/*
 * Copyright (c) 2017-2019 José Amuedo (https://github.com/spheras)
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

namespace DesktopFolder.Lang {
    // Application Description
    public const string APP_DESCRIPTION                          = _("Come back to life your minimalist Desktop \n Organize files at your Desktop using Panes.");
    // Generic Dialog OK Button
    public const string DIALOG_OK                                = _("_Ok");
    // Generic Dialog CANCEL Button
    public const string DIALOG_CANCEL                            = _("_Cancel");
    // Generic Dialog Select Button
    public const string DIALOG_SELECT                            = _("_Select");
    // Trying to paste and the clipboard is empty
    public const string CLIPBOARD_EMPTY                          = _("There is nothing on the clipboard to paste");
    // Dialog Error Title: Invalid Filename provided
    public const string CANT_DROP                                = _("Cannot drop this file");
    // Dialog Error Message while trying to drop
    public const string CANT_DROP_INVALID_FILE_NAME              = _("Invalid file name provided");
    // Title dialog for File Operations
    public const string DRAGNDROP_FILE_OPERATIONS                = _("File Operations");
    // Copying File message for progress dialog
    public const string DRAGNDROP_COPYING                        = _("Copying");
    // Drop Menu - Copy
    public const string DROP_MENU_COPY                           = _("Copy Here");
    // Drop Menu - Move
    public const string DROP_MENU_MOVE                           = _("Move Here");
    // Drop Menu - Link
    public const string DROP_MENU_LINK                           = _("Link Here");
    // Drop Menu - Cancel
    public const string DROP_MENU_CANCEL                         = _("Cancel");
    // desktopfolder menu - create a new Desktop-Folder Pane
    public const string DESKTOPFOLDER_MENU_NEW_DESKTOP_FOLDER    = _("Panel");
    // desktopfolder menu - create a new Desktop-Folder Pane
    public const string DESKTOPFOLDER_MENU_LINK_PANEL            = _("Link Panel");
    // desktopfolder menu - enable/disable alignment to grid
    public const string DESKTOPFOLDER_MENU_ALIGN_TO_GRID         = _("Align to Grid");
    // desktopfolder menu - enable/disable lock items
    public const string DESKTOPFOLDER_MENU_LOCK_ITEMS            = _("Lock Items");
    // desktopfolder menu - enable/disable lock panel
    public const string DESKTOPFOLDER_MENU_LOCK_PANEL            = _("Lock Panel");
    // desktopfolder menu - enable/disable text shadows
    public const string DESKTOPFOLDER_MENU_TEXT_SHADOW           = _("Text Shadow");
    // desktopfolder menu - enable/disable text bolds
    public const string DESKTOPFOLDER_MENU_TEXT_BOLD             = _("Text Bold");
    // desktopfolder menu - create a new Note
    public const string DESKTOPFOLDER_MENU_NEW_NOTE              = _("Note");
    // desktopfolder menu - create a new Folder
    public const string DESKTOPFOLDER_MENU_NEW_FOLDER            = _("Folder");
    // desktopfolder menu - create a new empty Text File
    public const string DESKTOPFOLDER_MENU_NEW_EMPTY_FILE        = _("Empty File");
    // desktopfolder menu - rename a Desktop-Folder Pane
    public const string DESKTOPFOLDER_MENU_RENAME_DESKTOP_FOLDER = _("Rename Panel");
    // desktopfolder menu - remove a Desktop-Folder Pane
    public const string DESKTOPFOLDER_MENU_REMOVE_DESKTOP_FOLDER = _("Move Panel to Trash");
    // desktopfolder menu - past from clipboard to the desktop-folder
    public const string DESKTOPFOLDER_MENU_PASTE                 = _("Paste");
    // desktopfolder - Dialog Title for a new Desktop Folder Panel to ask the new name
    public const string DESKTOPFOLDER_NEW                        = _("New Panel");
    // desktopfolder - Dialog Message to rename the current Desktop-Folder
    public const string DESKTOPFOLDER_RENAME_MESSAGE             = _("Enter the new name");
    // desktopfolder - Title for a Dialog Text to ask the new name for the Desktop-Folder
    public const string DESKTOPFOLDER_ENTER_TITLE                = _("New Panel");
    // desktopfolder - Dialog Text to ask the new name for the Desktop-Folder
    public const string DESKTOPFOLDER_ENTER_NAME                 = _("Enter the name");
    // desktopfolder - Title for Dialog to ask the new name for a folder inside a Desktop-Folder
    public const string DESKTOPFOLDER_NEW_FOLDER_TITLE           = _("New Folder");
    // desktopfolder - Dialog Text to ask the new name for a folder inside a Desktop-Folder
    public const string DESKTOPFOLDER_NEW_FOLDER_MESSAGE         = _("Enter the name");
    // desktopfolder - The default name for the new folder to be created
    public const string DESKTOPFOLDER_NEW_FOLDER_NAME            = _("new folder");
    // desktopfolder - Dialog Title to ask the new name for a text file inside a Desktop-Folder
    public const string DESKTOPFOLDER_NEW_TEXT_FILE_TITLE        = _("New Text File");
    // desktopfolder - Dialog Text to ask the new name for a text file inside a Desktop-Folder
    public const string DESKTOPFOLDER_NEW_TEXT_FILE_MESSAGE      = _("Enter the name");
    // desktopfolder - The default name for the new text file to be created
    public const string DESKTOPFOLDER_NEW_TEXT_FILE_NAME         = _("new.txt");
    // desktopfolder - The message to confirm the deletion of a Desktop Folder
    public const string DESKTOPFOLDER_DELETE_TOOLTIP             = _("Move to Trash");
    // desktopfolder - The message to confirm the deletion of a Desktop Folder
    public const string DESKTOPFOLDER_PROPERTIES_TOOLTIP         = _("Properties");
    // desktopfolder - Title for a Dialog Text to ask the new name for the Desktop-Folder
    public const string NOTE_ENTER_TITLE                         = _("New Note");
    // desktopfolder - Dialog Text to ask the new name for the Desktop-Folder
    public const string NOTE_ENTER_NAME                          = _("Enter the name");
    // desktopfolder - Dialog Title for a new Desktop Folder Panel to ask the new name
    public const string NOTE_NEW              = _("New Note");
    // Note - popup option to set the paper texture or not
    public const string NOTE_MENU_PAPER_NOTE  = _("Paper Texture");
    // Note - popup option to set allways on top or not
    public const string NOTE_MENU_ON_TOP      = _("Always on top");
    // Note - popup option to set allways on back or not
    public const string NOTE_MENU_ON_BACK     = _("Always on back");
    // Menu popup option to rename the note
    public const string NOTE_MENU_RENAME_NOTE = _("Rename Note");
    // Menu popup option to delete the note
    public const string NOTE_MENU_DELETE_NOTE = _("Move to Trash");
    // Note - Dialog Title Message to rename the current note
    public const string NOTE_RENAME_TITLE     = _("Rename Note");
    // Note - Dialog Message to rename the current note
    public const string NOTE_RENAME_MESSAGE   = _("Enter the new name");
    // Note - Dialog Message to DELETE the current note
    public const string NOTE_DELETE_MESSAGE   = _("This action will DELETE the Note.\n<b>Are you sure?</b>");

    // Item Menu - Open the file
    public const string ITEM_MENU_OPEN             = _("Open");
    // Item Menu - Execute the file
    public const string ITEM_MENU_EXECUTE          = _("Execute");
    // Item Menu - cut the file/folder
    public const string ITEM_MENU_CUT              = _("Cut");
    // Item Menu - copy the file/folder
    public const string ITEM_MENU_COPY             = _("Copy");
    // Item Menu - rename the file/folder
    public const string ITEM_MENU_RENAME           = _("Rename");
    // Item Menu - delete the file/folder
    public const string ITEM_MENU_DELETE           = _("Delete");
    // Item Menu - change icon
    public const string ITEM_MENU_CHANGEICON       = _("Change Icon");
    // Item - Delete Folder Item Dialog message
    public const string ITEM_DELETE_FOLDER_MESSAGE = _("This action will DELETE the folder and ALL its content.\n<b>Are you sure?</b>");
    // Item - Delete File Item Dialog message
    public const string ITEM_DELETE_FILE_MESSAGE   = _("This action will DELETE the file.\n<b>Are you sure?</b>");
    // Item - Delete File Link Dialog message
    public const string ITEM_DELETE_LINK_MESSAGE   = _("This action will DELETE the link (just the link).\n<b>Are you sure?</b>");
    // Item - Change icon dialog message to select an image file
    public const string ITEM_CHANGEICON_MESSAGE    = _("Select the image icon to be used.");
    // Item - Rename Dialog Title
    public const string ITEM_RENAME_TITLE          = _("Rename Item");
    // Item - Rename Dialog Message
    public const string ITEM_RENAME_MESSAGE        = _("Enter the new name");
    // Name of the first desktop-folder panel, when no panels found
    public const string APP_FIRST_PANEL            = _("My First Panel");
    // Hint to show desktop shortcut
    // public const string HINT_SHOW_DESKTOP=_("Press ⌘-D to Show Desktop");
    // Menu option to create a link to a file
    public const string DESKTOPFOLDER_MENU_NEW_FILE_LINK                = _("Link to File");
    // Menu option to create a link to a folder
    public const string DESKTOPFOLDER_MENU_NEW_FOLDER_LINK              = _("Link to Folder");
    // Dialog message to create a new link
    public const string DESKTOPFOLDER_LINK_MESSAGE                      = _("Select the destination file/folder of the link");
    // Dialog message to create a new link panel
    public const string DESKTOPFOLDER_PANELLINK_MESSAGE                 = _("Select the destination folder for the Panel");
    // Menu popup option to remove a photo
    public const string PHOTO_MENU_DELETE_PHOTO                         = _("Remove");
    // Note - Dialog Message to DELETE the current photo
    public const string PHOTO_DELETE_MESSAGE                            = _("This action will DELETE the Photo.\n<b>Are you sure?</b>");
    // desktopfolder menu - create a new Photo
    public const string DESKTOPFOLDER_MENU_NEW_PHOTO                    = _("Photo");
    // dialog message to select an image file to be shown at the desktop
    public const string PHOTO_SELECT_PHOTO_MESSAGE                      = _("Select the picture to show");
    // desktopfolder menu - create a new empty Text File
    public const string DESKTOPFOLDER_MENU_NEW_SUBMENU                  = _("New");
    // panel properties - Properties section
    public const string PANELPROPERTIES_PROPERTIES                      = _("Properties");
    // panel properties - General section
    public const string PANELPROPERTIES_GENERAL                         = _("General");
    // panel properties - Behavior section
    public const string PANELPROPERTIES_BEHAVIOR                        = _("Behavior");
    // panel properties - Interface section
    public const string PANELPROPERTIES_INTERFACE                       = _("Interface");
    // panel properties - Close button
    public const string PANELPROPERTIES_CLOSE                           = _("Close");
    // panel properties - Panel over Desktop title
    public const string PANELPROPERTIES_DESKTOP_PANEL                   = _("Panel Over Desktop");
    // panel properties - Panel over desktop description
    public const string PANELPROPERTIES_DESKTOP_PANEL_DESCRIPTION       = _("Activating this you will have a transparent background panel over your desktop. This change will require relogin into your system.");
    // panel properties - Resolution Strategy title
    public const string PANELPROPERTIES_RESOLUTION_STRATEGY             = _("Resolution Strategy");
    // panel properties - Resolution Strategy Description
    public const string PANELPROPERTIES_RESOLUTION_STRATEGY_DESCRIPTION = _("This is how all the widgets behave when a new screen resolution is found, doing nothing, storing and restoring the new resolution positions, or scaling the positions.");
    // panel properties - Resolution Strategy NONE
    public const string PANELPROPERTIES_RESOLUTION_STRATEGY_NONE        = _("None");
    // panel properties - Resolution Strategy NONE
    public const string PANELPROPERTIES_RESOLUTION_STRATEGY_SCALE       = _("Scale");
    // panel properties - Resolution Strategy NONE
    public const string PANELPROPERTIES_RESOLUTION_STRATEGY_STORE       = _("Store");
    // change desktop menu
    public const string DESKTOPFOLDER_MENU_CHANGEDESKTOP                = _("Change Wallpaper");
}
