package org.apache.maven.doxia.module.xdoc;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.io.Writer;
import java.util.Locale;

import org.apache.maven.doxia.sink.Sink;

/**
 * @author <a href="mailto:vincent.siveton@gmail.com">Vincent Siveton</a>
 * @version $Id: XdocSinkWithLanguageIdTest.java 739565 2009-01-31 14:39:03Z vsiveton $
 */
public class XdocSinkWithLanguageIdTest
    extends XdocSinkTest
{
    /** {@inheritDoc} */
    protected Sink createSink( Writer writer )
    {
        return new XdocSink( writer, "UTF-8", Locale.US.getLanguage() );
    }

    /** {@inheritDoc} */
    protected String getHeadBlock()
    {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
            + "<document xmlns=\"http://maven.apache.org/XDOC/2.0\" "
            + "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" "
            + "xsi:schemaLocation=\"http://maven.apache.org/XDOC/2.0 http://maven.apache.org/xsd/xdoc-2.0.xsd\" "
            + "lang=\"en\" xml:lang=\"en\">" + "<properties></properties>";
    }
}
