/*
 * Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <inttypes.h>

typedef float float32;
typedef double float64;
typedef long double float80;

/*
 * Exams
 */
extern int
float80_isneg(float80 f);
extern int
float80_iszero(float80 f);
extern int
float80_isnorm(float80 f);
extern int
float80_isdenorm(float80 f);
extern int
float80_isinf(float80 f);
extern int
float80_isnan(float80 f);

/*
 * Comparisons
 */
extern int
float80_isless(float80 a, float80 b);
extern int
float80_isunordered(float80 a, float80 b);

/*
 * Constants
 */
extern float80
float80_0(void);
extern float80
float80_1(void);
extern float80
float80_l2t(void);
extern float80
float80_l2e(void);
extern float80
float80_pi(void);
extern float80
float80_lg2(void);
extern float80
float80_ln2(void);

/*
 * Conversions
 */
extern float80
float80_from_i16(int16_t val);
extern int16_t
float80_to_i16(uint8_t rc, float80 val,
		uint8_t *pep, uint8_t *uep,
		uint8_t *oep, uint8_t *zep,
		uint8_t *dep, uint8_t *iep);
extern float80
float80_from_i32(int32_t val);
extern int32_t
float80_to_i32(uint8_t rc, float80 val,
		uint8_t *pep, uint8_t *uep,
		uint8_t *oep, uint8_t *zep,
		uint8_t *dep, uint8_t *iep);
extern float80
float80_from_i64(int64_t val);
extern int64_t
float80_to_i64(uint8_t rc, float80 val,
		uint8_t *pep, uint8_t *uep,
		uint8_t *oep, uint8_t *zep,
		uint8_t *dep, uint8_t *iep);
extern float80
float80_from_f32(float32 val);
extern float32
float80_to_f32(uint8_t rc, float80 val,
		uint8_t *pep, uint8_t *uep,
		uint8_t *oep, uint8_t *zep,
		uint8_t *dep, uint8_t *iep);
extern float80
float80_from_f64(float64 val);
extern float64
float80_to_f64(uint8_t rc, float80 val,
		uint8_t *pep, uint8_t *uep,
		uint8_t *oep, uint8_t *zep,
		uint8_t *dep, uint8_t *iep);
float80
float80_from_bcd(uint8_t *src);
extern void
float80_to_bcd(uint8_t *dst,
		uint8_t rc,
		float80 val,
		uint8_t *pep, uint8_t *uep,
		uint8_t *oep, uint8_t *zep,
		uint8_t *dep, uint8_t *iep);

/*
 * Unary Functions
 */
extern float80
float80_chs(int rc, int pc, float80 a,
		uint8_t *pep, uint8_t *uep,
		uint8_t *oep, uint8_t *zep,
		uint8_t *dep, uint8_t *iep);
extern float80
float80_abs(int rc, int pc, float80 a,
		uint8_t *pep, uint8_t *uep,
		uint8_t *oep, uint8_t *zep,
		uint8_t *dep, uint8_t *iep);
extern float80
float80_sqrt(int rc, int pc, float80 a,
		uint8_t *pep, uint8_t *uep,
		uint8_t *oep, uint8_t *zep,
		uint8_t *dep, uint8_t *iep);
extern float80
float80_tan(int rc, int pc, float80 a,
		uint8_t *pep, uint8_t *uep,
		uint8_t *oep, uint8_t *zep,
		uint8_t *dep, uint8_t *iep);
extern float80
float80_atan(int rc, int pc, float80 a, float80 b,
		uint8_t *pep, uint8_t *uep,
		uint8_t *oep, uint8_t *zep,
		uint8_t *dep, uint8_t *iep);
extern float80
float80_sin(int rc, int pc, float80 a,
		uint8_t *pep, uint8_t *uep,
		uint8_t *oep, uint8_t *zep,
		uint8_t *dep, uint8_t *iep);
extern float80
float80_cos(int rc, int pc, float80 a,
		uint8_t *pep, uint8_t *uep,
		uint8_t *oep, uint8_t *zep,
		uint8_t *dep, uint8_t *iep);
extern void
float80_sincos(int rc, int pc, float80 *res1p, float80 *res2p, float80 a,
		uint8_t *pep, uint8_t *uep,
		uint8_t *oep, uint8_t *zep,
		uint8_t *dep, uint8_t *iep);
extern float80
float80_2xm1(int rc, int pc, float80 a,
		uint8_t *pep, uint8_t *uep,
		uint8_t *oep, uint8_t *zep,
		uint8_t *dep, uint8_t *iep);
extern float80
float80_rndint(int rc, int pc, float80 a,
		uint8_t *pep, uint8_t *uep,
		uint8_t *oep, uint8_t *zep,
		uint8_t *dep, uint8_t *iep);

/*
 * Binary Functions
 */
extern float80
float80_scale(int rc, int pc, float80 a, float80 b,
		uint8_t *pep, uint8_t *uep,
		uint8_t *oep, uint8_t *zep,
		uint8_t *dep, uint8_t *iep);
extern float80
float80_fprem(int rc, int pc, float80 a, float80 b,
		uint8_t *pep, uint8_t *uep,
		uint8_t *oep, uint8_t *zep,
		uint8_t *dep, uint8_t *iep,
		uint8_t *c0, uint8_t *c1,
		uint8_t *c2, uint8_t *c3);
extern float80
float80_fprem1(int rc, int pc, float80 a, float80 b,
		uint8_t *pep, uint8_t *uep,
		uint8_t *oep, uint8_t *zep,
		uint8_t *dep, uint8_t *iep,
		uint8_t *c0, uint8_t *c1,
		uint8_t *c2, uint8_t *c3);
extern float80
float80_yl2x(int rc, int pc, float80 a, float80 b,
		uint8_t *pep, uint8_t *uep,
		uint8_t *oep, uint8_t *zep,
		uint8_t *dep, uint8_t *iep);
extern float80
float80_yl2xp1(int rc, int pc, float80 a, float80 b,
		uint8_t *pep, uint8_t *uep,
		uint8_t *oep, uint8_t *zep,
		uint8_t *dep, uint8_t *iep);
extern float80
float80_add(int rc, int pc, float80 a, float80 b,
		uint8_t *pep, uint8_t *uep,
		uint8_t *oep, uint8_t *zep,
		uint8_t *dep, uint8_t *iep);
extern float80
float80_sub(int rc, int pc, float80 a, float80 b,
		uint8_t *pep, uint8_t *uep,
		uint8_t *oep, uint8_t *zep,
		uint8_t *dep, uint8_t *iep);
extern float80
float80_mul(int rc, int pc, float80 a, float80 b,
		uint8_t *pep, uint8_t *uep,
		uint8_t *oep, uint8_t *zep,
		uint8_t *dep, uint8_t *iep);
extern float80
float80_div(int rc, int pc, float80 a, float80 b,
		uint8_t *pep, uint8_t *uep,
		uint8_t *oep, uint8_t *zep,
		uint8_t *dep, uint8_t *iep);
