/*
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __CMOS_H_INCLUDED
#define __CMOS_H_INCLUDED

#include "setup.h"
#include "segment.h"
#include "io.h"

#define RTC_UIP			0x80
#define RTC_DIV_CTL		0x70
#define RTC_CLCK_4MHZ		0x00
#define RTC_CLCK_1MHZ		0x10
#define RTC_CLCK_32KHZ		0x20
#define RTC_DIV_RESET1		0x60
#define RTC_DIV_RESET2		0x70
#define RTC_RATE_SELECT		0x0F

#define RTC_SET			0x80
#define RTC_PIE			0x40
#define RTC_AIE			0x20
#define RTC_UIE			0x10
#define RTC_SQWE		0x08
#define RTC_DM_BINARY		0x04
#define RTC_24H			0x02
#define RTC_DST_EN		0x01

#define RTC_IRQF		0x80
#define RTC_PF			0x40
#define RTC_AF			0x20
#define RTC_UF			0x10

#define RTC_VRT			0x80

#include "cmos_inc.h"

struct cmos_ext {
	uint8_t initialized;
	uint8_t apm;
	uint8_t pciirqs[4];
};

#define CMOS		((struct cmos *) 0)
#define CMOS_EXT	((struct cmos_ext *) 0)

static inline __attribute__((__always_inline__)) void
cmos_writeb(uint8_t reg, uint8_t val)
{
	outb(reg, 0x70);
	outb(val, 0x71);
}

static inline __attribute__((__always_inline__)) uint8_t
cmos_readb(uint8_t reg)
{
	uint8_t val;

	outb(reg, 0x70);
	val = inb(0x71);
	return val;
}

static inline __attribute__((__always_inline__)) void
cmos_writew(uint8_t reg, uint16_t val)
{
	outb(reg + 0, 0x70);
	outb((val >> 0) & 0xff, 0x71);
	outb(reg + 1, 0x70);
	outb((val >> 8) & 0xff, 0x71);
}

static inline __attribute__((__always_inline__)) uint16_t
cmos_readw(uint8_t reg)
{
	uint16_t val;

	outb(reg + 0, 0x70);
	val = inb(0x71) << 0;
	outb(reg + 1, 0x70);
	val |= inb(0x71) << 8;
	return val;
}

static inline __attribute__((__always_inline__)) void
cmos_ext_write(uint8_t reg, uint8_t val)
{
	outb(reg, 0x72);
	outb(val, 0x73);
}

static inline __attribute__((__always_inline__)) uint8_t
cmos_ext_read(uint8_t reg)
{
	outb(reg, 0x72);
	return inb(0x73);
}

#define cmos_put(var, value) \
	if (sizeof(CMOS->var) == 1) { \
		cmos_writeb((uint8_t) (uint32_t) &CMOS->var, value); \
	} else if (sizeof(CMOS->var) == 2) { \
		cmos_writew((uint8_t) (uint32_t) &CMOS->var, value); \
	} else { \
		assert(0); \
	}

#define cmos_get(var) \
	( \
		(sizeof(CMOS->var) == 1) ? \
			cmos_readb((uint8_t) (uint32_t) &CMOS->var) \
		: (sizeof(CMOS->var) == 2) ? \
			cmos_readw((uint8_t) (uint32_t) &CMOS->var) \
		: -1 \
	)

#define cmos_ext_put(var, value) \
	cmos_ext_write((uint8_t) (uint32_t) &CMOS_EXT->var, value)

#define cmos_ext_get(var) \
	cmos_ext_read((uint8_t) (uint32_t) &CMOS_EXT->var)

#ifdef INIT_RM

extern void
cmos_init(void);

#endif /* INIT_RM */

#endif /* __CMOS_H_INCLUDED */
