/* Scanner.c generated by valac 0.34.4, the Vala compiler
 * generated from Scanner.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <gee.h>
#include <cstuff.h>
#include <float.h>
#include <math.h>
#include <gst/mpegts/mpegts.h>


#define DVB_TYPE_ID_BUS_SCANNER (dvb_id_bus_scanner_get_type ())
#define DVB_ID_BUS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_SCANNER, DVBIDBusScanner))
#define DVB_IS_ID_BUS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_SCANNER))
#define DVB_ID_BUS_SCANNER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_SCANNER, DVBIDBusScannerIface))

typedef struct _DVBIDBusScanner DVBIDBusScanner;
typedef struct _DVBIDBusScannerIface DVBIDBusScannerIface;

#define DVB_TYPE_ID_BUS_SCANNER_PROXY (dvb_id_bus_scanner_proxy_get_type ())

#define DVB_TYPE_SCANNER (dvb_scanner_get_type ())
#define DVB_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNER, DVBScanner))
#define DVB_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNER, DVBScannerClass))
#define DVB_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNER))
#define DVB_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNER))
#define DVB_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNER, DVBScannerClass))

typedef struct _DVBScanner DVBScanner;
typedef struct _DVBScannerClass DVBScannerClass;
typedef struct _DVBScannerPrivate DVBScannerPrivate;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;

#define DVB_TYPE_ADAPTER_TYPE (dvb_adapter_type_get_type ())

#define DVB_TYPE_PARAMETER (dvb_parameter_get_type ())
#define DVB_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_PARAMETER, DVBParameter))
#define DVB_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_PARAMETER, DVBParameterClass))
#define DVB_IS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_PARAMETER))
#define DVB_IS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_PARAMETER))
#define DVB_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_PARAMETER, DVBParameterClass))

typedef struct _DVBParameter DVBParameter;
typedef struct _DVBParameterClass DVBParameterClass;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_queue_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_queue_free__g_object_unref0_ (var), NULL)))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_DVB_TPARAMETER (dvb_dvb_tparameter_get_type ())
#define DVB_DVB_TPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DVB_TPARAMETER, DVBDvbTParameter))
#define DVB_DVB_TPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DVB_TPARAMETER, DVBDvbTParameterClass))
#define DVB_IS_DVB_TPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DVB_TPARAMETER))
#define DVB_IS_DVB_TPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DVB_TPARAMETER))
#define DVB_DVB_TPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DVB_TPARAMETER, DVBDvbTParameterClass))

typedef struct _DVBDvbTParameter DVBDvbTParameter;
typedef struct _DVBDvbTParameterClass DVBDvbTParameterClass;

#define DVB_TYPE_DVB_CEUROPE_PARAMETER (dvb_dvb_ceurope_parameter_get_type ())
#define DVB_DVB_CEUROPE_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DVB_CEUROPE_PARAMETER, DVBDvbCEuropeParameter))
#define DVB_DVB_CEUROPE_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DVB_CEUROPE_PARAMETER, DVBDvbCEuropeParameterClass))
#define DVB_IS_DVB_CEUROPE_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DVB_CEUROPE_PARAMETER))
#define DVB_IS_DVB_CEUROPE_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DVB_CEUROPE_PARAMETER))
#define DVB_DVB_CEUROPE_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DVB_CEUROPE_PARAMETER, DVBDvbCEuropeParameterClass))

typedef struct _DVBDvbCEuropeParameter DVBDvbCEuropeParameter;
typedef struct _DVBDvbCEuropeParameterClass DVBDvbCEuropeParameterClass;

#define DVB_TYPE_DVB_SPARAMETER (dvb_dvb_sparameter_get_type ())
#define DVB_DVB_SPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DVB_SPARAMETER, DVBDvbSParameter))
#define DVB_DVB_SPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DVB_SPARAMETER, DVBDvbSParameterClass))
#define DVB_IS_DVB_SPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DVB_SPARAMETER))
#define DVB_IS_DVB_SPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DVB_SPARAMETER))
#define DVB_DVB_SPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DVB_SPARAMETER, DVBDvbSParameterClass))

typedef struct _DVBDvbSParameter DVBDvbSParameter;
typedef struct _DVBDvbSParameterClass DVBDvbSParameterClass;

#define DVB_IO_TYPE_CHANNEL_LIST_WRITER (dvb_io_channel_list_writer_get_type ())
#define DVB_IO_CHANNEL_LIST_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_IO_TYPE_CHANNEL_LIST_WRITER, DVBioChannelListWriter))
#define DVB_IO_CHANNEL_LIST_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_IO_TYPE_CHANNEL_LIST_WRITER, DVBioChannelListWriterClass))
#define DVB_IO_IS_CHANNEL_LIST_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_IO_TYPE_CHANNEL_LIST_WRITER))
#define DVB_IO_IS_CHANNEL_LIST_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_IO_TYPE_CHANNEL_LIST_WRITER))
#define DVB_IO_CHANNEL_LIST_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_IO_TYPE_CHANNEL_LIST_WRITER, DVBioChannelListWriterClass))

typedef struct _DVBioChannelListWriter DVBioChannelListWriter;
typedef struct _DVBioChannelListWriterClass DVBioChannelListWriterClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_IO_TYPE_SCANNING_LIST_READER (dvb_io_scanning_list_reader_get_type ())
#define DVB_IO_SCANNING_LIST_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_IO_TYPE_SCANNING_LIST_READER, DVBioScanningListReader))
#define DVB_IO_SCANNING_LIST_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_IO_TYPE_SCANNING_LIST_READER, DVBioScanningListReaderClass))
#define DVB_IO_IS_SCANNING_LIST_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_IO_TYPE_SCANNING_LIST_READER))
#define DVB_IO_IS_SCANNING_LIST_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_IO_TYPE_SCANNING_LIST_READER))
#define DVB_IO_SCANNING_LIST_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_IO_TYPE_SCANNING_LIST_READER, DVBioScanningListReaderClass))

typedef struct _DVBioScanningListReader DVBioScanningListReader;
typedef struct _DVBioScanningListReaderClass DVBioScanningListReaderClass;

#define DVB_TYPE_DVB_SRC_DELSYS (dvb_dvb_src_delsys_get_type ())
#define __vala_GstMpegtsPatProgram_free0(var) ((var == NULL) ? NULL : (var = (_vala_GstMpegtsPatProgram_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define __vala_GstMpegtsSDTService_free0(var) ((var == NULL) ? NULL : (var = (_vala_GstMpegtsSDTService_free (var), NULL)))
#define __vala_GstMpegtsDescriptor_free0(var) ((var == NULL) ? NULL : (var = (_vala_GstMpegtsDescriptor_free (var), NULL)))
#define __vala_GstMpegtsNITStream_free0(var) ((var == NULL) ? NULL : (var = (_vala_GstMpegtsNITStream_free (var), NULL)))
#define __vala_GstMpegtsPMTStream_free0(var) ((var == NULL) ? NULL : (var = (_vala_GstMpegtsPMTStream_free (var), NULL)))
#define __vala_GstMpegtsSection_free0(var) ((var == NULL) ? NULL : (var = (_vala_GstMpegtsSection_free (var), NULL)))

struct _DVBIDBusScannerIface {
	GTypeInterface parent_iface;
	void (*Run) (DVBIDBusScanner* self, GError** error);
	void (*Destroy) (DVBIDBusScanner* self, GError** error);
	gboolean (*WriteAllChannelsToFile) (DVBIDBusScanner* self, const gchar* path, GError** error);
	gboolean (*WriteChannelsToFile) (DVBIDBusScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error);
	gboolean (*AddScanningData) (DVBIDBusScanner* self, GHashTable* data, GError** error);
	gboolean (*AddScanningDataFromFile) (DVBIDBusScanner* self, const gchar* path, GError** error);
};

struct _DVBScanner {
	GObject parent_instance;
	DVBScannerPrivate * priv;
	DVBChannelList* channels;
	GstElement* pipeline;
};

struct _DVBScannerClass {
	GObjectClass parent_class;
};

typedef enum  {
	DVB_ADAPTER_TYPE_UNKNOWN,
	DVB_ADAPTER_TYPE_TERRESTRIAL,
	DVB_ADAPTER_TYPE_SATELLITE,
	DVB_ADAPTER_TYPE_CABLE
} DVBAdapterType;

struct _DVBScannerPrivate {
	DVBDevice* _Device;
	DVBAdapterType _Type;
	GRecMutex __lock_channels;
	GQueue* queue_scanning_params;
	DVBParameter* current_scanning_param;
	GeeHashSet* scanned_scanning_params;
	GeeArrayList* new_channels;
	GRecMutex __lock_new_channels;
	GSource* check_for_lock_source;
	GSource* wait_for_tables_source;
	GSource* start_scan_source;
	gboolean nit_arrived;
	gboolean sdt_arrived;
	gboolean pat_arrived;
	gboolean pmt_arrived;
	gboolean locked;
	GMainContext* context;
	GMainLoop* loop;
	GThread* worker_thread;
	gboolean running;
	guint bus_watch_id;
};

typedef enum  {
	DVB_DVB_SRC_DELSYS_SYS_UNDEFINED,
	DVB_DVB_SRC_DELSYS_SYS_DVBC_ANNEX_A,
	DVB_DVB_SRC_DELSYS_SYS_DVBC_ANNEX_B,
	DVB_DVB_SRC_DELSYS_SYS_DVBT,
	DVB_DVB_SRC_DELSYS_SYS_DSS,
	DVB_DVB_SRC_DELSYS_SYS_DVBS,
	DVB_DVB_SRC_DELSYS_SYS_DVBS2,
	DVB_DVB_SRC_DELSYS_SYS_DVBH,
	DVB_DVB_SRC_DELSYS_SYS_ISDBT,
	DVB_DVB_SRC_DELSYS_SYS_ISDBS,
	DVB_DVB_SRC_DELSYS_SYS_ISDBC,
	DVB_DVB_SRC_DELSYS_SYS_ATSC,
	DVB_DVB_SRC_DELSYS_SYS_ATSCMH,
	DVB_DVB_SRC_DELSYS_SYS_DTMB,
	DVB_DVB_SRC_DELSYS_SYS_CMMB,
	DVB_DVB_SRC_DELSYS_SYS_DAB,
	DVB_DVB_SRC_DELSYS_SYS_DVBT2,
	DVB_DVB_SRC_DELSYS_SYS_TURBO,
	DVB_DVB_SRC_DELSYS_SYS_DVBC_ANNEX_C
} DVBDvbSrcDelsys;


static gpointer dvb_scanner_parent_class = NULL;
static DVBLoggingLogger* dvb_scanner_log;
static DVBLoggingLogger* dvb_scanner_log = NULL;
static DVBIDBusScannerIface* dvb_scanner_dvb_id_bus_scanner_parent_iface = NULL;

GType dvb_id_bus_scanner_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_scanner_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_id_bus_scanner_get_type (void) G_GNUC_CONST;
GType dvb_scanner_get_type (void) G_GNUC_CONST;
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
GType dvb_device_get_type (void) G_GNUC_CONST;
GType dvb_adapter_type_get_type (void) G_GNUC_CONST;
GType dvb_parameter_get_type (void) G_GNUC_CONST;
#define DVB_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_SCANNER, DVBScannerPrivate))
enum  {
	DVB_SCANNER_DUMMY_PROPERTY,
	DVB_SCANNER_DEVICE,
	DVB_SCANNER_CHANNELS,
	DVB_SCANNER_TYPE
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
static void _g_object_unref0_ (gpointer var);
static void _g_queue_free__g_object_unref0_ (GQueue* self);
#define DVB_SCANNER_BASE_PIDS "16:17"
#define DVB_SCANNER_PIPELINE_TEMPLATE "dvbsrc name=dvbsrc adapter=%u frontend=%u stats-reporting-interval=100" \
" ! tsparse ! fakesink silent=true"
DVBScanner* dvb_scanner_new (DVBDevice* device, DVBAdapterType type);
DVBScanner* dvb_scanner_construct (GType object_type, DVBDevice* device, DVBAdapterType type);
static void dvb_scanner_real_Run (DVBIDBusScanner* base, GError** error);
static void* dvb_scanner_worker (DVBScanner* self);
static gpointer _dvb_scanner_worker_gthread_func (gpointer self);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
DVBChannelList* dvb_channel_list_new (GFile* channels);
DVBChannelList* dvb_channel_list_construct (GType object_type, GFile* channels);
DVBDevice* dvb_scanner_get_Device (DVBScanner* self);
guint dvb_device_get_Adapter (DVBDevice* self);
guint dvb_device_get_Frontend (DVBDevice* self);
gboolean dvb_scanner_bus_watch_func (DVBScanner* self, GstBus* bus, GstMessage* message);
static gboolean _dvb_scanner_bus_watch_func_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
void dvb_scanner_queue_start_scan (DVBScanner* self);
static void dvb_scanner_real_Destroy (DVBIDBusScanner* base, GError** error);
void dvb_scanner_do_destroy (DVBScanner* self);
void dvb_scanner_destroy_start_scan_source (DVBScanner* self);
void dvb_scanner_remove_check_for_lock_timeout (DVBScanner* self);
void dvb_scanner_remove_wait_for_tables_timeout (DVBScanner* self);
void dvb_scanner_clear_and_reset_all (DVBScanner* self);
void dvb_channel_list_clear (DVBChannelList* self);
static gboolean dvb_scanner_real_AddScanningData (DVBIDBusScanner* base, GHashTable* data, GError** error);
GType dvb_dvb_tparameter_get_type (void) G_GNUC_CONST;
DVBDvbTParameter* dvb_dvb_tparameter_new (void);
DVBDvbTParameter* dvb_dvb_tparameter_construct (GType object_type);
gboolean dvb_parameter_add_scanning_data (DVBParameter* self, GHashTable* data);
void dvb_scanner_add_to_queue (DVBScanner* self, DVBParameter* param);
GType dvb_dvb_ceurope_parameter_get_type (void) G_GNUC_CONST;
DVBDvbCEuropeParameter* dvb_dvb_ceurope_parameter_new (void);
DVBDvbCEuropeParameter* dvb_dvb_ceurope_parameter_construct (GType object_type);
GType dvb_dvb_sparameter_get_type (void) G_GNUC_CONST;
DVBDvbSParameter* dvb_dvb_sparameter_new (void);
DVBDvbSParameter* dvb_dvb_sparameter_construct (GType object_type);
static gboolean dvb_scanner_real_WriteAllChannelsToFile (DVBIDBusScanner* base, const gchar* path, GError** error);
GType dvb_io_channel_list_writer_get_type (void) G_GNUC_CONST;
DVBioChannelListWriter* dvb_io_channel_list_writer_new (GFile* file);
DVBioChannelListWriter* dvb_io_channel_list_writer_construct (GType object_type, GFile* file);
GType dvb_channel_get_type (void) G_GNUC_CONST;
void dvb_io_channel_list_writer_write (DVBioChannelListWriter* self, DVBChannel* channel, GError** error);
gboolean dvb_io_channel_list_writer_close (DVBioChannelListWriter* self, GError** error);
static gboolean dvb_scanner_real_WriteChannelsToFile (DVBIDBusScanner* base, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error);
DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid);
void dvb_logging_logger_warning (DVBLoggingLogger* self, const gchar* format, ...);
static gboolean dvb_scanner_real_AddScanningDataFromFile (DVBIDBusScanner* base, const gchar* path, GError** error);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
gboolean dvb_utils_is_readable_file (GFile* file);
GType dvb_io_scanning_list_reader_get_type (void) G_GNUC_CONST;
DVBioScanningListReader* dvb_io_scanning_list_reader_new (const gchar* keyfile);
DVBioScanningListReader* dvb_io_scanning_list_reader_construct (GType object_type, const gchar* keyfile);
void dvb_io_scanning_list_reader_read_data (DVBioScanningListReader* self, GError** error);
GList* dvb_io_scanning_list_reader_get_Parameters (DVBioScanningListReader* self);
void dvb_scanner_clear_queue (DVBScanner* self);
GType dvb_dvb_src_delsys_get_type (void) G_GNUC_CONST;
gboolean dvb_isSupported (DVBDvbSrcDelsys delsys, DVBAdapterType type);
DVBDvbSrcDelsys dvb_parameter_get_Delsys (DVBParameter* self);
DVBAdapterType dvb_scanner_get_Type (DVBScanner* self);
gboolean dvb_parameter_equal (DVBParameter* self, DVBParameter* param);
guint dvb_parameter_get_Frequency (DVBParameter* self);
gboolean dvb_scanner_start_scan (DVBScanner* self);
void dvb_channel_list_remove (DVBChannelList* self, guint sid);
void dvb_parameter_prepare (DVBParameter* self, GstElement* source);
gboolean dvb_scanner_check_for_lock (DVBScanner* self);
static gboolean _dvb_scanner_check_for_lock_gsource_func (gpointer self);
gboolean dvb_scanner_wait_for_tables (DVBScanner* self);
static gboolean _dvb_scanner_start_scan_gsource_func (gpointer self);
void dvb_scanner_set_uint_property (GstElement* src, GstStructure* params, const gchar* key);
void dvb_scanner_on_dvb_frontend_stats_structure (DVBScanner* self, GstStructure* structure);
static gboolean _dvb_scanner_wait_for_tables_gsource_func (gpointer self);
void dvb_scanner_on_dvb_read_failure_structure (DVBScanner* self);
void dvb_scanner_on_pat_structure (DVBScanner* self, GstMpegtsSection* section);
static GstMpegtsPatProgram* _vala_GstMpegtsPatProgram_copy (GstMpegtsPatProgram* self);
static void _vala_GstMpegtsPatProgram_free (GstMpegtsPatProgram* self);
void dvb_scanner_on_sdt_structure (DVBScanner* self, GstMpegtsSection* section);
static GstMpegtsSDTService* _vala_GstMpegtsSDTService_copy (GstMpegtsSDTService* self);
static void _vala_GstMpegtsSDTService_free (GstMpegtsSDTService* self);
gboolean dvb_channel_list_contains (DVBChannelList* self, guint sid);
static void dvb_scanner_add_new_channel (DVBScanner* self, guint sid);
void dvb_channel_set_Scrambled (DVBChannel* self, gboolean value);
void dvb_channel_set_TransportStreamId (DVBChannel* self, guint value);
static GstMpegtsDescriptor* _vala_GstMpegtsDescriptor_copy (GstMpegtsDescriptor* self);
static void _vala_GstMpegtsDescriptor_free (GstMpegtsDescriptor* self);
void dvb_channel_set_Name (DVBChannel* self, const gchar* value);
void dvb_channel_set_Network (DVBChannel* self, const gchar* value);
void dvb_channel_set_ServiceType (DVBChannel* self, GstMpegtsDVBServiceType value);
const gchar* dvb_channel_get_Name (DVBChannel* self);
gboolean dvb_channel_get_Scrambled (DVBChannel* self);
void dvb_scanner_on_nit_structure (DVBScanner* self, GstMpegtsSection* section);
static GstMpegtsNITStream* _vala_GstMpegtsNITStream_copy (GstMpegtsNITStream* self);
static void _vala_GstMpegtsNITStream_free (GstMpegtsNITStream* self);
DVBDvbTParameter* dvb_dvb_tparameter_new_with_parameter (guint frequency, guint bandwidth, GstMpegtsTerrestrialGuardInterval interval, GstMpegtsTerrestrialTransmissionMode transmission, GstMpegtsTerrestrialHierarchy hierarchy, GstMpegtsModulationType constellation, GstMpegtsDVBCodeRate code_rate_lp, GstMpegtsDVBCodeRate code_rate_hp);
DVBDvbTParameter* dvb_dvb_tparameter_construct_with_parameter (GType object_type, guint frequency, guint bandwidth, GstMpegtsTerrestrialGuardInterval interval, GstMpegtsTerrestrialTransmissionMode transmission, GstMpegtsTerrestrialHierarchy hierarchy, GstMpegtsModulationType constellation, GstMpegtsDVBCodeRate code_rate_lp, GstMpegtsDVBCodeRate code_rate_hp);
DVBParameter* dvb_channel_get_Param (DVBChannel* self);
void dvb_channel_set_Param (DVBChannel* self, DVBParameter* value);
DVBDvbCEuropeParameter* dvb_dvb_ceurope_parameter_new_with_parameter (guint frequency, guint symbol_rate, GstMpegtsModulationType modulation, GstMpegtsDVBCodeRate inner_fec);
DVBDvbCEuropeParameter* dvb_dvb_ceurope_parameter_construct_with_parameter (GType object_type, guint frequency, guint symbol_rate, GstMpegtsModulationType modulation, GstMpegtsDVBCodeRate inner_fec);
DVBDvbSParameter* dvb_dvb_sparameter_new_with_parameter (guint frequency, guint symbol_rate, gfloat position, GstMpegtsSatellitePolarizationType polarization, GstMpegtsDVBCodeRate inner_fec);
DVBDvbSParameter* dvb_dvb_sparameter_construct_with_parameter (GType object_type, guint frequency, guint symbol_rate, gfloat position, GstMpegtsSatellitePolarizationType polarization, GstMpegtsDVBCodeRate inner_fec);
void dvb_scanner_on_pmt_structure (DVBScanner* self, GstMpegtsSection* section);
static GstMpegtsPMTStream* _vala_GstMpegtsPMTStream_copy (GstMpegtsPMTStream* self);
static void _vala_GstMpegtsPMTStream_free (GstMpegtsPMTStream* self);
void dvb_channel_set_VideoPID (DVBChannel* self, guint value);
GeeList* dvb_channel_get_AudioPIDs (DVBChannel* self);
static void _vala_GstMpegtsSection_free (GstMpegtsSection* self);
gboolean dvb_channel_is_valid (DVBChannel* self);
gboolean dvb_channel_is_radio (DVBChannel* self);
const gchar* dvb_channel_get_Network (DVBChannel* self);
gchar* dvb_channel_to_string (DVBChannel* self);
DVBChannel* dvb_channel_new_without_schedule (void);
DVBChannel* dvb_channel_construct_without_schedule (GType object_type);
void dvb_channel_set_Sid (DVBChannel* self, guint value);
void dvb_channel_list_add (DVBChannelList* self, DVBChannel* channel);
static void dvb_scanner_set_Device (DVBScanner* self, DVBDevice* value);
DVBChannelList* dvb_scanner_get_Channels (DVBScanner* self);
static void dvb_scanner_set_Type (DVBScanner* self, DVBAdapterType value);
static GObject * dvb_scanner_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void dvb_scanner_finalize (GObject* obj);
static void _vala_dvb_scanner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_scanner_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_queue_free__g_object_unref0_ (GQueue* self) {
	g_queue_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_queue_free (self);
}


DVBScanner* dvb_scanner_construct (GType object_type, DVBDevice* device, DVBAdapterType type) {
	DVBScanner * self = NULL;
	DVBDevice* _tmp0_ = NULL;
	DVBAdapterType _tmp1_ = 0;
	g_return_val_if_fail (device != NULL, NULL);
	_tmp0_ = device;
	_tmp1_ = type;
	self = (DVBScanner*) g_object_new (object_type, "Device", _tmp0_, "Type", _tmp1_, NULL);
	return self;
}


DVBScanner* dvb_scanner_new (DVBDevice* device, DVBAdapterType type) {
	return dvb_scanner_construct (DVB_TYPE_SCANNER, device, type);
}


/**
         * Start the scanner
         */
static gpointer _dvb_scanner_worker_gthread_func (gpointer self) {
	gpointer result;
	result = dvb_scanner_worker ((DVBScanner*) self);
	g_object_unref (self);
	return result;
}


static gboolean _dvb_scanner_bus_watch_func_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
	gboolean result;
	result = dvb_scanner_bus_watch_func ((DVBScanner*) self, bus, message);
	return result;
}


static void dvb_scanner_real_Run (DVBIDBusScanner* base, GError** error) {
	DVBScanner * self;
	gboolean _tmp0_ = FALSE;
	GMainContext* _tmp1_ = NULL;
	GMainLoop* _tmp2_ = NULL;
	DVBChannelList* _tmp9_ = NULL;
	GstBus* bus = NULL;
	GstElement* _tmp25_ = NULL;
	GstBus* _tmp26_ = NULL;
	GstBus* _tmp27_ = NULL;
	GMainContext* _tmp28_ = NULL;
	guint _tmp29_ = 0U;
	GstElement* _tmp30_ = NULL;
	GError * _inner_error_ = NULL;
	self = (DVBScanner*) base;
	_tmp0_ = self->priv->running;
	if (_tmp0_) {
		return;
	}
	self->priv->running = TRUE;
	_tmp1_ = self->priv->context;
	_tmp2_ = g_main_loop_new (_tmp1_, FALSE);
	_g_main_loop_unref0 (self->priv->loop);
	self->priv->loop = _tmp2_;
	{
		GThread* _tmp3_ = NULL;
		GThread* _tmp4_ = NULL;
		GThread* _tmp5_ = NULL;
		_tmp4_ = g_thread_try_new ("Scanner-Worker-Thread", _dvb_scanner_worker_gthread_func, g_object_ref (self), &_inner_error_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch152_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_thread_unref0 (self->priv->worker_thread);
		self->priv->worker_thread = _tmp5_;
		_g_thread_unref0 (_tmp3_);
	}
	goto __finally152;
	__catch152_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = dvb_scanner_log;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		dvb_logging_logger_error (_tmp6_, "Scanner.vala:116: Could not create thread: %s", _tmp8_);
		_g_error_free0 (e);
		return;
	}
	__finally152:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp9_ = dvb_channel_list_new (NULL);
	_g_object_unref0 (self->channels);
	self->channels = _tmp9_;
	{
		GstElement* _tmp10_ = NULL;
		DVBDevice* _tmp11_ = NULL;
		guint _tmp12_ = 0U;
		guint _tmp13_ = 0U;
		DVBDevice* _tmp14_ = NULL;
		guint _tmp15_ = 0U;
		guint _tmp16_ = 0U;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		GstElement* _tmp19_ = NULL;
		GstElement* _tmp20_ = NULL;
		GstElement* _tmp21_ = NULL;
		_tmp11_ = self->priv->_Device;
		_tmp12_ = dvb_device_get_Adapter (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = self->priv->_Device;
		_tmp15_ = dvb_device_get_Frontend (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strdup_printf (DVB_SCANNER_PIPELINE_TEMPLATE, _tmp13_, _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = gst_parse_launch_full (_tmp18_, NULL, GST_PARSE_FLAG_NONE, &_inner_error_);
		g_object_ref_sink (_tmp19_);
		_tmp20_ = _tmp19_;
		_g_free0 (_tmp18_);
		_tmp10_ = _tmp20_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch153_g_error;
		}
		_tmp21_ = _tmp10_;
		_tmp10_ = NULL;
		g_object_ref_sink (_tmp21_);
		_g_object_unref0 (self->pipeline);
		self->pipeline = _tmp21_;
		_g_object_unref0 (_tmp10_);
	}
	goto __finally153;
	__catch153_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp22_ = NULL;
		GError* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = dvb_scanner_log;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		dvb_logging_logger_error (_tmp22_, "Scanner.vala:127: Could not create pipeline: %s", _tmp24_);
		_g_error_free0 (e);
		return;
	}
	__finally153:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp25_ = self->pipeline;
	_tmp26_ = gst_element_get_bus (_tmp25_);
	bus = _tmp26_;
	_tmp27_ = bus;
	_tmp28_ = self->priv->context;
	_tmp29_ = gst_bus_add_watch_context (_tmp27_, _dvb_scanner_bus_watch_func_gst_bus_func, self, _tmp28_);
	self->priv->bus_watch_id = _tmp29_;
	_tmp30_ = self->pipeline;
	gst_element_set_state (_tmp30_, GST_STATE_READY);
	dvb_scanner_queue_start_scan (self);
	_g_object_unref0 (bus);
}


/**
         * Abort scanning and cleanup
         */
static void dvb_scanner_real_Destroy (DVBIDBusScanner* base, GError** error) {
	DVBScanner * self;
	self = (DVBScanner*) base;
	dvb_scanner_do_destroy (self);
}


static gpointer _g_thread_ref0 (gpointer self) {
	return self ? g_thread_ref (self) : NULL;
}


void dvb_scanner_do_destroy (DVBScanner* self) {
	DVBChannelList* _tmp0_ = NULL;
	GMainLoop* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	dvb_scanner_destroy_start_scan_source (self);
	dvb_scanner_remove_check_for_lock_timeout (self);
	dvb_scanner_remove_wait_for_tables_timeout (self);
	dvb_scanner_clear_and_reset_all (self);
	_tmp0_ = self->channels;
	dvb_channel_list_clear (_tmp0_);
	_g_object_unref0 (self->channels);
	self->channels = NULL;
	_tmp1_ = self->priv->loop;
	if (_tmp1_ != NULL) {
		GMainLoop* _tmp2_ = NULL;
		GThread* _tmp3_ = NULL;
		GThread* _tmp4_ = NULL;
		_tmp2_ = self->priv->loop;
		g_main_loop_quit (_tmp2_);
		_g_main_loop_unref0 (self->priv->loop);
		self->priv->loop = NULL;
		_tmp3_ = self->priv->worker_thread;
		_tmp4_ = _g_thread_ref0 (_tmp3_);
		g_thread_join (_tmp4_);
		_g_thread_unref0 (self->priv->worker_thread);
		self->priv->worker_thread = NULL;
	}
	g_signal_emit_by_name (self, "destroyed");
}


/**
         * @data: all scanning parameter
         *
         * in progress
         */
static gboolean dvb_scanner_real_AddScanningData (DVBIDBusScanner* base, GHashTable* data, GError** error) {
	DVBScanner * self;
	gboolean result = FALSE;
	GVariant* _var = NULL;
	GHashTable* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	self = (DVBScanner*) base;
	g_return_val_if_fail (data != NULL, FALSE);
	_tmp0_ = data;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "delsys");
	_var = (GVariant*) _tmp1_;
	_tmp2_ = _var;
	if (_tmp2_ != NULL) {
		GVariant* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GQuark _tmp7_ = 0U;
		static GQuark _tmp6_label0 = 0;
		static GQuark _tmp6_label1 = 0;
		static GQuark _tmp6_label2 = 0;
		_tmp3_ = _var;
		_tmp4_ = g_variant_get_string (_tmp3_, NULL);
		_tmp5_ = _tmp4_;
		_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
		if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("DVBT")))) {
			switch (0) {
				default:
				{
					DVBDvbTParameter* param = NULL;
					DVBDvbTParameter* _tmp8_ = NULL;
					DVBDvbTParameter* _tmp9_ = NULL;
					GHashTable* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
					_tmp8_ = dvb_dvb_tparameter_new ();
					param = _tmp8_;
					_tmp9_ = param;
					_tmp10_ = data;
					_tmp11_ = dvb_parameter_add_scanning_data ((DVBParameter*) _tmp9_, _tmp10_);
					if (_tmp11_) {
						DVBDvbTParameter* _tmp12_ = NULL;
						_tmp12_ = param;
						dvb_scanner_add_to_queue (self, (DVBParameter*) _tmp12_);
						result = TRUE;
						_g_object_unref0 (param);
						return result;
					}
					_g_object_unref0 (param);
					break;
				}
			}
		} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("DVBC/ANNEX_A")))) {
			switch (0) {
				default:
				{
					DVBDvbCEuropeParameter* param = NULL;
					DVBDvbCEuropeParameter* _tmp13_ = NULL;
					DVBDvbCEuropeParameter* _tmp14_ = NULL;
					GHashTable* _tmp15_ = NULL;
					gboolean _tmp16_ = FALSE;
					_tmp13_ = dvb_dvb_ceurope_parameter_new ();
					param = _tmp13_;
					_tmp14_ = param;
					_tmp15_ = data;
					_tmp16_ = dvb_parameter_add_scanning_data ((DVBParameter*) _tmp14_, _tmp15_);
					if (_tmp16_) {
						DVBDvbCEuropeParameter* _tmp17_ = NULL;
						_tmp17_ = param;
						dvb_scanner_add_to_queue (self, (DVBParameter*) _tmp17_);
						result = TRUE;
						_g_object_unref0 (param);
						return result;
					}
					_g_object_unref0 (param);
					break;
				}
			}
		} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("DVBS")))) {
			switch (0) {
				default:
				{
					DVBDvbSParameter* param = NULL;
					DVBDvbSParameter* _tmp18_ = NULL;
					DVBDvbSParameter* _tmp19_ = NULL;
					GHashTable* _tmp20_ = NULL;
					gboolean _tmp21_ = FALSE;
					_tmp18_ = dvb_dvb_sparameter_new ();
					param = _tmp18_;
					_tmp19_ = param;
					_tmp20_ = data;
					_tmp21_ = dvb_parameter_add_scanning_data ((DVBParameter*) _tmp19_, _tmp20_);
					if (_tmp21_) {
						DVBDvbSParameter* _tmp22_ = NULL;
						_tmp22_ = param;
						dvb_scanner_add_to_queue (self, (DVBParameter*) _tmp22_);
						result = TRUE;
						_g_object_unref0 (param);
						return result;
					}
					_g_object_unref0 (param);
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					break;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


/**
         * @path: Location where the file will be stored
         *
         * Write all the channels stored in this.Channels to file
         */
static gboolean dvb_scanner_real_WriteAllChannelsToFile (DVBIDBusScanner* base, const gchar* path, GError** error) {
	DVBScanner * self;
	gboolean result = FALSE;
	gboolean success = FALSE;
	DVBioChannelListWriter* writer = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	DVBioChannelListWriter* _tmp3_ = NULL;
	DVBioChannelListWriter* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	self = (DVBScanner*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	success = TRUE;
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = dvb_io_channel_list_writer_new (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	writer = _tmp4_;
	{
		GeeIterator* _c_it = NULL;
		DVBChannelList* _tmp5_ = NULL;
		GeeIterator* _tmp6_ = NULL;
		_tmp5_ = self->channels;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_c_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			DVBChannel* c = NULL;
			GeeIterator* _tmp9_ = NULL;
			gpointer _tmp10_ = NULL;
			_tmp7_ = _c_it;
			_tmp8_ = gee_iterator_next (_tmp7_);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = _c_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			c = (DVBChannel*) _tmp10_;
			{
				DVBioChannelListWriter* _tmp11_ = NULL;
				DVBChannel* _tmp12_ = NULL;
				_tmp11_ = writer;
				_tmp12_ = c;
				dvb_io_channel_list_writer_write (_tmp11_, _tmp12_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch154_g_error;
				}
			}
			goto __finally154;
			__catch154_g_error:
			{
				GError* e = NULL;
				DVBLoggingLogger* _tmp13_ = NULL;
				GError* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp13_ = dvb_scanner_log;
				_tmp14_ = e;
				_tmp15_ = _tmp14_->message;
				dvb_logging_logger_error (_tmp13_, "Scanner.vala:213: Could not write to file: %s", _tmp15_);
				success = FALSE;
				_g_error_free0 (e);
			}
			__finally154:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_DBUS_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (c);
					_g_object_unref0 (_c_it);
					_g_object_unref0 (writer);
					return FALSE;
				} else {
					_g_object_unref0 (c);
					_g_object_unref0 (_c_it);
					_g_object_unref0 (writer);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			_g_object_unref0 (c);
		}
		_g_object_unref0 (_c_it);
	}
	{
		DVBioChannelListWriter* _tmp16_ = NULL;
		_tmp16_ = writer;
		dvb_io_channel_list_writer_close (_tmp16_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch155_g_error;
		}
	}
	goto __finally155;
	__catch155_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp17_ = NULL;
		GError* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = dvb_scanner_log;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		dvb_logging_logger_error (_tmp17_, "Scanner.vala:221: Could not close file handle: %s", _tmp19_);
		success = FALSE;
		_g_error_free0 (e);
	}
	__finally155:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (writer);
			return FALSE;
		} else {
			_g_object_unref0 (writer);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = success;
	_g_object_unref0 (writer);
	return result;
}


/**
         * @channel_sids: A list of channels' SIDs
         * @path: Location where the file will be stored
         *
         * Write the channels with the given SIDs to file @path
         */
static gboolean dvb_scanner_real_WriteChannelsToFile (DVBIDBusScanner* base, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error) {
	DVBScanner * self;
	gboolean result = FALSE;
	gboolean success = FALSE;
	DVBioChannelListWriter* writer = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	DVBioChannelListWriter* _tmp3_ = NULL;
	DVBioChannelListWriter* _tmp4_ = NULL;
	guint* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	GError * _inner_error_ = NULL;
	self = (DVBScanner*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	success = TRUE;
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = dvb_io_channel_list_writer_new (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	writer = _tmp4_;
	_tmp5_ = channel_sids;
	_tmp5__length1 = channel_sids_length1;
	{
		guint* sid_collection = NULL;
		gint sid_collection_length1 = 0;
		gint _sid_collection_size_ = 0;
		gint sid_it = 0;
		sid_collection = _tmp5_;
		sid_collection_length1 = _tmp5__length1;
		for (sid_it = 0; sid_it < _tmp5__length1; sid_it = sid_it + 1) {
			guint sid = 0U;
			sid = sid_collection[sid_it];
			{
				DVBChannel* c = NULL;
				DVBChannelList* _tmp6_ = NULL;
				guint _tmp7_ = 0U;
				DVBChannel* _tmp8_ = NULL;
				DVBChannel* _tmp9_ = NULL;
				_tmp6_ = self->channels;
				_tmp7_ = sid;
				_tmp8_ = dvb_channel_list_get_channel (_tmp6_, _tmp7_);
				c = _tmp8_;
				_tmp9_ = c;
				if (_tmp9_ == NULL) {
					DVBLoggingLogger* _tmp10_ = NULL;
					guint _tmp11_ = 0U;
					_tmp10_ = dvb_scanner_log;
					_tmp11_ = sid;
					dvb_logging_logger_warning (_tmp10_, "Scanner.vala:242: Channel with SID 0x%x does not exist", _tmp11_);
					_g_object_unref0 (c);
					continue;
				}
				{
					DVBioChannelListWriter* _tmp12_ = NULL;
					DVBChannel* _tmp13_ = NULL;
					_tmp12_ = writer;
					_tmp13_ = c;
					dvb_io_channel_list_writer_write (_tmp12_, _tmp13_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch156_g_error;
					}
				}
				goto __finally156;
				__catch156_g_error:
				{
					GError* e = NULL;
					DVBLoggingLogger* _tmp14_ = NULL;
					GError* _tmp15_ = NULL;
					const gchar* _tmp16_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp14_ = dvb_scanner_log;
					_tmp15_ = e;
					_tmp16_ = _tmp15_->message;
					dvb_logging_logger_error (_tmp14_, "Scanner.vala:248: Could not write to file: %s", _tmp16_);
					success = FALSE;
					_g_error_free0 (e);
				}
				__finally156:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == G_DBUS_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (c);
						_g_object_unref0 (writer);
						return FALSE;
					} else {
						_g_object_unref0 (c);
						_g_object_unref0 (writer);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
				_g_object_unref0 (c);
			}
		}
	}
	{
		DVBioChannelListWriter* _tmp17_ = NULL;
		_tmp17_ = writer;
		dvb_io_channel_list_writer_close (_tmp17_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch157_g_error;
		}
	}
	goto __finally157;
	__catch157_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp18_ = NULL;
		GError* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = dvb_scanner_log;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		dvb_logging_logger_error (_tmp18_, "Scanner.vala:256: Could not close file handle: %s", _tmp20_);
		success = FALSE;
		_g_error_free0 (e);
	}
	__finally157:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (writer);
			return FALSE;
		} else {
			_g_object_unref0 (writer);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = success;
	_g_object_unref0 (writer);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean dvb_scanner_real_AddScanningDataFromFile (DVBIDBusScanner* base, const gchar* path, GError** error) {
	DVBScanner * self;
	gboolean result = FALSE;
	GFile* datafile = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	DVBLoggingLogger* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	DVBioScanningListReader* reader = NULL;
	const gchar* _tmp6_ = NULL;
	DVBioScanningListReader* _tmp7_ = NULL;
	GList* scanning_params = NULL;
	DVBioScanningListReader* _tmp11_ = NULL;
	GList* _tmp12_ = NULL;
	GList* _tmp13_ = NULL;
	DVBLoggingLogger* _tmp14_ = NULL;
	GList* _tmp15_ = NULL;
	guint _tmp16_ = 0U;
	GList* _tmp17_ = NULL;
	GError * _inner_error_ = NULL;
	self = (DVBScanner*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	datafile = _tmp1_;
	_tmp2_ = dvb_scanner_log;
	_tmp3_ = path;
	dvb_logging_logger_debug (_tmp2_, "Scanner.vala:266: Reading scanning data from %s", _tmp3_);
	_tmp4_ = datafile;
	_tmp5_ = dvb_utils_is_readable_file (_tmp4_);
	if (!_tmp5_) {
		result = FALSE;
		_g_object_unref0 (datafile);
		return result;
	}
	_tmp6_ = path;
	_tmp7_ = dvb_io_scanning_list_reader_new (_tmp6_);
	reader = _tmp7_;
	{
		DVBioScanningListReader* _tmp8_ = NULL;
		_tmp8_ = reader;
		dvb_io_scanning_list_reader_read_data (_tmp8_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch158_g_key_file_error;
			}
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch158_g_file_error;
			}
			_g_object_unref0 (reader);
			_g_object_unref0 (datafile);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	goto __finally158;
	__catch158_g_key_file_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = dvb_scanner_log;
		dvb_logging_logger_error (_tmp9_, "Scanner.vala:275: could not read init file");
		_g_error_free0 (e);
	}
	goto __finally158;
	__catch158_g_file_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp10_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = dvb_scanner_log;
		dvb_logging_logger_error (_tmp10_, "Scanner.vala:277: could not read init file");
		_g_error_free0 (e);
	}
	__finally158:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (reader);
			_g_object_unref0 (datafile);
			return FALSE;
		} else {
			_g_object_unref0 (reader);
			_g_object_unref0 (datafile);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp11_ = reader;
	_tmp12_ = dvb_io_scanning_list_reader_get_Parameters (_tmp11_);
	_tmp13_ = _tmp12_;
	scanning_params = _tmp13_;
	_tmp14_ = dvb_scanner_log;
	_tmp15_ = scanning_params;
	_tmp16_ = g_list_length (_tmp15_);
	dvb_logging_logger_debug (_tmp14_, "Scanner.vala:281: read %u scanning parameter", _tmp16_);
	_tmp17_ = scanning_params;
	{
		GList* s_collection = NULL;
		GList* s_it = NULL;
		s_collection = _tmp17_;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			DVBParameter* _tmp18_ = NULL;
			DVBParameter* s = NULL;
			_tmp18_ = _g_object_ref0 ((DVBParameter*) s_it->data);
			s = _tmp18_;
			{
				DVBParameter* _tmp19_ = NULL;
				_tmp19_ = s;
				dvb_scanner_add_to_queue (self, _tmp19_);
				_g_object_unref0 (s);
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (reader);
	_g_object_unref0 (datafile);
	return result;
}


static void* dvb_scanner_worker (DVBScanner* self) {
	void* result = NULL;
	GMainLoop* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->loop;
	g_main_loop_run (_tmp0_);
	result = NULL;
	return result;
}


static gpointer _g_source_ref0 (gpointer self) {
	return self ? g_source_ref (self) : NULL;
}


void dvb_scanner_clear_and_reset_all (DVBScanner* self) {
	GstElement* _tmp0_ = NULL;
	GeeHashSet* _tmp9_ = NULL;
	GeeArrayList* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->pipeline;
	if (_tmp0_ != NULL) {
		GSource* bus_watch_source = NULL;
		GMainContext* _tmp1_ = NULL;
		guint _tmp2_ = 0U;
		GSource* _tmp3_ = NULL;
		GSource* _tmp4_ = NULL;
		GSource* _tmp5_ = NULL;
		DVBLoggingLogger* _tmp7_ = NULL;
		GstElement* _tmp8_ = NULL;
		_tmp1_ = self->priv->context;
		_tmp2_ = self->priv->bus_watch_id;
		_tmp3_ = g_main_context_find_source_by_id (_tmp1_, _tmp2_);
		_tmp4_ = _g_source_ref0 (_tmp3_);
		bus_watch_source = _tmp4_;
		_tmp5_ = bus_watch_source;
		if (_tmp5_ != NULL) {
			GSource* _tmp6_ = NULL;
			_tmp6_ = bus_watch_source;
			g_source_destroy (_tmp6_);
			self->priv->bus_watch_id = (guint) 0;
		}
		_tmp7_ = dvb_scanner_log;
		dvb_logging_logger_debug (_tmp7_, "Scanner.vala:306: Disposing pipeline");
		_tmp8_ = self->pipeline;
		gst_element_set_state (_tmp8_, GST_STATE_NULL);
		_g_object_unref0 (self->pipeline);
		self->pipeline = NULL;
		_g_source_unref0 (bus_watch_source);
	}
	_tmp9_ = self->priv->scanned_scanning_params;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp9_);
	dvb_scanner_clear_queue (self);
	_g_object_unref0 (self->priv->current_scanning_param);
	self->priv->current_scanning_param = NULL;
	_tmp10_ = self->priv->new_channels;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp10_);
	self->priv->running = FALSE;
}


void dvb_scanner_clear_queue (DVBScanner* self) {
	GQueue* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	while (TRUE) {
		GQueue* _tmp0_ = NULL;
		gboolean _tmp1_ = FALSE;
		DVBParameter* s = NULL;
		GQueue* _tmp2_ = NULL;
		gpointer _tmp3_ = NULL;
		_tmp0_ = self->priv->queue_scanning_params;
		_tmp1_ = g_queue_is_empty (_tmp0_);
		if (!(!_tmp1_)) {
			break;
		}
		_tmp2_ = self->priv->queue_scanning_params;
		_tmp3_ = g_queue_pop_head (_tmp2_);
		s = (DVBParameter*) _tmp3_;
		_g_object_unref0 (s);
		s = NULL;
		_g_object_unref0 (s);
	}
	_tmp4_ = self->priv->queue_scanning_params;
	g_queue_clear (_tmp4_);
}


void dvb_scanner_add_to_queue (DVBScanner* self, DVBParameter* param) {
	DVBParameter* _tmp0_ = NULL;
	DVBParameter* _tmp1_ = NULL;
	DVBDvbSrcDelsys _tmp2_ = 0;
	DVBDvbSrcDelsys _tmp3_ = 0;
	DVBAdapterType _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	gboolean eq = FALSE;
	gboolean _tmp15_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (param != NULL);
	_tmp0_ = param;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = param;
	_tmp2_ = dvb_parameter_get_Delsys (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_Type;
	_tmp5_ = dvb_isSupported (_tmp3_, _tmp4_);
	if (!_tmp5_) {
		return;
	}
	eq = FALSE;
	{
		GeeIterator* _s_it = NULL;
		GeeHashSet* _tmp6_ = NULL;
		GeeIterator* _tmp7_ = NULL;
		_tmp6_ = self->priv->scanned_scanning_params;
		_tmp7_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp6_);
		_s_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
			DVBParameter* s = NULL;
			GeeIterator* _tmp10_ = NULL;
			gpointer _tmp11_ = NULL;
			DVBParameter* _tmp12_ = NULL;
			DVBParameter* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			_tmp8_ = _s_it;
			_tmp9_ = gee_iterator_next (_tmp8_);
			if (!_tmp9_) {
				break;
			}
			_tmp10_ = _s_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			s = (DVBParameter*) _tmp11_;
			_tmp12_ = s;
			_tmp13_ = param;
			_tmp14_ = dvb_parameter_equal (_tmp12_, _tmp13_);
			if (_tmp14_) {
				eq = TRUE;
				_g_object_unref0 (s);
				break;
			}
			_g_object_unref0 (s);
		}
		_g_object_unref0 (_s_it);
	}
	_tmp15_ = eq;
	if (!_tmp15_) {
		DVBLoggingLogger* _tmp16_ = NULL;
		DVBParameter* _tmp17_ = NULL;
		guint _tmp18_ = 0U;
		guint _tmp19_ = 0U;
		GQueue* _tmp20_ = NULL;
		DVBParameter* _tmp21_ = NULL;
		DVBParameter* _tmp22_ = NULL;
		GeeHashSet* _tmp23_ = NULL;
		DVBParameter* _tmp24_ = NULL;
		_tmp16_ = dvb_scanner_log;
		_tmp17_ = param;
		_tmp18_ = dvb_parameter_get_Frequency (_tmp17_);
		_tmp19_ = _tmp18_;
		dvb_logging_logger_debug (_tmp16_, "Scanner.vala:342: Queueing new frequency %u", _tmp19_);
		_tmp20_ = self->priv->queue_scanning_params;
		_tmp21_ = param;
		_tmp22_ = _g_object_ref0 (_tmp21_);
		g_queue_push_tail (_tmp20_, _tmp22_);
		_tmp23_ = self->priv->scanned_scanning_params;
		_tmp24_ = param;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, _tmp24_);
	}
}


/**
         * Pick up the next tuning paramters from the queue
         * and start scanning with them
         */
static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


static gboolean _dvb_scanner_check_for_lock_gsource_func (gpointer self) {
	gboolean result;
	result = dvb_scanner_check_for_lock ((DVBScanner*) self);
	return result;
}


gboolean dvb_scanner_start_scan (DVBScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean all_tables = FALSE;
	DVBLoggingLogger* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	DVBParameter* _tmp23_ = NULL;
	GQueue* _tmp29_ = NULL;
	gboolean _tmp30_ = FALSE;
	GQueue* _tmp50_ = NULL;
	gpointer _tmp51_ = NULL;
	guint freq = 0U;
	DVBParameter* _tmp52_ = NULL;
	guint _tmp53_ = 0U;
	guint _tmp54_ = 0U;
	DVBLoggingLogger* _tmp55_ = NULL;
	guint _tmp56_ = 0U;
	GQueue* _tmp57_ = NULL;
	guint _tmp58_ = 0U;
	GstElement* _tmp59_ = NULL;
	GstElement* dvbsrc = NULL;
	GstElement* _tmp60_ = NULL;
	GstElement* _tmp61_ = NULL;
	DVBParameter* _tmp62_ = NULL;
	GstElement* _tmp63_ = NULL;
	GSource* _tmp64_ = NULL;
	GSource* _tmp65_ = NULL;
	GSource* _tmp66_ = NULL;
	GMainContext* _tmp67_ = NULL;
	GstElement* _tmp68_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = self->priv->sdt_arrived;
	if (_tmp3_) {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = self->priv->nit_arrived;
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp5_ = FALSE;
		_tmp5_ = self->priv->pat_arrived;
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp6_ = FALSE;
		_tmp6_ = self->priv->pmt_arrived;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	all_tables = _tmp0_;
	_tmp7_ = dvb_scanner_log;
	_tmp8_ = all_tables;
	_tmp9_ = bool_to_string (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->pat_arrived;
	_tmp12_ = bool_to_string (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = self->priv->sdt_arrived;
	_tmp15_ = bool_to_string (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = self->priv->nit_arrived;
	_tmp18_ = bool_to_string (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = self->priv->pmt_arrived;
	_tmp21_ = bool_to_string (_tmp20_);
	_tmp22_ = _tmp21_;
	dvb_logging_logger_debug (_tmp7_, "Scanner.vala:355: Received all tables: %s (pat: %s, sdt: %s, nit: %s, " \
"pmt: %s)", _tmp10_, _tmp13_, _tmp16_, _tmp19_, _tmp22_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp10_);
	self->priv->nit_arrived = FALSE;
	self->priv->sdt_arrived = FALSE;
	self->priv->pat_arrived = FALSE;
	self->priv->pmt_arrived = FALSE;
	self->priv->locked = FALSE;
	_tmp23_ = self->priv->current_scanning_param;
	if (_tmp23_ != NULL) {
		DVBParameter* _tmp24_ = NULL;
		guint _tmp25_ = 0U;
		guint _tmp26_ = 0U;
		GQueue* _tmp27_ = NULL;
		guint _tmp28_ = 0U;
		_tmp24_ = self->priv->current_scanning_param;
		_tmp25_ = dvb_parameter_get_Frequency (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = self->priv->queue_scanning_params;
		_tmp28_ = _tmp27_->length;
		g_signal_emit_by_name ((DVBIDBusScanner*) self, "frequency-scanned", _tmp26_, _tmp28_);
	}
	_tmp29_ = self->priv->queue_scanning_params;
	_tmp30_ = g_queue_is_empty (_tmp29_);
	if (_tmp30_) {
		g_message ("Scanner.vala:371: Finished scanning");
		{
			GeeArrayList* _tmp31_ = NULL;
			_tmp31_ = self->priv->new_channels;
			g_rec_mutex_lock (&self->priv->__lock_new_channels);
			{
				DVBLoggingLogger* _tmp32_ = NULL;
				GeeArrayList* _tmp33_ = NULL;
				gint _tmp34_ = 0;
				gint _tmp35_ = 0;
				_tmp32_ = dvb_scanner_log;
				_tmp33_ = self->priv->new_channels;
				_tmp34_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp33_);
				_tmp35_ = _tmp34_;
				dvb_logging_logger_debug (_tmp32_, "Scanner.vala:375: %u channels still have missing or invalid informatio" \
"n", (guint) _tmp35_);
				{
					GeeArrayList* _sid_list = NULL;
					GeeArrayList* _tmp36_ = NULL;
					GeeArrayList* _tmp37_ = NULL;
					gint _sid_size = 0;
					GeeArrayList* _tmp38_ = NULL;
					gint _tmp39_ = 0;
					gint _tmp40_ = 0;
					gint _sid_index = 0;
					_tmp36_ = self->priv->new_channels;
					_tmp37_ = _g_object_ref0 (_tmp36_);
					_sid_list = _tmp37_;
					_tmp38_ = _sid_list;
					_tmp39_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp38_);
					_tmp40_ = _tmp39_;
					_sid_size = _tmp40_;
					_sid_index = -1;
					while (TRUE) {
						gint _tmp41_ = 0;
						gint _tmp42_ = 0;
						gint _tmp43_ = 0;
						guint sid = 0U;
						GeeArrayList* _tmp44_ = NULL;
						gint _tmp45_ = 0;
						gpointer _tmp46_ = NULL;
						DVBChannelList* _tmp47_ = NULL;
						guint _tmp48_ = 0U;
						_tmp41_ = _sid_index;
						_sid_index = _tmp41_ + 1;
						_tmp42_ = _sid_index;
						_tmp43_ = _sid_size;
						if (!(_tmp42_ < _tmp43_)) {
							break;
						}
						_tmp44_ = _sid_list;
						_tmp45_ = _sid_index;
						_tmp46_ = gee_abstract_list_get ((GeeAbstractList*) _tmp44_, _tmp45_);
						sid = (guint) ((guintptr) _tmp46_);
						_tmp47_ = self->channels;
						_tmp48_ = sid;
						dvb_channel_list_remove (_tmp47_, _tmp48_);
					}
					_g_object_unref0 (_sid_list);
				}
			}
			__finally159:
			{
				GeeArrayList* _tmp49_ = NULL;
				_tmp49_ = self->priv->new_channels;
				g_rec_mutex_unlock (&self->priv->__lock_new_channels);
			}
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		dvb_scanner_clear_and_reset_all (self);
		g_signal_emit_by_name ((DVBIDBusScanner*) self, "finished");
		result = FALSE;
		return result;
	}
	_tmp50_ = self->priv->queue_scanning_params;
	_tmp51_ = g_queue_pop_head (_tmp50_);
	_g_object_unref0 (self->priv->current_scanning_param);
	self->priv->current_scanning_param = (DVBParameter*) _tmp51_;
	_tmp52_ = self->priv->current_scanning_param;
	_tmp53_ = dvb_parameter_get_Frequency (_tmp52_);
	_tmp54_ = _tmp53_;
	freq = _tmp54_;
	_tmp55_ = dvb_scanner_log;
	_tmp56_ = freq;
	_tmp57_ = self->priv->queue_scanning_params;
	_tmp58_ = g_queue_get_length (_tmp57_);
	dvb_logging_logger_debug (_tmp55_, "Scanner.vala:391: Starting scanning frequency %u (%u left)", _tmp56_, _tmp58_);
	_tmp59_ = self->pipeline;
	gst_element_set_state (_tmp59_, GST_STATE_READY);
	_tmp60_ = self->pipeline;
	_tmp61_ = gst_bin_get_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, gst_bin_get_type (), GstBin), "dvbsrc");
	dvbsrc = _tmp61_;
	_tmp62_ = self->priv->current_scanning_param;
	_tmp63_ = dvbsrc;
	dvb_parameter_prepare (_tmp62_, _tmp63_);
	_tmp64_ = g_timeout_source_new_seconds ((guint) 20);
	_g_source_unref0 (self->priv->check_for_lock_source);
	self->priv->check_for_lock_source = _tmp64_;
	_tmp65_ = self->priv->check_for_lock_source;
	g_source_set_callback (_tmp65_, _dvb_scanner_check_for_lock_gsource_func, g_object_ref (self), g_object_unref);
	_tmp66_ = self->priv->check_for_lock_source;
	_tmp67_ = self->priv->context;
	g_source_attach (_tmp66_, _tmp67_);
	_tmp68_ = self->pipeline;
	gst_element_set_state (_tmp68_, GST_STATE_PLAYING);
	result = FALSE;
	_g_object_unref0 (dvbsrc);
	return result;
}


/**
         * Check if we received a lock with the currently
         * used tuning parameters
         */
gboolean dvb_scanner_check_for_lock (DVBScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->locked;
	if (!_tmp0_) {
		GstElement* _tmp1_ = NULL;
		_tmp1_ = self->pipeline;
		gst_element_set_state (_tmp1_, GST_STATE_READY);
		dvb_scanner_queue_start_scan (self);
	}
	result = FALSE;
	return result;
}


gboolean dvb_scanner_wait_for_tables (DVBScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = self->priv->sdt_arrived;
	if (_tmp3_) {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = self->priv->nit_arrived;
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp5_ = FALSE;
		_tmp5_ = self->priv->pat_arrived;
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp6_ = FALSE;
		_tmp6_ = self->priv->pmt_arrived;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	if (!_tmp0_) {
		GstElement* _tmp7_ = NULL;
		_tmp7_ = self->pipeline;
		gst_element_set_state (_tmp7_, GST_STATE_READY);
		dvb_scanner_queue_start_scan (self);
	}
	result = FALSE;
	return result;
}


void dvb_scanner_destroy_start_scan_source (DVBScanner* self) {
	gboolean _tmp0_ = FALSE;
	GSource* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->start_scan_source;
	if (_tmp1_ != NULL) {
		GSource* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->start_scan_source;
		_tmp3_ = g_source_is_destroyed (_tmp2_);
		_tmp0_ = !_tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GSource* _tmp4_ = NULL;
		_tmp4_ = self->priv->start_scan_source;
		g_source_destroy (_tmp4_);
		_g_source_unref0 (self->priv->start_scan_source);
		self->priv->start_scan_source = NULL;
	}
}


void dvb_scanner_remove_check_for_lock_timeout (DVBScanner* self) {
	gboolean _tmp0_ = FALSE;
	GSource* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->check_for_lock_source;
	if (_tmp1_ != NULL) {
		GSource* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->check_for_lock_source;
		_tmp3_ = g_source_is_destroyed (_tmp2_);
		_tmp0_ = !_tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GSource* _tmp4_ = NULL;
		_tmp4_ = self->priv->check_for_lock_source;
		g_source_destroy (_tmp4_);
		_g_source_unref0 (self->priv->check_for_lock_source);
		self->priv->check_for_lock_source = NULL;
	}
}


void dvb_scanner_remove_wait_for_tables_timeout (DVBScanner* self) {
	gboolean _tmp0_ = FALSE;
	GSource* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->wait_for_tables_source;
	if (_tmp1_ != NULL) {
		GSource* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->wait_for_tables_source;
		_tmp3_ = g_source_is_destroyed (_tmp2_);
		_tmp0_ = !_tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GSource* _tmp4_ = NULL;
		_tmp4_ = self->priv->wait_for_tables_source;
		g_source_destroy (_tmp4_);
		_g_source_unref0 (self->priv->wait_for_tables_source);
		self->priv->wait_for_tables_source = NULL;
	}
}


static gboolean _dvb_scanner_start_scan_gsource_func (gpointer self) {
	gboolean result;
	result = dvb_scanner_start_scan ((DVBScanner*) self);
	return result;
}


void dvb_scanner_queue_start_scan (DVBScanner* self) {
	gboolean _tmp0_ = FALSE;
	GSource* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->start_scan_source;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GSource* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->start_scan_source;
		_tmp3_ = g_source_is_destroyed (_tmp2_);
		_tmp0_ = _tmp3_;
	}
	if (_tmp0_) {
		DVBLoggingLogger* _tmp4_ = NULL;
		GSource* _tmp5_ = NULL;
		GSource* _tmp6_ = NULL;
		GSource* _tmp7_ = NULL;
		GMainContext* _tmp8_ = NULL;
		_tmp4_ = dvb_scanner_log;
		dvb_logging_logger_debug (_tmp4_, "Scanner.vala:462: Queueing start_scan");
		_tmp5_ = g_idle_source_new ();
		_g_source_unref0 (self->priv->start_scan_source);
		self->priv->start_scan_source = _tmp5_;
		_tmp6_ = self->priv->start_scan_source;
		g_source_set_callback (_tmp6_, _dvb_scanner_start_scan_gsource_func, g_object_ref (self), g_object_unref);
		_tmp7_ = self->priv->start_scan_source;
		_tmp8_ = self->priv->context;
		g_source_attach (_tmp7_, _tmp8_);
	}
}


void dvb_scanner_set_uint_property (GstElement* src, GstStructure* params, const gchar* key) {
	guint val = 0U;
	GstStructure* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GstElement* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	g_return_if_fail (src != NULL);
	g_return_if_fail (params != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = params;
	_tmp1_ = key;
	gst_structure_get_uint (_tmp0_, _tmp1_, &_tmp2_);
	val = _tmp2_;
	_tmp3_ = src;
	_tmp4_ = key;
	g_object_set ((GObject*) _tmp3_, _tmp4_, val, NULL);
}


static gboolean _dvb_scanner_wait_for_tables_gsource_func (gpointer self) {
	gboolean result;
	result = dvb_scanner_wait_for_tables ((DVBScanner*) self);
	return result;
}


void dvb_scanner_on_dvb_frontend_stats_structure (DVBScanner* self, GstStructure* structure) {
	gboolean has_lock = FALSE;
	GstStructure* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gint _signal = 0;
	GstStructure* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _snr = 0;
	GstStructure* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (structure != NULL);
	_tmp0_ = structure;
	gst_structure_get_boolean (_tmp0_, "lock", &_tmp1_);
	has_lock = _tmp1_;
	_tmp3_ = has_lock;
	if (_tmp3_) {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = self->priv->locked;
		_tmp2_ = !_tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		DVBLoggingLogger* _tmp5_ = NULL;
		GSource* _tmp6_ = NULL;
		GSource* _tmp7_ = NULL;
		GSource* _tmp8_ = NULL;
		GMainContext* _tmp9_ = NULL;
		_tmp5_ = dvb_scanner_log;
		dvb_logging_logger_debug (_tmp5_, "Scanner.vala:480: Got lock");
		dvb_scanner_remove_check_for_lock_timeout (self);
		_tmp6_ = g_timeout_source_new_seconds ((guint) 10);
		_g_source_unref0 (self->priv->wait_for_tables_source);
		self->priv->wait_for_tables_source = _tmp6_;
		_tmp7_ = self->priv->wait_for_tables_source;
		g_source_set_callback (_tmp7_, _dvb_scanner_wait_for_tables_gsource_func, g_object_ref (self), g_object_unref);
		_tmp8_ = self->priv->wait_for_tables_source;
		_tmp9_ = self->priv->context;
		g_source_attach (_tmp8_, _tmp9_);
		self->priv->locked = TRUE;
	}
	_tmp10_ = structure;
	gst_structure_get_int (_tmp10_, "signal", &_tmp11_);
	_signal = _tmp11_;
	_tmp12_ = structure;
	gst_structure_get_int (_tmp12_, "snr", &_tmp13_);
	_snr = _tmp13_;
	g_signal_emit_by_name ((DVBIDBusScanner*) self, "frontend-stats", _signal / ((gdouble) 0xffff), _snr / ((gdouble) 0xffff));
}


void dvb_scanner_on_dvb_read_failure_structure (DVBScanner* self) {
	DVBLoggingLogger* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = dvb_scanner_log;
	dvb_logging_logger_warning (_tmp0_, "Scanner.vala:498: Read failure");
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static GstMpegtsPatProgram* _vala_GstMpegtsPatProgram_copy (GstMpegtsPatProgram* self) {
	return g_boxed_copy (gst_mpegts_pat_program_get_type (), self);
}


static gpointer __vala_GstMpegtsPatProgram_copy0 (gpointer self) {
	return self ? _vala_GstMpegtsPatProgram_copy (self) : NULL;
}


static void _vala_GstMpegtsPatProgram_free (GstMpegtsPatProgram* self) {
	g_boxed_free (gst_mpegts_pat_program_get_type (), self);
}


void dvb_scanner_on_pat_structure (DVBScanner* self, GstMpegtsSection* section) {
	DVBLoggingLogger* _tmp0_ = NULL;
	GstMpegtsSection* _tmp1_ = NULL;
	guint8 _tmp2_ = 0U;
	GstMpegtsSection* _tmp3_ = NULL;
	guint8 _tmp4_ = 0U;
	GstMpegtsSection* _tmp5_ = NULL;
	guint8 _tmp6_ = 0U;
	GPtrArray* pats = NULL;
	GstMpegtsSection* _tmp7_ = NULL;
	GPtrArray* _tmp8_ = NULL;
	GeeSet* pid_set = NULL;
	GeeHashSet* _tmp9_ = NULL;
	GeeSet* _tmp10_ = NULL;
	GeeSet* _tmp11_ = NULL;
	GstMpegtsPatProgram* pat = NULL;
	GString* new_pids = NULL;
	GString* _tmp26_ = NULL;
	gint i = 0;
	DVBLoggingLogger* _tmp46_ = NULL;
	GeeSet* _tmp47_ = NULL;
	gint _tmp48_ = 0;
	gint _tmp49_ = 0;
	GString* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	_tmp0_ = dvb_scanner_log;
	_tmp1_ = section;
	_tmp2_ = _tmp1_->version_number;
	_tmp3_ = section;
	_tmp4_ = _tmp3_->section_number;
	_tmp5_ = section;
	_tmp6_ = _tmp5_->last_section_number;
	dvb_logging_logger_debug (_tmp0_, "Scanner.vala:507: Received PAT, version %d, section number %d, last se" \
"ction number %d", (gint) _tmp2_, (gint) _tmp4_, (gint) _tmp6_);
	_tmp7_ = section;
	_tmp8_ = gst_mpegts_section_get_pat (_tmp7_);
	pats = _tmp8_;
	_tmp9_ = gee_hash_set_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	pid_set = (GeeSet*) _tmp9_;
	_tmp10_ = pid_set;
	gee_collection_add ((GeeCollection*) _tmp10_, (gpointer) ((guintptr) ((guint) 16)));
	_tmp11_ = pid_set;
	gee_collection_add ((GeeCollection*) _tmp11_, (gpointer) ((guintptr) ((guint) 17)));
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				gint _tmp14_ = 0;
				GPtrArray* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				GPtrArray* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				gconstpointer _tmp20_ = NULL;
				GstMpegtsPatProgram* _tmp21_ = NULL;
				guint pmt = 0U;
				GstMpegtsPatProgram* _tmp22_ = NULL;
				guint16 _tmp23_ = 0U;
				GeeSet* _tmp24_ = NULL;
				guint _tmp25_ = 0U;
				if (!_tmp12_) {
					gint _tmp13_ = 0;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp14_ = i;
				_tmp15_ = pats;
				_tmp16_ = g_ptr_array_get_length (_tmp15_);
				_tmp17_ = _tmp16_;
				if (!(_tmp14_ < _tmp17_)) {
					break;
				}
				_tmp18_ = pats;
				_tmp19_ = i;
				_tmp20_ = g_ptr_array_index (_tmp18_, (guint) _tmp19_);
				_tmp21_ = __vala_GstMpegtsPatProgram_copy0 ((GstMpegtsPatProgram*) _tmp20_);
				__vala_GstMpegtsPatProgram_free0 (pat);
				pat = _tmp21_;
				_tmp22_ = pat;
				_tmp23_ = _tmp22_->network_or_program_map_PID;
				pmt = (guint) _tmp23_;
				_tmp24_ = pid_set;
				_tmp25_ = pmt;
				gee_collection_add ((GeeCollection*) _tmp24_, (gpointer) ((guintptr) _tmp25_));
			}
		}
	}
	_tmp26_ = g_string_new ("");
	new_pids = _tmp26_;
	i = 0;
	{
		GeeIterator* _pid_it = NULL;
		GeeSet* _tmp27_ = NULL;
		GeeIterator* _tmp28_ = NULL;
		_tmp27_ = pid_set;
		_tmp28_ = gee_iterable_iterator ((GeeIterable*) _tmp27_);
		_pid_it = _tmp28_;
		while (TRUE) {
			GeeIterator* _tmp29_ = NULL;
			gboolean _tmp30_ = FALSE;
			guint pid = 0U;
			GeeIterator* _tmp31_ = NULL;
			gpointer _tmp32_ = NULL;
			gint _tmp33_ = 0;
			GeeSet* _tmp34_ = NULL;
			gint _tmp35_ = 0;
			gint _tmp36_ = 0;
			gint _tmp45_ = 0;
			_tmp29_ = _pid_it;
			_tmp30_ = gee_iterator_next (_tmp29_);
			if (!_tmp30_) {
				break;
			}
			_tmp31_ = _pid_it;
			_tmp32_ = gee_iterator_get (_tmp31_);
			pid = (guint) ((guintptr) _tmp32_);
			_tmp33_ = i;
			_tmp34_ = pid_set;
			_tmp35_ = gee_collection_get_size ((GeeCollection*) _tmp34_);
			_tmp36_ = _tmp35_;
			if ((_tmp33_ + 1) == _tmp36_) {
				GString* _tmp37_ = NULL;
				guint _tmp38_ = 0U;
				gchar* _tmp39_ = NULL;
				gchar* _tmp40_ = NULL;
				_tmp37_ = new_pids;
				_tmp38_ = pid;
				_tmp39_ = g_strdup_printf ("%u", _tmp38_);
				_tmp40_ = _tmp39_;
				g_string_append (_tmp37_, _tmp40_);
				_g_free0 (_tmp40_);
			} else {
				GString* _tmp41_ = NULL;
				guint _tmp42_ = 0U;
				gchar* _tmp43_ = NULL;
				gchar* _tmp44_ = NULL;
				_tmp41_ = new_pids;
				_tmp42_ = pid;
				_tmp43_ = g_strdup_printf ("%u:", _tmp42_);
				_tmp44_ = _tmp43_;
				g_string_append (_tmp41_, _tmp44_);
				_g_free0 (_tmp44_);
			}
			_tmp45_ = i;
			i = _tmp45_ + 1;
		}
		_g_object_unref0 (_pid_it);
	}
	_tmp46_ = dvb_scanner_log;
	_tmp47_ = pid_set;
	_tmp48_ = gee_collection_get_size ((GeeCollection*) _tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = new_pids;
	_tmp51_ = _tmp50_->str;
	dvb_logging_logger_debug (_tmp46_, "Scanner.vala:536: Setting %d pids: %s", _tmp49_, _tmp51_);
	self->priv->pat_arrived = TRUE;
	_g_string_free0 (new_pids);
	__vala_GstMpegtsPatProgram_free0 (pat);
	_g_object_unref0 (pid_set);
	_g_ptr_array_unref0 (pats);
}


static GstMpegtsSDTService* _vala_GstMpegtsSDTService_copy (GstMpegtsSDTService* self) {
	return g_boxed_copy (gst_mpegts_sdt_service_get_type (), self);
}


static gpointer __vala_GstMpegtsSDTService_copy0 (gpointer self) {
	return self ? _vala_GstMpegtsSDTService_copy (self) : NULL;
}


static void _vala_GstMpegtsSDTService_free (GstMpegtsSDTService* self) {
	g_boxed_free (gst_mpegts_sdt_service_get_type (), self);
}


static GstMpegtsDescriptor* _vala_GstMpegtsDescriptor_copy (GstMpegtsDescriptor* self) {
	return g_boxed_copy (gst_mpegts_descriptor_get_type (), self);
}


static gpointer __vala_GstMpegtsDescriptor_copy0 (gpointer self) {
	return self ? _vala_GstMpegtsDescriptor_copy (self) : NULL;
}


static void _vala_GstMpegtsDescriptor_free (GstMpegtsDescriptor* self) {
	g_boxed_free (gst_mpegts_descriptor_get_type (), self);
}


void dvb_scanner_on_sdt_structure (DVBScanner* self, GstMpegtsSection* section) {
	GstMpegtsSDT* sdt = NULL;
	GstMpegtsSection* _tmp0_ = NULL;
	GstMpegtsSDT* _tmp1_ = NULL;
	GstMpegtsSDT* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	guint tsid = 0U;
	GstMpegtsSection* _tmp4_ = NULL;
	guint16 _tmp5_ = 0U;
	guint onid = 0U;
	GstMpegtsSDT* _tmp6_ = NULL;
	guint16 _tmp7_ = 0U;
	DVBLoggingLogger* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	GstMpegtsSection* _tmp11_ = NULL;
	guint8 _tmp12_ = 0U;
	GstMpegtsSection* _tmp13_ = NULL;
	guint8 _tmp14_ = 0U;
	GstMpegtsSection* _tmp15_ = NULL;
	guint8 _tmp16_ = 0U;
	GstMpegtsSDTService* service = NULL;
	GstMpegtsSDT* _tmp85_ = NULL;
	gboolean _tmp86_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	_tmp0_ = section;
	_tmp1_ = gst_mpegts_section_get_sdt (_tmp0_);
	sdt = _tmp1_;
	_tmp2_ = sdt;
	_tmp3_ = _tmp2_->actual_ts;
	if (!_tmp3_) {
		return;
	}
	_tmp4_ = section;
	_tmp5_ = _tmp4_->subtable_extension;
	tsid = (guint) _tmp5_;
	_tmp6_ = sdt;
	_tmp7_ = _tmp6_->original_network_id;
	onid = (guint) _tmp7_;
	_tmp8_ = dvb_scanner_log;
	_tmp9_ = onid;
	_tmp10_ = tsid;
	_tmp11_ = section;
	_tmp12_ = _tmp11_->version_number;
	_tmp13_ = section;
	_tmp14_ = _tmp13_->section_number;
	_tmp15_ = section;
	_tmp16_ = _tmp15_->last_section_number;
	dvb_logging_logger_debug (_tmp8_, "Scanner.vala:553: Received SDT (0x%04x.0x%04x) , version %d, section n" \
"umber %d, last section number %d", _tmp9_, _tmp10_, (gint) _tmp12_, (gint) _tmp14_, (gint) _tmp16_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				gint _tmp19_ = 0;
				GstMpegtsSDT* _tmp20_ = NULL;
				GPtrArray* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				GstMpegtsSDT* _tmp24_ = NULL;
				GPtrArray* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				gconstpointer _tmp27_ = NULL;
				GstMpegtsSDTService* _tmp28_ = NULL;
				guint sid = 0U;
				GstMpegtsSDTService* _tmp29_ = NULL;
				guint16 _tmp30_ = 0U;
				DVBChannelList* _tmp31_ = NULL;
				guint _tmp32_ = 0U;
				gboolean _tmp33_ = FALSE;
				DVBChannel* channel = NULL;
				DVBChannelList* _tmp35_ = NULL;
				guint _tmp36_ = 0U;
				DVBChannel* _tmp37_ = NULL;
				DVBChannel* _tmp38_ = NULL;
				GstMpegtsSDTService* _tmp39_ = NULL;
				gboolean _tmp40_ = FALSE;
				DVBChannel* _tmp41_ = NULL;
				guint _tmp42_ = 0U;
				GstMpegtsDescriptor* desc = NULL;
				DVBLoggingLogger* _tmp75_ = NULL;
				guint _tmp76_ = 0U;
				DVBChannel* _tmp77_ = NULL;
				const gchar* _tmp78_ = NULL;
				const gchar* _tmp79_ = NULL;
				DVBChannel* _tmp80_ = NULL;
				gboolean _tmp81_ = FALSE;
				gboolean _tmp82_ = FALSE;
				gchar* _tmp83_ = NULL;
				gchar* _tmp84_ = NULL;
				if (!_tmp17_) {
					gint _tmp18_ = 0;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp19_ = i;
				_tmp20_ = sdt;
				_tmp21_ = _tmp20_->services;
				_tmp22_ = g_ptr_array_get_length (_tmp21_);
				_tmp23_ = _tmp22_;
				if (!(_tmp19_ < _tmp23_)) {
					break;
				}
				_tmp24_ = sdt;
				_tmp25_ = _tmp24_->services;
				_tmp26_ = i;
				_tmp27_ = g_ptr_array_index (_tmp25_, (guint) _tmp26_);
				_tmp28_ = __vala_GstMpegtsSDTService_copy0 ((GstMpegtsSDTService*) _tmp27_);
				__vala_GstMpegtsSDTService_free0 (service);
				service = _tmp28_;
				_tmp29_ = service;
				_tmp30_ = _tmp29_->service_id;
				sid = (guint) _tmp30_;
				_tmp31_ = self->channels;
				_tmp32_ = sid;
				_tmp33_ = dvb_channel_list_contains (_tmp31_, _tmp32_);
				if (!_tmp33_) {
					guint _tmp34_ = 0U;
					_tmp34_ = sid;
					dvb_scanner_add_new_channel (self, _tmp34_);
				}
				_tmp35_ = self->channels;
				_tmp36_ = sid;
				_tmp37_ = dvb_channel_list_get_channel (_tmp35_, _tmp36_);
				channel = _tmp37_;
				_tmp38_ = channel;
				_tmp39_ = service;
				_tmp40_ = _tmp39_->free_CA_mode;
				dvb_channel_set_Scrambled (_tmp38_, _tmp40_);
				_tmp41_ = channel;
				_tmp42_ = tsid;
				dvb_channel_set_TransportStreamId (_tmp41_, _tmp42_);
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp43_ = FALSE;
						_tmp43_ = TRUE;
						while (TRUE) {
							gint _tmp45_ = 0;
							GstMpegtsSDTService* _tmp46_ = NULL;
							GPtrArray* _tmp47_ = NULL;
							gint _tmp48_ = 0;
							gint _tmp49_ = 0;
							GstMpegtsSDTService* _tmp50_ = NULL;
							GPtrArray* _tmp51_ = NULL;
							gint _tmp52_ = 0;
							gconstpointer _tmp53_ = NULL;
							GstMpegtsDescriptor* _tmp54_ = NULL;
							GstMpegtsDescriptor* _tmp55_ = NULL;
							guint8 _tmp56_ = 0U;
							GstMpegtsDescriptor* _tmp63_ = NULL;
							guint8 _tmp64_ = 0U;
							if (!_tmp43_) {
								gint _tmp44_ = 0;
								_tmp44_ = j;
								j = _tmp44_ + 1;
							}
							_tmp43_ = FALSE;
							_tmp45_ = j;
							_tmp46_ = service;
							_tmp47_ = _tmp46_->descriptors;
							_tmp48_ = g_ptr_array_get_length (_tmp47_);
							_tmp49_ = _tmp48_;
							if (!(_tmp45_ < _tmp49_)) {
								break;
							}
							_tmp50_ = service;
							_tmp51_ = _tmp50_->descriptors;
							_tmp52_ = j;
							_tmp53_ = g_ptr_array_index (_tmp51_, (guint) _tmp52_);
							_tmp54_ = __vala_GstMpegtsDescriptor_copy0 ((GstMpegtsDescriptor*) _tmp53_);
							__vala_GstMpegtsDescriptor_free0 (desc);
							desc = _tmp54_;
							_tmp55_ = desc;
							_tmp56_ = _tmp55_->tag;
							if (_tmp56_ == GST_MTS_DESC_DVB_EXTENSION) {
								DVBLoggingLogger* _tmp57_ = NULL;
								GstMpegtsDescriptor* _tmp58_ = NULL;
								guint8 _tmp59_ = 0U;
								_tmp57_ = dvb_scanner_log;
								_tmp58_ = desc;
								_tmp59_ = _tmp58_->tag_extension;
								dvb_logging_logger_debug (_tmp57_, "Scanner.vala:576: Extentend descriptor 0x%02x", (guint) _tmp59_);
							} else {
								DVBLoggingLogger* _tmp60_ = NULL;
								GstMpegtsDescriptor* _tmp61_ = NULL;
								guint8 _tmp62_ = 0U;
								_tmp60_ = dvb_scanner_log;
								_tmp61_ = desc;
								_tmp62_ = _tmp61_->tag;
								dvb_logging_logger_debug (_tmp60_, "Scanner.vala:578: Descriptor 0x%02x", (guint) _tmp62_);
							}
							_tmp63_ = desc;
							_tmp64_ = _tmp63_->tag;
							switch (_tmp64_) {
								case GST_MTS_DESC_DVB_SERVICE:
								{
									{
										GstMpegtsDVBServiceType type = 0;
										gchar* name = NULL;
										gchar* provider = NULL;
										GstMpegtsDescriptor* _tmp65_ = NULL;
										GstMpegtsDVBServiceType _tmp66_ = 0;
										gchar* _tmp67_ = NULL;
										gchar* _tmp68_ = NULL;
										DVBChannel* _tmp69_ = NULL;
										const gchar* _tmp70_ = NULL;
										DVBChannel* _tmp71_ = NULL;
										const gchar* _tmp72_ = NULL;
										DVBChannel* _tmp73_ = NULL;
										GstMpegtsDVBServiceType _tmp74_ = 0;
										_tmp65_ = desc;
										gst_mpegts_descriptor_parse_dvb_service (_tmp65_, &_tmp66_, &_tmp67_, &_tmp68_);
										type = _tmp66_;
										_g_free0 (name);
										name = _tmp67_;
										_g_free0 (provider);
										provider = _tmp68_;
										_tmp69_ = channel;
										_tmp70_ = name;
										dvb_channel_set_Name (_tmp69_, _tmp70_);
										_tmp71_ = channel;
										_tmp72_ = provider;
										dvb_channel_set_Network (_tmp71_, _tmp72_);
										_tmp73_ = channel;
										_tmp74_ = type;
										dvb_channel_set_ServiceType (_tmp73_, _tmp74_);
										_g_free0 (provider);
										_g_free0 (name);
										break;
									}
								}
								default:
								{
									break;
								}
							}
						}
					}
				}
				_tmp75_ = dvb_scanner_log;
				_tmp76_ = sid;
				_tmp77_ = channel;
				_tmp78_ = dvb_channel_get_Name (_tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = channel;
				_tmp81_ = dvb_channel_get_Scrambled (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp83_ = bool_to_string (_tmp82_);
				_tmp84_ = _tmp83_;
				dvb_logging_logger_debug (_tmp75_, "Scanner.vala:600: Found service 0x%04x, %s, scrambled: %s", _tmp76_, _tmp79_, _tmp84_);
				_g_free0 (_tmp84_);
				__vala_GstMpegtsDescriptor_free0 (desc);
				_g_object_unref0 (channel);
			}
		}
	}
	_tmp85_ = sdt;
	_tmp86_ = _tmp85_->actual_ts;
	if (_tmp86_) {
		self->priv->sdt_arrived = TRUE;
	}
	__vala_GstMpegtsSDTService_free0 (service);
}


static GstMpegtsNITStream* _vala_GstMpegtsNITStream_copy (GstMpegtsNITStream* self) {
	return g_boxed_copy (gst_mpegts_nit_stream_get_type (), self);
}


static gpointer __vala_GstMpegtsNITStream_copy0 (gpointer self) {
	return self ? _vala_GstMpegtsNITStream_copy (self) : NULL;
}


static void _vala_GstMpegtsNITStream_free (GstMpegtsNITStream* self) {
	g_boxed_free (gst_mpegts_nit_stream_get_type (), self);
}


void dvb_scanner_on_nit_structure (DVBScanner* self, GstMpegtsSection* section) {
	GstMpegtsNIT* nit = NULL;
	GstMpegtsSection* _tmp0_ = NULL;
	GstMpegtsNIT* _tmp1_ = NULL;
	GstMpegtsNIT* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	DVBLoggingLogger* _tmp4_ = NULL;
	GstMpegtsSection* _tmp5_ = NULL;
	guint8 _tmp6_ = 0U;
	GstMpegtsSection* _tmp7_ = NULL;
	guint8 _tmp8_ = 0U;
	GstMpegtsSection* _tmp9_ = NULL;
	guint8 _tmp10_ = 0U;
	GstMpegtsDescriptor* desc = NULL;
	gchar* name = NULL;
	guint nid = 0U;
	GstMpegtsNIT* _tmp27_ = NULL;
	guint16 _tmp28_ = 0U;
	const gchar* _tmp29_ = NULL;
	DVBLoggingLogger* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	guint _tmp34_ = 0U;
	GstMpegtsNITStream* stream = NULL;
	GstMpegtsNIT* _tmp174_ = NULL;
	gboolean _tmp175_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	_tmp0_ = section;
	_tmp1_ = gst_mpegts_section_get_nit (_tmp0_);
	nit = _tmp1_;
	_tmp2_ = nit;
	_tmp3_ = _tmp2_->actual_network;
	if (!_tmp3_) {
		return;
	}
	_tmp4_ = dvb_scanner_log;
	_tmp5_ = section;
	_tmp6_ = _tmp5_->version_number;
	_tmp7_ = section;
	_tmp8_ = _tmp7_->section_number;
	_tmp9_ = section;
	_tmp10_ = _tmp9_->last_section_number;
	dvb_logging_logger_debug (_tmp4_, "Scanner.vala:615: Received NIT, version %d, section number %d, last se" \
"ction number %d", (gint) _tmp6_, (gint) _tmp8_, (gint) _tmp10_);
	name = NULL;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gint _tmp13_ = 0;
				GstMpegtsNIT* _tmp14_ = NULL;
				GPtrArray* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				GstMpegtsNIT* _tmp18_ = NULL;
				GPtrArray* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				gconstpointer _tmp21_ = NULL;
				GstMpegtsDescriptor* _tmp22_ = NULL;
				GstMpegtsDescriptor* _tmp23_ = NULL;
				guint8 _tmp24_ = 0U;
				if (!_tmp11_) {
					gint _tmp12_ = 0;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp13_ = i;
				_tmp14_ = nit;
				_tmp15_ = _tmp14_->descriptors;
				_tmp16_ = g_ptr_array_get_length (_tmp15_);
				_tmp17_ = _tmp16_;
				if (!(_tmp13_ < _tmp17_)) {
					break;
				}
				_tmp18_ = nit;
				_tmp19_ = _tmp18_->descriptors;
				_tmp20_ = i;
				_tmp21_ = g_ptr_array_index (_tmp19_, (guint) _tmp20_);
				_tmp22_ = __vala_GstMpegtsDescriptor_copy0 ((GstMpegtsDescriptor*) _tmp21_);
				__vala_GstMpegtsDescriptor_free0 (desc);
				desc = _tmp22_;
				_tmp23_ = desc;
				_tmp24_ = _tmp23_->tag;
				if (_tmp24_ == GST_MTS_DESC_DVB_NETWORK_NAME) {
					GstMpegtsDescriptor* _tmp25_ = NULL;
					gchar* _tmp26_ = NULL;
					_tmp25_ = desc;
					gst_mpegts_descriptor_parse_dvb_network_name (_tmp25_, &_tmp26_);
					_g_free0 (name);
					name = _tmp26_;
					break;
				}
			}
		}
	}
	_tmp27_ = nit;
	_tmp28_ = _tmp27_->network_id;
	nid = (guint) _tmp28_;
	_tmp29_ = name;
	if (_tmp29_ == NULL) {
		guint _tmp30_ = 0U;
		gchar* _tmp31_ = NULL;
		_tmp30_ = nid;
		_tmp31_ = g_strdup_printf ("%u", _tmp30_);
		_g_free0 (name);
		name = _tmp31_;
	}
	_tmp32_ = dvb_scanner_log;
	_tmp33_ = name;
	_tmp34_ = nid;
	dvb_logging_logger_debug (_tmp32_, "Scanner.vala:632: Network name '%s', id = 0x%04x", _tmp33_, _tmp34_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp35_ = FALSE;
			_tmp35_ = TRUE;
			while (TRUE) {
				gint _tmp37_ = 0;
				GstMpegtsNIT* _tmp38_ = NULL;
				GPtrArray* _tmp39_ = NULL;
				gint _tmp40_ = 0;
				gint _tmp41_ = 0;
				GstMpegtsNIT* _tmp42_ = NULL;
				GPtrArray* _tmp43_ = NULL;
				gint _tmp44_ = 0;
				gconstpointer _tmp45_ = NULL;
				GstMpegtsNITStream* _tmp46_ = NULL;
				guint tsid = 0U;
				GstMpegtsNITStream* _tmp47_ = NULL;
				guint16 _tmp48_ = 0U;
				guint onid = 0U;
				GstMpegtsNITStream* _tmp49_ = NULL;
				guint16 _tmp50_ = 0U;
				DVBLoggingLogger* _tmp51_ = NULL;
				guint _tmp52_ = 0U;
				guint _tmp53_ = 0U;
				if (!_tmp35_) {
					gint _tmp36_ = 0;
					_tmp36_ = i;
					i = _tmp36_ + 1;
				}
				_tmp35_ = FALSE;
				_tmp37_ = i;
				_tmp38_ = nit;
				_tmp39_ = _tmp38_->streams;
				_tmp40_ = g_ptr_array_get_length (_tmp39_);
				_tmp41_ = _tmp40_;
				if (!(_tmp37_ < _tmp41_)) {
					break;
				}
				_tmp42_ = nit;
				_tmp43_ = _tmp42_->streams;
				_tmp44_ = i;
				_tmp45_ = g_ptr_array_index (_tmp43_, (guint) _tmp44_);
				_tmp46_ = __vala_GstMpegtsNITStream_copy0 ((GstMpegtsNITStream*) _tmp45_);
				__vala_GstMpegtsNITStream_free0 (stream);
				stream = _tmp46_;
				_tmp47_ = stream;
				_tmp48_ = _tmp47_->transport_stream_id;
				tsid = (guint) _tmp48_;
				_tmp49_ = stream;
				_tmp50_ = _tmp49_->original_network_id;
				onid = (guint) _tmp50_;
				_tmp51_ = dvb_scanner_log;
				_tmp52_ = tsid;
				_tmp53_ = onid;
				dvb_logging_logger_debug (_tmp51_, "Scanner.vala:641: Received TS 0x%04x, on_id = 0x%04x", _tmp52_, _tmp53_);
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp54_ = FALSE;
						_tmp54_ = TRUE;
						while (TRUE) {
							gint _tmp56_ = 0;
							GstMpegtsNITStream* _tmp57_ = NULL;
							GPtrArray* _tmp58_ = NULL;
							gint _tmp59_ = 0;
							gint _tmp60_ = 0;
							GstMpegtsNITStream* _tmp61_ = NULL;
							GPtrArray* _tmp62_ = NULL;
							gint _tmp63_ = 0;
							gconstpointer _tmp64_ = NULL;
							GstMpegtsDescriptor* _tmp65_ = NULL;
							GstMpegtsDescriptor* _tmp66_ = NULL;
							guint8 _tmp67_ = 0U;
							GstMpegtsDescriptor* _tmp74_ = NULL;
							guint8 _tmp75_ = 0U;
							if (!_tmp54_) {
								gint _tmp55_ = 0;
								_tmp55_ = j;
								j = _tmp55_ + 1;
							}
							_tmp54_ = FALSE;
							_tmp56_ = j;
							_tmp57_ = stream;
							_tmp58_ = _tmp57_->descriptors;
							_tmp59_ = g_ptr_array_get_length (_tmp58_);
							_tmp60_ = _tmp59_;
							if (!(_tmp56_ < _tmp60_)) {
								break;
							}
							_tmp61_ = stream;
							_tmp62_ = _tmp61_->descriptors;
							_tmp63_ = j;
							_tmp64_ = g_ptr_array_index (_tmp62_, (guint) _tmp63_);
							_tmp65_ = __vala_GstMpegtsDescriptor_copy0 ((GstMpegtsDescriptor*) _tmp64_);
							__vala_GstMpegtsDescriptor_free0 (desc);
							desc = _tmp65_;
							_tmp66_ = desc;
							_tmp67_ = _tmp66_->tag;
							if (_tmp67_ == GST_MTS_DESC_DVB_EXTENSION) {
								DVBLoggingLogger* _tmp68_ = NULL;
								GstMpegtsDescriptor* _tmp69_ = NULL;
								guint8 _tmp70_ = 0U;
								_tmp68_ = dvb_scanner_log;
								_tmp69_ = desc;
								_tmp70_ = _tmp69_->tag_extension;
								dvb_logging_logger_debug (_tmp68_, "Scanner.vala:648: Extentend desriptor 0x%02x", (guint) _tmp70_);
							} else {
								DVBLoggingLogger* _tmp71_ = NULL;
								GstMpegtsDescriptor* _tmp72_ = NULL;
								guint8 _tmp73_ = 0U;
								_tmp71_ = dvb_scanner_log;
								_tmp72_ = desc;
								_tmp73_ = _tmp72_->tag;
								dvb_logging_logger_debug (_tmp71_, "Scanner.vala:650: Desriptor 0x%02x", (guint) _tmp73_);
							}
							_tmp74_ = desc;
							_tmp75_ = _tmp74_->tag;
							switch (_tmp75_) {
								case GST_MTS_DESC_DVB_TERRESTRIAL_DELIVERY_SYSTEM:
								{
									GstMpegtsTerrestrialDeliverySystemDescriptor tdesc = {0};
									GstMpegtsDescriptor* _tmp76_ = NULL;
									GstMpegtsTerrestrialDeliverySystemDescriptor _tmp77_ = {0};
									GstMpegtsDVBCodeRate ratehp = 0;
									GstMpegtsDVBCodeRate ratelp = 0;
									GstMpegtsTerrestrialDeliverySystemDescriptor _tmp78_ = {0};
									gboolean _tmp79_ = FALSE;
									DVBDvbTParameter* dvbtp = NULL;
									GstMpegtsTerrestrialDeliverySystemDescriptor _tmp84_ = {0};
									guint32 _tmp85_ = 0U;
									GstMpegtsTerrestrialDeliverySystemDescriptor _tmp86_ = {0};
									guint32 _tmp87_ = 0U;
									GstMpegtsTerrestrialDeliverySystemDescriptor _tmp88_ = {0};
									GstMpegtsTerrestrialGuardInterval _tmp89_ = 0;
									GstMpegtsTerrestrialDeliverySystemDescriptor _tmp90_ = {0};
									GstMpegtsTerrestrialTransmissionMode _tmp91_ = 0;
									GstMpegtsTerrestrialDeliverySystemDescriptor _tmp92_ = {0};
									GstMpegtsTerrestrialHierarchy _tmp93_ = 0;
									GstMpegtsTerrestrialDeliverySystemDescriptor _tmp94_ = {0};
									GstMpegtsModulationType _tmp95_ = 0;
									GstMpegtsDVBCodeRate _tmp96_ = 0;
									GstMpegtsDVBCodeRate _tmp97_ = 0;
									DVBDvbTParameter* _tmp98_ = NULL;
									DVBParameter* _tmp99_ = NULL;
									guint _tmp100_ = 0U;
									guint _tmp101_ = 0U;
									GstMpegtsTerrestrialDeliverySystemDescriptor _tmp102_ = {0};
									guint32 _tmp103_ = 0U;
									_tmp76_ = desc;
									gst_mpegts_descriptor_parse_terrestrial_delivery_system (_tmp76_, &_tmp77_);
									tdesc = _tmp77_;
									_tmp78_ = tdesc;
									_tmp79_ = _tmp78_.priority;
									if (_tmp79_) {
										GstMpegtsTerrestrialDeliverySystemDescriptor _tmp80_ = {0};
										GstMpegtsDVBCodeRate _tmp81_ = 0;
										_tmp80_ = tdesc;
										_tmp81_ = _tmp80_.code_rate_hp;
										ratehp = _tmp81_;
										ratelp = GST_MPEGTS_FEC_NONE;
									} else {
										GstMpegtsTerrestrialDeliverySystemDescriptor _tmp82_ = {0};
										GstMpegtsDVBCodeRate _tmp83_ = 0;
										ratehp = GST_MPEGTS_FEC_NONE;
										_tmp82_ = tdesc;
										_tmp83_ = _tmp82_.code_rate_lp;
										ratelp = _tmp83_;
									}
									_tmp84_ = tdesc;
									_tmp85_ = _tmp84_.frequency;
									_tmp86_ = tdesc;
									_tmp87_ = _tmp86_.bandwidth;
									_tmp88_ = tdesc;
									_tmp89_ = _tmp88_.guard_interval;
									_tmp90_ = tdesc;
									_tmp91_ = _tmp90_.transmission_mode;
									_tmp92_ = tdesc;
									_tmp93_ = _tmp92_.hierarchy;
									_tmp94_ = tdesc;
									_tmp95_ = _tmp94_.constellation;
									_tmp96_ = ratelp;
									_tmp97_ = ratehp;
									_tmp98_ = dvb_dvb_tparameter_new_with_parameter ((guint) _tmp85_, (guint) _tmp87_, _tmp89_, _tmp91_, _tmp93_, _tmp95_, _tmp96_, _tmp97_);
									dvbtp = _tmp98_;
									_tmp99_ = self->priv->current_scanning_param;
									_tmp100_ = dvb_parameter_get_Frequency (_tmp99_);
									_tmp101_ = _tmp100_;
									_tmp102_ = tdesc;
									_tmp103_ = _tmp102_.frequency;
									if (_tmp101_ == ((guint) _tmp103_)) {
										DVBDvbTParameter* _tmp121_ = NULL;
										DVBParameter* _tmp122_ = NULL;
										{
											DVBChannelList* _tmp104_ = NULL;
											_tmp104_ = self->channels;
											g_rec_mutex_lock (&self->priv->__lock_channels);
											{
												{
													GeeIterator* _channel_it = NULL;
													DVBChannelList* _tmp105_ = NULL;
													GeeIterator* _tmp106_ = NULL;
													_tmp105_ = self->channels;
													_tmp106_ = gee_iterable_iterator ((GeeIterable*) _tmp105_);
													_channel_it = _tmp106_;
													while (TRUE) {
														GeeIterator* _tmp107_ = NULL;
														gboolean _tmp108_ = FALSE;
														DVBChannel* channel = NULL;
														GeeIterator* _tmp109_ = NULL;
														gpointer _tmp110_ = NULL;
														DVBChannel* _tmp111_ = NULL;
														DVBParameter* _tmp112_ = NULL;
														DVBParameter* _tmp113_ = NULL;
														guint _tmp114_ = 0U;
														guint _tmp115_ = 0U;
														GstMpegtsTerrestrialDeliverySystemDescriptor _tmp116_ = {0};
														guint32 _tmp117_ = 0U;
														_tmp107_ = _channel_it;
														_tmp108_ = gee_iterator_next (_tmp107_);
														if (!_tmp108_) {
															break;
														}
														_tmp109_ = _channel_it;
														_tmp110_ = gee_iterator_get (_tmp109_);
														channel = (DVBChannel*) _tmp110_;
														_tmp111_ = channel;
														_tmp112_ = dvb_channel_get_Param (_tmp111_);
														_tmp113_ = _tmp112_;
														_tmp114_ = dvb_parameter_get_Frequency (_tmp113_);
														_tmp115_ = _tmp114_;
														_tmp116_ = tdesc;
														_tmp117_ = _tmp116_.frequency;
														if (_tmp115_ == ((guint) _tmp117_)) {
															DVBChannel* _tmp118_ = NULL;
															DVBDvbTParameter* _tmp119_ = NULL;
															_tmp118_ = channel;
															_tmp119_ = dvbtp;
															dvb_channel_set_Param (_tmp118_, (DVBParameter*) _tmp119_);
														}
														_g_object_unref0 (channel);
													}
													_g_object_unref0 (_channel_it);
												}
											}
											__finally160:
											{
												DVBChannelList* _tmp120_ = NULL;
												_tmp120_ = self->channels;
												g_rec_mutex_unlock (&self->priv->__lock_channels);
											}
											if (G_UNLIKELY (_inner_error_ != NULL)) {
												_g_object_unref0 (dvbtp);
												__vala_GstMpegtsNITStream_free0 (stream);
												_g_free0 (name);
												__vala_GstMpegtsDescriptor_free0 (desc);
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return;
											}
										}
										_tmp121_ = dvbtp;
										_tmp122_ = _g_object_ref0 ((DVBParameter*) _tmp121_);
										_g_object_unref0 (self->priv->current_scanning_param);
										self->priv->current_scanning_param = _tmp122_;
									} else {
										DVBDvbTParameter* _tmp123_ = NULL;
										_tmp123_ = dvbtp;
										dvb_scanner_add_to_queue (self, (DVBParameter*) _tmp123_);
									}
									_g_object_unref0 (dvbtp);
									break;
								}
								case GST_MTS_DESC_DVB_CABLE_DELIVERY_SYSTEM:
								{
									GstMpegtsCableDeliverySystemDescriptor cdesc = {0};
									GstMpegtsDescriptor* _tmp124_ = NULL;
									GstMpegtsCableDeliverySystemDescriptor _tmp125_ = {0};
									DVBDvbCEuropeParameter* dvbcp = NULL;
									GstMpegtsCableDeliverySystemDescriptor _tmp126_ = {0};
									guint32 _tmp127_ = 0U;
									GstMpegtsCableDeliverySystemDescriptor _tmp128_ = {0};
									guint32 _tmp129_ = 0U;
									GstMpegtsCableDeliverySystemDescriptor _tmp130_ = {0};
									GstMpegtsModulationType _tmp131_ = 0;
									GstMpegtsCableDeliverySystemDescriptor _tmp132_ = {0};
									GstMpegtsDVBCodeRate _tmp133_ = 0;
									DVBDvbCEuropeParameter* _tmp134_ = NULL;
									DVBParameter* _tmp135_ = NULL;
									guint _tmp136_ = 0U;
									guint _tmp137_ = 0U;
									GstMpegtsCableDeliverySystemDescriptor _tmp138_ = {0};
									guint32 _tmp139_ = 0U;
									_tmp124_ = desc;
									gst_mpegts_descriptor_parse_cable_delivery_system (_tmp124_, &_tmp125_);
									cdesc = _tmp125_;
									_tmp126_ = cdesc;
									_tmp127_ = _tmp126_.frequency;
									_tmp128_ = cdesc;
									_tmp129_ = _tmp128_.symbol_rate;
									_tmp130_ = cdesc;
									_tmp131_ = _tmp130_.modulation;
									_tmp132_ = cdesc;
									_tmp133_ = _tmp132_.fec_inner;
									_tmp134_ = dvb_dvb_ceurope_parameter_new_with_parameter ((guint) _tmp127_, (guint) _tmp129_, _tmp131_, _tmp133_);
									dvbcp = _tmp134_;
									_tmp135_ = self->priv->current_scanning_param;
									_tmp136_ = dvb_parameter_get_Frequency (_tmp135_);
									_tmp137_ = _tmp136_;
									_tmp138_ = cdesc;
									_tmp139_ = _tmp138_.frequency;
									if (_tmp137_ == ((guint) _tmp139_)) {
										DVBDvbCEuropeParameter* _tmp140_ = NULL;
										DVBParameter* _tmp141_ = NULL;
										_tmp140_ = dvbcp;
										_tmp141_ = _g_object_ref0 ((DVBParameter*) _tmp140_);
										_g_object_unref0 (self->priv->current_scanning_param);
										self->priv->current_scanning_param = _tmp141_;
									} else {
										DVBDvbCEuropeParameter* _tmp142_ = NULL;
										_tmp142_ = dvbcp;
										dvb_scanner_add_to_queue (self, (DVBParameter*) _tmp142_);
									}
									_g_object_unref0 (dvbcp);
									break;
								}
								case GST_MTS_DESC_DVB_SATELLITE_DELIVERY_SYSTEM:
								{
									GstMpegtsSatelliteDeliverySystemDescriptor sdesc = {0};
									GstMpegtsDescriptor* _tmp143_ = NULL;
									GstMpegtsSatelliteDeliverySystemDescriptor _tmp144_ = {0};
									gfloat position = 0.0F;
									GstMpegtsSatelliteDeliverySystemDescriptor _tmp145_ = {0};
									gboolean _tmp146_ = FALSE;
									_tmp143_ = desc;
									gst_mpegts_descriptor_parse_satellite_delivery_system (_tmp143_, &_tmp144_);
									sdesc = _tmp144_;
									_tmp145_ = sdesc;
									_tmp146_ = _tmp145_.modulation_system;
									if (!_tmp146_) {
										GstMpegtsSatelliteDeliverySystemDescriptor _tmp147_ = {0};
										GstMpegtsModulationType _tmp148_ = 0;
										_tmp147_ = sdesc;
										_tmp148_ = _tmp147_.modulation_type;
										if (_tmp148_ != GST_MPEGTS_MODULATION_QPSK) {
										} else {
											GstMpegtsSatelliteDeliverySystemDescriptor _tmp149_ = {0};
											gfloat _tmp150_ = 0.0F;
											GstMpegtsSatelliteDeliverySystemDescriptor _tmp151_ = {0};
											gboolean _tmp152_ = FALSE;
											DVBLoggingLogger* _tmp154_ = NULL;
											gfloat _tmp155_ = 0.0F;
											DVBDvbSParameter* dvbsp = NULL;
											GstMpegtsSatelliteDeliverySystemDescriptor _tmp156_ = {0};
											guint32 _tmp157_ = 0U;
											GstMpegtsSatelliteDeliverySystemDescriptor _tmp158_ = {0};
											guint32 _tmp159_ = 0U;
											gfloat _tmp160_ = 0.0F;
											GstMpegtsSatelliteDeliverySystemDescriptor _tmp161_ = {0};
											GstMpegtsSatellitePolarizationType _tmp162_ = 0;
											GstMpegtsSatelliteDeliverySystemDescriptor _tmp163_ = {0};
											GstMpegtsDVBCodeRate _tmp164_ = 0;
											DVBDvbSParameter* _tmp165_ = NULL;
											DVBParameter* _tmp166_ = NULL;
											guint _tmp167_ = 0U;
											guint _tmp168_ = 0U;
											GstMpegtsSatelliteDeliverySystemDescriptor _tmp169_ = {0};
											guint32 _tmp170_ = 0U;
											_tmp149_ = sdesc;
											_tmp150_ = _tmp149_.orbital_position;
											position = _tmp150_;
											_tmp151_ = sdesc;
											_tmp152_ = _tmp151_.west_east;
											if (!_tmp152_) {
												gfloat _tmp153_ = 0.0F;
												_tmp153_ = position;
												position = _tmp153_ * -1;
											}
											_tmp154_ = dvb_scanner_log;
											_tmp155_ = position;
											dvb_logging_logger_debug (_tmp154_, "Scanner.vala:712: Orbital position: %f", (gdouble) _tmp155_);
											_tmp156_ = sdesc;
											_tmp157_ = _tmp156_.frequency;
											_tmp158_ = sdesc;
											_tmp159_ = _tmp158_.symbol_rate;
											_tmp160_ = position;
											_tmp161_ = sdesc;
											_tmp162_ = _tmp161_.polarization;
											_tmp163_ = sdesc;
											_tmp164_ = _tmp163_.fec_inner;
											_tmp165_ = dvb_dvb_sparameter_new_with_parameter ((guint) _tmp157_, (guint) _tmp159_, _tmp160_, _tmp162_, _tmp164_);
											dvbsp = _tmp165_;
											_tmp166_ = self->priv->current_scanning_param;
											_tmp167_ = dvb_parameter_get_Frequency (_tmp166_);
											_tmp168_ = _tmp167_;
											_tmp169_ = sdesc;
											_tmp170_ = _tmp169_.frequency;
											if (_tmp168_ == ((guint) _tmp170_)) {
												DVBDvbSParameter* _tmp171_ = NULL;
												DVBParameter* _tmp172_ = NULL;
												_tmp171_ = dvbsp;
												_tmp172_ = _g_object_ref0 ((DVBParameter*) _tmp171_);
												_g_object_unref0 (self->priv->current_scanning_param);
												self->priv->current_scanning_param = _tmp172_;
											} else {
												DVBDvbSParameter* _tmp173_ = NULL;
												_tmp173_ = dvbsp;
												dvb_scanner_add_to_queue (self, (DVBParameter*) _tmp173_);
											}
											_g_object_unref0 (dvbsp);
										}
									} else {
									}
									break;
								}
								default:
								{
									break;
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp174_ = nit;
	_tmp175_ = _tmp174_->actual_network;
	if (_tmp175_) {
		self->priv->nit_arrived = TRUE;
	}
	__vala_GstMpegtsNITStream_free0 (stream);
	_g_free0 (name);
	__vala_GstMpegtsDescriptor_free0 (desc);
}


static GstMpegtsPMTStream* _vala_GstMpegtsPMTStream_copy (GstMpegtsPMTStream* self) {
	return g_boxed_copy (gst_mpegts_pmt_stream_get_type (), self);
}


static gpointer __vala_GstMpegtsPMTStream_copy0 (gpointer self) {
	return self ? _vala_GstMpegtsPMTStream_copy (self) : NULL;
}


static void _vala_GstMpegtsPMTStream_free (GstMpegtsPMTStream* self) {
	g_boxed_free (gst_mpegts_pmt_stream_get_type (), self);
}


void dvb_scanner_on_pmt_structure (DVBScanner* self, GstMpegtsSection* section) {
	DVBLoggingLogger* _tmp0_ = NULL;
	GstMpegtsSection* _tmp1_ = NULL;
	guint8 _tmp2_ = 0U;
	GstMpegtsSection* _tmp3_ = NULL;
	guint8 _tmp4_ = 0U;
	GstMpegtsSection* _tmp5_ = NULL;
	guint8 _tmp6_ = 0U;
	GstMpegtsPMT* pmt = NULL;
	GstMpegtsSection* _tmp7_ = NULL;
	GstMpegtsPMT* _tmp8_ = NULL;
	guint program_number = 0U;
	GstMpegtsPMT* _tmp9_ = NULL;
	guint16 _tmp10_ = 0U;
	DVBChannelList* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	gboolean _tmp13_ = FALSE;
	DVBChannel* dvb_channel = NULL;
	DVBChannelList* _tmp15_ = NULL;
	guint _tmp16_ = 0U;
	DVBChannel* _tmp17_ = NULL;
	GstMpegtsPMTStream* stream = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	_tmp0_ = dvb_scanner_log;
	_tmp1_ = section;
	_tmp2_ = _tmp1_->version_number;
	_tmp3_ = section;
	_tmp4_ = _tmp3_->section_number;
	_tmp5_ = section;
	_tmp6_ = _tmp5_->last_section_number;
	dvb_logging_logger_debug (_tmp0_, "Scanner.vala:741: Received PMT, version %d, section number %d, last se" \
"ction number %d", (gint) _tmp2_, (gint) _tmp4_, (gint) _tmp6_);
	_tmp7_ = section;
	_tmp8_ = gst_mpegts_section_get_pmt (_tmp7_);
	pmt = _tmp8_;
	_tmp9_ = pmt;
	_tmp10_ = _tmp9_->program_number;
	program_number = (guint) _tmp10_;
	_tmp11_ = self->channels;
	_tmp12_ = program_number;
	_tmp13_ = dvb_channel_list_contains (_tmp11_, _tmp12_);
	if (!_tmp13_) {
		guint _tmp14_ = 0U;
		_tmp14_ = program_number;
		dvb_scanner_add_new_channel (self, _tmp14_);
	}
	_tmp15_ = self->channels;
	_tmp16_ = program_number;
	_tmp17_ = dvb_channel_list_get_channel (_tmp15_, _tmp16_);
	dvb_channel = _tmp17_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp18_ = FALSE;
			_tmp18_ = TRUE;
			while (TRUE) {
				gint _tmp20_ = 0;
				GstMpegtsPMT* _tmp21_ = NULL;
				GPtrArray* _tmp22_ = NULL;
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
				GstMpegtsPMT* _tmp25_ = NULL;
				GPtrArray* _tmp26_ = NULL;
				gint _tmp27_ = 0;
				gconstpointer _tmp28_ = NULL;
				GstMpegtsPMTStream* _tmp29_ = NULL;
				guint pid = 0U;
				GstMpegtsPMTStream* _tmp30_ = NULL;
				guint16 _tmp31_ = 0U;
				GstMpegtsPMTStream* _tmp32_ = NULL;
				guint8 _tmp33_ = 0U;
				if (!_tmp18_) {
					gint _tmp19_ = 0;
					_tmp19_ = i;
					i = _tmp19_ + 1;
				}
				_tmp18_ = FALSE;
				_tmp20_ = i;
				_tmp21_ = pmt;
				_tmp22_ = _tmp21_->streams;
				_tmp23_ = g_ptr_array_get_length (_tmp22_);
				_tmp24_ = _tmp23_;
				if (!(_tmp20_ < _tmp24_)) {
					break;
				}
				_tmp25_ = pmt;
				_tmp26_ = _tmp25_->streams;
				_tmp27_ = i;
				_tmp28_ = g_ptr_array_index (_tmp26_, (guint) _tmp27_);
				_tmp29_ = __vala_GstMpegtsPMTStream_copy0 ((GstMpegtsPMTStream*) _tmp28_);
				__vala_GstMpegtsPMTStream_free0 (stream);
				stream = _tmp29_;
				_tmp30_ = stream;
				_tmp31_ = _tmp30_->pid;
				pid = (guint) _tmp31_;
				_tmp32_ = stream;
				_tmp33_ = _tmp32_->stream_type;
				switch (_tmp33_) {
					case GST_MPEGTS_STREAM_TYPE_VIDEO_MPEG1:
					case GST_MPEGTS_STREAM_TYPE_VIDEO_MPEG2:
					case GST_MPEGTS_STREAM_TYPE_VIDEO_H264:
					{
						DVBLoggingLogger* _tmp34_ = NULL;
						guint _tmp35_ = 0U;
						guint _tmp36_ = 0U;
						DVBChannel* _tmp37_ = NULL;
						guint _tmp38_ = 0U;
						_tmp34_ = dvb_scanner_log;
						_tmp35_ = pid;
						_tmp36_ = program_number;
						dvb_logging_logger_debug (_tmp34_, "Scanner.vala:764: Found video PID 0x%04x for channel 0x%04x", _tmp35_, _tmp36_);
						_tmp37_ = dvb_channel;
						_tmp38_ = pid;
						dvb_channel_set_VideoPID (_tmp37_, _tmp38_);
						break;
					}
					case GST_MPEGTS_STREAM_TYPE_AUDIO_MPEG1:
					case GST_MPEGTS_STREAM_TYPE_AUDIO_MPEG2:
					case GST_MPEGTS_STREAM_TYPE_AUDIO_AAC_ADTS:
					case GST_MPEGTS_STREAM_TYPE_AUDIO_AAC_LATM:
					case 0x81:
					case 0x87:
					{
						DVBLoggingLogger* _tmp39_ = NULL;
						guint _tmp40_ = 0U;
						guint _tmp41_ = 0U;
						DVBChannel* _tmp42_ = NULL;
						GeeList* _tmp43_ = NULL;
						GeeList* _tmp44_ = NULL;
						guint _tmp45_ = 0U;
						gboolean _tmp46_ = FALSE;
						_tmp39_ = dvb_scanner_log;
						_tmp40_ = pid;
						_tmp41_ = program_number;
						dvb_logging_logger_debug (_tmp39_, "Scanner.vala:774: Found audio PID 0x%04x for channel 0x%04x", _tmp40_, _tmp41_);
						_tmp42_ = dvb_channel;
						_tmp43_ = dvb_channel_get_AudioPIDs (_tmp42_);
						_tmp44_ = _tmp43_;
						_tmp45_ = pid;
						_tmp46_ = gee_collection_contains ((GeeCollection*) _tmp44_, (gpointer) ((guintptr) _tmp45_));
						if (!_tmp46_) {
							DVBChannel* _tmp47_ = NULL;
							GeeList* _tmp48_ = NULL;
							GeeList* _tmp49_ = NULL;
							guint _tmp50_ = 0U;
							_tmp47_ = dvb_channel;
							_tmp48_ = dvb_channel_get_AudioPIDs (_tmp47_);
							_tmp49_ = _tmp48_;
							_tmp50_ = pid;
							gee_collection_add ((GeeCollection*) _tmp49_, (gpointer) ((guintptr) _tmp50_));
						}
						break;
					}
					case GST_MPEGTS_STREAM_TYPE_PRIVATE_PES_PACKETS:
					{
						gboolean _tmp51_ = FALSE;
						gboolean _tmp52_ = FALSE;
						GstMpegtsPMTStream* _tmp53_ = NULL;
						GPtrArray* _tmp54_ = NULL;
						GstMpegtsDescriptor* _tmp55_ = NULL;
						_tmp53_ = stream;
						_tmp54_ = _tmp53_->descriptors;
						_tmp55_ = gst_mpegts_find_descriptor (_tmp54_, (guint8) GST_MTS_DESC_DVB_DTS);
						if (_tmp55_ != NULL) {
							_tmp52_ = TRUE;
						} else {
							GstMpegtsPMTStream* _tmp56_ = NULL;
							GPtrArray* _tmp57_ = NULL;
							GstMpegtsDescriptor* _tmp58_ = NULL;
							_tmp56_ = stream;
							_tmp57_ = _tmp56_->descriptors;
							_tmp58_ = gst_mpegts_find_descriptor (_tmp57_, (guint8) GST_MTS_DESC_DVB_AC3);
							_tmp52_ = _tmp58_ != NULL;
						}
						if (_tmp52_) {
							_tmp51_ = TRUE;
						} else {
							GstMpegtsPMTStream* _tmp59_ = NULL;
							GPtrArray* _tmp60_ = NULL;
							GstMpegtsDescriptor* _tmp61_ = NULL;
							_tmp59_ = stream;
							_tmp60_ = _tmp59_->descriptors;
							_tmp61_ = gst_mpegts_find_descriptor (_tmp60_, (guint8) GST_MTS_DESC_DVB_ENHANCED_AC3);
							_tmp51_ = _tmp61_ != NULL;
						}
						if (_tmp51_) {
							DVBLoggingLogger* _tmp62_ = NULL;
							guint _tmp63_ = 0U;
							guint _tmp64_ = 0U;
							DVBChannel* _tmp65_ = NULL;
							GeeList* _tmp66_ = NULL;
							GeeList* _tmp67_ = NULL;
							guint _tmp68_ = 0U;
							gboolean _tmp69_ = FALSE;
							_tmp62_ = dvb_scanner_log;
							_tmp63_ = pid;
							_tmp64_ = program_number;
							dvb_logging_logger_debug (_tmp62_, "Scanner.vala:785: Found audio PID 0x%04x for channel 0x%04x", _tmp63_, _tmp64_);
							_tmp65_ = dvb_channel;
							_tmp66_ = dvb_channel_get_AudioPIDs (_tmp65_);
							_tmp67_ = _tmp66_;
							_tmp68_ = pid;
							_tmp69_ = gee_collection_contains ((GeeCollection*) _tmp67_, (gpointer) ((guintptr) _tmp68_));
							if (!_tmp69_) {
								DVBChannel* _tmp70_ = NULL;
								GeeList* _tmp71_ = NULL;
								GeeList* _tmp72_ = NULL;
								guint _tmp73_ = 0U;
								_tmp70_ = dvb_channel;
								_tmp71_ = dvb_channel_get_AudioPIDs (_tmp70_);
								_tmp72_ = _tmp71_;
								_tmp73_ = pid;
								gee_collection_add ((GeeCollection*) _tmp72_, (gpointer) ((guintptr) _tmp73_));
							}
						}
						break;
					}
					default:
					{
						DVBLoggingLogger* _tmp74_ = NULL;
						GstMpegtsPMTStream* _tmp75_ = NULL;
						guint8 _tmp76_ = 0U;
						_tmp74_ = dvb_scanner_log;
						_tmp75_ = stream;
						_tmp76_ = _tmp75_->stream_type;
						dvb_logging_logger_debug (_tmp74_, "Scanner.vala:793: Other stream type: 0x%04x", (guint) _tmp76_);
						break;
					}
				}
			}
		}
	}
	self->priv->pmt_arrived = TRUE;
	__vala_GstMpegtsPMTStream_free0 (stream);
	_g_object_unref0 (dvb_channel);
}


static void _vala_GstMpegtsSection_free (GstMpegtsSection* self) {
	g_boxed_free (gst_mpegts_section_get_type (), self);
}


gboolean dvb_scanner_bus_watch_func (DVBScanner* self, GstBus* bus, GstMessage* message) {
	gboolean result = FALSE;
	GstMessage* _tmp0_ = NULL;
	GstMessageType _tmp1_ = 0;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp96_ = FALSE;
	gboolean _tmp97_ = FALSE;
	gboolean _tmp98_ = FALSE;
	gboolean _tmp99_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = message;
	_tmp1_ = _tmp0_->type;
	switch (_tmp1_) {
		case GST_MESSAGE_ELEMENT:
		{
			{
				GstMpegtsSection* section = NULL;
				GstMessage* _tmp2_ = NULL;
				GstMpegtsSection* _tmp3_ = NULL;
				GstMpegtsSection* _tmp4_ = NULL;
				_tmp2_ = message;
				_tmp3_ = gst_message_parse_mpegts_section (_tmp2_);
				section = _tmp3_;
				_tmp4_ = section;
				if (_tmp4_ == NULL) {
					GstStructure* structure = NULL;
					GstMessage* _tmp5_ = NULL;
					GstStructure* _tmp6_ = NULL;
					gchar* structure_name = NULL;
					GstStructure* _tmp7_ = NULL;
					const gchar* _tmp8_ = NULL;
					gchar* _tmp9_ = NULL;
					const gchar* _tmp10_ = NULL;
					_tmp5_ = message;
					_tmp6_ = gst_message_get_structure (_tmp5_);
					structure = _tmp6_;
					_tmp7_ = structure;
					_tmp8_ = gst_structure_get_name (_tmp7_);
					_tmp9_ = g_strdup (_tmp8_);
					structure_name = _tmp9_;
					_tmp10_ = structure_name;
					if (g_strcmp0 (_tmp10_, "dvb-frontend-stats") == 0) {
						GstStructure* _tmp11_ = NULL;
						_tmp11_ = structure;
						dvb_scanner_on_dvb_frontend_stats_structure (self, _tmp11_);
					} else {
						const gchar* _tmp12_ = NULL;
						_tmp12_ = structure_name;
						if (g_strcmp0 (_tmp12_, "dvb-read-failure") == 0) {
							dvb_scanner_on_dvb_read_failure_structure (self);
						} else {
							result = TRUE;
							_g_free0 (structure_name);
							__vala_GstMpegtsSection_free0 (section);
							return result;
						}
					}
					_g_free0 (structure_name);
				} else {
					GstMpegtsSection* _tmp13_ = NULL;
					GstMpegtsSectionType _tmp14_ = 0;
					_tmp13_ = section;
					_tmp14_ = _tmp13_->section_type;
					switch (_tmp14_) {
						case GST_MPEGTS_SECTION_PAT:
						{
							{
								GstMpegtsSection* _tmp15_ = NULL;
								_tmp15_ = section;
								dvb_scanner_on_pat_structure (self, _tmp15_);
								break;
							}
						}
						case GST_MPEGTS_SECTION_PMT:
						{
							{
								GstMpegtsSection* _tmp16_ = NULL;
								_tmp16_ = section;
								dvb_scanner_on_pmt_structure (self, _tmp16_);
								break;
							}
						}
						case GST_MPEGTS_SECTION_NIT:
						{
							{
								GstMpegtsSection* _tmp17_ = NULL;
								_tmp17_ = section;
								dvb_scanner_on_nit_structure (self, _tmp17_);
								break;
							}
						}
						case GST_MPEGTS_SECTION_SDT:
						{
							{
								GstMpegtsSection* _tmp18_ = NULL;
								_tmp18_ = section;
								dvb_scanner_on_sdt_structure (self, _tmp18_);
								break;
							}
						}
						default:
						{
							{
								result = TRUE;
								__vala_GstMpegtsSection_free0 (section);
								return result;
							}
						}
					}
				}
				__vala_GstMpegtsSection_free0 (section);
				break;
			}
		}
		case GST_MESSAGE_ERROR:
		{
			{
				GError* gerror = NULL;
				gchar* debug = NULL;
				GstMessage* _tmp19_ = NULL;
				GError* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				DVBLoggingLogger* _tmp22_ = NULL;
				GError* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				const gchar* _tmp25_ = NULL;
				_tmp19_ = message;
				gst_message_parse_error (_tmp19_, &_tmp20_, &_tmp21_);
				_g_error_free0 (gerror);
				gerror = _tmp20_;
				_g_free0 (debug);
				debug = _tmp21_;
				_tmp22_ = dvb_scanner_log;
				_tmp23_ = gerror;
				_tmp24_ = _tmp23_->message;
				_tmp25_ = debug;
				dvb_logging_logger_warning (_tmp22_, "Scanner.vala:845: %s %s", _tmp24_, _tmp25_);
				result = TRUE;
				_g_free0 (debug);
				_g_error_free0 (gerror);
				return result;
			}
		}
		default:
		{
			result = TRUE;
			return result;
		}
	}
	_tmp29_ = self->priv->nit_arrived;
	if (_tmp29_) {
		gboolean _tmp30_ = FALSE;
		_tmp30_ = self->priv->sdt_arrived;
		_tmp28_ = _tmp30_;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		gboolean _tmp31_ = FALSE;
		_tmp31_ = self->priv->pat_arrived;
		_tmp27_ = _tmp31_;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		gboolean _tmp32_ = FALSE;
		_tmp32_ = self->priv->pmt_arrived;
		_tmp26_ = _tmp32_;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		{
			GeeArrayList* _tmp33_ = NULL;
			_tmp33_ = self->priv->new_channels;
			g_rec_mutex_lock (&self->priv->__lock_new_channels);
			{
				GeeArrayList* del_channels = NULL;
				GeeArrayList* _tmp34_ = NULL;
				_tmp34_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
				del_channels = _tmp34_;
				{
					GeeArrayList* _sid_list = NULL;
					GeeArrayList* _tmp35_ = NULL;
					GeeArrayList* _tmp36_ = NULL;
					gint _sid_size = 0;
					GeeArrayList* _tmp37_ = NULL;
					gint _tmp38_ = 0;
					gint _tmp39_ = 0;
					gint _sid_index = 0;
					_tmp35_ = self->priv->new_channels;
					_tmp36_ = _g_object_ref0 (_tmp35_);
					_sid_list = _tmp36_;
					_tmp37_ = _sid_list;
					_tmp38_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp37_);
					_tmp39_ = _tmp38_;
					_sid_size = _tmp39_;
					_sid_index = -1;
					while (TRUE) {
						gint _tmp40_ = 0;
						gint _tmp41_ = 0;
						gint _tmp42_ = 0;
						guint sid = 0U;
						GeeArrayList* _tmp43_ = NULL;
						gint _tmp44_ = 0;
						gpointer _tmp45_ = NULL;
						DVBChannel* channel = NULL;
						DVBChannelList* _tmp46_ = NULL;
						guint _tmp47_ = 0U;
						DVBChannel* _tmp48_ = NULL;
						DVBChannel* _tmp49_ = NULL;
						gboolean _tmp50_ = FALSE;
						_tmp40_ = _sid_index;
						_sid_index = _tmp40_ + 1;
						_tmp41_ = _sid_index;
						_tmp42_ = _sid_size;
						if (!(_tmp41_ < _tmp42_)) {
							break;
						}
						_tmp43_ = _sid_list;
						_tmp44_ = _sid_index;
						_tmp45_ = gee_abstract_list_get ((GeeAbstractList*) _tmp43_, _tmp44_);
						sid = (guint) ((guintptr) _tmp45_);
						_tmp46_ = self->channels;
						_tmp47_ = sid;
						_tmp48_ = dvb_channel_list_get_channel (_tmp46_, _tmp47_);
						channel = _tmp48_;
						_tmp49_ = channel;
						_tmp50_ = dvb_channel_is_valid (_tmp49_);
						if (_tmp50_) {
							const gchar* _tmp51_ = NULL;
							DVBChannel* _tmp52_ = NULL;
							gboolean _tmp53_ = FALSE;
							gchar* type = NULL;
							gchar* _tmp54_ = NULL;
							DVBLoggingLogger* _tmp55_ = NULL;
							DVBChannel* _tmp56_ = NULL;
							const gchar* _tmp57_ = NULL;
							const gchar* _tmp58_ = NULL;
							DVBChannel* _tmp59_ = NULL;
							DVBParameter* _tmp60_ = NULL;
							DVBParameter* _tmp61_ = NULL;
							guint _tmp62_ = 0U;
							guint _tmp63_ = 0U;
							guint _tmp64_ = 0U;
							DVBChannel* _tmp65_ = NULL;
							const gchar* _tmp66_ = NULL;
							const gchar* _tmp67_ = NULL;
							DVBChannel* _tmp68_ = NULL;
							const gchar* _tmp69_ = NULL;
							const gchar* _tmp70_ = NULL;
							const gchar* _tmp71_ = NULL;
							DVBChannel* _tmp72_ = NULL;
							gboolean _tmp73_ = FALSE;
							gboolean _tmp74_ = FALSE;
							GeeArrayList* _tmp75_ = NULL;
							guint _tmp76_ = 0U;
							_tmp52_ = channel;
							_tmp53_ = dvb_channel_is_radio (_tmp52_);
							if (_tmp53_) {
								_tmp51_ = "Radio";
							} else {
								_tmp51_ = "TV";
							}
							_tmp54_ = g_strdup (_tmp51_);
							type = _tmp54_;
							_tmp55_ = dvb_scanner_log;
							_tmp56_ = channel;
							_tmp57_ = dvb_channel_get_Name (_tmp56_);
							_tmp58_ = _tmp57_;
							dvb_logging_logger_debug (_tmp55_, "Scanner.vala:864: Channel added: %s", _tmp58_);
							_tmp59_ = channel;
							_tmp60_ = dvb_channel_get_Param (_tmp59_);
							_tmp61_ = _tmp60_;
							_tmp62_ = dvb_parameter_get_Frequency (_tmp61_);
							_tmp63_ = _tmp62_;
							_tmp64_ = sid;
							_tmp65_ = channel;
							_tmp66_ = dvb_channel_get_Name (_tmp65_);
							_tmp67_ = _tmp66_;
							_tmp68_ = channel;
							_tmp69_ = dvb_channel_get_Network (_tmp68_);
							_tmp70_ = _tmp69_;
							_tmp71_ = type;
							_tmp72_ = channel;
							_tmp73_ = dvb_channel_get_Scrambled (_tmp72_);
							_tmp74_ = _tmp73_;
							g_signal_emit_by_name ((DVBIDBusScanner*) self, "channel-added", _tmp63_, _tmp64_, _tmp67_, _tmp70_, _tmp71_, _tmp74_);
							_tmp75_ = del_channels;
							_tmp76_ = sid;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp75_, (gpointer) ((guintptr) _tmp76_));
							_g_free0 (type);
						} else {
							DVBLoggingLogger* _tmp77_ = NULL;
							guint _tmp78_ = 0U;
							DVBChannel* _tmp79_ = NULL;
							gchar* _tmp80_ = NULL;
							gchar* _tmp81_ = NULL;
							_tmp77_ = dvb_scanner_log;
							_tmp78_ = sid;
							_tmp79_ = channel;
							_tmp80_ = dvb_channel_to_string (_tmp79_);
							_tmp81_ = _tmp80_;
							dvb_logging_logger_debug (_tmp77_, "Scanner.vala:871: Channel 0x%x is not valid: %s", _tmp78_, _tmp81_);
							_g_free0 (_tmp81_);
							self->priv->pmt_arrived = FALSE;
						}
						_g_object_unref0 (channel);
					}
					_g_object_unref0 (_sid_list);
				}
				{
					GeeArrayList* _sid_list = NULL;
					GeeArrayList* _tmp82_ = NULL;
					GeeArrayList* _tmp83_ = NULL;
					gint _sid_size = 0;
					GeeArrayList* _tmp84_ = NULL;
					gint _tmp85_ = 0;
					gint _tmp86_ = 0;
					gint _sid_index = 0;
					_tmp82_ = del_channels;
					_tmp83_ = _g_object_ref0 (_tmp82_);
					_sid_list = _tmp83_;
					_tmp84_ = _sid_list;
					_tmp85_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp84_);
					_tmp86_ = _tmp85_;
					_sid_size = _tmp86_;
					_sid_index = -1;
					while (TRUE) {
						gint _tmp87_ = 0;
						gint _tmp88_ = 0;
						gint _tmp89_ = 0;
						guint sid = 0U;
						GeeArrayList* _tmp90_ = NULL;
						gint _tmp91_ = 0;
						gpointer _tmp92_ = NULL;
						GeeArrayList* _tmp93_ = NULL;
						guint _tmp94_ = 0U;
						_tmp87_ = _sid_index;
						_sid_index = _tmp87_ + 1;
						_tmp88_ = _sid_index;
						_tmp89_ = _sid_size;
						if (!(_tmp88_ < _tmp89_)) {
							break;
						}
						_tmp90_ = _sid_list;
						_tmp91_ = _sid_index;
						_tmp92_ = gee_abstract_list_get ((GeeAbstractList*) _tmp90_, _tmp91_);
						sid = (guint) ((guintptr) _tmp92_);
						_tmp93_ = self->priv->new_channels;
						_tmp94_ = sid;
						gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp93_, (gpointer) ((guintptr) _tmp94_));
					}
					_g_object_unref0 (_sid_list);
				}
				_g_object_unref0 (del_channels);
			}
			__finally161:
			{
				GeeArrayList* _tmp95_ = NULL;
				_tmp95_ = self->priv->new_channels;
				g_rec_mutex_unlock (&self->priv->__lock_new_channels);
			}
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	_tmp99_ = self->priv->sdt_arrived;
	if (_tmp99_) {
		gboolean _tmp100_ = FALSE;
		_tmp100_ = self->priv->nit_arrived;
		_tmp98_ = _tmp100_;
	} else {
		_tmp98_ = FALSE;
	}
	if (_tmp98_) {
		gboolean _tmp101_ = FALSE;
		_tmp101_ = self->priv->pat_arrived;
		_tmp97_ = _tmp101_;
	} else {
		_tmp97_ = FALSE;
	}
	if (_tmp97_) {
		gboolean _tmp102_ = FALSE;
		_tmp102_ = self->priv->pmt_arrived;
		_tmp96_ = _tmp102_;
	} else {
		_tmp96_ = FALSE;
	}
	if (_tmp96_) {
		dvb_scanner_remove_wait_for_tables_timeout (self);
		dvb_scanner_queue_start_scan (self);
	}
	result = TRUE;
	return result;
}


static void dvb_scanner_add_new_channel (DVBScanner* self, guint sid) {
	DVBLoggingLogger* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	DVBChannel* new_channel = NULL;
	DVBChannel* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	DVBParameter* _tmp4_ = NULL;
	DVBChannelList* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = dvb_scanner_log;
	_tmp1_ = sid;
	dvb_logging_logger_debug (_tmp0_, "Scanner.vala:897: Adding new channel with SID 0x%x", _tmp1_);
	_tmp2_ = dvb_channel_new_without_schedule ();
	new_channel = _tmp2_;
	_tmp3_ = sid;
	dvb_channel_set_Sid (new_channel, _tmp3_);
	_tmp4_ = self->priv->current_scanning_param;
	dvb_channel_set_Param (new_channel, _tmp4_);
	_tmp5_ = self->channels;
	dvb_channel_list_add (_tmp5_, new_channel);
	{
		GeeArrayList* _tmp6_ = NULL;
		_tmp6_ = self->priv->new_channels;
		g_rec_mutex_lock (&self->priv->__lock_new_channels);
		{
			GeeArrayList* _tmp7_ = NULL;
			guint _tmp8_ = 0U;
			_tmp7_ = self->priv->new_channels;
			_tmp8_ = sid;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, (gpointer) ((guintptr) _tmp8_));
		}
		__finally162:
		{
			GeeArrayList* _tmp9_ = NULL;
			_tmp9_ = self->priv->new_channels;
			g_rec_mutex_unlock (&self->priv->__lock_new_channels);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (new_channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (new_channel);
}


DVBDevice* dvb_scanner_get_Device (DVBScanner* self) {
	DVBDevice* result;
	DVBDevice* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_Device;
	result = _tmp0_;
	return result;
}


static void dvb_scanner_set_Device (DVBScanner* self, DVBDevice* value) {
	DVBDevice* _tmp0_ = NULL;
	DVBDevice* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_Device);
	self->priv->_Device = _tmp1_;
	g_object_notify ((GObject *) self, "Device");
}


DVBChannelList* dvb_scanner_get_Channels (DVBScanner* self) {
	DVBChannelList* result;
	DVBChannelList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->channels;
	result = _tmp0_;
	return result;
}


DVBAdapterType dvb_scanner_get_Type (DVBScanner* self) {
	DVBAdapterType result;
	DVBAdapterType _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_Type;
	result = _tmp0_;
	return result;
}


static void dvb_scanner_set_Type (DVBScanner* self, DVBAdapterType value) {
	DVBAdapterType _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_Type = _tmp0_;
	g_object_notify ((GObject *) self, "Type");
}


static GObject * dvb_scanner_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBScanner * self;
	GeeHashSet* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	GQueue* _tmp2_ = NULL;
	GMainContext* _tmp3_ = NULL;
	parent_class = G_OBJECT_CLASS (dvb_scanner_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_TYPE_SCANNER, DVBScanner);
	_tmp0_ = gee_hash_set_new (DVB_TYPE_PARAMETER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->scanned_scanning_params);
	self->priv->scanned_scanning_params = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->new_channels);
	self->priv->new_channels = _tmp1_;
	_tmp2_ = g_queue_new ();
	__g_queue_free__g_object_unref0_0 (self->priv->queue_scanning_params);
	self->priv->queue_scanning_params = _tmp2_;
	_tmp3_ = g_main_context_new ();
	_g_main_context_unref0 (self->priv->context);
	self->priv->context = _tmp3_;
	self->priv->running = FALSE;
	return obj;
}


static void dvb_scanner_class_init (DVBScannerClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBScannerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_scanner_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_scanner_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_scanner_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_scanner_finalize;
	/**
	         * The DVB device the scanner should use
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SCANNER_DEVICE, g_param_spec_object ("Device", "Device", "Device", DVB_TYPE_DEVICE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SCANNER_CHANNELS, g_param_spec_object ("Channels", "Channels", "Channels", DVB_TYPE_CHANNEL_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SCANNER_TYPE, g_param_spec_enum ("Type", "Type", "Type", DVB_TYPE_ADAPTER_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	         * Emitted when the Destroy () method is called
	         */
	g_signal_new ("destroyed", DVB_TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_scanner_log = _tmp1_;
}


static void dvb_scanner_dvb_id_bus_scanner_interface_init (DVBIDBusScannerIface * iface) {
	dvb_scanner_dvb_id_bus_scanner_parent_iface = g_type_interface_peek_parent (iface);
	iface->Run = (void (*)(DVBIDBusScanner*, GError**)) dvb_scanner_real_Run;
	iface->Destroy = (void (*)(DVBIDBusScanner*, GError**)) dvb_scanner_real_Destroy;
	iface->AddScanningData = (gboolean (*)(DVBIDBusScanner*, GHashTable*, GError**)) dvb_scanner_real_AddScanningData;
	iface->WriteAllChannelsToFile = (gboolean (*)(DVBIDBusScanner*, const gchar*, GError**)) dvb_scanner_real_WriteAllChannelsToFile;
	iface->WriteChannelsToFile = (gboolean (*)(DVBIDBusScanner*, guint*, int, const gchar*, GError**)) dvb_scanner_real_WriteChannelsToFile;
	iface->AddScanningDataFromFile = (gboolean (*)(DVBIDBusScanner*, const gchar*, GError**)) dvb_scanner_real_AddScanningDataFromFile;
}


static void dvb_scanner_instance_init (DVBScanner * self) {
	self->priv = DVB_SCANNER_GET_PRIVATE (self);
	g_rec_mutex_init (&self->priv->__lock_channels);
	g_rec_mutex_init (&self->priv->__lock_new_channels);
}


static void dvb_scanner_finalize (GObject* obj) {
	DVBScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_TYPE_SCANNER, DVBScanner);
	_g_object_unref0 (self->priv->_Device);
	g_rec_mutex_clear (&self->priv->__lock_channels);
	_g_object_unref0 (self->channels);
	_g_object_unref0 (self->pipeline);
	__g_queue_free__g_object_unref0_0 (self->priv->queue_scanning_params);
	_g_object_unref0 (self->priv->current_scanning_param);
	_g_object_unref0 (self->priv->scanned_scanning_params);
	g_rec_mutex_clear (&self->priv->__lock_new_channels);
	_g_object_unref0 (self->priv->new_channels);
	_g_source_unref0 (self->priv->check_for_lock_source);
	_g_source_unref0 (self->priv->wait_for_tables_source);
	_g_source_unref0 (self->priv->start_scan_source);
	_g_main_context_unref0 (self->priv->context);
	_g_main_loop_unref0 (self->priv->loop);
	_g_thread_unref0 (self->priv->worker_thread);
	G_OBJECT_CLASS (dvb_scanner_parent_class)->finalize (obj);
}


/**
     * A class responsible for scanning for new channels
     */
GType dvb_scanner_get_type (void) {
	static volatile gsize dvb_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBScanner), 0, (GInstanceInitFunc) dvb_scanner_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_scanner_info = { (GInterfaceInitFunc) dvb_scanner_dvb_id_bus_scanner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_scanner_type_id;
		dvb_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBScanner", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_scanner_type_id, DVB_TYPE_ID_BUS_SCANNER, &dvb_id_bus_scanner_info);
		g_once_init_leave (&dvb_scanner_type_id__volatile, dvb_scanner_type_id);
	}
	return dvb_scanner_type_id__volatile;
}


static void _vala_dvb_scanner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DVB_TYPE_SCANNER, DVBScanner);
	switch (property_id) {
		case DVB_SCANNER_DEVICE:
		g_value_set_object (value, dvb_scanner_get_Device (self));
		break;
		case DVB_SCANNER_CHANNELS:
		g_value_set_object (value, dvb_scanner_get_Channels (self));
		break;
		case DVB_SCANNER_TYPE:
		g_value_set_enum (value, dvb_scanner_get_Type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_scanner_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DVB_TYPE_SCANNER, DVBScanner);
	switch (property_id) {
		case DVB_SCANNER_DEVICE:
		dvb_scanner_set_Device (self, g_value_get_object (value));
		break;
		case DVB_SCANNER_TYPE:
		dvb_scanner_set_Type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



