/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This package contains interfaces for {@link com.gs.collections.api.partition.set.sorted.PartitionSortedSet}.
 * <p>
 *     A PartitionSortedSet is the result of splitting a sorted set into two sorted sets based on a Predicate.
 * </p>
 * <p>
 *      This package contains the following interfaces:
 * <ul>
 *     <li>
 *         {@link com.gs.collections.api.partition.set.sorted.PartitionSortedSet} - a Read-only PartitionSortedSet API.
 *     </li>
 *     <li>
 *         {@link com.gs.collections.api.partition.set.sorted.PartitionMutableSortedSet} - a modifiable PartitionSortedSet.
 *     </li>
 *     <li>
 *         {@link com.gs.collections.api.partition.set.sorted.PartitionImmutableSortedSet} - the non-modifiable equivalent interface to {@link com.gs.collections.api.partition.set.sorted.PartitionMutableSortedSet}.
 *     </li>
 * </ul>
 * </p>
 */
package com.gs.collections.api.partition.set.sorted;
