//**************************************************************************************************
//                                         CmdGnuCapPR.hpp                                         *
//                                        -----------------                                        *
// Description : This class contains values associated with the GNU-Cap PRINT command. It inherits *
//               from the class CmdBase.                                                           *
// Started     : 2008-03-17                                                                        *
// Last Update : 2015-03-07                                                                        *
// Copyright   : (C) 2008 by MSWaters                                                              *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#ifndef CMDGCPPR_HPP
#define CMDGCPPR_HPP

// Application Includes

#include "TypeDefs.hpp"
#include "base/CmdBase.hpp"
#include "netlist/Component.hpp"
#include "netlist/NetList.hpp"
#include "ngspice/commands/CmdNgSpicePR.hpp"

class CmdNgSpicePR;

//**************************************************************************************************

class CmdGnuCapPR : public CmdBase
{
  private :

         eTypeCmd  m_eAnaType;

    virtual  bool  bValidate( void );

  public :

    wxArrayString  m_osaNodes;
    wxArrayString  m_osaCpnts;
    bool           m_bParams[ ePARAM_LST+1 ];
    bool           m_bCpxPts[ eCPXPT_LST+1 ];

                   CmdGnuCapPR( void );
    virtual       ~CmdGnuCapPR( );

    virtual  bool  bSetDefaults( void );
             bool  bSetAnaType ( eTypeCmd eAnaType );

         eTypeCmd  eGetAnaType( void ) const { return( m_eAnaType ); }

    virtual  bool  bParse ( void );
    virtual  bool  bFormat( void );

     CmdGnuCapPR & operator = ( const CmdNgSpicePR & roCmdPR );

             void  Print( const wxString & rosPrefix=wxT("  ") );
};

//**************************************************************************************************

#endif // CMDGCPPR_HPP
