Hedgewars - a turn-based strategy game
======================================

Description
-----------
This is the funniest and most addictive game you'll ever play—hilarious fun
that you can enjoy anywhere, anytime. **Hedgewars** is a **turn-based strategy
game** but the real buzz is from watching the **devastation caused by those
pesky hedgehogs** with those fantastic weapons—sneaky little blighters with
a bad attitude!

Each player controls a **team of up to 8 hedgehogs**. During the course of
the game, players take turns with one of their hedgehogs. They then use
whatever tools and weapons are available to **attack and kill the opponents'
hedgehogs**, thereby winning the game.

To destroy your foes you can use one out of **over 40 weapons**!
Launch bazookas or homing bees, drop mines, dynamite or explosive rubber ducks,
throw grenades or watermelon bombs, poison them with stinky cheese, send them
flying with a baseball bat, and much more!

Most weapons cause **explosions that deform the terrain**, removing
circular chunks. Hedgehogs can die by drowning, being thrown off
either side of the arena, or when their health is reduced to zero.

Hedgehogs may move around the terrain in a variety of ways, normally by
walking and jumping but also by using particular tools such as the rope
or parachute, to move to otherwise inaccessible areas. Each **turn is
time-limited** to ensure that players do not hold up the game with
excessive thinking or moving.

Getting started
---------------
For complete beginners we recommend to play in singleplayer mode first.
Start with the Basic Movement Training found in the training menu.
Proceed with the other training missions.
After completing the training, try to play some quick matches against the
computer (also found in the singleplayer menu).
Hedgewars has many weapons, so play a few matches to get a better feeling
for them.

In-depth information about the game can be found online:

* <https://hedgewars.org/start>: Getting Started
* <https://hedgewars.org/wiki.html>: Hedgewars Wiki

Default controls (excerpt)
--------------------------
The most important default controls are:

* Cursor keys: Walk and aim
* Mouse: Move camera
* Right mouse button: Open ammo menu
* Left mouse button: Select target or weapon
* Space bar: Shoot
* Left shift: Precise (this is a modifier key)
* Precise + Up/Down: Precise aiming
* Precise + Left/Right: Turn around without walking
* Hold down Precise: Prevent slipping on ice
* Enter: Jump
* Backspace: High jump
* Backspace ×2: Backjump
* Tab: Switch hedgehog (after activating the utility)
* 1-5: Set weapon timer
* F1-F10: Weapon shortcuts
* M: Mission panel / game mode information. Hold pressed to display, release to hide
* P: Pause, when playing offline, toggle automatic turn skipping when online
* Esc: Quit with prompt
* T: Chat
* U: Clan chat

### Default controller controls
Hedgewars also supports controllers. By default, Hedgewars sets up a few
controls for your first (!) connected controller.
This default might not be ideal, we recommend you set manual controls
in the settings menu.

* 1st D-pad: Walk and aim
* 2nd D-pad / 1st thumbstick: Move camera/cursor
* Button  1: Long jump
* Button  2: High jump
* Button  3: Attack
* Button  4: Ammo menu
* Button  5: Precise
* Button  6: Select target, or pick weapon (in ammo menu)
* Button  7: Switch hedgehog
* Button  8: Change timer
* Button  9: Find hedgehog / toggle auto camera
* Button 10: Mission panel

For the full list, go to the Hedgewars settings. Also read the weapon tooltips
for weapon-specific controls.

### Special controls

These are lesser-known controls of Hedgewars, they are based on your
configured controls:

* Precise + Toggle hedgehog tags: Change visible hedgehog tags (team name/hog name/health)
* Switch  + Toggle hedgehog tags: Toggle hedgehog tag translucency
* Precise + Toggle team bars + Switch: Toggle HUD
* Precise + Capture (screenshot key): Save current map + mask into Screenshot directory

System requirements
-------------------
For PC or Mac:

* Mouse and keyboard
* Monitor, minimal resolution 1024×768
* 200 MiB storage space
* Processor: 1 GHz (1 core is enough), 64bit recommended
* Video card: 250 MHz or so
              (any decent card from the year 2004 or later should do fine)
* 1 GiB RAM minimum
* Operating system: Windows Vista/7/8/10, GNU/Linux, macOS, FreeBSD, others

Hedgewars has been ported to other operating systems in the past.
Check out <https://hedgewars.org/download.html> for the latest information.

Gamepads are supported partially (only in-game, not in the main menu).

Installation instructions
-------------------------
See the `INSTALL.md` file.

Or see our wiki at <https://hedgewars.org/kb/BuildingHedgewars>.

Source code
-----------
Our main repository is located at <https://hg.hedgewars.org/hedgewars/> using
Mercurial as DVCS. A Git repository is also available (mirrored daily)
at <https://github.com/hedgewars/hw>.

[![Build Status](https://travis-ci.org/hedgewars/hw.svg)](https://travis-ci.org/hedgewars/hw)

Contribute
----------
If you see a bug or have any suggestion please use the official bug tracker at
<https://hedgewars.org/bugs> or the integrated feedback button.

If you want to help or get to know the sources better you can do that with some
easy tasks from <https://hedgewars.org/kb/TODO>. We also have an extensive API
in Lua to customize your adventures. See our wiki at
<https://hedgewars.org/kb/LuaAPI>.

If you know your way through the code feel free to send a patch or open a pull
request. The best Lua scripts get released in the official DLC page and later
integrated in the next version.

Licence and credits
-------------------
This game is free software (“free” as in “freedom”). Source code is
distributed under the terms of the GNU General Public Licence version 2;
images and sounds are distributed under the terms of the GNU Free Documentation
Licence version 1.2. See the `COPYING` file for the full text of the licenses.

Copyright 2004-2018 Andrey Korotaev <unC0Rr@gmail.com> and others.
See `QTfrontend/res/html/about.html` and `CREDITS` for a more complete list of
authors.

Contact
-------
* Homepage        - https://hedgewars.org/
* IRC channel     - irc://irc.freenode.net/hedgewars
* Community forum - https://hedgewars.org/forum

