; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -instsimplify -S | FileCheck %s

; fsub -0.0, (fsub -0.0, X) ==> X
define float @fsub_-0_-0_x(float %a) {
; CHECK-LABEL: @fsub_-0_-0_x(
; CHECK-NEXT:    ret float %a
;
  %t1 = fsub float -0.0, %a
  %ret = fsub float -0.0, %t1
  ret float %ret
}

; fsub 0.0, (fsub -0.0, X) != X
define float @fsub_0_-0_x(float %a) {
; CHECK-LABEL: @fsub_0_-0_x(
; CHECK-NEXT:    [[T1:%.*]] = fsub float 0.000000e+00, %a
; CHECK-NEXT:    [[RET:%.*]] = fsub float -0.000000e+00, [[T1]]
; CHECK-NEXT:    ret float [[RET]]
;
  %t1 = fsub float 0.0, %a
  %ret = fsub float -0.0, %t1
  ret float %ret
}

; fsub -0.0, (fsub 0.0, X) != X
define float @fsub_-0_0_x(float %a) {
; CHECK-LABEL: @fsub_-0_0_x(
; CHECK-NEXT:    [[T1:%.*]] = fsub float -0.000000e+00, %a
; CHECK-NEXT:    [[RET:%.*]] = fsub float 0.000000e+00, [[T1]]
; CHECK-NEXT:    ret float [[RET]]
;
  %t1 = fsub float -0.0, %a
  %ret = fsub float 0.0, %t1
  ret float %ret
}

; fsub X, 0 ==> X
define float @fsub_x_0(float %a) {
; CHECK-LABEL: @fsub_x_0(
; CHECK-NEXT:    ret float %a
;
  %ret = fsub float %a, 0.0
  ret float %ret
}

; fadd X, -0 ==> X
define float @fadd_x_n0(float %a) {
; CHECK-LABEL: @fadd_x_n0(
; CHECK-NEXT:    ret float %a
;
  %ret = fadd float %a, -0.0
  ret float %ret
}

; fmul X, 1.0 ==> X
define double @fmul_X_1(double %a) {
; CHECK-LABEL: @fmul_X_1(
; CHECK-NEXT:    ret double %a
;
  %b = fmul double 1.000000e+00, %a
  ret double %b
}

; fdiv X, 1.0 ==> X
define float @fdiv_x_1(float %a) {
; CHECK-LABEL: @fdiv_x_1(
; CHECK-NEXT:    ret float %a
;
  %ret = fdiv float %a, 1.0
  ret float %ret
}

; We can't optimize away the fadd in this test because the input
; value to the function and subsequently to the fadd may be -0.0.
; In that one special case, the result of the fadd should be +0.0
; rather than the first parameter of the fadd.

; Fragile test warning: We need 6 sqrt calls to trigger the bug
; because the internal logic has a magic recursion limit of 6.
; This is presented without any explanation or ability to customize.

declare float @sqrtf(float)

define float @PR22688(float %x) {
; CHECK-LABEL: @PR22688(
; CHECK-NEXT:    [[TMP1:%.*]] = call float @sqrtf(float %x)
; CHECK-NEXT:    [[TMP2:%.*]] = call float @sqrtf(float [[TMP1]])
; CHECK-NEXT:    [[TMP3:%.*]] = call float @sqrtf(float [[TMP2]])
; CHECK-NEXT:    [[TMP4:%.*]] = call float @sqrtf(float [[TMP3]])
; CHECK-NEXT:    [[TMP5:%.*]] = call float @sqrtf(float [[TMP4]])
; CHECK-NEXT:    [[TMP6:%.*]] = call float @sqrtf(float [[TMP5]])
; CHECK-NEXT:    [[TMP7:%.*]] = fadd float [[TMP6]], 0.000000e+00
; CHECK-NEXT:    ret float [[TMP7]]
;
  %1 = call float @sqrtf(float %x)
  %2 = call float @sqrtf(float %1)
  %3 = call float @sqrtf(float %2)
  %4 = call float @sqrtf(float %3)
  %5 = call float @sqrtf(float %4)
  %6 = call float @sqrtf(float %5)
  %7 = fadd float %6, 0.0
  ret float %7
}

declare float @llvm.fabs.f32(float)
declare float @llvm.sqrt.f32(float)

; CHECK-LABEL: @fabs_select_positive_constants(
; CHECK: %select = select i1 %cmp, float 1.000000e+00, float 2.000000e+00
; CHECK-NEXT: ret float %select
define float @fabs_select_positive_constants(i32 %c) {
  %cmp = icmp eq i32 %c, 0
  %select = select i1 %cmp, float 1.0, float 2.0
  %fabs = call float @llvm.fabs.f32(float %select)
  ret float %fabs
}

; CHECK-LABEL: @fabs_select_constant_variable(
; CHECK: %select = select i1 %cmp, float 1.000000e+00, float %x
; CHECK-NEXT: %fabs = call float @llvm.fabs.f32(float %select)
define float @fabs_select_constant_variable(i32 %c, float %x) {
  %cmp = icmp eq i32 %c, 0
  %select = select i1 %cmp, float 1.0, float %x
  %fabs = call float @llvm.fabs.f32(float %select)
  ret float %fabs
}

; CHECK-LABEL: @fabs_select_neg0_pos0(
; CHECK: %select = select i1 %cmp, float -0.000000e+00, float 0.000000e+00
; CHECK: %fabs = call float @llvm.fabs.f32(float %select)
; CHECK-NEXT: ret float %fabs
define float @fabs_select_neg0_pos0(float addrspace(1)* %out, i32 %c) {
  %cmp = icmp eq i32 %c, 0
  %select = select i1 %cmp, float -0.0, float 0.0
  %fabs = call float @llvm.fabs.f32(float %select)
  ret float %fabs
}

; CHECK-LABEL: @fabs_select_neg0_neg1(
; CHECK: %select = select i1 %cmp, float -0.000000e+00, float -1.000000e+00
; CHECK: %fabs = call float @llvm.fabs.f32(float %select)
define float @fabs_select_neg0_neg1(float addrspace(1)* %out, i32 %c) {
  %cmp = icmp eq i32 %c, 0
  %select = select i1 %cmp, float -0.0, float -1.0
  %fabs = call float @llvm.fabs.f32(float %select)
  ret float %fabs
}

; CHECK-LABEL: @fabs_select_nan_nan(
; CHECK: %select = select i1 %cmp, float 0x7FF8000000000000, float 0x7FF8000100000000
; CHECK-NEXT: ret float %select
define float @fabs_select_nan_nan(float addrspace(1)* %out, i32 %c) {
  %cmp = icmp eq i32 %c, 0
  %select = select i1 %cmp, float 0x7FF8000000000000, float 0x7FF8000100000000
  %fabs = call float @llvm.fabs.f32(float %select)
  ret float %fabs
}

; CHECK-LABEL: @fabs_select_negnan_nan(
; CHECK: %select = select i1 %cmp, float 0xFFF8000000000000, float 0x7FF8000000000000
; CHECK: %fabs = call float @llvm.fabs.f32(float %select)
define float @fabs_select_negnan_nan(float addrspace(1)* %out, i32 %c) {
  %cmp = icmp eq i32 %c, 0
  %select = select i1 %cmp, float 0xFFF8000000000000, float 0x7FF8000000000000
  %fabs = call float @llvm.fabs.f32(float %select)
  ret float %fabs
}

; CHECK-LABEL: @fabs_select_negnan_negnan(
; CHECK:  %select = select i1 %cmp, float 0xFFF8000000000000, float 0x7FF8000100000000
; CHECK: %fabs = call float @llvm.fabs.f32(float %select)
define float @fabs_select_negnan_negnan(float addrspace(1)* %out, i32 %c) {
  %cmp = icmp eq i32 %c, 0
  %select = select i1 %cmp, float 0xFFF8000000000000, float 0x7FF8000100000000
  %fabs = call float @llvm.fabs.f32(float %select)
  ret float %fabs
}

; CHECK-LABEL: @fabs_select_negnan_negzero(
; CHECK: %select = select i1 %cmp, float 0xFFF8000000000000, float -0.000000e+00
; CHECK: %fabs = call float @llvm.fabs.f32(float %select)
define float @fabs_select_negnan_negzero(float addrspace(1)* %out, i32 %c) {
  %cmp = icmp eq i32 %c, 0
  %select = select i1 %cmp, float 0xFFF8000000000000, float -0.0
  %fabs = call float @llvm.fabs.f32(float %select)
  ret float %fabs
}

; CHECK-LABEL: @fabs_select_negnan_zero(
; CHECK: %select = select i1 %cmp, float 0xFFF8000000000000, float 0.000000e+00
; CHECK: %fabs = call float @llvm.fabs.f32(float %select)
define float @fabs_select_negnan_zero(float addrspace(1)* %out, i32 %c) {
  %cmp = icmp eq i32 %c, 0
  %select = select i1 %cmp, float 0xFFF8000000000000, float 0.0
  %fabs = call float @llvm.fabs.f32(float %select)
  ret float %fabs
}

; CHECK-LABEL: @fabs_sqrt
; CHECK: call float @llvm.sqrt.f32
; CHECK: call float @llvm.fabs.f32
define float @fabs_sqrt(float %a) {
; The fabs can't be eliminated because llvm.sqrt.f32 may return -0 or NaN with
; an arbitrary sign bit.
  %sqrt = call float @llvm.sqrt.f32(float %a)
  %fabs = call float @llvm.fabs.f32(float %sqrt)
  ret float %fabs
}

; CHECK-LABEL: @fabs_sqrt_nnan
; CHECK: call nnan float @llvm.sqrt.f32
; CHECK: call float @llvm.fabs.f32
define float @fabs_sqrt_nnan(float %a) {
; The fabs can't be eliminated because the nnan sqrt may still return -0.
  %sqrt = call nnan float @llvm.sqrt.f32(float %a)
  %fabs = call float @llvm.fabs.f32(float %sqrt)
  ret float %fabs
}

; CHECK-LABEL: @fabs_sqrt_nsz
; CHECK: call nsz float @llvm.sqrt.f32
; CHECK: call float @llvm.fabs.f32
define float @fabs_sqrt_nsz(float %a) {
; The fabs can't be eliminated because the nsz sqrt may still return NaN.
  %sqrt = call nsz float @llvm.sqrt.f32(float %a)
  %fabs = call float @llvm.fabs.f32(float %sqrt)
  ret float %fabs
}

; CHECK-LABEL: @fabs_sqrt_nnan_nsz
; CHECK: call nnan nsz float @llvm.sqrt.f32
; CHECK-NOT: call float @llvm.fabs.f32
define float @fabs_sqrt_nnan_nsz(float %a) {
; The fabs can be eliminated because we're nsz and nnan.
  %sqrt = call nnan nsz float @llvm.sqrt.f32(float %a)
  %fabs = call float @llvm.fabs.f32(float %sqrt)
  ret float %fabs
}

; CHECK-LABEL: @fabs_sqrt_nnan_fabs
; CHECK: call float @llvm.fabs.f32
; CHECK: call nnan float @llvm.sqrt.f32
; CHECK-NOT: call float @llvm.fabs.f32
define float @fabs_sqrt_nnan_fabs(float %a) {
; The second fabs can be eliminated because the operand to sqrt cannot be -0.
  %b = call float @llvm.fabs.f32(float %a)
  %sqrt = call nnan float @llvm.sqrt.f32(float %b)
  %fabs = call float @llvm.fabs.f32(float %sqrt)
  ret float %fabs
}
