/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Gerben Venekamp <venekamp@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


/*!
 *  \file pdl_policy.h
 *
 *  \brief Include file for using the pdl policies.
 *
 *
 *  \author  G.M. Venekamp  (venekamp@nikhef.nl)
 *  \version $Revision: 17210 $
 *  \date    $Date: 2013-12-05 18:12:28 +0100 (Thu, 05 Dec 2013) $
 *
 */


#ifndef _PDL_POLICY_H
#define _PDL_POLICY_H

#include "pdl.h"
#include "pdl_rule.h"


/*!
 *  \brief Keeping track of found policies.
 *
 */
typedef struct policy_s {
  char* name;               /*!<  Name of the policy. */
  rule_t* rule;             /*!<  Pointer to the first rule of the policy. */
  int lineno;		    /*!<  Line number where the polict was found. */
  struct policy_s* next;    /*!<  Next policy, or 0 if none. */
  struct policy_s* prev;    /*!<  Previous policy, or 0 if none. */
} policy_t;


extern void lcmaps_add_policy(record_t* policy, rule_t* rules);
extern void lcmaps_remove_policy(record_t* name);
extern void lcmaps_show_policies(void);
extern void lcmaps_cleanup_policies(void);
extern void lcmaps_free_policies(void);
extern void lcmaps_allow_rules(BOOL allow);
extern BOOL lcmaps_check_policies_for_recursion(void);
extern void lcmaps_reduce_policies(void);
extern BOOL lcmaps_policies_have_been_reduced(void);
extern void lcmaps_SetSetOfRules(int, char**);

extern policy_t* lcmaps_find_policy(const char* name);
extern policy_t* lcmaps_get_policies(void);

/*
 *  Well, this is dirty indeed! It not the function itself that
 *  is dirty, it's the fact that it is defined in pdl_main.c instead
 *  of pdl_policy.c. It is the only way I got it compiling.
 */
extern policy_t * lcmaps_get_current_policy(void);

#endif
