/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.outline;

import java.util.List;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.lisaac.ldt.editors.ColorManager;
import org.lisaac.ldt.model.Position;
import org.lisaac.ldt.model.items.Section;
import org.lisaac.ldt.model.types.ITypeMono;
import org.lisaac.ldt.outline.OutlineImages;
import org.lisaac.ldt.outline.OutlineItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlineSection
extends OutlineItem {
    protected Section section;
    protected List<OutlineItem> slots;

    public OutlineSection(Section section) {
        this.section = section;
        this.slots = section.getOutlineItems();
        Position position = section.getPosition();
        this.fstartOffset = position.getStartOffset() - 7;
        this.fLength = 7;
    }

    @Override
    public String getText() {
        String result = "";
        if (this.section != null) {
            if (this.section.getName() != null) {
                result = this.section.getName();
            } else {
                ITypeMono[] types = this.section.getTypeList();
                int i = 0;
                while (i < types.length) {
                    result = String.valueOf(result) + types[i];
                    if (i != types.length - 1) {
                        result = String.valueOf(result) + ", ";
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    @Override
    public StyledString getStyledText() {
        StyledString result = new StyledString();
        ColorManager colors = ColorManager.getDefault();
        if (this.section != null) {
            if (this.section.getName() != null) {
                result.append(this.section.getName());
            } else {
                ITypeMono[] types = this.section.getTypeList();
                int i = 0;
                while (i < types.length) {
                    result.append(types[i].toString(), colors.getPrototypeStyler());
                    if (i != types.length - 1) {
                        result.append(", ");
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public Image getImage() {
        if (this.section != null) {
            return OutlineImages.PRIVATE_NONSHARED;
        }
        return null;
    }

    @Override
    public List<OutlineItem> getChildren() {
        return this.slots;
    }

    @Override
    public int compareTo(Object arg0) {
        return 0;
    }
}

