/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import org.gjt.jclasslib.io.Log;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;

public abstract class AbstractStructure {
    public static final String SYSTEM_PROPERTY_DEBUG = "jclasslib.io.debug";
    protected ClassFile classFile;
    protected boolean debug = Boolean.getBoolean("jclasslib.io.debug");

    protected AbstractStructure() {
    }

    public ClassFile getClassFile() {
        return this.classFile;
    }

    public void setClassFile(ClassFile classFile) {
        this.classFile = classFile;
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    protected int getLength(Object object) {
        if (object == null || !object.getClass().isArray()) {
            return 0;
        }
        return Array.getLength(object);
    }

    protected void debug(String string) {
        if (this.debug) {
            Log.debug(string);
        }
    }

    protected String printBytes(int n) {
        return this.padHexString(Integer.toHexString(n), 8);
    }

    protected String printAccessFlags(int n) {
        return this.padHexString(Integer.toHexString(n), 4);
    }

    private String padHexString(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer("0x");
        for (int i = string.length(); i < n; ++i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    protected abstract String printAccessFlagsVerbose(int var1);

    protected String printAccessFlagsVerbose(int[] nArray, String[] stringArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n2 |= nArray[i];
            if ((n & nArray[i]) == 0) continue;
            stringBuffer.append(stringArray[i]).append(' ');
        }
        if ((n2 | n) != n2) {
            stringBuffer.append("? ");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }
}

