/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper;

import com.google.caliper.MeasurementType;
import com.google.caliper.UserException;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class Arguments {
    private String suiteClassName;
    private final Set<String> userVms = Sets.newLinkedHashSet();
    private final Multimap<String, String> userParameters = LinkedHashMultimap.create();
    private final Multimap<String, String> vmParameters = LinkedHashMultimap.create();
    private int trials = 1;
    private long warmupMillis = 3000L;
    private long runMillis = 1000L;
    private String timeUnit = null;
    private String instanceUnit = null;
    private String memoryUnit = null;
    private File saveResultsFile = null;
    private File uploadResultsFile = null;
    private boolean captureVmLog = false;
    private boolean printScore = false;
    private boolean measureMemory = false;
    private boolean debug = false;
    private int debugReps = 1000;
    private MeasurementType measurementType;
    private MeasurementType primaryMeasurementType;
    private String marker = "//ZxJ/";
    private static final String defaultDelimiter = ",";
    private static final int defaultDebugReps = 1000;

    public String getSuiteClassName() {
        return this.suiteClassName;
    }

    public Set<String> getUserVms() {
        return this.userVms;
    }

    public int getTrials() {
        return this.trials;
    }

    public Multimap<String, String> getVmParameters() {
        return this.vmParameters;
    }

    public Multimap<String, String> getUserParameters() {
        return this.userParameters;
    }

    public long getWarmupMillis() {
        return this.warmupMillis;
    }

    public long getRunMillis() {
        return this.runMillis;
    }

    public String getTimeUnit() {
        return this.timeUnit;
    }

    public String getInstanceUnit() {
        return this.instanceUnit;
    }

    public String getMemoryUnit() {
        return this.memoryUnit;
    }

    public File getSaveResultsFile() {
        return this.saveResultsFile;
    }

    public File getUploadResultsFile() {
        return this.uploadResultsFile;
    }

    public boolean getCaptureVmLog() {
        return this.captureVmLog;
    }

    public boolean printScore() {
        return this.printScore;
    }

    public boolean getMeasureMemory() {
        return this.measureMemory;
    }

    public MeasurementType getMeasurementType() {
        return this.measurementType;
    }

    public MeasurementType getPrimaryMeasurementType() {
        return this.primaryMeasurementType;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public int getDebugReps() {
        return this.debugReps;
    }

    public String getMarker() {
        return this.marker;
    }

    public static Arguments parse(String[] argsArray) {
        Sets.SetView duplicates;
        Arguments result = new Arguments();
        UnmodifiableIterator args = Iterators.forArray((Object[])argsArray);
        String delimiter = defaultDelimiter;
        LinkedHashMap userParameterStrings = Maps.newLinkedHashMap();
        LinkedHashMap vmParameterStrings = Maps.newLinkedHashMap();
        String vmString = null;
        boolean standardRun = false;
        while (args.hasNext()) {
            String measurementType;
            String value;
            String arg = (String)args.next();
            if ("--help".equals(arg)) {
                throw new UserException.DisplayUsageException();
            }
            if (arg.startsWith("-D") || arg.startsWith("-J")) {
                String value2;
                String name;
                int equalsSign = arg.indexOf(61);
                if (equalsSign == -1) {
                    name = arg.substring(2);
                    value2 = (String)args.next();
                } else {
                    name = arg.substring(2, equalsSign);
                    value2 = arg.substring(equalsSign + 1);
                }
                String previousValue = arg.startsWith("-D") ? userParameterStrings.put(name, value2) : vmParameterStrings.put(name, value2);
                if (previousValue != null) {
                    throw new UserException.DuplicateParameterException(arg);
                }
                standardRun = true;
                continue;
            }
            if ("--captureVmLog".equals(arg)) {
                result.captureVmLog = true;
                standardRun = true;
                continue;
            }
            if ("--warmupMillis".equals(arg)) {
                result.warmupMillis = Long.parseLong((String)args.next());
                standardRun = true;
                continue;
            }
            if ("--runMillis".equals(arg)) {
                result.runMillis = Long.parseLong((String)args.next());
                standardRun = true;
                continue;
            }
            if ("--trials".equals(arg)) {
                value = (String)args.next();
                try {
                    result.trials = Integer.parseInt(value);
                    if (result.trials < 1) {
                        throw new UserException.InvalidTrialsException(value);
                    }
                }
                catch (NumberFormatException e) {
                    throw new UserException.InvalidTrialsException(value);
                }
                standardRun = true;
                continue;
            }
            if ("--vm".equals(arg)) {
                if (vmString != null) {
                    throw new UserException.DuplicateParameterException(arg);
                }
                vmString = (String)args.next();
                standardRun = true;
                continue;
            }
            if ("--delimiter".equals(arg)) {
                delimiter = (String)args.next();
                standardRun = true;
                continue;
            }
            if ("--timeUnit".equals(arg)) {
                result.timeUnit = (String)args.next();
                standardRun = true;
                continue;
            }
            if ("--instanceUnit".equals(arg)) {
                result.instanceUnit = (String)args.next();
                standardRun = true;
                continue;
            }
            if ("--memoryUnit".equals(arg)) {
                result.memoryUnit = (String)args.next();
                standardRun = true;
                continue;
            }
            if ("--saveResults".equals(arg) || "--xmlSave".equals(arg)) {
                result.saveResultsFile = new File((String)args.next());
                standardRun = true;
                continue;
            }
            if ("--uploadResults".equals(arg)) {
                result.uploadResultsFile = new File((String)args.next());
                continue;
            }
            if ("--printScore".equals(arg)) {
                result.printScore = true;
                standardRun = true;
                continue;
            }
            if ("--measureMemory".equals(arg)) {
                result.measureMemory = true;
                standardRun = true;
                continue;
            }
            if ("--debug".equals(arg)) {
                result.debug = true;
                continue;
            }
            if ("--debug-reps".equals(arg)) {
                value = (String)args.next();
                try {
                    result.debugReps = Integer.parseInt(value);
                    if (result.debugReps >= 1) continue;
                    throw new UserException.InvalidDebugRepsException(value);
                }
                catch (NumberFormatException e) {
                    throw new UserException.InvalidDebugRepsException(value);
                }
            }
            if ("--marker".equals(arg)) {
                result.marker = (String)args.next();
                continue;
            }
            if ("--measurementType".equals(arg)) {
                measurementType = (String)args.next();
                try {
                    result.measurementType = MeasurementType.valueOf(measurementType);
                }
                catch (Exception e) {
                    throw new UserException.InvalidParameterValueException(arg, measurementType);
                }
                standardRun = true;
                continue;
            }
            if ("--primaryMeasurementType".equals(arg)) {
                measurementType = ((String)args.next()).toUpperCase();
                try {
                    result.primaryMeasurementType = MeasurementType.valueOf(measurementType);
                }
                catch (Exception e) {
                    throw new UserException.InvalidParameterValueException(arg, measurementType);
                }
                standardRun = true;
                continue;
            }
            if (arg.startsWith("-")) {
                throw new UserException.UnrecognizedOptionException(arg);
            }
            if (result.suiteClassName != null) {
                throw new UserException.MultipleBenchmarkClassesException(result.suiteClassName, arg);
            }
            result.suiteClassName = arg;
        }
        Splitter delimiterSplitter = Splitter.on((String)delimiter);
        if (vmString != null) {
            Iterables.addAll(result.userVms, (Iterable)delimiterSplitter.split(vmString));
        }
        if (!(duplicates = Sets.intersection(userParameterStrings.keySet(), vmParameterStrings.keySet())).isEmpty()) {
            throw new UserException.DuplicateParameterException((Set<String>)duplicates);
        }
        for (Map.Entry entry : userParameterStrings.entrySet()) {
            result.userParameters.putAll(entry.getKey(), delimiterSplitter.split((CharSequence)entry.getValue()));
        }
        for (Map.Entry entry : vmParameterStrings.entrySet()) {
            result.vmParameters.putAll(entry.getKey(), delimiterSplitter.split((CharSequence)entry.getValue()));
        }
        if (standardRun && result.uploadResultsFile != null) {
            throw new UserException.IncompatibleArgumentsException("--uploadResults");
        }
        if (result.suiteClassName == null && result.uploadResultsFile == null) {
            throw new UserException.NoBenchmarkClassException();
        }
        if (result.primaryMeasurementType != null && result.primaryMeasurementType != MeasurementType.TIME && !result.measureMemory) {
            throw new UserException.IncompatibleArgumentsException("--primaryMeasurementType " + result.primaryMeasurementType.toString().toLowerCase());
        }
        return result;
    }

    public static void printUsage() {
        System.out.println();
        System.out.println("Usage: Runner [OPTIONS...] <benchmark>");
        System.out.println();
        System.out.println("  <benchmark>: a benchmark class or suite");
        System.out.println();
        System.out.println("OPTIONS");
        System.out.println();
        System.out.println("  -D<param>=<value>: fix a benchmark parameter to a given value.");
        System.out.println("        Multiple values can be supplied by separating them with the");
        System.out.println("        delimiter specified in the --delimiter argument.");
        System.out.println();
        System.out.println("        For example: \"-Dfoo=bar,baz,bat\"");
        System.out.println();
        System.out.println("        \"benchmark\" is a special parameter that can be used to specify");
        System.out.println("        which benchmark methods to run. For example, if a benchmark has");
        System.out.println("        the method \"timeFoo\", it can be run alone by using");
        System.out.println("        \"-Dbenchmark=Foo\". \"benchmark\" also accepts a delimiter");
        System.out.println("        separated list of methods to run.");
        System.out.println();
        System.out.println("  -J<param>=<value>: set a JVM argument to the given value.");
        System.out.println("        Multiple values can be supplied by separating them with the");
        System.out.println("        delimiter specified in the --delimiter argument.");
        System.out.println();
        System.out.println("        For example: \"-JmemoryMax=-Xmx32M,-Xmx512M\"");
        System.out.println();
        System.out.println("  --delimiter <delimiter>: character or string to use as a delimiter");
        System.out.println("        for parameter and vm values.");
        System.out.println("        Default: \",\"");
        System.out.println();
        System.out.println("  --warmupMillis <millis>: duration to warmup each benchmark");
        System.out.println();
        System.out.println("  --runMillis <millis>: duration to execute each benchmark");
        System.out.println();
        System.out.println("  --captureVmLog: record the VM's just-in-time compiler and GC logs.");
        System.out.println("        This may slow down or break benchmark display tools.");
        System.out.println();
        System.out.println("  --measureMemory: measure the number of allocations done and the amount of");
        System.out.println("        memory used by invocations of the benchmark.");
        System.out.println("        Default: off");
        System.out.println();
        System.out.println("  --vm <vm>: executable to test benchmark on. Multiple VMs may be passed");
        System.out.println("        in as a list separated by the delimiter specified in the");
        System.out.println("        --delimiter argument.");
        System.out.println();
        System.out.println("  --timeUnit <unit>: unit of time to use for result. Depends on the units");
        System.out.println("        defined in the benchmark's getTimeUnitNames() method, if defined.");
        System.out.println("        Default Options: ns, us, ms, s");
        System.out.println();
        System.out.println("  --instanceUnit <unit>: unit to use for allocation instances result.");
        System.out.println("        Depends on the units defined in the benchmark's");
        System.out.println("        getInstanceUnitNames() method, if defined.");
        System.out.println("        Default Options: instances, K instances, M instances, B instances");
        System.out.println();
        System.out.println("  --memoryUnit <unit>: unit to use for allocation memory size result.");
        System.out.println("        Depends on the units defined in the benchmark's");
        System.out.println("        getMemoryUnitNames() method, if defined.");
        System.out.println("        Default Options: B, KB, MB, GB");
        System.out.println();
        System.out.println("  --saveResults <file/dir>: write results to this file or directory");
        System.out.println();
        System.out.println("  --printScore: if present, also display an aggregate score for this run,");
        System.out.println("        where higher is better. This number has no particular meaning,");
        System.out.println("        but can be compared to scores from other runs that use the exact");
        System.out.println("        same arguments.");
        System.out.println();
        System.out.println("  --uploadResults <file/dir>: upload this file or directory of files");
        System.out.println("        to the web app. This argument ends Caliper early and is thus");
        System.out.println("        incompatible with all other arguments.");
        System.out.println();
        System.out.println("  --debug: run without measurement for use with debugger or profiling.");
        System.out.println();
        System.out.println("  --debug-reps: fixed number of reps to run with --debug.");
        System.out.println("        Default: \"1000\"");
    }
}

