C-----------------------------------------------------------------------
#include "pdf/pilot.h"
      Subroutine Ctq4RA5 (Iset)
#include "pdf/impdp.inc"
      PARAMETER (MXX = 105, MXQ = 25, MXF = 6)
      PARAMETER (MXPQX = (MXF *2 +2) * MXQ * MXX)
      PARAMETER (NxI = 90, NtI = 13, NfMxI = 5)
      COMMON / W5051IC / Al, XV(0:MXX), QL(0:MXQ), UPD(MXPQX)
      COMMON / W5051ID / Nx, Nt, NfMx
      COMMON / W5051IE / Qini, Qmax, Xmin
      DIMENSION Amass(6)
      PARAMETER (NSETS=10)
      DIMENSION 
     >  XVI(0:MXX),QLI(0:MXQ),UPDI(MXPQX),
     >  AmassI(6)
C
C-----------------------------------------------------------------------
C Parton Distribution Table : CTEQ4A5
C       PARAMETER (ISET=8)                                           
        DATA  DrI, FlI, AlI /             2.,   5.,  .2820 /
        DATA  (AmassI(I),I=1,6) /     .000,     .000,     .200,
     +                                 1.600,    5.000,  180.000 /
C        DATA  NXI,  NTI, NfMxI /    90,    13,     5 /
        DATA  QINII, QMAXI, (QLI(I), I =0, NTI) /
     +  .160000D+01, .100000D+05,
     +  .160000D+01, .202065D+01, .263326D+01, .355599D+01, .500000D+01,
     +  .779631D+01, .130200D+02, .235367D+02, .466233D+02, .102642D+03,
     +  .255265D+03, .730783D+03, .246126D+04, .100000D+05 /
        DATA  XMINI, (XVI(I), I =0, NXI) /
     +  .100000D-04,
     +  .000000D+00, .999983D-05, .124433D-04, .154836D-04, .192668D-04,
     +  .239740D-04, .298310D-04, .371184D-04, .461852D-04, .574656D-04,
     +  .714994D-04, .889575D-04, .110674D-03, .137686D-03, .171280D-03,
     +  .213055D-03, .264997D-03, .329564D-03, .409809D-03, .509508D-03,
     +  .633332D-03, .787053D-03, .977784D-03, .121428D-02, .150728D-02,
     +  .186993D-02, .231825D-02, .288037D-02, .356397D-02, .440443D-02,
     +  .543508D-02, .669508D-02, .822984D-02, .100851D-01, .123281D-01,
     +  .150167D-01, .182174D-01, .219985D-01, .264278D-01, .315720D-01,
     +  .374800D-01, .442088D-01, .517931D-01, .602576D-01, .696136D-01,
     +  .798586D-01, .909356D-01, .102935D+00, .115681D+00, .129293D+00,
     +  .143599D+00, .158606D+00, .174271D+00, .190550D+00, .207405D+00,
     +  .224796D+00, .242685D+00, .261038D+00, .279820D+00, .299001D+00,
     +  .318550D+00, .338442D+00, .358653D+00, .379067D+00, .399881D+00,
     +  .420953D+00, .442266D+00, .463806D+00, .485559D+00, .507513D+00,
     +  .529656D+00, .551978D+00, .574483D+00, .597187D+00, .619860D+00,
     +  .642828D+00, .665921D+00, .689135D+00, .712467D+00, .735911D+00,
     +  .759464D+00, .783080D+00, .806909D+00, .830741D+00, .854673D+00,
     +  .878696D+00, .902804D+00, .926992D+00, .951257D+00, .975603D+00,
     +  .100000D+01 /
C Parton Distribution Table:                                                     
        DATA (UPDI(I),I=1,52) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=53,104) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=105,156) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=157,208) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=209,260) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=261,312) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=313,364) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=365,416) /
     +  .319008D+06, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=417,468) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .148570D+06,
     +  .112239D+06, .833156D+05, .617989D+05, .458152D+05,
     +  .339356D+05, .251218D+05, .185795D+05, .137321D+05,
     +  .101390D+05, .748073D+04, .551330D+04, .406008D+04 /
        DATA (UPDI(I),I=469,520) /
     +  .298632D+04, .219461D+04, .161069D+04, .118099D+04,
     +  .864692D+03, .632431D+03, .461846D+03, .336884D+03,
     +  .245329D+03, .178427D+03, .129543D+03, .939186D+02,
     +  .679743D+02, .491452D+02, .352983D+02, .254390D+02,
     +  .182997D+02, .131515D+02, .943679D+01, .676669D+01,
     +  .485184D+01, .347684D+01, .249123D+01, .178759D+01,
     +  .128384D+01, .924545D+00, .667171D+00, .483603D+00,
     +  .351688D+00, .257017D+00, .188603D+00, .139193D+00,
     +  .103160D+00, .769792D-01, .575381D-01, .433305D-01,
     +  .326602D-01, .247454D-01, .187803D-01, .142965D-01,
     +  .108900D-01, .830960D-02, .633381D-02, .482722D-02,
     +  .366983D-02, .278675D-02, .210703D-02, .158848D-02,
     +  .119030D-02, .887269D-03, .657193D-03, .481962D-03 /
        DATA (UPDI(I),I=521,572) /
     +  .349115D-03, .249789D-03, .175606D-03, .121095D-03,
     +  .811371D-04, .524931D-04, .320884D-04, .179651D-04,
     +  .839892D-05, .229658D-05, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .328938D+06, .247986D+06,
     +  .183630D+06, .135870D+06, .100473D+06, .742301D+05,
     +  .548063D+05, .404256D+05, .297971D+05, .219398D+05,
     +  .161417D+05, .118624D+05, .870998D+04, .638743D+04,
     +  .467971D+04, .342396D+04, .250254D+04, .182642D+04,
     +  .133142D+04, .969045D+03, .704416D+03, .511185D+03,
     +  .370448D+03, .267974D+03, .193553D+03, .139547D+03 /
        DATA (UPDI(I),I=573,624) /
     +  .100493D+03, .718841D+02, .515907D+02, .369561D+02,
     +  .264431D+02, .188899D+02, .134825D+02, .962204D+01,
     +  .686144D+01, .489198D+01, .349206D+01, .249482D+01,
     +  .178678D+01, .128224D+01, .924067D+00, .668070D+00,
     +  .485261D+00, .353908D+00, .259526D+00, .191104D+00,
     +  .141657D+00, .105176D+00, .786577D-01, .588778D-01,
     +  .442927D-01, .333786D-01, .252259D-01, .190775D-01,
     +  .144506D-01, .109354D-01, .827423D-02, .624646D-02,
     +  .471055D-02, .353841D-02, .265114D-02, .197572D-02,
     +  .146591D-02, .108208D-02, .792237D-03, .574454D-03,
     +  .412959D-03, .293299D-03, .205957D-03, .142291D-03,
     +  .967834D-04, .643488D-04, .417019D-04, .261122D-04,
     +  .157852D-04, .894070D-05, .464461D-05, .203357D-05 /
        DATA (UPDI(I),I=625,676) /
     +  .570954D-06, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .546885D+06, .411391D+06, .303837D+06,
     +  .224221D+06, .165361D+06, .121839D+06, .897074D+05,
     +  .659835D+05, .484958D+05, .356043D+05, .261173D+05,
     +  .191358D+05, .140074D+05, .102403D+05, .747865D+04,
     +  .545424D+04, .397331D+04, .289014D+04, .209965D+04,
     +  .152288D+04, .110308D+04, .797599D+03, .575869D+03,
     +  .415005D+03, .298597D+03, .214432D+03, .153793D+03,
     +  .109552D+03, .782909D+02, .558413D+02, .397777D+02,
     +  .282873D+02, .200951D+02, .142730D+02, .101276D+02,
     +  .718434D+01, .510154D+01, .362536D+01, .258215D+01 /
        DATA (UPDI(I),I=677,728) /
     +  .184269D+01, .132026D+01, .948908D+00, .685063D+00,
     +  .496570D+00, .361834D+00, .264741D+00, .194951D+00,
     +  .143794D+00, .106807D+00, .794058D-01, .593198D-01,
     +  .443949D-01, .333145D-01, .250181D-01, .188146D-01,
     +  .141371D-01, .106202D-01, .796139D-02, .596126D-02,
     +  .444726D-02, .330940D-02, .245037D-02, .180678D-02,
     +  .132608D-02, .965901D-03, .697573D-03, .500117D-03,
     +  .354994D-03, .249800D-03, .173670D-03, .119541D-03,
     +  .811349D-04, .543487D-04, .358793D-04, .235159D-04,
     +  .151678D-04, .972516D-05, .619535D-05, .396674D-05,
     +  .255183D-05, .167474D-05, .111169D-05, .747865D-06,
     +  .498173D-06, .322660D-06, .195093D-06, .105237D-06,
     +  .462433D-07, .132268D-07, .102871D-08, .000000D+00 /
        DATA (UPDI(I),I=729,780) /
     +  .808861D+06, .607052D+06, .447111D+06, .329038D+06,
     +  .241976D+06, .177780D+06, .130514D+06, .957160D+05,
     +  .701369D+05, .513364D+05, .375408D+05, .274195D+05,
     +  .200068D+05, .145791D+05, .106121D+05, .771364D+04,
     +  .560004D+04, .405933D+04, .293862D+04, .212377D+04,
     +  .153268D+04, .110412D+04, .794144D+03, .570096D+03,
     +  .408565D+03, .292217D+03, .208713D+03, .148039D+03,
     +  .105338D+03, .748037D+02, .530439D+02, .375479D+02,
     +  .265469D+02, .187648D+02, .132481D+02, .935019D+01,
     +  .660445D+01, .466831D+01, .330659D+01, .234645D+01,
     +  .167145D+01, .119426D+01, .856970D+00, .617387D+00,
     +  .447038D+00, .325008D+00, .237776D+00, .174239D+00,
     +  .128553D+00, .949332D-01, .704346D-01, .523559D-01 /
        DATA (UPDI(I),I=781,832) /
     +  .390163D-01, .290985D-01, .217295D-01, .162141D-01,
     +  .120951D-01, .900460D-02, .669532D-02, .496101D-02,
     +  .366661D-02, .269718D-02, .197604D-02, .144155D-02,
     +  .104403D-02, .750309D-03, .535742D-03, .379271D-03,
     +  .266613D-03, .185663D-03, .128417D-03, .880055D-04,
     +  .598989D-04, .405304D-04, .274936D-04, .186028D-04,
     +  .126806D-04, .870979D-05, .606258D-05, .425559D-05,
     +  .301533D-05, .212683D-05, .147887D-05, .994751D-06,
     +  .634515D-06, .371335D-06, .190626D-06, .785737D-07,
     +  .210066D-07, .168579D-08, .000000D+00, .112169D+07,
     +  .839798D+06, .616755D+06, .452566D+06, .331837D+06,
     +  .243073D+06, .177907D+06, .130073D+06, .950146D+05,
     +  .693262D+05, .505334D+05, .367895D+05, .267548D+05 /
        DATA (UPDI(I),I=833,884) /
     +  .194312D+05, .140958D+05, .102105D+05, .738668D+04,
     +  .533538D+04, .384835D+04, .277102D+04, .199227D+04,
     +  .142973D+04, .102435D+04, .732450D+03, .522802D+03,
     +  .372381D+03, .264846D+03, .187039D+03, .132505D+03,
     +  .936772D+02, .661225D+02, .465880D+02, .327801D+02,
     +  .230581D+02, .161970D+02, .113730D+02, .799065D+01,
     +  .561783D+01, .395708D+01, .279229D+01, .197751D+01,
     +  .140465D+01, .100187D+01, .717389D+00, .516202D+00,
     +  .372930D+00, .271084D+00, .197366D+00, .144653D+00,
     +  .106117D+00, .782032D-01, .577427D-01, .427382D-01,
     +  .316592D-01, .234792D-01, .174006D-01, .128912D-01,
     +  .953260D-02, .703959D-02, .518145D-02, .380406D-02,
     +  .278040D-02, .202417D-02, .146785D-02, .105704D-02 /
        DATA (UPDI(I),I=885,936) /
     +  .755865D-03, .537398D-03, .379266D-03, .266142D-03,
     +  .185405D-03, .128601D-03, .886937D-04, .610159D-04,
     +  .419543D-04, .290675D-04, .202101D-04, .142121D-04,
     +  .100951D-04, .725247D-05, .523292D-05, .377793D-05,
     +  .269254D-05, .187217D-05, .124946D-05, .784298D-06,
     +  .448789D-06, .223579D-06, .886567D-07, .227125D-07,
     +  .185689D-08, .000000D+00, .149248D+07, .111460D+07,
     +  .816129D+06, .597063D+06, .436448D+06, .318715D+06,
     +  .232538D+06, .169477D+06, .123400D+06, .897444D+05,
     +  .652004D+05, .473088D+05, .342880D+05, .248168D+05,
     +  .179396D+05, .129489D+05, .933404D+04, .671741D+04,
     +  .482721D+04, .346280D+04, .248011D+04, .177291D+04,
     +  .126520D+04, .901033D+03, .640498D+03, .454302D+03 /
        DATA (UPDI(I),I=937,988) /
     +  .321730D+03, .226212D+03, .159546D+03, .112287D+03,
     +  .788919D+02, .553240D+02, .387388D+02, .271160D+02,
     +  .189510D+02, .132383D+02, .925188D+01, .646955D+01,
     +  .453178D+01, .317988D+01, .223900D+01, .158110D+01,
     +  .112095D+01, .797812D+00, .570516D+00, .409598D+00,
     +  .295849D+00, .214021D+00, .155839D+00, .113578D+00,
     +  .831489D-01, .609917D-01, .448420D-01, .329977D-01,
     +  .243072D-01, .178946D-01, .131685D-01, .967349D-02,
     +  .709621D-02, .518933D-02, .378524D-02, .274948D-02,
     +  .198944D-02, .143433D-02, .102725D-02, .731035D-03,
     +  .517607D-03, .364204D-03, .255127D-03, .177764D-03,
     +  .123585D-03, .856815D-04, .594539D-04, .413890D-04,
     +  .291211D-04, .206249D-04, .147873D-04, .107031D-04 /
        DATA (UPDI(I),I=989,1040) /
     +  .780914D-05, .569846D-05, .413431D-05, .294519D-05,
     +  .203419D-05, .134226D-05, .828829D-06, .464479D-06,
     +  .225336D-06, .863983D-07, .213372D-07, .177250D-08,
     +  .000000D+00, .192843D+07, .143647D+07, .104858D+07,
     +  .764741D+06, .557262D+06, .405650D+06, .295013D+06,
     +  .214311D+06, .155530D+06, .112735D+06, .816260D+05,
     +  .590247D+05, .426308D+05, .307469D+05, .221472D+05,
     +  .159283D+05, .114396D+05, .820220D+04, .587197D+04,
     +  .419618D+04, .299369D+04, .213162D+04, .151508D+04,
     +  .107460D+04, .760715D+03, .537287D+03, .378859D+03,
     +  .265198D+03, .186208D+03, .130458D+03, .912320D+02,
     +  .636757D+02, .443706D+02, .309054D+02, .214899D+02,
     +  .149345D+02, .103820D+02, .722079D+01, .503008D+01 /
        DATA (UPDI(I),I=1041,1092) /
     +  .350978D+01, .245709D+01, .172501D+01, .121571D+01,
     +  .860064D+00, .611262D+00, .436140D+00, .313047D+00,
     +  .225034D+00, .162808D+00, .117896D+00, .857496D-01,
     +  .624938D-01, .456462D-01, .333713D-01, .244209D-01,
     +  .178614D-01, .130584D-01, .953102D-02, .694662D-02,
     +  .504803D-02, .365918D-02, .264200D-02, .190047D-02,
     +  .136263D-02, .970848D-03, .687795D-03, .485150D-03,
     +  .340456D-03, .238152D-03, .166002D-03, .115677D-03,
     +  .805931D-04, .563526D-04, .396385D-04, .282309D-04,
     +  .202676D-04, .147216D-04, .107772D-04, .792510D-05,
     +  .580658D-05, .420905D-05, .298390D-05, .204173D-05,
     +  .133008D-05, .807717D-06, .443508D-06, .209781D-06,
     +  .779387D-07, .186122D-07, .156932D-08, .000000D+00 /
        DATA (UPDI(I),I=1093,1144) /
     +  .243672D+07, .181033D+07, .131733D+07, .957704D+06,
     +  .695632D+06, .504735D+06, .365869D+06, .264904D+06,
     +  .191599D+06, .138408D+06, .998701D+05, .719662D+05,
     +  .517945D+05, .372230D+05, .267149D+05, .191432D+05,
     +  .136974D+05, .978418D+04, .697778D+04, .496715D+04,
     +  .352980D+04, .250336D+04, .177210D+04, .125174D+04,
     +  .882413D+03, .620584D+03, .435697D+03, .303625D+03,
     +  .212233D+03, .148015D+03, .103028D+03, .715687D+02,
     +  .496287D+02, .343979D+02, .237973D+02, .164529D+02,
     +  .113771D+02, .787053D+01, .545258D+01, .378340D+01,
     +  .263353D+01, .183821D+01, .128785D+01, .905680D+00,
     +  .639781D+00, .453699D+00, .323638D+00, .231199D+00,
     +  .166213D+00, .119602D+00, .864361D-01, .625951D-01 /
        DATA (UPDI(I),I=1145,1196) /
     +  .454276D-01, .330002D-01, .239943D-01, .174380D-01,
     +  .126679D-01, .918818D-02, .665488D-02, .480660D-02,
     +  .346322D-02, .248613D-02, .177835D-02, .126843D-02,
     +  .899365D-03, .634527D-03, .446071D-03, .312333D-03,
     +  .218266D-03, .152258D-03, .106373D-03, .744709D-04,
     +  .524417D-04, .372203D-04, .267726D-04, .194184D-04,
     +  .142309D-04, .104884D-04, .773880D-05, .567002D-05,
     +  .409358D-05, .288116D-05, .195029D-05, .125331D-05,
     +  .748348D-06, .402678D-06, .185814D-06, .669755D-07,
     +  .154989D-07, .132563D-08, .000000D+00, .302428D+07,
     +  .224087D+07, .162541D+07, .117788D+07, .852769D+06,
     +  .616715D+06, .445550D+06, .321512D+06, .231751D+06,
     +  .166838D+06, .119964D+06, .861417D+05, .617754D+05 /
        DATA (UPDI(I),I=1197,1248) /
     +  .442360D+05, .316320D+05, .225830D+05, .160981D+05,
     +  .114554D+05, .813824D+04, .577069D+04, .408461D+04,
     +  .288524D+04, .203412D+04, .143090D+04, .100448D+04,
     +  .703408D+03, .491700D+03, .341121D+03, .237373D+03,
     +  .164795D+03, .114174D+03, .789364D+02, .544729D+02,
     +  .375702D+02, .258609D+02, .177880D+02, .122357D+02,
     +  .841937D+01, .580100D+01, .400289D+01, .277056D+01,
     +  .192278D+01, .133924D+01, .936278D+00, .657436D+00,
     +  .463405D+00, .328549D+00, .233266D+00, .166659D+00,
     +  .119177D+00, .855911D-01, .615979D-01, .444238D-01,
     +  .320700D-01, .231717D-01, .167359D-01, .120826D-01,
     +  .871044D-02, .627066D-02, .450245D-02, .322532D-02,
     +  .230261D-02, .163833D-02, .116285D-02, .820824D-03 /
        DATA (UPDI(I),I=1249,1300) /
     +  .576960D-03, .404420D-03, .282672D-03, .197441D-03,
     +  .137896D-03, .966155D-04, .679681D-04, .481795D-04,
     +  .344644D-04, .249916D-04, .182661D-04, .134655D-04,
     +  .995931D-05, .735136D-05, .537202D-05, .385526D-05,
     +  .268996D-05, .179974D-05, .114031D-05, .669361D-06,
     +  .352981D-06, .158958D-06, .556380D-07, .124982D-07,
     +  .108393D-08, .000000D+00, .263563D+05, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=1301,1352) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=1353,1404) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .582837D+05, .445595D+05, .335484D+05,
     +  .252504D+05, .190000D+05, .142911D+05, .107460D+05,
     +  .807664D+04, .606825D+04, .455688D+04, .342056D+04,
     +  .256604D+04, .192411D+04, .144177D+04, .107977D+04,
     +  .808020D+03, .604303D+03, .451531D+03, .337154D+03,
     +  .251489D+03, .187455D+03, .139566D+03, .103827D+03,
     +  .771430D+02, .572649D+02, .424582D+02, .314640D+02,
     +  .231833D+02, .171446D+02, .126616D+02, .934887D+01,
     +  .689557D+01, .508691D+01, .375408D+01, .277184D+01,
     +  .204742D+01, .151624D+01, .112446D+01, .837253D+00 /
        DATA (UPDI(I),I=1405,1456) /
     +  .625025D+00, .469326D+00, .353751D+00, .268341D+00,
     +  .204475D+00, .156931D+00, .120983D+00, .940141D-01,
     +  .732037D-01, .574805D-01, .451799D-01, .357215D-01,
     +  .282819D-01, .224753D-01, .178656D-01, .142341D-01,
     +  .113234D-01, .901015D-02, .714903D-02, .566897D-02,
     +  .447476D-02, .352413D-02, .275931D-02, .215122D-02,
     +  .166825D-02, .128319D-02, .976757D-03, .736623D-03,
     +  .548316D-03, .403034D-03, .290825D-03, .205941D-03,
     +  .141716D-03, .944985D-04, .596368D-04, .353222D-04,
     +  .182267D-04, .689909D-05, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=1457,1508) /
     +  .128349D+06, .979715D+05, .736232D+05, .553042D+05,
     +  .415310D+05, .311728D+05, .233900D+05, .175408D+05,
     +  .131491D+05, .985090D+04, .737664D+04, .552005D+04,
     +  .412859D+04, .308548D+04, .230456D+04, .171978D+04,
     +  .128254D+04, .955509D+03, .711336D+03, .528973D+03,
     +  .393046D+03, .291694D+03, .216281D+03, .160154D+03,
     +  .118473D+03, .875287D+02, .646259D+02, .474380D+02,
     +  .349460D+02, .257077D+02, .189041D+02, .138859D+02,
     +  .101993D+02, .749428D+01, .550784D+01, .404948D+01,
     +  .298401D+01, .220196D+01, .163080D+01, .121091D+01,
     +  .904041D+00, .677478D+00, .510723D+00, .386760D+00,
     +  .294861D+00, .225812D+00, .174243D+00, .134730D+00,
     +  .105012D+00, .819394D-01, .642939D-01, .505270D-01 /
        DATA (UPDI(I),I=1509,1560) /
     +  .398454D-01, .314367D-01, .248545D-01, .196255D-01,
     +  .154998D-01, .122110D-01, .961454D-02, .753948D-02,
     +  .590074D-02, .459438D-02, .356461D-02, .275357D-02,
     +  .211264D-02, .160730D-02, .121467D-02, .909317D-03,
     +  .675431D-03, .495959D-03, .360798D-03, .258937D-03,
     +  .183679D-03, .127925D-03, .883074D-04, .596068D-04,
     +  .396171D-04, .257212D-04, .163821D-04, .101410D-04,
     +  .613782D-05, .358989D-05, .203536D-05, .110023D-05,
     +  .567543D-06, .270448D-06, .117437D-06, .437115D-07,
     +  .119638D-07, .809365D-09, .000000D+00, .212670D+06,
     +  .162051D+06, .121526D+06, .910922D+05, .682567D+05,
     +  .511175D+05, .382668D+05, .286293D+05, .214093D+05,
     +  .159993D+05, .119502D+05, .891912D+04, .665300D+04 /
        DATA (UPDI(I),I=1561,1612) /
     +  .495846D+04, .369312D+04, .274808D+04, .204338D+04,
     +  .151778D+04, .112645D+04, .835037D+03, .618468D+03,
     +  .457483D+03, .338067D+03, .249478D+03, .183902D+03,
     +  .135380D+03, .995862D+02, .728219D+02, .534371D+02,
     +  .391561D+02, .286755D+02, .209764D+02, .153408D+02,
     +  .112230D+02, .821034D+01, .600845D+01, .440587D+01,
     +  .323514D+01, .238347D+01, .176048D+01, .130700D+01,
     +  .973938D+00, .729838D+00, .549390D+00, .416200D+00,
     +  .316720D+00, .242768D+00, .186476D+00, .144337D+00,
     +  .111852D+00, .871402D-01, .680038D-01, .532410D-01,
     +  .417086D-01, .327355D-01, .256650D-01, .201235D-01,
     +  .157430D-01, .123074D-01, .958549D-02, .745083D-02,
     +  .576370D-02, .444351D-02, .341193D-02, .260294D-02 /
        DATA (UPDI(I),I=1613,1664) /
     +  .197065D-02, .148311D-02, .110706D-02, .821022D-03,
     +  .603217D-03, .440166D-03, .318082D-03, .228163D-03,
     +  .161843D-03, .114594D-03, .802453D-04, .560525D-04,
     +  .389006D-04, .269982D-04, .186286D-04, .128658D-04,
     +  .879442D-05, .594270D-05, .390556D-05, .246746D-05,
     +  .145090D-05, .765867D-06, .336466D-06, .997955D-07,
     +  .762425D-08, .000000D+00, .260556D+06, .238852D+06,
     +  .178719D+06, .133655D+06, .999149D+05, .746465D+05,
     +  .557438D+05, .415999D+05, .310291D+05, .231274D+05,
     +  .172281D+05, .128232D+05, .953844D+04, .708870D+04,
     +  .526437D+04, .390563D+04, .289528D+04, .214390D+04,
     +  .158611D+04, .117201D+04, .865186D+03, .637837D+03,
     +  .469727D+03, .345427D+03, .253722D+03, .186096D+03 /
        DATA (UPDI(I),I=1665,1716) /
     +  .136380D+03, .993424D+02, .726120D+02, .529955D+02,
     +  .386509D+02, .281556D+02, .205019D+02, .149332D+02,
     +  .108744D+02, .792118D+01, .578016D+01, .422341D+01,
     +  .309552D+01, .227450D+01, .167937D+01, .124450D+01,
     +  .927179D+00, .693873D+00, .522441D+00, .395130D+00,
     +  .300938D+00, .229687D+00, .176604D+00, .135955D+00,
     +  .105200D+00, .815489D-01, .634067D-01, .493361D-01,
     +  .384527D-01, .299419D-01, .233145D-01, .181165D-01,
     +  .140655D-01, .108819D-01, .840164D-02, .645717D-02,
     +  .494600D-02, .377403D-02, .286154D-02, .215422D-02,
     +  .161273D-02, .119833D-02, .885241D-03, .648639D-03,
     +  .472595D-03, .341657D-03, .245673D-03, .175274D-03,
     +  .125156D-03, .887763D-04, .630507D-04, .446919D-04 /
        DATA (UPDI(I),I=1717,1768) /
     +  .317706D-04, .225164D-04, .159647D-04, .111900D-04,
     +  .771777D-05, .515410D-05, .328539D-05, .193709D-05,
     +  .101688D-05, .439338D-06, .126531D-06, .982627D-08,
     +  .000000D+00, .454333D+06, .344745D+06, .257255D+06,
     +  .191861D+06, .143024D+06, .106549D+06, .793345D+05,
     +  .590294D+05, .438957D+05, .326166D+05, .242200D+05,
     +  .179697D+05, .133227D+05, .986813D+04, .730348D+04,
     +  .539975D+04, .398870D+04, .294299D+04, .216929D+04,
     +  .159697D+04, .117440D+04, .862453D+03, .632622D+03,
     +  .463351D+03, .338937D+03, .247556D+03, .180639D+03,
     +  .131000D+03, .953199D+02, .692536D+02, .502701D+02,
     +  .364459D+02, .264071D+02, .191389D+02, .138643D+02,
     +  .100461D+02, .729027D+01, .529734D+01, .386003D+01 /
        DATA (UPDI(I),I=1769,1820) /
     +  .281970D+01, .206913D+01, .152390D+01, .112799D+01,
     +  .838713D+00, .627219D+00, .471178D+00, .356342D+00,
     +  .270076D+00, .206152D+00, .157563D+00, .121015D+00,
     +  .931265D-01, .718638D-01, .555033D-01, .429283D-01,
     +  .331761D-01, .256333D-01, .197669D-01, .152254D-01,
     +  .116874D-01, .894977D-02, .682237D-02, .518054D-02,
     +  .391792D-02, .294207D-02, .219257D-02, .162326D-02,
     +  .119162D-02, .868175D-03, .626265D-03, .447959D-03,
     +  .316898D-03, .221988D-03, .153515D-03, .105584D-03,
     +  .715983D-04, .482024D-04, .321199D-04, .212980D-04,
     +  .139992D-04, .917929D-05, .595730D-05, .382634D-05,
     +  .239739D-05, .144987D-05, .819247D-06, .417460D-06,
     +  .176871D-06, .505089D-07, .389009D-08, .000000D+00 /
        DATA (UPDI(I),I=1821,1872) /
     +  .626633D+06, .474322D+06, .352924D+06, .262439D+06,
     +  .195051D+06, .144866D+06, .107531D+06, .797577D+05,
     +  .591197D+05, .437859D+05, .324061D+05, .239623D+05,
     +  .177047D+05, .130682D+05, .963758D+04, .709981D+04,
     +  .522524D+04, .384101D+04, .282047D+04, .206837D+04,
     +  .151508D+04, .110821D+04, .809581D+03, .590515D+03,
     +  .430135D+03, .312815D+03, .227254D+03, .164060D+03,
     +  .118830D+03, .859354D+02, .620813D+02, .447918D+02,
     +  .322921D+02, .232861D+02, .167801D+02, .120944D+02,
     +  .872828D+01, .630693D+01, .456906D+01, .331813D+01,
     +  .242005D+01, .177141D+01, .130284D+01, .962513D+00,
     +  .715011D+00, .533543D+00, .400732D+00, .301629D+00,
     +  .228601D+00, .173484D+00, .132277D+00, .101064D+00 /
        DATA (UPDI(I),I=1873,1924) /
     +  .774165D-01, .593579D-01, .455681D-01, .349584D-01,
     +  .268095D-01, .205228D-01, .156898D-01, .119560D-01,
     +  .908765D-02, .687747D-02, .518422D-02, .389266D-02,
     +  .290209D-02, .214796D-02, .157959D-02, .115236D-02,
     +  .834655D-03, .599072D-03, .426703D-03, .301020D-03,
     +  .210589D-03, .145853D-03, .100729D-03, .688780D-04,
     +  .469505D-04, .318562D-04, .216085D-04, .146077D-04,
     +  .987211D-05, .661374D-05, .436910D-05, .280416D-05,
     +  .172128D-05, .978344D-06, .494510D-06, .203931D-06,
     +  .554686D-07, .438138D-08, .000000D+00, .836720D+06,
     +  .631717D+06, .468607D+06, .347388D+06, .257379D+06,
     +  .190550D+06, .140984D+06, .104227D+06, .770000D+05,
     +  .568356D+05, .419196D+05, .308888D+05, .227414D+05 /
        DATA (UPDI(I),I=1925,1976) /
     +  .167256D+05, .122896D+05, .901993D+04, .661333D+04,
     +  .484277D+04, .354222D+04, .258740D+04, .188765D+04,
     +  .137510D+04, .100037D+04, .726602D+03, .526989D+03,
     +  .381572D+03, .275964D+03, .198309D+03, .142971D+03,
     +  .102908D+03, .739840D+02, .531184D+02, .381022D+02,
     +  .273358D+02, .195945D+02, .140473D+02, .100816D+02,
     +  .724408D+01, .521763D+01, .376694D+01, .273077D+01,
     +  .198661D+01, .145188D+01, .106580D+01, .786544D+00,
     +  .583045D+00, .434954D+00, .325164D+00, .244723D+00,
     +  .184428D+00, .139625D+00, .105929D+00, .805622D-01,
     +  .613308D-01, .467417D-01, .356022D-01, .271058D-01,
     +  .206016D-01, .156360D-01, .118303D-01, .892758D-02,
     +  .670890D-02, .502140D-02, .374426D-02, .277215D-02 /
        DATA (UPDI(I),I=1977,2028) /
     +  .203824D-02, .148932D-02, .108006D-02, .777972D-03,
     +  .555767D-03, .394326D-03, .277483D-03, .193933D-03,
     +  .134525D-03, .932654D-04, .642438D-04, .442531D-04,
     +  .304586D-04, .210117D-04, .144795D-04, .997109D-05,
     +  .679952D-05, .455304D-05, .295019D-05, .181666D-05,
     +  .102995D-05, .515077D-06, .208067D-06, .549331D-07,
     +  .440707D-08, .000000D+00, .109103D+07, .821517D+06,
     +  .607470D+06, .448888D+06, .331498D+06, .244614D+06,
     +  .180379D+06, .132899D+06, .978434D+05, .719684D+05,
     +  .528928D+05, .388343D+05, .284869D+05, .208737D+05,
     +  .152800D+05, .111720D+05, .815957D+04, .595163D+04,
     +  .433597D+04, .315441D+04, .229187D+04, .166261D+04,
     +  .120442D+04, .871052D+03, .628997D+03, .453402D+03 /
        DATA (UPDI(I),I=2029,2080) /
     +  .326427D+03, .233477D+03, .167536D+03, .120016D+03,
     +  .858632D+02, .613426D+02, .437783D+02, .312466D+02,
     +  .222791D+02, .158861D+02, .113382D+02, .810123D+01,
     +  .580130D+01, .416382D+01, .300030D+01, .216937D+01,
     +  .157553D+01, .114926D+01, .842637D+00, .620545D+00,
     +  .459849D+00, .341472D+00, .255241D+00, .191037D+00,
     +  .143625D+00, .108213D+00, .817227D-01, .617808D-01,
     +  .467518D-01, .353607D-01, .267321D-01, .201760D-01,
     +  .152051D-01, .114247D-01, .856138D-02, .638984D-02,
     +  .474990D-02, .351809D-02, .258740D-02, .189040D-02,
     +  .137291D-02, .990082D-03, .709513D-03, .504695D-03,
     +  .356872D-03, .250612D-03, .175068D-03, .121655D-03,
     +  .846672D-04, .587113D-04, .408062D-04, .284072D-04 /
        DATA (UPDI(I),I=2081,2132) /
     +  .198404D-04, .138487D-04, .964198D-05, .663282D-05,
     +  .446128D-05, .289242D-05, .177279D-05, .995641D-06,
     +  .490017D-06, .193201D-06, .494952D-07, .402795D-08,
     +  .000000D+00, .139637D+07, .104854D+07, .772810D+06,
     +  .569178D+06, .418922D+06, .308076D+06, .226394D+06,
     +  .166220D+06, .121943D+06, .893737D+05, .654462D+05,
     +  .478745D+05, .349873D+05, .255400D+05, .186243D+05,
     +  .135643D+05, .986776D+04, .716887D+04, .520162D+04,
     +  .376865D+04, .272674D+04, .196973D+04, .142078D+04,
     +  .102305D+04, .735490D+03, .527774D+03, .378230D+03,
     +  .269254D+03, .192295D+03, .137091D+03, .975979D+02,
     +  .693789D+02, .492612D+02, .349785D+02, .248075D+02,
     +  .175935D+02, .124872D+02, .887216D+01, .631677D+01 /
        DATA (UPDI(I),I=2133,2184) /
     +  .450732D+01, .322836D+01, .232010D+01, .167454D+01,
     +  .121383D+01, .884275D+00, .647000D+00, .476309D+00,
     +  .351356D+00, .260865D+00, .193932D+00, .144809D+00,
     +  .108365D+00, .812765D-01, .610238D-01, .458598D-01,
     +  .344484D-01, .258633D-01, .193873D-01, .145105D-01,
     +  .108292D-01, .806026D-02, .597602D-02, .441292D-02,
     +  .324739D-02, .237315D-02, .172343D-02, .124450D-02,
     +  .892805D-03, .636816D-03, .451265D-03, .318179D-03,
     +  .223104D-03, .155866D-03, .108545D-03, .758451D-04,
     +  .529244D-04, .370749D-04, .260489D-04, .183614D-04,
     +  .129264D-04, .905458D-05, .625005D-05, .420124D-05,
     +  .271242D-05, .164807D-05, .913704D-06, .441352D-06,
     +  .169535D-06, .421306D-07, .347691D-08, .000000D+00 /
        DATA (UPDI(I),I=2185,2236) /
     +  .175984D+07, .131776D+07, .967980D+06, .710513D+06,
     +  .521155D+06, .381929D+06, .279681D+06, .204614D+06,
     +  .149568D+06, .109221D+06, .796845D+05, .580720D+05,
     +  .422788D+05, .307443D+05, .223320D+05, .162007D+05,
     +  .117386D+05, .849356D+04, .613752D+04, .442826D+04,
     +  .319049D+04, .229488D+04, .164814D+04, .118155D+04,
     +  .845650D+03, .604062D+03, .430903D+03, .305296D+03,
     +  .216997D+03, .153956D+03, .109065D+03, .771427D+02,
     +  .544940D+02, .384937D+02, .271556D+02, .191548D+02,
     +  .135203D+02, .955229D+01, .676200D+01, .479694D+01,
     +  .341535D+01, .243969D+01, .175002D+01, .126067D+01,
     +  .912577D+00, .663441D+00, .485256D+00, .355620D+00,
     +  .262287D+00, .193696D+00, .143667D+00, .106795D+00 /
        DATA (UPDI(I),I=2237,2288) /
     +  .795602D-01, .593349D-01, .442892D-01, .330455D-01,
     +  .246433D-01, .183499D-01, .136423D-01, .101143D-01,
     +  .747879D-02, .550933D-02, .404233D-02, .295622D-02,
     +  .214727D-02, .155050D-02, .111363D-02, .795084D-03,
     +  .564734D-03, .398873D-03, .280595D-03, .196571D-03,
     +  .137421D-03, .959442D-04, .673180D-04, .472528D-04,
     +  .333312D-04, .235936D-04, .167427D-04, .118503D-04,
     +  .832257D-05, .574403D-05, .384631D-05, .246566D-05,
     +  .148164D-05, .809239D-06, .383062D-06, .143242D-06,
     +  .345430D-07, .289032D-08, .000000D+00, .218865D+07,
     +  .163417D+07, .119632D+07, .875101D+06, .639645D+06,
     +  .467116D+06, .340842D+06, .248461D+06, .180957D+06,
     +  .131654D+06, .956915D+05, .694736D+05, .503857D+05 /
        DATA (UPDI(I),I=2289,2340) /
     +  .364974D+05, .264068D+05, .190805D+05, .137695D+05,
     +  .992242D+04, .714039D+04, .513027D+04, .368059D+04,
     +  .263603D+04, .188489D+04, .134530D+04, .958531D+03,
     +  .681566D+03, .483937D+03, .341238D+03, .241388D+03,
     +  .170433D+03, .120142D+03, .845526D+02, .594234D+02,
     +  .417586D+02, .293026D+02, .205580D+02, .144308D+02,
     +  .101387D+02, .713618D+01, .503311D+01, .356233D+01,
     +  .252946D+01, .180337D+01, .129110D+01, .928764D+00,
     +  .670946D+00, .487619D+00, .355052D+00, .260166D+00,
     +  .190877D+00, .140647D+00, .103867D+00, .768688D-01,
     +  .569510D-01, .422286D-01, .313014D-01, .231895D-01,
     +  .171551D-01, .126711D-01, .933414D-02, .685796D-02,
     +  .502060D-02, .366108D-02, .266146D-02, .192202D-02 /
        DATA (UPDI(I),I=2341,2392) /
     +  .138039D-02, .986517D-03, .701242D-03, .496231D-03,
     +  .349524D-03, .245459D-03, .171899D-03, .120319D-03,
     +  .842452D-04, .593584D-04, .418953D-04, .297285D-04,
     +  .211666D-04, .150898D-04, .107109D-04, .752264D-05,
     +  .517809D-05, .344638D-05, .218934D-05, .129907D-05,
     +  .698092D-06, .323533D-06, .117738D-06, .275726D-07,
     +  .233872D-08, .000000D+00, .268995D+07, .200269D+07,
     +  .146105D+07, .106504D+07, .775745D+06, .564494D+06,
     +  .410414D+06, .298088D+06, .216301D+06, .156783D+06,
     +  .113527D+06, .821082D+05, .593191D+05, .428006D+05,
     +  .308449D+05, .221982D+05, .159545D+05, .114498D+05,
     +  .820533D+04, .587065D+04, .419382D+04, .299065D+04,
     +  .212911D+04, .151288D+04, .107309D+04, .759529D+03 /
        DATA (UPDI(I),I=2393,2444) /
     +  .536794D+03, .376708D+03, .265208D+03, .186347D+03,
     +  .130713D+03, .915336D+02, .640020D+02, .447443D+02,
     +  .312320D+02, .217942D+02, .152148D+02, .106302D+02,
     +  .743976D+01, .521710D+01, .367095D+01, .259114D+01,
     +  .183621D+01, .130662D+01, .934121D+00, .670611D+00,
     +  .484316D+00, .350410D+00, .255125D+00, .185977D+00,
     +  .136154D+00, .999031D-01, .734575D-01, .540730D-01,
     +  .398351D-01, .293376D-01, .215953D-01, .158744D-01,
     +  .116509D-01, .852918D-02, .622787D-02, .453192D-02,
     +  .328516D-02, .237458D-02, .170547D-02, .121868D-02,
     +  .866945D-03, .613810D-03, .432958D-03, .304279D-03,
     +  .213437D-03, .149505D-03, .104818D-03, .736202D-04,
     +  .520874D-04, .369470D-04, .263476D-04, .188410D-04 /
        DATA (UPDI(I),I=2445,2496) /
     +  .134691D-04, .956793D-05, .670660D-05, .459526D-05,
     +  .303505D-05, .190796D-05, .111669D-05, .589888D-06,
     +  .267508D-06, .947379D-07, .215649D-07, .185392D-08,
     +  .000000D+00, .327069D+07, .242802D+07, .176521D+07,
     +  .128227D+07, .930662D+06, .674806D+06, .488842D+06,
     +  .353755D+06, .255745D+06, .184681D+06, .133221D+06,
     +  .959840D+05, .690751D+05, .496449D+05, .356355D+05,
     +  .255432D+05, .182842D+05, .130679D+05, .932595D+04,
     +  .664436D+04, .472632D+04, .335584D+04, .237867D+04,
     +  .168273D+04, .118820D+04, .837164D+03, .588926D+03,
     +  .411330D+03, .288208D+03, .201533D+03, .140672D+03,
     +  .980184D+02, .681893D+02, .474271D+02, .329310D+02,
     +  .228574D+02, .158704D+02, .110272D+02, .767432D+01 /
        DATA (UPDI(I),I=2497,2548) /
     +  .535097D+01, .374335D+01, .262675D+01, .185036D+01,
     +  .130878D+01, .929960D+00, .663519D+00, .476231D+00,
     +  .342408D+00, .247732D+00, .179449D+00, .130544D+00,
     +  .951828D-01, .695432D-01, .508683D-01, .372368D-01,
     +  .272519D-01, .199344D-01, .145627D-01, .106223D-01,
     +  .772910D-02, .560992D-02, .405855D-02, .292527D-02,
     +  .210296D-02, .150258D-02, .106864D-02, .757006D-03,
     +  .534081D-03, .375686D-03, .263573D-03, .184766D-03,
     +  .129510D-03, .909836D-04, .641085D-04, .455370D-04,
     +  .324417D-04, .232259D-04, .166574D-04, .119218D-04,
     +  .846066D-05, .590910D-05, .402431D-05, .263436D-05,
     +  .163714D-05, .944382D-06, .490085D-06, .217391D-06,
     +  .749346D-07, .165955D-07, .144579D-08, .000000D+00 /
        DATA (UPDI(I),I=2549,2600) /
     +  .211749D+05, .127778D+05, .102457D+05, .821536D+04,
     +  .658739D+04, .528205D+04, .423539D+04, .339615D+04,
     +  .272322D+04, .218365D+04, .175101D+04, .140410D+04,
     +  .112594D+04, .902906D+03, .724067D+03, .580667D+03,
     +  .465684D+03, .373485D+03, .299556D+03, .240275D+03,
     +  .192740D+03, .154623D+03, .124058D+03, .995476D+02,
     +  .798924D+02, .641300D+02, .514890D+02, .412223D+02,
     +  .331192D+02, .266188D+02, .214035D+02, .172187D+02,
     +  .138602D+02, .111715D+02, .900698D+01, .726910D+01,
     +  .587309D+01, .475092D+01, .384808D+01, .312059D+01,
     +  .253445D+01, .206065D+01, .167716D+01, .136612D+01,
     +  .111334D+01, .907501D+00, .740144D+00, .602510D+00,
     +  .490550D+00, .398270D+00, .322940D+00, .261199D+00 /
        DATA (UPDI(I),I=2601,2652) /
     +  .210629D+00, .169254D+00, .135459D+00, .107921D+00,
     +  .855464D-01, .674319D-01, .528276D-01, .411097D-01,
     +  .317582D-01, .243398D-01, .184938D-01, .139391D-01,
     +  .103818D-01, .764693D-02, .556476D-02, .399634D-02,
     +  .282871D-02, .197064D-02, .134902D-02, .905757D-03,
     +  .595034D-03, .381314D-03, .238736D-03, .144533D-03,
     +  .845292D-04, .475080D-04, .254943D-04, .129572D-04,
     +  .617225D-05, .272227D-05, .108491D-05, .383655D-06,
     +  .115450D-06, .278716D-07, .489045D-08, .518188D-09,
     +  .218723D-10, .971975D-13, .000000D+00, .740706D+05,
     +  .573171D+05, .437778D+05, .334525D+05, .255767D+05,
     +  .195645D+05, .149744D+05, .114671D+05, .878680D+04,
     +  .673670D+04, .516842D+04, .396755D+04, .304791D+04 /
        DATA (UPDI(I),I=2653,2704) /
     +  .234289D+04, .180235D+04, .138743D+04, .106892D+04,
     +  .824109D+03, .635931D+03, .491091D+03, .379610D+03,
     +  .293677D+03, .227433D+03, .176289D+03, .136799D+03,
     +  .106266D+03, .826625D+02, .641426D+02, .500246D+02,
     +  .390622D+02, .305527D+02, .239314D+02, .187793D+02,
     +  .147717D+02, .116375D+02, .918703D+01, .727070D+01,
     +  .576694D+01, .458637D+01, .365559D+01, .292206D+01,
     +  .234053D+01, .187890D+01, .151084D+01, .121686D+01,
     +  .980971D+00, .792070D+00, .638648D+00, .515533D+00,
     +  .415151D+00, .334138D+00, .268368D+00, .215033D+00,
     +  .171760D+00, .136722D+00, .108373D+00, .855082D-01,
     +  .671113D-01, .523782D-01, .406174D-01, .312846D-01,
     +  .239142D-01, .181311D-01, .136426D-01, .101484D-01 /
        DATA (UPDI(I),I=2705,2756) /
     +  .746751D-02, .543109D-02, .389888D-02, .275966D-02,
     +  .192211D-02, .131528D-02, .881558D-03, .577216D-03,
     +  .366783D-03, .226223D-03, .132932D-03, .734517D-04,
     +  .368401D-04, .153477D-04, .359555D-05, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .144113D+06, .110710D+06,
     +  .838375D+05, .634942D+05, .480978D+05, .364382D+05,
     +  .276118D+05, .209259D+05, .158632D+05, .120271D+05,
     +  .912155D+04, .691912D+04, .525035D+04, .398490D+04,
     +  .302571D+04, .229798D+04, .174613D+04, .132721D+04,
     +  .100935D+04, .767916D+03, .584624D+03, .445298D+03,
     +  .339438D+03, .258901D+03, .197650D+03, .151015D+03 /
        DATA (UPDI(I),I=2757,2808) /
     +  .115534D+03, .881349D+02, .675873D+02, .518908D+02,
     +  .399094D+02, .307405D+02, .237260D+02, .183603D+02,
     +  .142350D+02, .110627D+02, .862320D+01, .673959D+01,
     +  .528473D+01, .415532D+01, .327900D+01, .259432D+01,
     +  .205860D+01, .163719D+01, .130509D+01, .104184D+01,
     +  .833586D+00, .666278D+00, .533518D+00, .426329D+00,
     +  .340671D+00, .271745D+00, .216347D+00, .171760D+00,
     +  .135947D+00, .107177D+00, .841374D-01, .657199D-01,
     +  .510672D-01, .394377D-01, .302641D-01, .230571D-01,
     +  .174311D-01, .130850D-01, .971664D-02, .714177D-02,
     +  .519329D-02, .373160D-02, .264803D-02, .185271D-02,
     +  .127736D-02, .866089D-03, .577094D-03, .376449D-03,
     +  .241629D-03, .151022D-03, .922244D-04, .548009D-04 /
        DATA (UPDI(I),I=2809,2860) /
     +  .317118D-04, .177908D-04, .970894D-05, .513282D-05,
     +  .263613D-05, .130768D-05, .628303D-06, .284726D-06,
     +  .119867D-06, .439626D-07, .119743D-07, .809417D-09,
     +  .000000D+00, .228412D+06, .174773D+06, .131726D+06,
     +  .992707D+05, .748143D+05, .563753D+05, .424825D+05,
     +  .320093D+05, .241193D+05, .181721D+05, .136923D+05,
     +  .103158D+05, .777279D+04, .585623D+04, .441286D+04,
     +  .332510D+04, .250595D+04, .188860D+04, .142371D+04,
     +  .107332D+04, .809469D+03, .610578D+03, .460773D+03,
     +  .347822D+03, .262718D+03, .198542D+03, .150201D+03,
     +  .113253D+03, .858374D+02, .651202D+02, .494813D+02,
     +  .376492D+02, .287017D+02, .219381D+02, .168000D+02,
     +  .128967D+02, .993162D+01, .767007D+01, .594461D+01 /
        DATA (UPDI(I),I=2861,2912) /
     +  .462134D+01, .360694D+01, .282368D+01, .221791D+01,
     +  .174676D+01, .137955D+01, .109152D+01, .866016D+00,
     +  .686605D+00, .545620D+00, .432809D+00, .343450D+00,
     +  .272143D+00, .215296D+00, .169893D+00, .133697D+00,
     +  .104821D+00, .818544D-01, .636147D-01, .491959D-01,
     +  .378202D-01, .288997D-01, .219303D-01, .165185D-01,
     +  .123590D-01, .915078D-02, .670920D-02, .486972D-02,
     +  .349520D-02, .248009D-02, .173730D-02, .120144D-02,
     +  .819092D-03, .550646D-03, .364148D-03, .238512D-03,
     +  .153580D-03, .979245D-04, .618581D-04, .389956D-04,
     +  .245614D-04, .156080D-04, .996710D-05, .639407D-05,
     +  .405956D-05, .251196D-05, .146122D-05, .767596D-06,
     +  .336643D-06, .998028D-07, .762429D-08, .000000D+00 /
        DATA (UPDI(I),I=2913,2964) /
     +  .255405D+06, .251557D+06, .188906D+06, .141823D+06,
     +  .106464D+06, .798971D+05, .599535D+05, .449750D+05,
     +  .337352D+05, .252969D+05, .189675D+05, .142176D+05,
     +  .106563D+05, .798484D+04, .598274D+04, .448147D+04,
     +  .335684D+04, .251385D+04, .188261D+04, .140963D+04,
     +  .105560D+04, .790415D+03, .591973D+03, .443361D+03,
     +  .332170D+03, .248926D+03, .186696D+03, .139504D+03,
     +  .104767D+03, .787371D+02, .592545D+02, .446446D+02,
     +  .336959D+02, .254966D+02, .193267D+02, .146849D+02,
     +  .111934D+02, .855696D+01, .656551D+01, .505370D+01,
     +  .390636D+01, .302933D+01, .235771D+01, .184046D+01,
     +  .144118D+01, .113092D+01, .890219D+00, .700419D+00,
     +  .552561D+00, .435238D+00, .343056D+00, .270072D+00 /
        DATA (UPDI(I),I=2965,3016) /
     +  .212328D+00, .166548D+00, .130309D+00, .101595D+00,
     +  .789096D-01, .610087D-01, .469458D-01, .359177D-01,
     +  .273206D-01, .206418D-01, .154838D-01, .115401D-01,
     +  .851377D-02, .622187D-02, .450336D-02, .322500D-02,
     +  .228491D-02, .159966D-02, .110704D-02, .756565D-03,
     +  .511012D-03, .340609D-03, .225727D-03, .147864D-03,
     +  .965321D-04, .629038D-04, .412082D-04, .271425D-04,
     +  .180825D-04, .120867D-04, .805910D-05, .526922D-05,
     +  .331822D-05, .194460D-05, .101812D-05, .439463D-06,
     +  .126536D-06, .982630D-08, .000000D+00, .470033D+06,
     +  .357432D+06, .267427D+06, .200017D+06, .149563D+06,
     +  .111791D+06, .835377D+05, .623991D+05, .465973D+05,
     +  .347824D+05, .259563D+05, .193615D+05, .144384D+05 /
        DATA (UPDI(I),I=3017,3068) /
     +  .107624D+05, .802027D+04, .597424D+04, .444909D+04,
     +  .331193D+04, .246491D+04, .183382D+04, .136413D+04,
     +  .101443D+04, .754329D+03, .560804D+03, .416953D+03,
     +  .309998D+03, .230604D+03, .170844D+03, .127189D+03,
     +  .947358D+02, .706387D+02, .527222D+02, .394085D+02,
     +  .295281D+02, .221592D+02, .166680D+02, .125760D+02,
     +  .951652D+01, .722778D+01, .550776D+01, .421517D+01,
     +  .323712D+01, .249543D+01, .192996D+01, .149763D+01,
     +  .116496D+01, .909284D+00, .709556D+00, .555356D+00,
     +  .434094D+00, .339624D+00, .265465D+00, .207263D+00,
     +  .161489D+00, .125528D+00, .972517D-01, .750709D-01,
     +  .576942D-01, .441354D-01, .335750D-01, .253953D-01,
     +  .190820D-01, .142353D-01, .105521D-01, .774182D-02 /
        DATA (UPDI(I),I=3069,3120) /
     +  .562600D-02, .404834D-02, .288139D-02, .202785D-02,
     +  .140919D-02, .966847D-03, .653968D-03, .436084D-03,
     +  .285977D-03, .185578D-03, .118243D-03, .744266D-04,
     +  .462687D-04, .285676D-04, .175310D-04, .107808D-04,
     +  .662867D-05, .407918D-05, .248171D-05, .147363D-05,
     +  .824615D-06, .418336D-06, .176958D-06, .505124D-07,
     +  .389011D-08, .000000D+00, .642312D+06, .486991D+06,
     +  .363081D+06, .270583D+06, .201581D+06, .150101D+06,
     +  .111728D+06, .831221D+05, .618168D+05, .459480D+05,
     +  .341392D+05, .253515D+05, .188181D+05, .139606D+05,
     +  .103527D+05, .767289D+04, .568443D+04, .420889D+04,
     +  .311517D+04, .230441D+04, .170410D+04, .125955D+04,
     +  .930721D+03, .687460D+03, .507696D+03, .374848D+03 /
        DATA (UPDI(I),I=3121,3172) /
     +  .276850D+03, .203573D+03, .150399D+03, .111147D+03,
     +  .822053D+02, .608472D+02, .450943D+02, .334959D+02,
     +  .249136D+02, .185716D+02, .138845D+02, .104105D+02,
     +  .783401D+01, .591507D+01, .448563D+01, .341384D+01,
     +  .260827D+01, .199969D+01, .153849D+01, .118679D+01,
     +  .918811D+00, .711309D+00, .552451D+00, .428583D+00,
     +  .332866D+00, .258341D+00, .200306D+00, .155020D+00,
     +  .119707D+00, .921474D-01, .706840D-01, .539904D-01,
     +  .410539D-01, .310482D-01, .233494D-01, .174470D-01,
     +  .129443D-01, .954424D-02, .696605D-02, .503710D-02,
     +  .360743D-02, .255632D-02, .179191D-02, .124104D-02,
     +  .849267D-03, .573600D-03, .382485D-03, .251413D-03,
     +  .163988D-03, .105469D-03, .673502D-04, .427661D-04 /
        DATA (UPDI(I),I=3173,3224) /
     +  .271623D-04, .172796D-04, .110711D-04, .711084D-05,
     +  .455407D-05, .286506D-05, .173821D-05, .982113D-06,
     +  .495116D-06, .203991D-06, .554710D-07, .438140D-08,
     +  .000000D+00, .852377D+06, .644369D+06, .478750D+06,
     +  .355520D+06, .263899D+06, .195777D+06, .145174D+06,
     +  .107586D+06, .796926D+05, .589939D+05, .436495D+05,
     +  .322753D+05, .238525D+05, .176160D+05, .130031D+05,
     +  .959157D+04, .707126D+04, .520956D+04, .383596D+04,
     +  .282259D+04, .207591D+04, .152576D+04, .112092D+04,
     +  .823014D+03, .604071D+03, .443174D+03, .325173D+03,
     +  .237473D+03, .174226D+03, .127837D+03, .938532D+02,
     +  .689445D+02, .506984D+02, .373607D+02, .275625D+02,
     +  .203768D+02, .151063D+02, .112309D+02, .837920D+01 /
        DATA (UPDI(I),I=3225,3276) /
     +  .627276D+01, .471631D+01, .355904D+01, .269637D+01,
     +  .205014D+01, .156445D+01, .119716D+01, .919593D+00,
     +  .706440D+00, .544557D+00, .419355D+00, .323360D+00,
     +  .249208D+00, .191898D+00, .147519D+00, .113164D+00,
     +  .865499D-01, .659701D-01, .500779D-01, .378467D-01,
     +  .284520D-01, .212715D-01, .158034D-01, .116587D-01,
     +  .854917D-02, .620617D-02, .446442D-02, .318150D-02,
     +  .224413D-02, .156648D-02, .108103D-02, .737708D-03,
     +  .497431D-03, .331643D-03, .218457D-03, .143177D-03,
     +  .928820D-04, .600847D-04, .388509D-04, .252443D-04,
     +  .164959D-04, .108664D-04, .716662D-05, .468799D-05,
     +  .299406D-05, .182869D-05, .103259D-05, .515494D-06,
     +  .208108D-06, .549347D-07, .440708D-08, .000000D+00 /
        DATA (UPDI(I),I=3277,3328) /
     +  .110666D+07, .834151D+06, .617599D+06, .457008D+06,
     +  .338008D+06, .249833D+06, .184562D+06, .136252D+06,
     +  .100531D+06, .741228D+05, .546194D+05, .402181D+05,
     +  .295957D+05, .217621D+05, .159918D+05, .117422D+05,
     +  .861618D+04, .631726D+04, .462868D+04, .338870D+04,
     +  .247934D+04, .181257D+04, .132433D+04, .966900D+03,
     +  .705574D+03, .514550D+03, .375229D+03, .272276D+03,
     +  .198463D+03, .144650D+03, .105467D+03, .769310D+02,
     +  .561617D+02, .410814D+02, .300777D+02, .220648D+02,
     +  .162292D+02, .119700D+02, .885902D+01, .657858D+01,
     +  .490633D+01, .367266D+01, .276016D+01, .208203D+01,
     +  .157633D+01, .119693D+01, .912447D+00, .695704D+00,
     +  .532353D+00, .407000D+00, .311616D+00, .238496D+00 /
        DATA (UPDI(I),I=3329,3380) /
     +  .182401D+00, .139284D+00, .106145D+00, .806589D-01,
     +  .610899D-01, .460847D-01, .346148D-01, .258657D-01,
     +  .192232D-01, .141987D-01, .104149D-01, .759440D-02,
     +  .548285D-02, .392334D-02, .278188D-02, .195309D-02,
     +  .135756D-02, .933495D-03, .635268D-03, .427678D-03,
     +  .285130D-03, .188232D-03, .123953D-03, .810702D-04,
     +  .530624D-04, .348468D-04, .230580D-04, .153665D-04,
     +  .103088D-04, .690321D-05, .455948D-05, .292393D-05,
     +  .178131D-05, .997483D-06, .490304D-06, .193228D-06,
     +  .494963D-07, .402796D-08, .000000D+00, .141199D+07,
     +  .106116D+07, .782925D+06, .577287D+06, .425423D+06,
     +  .313287D+06, .230571D+06, .169568D+06, .124626D+06,
     +  .915242D+05, .671695D+05, .492554D+05, .360936D+05 /
        DATA (UPDI(I),I=3381,3432) /
     +  .264264D+05, .193342D+05, .141328D+05, .103230D+05,
     +  .753329D+04, .549327D+04, .400199D+04, .291337D+04,
     +  .211894D+04, .154003D+04, .111830D+04, .811534D+03,
     +  .588445D+03, .426603D+03, .307669D+03, .222877D+03,
     +  .161417D+03, .116926D+03, .847211D+02, .614250D+02,
     +  .446177D+02, .324326D+02, .236187D+02, .172429D+02,
     +  .126220D+02, .927032D+01, .683124D+01, .505550D+01,
     +  .375519D+01, .280049D+01, .209634D+01, .157514D+01,
     +  .118707D+01, .898254D+00, .679879D+00, .516512D+00,
     +  .392092D+00, .298113D+00, .226605D+00, .172140D+00,
     +  .130578D+00, .988611D-01, .746414D-01, .561743D-01,
     +  .421126D-01, .314367D-01, .233489D-01, .172493D-01,
     +  .126664D-01, .923735D-02, .669787D-02, .480898D-02 /
        DATA (UPDI(I),I=3433,3484) /
     +  .342298D-02, .241494D-02, .168762D-02, .116816D-02,
     +  .800479D-03, .543342D-03, .365300D-03, .243614D-03,
     +  .161224D-03, .106689D-03, .703360D-04, .465384D-04,
     +  .309770D-04, .208009D-04, .140658D-04, .954991D-05,
     +  .644866D-05, .427250D-05, .273500D-05, .165409D-05,
     +  .914987D-06, .441549D-06, .169553D-06, .421313D-07,
     +  .347691D-08, .000000D+00, .177544D+07, .133036D+07,
     +  .978081D+06, .718609D+06, .527645D+06, .387132D+06,
     +  .283851D+06, .207956D+06, .152247D+06, .111368D+06,
     +  .814043D+05, .594499D+05, .433826D+05, .316284D+05,
     +  .230401D+05, .167676D+05, .121924D+05, .885671D+04,
     +  .642805D+04, .466061D+04, .337624D+04, .244331D+04,
     +  .176669D+04, .127618D+04, .921133D+03, .664231D+03 /
        DATA (UPDI(I),I=3485,3536) /
     +  .478827D+03, .343310D+03, .247221D+03, .177961D+03,
     +  .128107D+03, .922302D+02, .664314D+02, .479324D+02,
     +  .346034D+02, .250239D+02, .181389D+02, .131823D+02,
     +  .961120D+01, .703037D+01, .516436D+01, .380762D+01,
     +  .281852D+01, .209428D+01, .156202D+01, .116861D+01,
     +  .877928D+00, .659747D+00, .497694D+00, .375178D+00,
     +  .283299D+00, .213893D+00, .161401D+00, .121630D+00,
     +  .914891D-01, .686344D-01, .513278D-01, .382404D-01,
     +  .283708D-01, .209446D-01, .153810D-01, .112285D-01,
     +  .814161D-02, .587025D-02, .419169D-02, .296801D-02,
     +  .208362D-02, .144951D-02, .999337D-03, .682576D-03,
     +  .462253D-03, .310478D-03, .207201D-03, .137518D-03,
     +  .914702D-04, .607760D-04, .406188D-04, .273548D-04 /
        DATA (UPDI(I),I=3537,3588) /
     +  .185871D-04, .127032D-04, .868947D-05, .588950D-05,
     +  .389788D-05, .248179D-05, .148588D-05, .810130D-06,
     +  .383197D-06, .143255D-06, .345435D-07, .289033D-08,
     +  .000000D+00, .220422D+07, .164675D+07, .120641D+07,
     +  .883186D+06, .646126D+06, .472311D+06, .345005D+06,
     +  .251797D+06, .183630D+06, .133796D+06, .974079D+05,
     +  .708485D+05, .514869D+05, .373792D+05, .271128D+05,
     +  .196457D+05, .142218D+05, .102842D+05, .742973D+04,
     +  .536157D+04, .386540D+04, .278362D+04, .200270D+04,
     +  .143927D+04, .103342D+04, .741207D+03, .531389D+03,
     +  .378832D+03, .271237D+03, .194104D+03, .138887D+03,
     +  .993771D+02, .711281D+02, .509918D+02, .365697D+02,
     +  .262686D+02, .189111D+02, .136483D+02, .988107D+01 /
        DATA (UPDI(I),I=3589,3640) /
     +  .717657D+01, .523411D+01, .383139D+01, .281575D+01,
     +  .207723D+01, .153824D+01, .114265D+01, .852393D+00,
     +  .636078D+00, .476530D+00, .356766D+00, .267578D+00,
     +  .200680D+00, .150435D+00, .112630D+00, .841747D-01,
     +  .627470D-01, .466311D-01, .345268D-01, .254593D-01,
     +  .186823D-01, .136383D-01, .989858D-02, .713624D-02,
     +  .511677D-02, .363392D-02, .255987D-02, .178847D-02,
     +  .123878D-02, .850838D-03, .579435D-03, .391650D-03,
     +  .262914D-03, .175668D-03, .116970D-03, .782212D-04,
     +  .523703D-04, .353254D-04, .240294D-04, .164805D-04,
     +  .113476D-04, .779364D-05, .528434D-05, .348360D-05,
     +  .220083D-05, .130205D-05, .698709D-06, .323625D-06,
     +  .117747D-06, .275729D-07, .233873D-08, .000000D+00 /
        DATA (UPDI(I),I=3641,3692) /
     +  .270550D+07, .201526D+07, .147113D+07, .107312D+07,
     +  .782216D+06, .569680D+06, .414570D+06, .301419D+06,
     +  .218970D+06, .158921D+06, .115239D+06, .834799D+05,
     +  .604175D+05, .436801D+05, .315488D+05, .227615D+05,
     +  .164052D+05, .118102D+05, .849342D+04, .610084D+04,
     +  .437765D+04, .313737D+04, .224614D+04, .160615D+04,
     +  .114736D+04, .818616D+03, .583753D+03, .413863D+03,
     +  .294667D+03, .209672D+03, .149152D+03, .106087D+03,
     +  .754677D+02, .537673D+02, .383150D+02, .273442D+02,
     +  .195555D+02, .140189D+02, .100806D+02, .727131D+01,
     +  .526652D+01, .382833D+01, .279388D+01, .204674D+01,
     +  .150511D+01, .111028D+01, .822561D+00, .609608D+00,
     +  .453607D+00, .337319D+00, .251312D+00, .187244D+00 /
        DATA (UPDI(I),I=3693,3744) /
     +  .139451D+00, .103735D+00, .770343D-01, .570637D-01,
     +  .421442D-01, .310134D-01, .227300D-01, .165801D-01,
     +  .120327D-01, .868299D-02, .622449D-02, .443859D-02,
     +  .313558D-02, .219778D-02, .152838D-02, .105426D-02,
     +  .721587D-03, .490136D-03, .330793D-03, .222045D-03,
     +  .148608D-03, .993127D-04, .667805D-04, .450393D-04,
     +  .306343D-04, .210140D-04, .145148D-04, .100419D-04,
     +  .690620D-05, .467263D-05, .306182D-05, .191612D-05,
     +  .111878D-05, .590314D-06, .267570D-06, .947435D-07,
     +  .215651D-07, .185392D-08, .000000D+00, .328622D+07,
     +  .244057D+07, .177527D+07, .129033D+07, .937123D+06,
     +  .679983D+06, .492991D+06, .357079D+06, .258408D+06,
     +  .186814D+06, .134930D+06, .973524D+05, .701707D+05 /
        DATA (UPDI(I),I=3745,3796) /
     +  .505218D+05, .363373D+05, .261046D+05, .187331D+05,
     +  .134267D+05, .961271D+04, .687338D+04, .490910D+04,
     +  .350164D+04, .249487D+04, .177526D+04, .126182D+04,
     +  .895670D+03, .635369D+03, .448028D+03, .317261D+03,
     +  .224499D+03, .158795D+03, .112293D+03, .794099D+02,
     +  .562357D+02, .398271D+02, .282451D+02, .200707D+02,
     +  .142951D+02, .102115D+02, .731681D+01, .526391D+01,
     +  .380059D+01, .275481D+01, .200441D+01, .146397D+01,
     +  .107261D+01, .789307D+00, .581028D+00, .429467D+00,
     +  .317253D+00, .234815D+00, .173821D+00, .128623D+00,
     +  .950735D-01, .701576D-01, .516466D-01, .379090D-01,
     +  .277275D-01, .201998D-01, .146476D-01, .105685D-01,
     +  .758308D-02, .540573D-02, .383404D-02, .269451D-02 /
        DATA (UPDI(I),I=3797,3848) /
     +  .187949D-02, .130126D-02, .894122D-03, .610043D-03,
     +  .413451D-03, .278741D-03, .187180D-03, .125540D-03,
     +  .842280D-04, .569523D-04, .386768D-04, .265004D-04,
     +  .183023D-04, .127059D-04, .881251D-05, .605570D-05,
     +  .408050D-05, .265357D-05, .164292D-05, .945841D-06,
     +  .490379D-06, .217434D-06, .749383D-07, .165957D-07,
     +  .144579D-08, .000000D+00, .159314D+05, .255729D+05,
     +  .205063D+05, .164437D+05, .131860D+05, .105739D+05,
     +  .847935D+04, .679981D+04, .545304D+04, .437310D+04,
     +  .350712D+04, .281271D+04, .225587D+04, .180933D+04,
     +  .145126D+04, .116410D+04, .933829D+03, .749160D+03,
     +  .601062D+03, .482289D+03, .387033D+03, .310635D+03,
     +  .249360D+03, .200211D+03, .160788D+03, .129163D+03 /
        DATA (UPDI(I),I=3849,3900) /
     +  .103793D+03, .831815D+02, .669076D+02, .538473D+02,
     +  .433647D+02, .349497D+02, .281933D+02, .227819D+02,
     +  .184232D+02, .149219D+02, .121076D+02, .984390D+01,
     +  .802104D+01, .655053D+01, .536388D+01, .440259D+01,
     +  .362216D+01, .298658D+01, .246723D+01, .204134D+01,
     +  .169200D+01, .140161D+01, .116235D+01, .962218D+00,
     +  .796092D+00, .657399D+00, .541495D+00, .444611D+00,
     +  .363671D+00, .296145D+00, .239937D+00, .193295D+00,
     +  .154741D+00, .123021D+00, .970659D-01, .759569D-01,
     +  .589071D-01, .452967D-01, .344098D-01, .258407D-01,
     +  .191645D-01, .140207D-01, .101059D-01, .716643D-02,
     +  .499168D-02, .340885D-02, .227688D-02, .148298D-02,
     +  .943207D-03, .579943D-03, .344349D-03, .196419D-03 /
        DATA (UPDI(I),I=3901,3952) /
     +  .106940D-03, .551253D-04, .266250D-04, .119026D-04,
     +  .480696D-05, .172203D-05, .524804D-06, .128280D-06,
     +  .227838D-07, .244308D-08, .104331D-09, .468971D-12,
     +  .000000D+00, .898777D+05, .700923D+05, .540223D+05,
     +  .416679D+05, .321649D+05, .248479D+05, .192115D+05,
     +  .148652D+05, .115121D+05, .892249D+04, .692155D+04,
     +  .537371D+04, .417582D+04, .324766D+04, .252816D+04,
     +  .196972D+04, .153611D+04, .119898D+04, .936753D+03,
     +  .732522D+03, .573402D+03, .449256D+03, .352358D+03,
     +  .276623D+03, .217403D+03, .171041D+03, .134736D+03,
     +  .105894D+03, .836257D+02, .661208D+02, .523592D+02,
     +  .415212D+02, .329830D+02, .262632D+02, .209443D+02,
     +  .167389D+02, .134120D+02, .107737D+02, .867938D+01 /
        DATA (UPDI(I),I=3953,4004) /
     +  .701139D+01, .568263D+01, .461850D+01, .376443D+01,
     +  .307605D+01, .251945D+01, .206726D+01, .169995D+01,
     +  .139721D+01, .115010D+01, .945099D+00, .776388D+00,
     +  .636664D+00, .520866D+00, .424830D+00, .345237D+00,
     +  .279340D+00, .224905D+00, .180068D+00, .143285D+00,
     +  .113237D+00, .888269D-01, .691153D-01, .532994D-01,
     +  .407609D-01, .307958D-01, .230018D-01, .169675D-01,
     +  .123468D-01, .885164D-02, .624240D-02, .432322D-02,
     +  .293398D-02, .194643D-02, .125704D-02, .791215D-03,
     +  .479416D-03, .278517D-03, .153385D-03, .785232D-04,
     +  .360060D-04, .133478D-04, .246171D-05, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=4005,4056) /
     +  .159898D+06, .123467D+06, .940674D+05, .716977D+05,
     +  .546765D+05, .417139D+05, .318427D+05, .243189D+05,
     +  .185844D+05, .142096D+05, .108719D+05, .832300D+04,
     +  .637638D+04, .488812D+04, .375022D+04, .287919D+04,
     +  .221240D+04, .170130D+04, .130952D+04, .100878D+04,
     +  .777932D+03, .600456D+03, .463995D+03, .358911D+03,
     +  .277967D+03, .215534D+03, .167379D+03, .129681D+03,
     +  .101002D+03, .787808D+02, .615623D+02, .481900D+02,
     +  .378013D+02, .297341D+02, .234336D+02, .185149D+02,
     +  .146727D+02, .116617D+02, .929964D+01, .743899D+01,
     +  .597287D+01, .481062D+01, .388709D+01, .314969D+01,
     +  .255901D+01, .208328D+01, .170023D+01, .138708D+01,
     +  .113363D+01, .925006D+00, .754686D+00, .614711D+00 /
        DATA (UPDI(I),I=4057,4108) /
     +  .499603D+00, .404859D+00, .326928D+00, .262879D+00,
     +  .210356D+00, .167404D+00, .132420D+00, .104042D+00,
     +  .811489D-01, .627903D-01, .481569D-01, .366336D-01,
     +  .275345D-01, .204632D-01, .150231D-01, .108834D-01,
     +  .777132D-02, .546171D-02, .377276D-02, .255682D-02,
     +  .169693D-02, .109913D-02, .696755D-03, .427910D-03,
     +  .254724D-03, .146354D-03, .808804D-04, .427737D-04,
     +  .215789D-04, .103497D-04, .470181D-05, .203265D-05,
     +  .844041D-06, .336211D-06, .128765D-06, .448955D-07,
     +  .120139D-07, .809615D-09, .000000D+00, .244176D+06,
     +  .187513D+06, .141942D+06, .107463D+06, .813840D+05,
     +  .616438D+05, .467075D+05, .353976D+05, .268366D+05,
     +  .203513D+05, .154400D+05, .117176D+05, .889704D+04 /
        DATA (UPDI(I),I=4109,4160) /
     +  .675796D+04, .513614D+04, .390526D+04, .297135D+04,
     +  .226195D+04, .172323D+04, .131364D+04, .100230D+04,
     +  .765320D+03, .584964D+03, .447509D+03, .342749D+03,
     +  .262805D+03, .201816D+03, .154593D+03, .119065D+03,
     +  .918402D+02, .709795D+02, .549575D+02, .426478D+02,
     +  .331936D+02, .258902D+02, .202495D+02, .158898D+02,
     +  .125082D+02, .988227D+01, .783393D+01, .623539D+01,
     +  .497976D+01, .399098D+01, .320832D+01, .258670D+01,
     +  .209011D+01, .169350D+01, .137176D+01, .111341D+01,
     +  .902341D+00, .731325D+00, .591811D+00, .477926D+00,
     +  .384866D+00, .308871D+00, .246852D+00, .196350D+00,
     +  .155338D+00, .122163D+00, .954348D-01, .740180D-01,
     +  .569579D-01, .434465D-01, .328758D-01, .245816D-01 /
        DATA (UPDI(I),I=4161,4212) /
     +  .181762D-01, .132792D-01, .957555D-02, .680818D-02,
     +  .476648D-02, .328204D-02, .221924D-02, .147162D-02,
     +  .954227D-03, .607389D-03, .376275D-03, .227567D-03,
     +  .134289D-03, .775492D-04, .439698D-04, .247364D-04,
     +  .139372D-04, .794774D-05, .459822D-05, .267007D-05,
     +  .149842D-05, .773927D-06, .337298D-06, .998305D-07,
     +  .762443D-08, .000000D+00, .250163D+06, .264281D+06,
     +  .199109D+06, .150005D+06, .113025D+06, .851586D+05,
     +  .641729D+05, .483587D+05, .364487D+05, .274731D+05,
     +  .207127D+05, .156172D+05, .117788D+05, .888513D+04,
     +  .670481D+04, .506062D+04, .382137D+04, .288646D+04,
     +  .218151D+04, .164940D+04, .124796D+04, .944740D+03,
     +  .715798D+03, .542723D+03, .411911D+03, .312930D+03 /
        DATA (UPDI(I),I=4213,4264) /
     +  .238077D+03, .180633D+03, .137805D+03, .105284D+03,
     +  .805954D+02, .618097D+02, .475112D+02, .366325D+02,
     +  .283074D+02, .219376D+02, .170599D+02, .133111D+02,
     +  .104262D+02, .819574D+01, .647014D+01, .512617D+01,
     +  .407653D+01, .325240D+01, .260302D+01, .208823D+01,
     +  .168020D+01, .135164D+01, .108977D+01, .877372D+00,
     +  .706512D+00, .568115D+00, .455938D+00, .364913D+00,
     +  .291093D+00, .231262D+00, .182870D+00, .143837D+00,
     +  .112473D+00, .873704D-01, .673879D-01, .515735D-01,
     +  .391273D-01, .294514D-01, .219065D-01, .161158D-01,
     +  .117157D-01, .840826D-02, .595168D-02, .414987D-02,
     +  .284738D-02, .192003D-02, .127117D-02, .824252D-03,
     +  .525905D-03, .327733D-03, .200426D-03, .120478D-03 /
        DATA (UPDI(I),I=4265,4316) /
     +  .715907D-04, .423002D-04, .251423D-04, .151261D-04,
     +  .923522D-05, .567220D-05, .343497D-05, .197170D-05,
     +  .102267D-05, .439927D-06, .126555D-06, .982640D-08,
     +  .000000D+00, .485755D+06, .370139D+06, .277616D+06,
     +  .208187D+06, .156115D+06, .117045D+06, .877509D+05,
     +  .657778D+05, .493067D+05, .369552D+05, .276987D+05,
     +  .207588D+05, .155589D+05, .116611D+05, .874098D+04,
     +  .655223D+04, .491264D+04, .368369D+04, .276307D+04,
     +  .207296D+04, .155593D+04, .116827D+04, .877727D+03,
     +  .659786D+03, .496355D+03, .373697D+03, .281712D+03,
     +  .211727D+03, .160004D+03, .121081D+03, .917959D+02,
     +  .697200D+02, .530715D+02, .405251D+02, .310132D+02,
     +  .238052D+02, .183371D+02, .141745D+02, .110007D+02 /
        DATA (UPDI(I),I=4317,4368) /
     +  .856976D+01, .670594D+01, .526740D+01, .415363D+01,
     +  .328677D+01, .260944D+01, .207698D+01, .165838D+01,
     +  .132403D+01, .105967D+01, .846962D+00, .677180D+00,
     +  .540732D+00, .430981D+00, .342609D+00, .271478D+00,
     +  .214261D+00, .168326D+00, .131547D+00, .102210D+00,
     +  .788990D-01, .604751D-01, .459978D-01, .346819D-01,
     +  .259456D-01, .191795D-01, .140220D-01, .101295D-01,
     +  .722331D-02, .507919D-02, .351717D-02, .239557D-02,
     +  .160247D-02, .105142D-02, .674606D-03, .424982D-03,
     +  .260584D-03, .155982D-03, .910869D-04, .520123D-04,
     +  .291210D-04, .161266D-04, .890694D-05, .495121D-05,
     +  .277711D-05, .155817D-05, .844000D-06, .421544D-06,
     +  .177282D-06, .505260D-07, .389019D-08, .000000D+00 /
        DATA (UPDI(I),I=4369,4420) /
     +  .658013D+06, .499680D+06, .373256D+06, .278742D+06,
     +  .208123D+06, .155347D+06, .115935D+06, .864958D+05,
     +  .645221D+05, .481174D+05, .358788D+05, .267465D+05,
     +  .199367D+05, .148577D+05, .110721D+05, .824971D+04,
     +  .614697D+04, .457980D+04, .341259D+04, .254289D+04,
     +  .189533D+04, .141289D+04, .105367D+04, .786045D+03,
     +  .586743D+03, .438229D+03, .327671D+03, .244197D+03,
     +  .182980D+03, .137280D+03, .103170D+03, .776702D+02,
     +  .585984D+02, .443484D+02, .336364D+02, .255893D+02,
     +  .195370D+02, .149699D+02, .115173D+02, .889570D+01,
     +  .690255D+01, .537716D+01, .420583D+01, .330167D+01,
     +  .260084D+01, .205430D+01, .162799D+01, .129014D+01,
     +  .102507D+01, .813441D+00, .645800D+00, .512102D+00 /
        DATA (UPDI(I),I=4421,4472) /
     +  .405368D+00, .320074D+00, .251929D+00, .197521D+00,
     +  .154160D+00, .119699D+00, .924088D-01, .708819D-01,
     +  .539893D-01, .408102D-01, .305804D-01, .227378D-01,
     +  .167060D-01, .121403D-01, .871831D-02, .618104D-02,
     +  .432188D-02, .297669D-02, .201728D-02, .134338D-02,
     +  .878175D-03, .562064D-03, .353844D-03, .217418D-03,
     +  .130941D-03, .773983D-04, .451075D-04, .260628D-04,
     +  .150792D-04, .879989D-05, .519270D-05, .307861D-05,
     +  .179847D-05, .995730D-06, .497335D-06, .204212D-06,
     +  .554802D-07, .438146D-08, .000000D+00, .868058D+06,
     +  .657041D+06, .488912D+06, .363669D+06, .270433D+06,
     +  .201016D+06, .149375D+06, .110955D+06, .823938D+05,
     +  .611599D+05, .453864D+05, .336679D+05, .249692D+05 /
        DATA (UPDI(I),I=4473,4524) /
     +  .185114D+05, .137210D+05, .101672D+05, .753277D+04,
     +  .557957D+04, .413260D+04, .306040D+04, .226655D+04,
     +  .167857D+04, .124340D+04, .921181D+03, .682744D+03,
     +  .506219D+03, .375692D+03, .277825D+03, .206560D+03,
     +  .153747D+03, .114616D+03, .855846D+02, .640367D+02,
     +  .480629D+02, .361490D+02, .272710D+02, .206470D+02,
     +  .156890D+02, .119710D+02, .917068D+01, .705855D+01,
     +  .545499D+01, .423325D+01, .329759D+01, .257790D+01,
     +  .202095D+01, .158980D+01, .125071D+01, .986659D+00,
     +  .777420D+00, .612906D+00, .482681D+00, .379485D+00,
     +  .297627D+00, .232705D+00, .181249D+00, .140539D+00,
     +  .108419D+00, .831648D-01, .633869D-01, .479770D-01,
     +  .360399D-01, .268382D-01, .198330D-01, .144826D-01 /
        DATA (UPDI(I),I=4525,4576) /
     +  .104610D-01, .746762D-02, .526352D-02, .365956D-02,
     +  .250697D-02, .169046D-02, .112077D-02, .730049D-03,
     +  .466208D-03, .293390D-03, .180721D-03, .109550D-03,
     +  .655470D-04, .389462D-04, .231352D-04, .138638D-04,
     +  .841551D-05, .515443D-05, .314800D-05, .187152D-05,
     +  .104212D-05, .517025D-06, .208258D-06, .549409D-07,
     +  .440712D-08, .000000D+00, .112232D+07, .846807D+06,
     +  .627748D+06, .465146D+06, .344533D+06, .255065D+06,
     +  .188758D+06, .139616D+06, .103229D+06, .762855D+05,
     +  .563534D+05, .416084D+05, .307103D+05, .226558D+05,
     +  .167083D+05, .123165D+05, .907662D+04, .668634D+04,
     +  .492451D+04, .362580D+04, .266935D+04, .196483D+04,
     +  .144632D+04, .106463D+04, .783853D+03, .577241D+03 /
        DATA (UPDI(I),I=4577,4628) /
     +  .425429D+03, .312341D+03, .230538D+03, .170325D+03,
     +  .126018D+03, .933797D+02, .693269D+02, .516272D+02,
     +  .385229D+02, .288316D+02, .216549D+02, .163245D+02,
     +  .123575D+02, .939256D+01, .717313D+01, .550094D+01,
     +  .423643D+01, .327531D+01, .254150D+01, .197783D+01,
     +  .154468D+01, .120652D+01, .945105D+00, .739480D+00,
     +  .578980D+00, .452862D+00, .353643D+00, .275512D+00,
     +  .213990D+00, .165582D+00, .127557D+00, .977711D-01,
     +  .745178D-01, .564365D-01, .424478D-01, .316877D-01,
     +  .234506D-01, .172230D-01, .124997D-01, .897403D-02,
     +  .636802D-02, .446239D-02, .308514D-02, .210221D-02,
     +  .141059D-02, .931230D-03, .604571D-03, .385336D-03,
     +  .242508D-03, .149821D-03, .914428D-04, .553731D-04 /
        DATA (UPDI(I),I=4629,4680) /
     +  .334931D-04, .203722D-04, .125445D-04, .782422D-05,
     +  .489926D-05, .303462D-05, .181167D-05, .100414D-05,
     +  .491356D-06, .193330D-06, .495004D-07, .402799D-08,
     +  .000000D+00, .142763D+07, .107380D+07, .793060D+06,
     +  .585413D+06, .431939D+06, .318511D+06, .234760D+06,
     +  .172927D+06, .127319D+06, .936834D+05, .689006D+05,
     +  .506433D+05, .372063D+05, .273183D+05, .200492D+05,
     +  .147059D+05, .107823D+05, .790141D+04, .578826D+04,
     +  .423835D+04, .310272D+04, .227061D+04, .166150D+04,
     +  .121557D+04, .889398D+03, .650762D+03, .476467D+03,
     +  .347432D+03, .254680D+03, .186847D+03, .137256D+03,
     +  .100970D+03, .744100D+02, .550010D+02, .407315D+02,
     +  .302539D+02, .225505D+02, .168704D+02, .126737D+02 /
        DATA (UPDI(I),I=4681,4732) /
     +  .956012D+01, .724624D+01, .551559D+01, .421632D+01,
     +  .323592D+01, .249275D+01, .192598D+01, .149355D+01,
     +  .115837D+01, .901100D+00, .700188D+00, .544485D+00,
     +  .423013D+00, .328128D+00, .253942D+00, .195941D+00,
     +  .150629D+00, .115288D+00, .878001D-01, .664917D-01,
     +  .500396D-01, .374002D-01, .277458D-01, .204058D-01,
     +  .148948D-01, .107438D-01, .766684D-02, .540820D-02,
     +  .376794D-02, .259058D-02, .175602D-02, .117270D-02,
     +  .771063D-03, .499092D-03, .317632D-03, .200016D-03,
     +  .124005D-03, .762394D-04, .467173D-04, .287267D-04,
     +  .178295D-04, .112129D-04, .712598D-05, .451934D-05,
     +  .281436D-05, .167556D-05, .919628D-06, .442272D-06,
     +  .169622D-06, .421341D-07, .347693D-08, .000000D+00 /
        DATA (UPDI(I),I=4733,4784) /
     +  .179106D+07, .134298D+07, .988203D+06, .726725D+06,
     +  .534153D+06, .392349D+06, .288034D+06, .211310D+06,
     +  .154936D+06, .113523D+06, .831325D+05, .608353D+05,
     +  .444931D+05, .325185D+05, .237535D+05, .173393D+05,
     +  .126506D+05, .922381D+04, .672215D+04, .489618D+04,
     +  .356490D+04, .259437D+04, .188761D+04, .137295D+04,
     +  .998557D+03, .726154D+03, .528336D+03, .382754D+03,
     +  .278737D+03, .203133D+03, .148204D+03, .108270D+03,
     +  .792287D+02, .581471D+02, .427511D+02, .315236D+02,
     +  .233252D+02, .173224D+02, .129180D+02, .967318D+01,
     +  .727856D+01, .550009D+01, .417420D+01, .318074D+01,
     +  .243288D+01, .186651D+01, .143738D+01, .110708D+01,
     +  .855317D+00, .660089D+00, .509848D+00, .393461D+00 /
        DATA (UPDI(I),I=4785,4836) /
     +  .303184D+00, .233097D+00, .178684D+00, .136472D+00,
     +  .103781D+00, .785324D-01, .590957D-01, .441934D-01,
     +  .328240D-01, .241996D-01, .176875D-01, .128316D-01,
     +  .919918D-02, .652523D-02, .457589D-02, .316992D-02,
     +  .216757D-02, .146184D-02, .971832D-03, .636601D-03,
     +  .410994D-03, .261308D-03, .164743D-03, .102559D-03,
     +  .635409D-04, .393918D-04, .245903D-04, .155252D-04,
     +  .992298D-05, .638619D-05, .407668D-05, .253853D-05,
     +  .150101D-05, .813354D-06, .383692D-06, .143301D-06,
     +  .345454D-07, .289034D-08, .000000D+00, .221982D+07,
     +  .165936D+07, .121651D+07, .891291D+06, .652624D+06,
     +  .477521D+06, .349182D+06, .255146D+06, .186315D+06,
     +  .135949D+06, .991330D+05, .722314D+05, .525953D+05 /
        DATA (UPDI(I),I=4837,4888) /
     +  .382675D+05, .278247D+05, .202160D+05, .146788D+05,
     +  .106503D+05, .772289D+04, .559632D+04, .405333D+04,
     +  .293403D+04, .212304D+04, .153552D+04, .111038D+04,
     +  .802713D+03, .580525D+03, .417941D+03, .302452D+03,
     +  .219006D+03, .158742D+03, .115199D+03, .837302D+02,
     +  .610318D+02, .445612D+02, .326290D+02, .239733D+02,
     +  .176780D+02, .130898D+02, .973250D+01, .727145D+01,
     +  .545602D+01, .411171D+01, .311127D+01, .236324D+01,
     +  .180057D+01, .137714D+01, .105345D+01, .808400D+00,
     +  .619686D+00, .475455D+00, .364497D+00, .279023D+00,
     +  .213123D+00, .162314D+00, .123172D+00, .930682D-01,
     +  .699783D-01, .523261D-01, .388854D-01, .287016D-01,
     +  .210295D-01, .152757D-01, .110144D-01, .784867D-02 /
        DATA (UPDI(I),I=4889,4940) /
     +  .553420D-02, .385844D-02, .265798D-02, .180789D-02,
     +  .121333D-02, .803186D-03, .524349D-03, .337804D-03,
     +  .214684D-03, .135594D-03, .848122D-04, .529672D-04,
     +  .332088D-04, .210146D-04, .134574D-04, .870596D-05,
     +  .564751D-05, .361274D-05, .224128D-05, .131270D-05,
     +  .700943D-06, .323962D-06, .117778D-06, .275742D-07,
     +  .233874D-08, .000000D+00, .272109D+07, .202785D+07,
     +  .148122D+07, .108121D+07, .788705D+06, .574883D+06,
     +  .418741D+06, .304762D+06, .221650D+06, .161070D+06,
     +  .116962D+06, .848601D+05, .615236D+05, .445664D+05,
     +  .322590D+05, .233305D+05, .168609D+05, .121751D+05,
     +  .878560D+04, .633472D+04, .456480D+04, .328709D+04,
     +  .236587D+04, .170186D+04, .122383D+04, .879683D+03 /
        DATA (UPDI(I),I=4941,4992) /
     +  .632494D+03, .452619D+03, .325566D+03, .234290D+03,
     +  .168753D+03, .121682D+03, .878672D+02, .636266D+02,
     +  .461457D+02, .335616D+02, .244909D+02, .179364D+02,
     +  .131901D+02, .973973D+01, .722688D+01, .538539D+01,
     +  .403070D+01, .302918D+01, .228526D+01, .172937D+01,
     +  .131380D+01, .998251D+00, .760949D+00, .579439D+00,
     +  .441649D+00, .336367D+00, .255815D+00, .194134D+00,
     +  .146901D+00, .110764D+00, .831604D-01, .621337D-01,
     +  .461684D-01, .340954D-01, .250100D-01, .182120D-01,
     +  .131481D-01, .942300D-02, .667445D-02, .467863D-02,
     +  .324336D-02, .222207D-02, .150366D-02, .100447D-02,
     +  .662297D-03, .431080D-03, .277266D-03, .176240D-03,
     +  .111584D-03, .701599D-04, .441750D-04, .279949D-04 /
        DATA (UPDI(I),I=4993,5044) /
     +  .179298D-04, .116148D-04, .757903D-05, .493742D-05,
     +  .315483D-05, .194488D-05, .112624D-05, .591858D-06,
     +  .267800D-06, .947646D-07, .215659D-07, .185393D-08,
     +  .000000D+00, .330178D+07, .245314D+07, .178535D+07,
     +  .129841D+07, .943603D+06, .685178D+06, .497155D+06,
     +  .360417D+06, .261084D+06, .188959D+06, .136649D+06,
     +  .987299D+05, .712744D+05, .514062D+05, .370457D+05,
     +  .266719D+05, .191875D+05, .137905D+05, .990385D+04,
     +  .710634D+04, .509544D+04, .365063D+04, .261395D+04,
     +  .187039D+04, .133777D+04, .956274D+03, .683696D+03,
     +  .486413D+03, .347829D+03, .248821D+03, .178131D+03,
     +  .127652D+03, .915996D+02, .659085D+02, .474924D+02,
     +  .343162D+02, .248768D+02, .180985D+02, .132208D+02 /
        DATA (UPDI(I),I=5045,5096) /
     +  .969732D+01, .714732D+01, .529050D+01, .393321D+01,
     +  .293620D+01, .220035D+01, .165404D+01, .124829D+01,
     +  .942192D+00, .713507D+00, .539749D+00, .408721D+00,
     +  .309274D+00, .233694D+00, .176210D+00, .132487D+00,
     +  .992614D-01, .740543D-01, .549827D-01, .405998D-01,
     +  .297970D-01, .217224D-01, .157213D-01, .112810D-01,
     +  .803650D-02, .565868D-02, .394370D-02, .271863D-02,
     +  .185269D-02, .124753D-02, .829726D-03, .545098D-03,
     +  .353891D-03, .227368D-03, .144632D-03, .918476D-04,
     +  .580763D-04, .368653D-04, .235967D-04, .152709D-04,
     +  .998190D-05, .655052D-05, .427301D-05, .272036D-05,
     +  .166330D-05, .951057D-06, .491442D-06, .217590D-06,
     +  .749524D-07, .165963D-07, .144580D-08, .000000D+00 /
        DATA (UPDI(I),I=5097,5148) /
     +  .158812D+05, .255495D+05, .204854D+05, .164249D+05,
     +  .131693D+05, .105589D+05, .846589D+04, .678774D+04,
     +  .544222D+04, .436341D+04, .349844D+04, .280492D+04,
     +  .224889D+04, .180308D+04, .144564D+04, .115907D+04,
     +  .929313D+03, .745106D+03, .597422D+03, .479020D+03,
     +  .384095D+03, .307992D+03, .246980D+03, .198066D+03,
     +  .158851D+03, .127413D+03, .102207D+03, .817435D+02,
     +  .655981D+02, .526511D+02, .422679D+02, .339400D+02,
     +  .272595D+02, .219140D+02, .176125D+02, .141609D+02,
     +  .113898D+02, .916391D+01, .737463D+01, .593454D+01,
     +  .477611D+01, .384182D+01, .308793D+01, .247909D+01,
     +  .198710D+01, .158946D+01, .126922D+01, .100896D+01,
     +  .800277D+00, .631210D+00, .495948D+00, .387625D+00 /
        DATA (UPDI(I),I=5149,5200) /
     +  .301203D+00, .232551D+00, .178285D+00, .135634D+00,
     +  .102323D+00, .764916D-01, .566156D-01, .414531D-01,
     +  .299945D-01, .214236D-01, .150845D-01, .104718D-01,
     +  .712630D-02, .475365D-02, .309944D-02, .196816D-02,
     +  .121137D-02, .717856D-03, .405555D-03, .214973D-03,
     +  .103772D-03, .426136D-04, .119447D-04, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .898487D+05,
     +  .700663D+05, .539990D+05, .416470D+05, .321462D+05,
     +  .248312D+05, .191965D+05, .148517D+05, .115001D+05,
     +  .891169D+04, .691186D+04, .536503D+04, .416804D+04 /
        DATA (UPDI(I),I=5201,5252) /
     +  .324068D+04, .252190D+04, .196411D+04, .153107D+04,
     +  .119446D+04, .932696D+03, .728878D+03, .570128D+03,
     +  .446311D+03, .349707D+03, .274234D+03, .215248D+03,
     +  .169093D+03, .132973D+03, .104298D+03, .821735D+02,
     +  .647965D+02, .511474D+02, .404085D+02, .319571D+02,
     +  .253132D+02, .200609D+02, .159138D+02, .126383D+02,
     +  .100455D+02, .799218D+01, .636162D+01, .506771D+01,
     +  .403687D+01, .321521D+01, .255902D+01, .203473D+01,
     +  .161519D+01, .128077D+01, .101137D+01, .797398D+00,
     +  .625424D+00, .488950D+00, .380432D+00, .294469D+00,
     +  .226604D+00, .173284D+00, .131585D+00, .991719D-01,
     +  .741297D-01, .549300D-01, .403136D-01, .292871D-01,
     +  .210411D-01, .149362D-01, .104833D-01, .723894D-02 /
        DATA (UPDI(I),I=5253,5304) /
     +  .492031D-02, .328774D-02, .215497D-02, .138300D-02,
     +  .865794D-03, .526987D-03, .309459D-03, .173853D-03,
     +  .910805D-04, .431990D-04, .159574D-04, .154985D-05,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .159866D+06, .123439D+06,
     +  .940417D+05, .716747D+05, .546558D+05, .416954D+05,
     +  .318261D+05, .243041D+05, .185711D+05, .141976D+05,
     +  .108612D+05, .831343D+04, .636780D+04, .488042D+04,
     +  .374333D+04, .287301D+04, .220685D+04, .169632D+04,
     +  .130505D+04, .100477D+04, .774326D+03, .597215D+03,
     +  .461078D+03, .356284D+03, .275599D+03, .213396D+03 /
        DATA (UPDI(I),I=5305,5356) /
     +  .165444D+03, .127931D+03, .994130D+02, .773337D+02,
     +  .602408D+02, .469796D+02, .366885D+02, .287072D+02,
     +  .224825D+02, .176309D+02, .138480D+02, .108902D+02,
     +  .857613D+01, .675966D+01, .533471D+01, .421169D+01,
     +  .332604D+01, .262584D+01, .207195D+01, .163279D+01,
     +  .128595D+01, .100887D+01, .790682D+00, .616659D+00,
     +  .479601D+00, .371376D+00, .286226D+00, .219418D+00,
     +  .167241D+00, .126648D+00, .952505D-01, .710976D-01,
     +  .526542D-01, .386568D-01, .281266D-01, .202652D-01,
     +  .144503D-01, .102083D-01, .711337D-02, .489407D-02,
     +  .332420D-02, .222682D-02, .147166D-02, .958369D-03,
     +  .615871D-03, .390190D-03, .244424D-03, .151028D-03,
     +  .932775D-04, .570445D-04, .349850D-04, .214321D-04 /
        DATA (UPDI(I),I=5357,5408) /
     +  .132160D-04, .811407D-05, .498428D-05, .300309D-05,
     +  .177250D-05, .997783D-06, .534136D-06, .261808D-06,
     +  .115832D-06, .435319D-07, .119557D-07, .809320D-09,
     +  .000000D+00, .244141D+06, .187481D+06, .141914D+06,
     +  .107438D+06, .813614D+05, .616235D+05, .466893D+05,
     +  .353813D+05, .268220D+05, .203382D+05, .154283D+05,
     +  .117071D+05, .888765D+04, .674954D+04, .512859D+04,
     +  .389850D+04, .296528D+04, .225651D+04, .171835D+04,
     +  .130926D+04, .998363D+03, .761783D+03, .581783D+03,
     +  .444646D+03, .340169D+03, .260477D+03, .199713D+03,
     +  .152693D+03, .117342D+03, .902738D+02, .695519D+02,
     +  .536531D+02, .414520D+02, .320937D+02, .248754D+02,
     +  .193103D+02, .150180D+02, .116970D+02, .912613D+01 /
        DATA (UPDI(I),I=5409,5460) /
     +  .712854D+01, .557725D+01, .436652D+01, .342078D+01,
     +  .267996D+01, .209923D+01, .164274D+01, .128525D+01,
     +  .100193D+01, .780609D+00, .605377D+00, .468358D+00,
     +  .360892D+00, .276890D+00, .211385D+00, .160522D+00,
     +  .121162D+00, .908699D-01, .676739D-01, .500361D-01,
     +  .366984D-01, .266972D-01, .192495D-01, .137509D-01,
     +  .974397D-02, .682127D-02, .472334D-02, .323641D-02,
     +  .219321D-02, .147159D-02, .977257D-03, .644033D-03,
     +  .421397D-03, .274915D-03, .178853D-03, .117577D-03,
     +  .776192D-04, .520628D-04, .353617D-04, .244472D-04,
     +  .170239D-04, .119664D-04, .834338D-05, .574353D-05,
     +  .382903D-05, .244288D-05, .144464D-05, .764723D-06,
     +  .336340D-06, .997899D-07, .762422D-08, .000000D+00 /
        DATA (UPDI(I),I=5461,5512) /
     +  .250099D+06, .264247D+06, .199078D+06, .149977D+06,
     +  .113000D+06, .851366D+05, .641531D+05, .483410D+05,
     +  .364328D+05, .274589D+05, .206999D+05, .156058D+05,
     +  .117686D+05, .887598D+04, .669661D+04, .505327D+04,
     +  .381478D+04, .288056D+04, .217621D+04, .164464D+04,
     +  .124369D+04, .940907D+03, .712352D+03, .539624D+03,
     +  .409121D+03, .310414D+03, .235807D+03, .178584D+03,
     +  .135950D+03, .103601D+03, .790644D+02, .604141D+02,
     +  .462353D+02, .354628D+02, .272321D+02, .209466D+02,
     +  .161442D+02, .124635D+02, .964054D+01, .746726D+01,
     +  .579485D+01, .450117D+01, .349947D+01, .272153D+01,
     +  .211680D+01, .164528D+01, .127896D+01, .990834D+00,
     +  .767441D+00, .591826D+00, .455451D+00, .349195D+00 /
        DATA (UPDI(I),I=5513,5564) /
     +  .266664D+00, .202693D+00, .153304D+00, .115291D+00,
     +  .861827D-01, .639995D-01, .472060D-01, .345572D-01,
     +  .251069D-01, .180914D-01, .129249D-01, .916746D-02,
     +  .643039D-02, .446677D-02, .307473D-02, .209682D-02,
     +  .141869D-02, .952308D-03, .636144D-03, .423272D-03,
     +  .281755D-03, .187775D-03, .126777D-03, .862226D-04,
     +  .596301D-04, .417691D-04, .297091D-04, .212410D-04,
     +  .152602D-04, .108415D-04, .756595D-05, .509657D-05,
     +  .326718D-05, .193251D-05, .101606D-05, .439249D-06,
     +  .126527D-06, .982624D-08, .000000D+00, .485713D+06,
     +  .370101D+06, .277582D+06, .208157D+06, .156088D+06,
     +  .117021D+06, .877292D+05, .657584D+05, .492893D+05,
     +  .369396D+05, .276847D+05, .207463D+05, .155478D+05 /
        DATA (UPDI(I),I=5565,5616) /
     +  .116511D+05, .873201D+04, .654420D+04, .490544D+04,
     +  .367724D+04, .275729D+04, .206777D+04, .155128D+04,
     +  .116409D+04, .873976D+03, .656416D+03, .493324D+03,
     +  .370968D+03, .279252D+03, .209511D+03, .158000D+03,
     +  .119267D+03, .901498D+02, .682236D+02, .517078D+02,
     +  .392793D+02, .298726D+02, .227587D+02, .173752D+02,
     +  .132891D+02, .101851D+02, .781843D+01, .601433D+01,
     +  .463197D+01, .357139D+01, .275529D+01, .212651D+01,
     +  .164054D+01, .126617D+01, .974169D+00, .749587D+00,
     +  .574419D+00, .439406D+00, .334981D+00, .254431D+00,
     +  .192416D+00, .144838D+00, .108442D+00, .807299D-01,
     +  .597260D-01, .439044D-01, .320442D-01, .232202D-01,
     +  .166955D-01, .119058D-01, .843240D-02, .590774D-02 /
        DATA (UPDI(I),I=5617,5668) /
     +  .409981D-02, .281943D-02, .192048D-02, .129687D-02,
     +  .867719D-03, .576348D-03, .379902D-03, .249129D-03,
     +  .162386D-03, .106229D-03, .692338D-04, .453425D-04,
     +  .297602D-04, .196686D-04, .130075D-04, .863933D-05,
     +  .569371D-05, .371304D-05, .235502D-05, .143664D-05,
     +  .815972D-06, .416879D-06, .176808D-06, .505061D-07,
     +  .389007D-08, .000000D+00, .657967D+06, .499639D+06,
     +  .373220D+06, .278709D+06, .208094D+06, .155321D+06,
     +  .115911D+06, .864746D+05, .645032D+05, .481004D+05,
     +  .358636D+05, .267329D+05, .199246D+05, .148468D+05,
     +  .110623D+05, .824097D+04, .613914D+04, .457278D+04,
     +  .340630D+04, .253726D+04, .189028D+04, .140836D+04,
     +  .104961D+04, .782397D+03, .583466D+03, .435282D+03 /
        DATA (UPDI(I),I=5669,5720) /
     +  .325019D+03, .241811D+03, .180826D+03, .135334D+03,
     +  .101409D+03, .760740D+02, .571483D+02, .430285D+02,
     +  .324328D+02, .244901D+02, .185317D+02, .140496D+02,
     +  .106746D+02, .812439D+01, .619735D+01, .473385D+01,
     +  .362071D+01, .277160D+01, .212290D+01, .162573D+01,
     +  .124585D+01, .951932D+00, .727638D+00, .554035D+00,
     +  .421214D+00, .319226D+00, .241100D+00, .181357D+00,
     +  .135815D+00, .101194D+00, .749900D-01, .552430D-01,
     +  .404476D-01, .294144D-01, .212448D-01, .152316D-01,
     +  .108349D-01, .765864D-02, .535749D-02, .371464D-02,
     +  .255398D-02, .174075D-02, .117729D-02, .789859D-03,
     +  .526747D-03, .349207D-03, .230734D-03, .151971D-03,
     +  .100704D-03, .667344D-04, .445766D-04, .299632D-04 /
        DATA (UPDI(I),I=5721,5772) /
     +  .203296D-04, .138426D-04, .946194D-05, .641642D-05,
     +  .428553D-05, .277337D-05, .171182D-05, .976038D-06,
     +  .494108D-06, .203889D-06, .554667D-07, .438137D-08,
     +  .000000D+00, .868008D+06, .656996D+06, .488871D+06,
     +  .363633D+06, .270401D+06, .200987D+06, .149349D+06,
     +  .110932D+06, .823732D+05, .611414D+05, .453698D+05,
     +  .336531D+05, .249560D+05, .184995D+05, .137104D+05,
     +  .101577D+05, .752428D+04, .557196D+04, .412579D+04,
     +  .305430D+04, .226108D+04, .167368D+04, .123901D+04,
     +  .917247D+03, .679214D+03, .503049D+03, .372844D+03,
     +  .275267D+03, .204257D+03, .151670D+03, .112741D+03,
     +  .838897D+02, .625019D+02, .466709D+02, .348848D+02,
     +  .261217D+02, .196010D+02, .147367D+02, .111041D+02 /
        DATA (UPDI(I),I=5773,5824) /
     +  .838220D+01, .634245D+01, .480629D+01, .364748D+01,
     +  .277086D+01, .210656D+01, .160153D+01, .121869D+01,
     +  .924791D+00, .702217D+00, .531239D+00, .401376D+00,
     +  .302372D+00, .227052D+00, .169843D+00, .126514D+00,
     +  .937833D-01, .691591D-01, .507122D-01, .369676D-01,
     +  .267737D-01, .192639D-01, .137634D-01, .975948D-02,
     +  .687920D-02, .480067D-02, .332229D-02, .228120D-02,
     +  .155389D-02, .105110D-02, .706077D-03, .472014D-03,
     +  .314172D-03, .208773D-03, .138643D-03, .928298D-04,
     +  .623436D-04, .422966D-04, .289468D-04, .200114D-04,
     +  .138911D-04, .966042D-05, .665224D-05, .449158D-05,
     +  .292788D-05, .180991D-05, .102833D-05, .514799D-06,
     +  .208038D-06, .549318D-07, .440706D-08, .000000D+00 /
        DATA (UPDI(I),I=5825,5876) /
     +  .112227D+07, .846758D+06, .627704D+06, .465107D+06,
     +  .344498D+06, .255033D+06, .188730D+06, .139591D+06,
     +  .103206D+06, .762654D+05, .563355D+05, .415923D+05,
     +  .306960D+05, .226430D+05, .166968D+05, .123063D+05,
     +  .906744D+04, .667812D+04, .491716D+04, .361922D+04,
     +  .266346D+04, .195956D+04, .144160D+04, .106040D+04,
     +  .780065D+03, .573845D+03, .422381D+03, .309609D+03,
     +  .228083D+03, .168117D+03, .124030D+03, .915874D+02,
     +  .677093D+02, .501652D+02, .372006D+02, .276348D+02,
     +  .205711D+02, .153431D+02, .114693D+02, .858971D+01,
     +  .644876D+01, .484923D+01, .365214D+01, .275375D+01,
     +  .207826D+01, .156872D+01, .118542D+01, .893408D+00,
     +  .673903D+00, .506528D+00, .380311D+00, .284768D+00 /
        DATA (UPDI(I),I=5877,5928) /
     +  .212577D+00, .158112D+00, .117128D+00, .863652D-01,
     +  .633637D-01, .462358D-01, .335467D-01, .241885D-01,
     +  .173308D-01, .123339D-01, .871396D-02, .612182D-02,
     +  .425938D-02, .294027D-02, .201486D-02, .137065D-02,
     +  .926623D-03, .622745D-03, .416979D-03, .278409D-03,
     +  .185907D-03, .124340D-03, .840024D-04, .570567D-04,
     +  .392048D-04, .272052D-04, .190608D-04, .133976D-04,
     +  .940740D-05, .652321D-05, .441620D-05, .287630D-05,
     +  .176799D-05, .994508D-06, .489825D-06, .193181D-06,
     +  .494943D-07, .402794D-08, .000000D+00, .142757D+07,
     +  .107375D+07, .793012D+06, .585371D+06, .431901D+06,
     +  .318477D+06, .234730D+06, .172900D+06, .127295D+06,
     +  .936616D+05, .688812D+05, .506259D+05, .371907D+05 /
        DATA (UPDI(I),I=5929,5980) /
     +  .273044D+05, .200368D+05, .146949D+05, .107724D+05,
     +  .789255D+04, .578034D+04, .423127D+04, .309640D+04,
     +  .226496D+04, .165643D+04, .121104D+04, .885346D+03,
     +  .647135D+03, .473218D+03, .344525D+03, .252073D+03,
     +  .184507D+03, .135155D+03, .990816D+02, .727114D+02,
     +  .534716D+02, .393538D+02, .290126D+02, .214319D+02,
     +  .158629D+02, .117671D+02, .874570D+01, .651618D+01,
     +  .486321D+01, .363553D+01, .272122D+01, .203896D+01,
     +  .152820D+01, .114684D+01, .858477D+00, .643287D+00,
     +  .480392D+00, .358421D+00, .266738D+00, .197933D+00,
     +  .146369D+00, .107820D+00, .790694D-01, .577054D-01,
     +  .418934D-01, .302473D-01, .217076D-01, .154839D-01,
     +  .109732D-01, .772174D-02, .540480D-02, .374788D-02 /
        DATA (UPDI(I),I=5981,6032) /
     +  .257968D-02, .176354D-02, .119762D-02, .808883D-03,
     +  .543671D-03, .364500D-03, .244053D-03, .163706D-03,
     +  .110216D-03, .750744D-04, .515050D-04, .357724D-04,
     +  .250973D-04, .177561D-04, .125818D-04, .887799D-05,
     +  .616872D-05, .416827D-05, .270080D-05, .164466D-05,
     +  .912913D-06, .441221D-06, .169521D-06, .421300D-07,
     +  .347690D-08, .000000D+00, .179099D+07, .134292D+07,
     +  .988151D+06, .726679D+06, .534112D+06, .392313D+06,
     +  .288001D+06, .211280D+06, .154910D+06, .113500D+06,
     +  .831115D+05, .608165D+05, .444764D+05, .325036D+05,
     +  .237401D+05, .173274D+05, .126399D+05, .921429D+04,
     +  .671364D+04, .488858D+04, .355811D+04, .258831D+04,
     +  .188220D+04, .136812D+04, .994236D+03, .722291D+03 /
        DATA (UPDI(I),I=6033,6084) /
     +  .524883D+03, .379670D+03, .275978D+03, .200663D+03,
     +  .145992D+03, .106288D+03, .774514D+02, .565528D+02,
     +  .413209D+02, .302408D+02, .221749D+02, .162918D+02,
     +  .119960D+02, .884995D+01, .654534D+01, .484927D+01,
     +  .359884D+01, .267448D+01, .198978D+01, .148095D+01,
     +  .110381D+01, .820705D+00, .610947D+00, .453298D+00,
     +  .336079D+00, .248576D+00, .183350D+00, .134793D+00,
     +  .987264D-01, .719996D-01, .522631D-01, .377448D-01,
     +  .271145D-01, .193650D-01, .137488D-01, .970060D-02,
     +  .679766D-02, .473946D-02, .327477D-02, .224702D-02,
     +  .153217D-02, .103853D-02, .700683D-03, .470957D-03,
     +  .316144D-03, .212268D-03, .143029D-03, .969108D-04,
     +  .665227D-04, .460502D-04, .322782D-04, .228436D-04 /
        DATA (UPDI(I),I=6085,6136) /
     +  .162743D-04, .115878D-04, .819007D-05, .568387D-05,
     +  .382227D-05, .245732D-05, .147922D-05, .808688D-06,
     +  .382972D-06, .143233D-06, .345426D-07, .289032D-08,
     +  .000000D+00, .221975D+07, .165930D+07, .121646D+07,
     +  .891241D+06, .652580D+06, .477481D+06, .349147D+06,
     +  .255114D+06, .186286D+06, .135923D+06, .991104D+05,
     +  .722112D+05, .525772D+05, .382514D+05, .278103D+05,
     +  .202032D+05, .146673D+05, .106401D+05, .771378D+04,
     +  .558819D+04, .404608D+04, .292756D+04, .211726D+04,
     +  .153037D+04, .110579D+04, .798612D+03, .576865D+03,
     +  .414680D+03, .299540D+03, .216406D+03, .156420D+03,
     +  .113125D+03, .818769D+02, .593755D+02, .430816D+02,
     +  .313079D+02, .227945D+02, .166275D+02, .121553D+02 /
        DATA (UPDI(I),I=6137,6188) /
     +  .890320D+01, .653753D+01, .480892D+01, .354357D+01,
     +  .261490D+01, .193193D+01, .142801D+01, .105718D+01,
     +  .780787D+00, .577439D+00, .425681D+00, .313620D+00,
     +  .230539D+00, .169022D+00, .123529D+00, .899558D-01,
     +  .652356D-01, .470949D-01, .338321D-01, .241788D-01,
     +  .171829D-01, .121414D-01, .852769D-02, .594998D-02,
     +  .413179D-02, .284442D-02, .194550D-02, .132308D-02,
     +  .895106D-03, .603305D-03, .405555D-03, .272623D-03,
     +  .183588D-03, .124276D-03, .847331D-04, .585898D-04,
     +  .408874D-04, .288820D-04, .205780D-04, .147288D-04,
     +  .105117D-04, .742355D-05, .513373D-05, .342892D-05,
     +  .218337D-05, .129737D-05, .697709D-06, .323471D-06,
     +  .117732D-06, .275723D-07, .233872D-08, .000000D+00 /
        DATA (UPDI(I),I=6189,6240) /
     +  .272101D+07, .202778D+07, .148116D+07, .108116D+07,
     +  .788657D+06, .574840D+06, .418703D+06, .304728D+06,
     +  .221620D+06, .161043D+06, .116937D+06, .848384D+05,
     +  .615042D+05, .445491D+05, .322436D+05, .233167D+05,
     +  .168486D+05, .121642D+05, .877586D+04, .632603D+04,
     +  .455706D+04, .328019D+04, .235972D+04, .169638D+04,
     +  .121895D+04, .875340D+03, .628626D+03, .449179D+03,
     +  .322503D+03, .231562D+03, .166323D+03, .119518D+03,
     +  .859409D+02, .619116D+02, .446200D+02, .322056D+02,
     +  .232869D+02, .168692D+02, .122461D+02, .890705D+01,
     +  .649465D+01, .474404D+01, .347147D+01, .254402D+01,
     +  .186669D+01, .137044D+01, .100780D+01, .739390D+00,
     +  .543281D+00, .397937D+00, .291342D+00, .212848D+00 /
        DATA (UPDI(I),I=6241,6292) /
     +  .155112D+00, .112694D+00, .815911D-01, .588357D-01,
     +  .422410D-01, .301828D-01, .214586D-01, .151733D-01,
     +  .106697D-01, .745960D-02, .518202D-02, .358392D-02,
     +  .245815D-02, .167596D-02, .113685D-02, .767741D-03,
     +  .517023D-03, .347674D-03, .234101D-03, .158151D-03,
     +  .107567D-03, .737922D-04, .513756D-04, .361102D-04,
     +  .256707D-04, .183809D-04, .131919D-04, .941729D-05,
     +  .663272D-05, .456265D-05, .302239D-05, .190370D-05,
     +  .111549D-05, .589623D-06, .267466D-06, .947338D-07,
     +  .215647D-07, .185392D-08, .000000D+00, .330170D+07,
     +  .245307D+07, .178529D+07, .129835D+07, .943551D+06,
     +  .685132D+06, .497114D+06, .360380D+06, .261051D+06,
     +  .188930D+06, .136623D+06, .987065D+05, .712536D+05 /
        DATA (UPDI(I),I=6293,6344) /
     +  .513876D+05, .370292D+05, .266572D+05, .191743D+05,
     +  .137788D+05, .989345D+04, .709708D+04, .508720D+04,
     +  .364330D+04, .260743D+04, .186459D+04, .133261D+04,
     +  .951686D+03, .679618D+03, .482796D+03, .344614D+03,
     +  .245966D+03, .175596D+03, .125402D+03, .896033D+02,
     +  .641381D+02, .459241D+02, .329286D+02, .236510D+02,
     +  .170178D+02, .122703D+02, .886391D+01, .641908D+01,
     +  .465683D+01, .338443D+01, .246342D+01, .179538D+01,
     +  .130926D+01, .956467D+00, .697134D+00, .508941D+00,
     +  .370413D+00, .269500D+00, .195685D+00, .141746D+00,
     +  .102376D+00, .736919D-01, .528390D-01, .377262D-01,
     +  .268120D-01, .189626D-01, .133407D-01, .933559D-02,
     +  .649681D-02, .449347D-02, .309520D-02, .211522D-02 /
        DATA (UPDI(I),I=6345,6396) /
     +  .143769D-02, .972856D-03, .655948D-03, .441473D-03,
     +  .297058D-03, .200413D-03, .135859D-03, .928560D-04,
     +  .640804D-04, .448974D-04, .317529D-04, .226874D-04,
     +  .162992D-04, .117096D-04, .834710D-05, .585420D-05,
     +  .400041D-05, .262522D-05, .163411D-05, .943544D-06,
     +  .489903D-06, .217363D-06, .749318D-07, .165954D-07,
     +  .144579D-08, .000000D+00, .256211D+07, .196415D+07,
     +  .148372D+07, .112080D+07, .846662D+06, .639578D+06,
     +  .483149D+06, .364984D+06, .275722D+06, .208294D+06,
     +  .157359D+06, .118882D+06, .898164D+05, .678595D+05,
     +  .512727D+05, .387425D+05, .292764D+05, .221252D+05,
     +  .167226D+05, .126408D+05, .955692D+04, .722682D+04,
     +  .546615D+04, .413568D+04, .313020D+04, .237024D+04 /
        DATA (UPDI(I),I=6397,6448) /
     +  .179578D+04, .135614D+04, .102915D+04, .781794D+03,
     +  .594621D+03, .452939D+03, .345642D+03, .264554D+03,
     +  .202897D+03, .156122D+03, .120594D+03, .935672D+02,
     +  .729673D+02, .572210D+02, .451659D+02, .358872D+02,
     +  .287176D+02, .231492D+02, .187993D+02, .153795D+02,
     +  .126809D+02, .105142D+02, .878218D+01, .736912D+01,
     +  .621844D+01, .526994D+01, .448197D+01, .382241D+01,
     +  .326650D+01, .279498D+01, .239282D+01, .204822D+01,
     +  .175179D+01, .149604D+01, .127492D+01, .108348D+01,
     +  .917653D+00, .774678D+00, .650244D+00, .542864D+00,
     +  .450452D+00, .371203D+00, .303539D+00, .246068D+00,
     +  .197555D+00, .156896D+00, .123080D+00, .951973D-01,
     +  .726580D-01, .543944D-01, .399177D-01, .286272D-01 /
        DATA (UPDI(I),I=6449,6500) /
     +  .199871D-01, .135211D-01, .880876D-02, .548727D-02,
     +  .322234D-02, .176498D-02, .879967D-03, .385861D-03,
     +  .140482D-03, .381180D-04, .604828D-05, .258374D-06,
     +  .000000D+00, .363347D+07, .278431D+07, .210194D+07,
     +  .158636D+07, .119739D+07, .903534D+06, .681871D+06,
     +  .514434D+06, .388151D+06, .292776D+06, .220856D+06,
     +  .166549D+06, .125605D+06, .946945D+05, .713958D+05,
     +  .538109D+05, .405598D+05, .305611D+05, .230289D+05,
     +  .173472D+05, .130684D+05, .984189D+04, .741299D+04,
     +  .558210D+04, .420430D+04, .316592D+04, .238489D+04,
     +  .178957D+04, .134912D+04, .101743D+04, .768008D+03,
     +  .580203D+03, .438970D+03, .332881D+03, .252848D+03,
     +  .192557D+03, .147158D+03, .112891D+03, .870167D+02 /
        DATA (UPDI(I),I=6501,6552) /
     +  .674070D+02, .525424D+02, .412052D+02, .325359D+02,
     +  .258672D+02, .207140D+02, .167028D+02, .135731D+02,
     +  .110871D+02, .912306D+01, .753936D+01, .626580D+01,
     +  .522921D+01, .437957D+01, .367809D+01, .309530D+01,
     +  .260826D+01, .219918D+01, .185409D+01, .156194D+01,
     +  .131397D+01, .110306D+01, .923563D+00, .770584D+00,
     +  .640916D+00, .529946D+00, .435835D+00, .356205D+00,
     +  .289104D+00, .232787D+00, .185795D+00, .146811D+00,
     +  .114728D+00, .885328D-01, .673248D-01, .504979D-01,
     +  .371293D-01, .267386D-01, .188040D-01, .128590D-01,
     +  .851202D-02, .541617D-02, .329088D-02, .187986D-02,
     +  .999302D-03, .481583D-03, .203322D-03, .707821D-04,
     +  .182549D-04, .276718D-05, .121184D-06, .000000D+00 /
        DATA (UPDI(I),I=6553,6604) /
     +  .510154D+07, .390271D+07, .294027D+07, .221421D+07,
     +  .166754D+07, .125528D+07, .944974D+06, .711042D+06,
     +  .535026D+06, .402383D+06, .302620D+06, .227472D+06,
     +  .170979D+06, .128445D+06, .964854D+05, .724362D+05,
     +  .543768D+05, .407953D+05, .306031D+05, .229431D+05,
     +  .171987D+05, .128846D+05, .965194D+04, .722616D+04,
     +  .540990D+04, .404777D+04, .302906D+04, .225692D+04,
     +  .168912D+04, .126413D+04, .946663D+03, .709228D+03,
     +  .531957D+03, .399762D+03, .300816D+03, .226862D+03,
     +  .171638D+03, .130305D+03, .993710D+02, .761320D+02,
     +  .586773D+02, .454858D+02, .354935D+02, .278793D+02,
     +  .220523D+02, .175599D+02, .140899D+02, .113608D+02,
     +  .922723D+01, .752503D+01, .617112D+01, .508156D+01 /
        DATA (UPDI(I),I=6605,6656) /
     +  .419888D+01, .347893D+01, .288821D+01, .240090D+01,
     +  .199696D+01, .166084D+01, .138020D+01, .114538D+01,
     +  .948513D+00, .783423D+00, .644749D+00, .528964D+00,
     +  .431354D+00, .349842D+00, .281924D+00, .225585D+00,
     +  .179037D+00, .140817D+00, .109616D+00, .843639D-01,
     +  .640931D-01, .479588D-01, .353802D-01, .255680D-01,
     +  .180828D-01, .124788D-01, .836454D-02, .542105D-02,
     +  .337133D-02, .199899D-02, .111139D-02, .573556D-03,
     +  .267267D-03, .108637D-03, .361599D-04, .886065D-05,
     +  .128130D-05, .569024D-07, .000000D+00, .703699D+07,
     +  .537043D+07, .403455D+07, .302935D+07, .227446D+07,
     +  .170674D+07, .128061D+07, .960310D+06, .720035D+06,
     +  .539543D+06, .404232D+06, .302656D+06, .226560D+06 /
        DATA (UPDI(I),I=6657,6708) /
     +  .169478D+06, .126749D+06, .947233D+05, .707709D+05,
     +  .528344D+05, .394326D+05, .294065D+05, .219230D+05,
     +  .163305D+05, .121612D+05, .904908D+04, .673160D+04,
     +  .500337D+04, .371860D+04, .275082D+04, .204366D+04,
     +  .151785D+04, .112772D+04, .838011D+03, .623265D+03,
     +  .464329D+03, .346279D+03, .258748D+03, .193913D+03,
     +  .145791D+03, .110078D+03, .834806D+02, .636757D+02,
     +  .488402D+02, .377015D+02, .292902D+02, .229110D+02,
     +  .180377D+02, .143083D+02, .114026D+02, .915272D+01,
     +  .737547D+01, .597601D+01, .486152D+01, .396821D+01,
     +  .324763D+01, .266304D+01, .218642D+01, .179605D+01,
     +  .147521D+01, .121066D+01, .992147D+00, .811322D+00,
     +  .661699D+00, .537674D+00, .435528D+00, .350596D+00 /
        DATA (UPDI(I),I=6709,6760) /
     +  .280661D+00, .223210D+00, .176236D+00, .137987D+00,
     +  .107044D+00, .821600D-01, .623299D-01, .466610D-01,
     +  .343865D-01, .249736D-01, .177553D-01, .123450D-01,
     +  .836852D-02, .550471D-02, .349711D-02, .212864D-02,
     +  .123349D-02, .668675D-03, .335672D-03, .151633D-03,
     +  .595198D-04, .190255D-04, .445681D-05, .618377D-06,
     +  .272334D-07, .000000D+00, .951813D+07, .724366D+07,
     +  .542387D+07, .405876D+07, .303668D+07, .227053D+07,
     +  .169731D+07, .126794D+07, .946948D+06, .706708D+06,
     +  .527258D+06, .393074D+06, .292938D+06, .218134D+06,
     +  .162368D+06, .120755D+06, .897680D+05, .666720D+05,
     +  .494953D+05, .367088D+05, .272121D+05, .201525D+05,
     +  .149171D+05, .110311D+05, .815347D+04, .602015D+04 /
        DATA (UPDI(I),I=6761,6812) /
     +  .444389D+04, .326402D+04, .240740D+04, .177473D+04,
     +  .130847D+04, .964684D+03, .711656D+03, .525787D+03,
     +  .388762D+03, .287955D+03, .213870D+03, .159328D+03,
     +  .119177D+03, .895226D+02, .676238D+02, .513590D+02,
     +  .392494D+02, .301837D+02, .233667D+02, .182044D+02,
     +  .142881D+02, .112641D+02, .894373D+01, .712785D+01,
     +  .571141D+01, .459442D+01, .370796D+01, .300026D+01,
     +  .243213D+01, .197396D+01, .160282D+01, .130126D+01,
     +  .105548D+01, .854875D+00, .690864D+00, .556814D+00,
     +  .447061D+00, .357809D+00, .284544D+00, .225000D+00,
     +  .176727D+00, .137785D+00, .106506D+00, .815502D-01,
     +  .617635D-01, .462222D-01, .341227D-01, .247856D-01,
     +  .177359D-01, .124159D-01, .849449D-02, .566195D-02 /
        DATA (UPDI(I),I=6813,6864) /
     +  .365874D-02, .228102D-02, .136072D-02, .771689D-03,
     +  .408594D-03, .199910D-03, .877615D-04, .333676D-04,
     +  .102871D-04, .231666D-05, .309840D-06, .131450D-07,
     +  .000000D+00, .128447D+08, .974277D+07, .726648D+07,
     +  .541588D+07, .403529D+07, .300450D+07, .223621D+07,
     +  .166312D+07, .123640D+07, .918421D+06, .681911D+06,
     +  .505872D+06, .375088D+06, .277861D+06, .205721D+06,
     +  .152162D+06, .112479D+06, .830593D+05, .612945D+05,
     +  .451839D+05, .332849D+05, .244920D+05, .180094D+05,
     +  .132276D+05, .970874D+04, .711706D+04, .521490D+04,
     +  .380100D+04, .278165D+04, .203431D+04, .148756D+04,
     +  .108754D+04, .795373D+03, .582485D+03, .426793D+03,
     +  .313217D+03, .230441D+03, .170029D+03, .125938D+03 /
        DATA (UPDI(I),I=6865,6916) /
     +  .936619D+02, .700355D+02, .526457D+02, .398132D+02,
     +  .302941D+02, .232008D+02, .178787D+02, .138784D+02,
     +  .108187D+02, .849335D+01, .669146D+01, .529988D+01,
     +  .421377D+01, .336080D+01, .268720D+01, .215237D+01,
     +  .172596D+01, .138453D+01, .111040D+01, .889676D+00,
     +  .711748D+00, .568102D+00, .452194D+00, .358517D+00,
     +  .283338D+00, .222449D+00, .173635D+00, .134606D+00,
     +  .103561D+00, .789792D-01, .596492D-01, .445492D-01,
     +  .328670D-01, .239118D-01, .171089D-01, .120552D-01,
     +  .830489D-02, .558807D-02, .366062D-02, .232289D-02,
     +  .142074D-02, .830496D-03, .460939D-03, .238451D-03,
     +  .113778D-03, .486042D-04, .179359D-04, .535257D-05,
     +  .116456D-05, .150692D-06, .589119D-08, .000000D+00 /
        DATA (UPDI(I),I=6917,6968) /
     +  .171094D+08, .129312D+08, .960385D+07, .712729D+07,
     +  .528702D+07, .391884D+07, .290330D+07, .214913D+07,
     +  .159001D+07, .117530D+07, .868245D+06, .640799D+06,
     +  .472626D+06, .348236D+06, .256402D+06, .188582D+06,
     +  .138594D+06, .101740D+06, .746249D+05, .546704D+05,
     +  .400170D+05, .292545D+05, .213677D+05, .155873D+05,
     +  .113604D+05, .826794D+04, .601362D+04, .434970D+04,
     +  .315859D+04, .229176D+04, .166224D+04, .120521D+04,
     +  .873942D+03, .634507D+03, .460794D+03, .335125D+03,
     +  .244291D+03, .178565D+03, .131002D+03, .964883D+02,
     +  .714417D+02, .531697D+02, .398040D+02, .299783D+02,
     +  .227214D+02, .173259D+02, .133072D+02, .102617D+02,
     +  .796898D+01, .620935D+01, .486358D+01, .382372D+01 /
        DATA (UPDI(I),I=6969,7020) /
     +  .301533D+01, .238362D+01, .188737D+01, .149604D+01,
     +  .118618D+01, .940238D+00, .744499D+00, .588579D+00,
     +  .464213D+00, .365086D+00, .285959D+00, .223256D+00,
     +  .173120D+00, .133449D+00, .102150D+00, .775866D-01,
     +  .584025D-01, .435263D-01, .320702D-01, .233350D-01,
     +  .167380D-01, .118021D-01, .819237D-02, .555650D-02,
     +  .367883D-02, .236967D-02, .147743D-02, .887014D-03,
     +  .508415D-03, .276351D-03, .139790D-03, .651103D-04,
     +  .270958D-04, .971748D-05, .281194D-05, .592037D-06,
     +  .740283D-07, .248633D-08, .000000D+00, .224514D+08,
     +  .169064D+08, .125015D+08, .923672D+07, .682077D+07,
     +  .503243D+07, .371073D+07, .273367D+07, .201255D+07,
     +  .148021D+07, .108790D+07, .798739D+06, .585976D+06 /
        DATA (UPDI(I),I=7021,7072) /
     +  .429411D+06, .314412D+06, .229938D+06, .168007D+06,
     +  .122603D+06, .893817D+05, .650764D+05, .473318D+05,
     +  .343783D+05, .249435D+05, .180725D+05, .130801D+05,
     +  .945180D+04, .682471D+04, .489917D+04, .353051D+04,
     +  .254172D+04, .182885D+04, .131525D+04, .945803D+03,
     +  .680882D+03, .490191D+03, .353368D+03, .255277D+03,
     +  .184896D+03, .134389D+03, .980534D+02, .719087D+02,
     +  .530011D+02, .392896D+02, .292982D+02, .219836D+02,
     +  .165933D+02, .126145D+02, .962645D+01, .739767D+01,
     +  .570316D+01, .441951D+01, .343729D+01, .268126D+01,
     +  .209644D+01, .164177D+01, .128700D+01, .100910D+01,
     +  .790945D+00, .619253D+00, .484037D+00, .377425D+00,
     +  .293440D+00, .227191D+00, .175322D+00, .134355D+00 /
        DATA (UPDI(I),I=7073,7124) /
     +  .102339D+00, .773973D-01, .580725D-01, .431754D-01,
     +  .317754D-01, .231143D-01, .166004D-01, .117497D-01,
     +  .817186D-02, .559366D-02, .373931D-02, .243894D-02,
     +  .154682D-02, .948969D-03, .560212D-03, .315473D-03,
     +  .168318D-03, .834820D-04, .380799D-04, .155000D-04,
     +  .542932D-05, .153303D-05, .314637D-06, .381867D-07,
     +  .995807D-09, .000000D+00, .290108D+08, .217649D+08,
     +  .160233D+08, .117858D+08, .866337D+07, .636228D+07,
     +  .466907D+07, .342311D+07, .250771D+07, .183518D+07,
     +  .134189D+07, .980096D+06, .715199D+06, .521274D+06,
     +  .379560D+06, .276021D+06, .200515D+06, .145467D+06,
     +  .105414D+06, .762792D+05, .551322D+05, .397881D+05,
     +  .286799D+05, .206409D+05, .148368D+05, .106462D+05 /
        DATA (UPDI(I),I=7125,7176) /
     +  .763220D+04, .543829D+04, .388976D+04, .277904D+04,
     +  .198402D+04, .141551D+04, .100962D+04, .720829D+03,
     +  .514564D+03, .367752D+03, .263343D+03, .189044D+03,
     +  .136164D+03, .984404D+02, .715233D+02, .522228D+02,
     +  .383447D+02, .283192D+02, .210427D+02, .157272D+02,
     +  .118380D+02, .894316D+01, .680341D+01, .519149D+01,
     +  .398174D+01, .306485D+01, .236588D+01, .183052D+01,
     +  .141845D+01, .110019D+01, .853472D+00, .661825D+00,
     +  .512611D+00, .396371D+00, .305727D+00, .235115D+00,
     +  .180041D+00, .137413D+00, .104134D+00, .784312D-01,
     +  .586462D-01, .435008D-01, .319682D-01, .232521D-01,
     +  .167135D-01, .118586D-01, .829050D-02, .569356D-02,
     +  .384759D-02, .253830D-02, .163329D-02, .102151D-02 /
        DATA (UPDI(I),I=7177,7228) /
     +  .617749D-03, .359293D-03, .199236D-03, .104614D-03,
     +  .510303D-04, .228779D-04, .914735D-05, .314544D-05,
     +  .871922D-06, .175607D-06, .207728D-07, .359052D-09,
     +  .000000D+00, .369201D+08, .275965D+08, .202269D+08,
     +  .148113D+08, .108376D+08, .792217D+07, .578636D+07,
     +  .422192D+07, .307776D+07, .224116D+07, .163043D+07,
     +  .118471D+07, .859954D+06, .623426D+06, .451458D+06,
     +  .326481D+06, .235823D+06, .170092D+06, .122529D+06,
     +  .881305D+05, .633054D+05, .453999D+05, .325147D+05,
     +  .232476D+05, .165984D+05, .118285D+05, .842048D+04,
     +  .595653D+04, .422932D+04, .299915D+04, .212485D+04,
     +  .150424D+04, .106439D+04, .753809D+03, .533671D+03,
     +  .378213D+03, .268524D+03, .191097D+03, .136433D+03 /
        DATA (UPDI(I),I=7229,7280) /
     +  .977570D+02, .703864D+02, .509243D+02, .370461D+02,
     +  .271053D+02, .199510D+02, .147696D+02, .110109D+02,
     +  .823769D+01, .620589D+01, .468898D+01, .356086D+01,
     +  .271372D+01, .207395D+01, .158860D+01, .121862D+01,
     +  .935670D+00, .718504D+00, .551515D+00, .422827D+00,
     +  .323613D+00, .247056D+00, .188046D+00, .142513D+00,
     +  .107649D+00, .807288D-01, .601660D-01, .445145D-01,
     +  .326681D-01, .237506D-01, .170884D-01, .121492D-01,
     +  .852491D-02, .589331D-02, .400123D-02, .267295D-02,
     +  .174269D-02, .110798D-02, .684530D-03, .408828D-03,
     +  .234764D-03, .128497D-03, .665778D-04, .320376D-04,
     +  .141653D-04, .558531D-05, .189369D-05, .517817D-06,
     +  .102836D-06, .118957D-07, .982113D-10, .000000D+00 /
        DATA (UPDI(I),I=7281,7332) /
     +  .462985D+08, .344800D+08, .251614D+08, .183428D+08,
     +  .133609D+08, .972188D+07, .706764D+07, .513233D+07,
     +  .372334D+07, .269795D+07, .195291D+07, .141181D+07,
     +  .101949D+07, .735184D+06, .529523D+06, .380840D+06,
     +  .273551D+06, .196183D+06, .140503D+06, .100461D+06,
     +  .717270D+05, .511230D+05, .363831D+05, .258466D+05,
     +  .183330D+05, .129769D+05, .917491D+04, .644427D+04,
     +  .454300D+04, .319818D+04, .224902D+04, .158009D+04,
     +  .110941D+04, .779524D+03, .547443D+03, .384808D+03,
     +  .270937D+03, .191190D+03, .135332D+03, .961287D+02,
     +  .686074D+02, .491975D+02, .354693D+02, .257171D+02,
     +  .187566D+02, .137576D+02, .101618D+02, .753128D+01,
     +  .562067D+01, .420667D+01, .316435D+01, .238865D+01 /
        DATA (UPDI(I),I=7333,7384) /
     +  .180813D+01, .137176D+01, .104222D+01, .792568D+00,
     +  .602781D+00, .458249D+00, .347952D+00, .263751D+00,
     +  .199421D+00, .150331D+00, .112833D+00, .844116D-01,
     +  .626901D-01, .462691D-01, .339003D-01, .246361D-01,
     +  .177359D-01, .126354D-01, .889455D-02, .617912D-02,
     +  .422891D-02, .284214D-02, .187942D-02, .121273D-02,
     +  .763049D-03, .466491D-03, .275665D-03, .156606D-03,
     +  .847958D-04, .434576D-04, .206836D-04, .904454D-05,
     +  .352724D-05, .118272D-05, .319944D-06, .628152D-07,
     +  .712225D-08, .000000D+00, .000000D+00, .572469D+08,
     +  .424799D+08, .308649D+08, .224019D+08, .162445D+08,
     +  .117665D+08, .851458D+07, .615412D+07, .444333D+07,
     +  .320409D+07, .230784D+07, .166006D+07, .119263D+07 /
        DATA (UPDI(I),I=7385,7436) /
     +  .855592D+06, .612991D+06, .438504D+06, .313244D+06,
     +  .223398D+06, .159084D+06, .113089D+06, .802651D+05,
     +  .568641D+05, .402200D+05, .283932D+05, .200101D+05,
     +  .140712D+05, .988219D+04, .689311D+04, .482560D+04,
     +  .337304D+04, .235480D+04, .164220D+04, .114432D+04,
     +  .797905D+03, .555967D+03, .387694D+03, .270762D+03,
     +  .189501D+03, .133021D+03, .936917D+02, .662988D+02,
     +  .471332D+02, .336858D+02, .242101D+02, .175017D+02,
     +  .127230D+02, .931403D+01, .684077D+01, .505948D+01,
     +  .375233D+01, .279704D+01, .209224D+01, .156940D+01,
     +  .117985D+01, .888285D+00, .669390D+00, .504498D+00,
     +  .380073D+00, .285996D+00, .214841D+00, .160987D+00,
     +  .120275D+00, .894685D-01, .663394D-01, .488304D-01 /
        DATA (UPDI(I),I=7437,7488) /
     +  .357199D-01, .259393D-01, .186838D-01, .133319D-01,
     +  .941401D-02, .656836D-02, .452272D-02, .306793D-02,
     +  .204354D-02, .133941D-02, .856584D-03, .534163D-03,
     +  .323644D-03, .189543D-03, .106713D-03, .572624D-04,
     +  .290816D-04, .137158D-04, .594261D-05, .229614D-05,
     +  .762543D-06, .204278D-06, .396740D-07, .441607D-08,
     +  .000000D+00, .000000D+00, .698428D+08, .516430D+08,
     +  .373621D+08, .270001D+08, .194925D+08, .140562D+08,
     +  .101252D+08, .728453D+07, .523483D+07, .375690D+07,
     +  .269291D+07, .192753D+07, .137786D+07, .983449D+06,
     +  .700944D+06, .498783D+06, .354391D+06, .251365D+06,
     +  .178003D+06, .125821D+06, .887854D+05, .625302D+05,
     +  .439617D+05, .308445D+05, .216016D+05, .150931D+05 /
        DATA (UPDI(I),I=7489,7540) /
     +  .105309D+05, .729607D+04, .507305D+04, .352150D+04,
     +  .244108D+04, .169014D+04, .116907D+04, .809088D+03,
     +  .559466D+03, .387118D+03, .268234D+03, .186235D+03,
     +  .129672D+03, .905865D+02, .635720D+02, .448178D+02,
     +  .317615D+02, .226339D+02, .162229D+02, .116923D+02,
     +  .848617D+01, .617882D+01, .453058D+01, .333096D+01,
     +  .246152D+01, .182539D+01, .135746D+01, .101176D+01,
     +  .755227D+00, .564276D+00, .421675D+00, .314999D+00,
     +  .235043D+00, .175093D+00, .130116D+00, .964101D-01,
     +  .711289D-01, .523132D-01, .381942D-01, .277142D-01,
     +  .199646D-01, .142658D-01, .100988D-01, .707485D-02,
     +  .489760D-02, .334596D-02, .225205D-02, .148843D-02,
     +  .968079D-03, .614330D-03, .380150D-03, .228557D-03 /
        DATA (UPDI(I),I=7541,7592) /
     +  .132826D-03, .742026D-04, .395085D-04, .199066D-04,
     +  .931303D-05, .400135D-05, .153264D-05, .504201D-06,
     +  .133718D-06, .256756D-07, .280853D-08, .000000D+00,
     +  .000000D+00, .841368D+08, .619958D+08, .446630D+08,
     +  .321384D+08, .231015D+08, .165854D+08, .118937D+08,
     +  .851818D+07, .609318D+07, .435250D+07, .310501D+07,
     +  .221178D+07, .157329D+07, .111735D+07, .792337D+06,
     +  .560912D+06, .396440D+06, .279688D+06, .196981D+06,
     +  .138464D+06, .971556D+05, .680316D+05, .475487D+05,
     +  .331617D+05, .230825D+05, .160271D+05, .111115D+05,
     +  .764775D+04, .528242D+04, .364213D+04, .250734D+04,
     +  .172386D+04, .118387D+04, .813390D+03, .558275D+03,
     +  .383389D+03, .263620D+03, .181615D+03, .125464D+03 /
        DATA (UPDI(I),I=7593,7644) /
     +  .869516D+02, .605328D+02, .423308D+02, .297551D+02,
     +  .210308D+02, .149502D+02, .106862D+02, .769225D+01,
     +  .555438D+01, .403925D+01, .294522D+01, .215862D+01,
     +  .158771D+01, .117111D+01, .865826D+00, .641110D+00,
     +  .475198D+00, .352303D+00, .261115D+00, .193324D+00,
     +  .142907D+00, .105389D+00, .774991D-01, .567492D-01,
     +  .414295D-01, .300258D-01, .216286D-01, .154685D-01,
     +  .109741D-01, .771374D-02, .536606D-02, .368886D-02,
     +  .250274D-02, .167295D-02, .109811D-02, .709386D-03,
     +  .447104D-03, .274790D-03, .164082D-03, .947001D-04,
     +  .525332D-04, .277712D-04, .138891D-04, .644733D-05,
     +  .274710D-05, .104280D-05, .339621D-06, .890796D-07,
     +  .168932D-07, .181738D-08, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=7645,7696) /
     +  .158812D+05, .258924D+05, .207927D+05, .167003D+05,
     +  .134161D+05, .107801D+05, .866418D+04, .696550D+04,
     +  .560159D+04, .450630D+04, .362658D+04, .291986D+04,
     +  .235199D+04, .189559D+04, .152867D+04, .123361D+04,
     +  .996260D+03, .805258D+03, .651494D+03, .527655D+03,
     +  .427869D+03, .347422D+03, .282529D+03, .230150D+03,
     +  .187843D+03, .153647D+03, .125985D+03, .103304D+03,
     +  .852157D+02, .705420D+02, .586255D+02, .489372D+02,
     +  .410508D+02, .346399D+02, .293924D+02, .251028D+02,
     +  .215887D+02, .187024D+02, .163238D+02, .143549D+02,
     +  .127191D+02, .113494D+02, .101947D+02, .921271D+01,
     +  .836967D+01, .763840D+01, .699943D+01, .642935D+01,
     +  .592153D+01, .545897D+01, .503794D+01, .465012D+01 /
        DATA (UPDI(I),I=7697,7748) /
     +  .429044D+01, .395499D+01, .364074D+01, .334541D+01,
     +  .306726D+01, .280502D+01, .255770D+01, .232458D+01,
     +  .210511D+01, .189887D+01, .170548D+01, .152546D+01,
     +  .135665D+01, .119993D+01, .105503D+01, .921656D+00,
     +  .799513D+00, .688264D+00, .587546D+00, .496962D+00,
     +  .416037D+00, .344253D+00, .281724D+00, .226999D+00,
     +  .179995D+00, .140118D+00, .106773D+00, .793549D-01,
     +  .572508D-01, .398729D-01, .265151D-01, .166964D-01,
     +  .976865D-02, .517045D-02, .236723D-02, .861917D-03,
     +  .206645D-03, .178363D-04, .000000D+00, .902698D+05,
     +  .704441D+05, .543377D+05, .419506D+05, .324183D+05,
     +  .250750D+05, .194151D+05, .150477D+05, .116758D+05,
     +  .906928D+04, .705321D+04, .549181D+04, .428178D+04 /
        DATA (UPDI(I),I=7749,7800) /
     +  .334274D+04, .261352D+04, .204636D+04, .160495D+04,
     +  .126084D+04, .992368D+03, .782547D+03, .618430D+03,
     +  .489814D+03, .388921D+03, .309616D+03, .247209D+03,
     +  .198001D+03, .159157D+03, .128020D+03, .103736D+03,
     +  .844353D+02, .690755D+02, .568133D+02, .470092D+02,
     +  .391650D+02, .328438D+02, .277451D+02, .236227D+02,
     +  .202728D+02, .175414D+02, .152991D+02, .134516D+02,
     +  .119143D+02, .106264D+02, .953646D+01, .860560D+01,
     +  .780164D+01, .710261D+01, .648183D+01, .593190D+01,
     +  .543365D+01, .498303D+01, .457061D+01, .419089D+01,
     +  .383931D+01, .351252D+01, .320781D+01, .292317D+01,
     +  .265697D+01, .240800D+01, .217526D+01, .195796D+01,
     +  .175544D+01, .156706D+01, .139314D+01, .123134D+01 /
        DATA (UPDI(I),I=7801,7852) /
     +  .108234D+01, .945673D+00, .820893D+00, .707523D+00,
     +  .605094D+00, .513095D+00, .431028D+00, .358328D+00,
     +  .294360D+00, .239112D+00, .191178D+00, .150366D+00,
     +  .116073D+00, .876680D-01, .645483D-01, .460997D-01,
     +  .317624D-01, .208721D-01, .129732D-01, .747985D-02,
     +  .389359D-02, .174790D-02, .621593D-03, .145438D-03,
     +  .126875D-04, .000000D+00, .160326D+06, .123852D+06,
     +  .944121D+05, .720067D+05, .549534D+05, .419622D+05,
     +  .320653D+05, .245185D+05, .187634D+05, .143700D+05,
     +  .110159D+05, .845213D+04, .649224D+04, .499209D+04,
     +  .384355D+04, .296299D+04, .228767D+04, .176893D+04,
     +  .137031D+04, .106346D+04, .827137D+03, .644764D+03,
     +  .503928D+03, .394929D+03, .310490D+03, .244936D+03 /
        DATA (UPDI(I),I=7853,7904) /
     +  .193990D+03, .153768D+03, .122872D+03, .986696D+02,
     +  .796868D+02, .647387D+02, .529472D+02, .436306D+02,
     +  .362141D+02, .302977D+02, .255647D+02, .217544D+02,
     +  .186748D+02, .161657D+02, .141131D+02, .124151D+02,
     +  .110007D+02, .980937D+01, .879677D+01, .792601D+01,
     +  .717236D+01, .650611D+01, .591888D+01, .538958D+01,
     +  .491363D+01, .448062D+01, .408450D+01, .372017D+01,
     +  .338390D+01, .307258D+01, .278386D+01, .251584D+01,
     +  .226703D+01, .203618D+01, .182224D+01, .162438D+01,
     +  .144167D+01, .127424D+01, .111962D+01, .978308D+00,
     +  .849639D+00, .733040D+00, .627889D+00, .533601D+00,
     +  .449548D+00, .375145D+00, .309758D+00, .252668D+00,
     +  .203760D+00, .161679D+00, .126155D+00, .965684D-01 /
        DATA (UPDI(I),I=7905,7956) /
     +  .722894D-01, .527248D-01, .372716D-01, .253991D-01,
     +  .164880D-01, .101109D-01, .574065D-02, .293576D-02,
     +  .129017D-02, .447003D-03, .101710D-03, .898331D-05,
     +  .000000D+00, .244642D+06, .187931D+06, .142317D+06,
     +  .107799D+06, .816851D+05, .619137D+05, .469494D+05,
     +  .356145D+05, .270311D+05, .205257D+05, .155965D+05,
     +  .118579D+05, .902297D+04, .687095D+04, .523757D+04,
     +  .399632D+04, .305312D+04, .233541D+04, .178926D+04,
     +  .137301D+04, .105571D+04, .813401D+03, .628279D+03,
     +  .486558D+03, .377987D+03, .294639D+03, .230605D+03,
     +  .180624D+03, .142672D+03, .113278D+03, .904839D+02,
     +  .727321D+02, .588806D+02, .480503D+02, .395158D+02,
     +  .327721D+02, .274259D+02, .231574D+02, .197340D+02 /
        DATA (UPDI(I),I=7957,8008) /
     +  .169640D+02, .147122D+02, .128599D+02, .113249D+02,
     +  .100379D+02, .894898D+01, .801655D+01, .721303D+01,
     +  .650584D+01, .588548D+01, .532909D+01, .483146D+01,
     +  .438125D+01, .397187D+01, .359766D+01, .325449D+01,
     +  .293886D+01, .264812D+01, .238007D+01, .213294D+01,
     +  .190524D+01, .169569D+01, .150324D+01, .132675D+01,
     +  .116615D+01, .101887D+01, .885194D+00, .764332D+00,
     +  .655578D+00, .558193D+00, .471489D+00, .394750D+00,
     +  .327317D+00, .268502D+00, .217529D+00, .174200D+00,
     +  .137213D+00, .106247D+00, .806759D-01, .598789D-01,
     +  .432784D-01, .302948D-01, .204278D-01, .131066D-01,
     +  .793411D-02, .443902D-02, .223202D-02, .961269D-03,
     +  .325004D-03, .720846D-04, .644138D-05, .000000D+00 /
        DATA (UPDI(I),I=8009,8060) /
     +  .250099D+06, .264734D+06, .199514D+06, .150368D+06,
     +  .113351D+06, .854508D+05, .644348D+05, .485935D+05,
     +  .366592D+05, .276619D+05, .208820D+05, .157691D+05,
     +  .119151D+05, .900737D+04, .681452D+04, .515909D+04,
     +  .390980D+04, .296588D+04, .225287D+04, .171354D+04,
     +  .130564D+04, .996646D+03, .762534D+03, .584832D+03,
     +  .449884D+03, .347209D+03, .269048D+03, .208605D+03,
     +  .163140D+03, .128258D+03, .101462D+03, .807890D+02,
     +  .648065D+02, .524231D+02, .427498D+02, .351705D+02,
     +  .292097D+02, .244858D+02, .207235D+02, .176986D+02,
     +  .152538D+02, .132534D+02, .116035D+02, .102265D+02,
     +  .906630D+01, .807698D+01, .722797D+01, .648399D+01,
     +  .583428D+01, .525436D+01, .473830D+01, .427392D+01 /
        DATA (UPDI(I),I=8061,8112) /
     +  .385400D+01, .347241D+01, .312457D+01, .280664D+01,
     +  .251562D+01, .224903D+01, .200484D+01, .178132D+01,
     +  .157697D+01, .139054D+01, .122068D+01, .106714D+01,
     +  .927257D+00, .801146D+00, .687881D+00, .586649D+00,
     +  .496611D+00, .416996D+00, .347014D+00, .285953D+00,
     +  .233080D+00, .187585D+00, .149200D+00, .116685D+00,
     +  .896789D-01, .675631D-01, .497313D-01, .356277D-01,
     +  .247023D-01, .164864D-01, .104582D-01, .625186D-02,
     +  .344837D-02, .170574D-02, .720470D-03, .238004D-03,
     +  .515592D-04, .465854D-05, .000000D+00, .486305D+06,
     +  .370632D+06, .278058D+06, .208584D+06, .156470D+06,
     +  .117364D+06, .880364D+05, .660338D+05, .495362D+05,
     +  .371610D+05, .278832D+05, .209243D+05, .157074D+05 /
        DATA (UPDI(I),I=8113,8164) /
     +  .117942D+05, .886043D+04, .665942D+04, .500886D+04,
     +  .377009D+04, .284067D+04, .214267D+04, .161860D+04,
     +  .122462D+04, .928432D+03, .705435D+03, .537485D+03,
     +  .410788D+03, .315184D+03, .241917D+03, .187304D+03,
     +  .145794D+03, .114198D+03, .900500D+02, .715511D+02,
     +  .573499D+02, .463538D+02, .378130D+02, .311503D+02,
     +  .259118D+02, .217694D+02, .184615D+02, .158044D+02,
     +  .136427D+02, .118690D+02, .103960D+02, .916061D+01,
     +  .811212D+01, .721646D+01, .643536D+01, .575660D+01,
     +  .515395D+01, .462061D+01, .414350D+01, .371466D+01,
     +  .332744D+01, .297676D+01, .265837D+01, .236891D+01,
     +  .210559D+01, .186608D+01, .164839D+01, .145078D+01,
     +  .127179D+01, .110986D+01, .964529D+00, .833076D+00 /
        DATA (UPDI(I),I=8165,8216) /
     +  .715417D+00, .610510D+00, .517430D+00, .435250D+00,
     +  .363122D+00, .300194D+00, .245708D+00, .198896D+00,
     +  .158930D+00, .125482D+00, .973849D-01, .742478D-01,
     +  .554695D-01, .404696D-01, .287217D-01, .197145D-01,
     +  .130163D-01, .815989D-02, .481513D-02, .261766D-02,
     +  .127372D-02, .527857D-03, .170615D-03, .362049D-04,
     +  .330446D-05, .000000D+00, .658612D+06, .500217D+06,
     +  .373738D+06, .279174D+06, .208510D+06, .155694D+06,
     +  .116246D+06, .867742D+05, .647717D+05, .483411D+05,
     +  .360794D+05, .269263D+05, .200980D+05, .150023D+05,
     +  .112018D+05, .836609D+04, .625140D+04, .467351D+04,
     +  .349672D+04, .261844D+04, .196320D+04, .147387D+04,
     +  .110850D+04, .835365D+03, .631135D+03, .478218D+03 /
        DATA (UPDI(I),I=8217,8268) /
     +  .363712D+03, .276655D+03, .212284D+03, .163757D+03,
     +  .127122D+03, .993564D+02, .782599D+02, .621985D+02,
     +  .498607D+02, .403535D+02, .329916D+02, .272452D+02,
     +  .227311D+02, .191492D+02, .162882D+02, .139732D+02,
     +  .120829D+02, .105206D+02, .921611D+01, .811393D+01,
     +  .717656D+01, .636289D+01, .565921D+01, .503765D+01,
     +  .449048D+01, .400376D+01, .356884D+01, .317853D+01,
     +  .282725D+01, .251039D+01, .222420D+01, .196560D+01,
     +  .173197D+01, .152108D+01, .133096D+01, .115995D+01,
     +  .100630D+01, .869357D+00, .746364D+00, .637056D+00,
     +  .540289D+00, .455049D+00, .380336D+00, .315241D+00,
     +  .258874D+00, .210438D+00, .169150D+00, .134174D+00,
     +  .105141D+00, .809555D-01, .612133D-01, .453355D-01 /
        DATA (UPDI(I),I=8269,8320) /
     +  .327729D-01, .230322D-01, .156428D-01, .102109D-01,
     +  .632118D-02, .367858D-02, .196863D-02, .940805D-03,
     +  .381731D-03, .120376D-03, .249402D-04, .230346D-05,
     +  .000000D+00, .868709D+06, .657625D+06, .489435D+06,
     +  .364138D+06, .270853D+06, .201392D+06, .149713D+06,
     +  .111257D+06, .826648D+05, .614028D+05, .456040D+05,
     +  .338630D+05, .251441D+05, .186682D+05, .138616D+05,
     +  .102932D+05, .764583D+04, .568098D+04, .422358D+04,
     +  .314205D+04, .233985D+04, .174439D+04, .130252D+04,
     +  .974308D+03, .730510D+03, .549195D+03, .414371D+03,
     +  .312605D+03, .237906D+03, .182015D+03, .140132D+03,
     +  .108632D+03, .848772D+02, .669289D+02, .532422D+02,
     +  .427722D+02, .347204D+02, .284774D+02, .236033D+02 /
        DATA (UPDI(I),I=8321,8372) /
     +  .197585D+02, .167038D+02, .142446D+02, .122459D+02,
     +  .106013D+02, .923404D+01, .808379D+01, .710975D+01,
     +  .626807D+01, .554357D+01, .490681D+01, .434917D+01,
     +  .385588D+01, .341758D+01, .302658D+01, .267681D+01,
     +  .236330D+01, .208195D+01, .182938D+01, .160270D+01,
     +  .139945D+01, .121745D+01, .105486D+01, .909759D+00,
     +  .781321D+00, .666761D+00, .565658D+00, .476782D+00,
     +  .399048D+00, .331403D+00, .272894D+00, .222604D+00,
     +  .179716D+00, .143439D+00, .112947D+00, .878406D-01,
     +  .671009D-01, .503181D-01, .369424D-01, .264599D-01,
     +  .184132D-01, .123737D-01, .798496D-02, .488108D-02,
     +  .280109D-02, .147556D-02, .692523D-03, .275106D-03,
     +  .846499D-04, .171322D-04, .160128D-05, .000000D+00 /
        DATA (UPDI(I),I=8373,8424) /
     +  .112303D+07, .847441D+06, .628315D+06, .465654D+06,
     +  .344989D+06, .255473D+06, .189123D+06, .139944D+06,
     +  .103522D+06, .765485D+05, .565891D+05, .418196D+05,
     +  .308996D+05, .228254D+05, .168603D+05, .124528D+05,
     +  .919876D+04, .679583D+04, .502269D+04, .371383D+04,
     +  .274832D+04, .203567D+04, .150990D+04, .112170D+04,
     +  .835105D+03, .623294D+03, .466815D+03, .349494D+03,
     +  .263961D+03, .200406D+03, .153110D+03, .117791D+03,
     +  .913410D+02, .714970D+02, .564677D+02, .450485D+02,
     +  .363228D+02, .295995D+02, .243805D+02, .202864D+02,
     +  .170498D+02, .144568D+02, .123584D+02, .106393D+02,
     +  .921590D+01, .802342D+01, .701785D+01, .615276D+01,
     +  .541151D+01, .476322D+01, .419836D+01, .370138D+01 /
        DATA (UPDI(I),I=8425,8476) /
     +  .326225D+01, .287279D+01, .252649D+01, .221798D+01,
     +  .194286D+01, .169746D+01, .147863D+01, .128371D+01,
     +  .111033D+01, .956465D+00, .820063D+00, .700140D+00,
     +  .593903D+00, .500790D+00, .419507D+00, .348912D+00,
     +  .287917D+00, .235539D+00, .190848D+00, .153022D+00,
     +  .121272D+00, .947917D-01, .731641D-01, .554469D-01,
     +  .412341D-01, .300090D-01, .212954D-01, .146734D-01,
     +  .975594D-02, .622367D-02, .375648D-02, .212569D-02,
     +  .110221D-02, .508021D-03, .197608D-03, .593539D-04,
     +  .117453D-04, .111078D-05, .000000D+00, .142839D+07,
     +  .107448D+07, .793675D+06, .585964D+06, .432432D+06,
     +  .318953D+06, .235156D+06, .173282D+06, .127637D+06,
     +  .939679D+05, .691555D+05, .508715D+05, .374107D+05 /
        DATA (UPDI(I),I=8477,8528) /
     +  .275015D+05, .202132D+05, .148529D+05, .109140D+05,
     +  .801938D+04, .589396D+04, .433306D+04, .318761D+04,
     +  .234670D+04, .172970D+04, .127672D+04, .944247D+03,
     +  .699978D+03, .520627D+03, .387006D+03, .290213D+03,
     +  .218760D+03, .165932D+03, .126744D+03, .975888D+02,
     +  .758598D+02, .595080D+02, .471629D+02, .377863D+02,
     +  .306038D+02, .250585D+02, .207309D+02, .173258D+02,
     +  .146101D+02, .124216D+02, .106361D+02, .916341D+01,
     +  .793468D+01, .690279D+01, .601887D+01, .526488D+01,
     +  .460863D+01, .403969D+01, .354176D+01, .310420D+01,
     +  .271836D+01, .237727D+01, .207526D+01, .180757D+01,
     +  .157031D+01, .136009D+01, .117404D+01, .100962D+01,
     +  .864676D+00, .737022D+00, .625537D+00, .527439D+00 /
        DATA (UPDI(I),I=8529,8580) /
     +  .442045D+00, .368015D+00, .304166D+00, .249387D+00,
     +  .202685D+00, .163128D+00, .129896D+00, .102216D+00,
     +  .793087D-01, .607498D-01, .456726D-01, .336825D-01,
     +  .242984D-01, .170830D-01, .116544D-01, .766620D-02,
     +  .483434D-02, .288098D-02, .160749D-02, .820407D-03,
     +  .371351D-03, .141455D-03, .414910D-04, .803512D-05,
     +  .768762D-06, .000000D+00, .179189D+07, .134372D+07,
     +  .988868D+06, .727321D+06, .534687D+06, .392827D+06,
     +  .288462D+06, .211693D+06, .155279D+06, .113831D+06,
     +  .834077D+05, .610816D+05, .447137D+05, .327160D+05,
     +  .239303D+05, .174976D+05, .127923D+05, .935067D+04,
     +  .683573D+04, .499787D+04, .365594D+04, .267589D+04,
     +  .196061D+04, .143833D+04, .105711D+04, .778618D+03 /
        DATA (UPDI(I),I=8581,8632) /
     +  .575334D+03, .424793D+03, .316410D+03, .236895D+03,
     +  .178469D+03, .135402D+03, .103560D+03, .799764D+02,
     +  .623363D+02, .490983D+02, .391006D+02, .314844D+02,
     +  .256342D+02, .210909D+02, .175319D+02, .147056D+02,
     +  .124369D+02, .105933D+02, .907854D+01, .781960D+01,
     +  .676657D+01, .586835D+01, .510556D+01, .444479D+01,
     +  .387475D+01, .337846D+01, .294470D+01, .256436D+01,
     +  .223008D+01, .193586D+01, .167667D+01, .144835D+01,
     +  .124733D+01, .107055D+01, .915331D+00, .779379D+00,
     +  .660426D+00, .557223D+00, .467021D+00, .389029D+00,
     +  .321877D+00, .264361D+00, .215362D+00, .173885D+00,
     +  .139009D+00, .109927D+00, .858873D-01, .661472D-01,
     +  .502825D-01, .375012D-01, .274251D-01, .196101D-01 /
        DATA (UPDI(I),I=8633,8684) /
     +  .136584D-01, .922548D-02, .600354D-02, .374214D-02,
     +  .220175D-02, .121126D-02, .608450D-03, .270470D-03,
     +  .100905D-03, .289143D-04, .548470D-05, .530785D-06,
     +  .000000D+00, .222072D+07, .166016D+07, .121723D+07,
     +  .891935D+06, .653201D+06, .478037D+06, .349645D+06,
     +  .255560D+06, .186685D+06, .136280D+06, .994297D+05,
     +  .724968D+05, .528328D+05, .384801D+05, .280148D+05,
     +  .203862D+05, .148310D+05, .107864D+05, .784471D+04,
     +  .570528D+04, .415080D+04, .302120D+04, .220100D+04,
     +  .160525D+04, .117275D+04, .858505D+03, .630417D+03,
     +  .462485D+03, .342287D+03, .254626D+03, .190595D+03,
     +  .143679D+03, .109197D+03, .838097D+02, .649291D+02,
     +  .508404D+02, .402573D+02, .322369D+02, .261058D+02 /
        DATA (UPDI(I),I=8685,8736) /
     +  .213662D+02, .176690D+02, .147448D+02, .124063D+02,
     +  .105132D+02, .896346D+01, .768034D+01, .661130D+01,
     +  .570321D+01, .493540D+01, .427341D+01, .370509D+01,
     +  .321287D+01, .278495D+01, .241183D+01, .208576D+01,
     +  .180046D+01, .155063D+01, .133192D+01, .114054D+01,
     +  .973302D+00, .827399D+00, .700425D+00, .590042D+00,
     +  .494902D+00, .412296D+00, .341351D+00, .280682D+00,
     +  .229075D+00, .185418D+00, .148724D+00, .118093D+00,
     +  .927403D-01, .719429D-01, .549968D-01, .414870D-01,
     +  .306932D-01, .222577D-01, .157745D-01, .108841D-01,
     +  .727811D-02, .468537D-02, .288662D-02, .167672D-02,
     +  .909435D-03, .449620D-03, .196283D-03, .717292D-04,
     +  .200876D-04, .373534D-05, .365587D-06, .000000D+00 /
        DATA (UPDI(I),I=8737,8788) /
     +  .272205D+07, .202871D+07, .148200D+07, .108191D+07,
     +  .789328D+06, .575440D+06, .419240D+06, .305208D+06,
     +  .222049D+06, .161427D+06, .117281D+06, .851458D+05,
     +  .617791D+05, .447949D+05, .324633D+05, .235131D+05,
     +  .170241D+05, .123211D+05, .891602D+04, .645126D+04,
     +  .466893D+04, .338011D+04, .244896D+04, .177607D+04,
     +  .129011D+04, .938877D+03, .685335D+03, .499702D+03,
     +  .367583D+03, .271775D+03, .202189D+03, .151497D+03,
     +  .114450D+03, .873273D+02, .672667D+02, .523779D+02,
     +  .412504D+02, .328589D+02, .264731D+02, .215579D+02,
     +  .177388D+02, .147297D+02, .123321D+02, .103981D+02,
     +  .882049D+01, .751915D+01, .643912D+01, .552544D+01,
     +  .475626D+01, .409616D+01, .353221D+01, .304627D+01 /
        DATA (UPDI(I),I=8789,8840) /
     +  .262606D+01, .226167D+01, .194505D+01, .166962D+01,
     +  .142988D+01, .122127D+01, .103985D+01, .882309D+00,
     +  .745732D+00, .627630D+00, .525616D+00, .438260D+00,
     +  .362912D+00, .298631D+00, .244033D+00, .197907D+00,
     +  .159158D+00, .126819D+00, .100019D+00, .780011D-01,
     +  .600760D-01, .455832D-01, .341220D-01, .250410D-01,
     +  .180058D-01, .126477D-01, .864452D-02, .572253D-02,
     +  .364417D-02, .221898D-02, .127240D-02, .680387D-03,
     +  .331060D-03, .141935D-03, .508142D-04, .139129D-04,
     +  .253823D-05, .251196D-06, .000000D+00, .330282D+07,
     +  .245408D+07, .178619D+07, .129916D+07, .944274D+06,
     +  .685779D+06, .497692D+06, .360897D+06, .261514D+06,
     +  .189343D+06, .136993D+06, .990368D+05, .715488D+05 /
        DATA (UPDI(I),I=8841,8892) /
     +  .516513D+05, .372648D+05, .268676D+05, .193623D+05,
     +  .139466D+05, .100432D+05, .723076D+04, .520649D+04,
     +  .374971D+04, .270233D+04, .194921D+04, .140806D+04,
     +  .101894D+04, .739531D+03, .536063D+03, .392038D+03,
     +  .288169D+03, .213139D+03, .158782D+03, .119272D+03,
     +  .905023D+02, .693338D+02, .537028D+02, .420768D+02,
     +  .333498D+02, .267370D+02, .216678D+02, .177437D+02,
     +  .146631D+02, .122169D+02, .102505D+02, .865210D+01,
     +  .733835D+01, .625219D+01, .533703D+01, .456993D+01,
     +  .391464D+01, .335751D+01, .287989D+01, .246904D+01,
     +  .211472D+01, .180859D+01, .154383D+01, .131474D+01,
     +  .111659D+01, .945327D+00, .797521D+00, .670188D+00,
     +  .560776D+00, .466869D+00, .386973D+00, .318512D+00 /
        DATA (UPDI(I),I=8893,8944) /
     +  .260493D+00, .211545D+00, .170474D+00, .136211D+00,
     +  .107817D+00, .844567D-01, .654052D-01, .500130D-01,
     +  .376642D-01, .279769D-01, .203653D-01, .145196D-01,
     +  .101079D-01, .684332D-02, .448449D-02, .282481D-02,
     +  .169993D-02, .962231D-03, .507240D-03, .242902D-03,
     +  .102276D-03, .358770D-04, .960770D-05, .172100D-05,
     +  .172191D-06, .000000D+00, .159314D+05, .257178D+05,
     +  .206374D+05, .165624D+05, .132936D+05, .106714D+05,
     +  .856784D+04, .688015D+04, .552603D+04, .443947D+04,
     +  .356751D+04, .286771D+04, .230599D+04, .185506D+04,
     +  .149301D+04, .120226D+04, .968736D+03, .781122D+03,
     +  .630357D+03, .509167D+03, .411719D+03, .333330D+03,
     +  .270245D+03, .219452D+03, .178531D+03, .145542D+03 /
        DATA (UPDI(I),I=8945,8996) /
     +  .118928D+03, .971636D+02, .798514D+02, .658400D+02,
     +  .544844D+02, .452668D+02, .377709D+02, .316785D+02,
     +  .266877D+02, .226001D+02, .192405D+02, .164682D+02,
     +  .141697D+02, .122532D+02, .106480D+02, .929256D+01,
     +  .814061D+01, .715458D+01, .630453D+01, .556671D+01,
     +  .492446D+01, .435662D+01, .385820D+01, .341351D+01,
     +  .301939D+01, .266787D+01, .235385D+01, .207305D+01,
     +  .182186D+01, .159723D+01, .139651D+01, .121737D+01,
     +  .105777D+01, .915860D+00, .789974D+00, .678594D+00,
     +  .580330D+00, .494282D+00, .418399D+00, .352168D+00,
     +  .294597D+00, .244782D+00, .201891D+00, .165165D+00,
     +  .133909D+00, .107490D+00, .853144D-01, .668441D-01,
     +  .517455D-01, .393561D-01, .293942D-01, .214979D-01 /
        DATA (UPDI(I),I=8997,9048) /
     +  .153426D-01, .106382D-01, .712635D-02, .458176D-02,
     +  .279041D-02, .159418D-02, .835358D-03, .388985D-03,
     +  .152649D-03, .457073D-04, .835368D-05, .456436D-06,
     +  .000000D+00, .900584D+05, .702560D+05, .541706D+05,
     +  .418022D+05, .322866D+05, .249583D+05, .193117D+05,
     +  .149561D+05, .115948D+05, .899763D+04, .698991D+04,
     +  .543595D+04, .423253D+04, .329936D+04, .257534D+04,
     +  .201281D+04, .157549D+04, .123499D+04, .969720D+03,
     +  .762722D+03, .601092D+03, .474663D+03, .375690D+03,
     +  .298066D+03, .237126D+03, .189196D+03, .151459D+03,
     +  .121291D+03, .978276D+02, .792268D+02, .644607D+02,
     +  .526982D+02, .433102D+02, .358078D+02, .297647D+02,
     +  .248884D+02, .209400D+02, .177237D+02, .150917D+02 /
        DATA (UPDI(I),I=9049,9100) /
     +  .129218D+02, .111251D+02, .962305D+01, .835942D+01,
     +  .728751D+01, .637205D+01, .558418D+01, .490438D+01,
     +  .430820D+01, .378938D+01, .333016D+01, .292648D+01,
     +  .256925D+01, .225265D+01, .197170D+01, .172229D+01,
     +  .150091D+01, .130453D+01, .113053D+01, .976599D+00,
     +  .840694D+00, .720963D+00, .615772D+00, .523568D+00,
     +  .443380D+00, .373125D+00, .312218D+00, .259625D+00,
     +  .214425D+00, .175768D+00, .142896D+00, .115111D+00,
     +  .917921D-01, .723650D-01, .562998D-01, .432680D-01,
     +  .326591D-01, .241981D-01, .175499D-01, .124135D-01,
     +  .852623D-02, .565279D-02, .359435D-02, .216409D-02,
     +  .122156D-02, .631288D-03, .289357D-03, .111448D-03,
     +  .326578D-04, .585018D-05, .324957D-06, .000000D+00 /
        DATA (UPDI(I),I=9101,9152) /
     +  .160100D+06, .123650D+06, .942331D+05, .718479D+05,
     +  .548126D+05, .418374D+05, .319547D+05, .244207D+05,
     +  .186769D+05, .142936D+05, .109483D+05, .839256D+04,
     +  .643973D+04, .494584D+04, .380286D+04, .292722D+04,
     +  .225625D+04, .174136D+04, .134614D+04, .104228D+04,
     +  .808596D+03, .628541D+03, .489735D+03, .382513D+03,
     +  .299625D+03, .235418D+03, .185642D+03, .146443D+03,
     +  .116413D+03, .929508D+02, .745968D+02, .601796D+02,
     +  .488320D+02, .398827D+02, .327679D+02, .270964D+02,
     +  .225590D+02, .189036D+02, .159447D+02, .135294D+02,
     +  .115491D+02, .990825D+01, .854017D+01, .738922D+01,
     +  .641439D+01, .558197D+01, .486938D+01, .424915D+01,
     +  .371354D+01, .324294D+01, .283234D+01, .247162D+01 /
        DATA (UPDI(I),I=9153,9204) /
     +  .215422D+01, .187456D+01, .162803D+01, .141072D+01,
     +  .121924D+01, .105073D+01, .902643D+00, .772751D+00,
     +  .659054D+00, .559819D+00, .473369D+00, .398666D+00,
     +  .333622D+00, .277591D+00, .229513D+00, .188458D+00,
     +  .153572D+00, .124101D+00, .993530D-01, .787247D-01,
     +  .616611D-01, .476479D-01, .363642D-01, .272483D-01,
     +  .200351D-01, .144144D-01, .101094D-01, .688161D-02,
     +  .451833D-02, .284353D-02, .169115D-02, .941396D-03,
     +  .478979D-03, .215729D-03, .813910D-04, .232836D-04,
     +  .407883D-05, .231106D-06, .000000D+00, .244400D+06,
     +  .187716D+06, .142126D+06, .107630D+06, .815350D+05,
     +  .617807D+05, .468317D+05, .355104D+05, .269391D+05,
     +  .204444D+05, .155247D+05, .117946D+05, .896716D+04 /
        DATA (UPDI(I),I=9205,9256) /
     +  .682181D+04, .519432D+04, .395830D+04, .301972D+04,
     +  .230609D+04, .176354D+04, .135045D+04, .103594D+04,
     +  .796079D+03, .613102D+03, .473256D+03, .366320D+03,
     +  .284393D+03, .221592D+03, .172690D+03, .135651D+03,
     +  .107040D+03, .849122D+02, .677250D+02, .543476D+02,
     +  .439125D+02, .357057D+02, .292316D+02, .241048D+02,
     +  .200144D+02, .167346D+02, .140812D+02, .119246D+02,
     +  .101523D+02, .868641D+01, .746263D+01, .643394D+01,
     +  .556190D+01, .482082D+01, .418032D+01, .363114D+01,
     +  .315195D+01, .273674D+01, .237445D+01, .205782D+01,
     +  .178070D+01, .153801D+01, .132547D+01, .113939D+01,
     +  .976677D+00, .834568D+00, .710696D+00, .602932D+00,
     +  .509455D+00, .428500D+00, .358969D+00, .298787D+00 /
        DATA (UPDI(I),I=9257,9308) /
     +  .247260D+00, .203311D+00, .166013D+00, .134514D+00,
     +  .108069D+00, .860040D-01, .677315D-01, .527190D-01,
     +  .404723D-01, .306808D-01, .228281D-01, .166613D-01,
     +  .118946D-01, .827399D-02, .558350D-02, .363181D-02,
     +  .226292D-02, .133118D-02, .732260D-03, .367691D-03,
     +  .163221D-03, .605958D-04, .170544D-04, .296205D-05,
     +  .172737D-06, .000000D+00, .250163D+06, .264505D+06,
     +  .199311D+06, .150188D+06, .113191D+06, .853095D+05,
     +  .643098D+05, .484830D+05, .365616D+05, .275756D+05,
     +  .208059D+05, .157020D+05, .118559D+05, .895526D+04,
     +  .676866D+04, .511877D+04, .387436D+04, .293476D+04,
     +  .222554D+04, .168956D+04, .128461D+04, .978192D+03,
     +  .746341D+03, .570615D+03, .437390D+03, .336211D+03 /
        DATA (UPDI(I),I=9309,9360) /
     +  .259349D+03, .200045D+03, .155544D+03, .121490D+03,
     +  .953999D+02, .753277D+02, .598521D+02, .478942D+02,
     +  .385770D+02, .312943D+02, .255786D+02, .210580D+02,
     +  .174639D+02, .145800D+02, .122544D+02, .103578D+02,
     +  .880063D+01, .750994D+01, .643259D+01, .552557D+01,
     +  .475996D+01, .410267D+01, .354284D+01, .305757D+01,
     +  .263982D+01, .227767D+01, .196317D+01, .168966D+01,
     +  .145163D+01, .124445D+01, .106417D+01, .907480D+00,
     +  .771451D+00, .653582D+00, .551643D+00, .463739D+00,
     +  .388044D+00, .323406D+00, .267783D+00, .220435D+00,
     +  .180286D+00, .146414D+00, .117978D+00, .942498D-01,
     +  .745719D-01, .583796D-01, .451631D-01, .344515D-01,
     +  .259460D-01, .191729D-01, .138931D-01, .984371D-02 /
        DATA (UPDI(I),I=9361,9412) /
     +  .679285D-02, .454530D-02, .292964D-02, .180772D-02,
     +  .105211D-02, .572075D-03, .283589D-03, .124117D-03,
     +  .453591D-04, .125623D-04, .216036D-05, .129239D-06,
     +  .000000D+00, .486029D+06, .370387D+06, .277841D+06,
     +  .208391D+06, .156299D+06, .117213D+06, .879029D+05,
     +  .659157D+05, .494319D+05, .370689D+05, .278019D+05,
     +  .208526D+05, .156442D+05, .117386D+05, .881149D+04,
     +  .661638D+04, .497102D+04, .373683D+04, .281145D+04,
     +  .211702D+04, .159606D+04, .120482D+04, .911035D+03,
     +  .690134D+03, .524010D+03, .398901D+03, .304676D+03,
     +  .232619D+03, .179032D+03, .138405D+03, .107564D+03,
     +  .840624D+02, .661113D+02, .523733D+02, .417687D+02,
     +  .335580D+02, .271726D+02, .221684D+02, .182243D+02 /
        DATA (UPDI(I),I=9413,9464) /
     +  .150870D+02, .125778D+02, .105482D+02, .889468D+01,
     +  .753476D+01, .640807D+01, .546654D+01, .467756D+01,
     +  .400509D+01, .343642D+01, .294700D+01, .252863D+01,
     +  .216848D+01, .185787D+01, .158960D+01, .135771D+01,
     +  .115723D+01, .983928D+00, .834294D+00, .705235D+00,
     +  .594127D+00, .498652D+00, .416847D+00, .346841D+00,
     +  .287437D+00, .236640D+00, .193674D+00, .157473D+00,
     +  .127128D+00, .101818D+00, .808379D-01, .635551D-01,
     +  .494316D-01, .379857D-01, .287749D-01, .215156D-01,
     +  .157794D-01, .113440D-01, .797092D-02, .545213D-02,
     +  .361401D-02, .230579D-02, .140725D-02, .809143D-03,
     +  .434087D-03, .211924D-03, .911316D-04, .326123D-04,
     +  .880578D-05, .147310D-05, .887448D-07, .000000D+00 /
        DATA (UPDI(I),I=9465,9516) /
     +  .658317D+06, .499955D+06, .373506D+06, .278968D+06,
     +  .208328D+06, .155533D+06, .116103D+06, .866482D+05,
     +  .646605D+05, .482429D+05, .359928D+05, .268499D+05,
     +  .200307D+05, .149430D+05, .111496D+05, .832017D+04,
     +  .621101D+04, .463800D+04, .346550D+04, .259100D+04,
     +  .193907D+04, .145265D+04, .108983D+04, .818913D+03,
     +  .616622D+03, .465389D+03, .352349D+03, .266579D+03,
     +  .203302D+03, .155719D+03, .119893D+03, .928233D+02,
     +  .723200D+02, .567638D+02, .448567D+02, .357167D+02,
     +  .286675D+02, .231893D+02, .189063D+02, .155266D+02,
     +  .128443D+02, .106911D+02, .894965D+01, .752787D+01,
     +  .635822D+01, .538766D+01, .457996D+01, .389629D+01,
     +  .332210D+01, .283130D+01, .241458D+01, .205828D+01 /
        DATA (UPDI(I),I=9517,9568) /
     +  .175304D+01, .149116D+01, .126627D+01, .107312D+01,
     +  .907235D+00, .764923D+00, .642960D+00, .538627D+00,
     +  .449539D+00, .373685D+00, .309172D+00, .254771D+00,
     +  .208542D+00, .169686D+00, .137157D+00, .110064D+00,
     +  .876134D-01, .691261D-01, .539994D-01, .417233D-01,
     +  .318456D-01, .239538D-01, .177808D-01, .129410D-01,
     +  .922932D-02, .643064D-02, .435959D-02, .286259D-02,
     +  .180788D-02, .109140D-02, .620091D-03, .328364D-03,
     +  .158016D-03, .668730D-04, .235109D-04, .623177D-05,
     +  .102871D-05, .635486D-07, .000000D+00, .868393D+06,
     +  .657345D+06, .489186D+06, .363918D+06, .270658D+06,
     +  .201220D+06, .149561D+06, .111123D+06, .825461D+05,
     +  .612980D+05, .455116D+05, .337816D+05, .250723D+05 /
        DATA (UPDI(I),I=9569,9620) /
     +  .186049D+05, .138060D+05, .102443D+05, .760273D+04,
     +  .564307D+04, .419023D+04, .311271D+04, .231402D+04,
     +  .172165D+04, .128249D+04, .956634D+03, .714895D+03,
     +  .535371D+03, .402106D+03, .301711D+03, .228179D+03,
     +  .173298D+03, .132285D+03, .101535D+03, .784229D+02,
     +  .610259D+02, .478132D+02, .377512D+02, .300506D+02,
     +  .241127D+02, .195049D+02, .158962D+02, .130526D+02,
     +  .107864D+02, .896608D+01, .749019D+01, .628416D+01,
     +  .529012D+01, .446835D+01, .377738D+01, .320086D+01,
     +  .271134D+01, .229843D+01, .194769D+01, .164917D+01,
     +  .139471D+01, .117759D+01, .992303D+00, .834181D+00,
     +  .699384D+00, .584584D+00, .486992D+00, .404177D+00,
     +  .334101D+00, .274865D+00, .225221D+00, .183297D+00 /
        DATA (UPDI(I),I=9621,9672) /
     +  .148280D+00, .119148D+00, .950404D-01, .751925D-01,
     +  .589557D-01, .457595D-01, .351240D-01, .266271D-01,
     +  .198872D-01, .146548D-01, .105846D-01, .748840D-02,
     +  .517380D-02, .347638D-02, .226110D-02, .141353D-02,
     +  .844076D-03, .473886D-03, .247705D-03, .117506D-03,
     +  .489500D-04, .169147D-04, .440494D-05, .718692D-06,
     +  .455448D-07, .000000D+00, .112269D+07, .847142D+06,
     +  .628050D+06, .465420D+06, .344781D+06, .255289D+06,
     +  .188961D+06, .139800D+06, .103396D+06, .764370D+05,
     +  .564907D+05, .417328D+05, .308232D+05, .227581D+05,
     +  .168010D+05, .124006D+05, .915279D+04, .675538D+04,
     +  .498708D+04, .368248D+04, .272070D+04, .201133D+04,
     +  .148843D+04, .110273D+04, .818325D+03, .608418D+03 /
        DATA (UPDI(I),I=9673,9724) /
     +  .453600D+03, .337740D+03, .253455D+03, .190982D+03,
     +  .144621D+03, .110111D+03, .843591D+02, .651170D+02,
     +  .506089D+02, .396420D+02, .313094D+02, .249308D+02,
     +  .200160D+02, .161938D+02, .132025D+02, .108345D+02,
     +  .894505D+01, .742311D+01, .618741D+01, .517546D+01,
     +  .434421D+01, .364972D+01, .307396D+01, .258820D+01,
     +  .218107D+01, .183745D+01, .154684D+01, .130068D+01,
     +  .109197D+01, .914968D+00, .764859D+00, .637686D+00,
     +  .530046D+00, .439103D+00, .362405D+00, .297901D+00,
     +  .243705D+00, .198562D+00, .160673D+00, .129224D+00,
     +  .103225D+00, .818454D-01, .643572D-01, .501445D-01,
     +  .386708D-01, .294870D-01, .222021D-01, .164650D-01,
     +  .120445D-01, .863265D-02, .605853D-02, .415062D-02 /
        DATA (UPDI(I),I=9725,9776) /
     +  .276406D-02, .178078D-02, .110196D-02, .650872D-03,
     +  .361087D-03, .186313D-03, .871327D-04, .357329D-04,
     +  .121393D-04, .310735D-05, .501251D-06, .325680D-07,
     +  .000000D+00, .142803D+07, .107417D+07, .793392D+06,
     +  .585714D+06, .432211D+06, .318758D+06, .234983D+06,
     +  .173129D+06, .127502D+06, .938491D+05, .690507D+05,
     +  .507792D+05, .373293D+05, .274297D+05, .201500D+05,
     +  .147973D+05, .108650D+05, .797622D+04, .585595D+04,
     +  .429957D+04, .315809D+04, .232065D+04, .170670D+04,
     +  .125639D+04, .926237D+03, .683995D+03, .506413D+03,
     +  .374352D+03, .278894D+03, .208601D+03, .156779D+03,
     +  .118465D+03, .900676D+02, .689953D+02, .532160D+02,
     +  .413712D+02, .324328D+02, .256374D+02, .204363D+02 /
        DATA (UPDI(I),I=9777,9828) /
     +  .164184D+02, .132940D+02, .108367D+02, .888804D+01,
     +  .732832D+01, .606973D+01, .504538D+01, .420911D+01,
     +  .351474D+01, .294261D+01, .246294D+01, .206339D+01,
     +  .172827D+01, .144659D+01, .120949D+01, .100968D+01,
     +  .841281D+00, .699339D+00, .579819D+00, .479273D+00,
     +  .394840D+00, .324063D+00, .264899D+00, .215489D+00,
     +  .174581D+00, .140458D+00, .112309D+00, .891842D-01,
     +  .702882D-01, .549310D-01, .425315D-01, .325887D-01,
     +  .246850D-01, .184599D-01, .135926D-01, .987057D-02,
     +  .702019D-02, .488728D-02, .331992D-02, .219112D-02,
     +  .139826D-02, .856454D-03, .500360D-03, .274299D-03,
     +  .139712D-03, .644190D-04, .260108D-04, .868981D-05,
     +  .218725D-05, .348929D-06, .232310D-07, .000000D+00 /
        DATA (UPDI(I),I=9829,9880) /
     +  .179150D+07, .134338D+07, .988567D+06, .727055D+06,
     +  .534451D+06, .392619D+06, .288278D+06, .211531D+06,
     +  .155136D+06, .113704D+06, .832961D+05, .609833D+05,
     +  .446270D+05, .326396D+05, .238630D+05, .174383D+05,
     +  .127400D+05, .930465D+04, .679517D+04, .496211D+04,
     +  .362440D+04, .264805D+04, .193600D+04, .141655D+04,
     +  .103781D+04, .761469D+03, .560072D+03, .411198D+03,
     +  .304244D+03, .225974D+03, .168632D+03, .126509D+03,
     +  .954893D+02, .726220D+02, .556097D+02, .429235D+02,
     +  .334120D+02, .262280D+02, .207641D+02, .165698D+02,
     +  .133282D+02, .107943D+02, .879694D+01, .720780D+01,
     +  .593303D+01, .490167D+01, .406467D+01, .337385D+01,
     +  .280806D+01, .233657D+01, .194622D+01, .162080D+01 /
        DATA (UPDI(I),I=9881,9932) /
     +  .134893D+01, .112148D+01, .930966D+00, .771369D+00,
     +  .637662D+00, .525754D+00, .432178D+00, .354070D+00,
     +  .288989D+00, .234913D+00, .190021D+00, .153079D+00,
     +  .122451D+00, .973409D-01, .768411D-01, .601959D-01,
     +  .467547D-01, .359732D-01, .273857D-01, .206062D-01,
     +  .153043D-01, .111888D-01, .806536D-02, .569206D-02,
     +  .393071D-02, .264748D-02, .173167D-02, .109455D-02,
     +  .663596D-03, .383463D-03, .207726D-03, .104446D-03,
     +  .474836D-04, .188798D-04, .620441D-05, .153617D-05,
     +  .242421D-06, .165299D-07, .000000D+00, .222031D+07,
     +  .165980D+07, .121691D+07, .891651D+06, .652950D+06,
     +  .477815D+06, .349449D+06, .255387D+06, .186533D+06,
     +  .136145D+06, .993109D+05, .723921D+05, .527405D+05 /
        DATA (UPDI(I),I=9933,9984) /
     +  .383987D+05, .279432D+05, .203230D+05, .147753D+05,
     +  .107374D+05, .780146D+04, .566712D+04, .411712D+04,
     +  .299145D+04, .217469D+04, .158195D+04, .115208D+04,
     +  .840134D+03, .614060D+03, .447910D+03, .329242D+03,
     +  .242918D+03, .180054D+03, .134159D+03, .100569D+03,
     +  .759617D+02, .577683D+02, .442863D+02, .342404D+02,
     +  .266996D+02, .209989D+02, .166491D+02, .133070D+02,
     +  .107096D+02, .867400D+01, .706373D+01, .577936D+01,
     +  .474618D+01, .391253D+01, .322846D+01, .267148D+01,
     +  .221007D+01, .183033D+01, .151564D+01, .125430D+01,
     +  .103696D+01, .856008D+00, .705323D+00, .579836D+00,
     +  .475435D+00, .388656D+00, .316652D+00, .257016D+00,
     +  .207758D+00, .167110D+00, .133860D+00, .106462D+00 /
        DATA (UPDI(I),I=9985,10036) /
     +  .841369D-01, .660244D-01, .514101D-01, .396847D-01,
     +  .303409D-01, .229484D-01, .171524D-01, .126518D-01,
     +  .918341D-02, .657101D-02, .460156D-02, .315194D-02,
     +  .210488D-02, .136440D-02, .854175D-03, .512580D-03,
     +  .292967D-03, .156825D-03, .778428D-04, .348960D-04,
     +  .136648D-04, .441845D-05, .107651D-05, .168099D-06,
     +  .117332D-07, .000000D+00, .272162D+07, .202833D+07,
     +  .148166D+07, .108160D+07, .789060D+06, .575204D+06,
     +  .419031D+06, .305024D+06, .221887D+06, .161284D+06,
     +  .117155D+06, .850344D+05, .616809D+05, .447083D+05,
     +  .323870D+05, .234458D+05, .169648D+05, .122688D+05,
     +  .886991D+04, .641056D+04, .463299D+04, .334835D+04,
     +  .242085D+04, .175117D+04, .126801D+04, .919227D+03 /
        DATA (UPDI(I),I=10037,10088) /
     +  .667834D+03, .484107D+03, .353628D+03, .259257D+03,
     +  .190928D+03, .141339D+03, .105258D+03, .789843D+02,
     +  .596741D+02, .454502D+02, .349138D+02, .270514D+02,
     +  .211417D+02, .166583D+02, .132326D+02, .105852D+02,
     +  .852177D+01, .689849D+01, .561086D+01, .458079D+01,
     +  .375430D+01, .307994D+01, .253399D+01, .208434D+01,
     +  .171642D+01, .141332D+01, .116307D+01, .956182D+00,
     +  .784943D+00, .643190D+00, .525839D+00, .428782D+00,
     +  .348584D+00, .282434D+00, .227971D+00, .183252D+00,
     +  .146568D+00, .116740D+00, .923110D-01, .725269D-01,
     +  .565758D-01, .437863D-01, .335909D-01, .255192D-01,
     +  .191762D-01, .142371D-01, .104291D-01, .751574D-02,
     +  .533796D-02, .370906D-02, .251997D-02, .166849D-02 /
        DATA (UPDI(I),I=10089,10140) /
     +  .107178D-02, .664565D-03, .394722D-03, .223143D-03,
     +  .118035D-03, .578406D-04, .255701D-04, .986277D-05,
     +  .313863D-05, .752737D-06, .116342D-06, .830853D-08,
     +  .000000D+00, .330236D+07, .245367D+07, .178583D+07,
     +  .129884D+07, .943989D+06, .685527D+06, .497471D+06,
     +  .360702D+06, .261341D+06, .189191D+06, .136858D+06,
     +  .989183D+05, .714443D+05, .515592D+05, .371836D+05,
     +  .267961D+05, .192991D+05, .138909D+05, .999410D+04,
     +  .718738D+04, .516816D+04, .371582D+04, .267233D+04,
     +  .192263D+04, .138446D+04, .997954D+03, .720842D+03,
     +  .519413D+03, .377147D+03, .274820D+03, .201143D+03,
     +  .147977D+03, .109513D+03, .816650D+02, .613138D+02,
     +  .464091D+02, .354305D+02, .272842D+02, .211947D+02 /
        DATA (UPDI(I),I=10141,10192) /
     +  .166001D+02, .131082D+02, .104241D+02, .834299D+01,
     +  .671456D+01, .542970D+01, .440738D+01, .359157D+01,
     +  .292958D+01, .239664D+01, .196020D+01, .160512D+01,
     +  .131428D+01, .107555D+01, .879328D+00, .717862D+00,
     +  .584978D+00, .475613D+00, .385691D+00, .311824D+00,
     +  .251253D+00, .201678D+00, .161212D+00, .128212D+00,
     +  .101541D+00, .798282D-01, .623519D-01, .483490D-01,
     +  .371921D-01, .283552D-01, .214049D-01, .159796D-01,
     +  .117843D-01, .857269D-02, .613342D-02, .432385D-02,
     +  .298101D-02, .200882D-02, .131867D-02, .839420D-03,
     +  .515498D-03, .303051D-03, .169449D-03, .885744D-04,
     +  .428514D-04, .186829D-04, .709932D-05, .222405D-05,
     +  .525226D-06, .803740D-07, .586984D-08, .000000D+00 /
C-----------------------------------------------------------------------
C
      Dr = DrI
      Fl = FlI
      Al = AlI
      DO I=1,6
         Amass(I) = AmassI(I)
      ENDDO
      Iorder = Nint(Dr)
      Nfl = Nint(Fl)
      Alambda = Al
C
      NX = NxI
      NT = NTI
      NfMx = NfMxI
C
      QINI = QINII
      QMAX = QMAXI
      DO I=0,NT
         QL(I) = QLI(I)
      ENDDO
C
      XMIN = XMINI
      DO I=0,NX
         XV(I) = XVI(I)
      ENDDO
C
      Do 11 Iq = 0, NT
         QL(Iq) = Log (QL(Iq) /Al)
   11 Continue
C
C                  Since quark = anti-quark for nfl>2 at this stage, 
C                  we Read  out only the non-redundent data points
C     No of flavors = NfMx (sea) + 1 (gluon) + 2 (valence) 

      Nblk = (NX+1) * (NT+1)
      Npts =  Nblk  * (NfMx+3)
      DO I=1,Npts
         UPD(I) = UPDI(I)
      ENDDO
C
      Return
C                        ****************************
      End
