/*******************************************************************************
*                                                                              *
*   (C) 1997-2017 by Ernst W. Mayer.                                           *
*                                                                              *
*  This program is free software; you can redistribute it and/or modify it     *
*  under the terms of the GNU General Public License as published by the       *
*  Free Software Foundation; either version 2 of the License, or (at your      *
*  option) any later version.                                                  *
*                                                                              *
*  This program is distributed in the hope that it will be useful, but WITHOUT *
*  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or       *
*  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for   *
*  more details.                                                               *
*                                                                              *
*  You should have received a copy of the GNU General Public License along     *
*  with this program; see the file GPL.txt.  If not, you may view one at       *
*  http://www.fsf.org/licenses/licenses.html, or obtain one by writing to the  *
*  Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA     *
*  02111-1307, USA.                                                            *
*                                                                              *
*******************************************************************************/

/****************************************************************************
 * We now include this header file if it was not included before.
 ****************************************************************************/
#ifndef radix960_avx_negadwt_consts_included
#define radix960_avx_negadwt_consts_included

	#include "types.h"

	const uint64 radix960_avx_negadwt_consts[960] = {	// 8 entries per line ==> RADIX/8 lines:
		0x3FF0000000000000ull,0x3FEFFFFD315147B3ull,0x3FEFFFF4C5459CE7ull,0x3FEFFFE6BBDE79E7ull,0x3FEFFFD3151E5533ull,0x3FEFFFB9D108A17Cull,0x3FEFFF9AEFA1CDA6ull,0x3FEFFF7670EF44C5ull,
		0x3FEFFF4C54F76E1Cull,0x3FEFFF1C9BC1AD1Full,0x3FEFFEE74556616Full,0x3FEFFEAC51BEE6D7ull,0x3FEFFE6BC105954Eull,0x3FEFFE259335C0F5ull,0x3FEFFDD9C85BBA11ull,0x3FEFFD886084CD0Dull,
		0x3FEFFD315BBF4275ull,0x3FEFFCD4BA1A5EF7ull,0x3FEFFC727BA6635Aull,0x3FEFFC0AA0748C84ull,0x3FEFFB9D2897136Eull,0x3FEFFB2A14212D26ull,0x3FEFFAB163270ACCull,0x3FEFFA3315BDD98Aull,
		0x3FEFF9AF2BFBC297ull,0x3FEFF925A5F7EB2Dull,0x3FEFF89683CA7487ull,0x3FEFF801C58C7BDEull,0x3FEFF7676B581A63ull,0x3FEFF6C77548653Cull,0x3FEFF621E3796D7Eull,0x3FEFF576B6084027ull,
		0x3FEFF4C5ED12E61Dull,0x3FEFF40F88B86424ull,0x3FEFF3538918BADBull,0x3FEFF291EE54E6B5ull,0x3FEFF1CAB88EDFF7ull,0x3FEFF0FDE7E99AACull,0x3FEFF02B7C8906A4ull,0x3FEFEF5376920F6Cull,
		0x3FEFEE75D62A9C46ull,0x3FEFED929B799025ull,0x3FEFECA9C6A6C9A3ull,0x3FEFEBBB57DB22FDull,0x3FEFEAC74F40720Cull,0x3FEFE9CDAD01883Aull,0x3FEFE8CE714A327Eull,0x3FEFE7C99C473952ull,
		0x3FEFE6BF2E2660AFull,0x3FEFE5AF271667FFull,0x3FEFE49987470A1Aull,0x3FEFE37E4EE8FD3Bull,0x3FEFE25D7E2DF2F8ull,0x3FEFE1371548983Aull,0x3FEFE00B146C9533ull,0x3FEFDED97BCE8D56ull,
		0x3FEFDDA24BA41F4Dull,0x3FEFDC658423E4EEull,0x3FEFDB2325857336ull,0x3FEFD9DB30015A3Cull,0x3FEFD88DA3D12526ull,0x3FEFD73A812F5A21ull,0x3FEFD5E1C8577A56ull,0x3FEFD483798601E2ull,
		0x3FEFD31F94F867C6ull,0x3FEFD1B61AED1DE2ull,0x3FEFD0470BA390E4ull,0x3FEFCED2675C2844ull,0x3FEFCD582E584632ull,0x3FEFCBD860DA4790ull,0x3FEFCA52FF2583E1ull,0x3FEFC8C8097E4D44ull,
		0x3FEFC7378029F05Full,0x3FEFC5A1636EB45Cull,0x3FEFC405B393DAD7ull,0x3FEFC26470E19FD3ull,0x3FEFC0BD9BA139AEull,0x3FEFBF11341CD911ull,0x3FEFBD5F3A9FA8EAull,0x3FEFBBA7AF75CE56ull,
		0x3FEFB9EA92EC689Bull,0x3FEFB827E5519116ull,0x3FEFB65FA6F45B2Eull,0x3FEFB491D824D448ull,0x3FEFB2BE793403B9ull,0x3FEFB0E58A73EAB4ull,0x3FEFAF070C37843Full,0x3FEFAD22FED2C524ull,
		0x3FEFAB39629A9BE3ull,0x3FEFA94A37E4F0A0ull,0x3FEFA7557F08A517ull,0x3FEFA55B385D948Bull,0x3FEFA35B643C93B9ull,0x3FEFA15602FF70C4ull,0x3FEF9F4B1500F32Bull,0x3FEF9D3A9A9CDBB3ull,
		0x3FEF9B24942FE45Cull,0x3FEF99090217C04Dull,0x3FEF96E7E4B31BC7ull,0x3FEF94C13C619C12ull,0x3FEF92950983DF6Bull,0x3FEF90634C7B7CF8ull,0x3FEF8E2C05AB04B1ull,0x3FEF8BEF3575FF52ull,
		0x3FEF89ACDC40EE4Bull,0x3FEF8764FA714BA9ull,0x3FEF8517906D8A0Bull,0x3FEF82C49E9D1489ull,0x3FEF806C25684EA8ull,0x3FEF7E0E25389445ull,0x3FEF7BAA9E783981ull,0x3FEF794191928AB1ull,
		0x3FEF76D2FEF3CC4Bull,0x3FEF745EE7093ACFull,0x3FEF71E54A410ABBull,0x3FEF6F66290A6870ull,0x3FEF6CE183D57825ull,0x3FEF6A575B1355CEull,0x3FEF67C7AF36150Dull,0x3FEF653280B0C11Aull,
		0x3FEF6297CFF75CB0ull,0x3FEF5FF79D7EE1FBull,0x3FEF5D51E9BD427Full,0x3FEF5AA6B5296708ull,0x3FEF57F6003B2F91ull,0x3FEF553FCB6B7333ull,0x3FEF52841734000Cull,0x3FEF4FC2E40F9B2Cull,
		0x3FEF4CFC327A0080ull,0x3FEF4A3002EFE2B8ull,0x3FEF475E55EEEB37ull,0x3FEF44872BF5B9F9ull,0x3FEF41AA8583E57Eull,0x3FEF3EC86319FAB5ull,0x3FEF3BE0C5397CE1ull,0x3FEF38F3AC64E589ull,
		0x3FEF3601191FA459ull,0x3FEF33090BEE1F14ull,0x3FEF300B8555B174ull,0x3FEF2D0885DCAD1Aull,0x3FEF2A000E0A5970ull,0x3FEF26F21E66F398ull,0x3FEF23DEB77BAE4Cull,0x3FEF20C5D9D2B1D0ull,
		0x3FEF1DA785F71BCEull,0x3FEF1A83BC74FF49ull,0x3FEF175A7DD9647Dull,0x3FEF142BCAB248C7ull,0x3FEF10F7A38E9E90ull,0x3FEF0DBE08FE4D30ull,0x3FEF0A7EFB9230D7ull,0x3FEF073A7BDC1A73ull,
		0x3FEF03F08A6ECF94ull,0x3FEF00A127DE0A57ull,0x3FEEFD4C54BE7949ull,0x3FEEF9F211A5BF4Cull,0x3FEEF6925F2A7380ull,0x3FEEF32D3DE42126ull,0x3FEEEFC2AE6B4785ull,0x3FEEEC52B15959D3ull,
		0x3FEEE8DD4748BF15ull,0x3FEEE56270D4D207ull,0x3FEEE1E22E99E102ull,0x3FEEDE5C81352DDCull,0x3FEEDAD16944EDD0ull,0x3FEED740E7684963ull,0x3FEED3AAFC3F5C45ull,0x3FEED00FA86B3535ull,
		0x3FEECC6EEC8DD5E9ull,0x3FEEC8C8C94A32EDull,0x3FEEC51D3F443387ull,0x3FEEC16C4F20B19Full,0x3FEEBDB5F9857999ull,0x3FEEB9FA3F194A43ull,0x3FEEB6392083D4ADull,0x3FEEB2729E6DBC14ull,
		0x3FEEAEA6B98095C0ull,0x3FEEAAD57266E8E7ull,0x3FEEA6FEC9CC2E8Full,0x3FEEA322C05CD171ull,0x3FEE9F4156C62DDAull,0x3FEE9B5A8DB6918Dull,0x3FEE976E65DD3BA2ull,0x3FEE937CDFEA5C6Bull,
		0x3FEE8F85FC8F1553ull,0x3FEE8B89BC7D78BFull,0x3FEE8788206889F0ull,0x3FEE838129043CE2ull,0x3FEE7F74D705762Bull,0x3FEE7B632B220AE1ull,0x3FEE774C2610C074ull,0x3FEE732FC8894C90ull,
		0x3FEE6F0E134454FFull,0x3FEE6AE706FB6F86ull,0x3FEE66BAA46921C3ull,0x3FEE6288EC48E112ull,0x3FEE5E51DF571265ull,0x3FEE5A157E510A2Aull,0x3FEE55D3C9F50C23ull,0x3FEE518CC3024B49ull,
		0x3FEE4D406A38E9ABull,0x3FEE48EEC059F847ull,0x3FEE4497C62776F0ull,0x3FEE403B7C645424ull,0x3FEE3BD9E3D46CEFull,0x3FEE3772FD3C8CC7ull,0x3FEE3306C9626D6Bull,0x3FEE2E95490CB6BCull,
		0x3FEE2A1E7D02FE9Full,0x3FEE25A2660DC8D7ull,0x3FEE212104F686E5ull,0x3FEE1C9A5A8797DFull,0x3FEE180E678C4853ull,0x3FEE137D2CD0D21Full,0x3FEE0EE6AB225C4Dull,0x3FEE0A4AE34EFAF5ull,
		0x3FEE05A9D625AF0Full,0x3FEE010384766657ull,0x3FEDFC57EF11FB25ull,0x3FEDF7A716CA3449ull,0x3FEDF2F0FC71C4E5ull,0x3FEDEE35A0DC4C4Bull,0x3FEDE97504DE55D5ull,0x3FEDE4AF294D58BFull,
		0x3FEDDFE40EFFB805ull,0x3FEDDB13B6CCC23Cull,0x3FEDD63E218CB16Cull,0x3FEDD1635018AAE7ull,0x3FEDCC83434ABF29ull,0x3FEDC79DFBFDE9ADull,0x3FEDC2B37B0E10C8ull,0x3FEDBDC3C1580584ull,
		0x3FEDB8CECFB98376ull,0x3FEDB3D4A7113099ull,0x3FEDAED5483E9D28ull,0x3FEDA9D0B4224375ull,0x3FEDA4C6EB9D87C2ull,0x3FED9FB7EF92B819ull,0x3FED9AA3C0E50C26ull,0x3FED958A6078A50Eull,
		0x3FED906BCF328D46ull,0x3FED8B480DF8B86Eull,0x3FED861F1DB20323ull,0x3FED80F0FF4632DDull,0x3FED7BBDB39DF5C3ull,0x3FED76853BA2E282ull,0x3FED7147983F7823ull,0x3FED6C04CA5F1DE5ull,
		0x3FED66BCD2EE2313ull,0x3FED616FB2D9BED7ull,0x3FED5C1D6B101015ull,0x3FED56C5FC801D3Full,0x3FED51696819D42Bull,0x3FED4C07AECE09E7ull,0x3FED46A0D18E7A95ull,0x3FED4134D14DC93Aull,
		0x3FED3BC3AEFF7F95ull,0x3FED364D6B980DF8ull,0x3FED30D2080CCB19ull,0x3FED2B518553F3E6ull,0x3FED25CBE464AB60ull,0x3FED20412636FA69ull,0x3FED1AB14BC3CF9Dull,0x3FED151C5604FF21ull,
		0x3FED0F8245F5427Full,0x3FED09E31C903874ull,0x3FED043EDAD264C4ull,0x3FECFE9581B93011ull,0x3FECF8E71242E7ABull,0x3FECF3338D6EBD69ull,0x3FECED7AF43CC773ull,0x3FECE7BD47AE001Eull,
		0x3FECE1FA88C445BBull,0x3FECDC32B8825A68ull,0x3FECD665D7EBE3E8ull,0x3FECD093E8056B6Eull,0x3FECCABCE9D45D78ull,0x3FECC4E0DE5F0998ull,0x3FECBEFFC6ACA24Eull,0x3FECB919A3C53CD4ull,
		0x3FECB32E76B1D0F4ull,0x3FECAD3E407C38D7ull,0x3FECA749022F30D4ull,0x3FECA14EBCD65749ull,0x3FEC9B4F717E2C63ull,0x3FEC954B213411F5ull,0x3FEC8F41CD064B46ull,0x3FEC89337603FCE2ull,
		0x3FEC83201D3D2C6Dull,0x3FEC7D07C3C2C06Dull,0x3FEC76EA6AA68022ull,0x3FEC70C812FB134Full,0x3FEC6AA0BDD40210ull,0x3FEC64746C45B4A3ull,0x3FEC5E431F65733Full,0x3FEC580CD84965DBull,
		0x3FEC51D198089406ull,0x3FEC4B915FBAE4AEull,0x3FEC454C30791DF4ull,0x3FEC3F020B5CE4FBull,0x3FEC38B2F180BDB1ull,0x3FEC325EE4000AA4ull,0x3FEC2C05E3F70CCEull,0x3FEC25A7F282E360ull,
		0x3FEC1F4510C18B95ull,0x3FEC18DD3FD1E07Dull,0x3FEC127080D39ACAull,0x3FEC0BFED4E7509Full,0x3FEC05883D2E7560ull,0x3FEBFF0CBACB5977ull,0x3FEBF88C4EE12A29ull,0x3FEBF206FA93F162ull,
		0x3FEBEB7CBF08957Dull,0x3FEBE4ED9D64D915ull,0x3FEBDE5996CF5AD0ull,0x3FEBD7C0AC6F952Aull,0x3FEBD122DF6DDE43ull,0x3FEBCA8030F367ADull,0x3FEBC3D8A22A3E32ull,0x3FEBBD2C343D49A5ull,
		0x3FEBB67AE8584CAAull,0x3FEBAFC4BFA7E485ull,0x3FEBA909BB5988E2ull,0x3FEBA249DC9B8BA1ull,0x3FEB9B85249D18A2ull,0x3FEB94BB948E358Full,0x3FEB8DED2D9FC1A7ull,0x3FEB8719F1037589ull,
		0x3FEB8041DFEBE2FBull,0x3FEB7964FB8C74B9ull,0x3FEB728345196E3Eull,0x3FEB6B9CBDC7EB89ull,0x3FEB64B166CDE0EEull,0x3FEB5DC141621ADCull,0x3FEB56CC4EBC3DA4ull,0x3FEB4FD29014C549ull,
		0x3FEB48D406A50540ull,0x3FEB41D0B3A72844ull,0x3FEB3AC898563014ull,0x3FEB33BBB5EDF544ull,0x3FEB2CAA0DAB2702ull,0x3FEB2593A0CB4ADDull,0x3FEB1E78708CBC90ull,0x3FEB17587E2EADCBull,
		0x3FEB1033CAF125F6ull,0x3FEB090A58150200ull,0x3FEB01DC26DBF41Eull,0x3FEAFAA93888839Cull,0x3FEAF3718E5E0C9Cull,0x3FEAEC3529A0BFE4ull,0x3FEAE4F40B95A2A0ull,0x3FEADDAE35828E2Dull,
		0x3FEAD663A8AE2FDCull,0x3FEACF14666008BBull,0x3FEAC7C06FE06D5Cull,0x3FEAC067C678859Bull,0x3FEAB90A6B724C62ull,0x3FEAB1A860188F72ull,0x3FEAAA41A5B6EF27ull,0x3FEAA2D63D99DE40ull,
		0x3FEA9B66290EA1A3ull,0x3FEA93F169635022ull,0x3FEA8C77FFE6D241ull,0x3FEA84F9EDE8E1FDull,0x3FEA7D7734BA0A8Eull,0x3FEA75EFD5ABA82Full,0x3FEA6E63D20FE7E1ull,0x3FEA66D32B39C72Eull,
		0x3FEA5F3DE27D13F2ull,0x3FEA57A3F92E6C1Bull,0x3FEA500570A33D71ull,0x3FEA48624A31C557ull,0x3FEA40BA87311090ull,0x3FEA390E28F8FB04ull,0x3FEA315D30E22F81ull,0x3FEA29A7A0462782ull,
		0x3FEA21ED787F2AEFull,0x3FEA1A2EBAE84FE3ull,0x3FEA126B68DD7A6Dull,0x3FEA0AA383BB5C54ull,0x3FEA02D70CDF74DBull,0x3FE9FB0605A81080ull,0x3FE9F3306F7448C2ull,0x3FE9EB564BA403E2ull,
		0x3FE9E3779B97F4A8ull,0x3FE9DB9460B19A1Eull,0x3FE9D3AC9C533F5Bull,0x3FE9CBC04FDFFB3Dull,0x3FE9C3CF7CBBB030ull,0x3FE9BBDA244B0BEFull,0x3FE9B3E047F38741ull,0x3FE9ABE1E91B65BFull,
		0x3FE9A3DF0929B594ull,0x3FE99BD7A9864F3Dull,0x3FE993CBCB99D54Aull,0x3FE98BBB70CDB420ull,0x3FE983A69A8C21B8ull,0x3FE97B8D4A401D61ull,0x3FE9736F81556F7Eull,0x3FE96B4D4138A94Aull,
		0x3FE963268B572492ull,0x3FE95AFB611F037Cull,0x3FE952CBC3FF3043ull,0x3FE94A97B5675CF5ull,0x3FE9425F36C80335ull,0x3FE93A22499263FBull,0x3FE931E0EF388752ull,0x3FE9299B292D3C14ull,
		0x3FE92150F8E417B1ull,0x3FE919025FD175E4ull,0x3FE910AF5F6A787Aull,0x3FE90857F925070Bull,0x3FE8FFFC2E77CEBAull,0x3FE8F79C00DA41F7ull,0x3FE8EF3771C49835ull,0x3FE8E6CE82AFCDB0ull,
		0x3FE8DE613515A328ull,0x3FE8D5EF8A709D9Bull,0x3FE8CD79843C060Aull,0x3FE8C4FF23F3E930ull,0x3FE8BC806B151741ull,0x3FE8B3FD5B1D23AAull,0x3FE8AB75F58A64CAull,0x3FE8A2EA3BDBF3B3ull,
		0x3FE89A5A2F91ABE4ull,0x3FE891C5D22C2B03ull,0x3FE8892D252CD0A2ull,0x3FE880902A15BDF2ull,0x3FE877EEE269D586ull,0x3FE86F494FACBB0Cull,0x3FE8669F7362D307ull,0x3FE85DF14F114292ull,
		0x3FE8553EE43DEF13ull,0x3FE84C88346F7DFDull,0x3FE843CD412D5488ull,0x3FE83B0E0BFF976Eull,0x3FE8324A966F2AA5ull,0x3FE82982E205B11Dull,0x3FE820B6F04D8C75ull,0x3FE817E6C2D1DCBCull,
		0x3FE80F125B1E8028ull,0x3FE80639BAC012D3ull,0x3FE7FD5CE343EE74ull,0x3FE7F47BD6382A17ull,0x3FE7EB96952B99DCull,0x3FE7E2AD21ADCEADull,0x3FE7D9BF7D4F15FBull,0x3FE7D0CDA9A07974ull,
		0x3FE7C7D7A833BEC2ull,0x3FE7BEDD7A9B673Eull,0x3FE7B5DF226AAFAFull,0x3FE7ACDCA1358FFFull,0x3FE7A3D5F890BAF9ull,0x3FE79ACB2A119DFCull,0x3FE791BC374E60B8ull,0x3FE788A921DDE4E7ull,
		0x3FE77F91EB57C602ull,0x3FE77676955458FDull,0x3FE76D57216CABFFull,0x3FE76433913A8618ull,0x3FE75B0BE65866FBull,0x3FE751E0226186B4ull,0x3FE748B046F1D563ull,0x3FE73F7C55A5FAF3ull,
		0x3FE73644501B56CDull,0x3FE72D0837EFFF96ull,0x3FE723C80EC2C2E3ull,0x3FE71A83D63324EFull,0x3FE7113B8FE16056ull,0x3FE707EF3D6E65C7ull,0x3FE6FE9EE07BDBC1ull,0x3FE6F54A7AAC1E42ull,
		0x3FE6EBF20DA23E86ull,0x3FE6E2959B0202B6ull,0x3FE6D935246FE5A4ull,0x3FE6CFD0AB91167Eull,0x3FE6C668320B7884ull,0x3FE6BCFBB985A2C0ull,0x3FE6B38B43A6DFBBull,0x3FE6AA16D2172D32ull,
		0x3FE6A09E667F3BCDull,0x3FE6972202886ED1ull,0x3FE68DA1A7DCDBDCull,0x3FE6841D58274A93ull,0x3FE67A951513345Cull,0x3FE67108E04CC411ull,0x3FE66778BB80D5B4ull,0x3FE65DE4A85CF626ull,
		0x3FE6544CA88F62DBull,0x3FE64AB0BDC7098Full,0x3FE64110E9B387F6ull,0x3FE6376D2E052B77ull,0x3FE62DC58C6CF0DBull,0x3FE6241A069C8405ull,0x3FE61A6A9E463FA2ull,0x3FE610B7551D2CDFull,
		0x3FE607002CD5031Dull,0x3FE5FD45272227A3ull,0x3FE5F38645B9AD52ull,0x3FE5E9C38A51545Bull,0x3FE5DFFCF69F89EDull,0x3FE5D6328C5B67ECull,0x3FE5CC644D3CB4A3ull,0x3FE5C2923AFBE277ull,
		0x3FE5B8BC57520F97ull,0x3FE5AEE2A3F905B3ull,0x3FE5A50522AB39AEull,0x3FE59B23D523CB4Cull,0x3FE5913EBD1E84E7ull,0x3FE58755DC57DB24ull,0x3FE57D69348CECA0ull,0x3FE57378C77B81A4ull,
		0x3FE5698496E20BD8ull,0x3FE55F8CA47FA5F3ull,0x3FE55590F214136Eull,0x3FE54B91815FC032ull,0x3FE5418E5423C050ull,0x3FE537876C21CFAAull,0x3FE52D7CCB1C51ABull,0x3FE5236E72D650F3ull,
		0x3FE5195C65137F0Cull,0x3FE50F46A3983418ull,0x3FE5052D30296E82ull,0x3FE4FB100C8CD2AEull,0x3FE4F0EF3A88AAADull,0x3FE4E6CABBE3E5E9ull,0x3FE4DCA2926618D6ull,0x3FE4D276BFD77CA4ull,
		0x3FE4C8474600EEEEull,0x3FE4BE1426ABF168ull,0x3FE4B3DD63A2A993ull,0x3FE4A9A2FEAFE067ull,0x3FE49F64F99F0207ull,0x3FE49523563C1D70ull,0x3FE48ADE1653E425ull,0x3FE480953BB3A9E1ull,
		0x3FE47648C8296447ull,0x3FE46BF8BD83AA8Cull,0x3FE461A51D91B52Cull,0x3FE4574DEA235D95ull,0x3FE44CF325091DD6ull,0x3FE44294D014104Full,0x3FE43832ED15EF5Dull,0x3FE42DCD7DE1150Bull,
		0x3FE4236484487ABEull,0x3FE418F8021FB8E3ull,0x3FE40E87F93B06A2ull,0x3FE404146B6F3981ull,0x3FE3F99D5A91C51Full,0x3FE3EF22C878BAD7ull,0x3FE3E4A4B6FAC973ull,0x3FE3DA2327EF3CD8ull,
		0x3FE3CF9E1D2DFDB2ull,0x3FE3C515988F9125ull,0x3FE3BA899BED1876ull,0x3FE3AFFA292050B9ull,0x3FE3A56742039280ull,0x3FE39AD0E871D186ull,0x3FE390371E469C5Aull,0x3FE38599E55E1C10ull,
		0x3FE37AF93F9513EAull,0x3FE370552EC8E104ull,0x3FE365ADB4D77A03ull,0x3FE35B02D39F6EC0ull,0x3FE350548CFFE7F2ull,0x3FE345A2E2D8A6DDull,0x3FE33AEDD70A04FBull,0x3FE330356B74F3ABull,
		0x3FE32579A1FAFBDAull,0x3FE31ABA7C7E3DAEull,0x3FE30FF7FCE17035ull,0x3FE305322507E10Cull,0x3FE2FA68F6D5740Cull,0x3FE2EF9C742EA2F8ull,0x3FE2E4CC9EF87D23ull,0x3FE2D9F97918A71Dull,
		0x3FE2CF2304755A5Eull,0x3FE2C44942F564F2ull,0x3FE2B96C36802922ull,0x3FE2AE8BE0FD9D1Dull,0x3FE2A3A844564AA5ull,0x3FE298C162734EB9ull,0x3FE28DD73D3E593Full,0x3FE282E9D6A1ACABull,
		0x3FE277F930881DAFull,0x3FE26D054CDD12DFull,0x3FE2620E2D8C845Dull,0x3FE25713D482FB86ull,0x3FE24C1643AD9295ull,0x3FE241157CF9F453ull,0x3FE2361182565BBAull,0x3FE22B0A55B193A5ull,
		0x3FE21FFFF8FAF674ull,0x3FE214F26E226DB7ull,0x3FE209E1B71871D9ull,0x3FE1FECDD5CE09C3ull,0x3FE1F3B6CC34CA8Bull,0x3FE1E89C9C3ED71Bull,0x3FE1DD7F47DEDFD8ull,0x3FE1D25ED108224Aull,
		0x3FE1C73B39AE68C8ull,0x3FE1BC1483C60A1Eull,0x3FE1B0EAB143E933ull,0x3FE1A5BDC41D74B5ull,0x3FE19A8DBE48A6C1ull,0x3FE18F5AA1BC0486ull,0x3FE18424706E9DF3ull,0x3FE178EB2C580D5Bull,
		0x3FE16DAED770771Dull,0x3FE1626F73B0894Dull,0x3FE1572D03117B5Aull,0x3FE14BE7878D0DB6ull,0x3FE1409F031D897Eull,0x3FE1355377BDC01Eull,0x3FE12A04E7690AFEull,0x3FE11EB3541B4B23ull,
		0x3FE1135EBFD0E8D7ull,0x3FE108072C86D355ull,0x3FE0FCAC9C3A8069ull,0x3FE0F14F10E9EC1Aull,0x3FE0E5EE8C939850ull,0x3FE0DA8B11368C7Aull,0x3FE0CF24A0D25535ull,0x3FE0C3BB3D6703F2ull,
		0x3FE0B84EE8F52E9Dull,0x3FE0ACDFA57DEF3Full,0x3FE0A16D7502E3ABull,0x3FE095F859862D1Dull,0x3FE08A80550A6FE5ull,0x3FE07F056992D30Aull,0x3FE073879922FFEEull,0x3FE06806E5BF21F7ull,
		0x3FE05C83516BE635ull,0x3FE050FCDE2E7B03ull,0x3FE045738E0C8FAFull,0x3FE039E7630C541Full,0x3FE02E585F347876ull,0x3FE022C6848C2CBAull,0x3FE01731D51B2075ull,0x3FE00B9A52E9825Full,
		0x3FE0000000000000ull,0x3FDFE8C5BCCF8AA8ull,0x3FDFD185E054F8E4ull,0x3FDFBA406EA49A5Aull,0x3FDFA2F56BD3B979ull,0x3FDF8BA4DBF89ABAull,0x3FDF744EC32A7BEEull,0x3FDF5CF325819383ull,
		0x3FDF459207170FCEull,0x3FDF2E2B6C051650ull,0x3FDF16BF5866C302ull,0x3FDEFF4DD058279Aull,0x3FDEE7D6D7F64AD2ull,0x3FDED05A735F27AFull,0x3FDEB8D8A6B1ACCCull,0x3FDEA151760DBB9Bull,
		0x3FDE89C4E59427B1ull,0x3FDE7232F966B609ull,0x3FDE5A9BB5A81C4Bull,0x3FDE42FF1E7C0014ull,0x3FDE2B5D3806F63Bull,0x3FDE13B6066E8217ull,0x3FDDFC098DD914C4ull,0x3FDDE457D26E0C6Aull,
		0x3FDDCCA0D855B380ull,0x3FDDB4E4A3B94015ull,0x3FDD9D2338C2D311ull,0x3FDD855C9B9D777Full,0x3FDD6D90D07521CBull,0x3FDD55BFDB76AF0Cull,0x3FDD3DE9C0CFE448ull,0x3FDD260E84AF6DB5ull,
		0x3FDD0E2E2B44DE01ull,0x3FDCF648B8C0AD92ull,0x3FDCDE5E315439CFull,0x3FDCC66E9931C45Eull,0x3FDCAE79F48C726Cull,0x3FDC968047984BEDull,0x3FDC7E81968A3AE3ull,0x3FDC667DE5980A9Dull,
		0x3FDC4E7538F866FCull,0x3FDC366794E2DBB5ull,0x3FDC1E54FD8FD396ull,0x3FDC063D773897C4ull,0x3FDBEE2106174F02ull,0x3FDBD5FFAE66FCEFull,0x3FDBBDD97463814Aull,0x3FDBA5AE5C499736ull,
		0x3FDB8D7E6A56D476ull,0x3FDB7549A2C9A8B4ull,0x3FDB5D1009E15CC0ull,0x3FDB44D1A3DE11D1ull,0x3FDB2C8E7500C0C6ull,0x3FDB1446818B3969ull,0x3FDAFBF9CDC021ACull,0x3FDAE3A85DE2F4EFull,
		0x3FDACB523638033Bull,0x3FDAB2F75B047085ull,0x3FDA9A97D08E33EFull,0x3FDA82339B1C1705ull,0x3FDA69CABEF5B501ull,0x3FDA515D40637A08ull,0x3FDA38EB23AEA269ull,0x3FDA20746D2139E0ull,
		0x3FDA07F921061AD1ull,0x3FD9EF7943A8ED8Aull,0x3FD9D6F4D9562782ull,0x3FD9BE6BE65B0A96ull,0x3FD9A5DE6F05A44Bull,0x3FD98D4C77A4CD08ull,0x3FD974B604882759ull,0x3FD95C1B1A001F2Bull,
		0x3FD9437BBC5DE90Aull,0x3FD92AD7EFF38162ull,0x3FD9122FB913ABB9ull,0x3FD8F9831C11F1EDull,0x3FD8E0D21D42A377ull,0x3FD8C81CC0FAD4A3ull,0x3FD8AF630B905DCEull,0x3FD896A50159DAA5ull,
		0x3FD87DE2A6AEA963ull,0x3FD8651BFFE6EA0Bull,0x3FD84C51115B7DA7ull,0x3FD83381DF660585ull,0x3FD81AAE6E60E271ull,0x3FD801D6C2A733F5ull,0x3FD7E8FAE094D791ull,0x3FD7D01ACC8667FEull,
		0x3FD7B7368AD93C61ull,0x3FD79E4E1FEB6790ull,0x3FD78561901BB747ull,0x3FD76C70DFC9B368ull,0x3FD7537C13559D33ull,0x3FD73A832F206E86ull,0x3FD72186378BD913ull,0x3FD7088530FA459Full,
		0x3FD6EF801FCED33Cull,0x3FD6D677086D5685ull,0x3FD6BD69EF3A58D5ull,0x3FD6A458D89B1786ull,0x3FD68B43C8F5832Aull,0x3FD6722AC4B03EC6ull,0x3FD6590DD0329F09ull,0x3FD63FECEFE4A98Dull,
		0x3FD626C8282F1408ull,0x3FD60D9F7D7B4390ull,0x3FD5F472F4334BCBull,0x3FD5DB4290C1EE32ull,0x3FD5C20E57929942ull,0x3FD5A8D64D1167BDull,0x3FD58F9A75AB1FDDull,0x3FD5765AD5CD3292ull,
		0x3FD55D1771E5BAB9ull,0x3FD543D04E637C56ull,0x3FD52A856FB5E3C9ull,0x3FD51136DA4D050Eull,0x3FD4F7E492999AEEull,0x3FD4DE8E9D0D0640ull,0x3FD4C534FE194D17ull,0x3FD4ABD7BA311A04ull,
		0x3FD49276D5C7BB48ull,0x3FD479125551220Full,0x3FD45FAA3D41E1A8ull,0x3FD4463E920F2EBBull,0x3FD42CCF582EDE82ull,0x3FD4135C94176601ull,0x3FD3F9E64A3FD93Dull,0x3FD3E06C7F1FEA73ull,
		0x3FD3C6EF372FE950ull,0x3FD3AD6E76E8C228ull,0x3FD393EA42C3FD2Eull,0x3FD37A629F3BBDAAull,0x3FD360D790CAC12Eull,0x3FD347491BEC5ED3ull,0x3FD32DB7451C8667ull,0x3FD3142210D7BFABull,
		0x3FD2FA89839B2985ull,0x3FD2E0EDA1E4793Bull,0x3FD2C74E7031F9A1ull,0x3FD2ADABF3028A5Aull,0x3FD294062ED59F06ull,0x3FD27A5D282B3E79ull,0x3FD260B0E38401F4ull,0x3FD247016561145Aull,
		0x3FD22D4EB2443163ull,0x3FD21398CEAFA4D5ull,0x3FD1F9DFBF2649B6ull,0x3FD1E023882B8984ull,0x3FD1C6642E435B69ull,0x3FD1ACA1B5F24373ull,0x3FD192DC23BD51C3ull,0x3FD179137C2A21C8ull,
		0x3FD15F47C3BED971ull,0x3FD14578FF022862ull,0x3FD12BA7327B472Bull,0x3FD111D262B1F677ull,0x3FD0F7FA942E7E48ull,0x3FD0DE1FCB79AD25ull,0x3FD0C4420D1CD752ull,0x3FD0AA615DA1D603ull,
		0x3FD0907DC1930690ull,0x3FD076973D7B49AAull,0x3FD05CADD5E6028Eull,0x3FD042C18F5F1638ull,0x3FD028D26E72EA99ull,0x3FD00EE077AE65CBull,0x3FCFE9D75F3DDA82ull,0x3FCFB5E835A4C9FBull,
		0x3FCF81F37BAE5D8Cull,0x3FCF4DF93A7852AAull,0x3FCF19F97B215F1Bull,0x3FCEE5F446C92F5Dull,0x3FCEB1E9A690650Eull,0x3FCE7DD9A398954Eull,0x3FCE49C447044728ull,0x3FCE15A999F6F1F7ull,
		0x3FCDE189A594FBCCull,0x3FCDAD647303B7D0ull,0x3FCD793A0B6964AEull,0x3FCD450A77ED2AF6ull,0x3FCD10D5C1B71B7Full,0x3FCCDC9BF1F02DD2ull,0x3FCCA85D11C23E89ull,0x3FCC74192A580DB6ull,
		0x3FCC3FD044DD3D45ull,0x3FCC0B826A7E4F63ull,0x3FCBD72FA468A4E1ull,0x3FCBA2D7FBCA7B98ull,0x3FCB6E7B79D2ECC9ull,0x3FCB3A1A27B1EB87ull,0x3FCB05B40E984314ull,0x3FCAD14937B79549ull,
		0x3FCA9CD9AC4258F6ull,0x3FCA6865756BD846ull,0x3FCA33EC9C682F23ull,0x3FC9FF6F2A6C4995ull,0x3FC9CAED28ADE228ull,0x3FC99666A063804Dull,0x3FC961DB9AC476BDull,0x3FC92D4C2108E1D8ull,
		0x3FC8F8B83C69A60Bull,0x3FC8C41FF6206E2Full,0x3FC88F835767A9EDull,0x3FC85AE2697A8C1Cull,0x3FC8263D35950926ull,0x3FC7F193C4F3D566ull,0x3FC7BCE620D4638Bull,0x3FC788345274E2FBull,
		0x3FC7537E63143E2Eull,0x3FC71EC45BF21915ull,0x3FC6EA06464ECF76ull,0x3FC6B5442B6B734Eull,0x3FC6807E1489CB33ull,0x3FC64BB40AEC50B1ull,0x3FC616E617D62EAEull,0x3FC5E214448B3FC6ull,
		0x3FC5AD3E9A500CADull,0x3FC578652269CA8Eull,0x3FC54387E61E596Bull,0x3FC50EA6EEB4427Eull,0x3FC4D9C24572B693ull,0x3FC4A4D9F3A18C6Full,0x3FC46FEE02893F2Aull,0x3FC43AFE7B72EC8Dull,
		0x3FC4060B67A85375ull,0x3FC3D114D073D230ull,0x3FC39C1ABF2064DBull,0x3FC3671D3CF9A3C1ull,0x3FC3321C534BC1BBull,0x3FC2FD180B638A89ull,0x3FC2C8106E8E613Aull,0x3FC29305861A3E80ull,
		0x3FC25DF75B55AF15ull,0x3FC228E5F78FD214ull,0x3FC1F3D16418575Bull,0x3FC1BEB9AA3F7DE8ull,0x3FC1899ED3561233ull,0x3FC15480E8AD6C90ull,0x3FC11F5FF3976F8Cull,0x3FC0EA3BFD668645ull,
		0x3FC0B5150F6DA2D1ull,0x3FC07FEB33003C90ull,0x3FC04ABE71724E93ull,0x3FC0158ED41855F2ull,0x3FBFC0B8C88EA05Aull,0x3FBF564E56A9730Eull,0x3FBEEBDE652D16C7ull,0x3FBE816906C67544ull,
		0x3FBE16EE4E236BF8ull,0x3FBDAC6E4DF2C8C2ull,0x3FBD41E918E446A6ull,0x3FBCD75EC1A88A83ull,0x3FBC6CCF5AF11FD1ull,0x3FBC023AF7707553ull,0x3FBB97A1A9D9D9D4ull,0x3FBB2D0384E178DDull,
		0x3FBAC2609B3C576Cull,0x3FBA57B8FFA050AFull,0x3FB9ED0CC4C412B8ull,0x3FB9825BFD5F1B36ull,0x3FB917A6BC29B42Cull,0x3FB8ACED13DCF0A9ull,0x3FB8422F1732A97Dull,0x3FB7D76CD8E579F2ull,
		0x3FB76CA66BB0BC83ull,0x3FB701DBE2508790ull,0x3FB6970D4F81AA16ull,0x3FB62C3AC601A866ull,0x3FB5C164588EB8DAull,0x3FB5568A19E7C08Dull,0x3FB4EBAC1CCC500Eull,0x3FB480CA73FCA019ull,
		0x3FB415E532398E49ull,0x3FB3AAFC6A4499D3ull,0x3FB340102EDFE037ull,0x3FB2D52092CE19F6ull,0x3FB26A2DA8D2974Aull,0x3FB1FF3783B13CD7ull,0x3FB1943E362E8067ull,0x3FB12941D30F6595ull,
		0x3FB0BE426D197A8Bull,0x3FB053401712D4B3ull,0x3FAFD075C7841AD6ull,0x3FAEFA65CBDC7D76ull,0x3FAE245060BE0012ull,0x3FAD4E35ABB8C59Dull,0x3FAC7815D25DDE96ull,0x3FABA1F0FA3F4275ull,
		0x3FAACBC748EFC90Eull,0x3FA9F598E40323FFull,0x3FA91F65F10DD814ull,0x3FA8492E95A536B2ull,0x3FA772F2F75F573Cull,0x3FA69CB33BD3107Cull,0x3FA5C66F8897F20Cull,0x3FA4F02803463DBCull,
		0x3FA419DCD176E0F7ull,0x3FA3438E18C36E2Full,0x3FA26D3BFEC61641ull,0x3FA196E6A919A1DEull,0x3FA0C08E3D596AEEull,0x3F9FD465C242ABF6ull,0x3F9E27A9741B972Eull,0x3F9C7AE7DB77637Full,
		0x3F9ACE214390CA91ull,0x3F992155F7A3667Eull,0x3F97748642EBA4A3ull,0x3F95C7B270A6B86Dull,0x3F941ADACC128E22ull,0x3F926DFFA06DBDB1ull,0x3F90C12138F77D7Bull,0x3F8E287FC1DF2A45ull,
		0x3F8ACEB7C72CA0A8ull,0x3F8774EB1858E329ull,0x3F841B1A4BE64A17ull,0x3F80C145F857E6A2ull,0x3F7ACEDD6862D0D7ull,0x3F741B2A2BEE064Cull,0x3F6ACEE6D0B55093ull,0x3F5ACEE92ACA3FBDull
	};

#endif	/* #ifndef radix960_avx_negadwt_consts_included */
