/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.zoom;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import org.jhotdraw.contrib.zoom.ScalingGraphics;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Painter;

public class ZoomUpdateStrategy
implements Painter {
    private transient Image fOffscreen;
    private int fImagewidth = -1;
    private int fImageheight = -1;

    public void draw(Graphics graphics, DrawingView drawingView) {
        Dimension dimension = drawingView.getSize();
        if (this.fOffscreen == null || dimension.width != this.fImagewidth || dimension.height != this.fImageheight) {
            this.fOffscreen = drawingView.createImage(dimension.width, dimension.height);
            this.fImagewidth = dimension.width;
            this.fImageheight = dimension.height;
        }
        Graphics graphics2 = this.fOffscreen.getGraphics();
        Rectangle rectangle = graphics.getClipBounds();
        if (graphics2 instanceof ScalingGraphics) {
            ScalingGraphics scalingGraphics = (ScalingGraphics)graphics2;
            if (rectangle != null) {
                rectangle = new Rectangle((int)((double)(rectangle.x - 2) / scalingGraphics.getScale()), (int)((double)(rectangle.y - 2) / scalingGraphics.getScale()), (int)((double)(rectangle.width + 4) / scalingGraphics.getScale()), (int)((double)(rectangle.height + 4) / scalingGraphics.getScale()));
                graphics.setClip(rectangle);
            }
        }
        graphics2.setClip(rectangle);
        drawingView.drawAll(graphics2);
        graphics.drawImage(this.fOffscreen, 0, 0, drawingView);
    }
}

