"use strict";

var helpers = require("../../helpers/helpers");

exports["America/Adak"] = {

	"guess:by:offset" : helpers.makeTestGuess("America/Adak", { offset: true }),

	"guess:by:abbr" : helpers.makeTestGuess("America/Adak", { abbr: true }),

	"1900" : helpers.makeTestYear("America/Adak", [
		["1900-08-20T23:46:37+00:00", "11:59:59", "LMT", 42398 / 60],
		["1900-08-20T23:46:38+00:00", "12:46:38", "NST", 660]
	]),

	"1942" : helpers.makeTestYear("America/Adak", [
		["1942-02-09T12:59:59+00:00", "01:59:59", "NST", 660],
		["1942-02-09T13:00:00+00:00", "03:00:00", "NWT", 600]
	]),

	"1945" : helpers.makeTestYear("America/Adak", [
		["1945-08-14T22:59:59+00:00", "12:59:59", "NWT", 600],
		["1945-08-14T23:00:00+00:00", "13:00:00", "NPT", 600],
		["1945-09-30T11:59:59+00:00", "01:59:59", "NPT", 600],
		["1945-09-30T12:00:00+00:00", "01:00:00", "NST", 660]
	]),

	"1967" : helpers.makeTestYear("America/Adak", [
		["1967-04-01T10:59:59+00:00", "23:59:59", "NST", 660],
		["1967-04-01T11:00:00+00:00", "00:00:00", "BST", 660]
	]),

	"1969" : helpers.makeTestYear("America/Adak", [
		["1969-04-27T12:59:59+00:00", "01:59:59", "BST", 660],
		["1969-04-27T13:00:00+00:00", "03:00:00", "BDT", 600],
		["1969-10-26T11:59:59+00:00", "01:59:59", "BDT", 600],
		["1969-10-26T12:00:00+00:00", "01:00:00", "BST", 660]
	]),

	"1970" : helpers.makeTestYear("America/Adak", [
		["1970-04-26T12:59:59+00:00", "01:59:59", "BST", 660],
		["1970-04-26T13:00:00+00:00", "03:00:00", "BDT", 600],
		["1970-10-25T11:59:59+00:00", "01:59:59", "BDT", 600],
		["1970-10-25T12:00:00+00:00", "01:00:00", "BST", 660]
	]),

	"1971" : helpers.makeTestYear("America/Adak", [
		["1971-04-25T12:59:59+00:00", "01:59:59", "BST", 660],
		["1971-04-25T13:00:00+00:00", "03:00:00", "BDT", 600],
		["1971-10-31T11:59:59+00:00", "01:59:59", "BDT", 600],
		["1971-10-31T12:00:00+00:00", "01:00:00", "BST", 660]
	]),

	"1972" : helpers.makeTestYear("America/Adak", [
		["1972-04-30T12:59:59+00:00", "01:59:59", "BST", 660],
		["1972-04-30T13:00:00+00:00", "03:00:00", "BDT", 600],
		["1972-10-29T11:59:59+00:00", "01:59:59", "BDT", 600],
		["1972-10-29T12:00:00+00:00", "01:00:00", "BST", 660]
	]),

	"1973" : helpers.makeTestYear("America/Adak", [
		["1973-04-29T12:59:59+00:00", "01:59:59", "BST", 660],
		["1973-04-29T13:00:00+00:00", "03:00:00", "BDT", 600],
		["1973-10-28T11:59:59+00:00", "01:59:59", "BDT", 600],
		["1973-10-28T12:00:00+00:00", "01:00:00", "BST", 660]
	]),

	"1974" : helpers.makeTestYear("America/Adak", [
		["1974-01-06T12:59:59+00:00", "01:59:59", "BST", 660],
		["1974-01-06T13:00:00+00:00", "03:00:00", "BDT", 600],
		["1974-10-27T11:59:59+00:00", "01:59:59", "BDT", 600],
		["1974-10-27T12:00:00+00:00", "01:00:00", "BST", 660]
	]),

	"1975" : helpers.makeTestYear("America/Adak", [
		["1975-02-23T12:59:59+00:00", "01:59:59", "BST", 660],
		["1975-02-23T13:00:00+00:00", "03:00:00", "BDT", 600],
		["1975-10-26T11:59:59+00:00", "01:59:59", "BDT", 600],
		["1975-10-26T12:00:00+00:00", "01:00:00", "BST", 660]
	]),

	"1976" : helpers.makeTestYear("America/Adak", [
		["1976-04-25T12:59:59+00:00", "01:59:59", "BST", 660],
		["1976-04-25T13:00:00+00:00", "03:00:00", "BDT", 600],
		["1976-10-31T11:59:59+00:00", "01:59:59", "BDT", 600],
		["1976-10-31T12:00:00+00:00", "01:00:00", "BST", 660]
	]),

	"1977" : helpers.makeTestYear("America/Adak", [
		["1977-04-24T12:59:59+00:00", "01:59:59", "BST", 660],
		["1977-04-24T13:00:00+00:00", "03:00:00", "BDT", 600],
		["1977-10-30T11:59:59+00:00", "01:59:59", "BDT", 600],
		["1977-10-30T12:00:00+00:00", "01:00:00", "BST", 660]
	]),

	"1978" : helpers.makeTestYear("America/Adak", [
		["1978-04-30T12:59:59+00:00", "01:59:59", "BST", 660],
		["1978-04-30T13:00:00+00:00", "03:00:00", "BDT", 600],
		["1978-10-29T11:59:59+00:00", "01:59:59", "BDT", 600],
		["1978-10-29T12:00:00+00:00", "01:00:00", "BST", 660]
	]),

	"1979" : helpers.makeTestYear("America/Adak", [
		["1979-04-29T12:59:59+00:00", "01:59:59", "BST", 660],
		["1979-04-29T13:00:00+00:00", "03:00:00", "BDT", 600],
		["1979-10-28T11:59:59+00:00", "01:59:59", "BDT", 600],
		["1979-10-28T12:00:00+00:00", "01:00:00", "BST", 660]
	]),

	"1980" : helpers.makeTestYear("America/Adak", [
		["1980-04-27T12:59:59+00:00", "01:59:59", "BST", 660],
		["1980-04-27T13:00:00+00:00", "03:00:00", "BDT", 600],
		["1980-10-26T11:59:59+00:00", "01:59:59", "BDT", 600],
		["1980-10-26T12:00:00+00:00", "01:00:00", "BST", 660]
	]),

	"1981" : helpers.makeTestYear("America/Adak", [
		["1981-04-26T12:59:59+00:00", "01:59:59", "BST", 660],
		["1981-04-26T13:00:00+00:00", "03:00:00", "BDT", 600],
		["1981-10-25T11:59:59+00:00", "01:59:59", "BDT", 600],
		["1981-10-25T12:00:00+00:00", "01:00:00", "BST", 660]
	]),

	"1982" : helpers.makeTestYear("America/Adak", [
		["1982-04-25T12:59:59+00:00", "01:59:59", "BST", 660],
		["1982-04-25T13:00:00+00:00", "03:00:00", "BDT", 600],
		["1982-10-31T11:59:59+00:00", "01:59:59", "BDT", 600],
		["1982-10-31T12:00:00+00:00", "01:00:00", "BST", 660]
	]),

	"1983" : helpers.makeTestYear("America/Adak", [
		["1983-04-24T12:59:59+00:00", "01:59:59", "BST", 660],
		["1983-04-24T13:00:00+00:00", "03:00:00", "BDT", 600],
		["1983-10-30T11:59:59+00:00", "01:59:59", "BDT", 600],
		["1983-10-30T12:00:00+00:00", "02:00:00", "AHST", 600],
		["1983-11-30T09:59:59+00:00", "23:59:59", "AHST", 600],
		["1983-11-30T10:00:00+00:00", "00:00:00", "HST", 600]
	]),

	"1984" : helpers.makeTestYear("America/Adak", [
		["1984-04-29T11:59:59+00:00", "01:59:59", "HST", 600],
		["1984-04-29T12:00:00+00:00", "03:00:00", "HDT", 540],
		["1984-10-28T10:59:59+00:00", "01:59:59", "HDT", 540],
		["1984-10-28T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"1985" : helpers.makeTestYear("America/Adak", [
		["1985-04-28T11:59:59+00:00", "01:59:59", "HST", 600],
		["1985-04-28T12:00:00+00:00", "03:00:00", "HDT", 540],
		["1985-10-27T10:59:59+00:00", "01:59:59", "HDT", 540],
		["1985-10-27T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"1986" : helpers.makeTestYear("America/Adak", [
		["1986-04-27T11:59:59+00:00", "01:59:59", "HST", 600],
		["1986-04-27T12:00:00+00:00", "03:00:00", "HDT", 540],
		["1986-10-26T10:59:59+00:00", "01:59:59", "HDT", 540],
		["1986-10-26T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"1987" : helpers.makeTestYear("America/Adak", [
		["1987-04-05T11:59:59+00:00", "01:59:59", "HST", 600],
		["1987-04-05T12:00:00+00:00", "03:00:00", "HDT", 540],
		["1987-10-25T10:59:59+00:00", "01:59:59", "HDT", 540],
		["1987-10-25T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"1988" : helpers.makeTestYear("America/Adak", [
		["1988-04-03T11:59:59+00:00", "01:59:59", "HST", 600],
		["1988-04-03T12:00:00+00:00", "03:00:00", "HDT", 540],
		["1988-10-30T10:59:59+00:00", "01:59:59", "HDT", 540],
		["1988-10-30T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"1989" : helpers.makeTestYear("America/Adak", [
		["1989-04-02T11:59:59+00:00", "01:59:59", "HST", 600],
		["1989-04-02T12:00:00+00:00", "03:00:00", "HDT", 540],
		["1989-10-29T10:59:59+00:00", "01:59:59", "HDT", 540],
		["1989-10-29T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"1990" : helpers.makeTestYear("America/Adak", [
		["1990-04-01T11:59:59+00:00", "01:59:59", "HST", 600],
		["1990-04-01T12:00:00+00:00", "03:00:00", "HDT", 540],
		["1990-10-28T10:59:59+00:00", "01:59:59", "HDT", 540],
		["1990-10-28T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"1991" : helpers.makeTestYear("America/Adak", [
		["1991-04-07T11:59:59+00:00", "01:59:59", "HST", 600],
		["1991-04-07T12:00:00+00:00", "03:00:00", "HDT", 540],
		["1991-10-27T10:59:59+00:00", "01:59:59", "HDT", 540],
		["1991-10-27T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"1992" : helpers.makeTestYear("America/Adak", [
		["1992-04-05T11:59:59+00:00", "01:59:59", "HST", 600],
		["1992-04-05T12:00:00+00:00", "03:00:00", "HDT", 540],
		["1992-10-25T10:59:59+00:00", "01:59:59", "HDT", 540],
		["1992-10-25T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"1993" : helpers.makeTestYear("America/Adak", [
		["1993-04-04T11:59:59+00:00", "01:59:59", "HST", 600],
		["1993-04-04T12:00:00+00:00", "03:00:00", "HDT", 540],
		["1993-10-31T10:59:59+00:00", "01:59:59", "HDT", 540],
		["1993-10-31T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"1994" : helpers.makeTestYear("America/Adak", [
		["1994-04-03T11:59:59+00:00", "01:59:59", "HST", 600],
		["1994-04-03T12:00:00+00:00", "03:00:00", "HDT", 540],
		["1994-10-30T10:59:59+00:00", "01:59:59", "HDT", 540],
		["1994-10-30T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"1995" : helpers.makeTestYear("America/Adak", [
		["1995-04-02T11:59:59+00:00", "01:59:59", "HST", 600],
		["1995-04-02T12:00:00+00:00", "03:00:00", "HDT", 540],
		["1995-10-29T10:59:59+00:00", "01:59:59", "HDT", 540],
		["1995-10-29T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"1996" : helpers.makeTestYear("America/Adak", [
		["1996-04-07T11:59:59+00:00", "01:59:59", "HST", 600],
		["1996-04-07T12:00:00+00:00", "03:00:00", "HDT", 540],
		["1996-10-27T10:59:59+00:00", "01:59:59", "HDT", 540],
		["1996-10-27T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"1997" : helpers.makeTestYear("America/Adak", [
		["1997-04-06T11:59:59+00:00", "01:59:59", "HST", 600],
		["1997-04-06T12:00:00+00:00", "03:00:00", "HDT", 540],
		["1997-10-26T10:59:59+00:00", "01:59:59", "HDT", 540],
		["1997-10-26T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"1998" : helpers.makeTestYear("America/Adak", [
		["1998-04-05T11:59:59+00:00", "01:59:59", "HST", 600],
		["1998-04-05T12:00:00+00:00", "03:00:00", "HDT", 540],
		["1998-10-25T10:59:59+00:00", "01:59:59", "HDT", 540],
		["1998-10-25T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"1999" : helpers.makeTestYear("America/Adak", [
		["1999-04-04T11:59:59+00:00", "01:59:59", "HST", 600],
		["1999-04-04T12:00:00+00:00", "03:00:00", "HDT", 540],
		["1999-10-31T10:59:59+00:00", "01:59:59", "HDT", 540],
		["1999-10-31T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2000" : helpers.makeTestYear("America/Adak", [
		["2000-04-02T11:59:59+00:00", "01:59:59", "HST", 600],
		["2000-04-02T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2000-10-29T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2000-10-29T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2001" : helpers.makeTestYear("America/Adak", [
		["2001-04-01T11:59:59+00:00", "01:59:59", "HST", 600],
		["2001-04-01T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2001-10-28T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2001-10-28T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2002" : helpers.makeTestYear("America/Adak", [
		["2002-04-07T11:59:59+00:00", "01:59:59", "HST", 600],
		["2002-04-07T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2002-10-27T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2002-10-27T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2003" : helpers.makeTestYear("America/Adak", [
		["2003-04-06T11:59:59+00:00", "01:59:59", "HST", 600],
		["2003-04-06T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2003-10-26T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2003-10-26T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2004" : helpers.makeTestYear("America/Adak", [
		["2004-04-04T11:59:59+00:00", "01:59:59", "HST", 600],
		["2004-04-04T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2004-10-31T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2004-10-31T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2005" : helpers.makeTestYear("America/Adak", [
		["2005-04-03T11:59:59+00:00", "01:59:59", "HST", 600],
		["2005-04-03T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2005-10-30T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2005-10-30T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2006" : helpers.makeTestYear("America/Adak", [
		["2006-04-02T11:59:59+00:00", "01:59:59", "HST", 600],
		["2006-04-02T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2006-10-29T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2006-10-29T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2007" : helpers.makeTestYear("America/Adak", [
		["2007-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2007-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2007-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2007-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2008" : helpers.makeTestYear("America/Adak", [
		["2008-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2008-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2008-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2008-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2009" : helpers.makeTestYear("America/Adak", [
		["2009-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2009-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2009-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2009-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2010" : helpers.makeTestYear("America/Adak", [
		["2010-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2010-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2010-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2010-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2011" : helpers.makeTestYear("America/Adak", [
		["2011-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2011-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2011-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2011-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2012" : helpers.makeTestYear("America/Adak", [
		["2012-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2012-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2012-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2012-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2013" : helpers.makeTestYear("America/Adak", [
		["2013-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2013-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2013-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2013-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2014" : helpers.makeTestYear("America/Adak", [
		["2014-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2014-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2014-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2014-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2015" : helpers.makeTestYear("America/Adak", [
		["2015-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2015-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2015-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2015-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2016" : helpers.makeTestYear("America/Adak", [
		["2016-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2016-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2016-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2016-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2017" : helpers.makeTestYear("America/Adak", [
		["2017-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2017-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2017-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2017-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2018" : helpers.makeTestYear("America/Adak", [
		["2018-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2018-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2018-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2018-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2019" : helpers.makeTestYear("America/Adak", [
		["2019-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2019-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2019-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2019-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2020" : helpers.makeTestYear("America/Adak", [
		["2020-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2020-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2020-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2020-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2021" : helpers.makeTestYear("America/Adak", [
		["2021-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2021-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2021-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2021-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2022" : helpers.makeTestYear("America/Adak", [
		["2022-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2022-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2022-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2022-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2023" : helpers.makeTestYear("America/Adak", [
		["2023-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2023-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2023-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2023-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2024" : helpers.makeTestYear("America/Adak", [
		["2024-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2024-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2024-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2024-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2025" : helpers.makeTestYear("America/Adak", [
		["2025-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2025-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2025-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2025-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2026" : helpers.makeTestYear("America/Adak", [
		["2026-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2026-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2026-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2026-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2027" : helpers.makeTestYear("America/Adak", [
		["2027-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2027-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2027-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2027-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2028" : helpers.makeTestYear("America/Adak", [
		["2028-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2028-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2028-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2028-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2029" : helpers.makeTestYear("America/Adak", [
		["2029-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2029-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2029-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2029-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2030" : helpers.makeTestYear("America/Adak", [
		["2030-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2030-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2030-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2030-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2031" : helpers.makeTestYear("America/Adak", [
		["2031-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2031-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2031-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2031-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2032" : helpers.makeTestYear("America/Adak", [
		["2032-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2032-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2032-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2032-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2033" : helpers.makeTestYear("America/Adak", [
		["2033-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2033-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2033-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2033-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2034" : helpers.makeTestYear("America/Adak", [
		["2034-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2034-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2034-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2034-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2035" : helpers.makeTestYear("America/Adak", [
		["2035-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2035-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2035-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2035-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2036" : helpers.makeTestYear("America/Adak", [
		["2036-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2036-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2036-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2036-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2037" : helpers.makeTestYear("America/Adak", [
		["2037-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2037-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2037-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2037-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2038" : helpers.makeTestYear("America/Adak", [
		["2038-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2038-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2038-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2038-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2039" : helpers.makeTestYear("America/Adak", [
		["2039-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2039-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2039-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2039-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2040" : helpers.makeTestYear("America/Adak", [
		["2040-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2040-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2040-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2040-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2041" : helpers.makeTestYear("America/Adak", [
		["2041-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2041-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2041-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2041-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2042" : helpers.makeTestYear("America/Adak", [
		["2042-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2042-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2042-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2042-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2043" : helpers.makeTestYear("America/Adak", [
		["2043-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2043-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2043-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2043-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2044" : helpers.makeTestYear("America/Adak", [
		["2044-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2044-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2044-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2044-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2045" : helpers.makeTestYear("America/Adak", [
		["2045-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2045-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2045-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2045-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2046" : helpers.makeTestYear("America/Adak", [
		["2046-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2046-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2046-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2046-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2047" : helpers.makeTestYear("America/Adak", [
		["2047-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2047-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2047-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2047-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2048" : helpers.makeTestYear("America/Adak", [
		["2048-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2048-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2048-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2048-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2049" : helpers.makeTestYear("America/Adak", [
		["2049-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2049-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2049-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2049-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2050" : helpers.makeTestYear("America/Adak", [
		["2050-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2050-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2050-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2050-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2051" : helpers.makeTestYear("America/Adak", [
		["2051-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2051-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2051-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2051-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2052" : helpers.makeTestYear("America/Adak", [
		["2052-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2052-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2052-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2052-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2053" : helpers.makeTestYear("America/Adak", [
		["2053-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2053-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2053-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2053-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2054" : helpers.makeTestYear("America/Adak", [
		["2054-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2054-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2054-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2054-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2055" : helpers.makeTestYear("America/Adak", [
		["2055-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2055-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2055-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2055-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2056" : helpers.makeTestYear("America/Adak", [
		["2056-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2056-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2056-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2056-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2057" : helpers.makeTestYear("America/Adak", [
		["2057-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2057-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2057-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2057-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2058" : helpers.makeTestYear("America/Adak", [
		["2058-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2058-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2058-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2058-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2059" : helpers.makeTestYear("America/Adak", [
		["2059-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2059-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2059-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2059-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2060" : helpers.makeTestYear("America/Adak", [
		["2060-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2060-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2060-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2060-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2061" : helpers.makeTestYear("America/Adak", [
		["2061-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2061-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2061-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2061-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2062" : helpers.makeTestYear("America/Adak", [
		["2062-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2062-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2062-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2062-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2063" : helpers.makeTestYear("America/Adak", [
		["2063-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2063-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2063-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2063-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2064" : helpers.makeTestYear("America/Adak", [
		["2064-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2064-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2064-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2064-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2065" : helpers.makeTestYear("America/Adak", [
		["2065-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2065-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2065-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2065-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2066" : helpers.makeTestYear("America/Adak", [
		["2066-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2066-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2066-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2066-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2067" : helpers.makeTestYear("America/Adak", [
		["2067-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2067-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2067-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2067-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2068" : helpers.makeTestYear("America/Adak", [
		["2068-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2068-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2068-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2068-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2069" : helpers.makeTestYear("America/Adak", [
		["2069-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2069-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2069-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2069-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2070" : helpers.makeTestYear("America/Adak", [
		["2070-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2070-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2070-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2070-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2071" : helpers.makeTestYear("America/Adak", [
		["2071-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2071-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2071-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2071-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2072" : helpers.makeTestYear("America/Adak", [
		["2072-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2072-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2072-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2072-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2073" : helpers.makeTestYear("America/Adak", [
		["2073-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2073-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2073-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2073-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2074" : helpers.makeTestYear("America/Adak", [
		["2074-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2074-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2074-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2074-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2075" : helpers.makeTestYear("America/Adak", [
		["2075-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2075-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2075-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2075-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2076" : helpers.makeTestYear("America/Adak", [
		["2076-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2076-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2076-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2076-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2077" : helpers.makeTestYear("America/Adak", [
		["2077-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2077-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2077-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2077-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2078" : helpers.makeTestYear("America/Adak", [
		["2078-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2078-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2078-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2078-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2079" : helpers.makeTestYear("America/Adak", [
		["2079-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2079-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2079-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2079-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2080" : helpers.makeTestYear("America/Adak", [
		["2080-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2080-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2080-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2080-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2081" : helpers.makeTestYear("America/Adak", [
		["2081-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2081-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2081-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2081-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2082" : helpers.makeTestYear("America/Adak", [
		["2082-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2082-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2082-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2082-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2083" : helpers.makeTestYear("America/Adak", [
		["2083-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2083-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2083-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2083-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2084" : helpers.makeTestYear("America/Adak", [
		["2084-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2084-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2084-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2084-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2085" : helpers.makeTestYear("America/Adak", [
		["2085-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2085-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2085-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2085-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2086" : helpers.makeTestYear("America/Adak", [
		["2086-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2086-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2086-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2086-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2087" : helpers.makeTestYear("America/Adak", [
		["2087-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2087-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2087-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2087-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2088" : helpers.makeTestYear("America/Adak", [
		["2088-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2088-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2088-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2088-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2089" : helpers.makeTestYear("America/Adak", [
		["2089-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2089-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2089-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2089-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2090" : helpers.makeTestYear("America/Adak", [
		["2090-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2090-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2090-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2090-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2091" : helpers.makeTestYear("America/Adak", [
		["2091-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2091-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2091-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2091-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2092" : helpers.makeTestYear("America/Adak", [
		["2092-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2092-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2092-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2092-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2093" : helpers.makeTestYear("America/Adak", [
		["2093-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2093-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2093-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2093-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2094" : helpers.makeTestYear("America/Adak", [
		["2094-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2094-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2094-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2094-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2095" : helpers.makeTestYear("America/Adak", [
		["2095-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2095-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2095-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2095-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2096" : helpers.makeTestYear("America/Adak", [
		["2096-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2096-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2096-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2096-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2097" : helpers.makeTestYear("America/Adak", [
		["2097-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2097-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2097-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2097-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2098" : helpers.makeTestYear("America/Adak", [
		["2098-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2098-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2098-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2098-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2099" : helpers.makeTestYear("America/Adak", [
		["2099-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2099-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2099-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2099-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2100" : helpers.makeTestYear("America/Adak", [
		["2100-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2100-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2100-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2100-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2101" : helpers.makeTestYear("America/Adak", [
		["2101-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2101-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2101-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2101-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2102" : helpers.makeTestYear("America/Adak", [
		["2102-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2102-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2102-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2102-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2103" : helpers.makeTestYear("America/Adak", [
		["2103-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2103-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2103-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2103-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2104" : helpers.makeTestYear("America/Adak", [
		["2104-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2104-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2104-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2104-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2105" : helpers.makeTestYear("America/Adak", [
		["2105-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2105-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2105-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2105-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2106" : helpers.makeTestYear("America/Adak", [
		["2106-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2106-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2106-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2106-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2107" : helpers.makeTestYear("America/Adak", [
		["2107-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2107-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2107-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2107-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2108" : helpers.makeTestYear("America/Adak", [
		["2108-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2108-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2108-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2108-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2109" : helpers.makeTestYear("America/Adak", [
		["2109-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2109-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2109-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2109-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2110" : helpers.makeTestYear("America/Adak", [
		["2110-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2110-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2110-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2110-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2111" : helpers.makeTestYear("America/Adak", [
		["2111-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2111-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2111-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2111-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2112" : helpers.makeTestYear("America/Adak", [
		["2112-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2112-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2112-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2112-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2113" : helpers.makeTestYear("America/Adak", [
		["2113-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2113-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2113-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2113-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2114" : helpers.makeTestYear("America/Adak", [
		["2114-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2114-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2114-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2114-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2115" : helpers.makeTestYear("America/Adak", [
		["2115-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2115-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2115-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2115-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2116" : helpers.makeTestYear("America/Adak", [
		["2116-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2116-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2116-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2116-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2117" : helpers.makeTestYear("America/Adak", [
		["2117-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2117-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2117-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2117-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2118" : helpers.makeTestYear("America/Adak", [
		["2118-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2118-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2118-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2118-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2119" : helpers.makeTestYear("America/Adak", [
		["2119-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2119-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2119-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2119-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2120" : helpers.makeTestYear("America/Adak", [
		["2120-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2120-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2120-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2120-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2121" : helpers.makeTestYear("America/Adak", [
		["2121-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2121-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2121-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2121-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2122" : helpers.makeTestYear("America/Adak", [
		["2122-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2122-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2122-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2122-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2123" : helpers.makeTestYear("America/Adak", [
		["2123-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2123-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2123-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2123-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2124" : helpers.makeTestYear("America/Adak", [
		["2124-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2124-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2124-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2124-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2125" : helpers.makeTestYear("America/Adak", [
		["2125-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2125-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2125-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2125-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2126" : helpers.makeTestYear("America/Adak", [
		["2126-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2126-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2126-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2126-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2127" : helpers.makeTestYear("America/Adak", [
		["2127-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2127-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2127-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2127-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2128" : helpers.makeTestYear("America/Adak", [
		["2128-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2128-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2128-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2128-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2129" : helpers.makeTestYear("America/Adak", [
		["2129-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2129-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2129-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2129-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2130" : helpers.makeTestYear("America/Adak", [
		["2130-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2130-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2130-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2130-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2131" : helpers.makeTestYear("America/Adak", [
		["2131-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2131-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2131-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2131-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2132" : helpers.makeTestYear("America/Adak", [
		["2132-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2132-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2132-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2132-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2133" : helpers.makeTestYear("America/Adak", [
		["2133-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2133-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2133-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2133-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2134" : helpers.makeTestYear("America/Adak", [
		["2134-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2134-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2134-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2134-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2135" : helpers.makeTestYear("America/Adak", [
		["2135-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2135-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2135-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2135-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2136" : helpers.makeTestYear("America/Adak", [
		["2136-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2136-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2136-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2136-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2137" : helpers.makeTestYear("America/Adak", [
		["2137-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2137-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2137-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2137-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2138" : helpers.makeTestYear("America/Adak", [
		["2138-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2138-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2138-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2138-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2139" : helpers.makeTestYear("America/Adak", [
		["2139-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2139-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2139-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2139-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2140" : helpers.makeTestYear("America/Adak", [
		["2140-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2140-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2140-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2140-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2141" : helpers.makeTestYear("America/Adak", [
		["2141-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2141-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2141-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2141-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2142" : helpers.makeTestYear("America/Adak", [
		["2142-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2142-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2142-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2142-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2143" : helpers.makeTestYear("America/Adak", [
		["2143-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2143-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2143-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2143-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2144" : helpers.makeTestYear("America/Adak", [
		["2144-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2144-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2144-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2144-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2145" : helpers.makeTestYear("America/Adak", [
		["2145-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2145-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2145-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2145-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2146" : helpers.makeTestYear("America/Adak", [
		["2146-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2146-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2146-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2146-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2147" : helpers.makeTestYear("America/Adak", [
		["2147-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2147-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2147-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2147-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2148" : helpers.makeTestYear("America/Adak", [
		["2148-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2148-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2148-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2148-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2149" : helpers.makeTestYear("America/Adak", [
		["2149-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2149-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2149-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2149-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2150" : helpers.makeTestYear("America/Adak", [
		["2150-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2150-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2150-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2150-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2151" : helpers.makeTestYear("America/Adak", [
		["2151-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2151-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2151-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2151-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2152" : helpers.makeTestYear("America/Adak", [
		["2152-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2152-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2152-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2152-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2153" : helpers.makeTestYear("America/Adak", [
		["2153-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2153-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2153-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2153-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2154" : helpers.makeTestYear("America/Adak", [
		["2154-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2154-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2154-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2154-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2155" : helpers.makeTestYear("America/Adak", [
		["2155-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2155-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2155-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2155-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2156" : helpers.makeTestYear("America/Adak", [
		["2156-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2156-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2156-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2156-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2157" : helpers.makeTestYear("America/Adak", [
		["2157-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2157-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2157-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2157-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2158" : helpers.makeTestYear("America/Adak", [
		["2158-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2158-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2158-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2158-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2159" : helpers.makeTestYear("America/Adak", [
		["2159-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2159-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2159-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2159-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2160" : helpers.makeTestYear("America/Adak", [
		["2160-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2160-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2160-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2160-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2161" : helpers.makeTestYear("America/Adak", [
		["2161-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2161-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2161-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2161-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2162" : helpers.makeTestYear("America/Adak", [
		["2162-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2162-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2162-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2162-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2163" : helpers.makeTestYear("America/Adak", [
		["2163-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2163-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2163-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2163-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2164" : helpers.makeTestYear("America/Adak", [
		["2164-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2164-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2164-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2164-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2165" : helpers.makeTestYear("America/Adak", [
		["2165-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2165-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2165-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2165-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2166" : helpers.makeTestYear("America/Adak", [
		["2166-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2166-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2166-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2166-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2167" : helpers.makeTestYear("America/Adak", [
		["2167-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2167-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2167-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2167-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2168" : helpers.makeTestYear("America/Adak", [
		["2168-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2168-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2168-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2168-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2169" : helpers.makeTestYear("America/Adak", [
		["2169-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2169-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2169-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2169-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2170" : helpers.makeTestYear("America/Adak", [
		["2170-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2170-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2170-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2170-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2171" : helpers.makeTestYear("America/Adak", [
		["2171-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2171-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2171-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2171-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2172" : helpers.makeTestYear("America/Adak", [
		["2172-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2172-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2172-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2172-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2173" : helpers.makeTestYear("America/Adak", [
		["2173-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2173-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2173-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2173-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2174" : helpers.makeTestYear("America/Adak", [
		["2174-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2174-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2174-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2174-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2175" : helpers.makeTestYear("America/Adak", [
		["2175-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2175-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2175-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2175-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2176" : helpers.makeTestYear("America/Adak", [
		["2176-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2176-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2176-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2176-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2177" : helpers.makeTestYear("America/Adak", [
		["2177-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2177-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2177-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2177-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2178" : helpers.makeTestYear("America/Adak", [
		["2178-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2178-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2178-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2178-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2179" : helpers.makeTestYear("America/Adak", [
		["2179-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2179-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2179-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2179-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2180" : helpers.makeTestYear("America/Adak", [
		["2180-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2180-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2180-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2180-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2181" : helpers.makeTestYear("America/Adak", [
		["2181-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2181-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2181-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2181-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2182" : helpers.makeTestYear("America/Adak", [
		["2182-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2182-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2182-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2182-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2183" : helpers.makeTestYear("America/Adak", [
		["2183-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2183-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2183-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2183-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2184" : helpers.makeTestYear("America/Adak", [
		["2184-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2184-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2184-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2184-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2185" : helpers.makeTestYear("America/Adak", [
		["2185-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2185-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2185-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2185-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2186" : helpers.makeTestYear("America/Adak", [
		["2186-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2186-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2186-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2186-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2187" : helpers.makeTestYear("America/Adak", [
		["2187-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2187-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2187-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2187-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2188" : helpers.makeTestYear("America/Adak", [
		["2188-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2188-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2188-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2188-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2189" : helpers.makeTestYear("America/Adak", [
		["2189-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2189-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2189-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2189-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2190" : helpers.makeTestYear("America/Adak", [
		["2190-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2190-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2190-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2190-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2191" : helpers.makeTestYear("America/Adak", [
		["2191-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2191-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2191-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2191-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2192" : helpers.makeTestYear("America/Adak", [
		["2192-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2192-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2192-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2192-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2193" : helpers.makeTestYear("America/Adak", [
		["2193-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2193-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2193-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2193-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2194" : helpers.makeTestYear("America/Adak", [
		["2194-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2194-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2194-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2194-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2195" : helpers.makeTestYear("America/Adak", [
		["2195-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2195-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2195-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2195-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2196" : helpers.makeTestYear("America/Adak", [
		["2196-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2196-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2196-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2196-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2197" : helpers.makeTestYear("America/Adak", [
		["2197-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2197-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2197-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2197-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2198" : helpers.makeTestYear("America/Adak", [
		["2198-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2198-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2198-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2198-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2199" : helpers.makeTestYear("America/Adak", [
		["2199-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2199-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2199-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2199-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2200" : helpers.makeTestYear("America/Adak", [
		["2200-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2200-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2200-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2200-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2201" : helpers.makeTestYear("America/Adak", [
		["2201-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2201-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2201-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2201-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2202" : helpers.makeTestYear("America/Adak", [
		["2202-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2202-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2202-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2202-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2203" : helpers.makeTestYear("America/Adak", [
		["2203-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2203-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2203-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2203-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2204" : helpers.makeTestYear("America/Adak", [
		["2204-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2204-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2204-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2204-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2205" : helpers.makeTestYear("America/Adak", [
		["2205-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2205-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2205-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2205-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2206" : helpers.makeTestYear("America/Adak", [
		["2206-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2206-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2206-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2206-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2207" : helpers.makeTestYear("America/Adak", [
		["2207-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2207-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2207-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2207-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2208" : helpers.makeTestYear("America/Adak", [
		["2208-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2208-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2208-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2208-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2209" : helpers.makeTestYear("America/Adak", [
		["2209-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2209-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2209-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2209-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2210" : helpers.makeTestYear("America/Adak", [
		["2210-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2210-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2210-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2210-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2211" : helpers.makeTestYear("America/Adak", [
		["2211-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2211-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2211-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2211-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2212" : helpers.makeTestYear("America/Adak", [
		["2212-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2212-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2212-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2212-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2213" : helpers.makeTestYear("America/Adak", [
		["2213-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2213-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2213-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2213-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2214" : helpers.makeTestYear("America/Adak", [
		["2214-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2214-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2214-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2214-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2215" : helpers.makeTestYear("America/Adak", [
		["2215-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2215-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2215-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2215-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2216" : helpers.makeTestYear("America/Adak", [
		["2216-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2216-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2216-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2216-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2217" : helpers.makeTestYear("America/Adak", [
		["2217-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2217-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2217-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2217-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2218" : helpers.makeTestYear("America/Adak", [
		["2218-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2218-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2218-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2218-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2219" : helpers.makeTestYear("America/Adak", [
		["2219-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2219-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2219-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2219-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2220" : helpers.makeTestYear("America/Adak", [
		["2220-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2220-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2220-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2220-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2221" : helpers.makeTestYear("America/Adak", [
		["2221-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2221-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2221-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2221-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2222" : helpers.makeTestYear("America/Adak", [
		["2222-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2222-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2222-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2222-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2223" : helpers.makeTestYear("America/Adak", [
		["2223-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2223-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2223-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2223-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2224" : helpers.makeTestYear("America/Adak", [
		["2224-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2224-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2224-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2224-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2225" : helpers.makeTestYear("America/Adak", [
		["2225-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2225-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2225-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2225-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2226" : helpers.makeTestYear("America/Adak", [
		["2226-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2226-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2226-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2226-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2227" : helpers.makeTestYear("America/Adak", [
		["2227-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2227-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2227-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2227-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2228" : helpers.makeTestYear("America/Adak", [
		["2228-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2228-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2228-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2228-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2229" : helpers.makeTestYear("America/Adak", [
		["2229-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2229-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2229-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2229-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2230" : helpers.makeTestYear("America/Adak", [
		["2230-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2230-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2230-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2230-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2231" : helpers.makeTestYear("America/Adak", [
		["2231-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2231-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2231-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2231-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2232" : helpers.makeTestYear("America/Adak", [
		["2232-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2232-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2232-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2232-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2233" : helpers.makeTestYear("America/Adak", [
		["2233-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2233-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2233-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2233-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2234" : helpers.makeTestYear("America/Adak", [
		["2234-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2234-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2234-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2234-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2235" : helpers.makeTestYear("America/Adak", [
		["2235-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2235-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2235-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2235-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2236" : helpers.makeTestYear("America/Adak", [
		["2236-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2236-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2236-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2236-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2237" : helpers.makeTestYear("America/Adak", [
		["2237-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2237-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2237-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2237-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2238" : helpers.makeTestYear("America/Adak", [
		["2238-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2238-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2238-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2238-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2239" : helpers.makeTestYear("America/Adak", [
		["2239-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2239-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2239-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2239-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2240" : helpers.makeTestYear("America/Adak", [
		["2240-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2240-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2240-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2240-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2241" : helpers.makeTestYear("America/Adak", [
		["2241-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2241-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2241-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2241-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2242" : helpers.makeTestYear("America/Adak", [
		["2242-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2242-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2242-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2242-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2243" : helpers.makeTestYear("America/Adak", [
		["2243-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2243-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2243-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2243-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2244" : helpers.makeTestYear("America/Adak", [
		["2244-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2244-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2244-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2244-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2245" : helpers.makeTestYear("America/Adak", [
		["2245-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2245-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2245-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2245-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2246" : helpers.makeTestYear("America/Adak", [
		["2246-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2246-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2246-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2246-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2247" : helpers.makeTestYear("America/Adak", [
		["2247-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2247-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2247-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2247-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2248" : helpers.makeTestYear("America/Adak", [
		["2248-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2248-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2248-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2248-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2249" : helpers.makeTestYear("America/Adak", [
		["2249-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2249-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2249-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2249-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2250" : helpers.makeTestYear("America/Adak", [
		["2250-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2250-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2250-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2250-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2251" : helpers.makeTestYear("America/Adak", [
		["2251-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2251-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2251-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2251-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2252" : helpers.makeTestYear("America/Adak", [
		["2252-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2252-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2252-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2252-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2253" : helpers.makeTestYear("America/Adak", [
		["2253-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2253-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2253-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2253-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2254" : helpers.makeTestYear("America/Adak", [
		["2254-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2254-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2254-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2254-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2255" : helpers.makeTestYear("America/Adak", [
		["2255-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2255-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2255-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2255-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2256" : helpers.makeTestYear("America/Adak", [
		["2256-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2256-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2256-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2256-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2257" : helpers.makeTestYear("America/Adak", [
		["2257-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2257-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2257-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2257-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2258" : helpers.makeTestYear("America/Adak", [
		["2258-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2258-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2258-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2258-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2259" : helpers.makeTestYear("America/Adak", [
		["2259-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2259-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2259-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2259-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2260" : helpers.makeTestYear("America/Adak", [
		["2260-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2260-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2260-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2260-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2261" : helpers.makeTestYear("America/Adak", [
		["2261-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2261-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2261-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2261-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2262" : helpers.makeTestYear("America/Adak", [
		["2262-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2262-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2262-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2262-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2263" : helpers.makeTestYear("America/Adak", [
		["2263-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2263-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2263-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2263-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2264" : helpers.makeTestYear("America/Adak", [
		["2264-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2264-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2264-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2264-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2265" : helpers.makeTestYear("America/Adak", [
		["2265-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2265-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2265-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2265-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2266" : helpers.makeTestYear("America/Adak", [
		["2266-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2266-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2266-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2266-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2267" : helpers.makeTestYear("America/Adak", [
		["2267-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2267-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2267-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2267-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2268" : helpers.makeTestYear("America/Adak", [
		["2268-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2268-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2268-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2268-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2269" : helpers.makeTestYear("America/Adak", [
		["2269-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2269-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2269-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2269-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2270" : helpers.makeTestYear("America/Adak", [
		["2270-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2270-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2270-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2270-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2271" : helpers.makeTestYear("America/Adak", [
		["2271-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2271-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2271-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2271-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2272" : helpers.makeTestYear("America/Adak", [
		["2272-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2272-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2272-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2272-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2273" : helpers.makeTestYear("America/Adak", [
		["2273-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2273-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2273-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2273-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2274" : helpers.makeTestYear("America/Adak", [
		["2274-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2274-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2274-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2274-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2275" : helpers.makeTestYear("America/Adak", [
		["2275-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2275-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2275-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2275-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2276" : helpers.makeTestYear("America/Adak", [
		["2276-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2276-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2276-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2276-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2277" : helpers.makeTestYear("America/Adak", [
		["2277-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2277-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2277-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2277-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2278" : helpers.makeTestYear("America/Adak", [
		["2278-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2278-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2278-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2278-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2279" : helpers.makeTestYear("America/Adak", [
		["2279-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2279-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2279-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2279-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2280" : helpers.makeTestYear("America/Adak", [
		["2280-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2280-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2280-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2280-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2281" : helpers.makeTestYear("America/Adak", [
		["2281-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2281-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2281-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2281-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2282" : helpers.makeTestYear("America/Adak", [
		["2282-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2282-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2282-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2282-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2283" : helpers.makeTestYear("America/Adak", [
		["2283-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2283-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2283-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2283-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2284" : helpers.makeTestYear("America/Adak", [
		["2284-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2284-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2284-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2284-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2285" : helpers.makeTestYear("America/Adak", [
		["2285-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2285-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2285-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2285-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2286" : helpers.makeTestYear("America/Adak", [
		["2286-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2286-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2286-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2286-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2287" : helpers.makeTestYear("America/Adak", [
		["2287-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2287-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2287-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2287-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2288" : helpers.makeTestYear("America/Adak", [
		["2288-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2288-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2288-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2288-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2289" : helpers.makeTestYear("America/Adak", [
		["2289-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2289-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2289-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2289-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2290" : helpers.makeTestYear("America/Adak", [
		["2290-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2290-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2290-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2290-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2291" : helpers.makeTestYear("America/Adak", [
		["2291-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2291-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2291-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2291-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2292" : helpers.makeTestYear("America/Adak", [
		["2292-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2292-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2292-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2292-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2293" : helpers.makeTestYear("America/Adak", [
		["2293-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2293-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2293-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2293-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2294" : helpers.makeTestYear("America/Adak", [
		["2294-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2294-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2294-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2294-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2295" : helpers.makeTestYear("America/Adak", [
		["2295-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2295-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2295-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2295-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2296" : helpers.makeTestYear("America/Adak", [
		["2296-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2296-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2296-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2296-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2297" : helpers.makeTestYear("America/Adak", [
		["2297-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2297-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2297-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2297-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2298" : helpers.makeTestYear("America/Adak", [
		["2298-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2298-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2298-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2298-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2299" : helpers.makeTestYear("America/Adak", [
		["2299-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2299-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2299-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2299-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2300" : helpers.makeTestYear("America/Adak", [
		["2300-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2300-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2300-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2300-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2301" : helpers.makeTestYear("America/Adak", [
		["2301-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2301-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2301-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2301-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2302" : helpers.makeTestYear("America/Adak", [
		["2302-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2302-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2302-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2302-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2303" : helpers.makeTestYear("America/Adak", [
		["2303-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2303-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2303-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2303-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2304" : helpers.makeTestYear("America/Adak", [
		["2304-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2304-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2304-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2304-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2305" : helpers.makeTestYear("America/Adak", [
		["2305-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2305-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2305-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2305-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2306" : helpers.makeTestYear("America/Adak", [
		["2306-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2306-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2306-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2306-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2307" : helpers.makeTestYear("America/Adak", [
		["2307-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2307-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2307-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2307-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2308" : helpers.makeTestYear("America/Adak", [
		["2308-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2308-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2308-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2308-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2309" : helpers.makeTestYear("America/Adak", [
		["2309-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2309-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2309-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2309-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2310" : helpers.makeTestYear("America/Adak", [
		["2310-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2310-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2310-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2310-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2311" : helpers.makeTestYear("America/Adak", [
		["2311-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2311-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2311-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2311-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2312" : helpers.makeTestYear("America/Adak", [
		["2312-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2312-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2312-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2312-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2313" : helpers.makeTestYear("America/Adak", [
		["2313-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2313-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2313-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2313-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2314" : helpers.makeTestYear("America/Adak", [
		["2314-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2314-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2314-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2314-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2315" : helpers.makeTestYear("America/Adak", [
		["2315-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2315-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2315-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2315-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2316" : helpers.makeTestYear("America/Adak", [
		["2316-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2316-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2316-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2316-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2317" : helpers.makeTestYear("America/Adak", [
		["2317-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2317-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2317-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2317-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2318" : helpers.makeTestYear("America/Adak", [
		["2318-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2318-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2318-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2318-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2319" : helpers.makeTestYear("America/Adak", [
		["2319-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2319-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2319-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2319-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2320" : helpers.makeTestYear("America/Adak", [
		["2320-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2320-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2320-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2320-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2321" : helpers.makeTestYear("America/Adak", [
		["2321-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2321-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2321-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2321-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2322" : helpers.makeTestYear("America/Adak", [
		["2322-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2322-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2322-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2322-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2323" : helpers.makeTestYear("America/Adak", [
		["2323-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2323-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2323-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2323-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2324" : helpers.makeTestYear("America/Adak", [
		["2324-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2324-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2324-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2324-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2325" : helpers.makeTestYear("America/Adak", [
		["2325-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2325-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2325-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2325-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2326" : helpers.makeTestYear("America/Adak", [
		["2326-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2326-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2326-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2326-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2327" : helpers.makeTestYear("America/Adak", [
		["2327-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2327-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2327-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2327-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2328" : helpers.makeTestYear("America/Adak", [
		["2328-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2328-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2328-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2328-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2329" : helpers.makeTestYear("America/Adak", [
		["2329-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2329-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2329-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2329-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2330" : helpers.makeTestYear("America/Adak", [
		["2330-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2330-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2330-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2330-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2331" : helpers.makeTestYear("America/Adak", [
		["2331-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2331-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2331-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2331-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2332" : helpers.makeTestYear("America/Adak", [
		["2332-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2332-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2332-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2332-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2333" : helpers.makeTestYear("America/Adak", [
		["2333-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2333-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2333-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2333-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2334" : helpers.makeTestYear("America/Adak", [
		["2334-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2334-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2334-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2334-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2335" : helpers.makeTestYear("America/Adak", [
		["2335-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2335-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2335-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2335-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2336" : helpers.makeTestYear("America/Adak", [
		["2336-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2336-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2336-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2336-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2337" : helpers.makeTestYear("America/Adak", [
		["2337-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2337-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2337-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2337-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2338" : helpers.makeTestYear("America/Adak", [
		["2338-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2338-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2338-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2338-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2339" : helpers.makeTestYear("America/Adak", [
		["2339-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2339-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2339-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2339-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2340" : helpers.makeTestYear("America/Adak", [
		["2340-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2340-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2340-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2340-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2341" : helpers.makeTestYear("America/Adak", [
		["2341-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2341-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2341-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2341-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2342" : helpers.makeTestYear("America/Adak", [
		["2342-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2342-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2342-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2342-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2343" : helpers.makeTestYear("America/Adak", [
		["2343-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2343-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2343-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2343-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2344" : helpers.makeTestYear("America/Adak", [
		["2344-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2344-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2344-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2344-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2345" : helpers.makeTestYear("America/Adak", [
		["2345-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2345-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2345-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2345-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2346" : helpers.makeTestYear("America/Adak", [
		["2346-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2346-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2346-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2346-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2347" : helpers.makeTestYear("America/Adak", [
		["2347-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2347-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2347-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2347-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2348" : helpers.makeTestYear("America/Adak", [
		["2348-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2348-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2348-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2348-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2349" : helpers.makeTestYear("America/Adak", [
		["2349-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2349-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2349-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2349-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2350" : helpers.makeTestYear("America/Adak", [
		["2350-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2350-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2350-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2350-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2351" : helpers.makeTestYear("America/Adak", [
		["2351-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2351-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2351-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2351-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2352" : helpers.makeTestYear("America/Adak", [
		["2352-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2352-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2352-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2352-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2353" : helpers.makeTestYear("America/Adak", [
		["2353-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2353-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2353-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2353-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2354" : helpers.makeTestYear("America/Adak", [
		["2354-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2354-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2354-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2354-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2355" : helpers.makeTestYear("America/Adak", [
		["2355-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2355-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2355-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2355-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2356" : helpers.makeTestYear("America/Adak", [
		["2356-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2356-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2356-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2356-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2357" : helpers.makeTestYear("America/Adak", [
		["2357-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2357-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2357-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2357-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2358" : helpers.makeTestYear("America/Adak", [
		["2358-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2358-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2358-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2358-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2359" : helpers.makeTestYear("America/Adak", [
		["2359-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2359-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2359-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2359-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2360" : helpers.makeTestYear("America/Adak", [
		["2360-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2360-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2360-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2360-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2361" : helpers.makeTestYear("America/Adak", [
		["2361-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2361-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2361-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2361-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2362" : helpers.makeTestYear("America/Adak", [
		["2362-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2362-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2362-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2362-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2363" : helpers.makeTestYear("America/Adak", [
		["2363-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2363-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2363-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2363-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2364" : helpers.makeTestYear("America/Adak", [
		["2364-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2364-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2364-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2364-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2365" : helpers.makeTestYear("America/Adak", [
		["2365-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2365-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2365-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2365-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2366" : helpers.makeTestYear("America/Adak", [
		["2366-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2366-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2366-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2366-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2367" : helpers.makeTestYear("America/Adak", [
		["2367-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2367-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2367-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2367-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2368" : helpers.makeTestYear("America/Adak", [
		["2368-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2368-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2368-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2368-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2369" : helpers.makeTestYear("America/Adak", [
		["2369-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2369-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2369-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2369-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2370" : helpers.makeTestYear("America/Adak", [
		["2370-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2370-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2370-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2370-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2371" : helpers.makeTestYear("America/Adak", [
		["2371-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2371-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2371-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2371-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2372" : helpers.makeTestYear("America/Adak", [
		["2372-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2372-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2372-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2372-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2373" : helpers.makeTestYear("America/Adak", [
		["2373-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2373-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2373-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2373-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2374" : helpers.makeTestYear("America/Adak", [
		["2374-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2374-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2374-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2374-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2375" : helpers.makeTestYear("America/Adak", [
		["2375-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2375-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2375-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2375-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2376" : helpers.makeTestYear("America/Adak", [
		["2376-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2376-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2376-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2376-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2377" : helpers.makeTestYear("America/Adak", [
		["2377-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2377-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2377-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2377-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2378" : helpers.makeTestYear("America/Adak", [
		["2378-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2378-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2378-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2378-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2379" : helpers.makeTestYear("America/Adak", [
		["2379-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2379-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2379-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2379-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2380" : helpers.makeTestYear("America/Adak", [
		["2380-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2380-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2380-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2380-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2381" : helpers.makeTestYear("America/Adak", [
		["2381-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2381-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2381-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2381-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2382" : helpers.makeTestYear("America/Adak", [
		["2382-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2382-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2382-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2382-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2383" : helpers.makeTestYear("America/Adak", [
		["2383-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2383-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2383-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2383-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2384" : helpers.makeTestYear("America/Adak", [
		["2384-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2384-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2384-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2384-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2385" : helpers.makeTestYear("America/Adak", [
		["2385-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2385-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2385-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2385-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2386" : helpers.makeTestYear("America/Adak", [
		["2386-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2386-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2386-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2386-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2387" : helpers.makeTestYear("America/Adak", [
		["2387-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2387-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2387-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2387-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2388" : helpers.makeTestYear("America/Adak", [
		["2388-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2388-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2388-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2388-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2389" : helpers.makeTestYear("America/Adak", [
		["2389-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2389-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2389-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2389-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2390" : helpers.makeTestYear("America/Adak", [
		["2390-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2390-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2390-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2390-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2391" : helpers.makeTestYear("America/Adak", [
		["2391-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2391-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2391-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2391-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2392" : helpers.makeTestYear("America/Adak", [
		["2392-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2392-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2392-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2392-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2393" : helpers.makeTestYear("America/Adak", [
		["2393-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2393-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2393-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2393-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2394" : helpers.makeTestYear("America/Adak", [
		["2394-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2394-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2394-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2394-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2395" : helpers.makeTestYear("America/Adak", [
		["2395-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2395-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2395-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2395-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2396" : helpers.makeTestYear("America/Adak", [
		["2396-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2396-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2396-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2396-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2397" : helpers.makeTestYear("America/Adak", [
		["2397-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2397-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2397-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2397-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2398" : helpers.makeTestYear("America/Adak", [
		["2398-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2398-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2398-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2398-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2399" : helpers.makeTestYear("America/Adak", [
		["2399-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2399-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2399-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2399-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2400" : helpers.makeTestYear("America/Adak", [
		["2400-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2400-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2400-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2400-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2401" : helpers.makeTestYear("America/Adak", [
		["2401-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2401-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2401-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2401-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2402" : helpers.makeTestYear("America/Adak", [
		["2402-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2402-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2402-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2402-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2403" : helpers.makeTestYear("America/Adak", [
		["2403-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2403-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2403-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2403-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2404" : helpers.makeTestYear("America/Adak", [
		["2404-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2404-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2404-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2404-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2405" : helpers.makeTestYear("America/Adak", [
		["2405-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2405-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2405-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2405-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2406" : helpers.makeTestYear("America/Adak", [
		["2406-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2406-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2406-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2406-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2407" : helpers.makeTestYear("America/Adak", [
		["2407-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2407-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2407-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2407-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2408" : helpers.makeTestYear("America/Adak", [
		["2408-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2408-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2408-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2408-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2409" : helpers.makeTestYear("America/Adak", [
		["2409-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2409-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2409-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2409-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2410" : helpers.makeTestYear("America/Adak", [
		["2410-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2410-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2410-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2410-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2411" : helpers.makeTestYear("America/Adak", [
		["2411-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2411-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2411-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2411-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2412" : helpers.makeTestYear("America/Adak", [
		["2412-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2412-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2412-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2412-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2413" : helpers.makeTestYear("America/Adak", [
		["2413-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2413-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2413-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2413-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2414" : helpers.makeTestYear("America/Adak", [
		["2414-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2414-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2414-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2414-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2415" : helpers.makeTestYear("America/Adak", [
		["2415-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2415-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2415-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2415-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2416" : helpers.makeTestYear("America/Adak", [
		["2416-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2416-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2416-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2416-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2417" : helpers.makeTestYear("America/Adak", [
		["2417-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2417-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2417-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2417-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2418" : helpers.makeTestYear("America/Adak", [
		["2418-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2418-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2418-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2418-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2419" : helpers.makeTestYear("America/Adak", [
		["2419-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2419-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2419-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2419-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2420" : helpers.makeTestYear("America/Adak", [
		["2420-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2420-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2420-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2420-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2421" : helpers.makeTestYear("America/Adak", [
		["2421-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2421-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2421-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2421-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2422" : helpers.makeTestYear("America/Adak", [
		["2422-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2422-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2422-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2422-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2423" : helpers.makeTestYear("America/Adak", [
		["2423-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2423-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2423-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2423-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2424" : helpers.makeTestYear("America/Adak", [
		["2424-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2424-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2424-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2424-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2425" : helpers.makeTestYear("America/Adak", [
		["2425-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2425-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2425-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2425-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2426" : helpers.makeTestYear("America/Adak", [
		["2426-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2426-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2426-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2426-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2427" : helpers.makeTestYear("America/Adak", [
		["2427-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2427-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2427-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2427-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2428" : helpers.makeTestYear("America/Adak", [
		["2428-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2428-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2428-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2428-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2429" : helpers.makeTestYear("America/Adak", [
		["2429-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2429-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2429-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2429-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2430" : helpers.makeTestYear("America/Adak", [
		["2430-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2430-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2430-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2430-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2431" : helpers.makeTestYear("America/Adak", [
		["2431-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2431-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2431-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2431-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2432" : helpers.makeTestYear("America/Adak", [
		["2432-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2432-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2432-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2432-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2433" : helpers.makeTestYear("America/Adak", [
		["2433-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2433-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2433-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2433-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2434" : helpers.makeTestYear("America/Adak", [
		["2434-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2434-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2434-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2434-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2435" : helpers.makeTestYear("America/Adak", [
		["2435-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2435-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2435-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2435-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2436" : helpers.makeTestYear("America/Adak", [
		["2436-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2436-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2436-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2436-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2437" : helpers.makeTestYear("America/Adak", [
		["2437-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2437-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2437-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2437-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2438" : helpers.makeTestYear("America/Adak", [
		["2438-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2438-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2438-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2438-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2439" : helpers.makeTestYear("America/Adak", [
		["2439-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2439-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2439-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2439-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2440" : helpers.makeTestYear("America/Adak", [
		["2440-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2440-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2440-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2440-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2441" : helpers.makeTestYear("America/Adak", [
		["2441-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2441-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2441-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2441-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2442" : helpers.makeTestYear("America/Adak", [
		["2442-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2442-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2442-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2442-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2443" : helpers.makeTestYear("America/Adak", [
		["2443-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2443-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2443-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2443-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2444" : helpers.makeTestYear("America/Adak", [
		["2444-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2444-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2444-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2444-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2445" : helpers.makeTestYear("America/Adak", [
		["2445-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2445-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2445-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2445-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2446" : helpers.makeTestYear("America/Adak", [
		["2446-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2446-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2446-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2446-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2447" : helpers.makeTestYear("America/Adak", [
		["2447-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2447-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2447-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2447-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2448" : helpers.makeTestYear("America/Adak", [
		["2448-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2448-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2448-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2448-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2449" : helpers.makeTestYear("America/Adak", [
		["2449-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2449-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2449-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2449-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2450" : helpers.makeTestYear("America/Adak", [
		["2450-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2450-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2450-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2450-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2451" : helpers.makeTestYear("America/Adak", [
		["2451-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2451-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2451-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2451-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2452" : helpers.makeTestYear("America/Adak", [
		["2452-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2452-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2452-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2452-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2453" : helpers.makeTestYear("America/Adak", [
		["2453-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2453-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2453-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2453-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2454" : helpers.makeTestYear("America/Adak", [
		["2454-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2454-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2454-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2454-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2455" : helpers.makeTestYear("America/Adak", [
		["2455-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2455-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2455-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2455-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2456" : helpers.makeTestYear("America/Adak", [
		["2456-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2456-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2456-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2456-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2457" : helpers.makeTestYear("America/Adak", [
		["2457-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2457-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2457-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2457-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2458" : helpers.makeTestYear("America/Adak", [
		["2458-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2458-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2458-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2458-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2459" : helpers.makeTestYear("America/Adak", [
		["2459-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2459-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2459-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2459-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2460" : helpers.makeTestYear("America/Adak", [
		["2460-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2460-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2460-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2460-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2461" : helpers.makeTestYear("America/Adak", [
		["2461-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2461-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2461-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2461-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2462" : helpers.makeTestYear("America/Adak", [
		["2462-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2462-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2462-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2462-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2463" : helpers.makeTestYear("America/Adak", [
		["2463-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2463-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2463-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2463-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2464" : helpers.makeTestYear("America/Adak", [
		["2464-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2464-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2464-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2464-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2465" : helpers.makeTestYear("America/Adak", [
		["2465-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2465-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2465-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2465-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2466" : helpers.makeTestYear("America/Adak", [
		["2466-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2466-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2466-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2466-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2467" : helpers.makeTestYear("America/Adak", [
		["2467-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2467-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2467-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2467-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2468" : helpers.makeTestYear("America/Adak", [
		["2468-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2468-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2468-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2468-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2469" : helpers.makeTestYear("America/Adak", [
		["2469-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2469-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2469-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2469-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2470" : helpers.makeTestYear("America/Adak", [
		["2470-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2470-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2470-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2470-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2471" : helpers.makeTestYear("America/Adak", [
		["2471-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2471-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2471-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2471-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2472" : helpers.makeTestYear("America/Adak", [
		["2472-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2472-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2472-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2472-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2473" : helpers.makeTestYear("America/Adak", [
		["2473-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2473-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2473-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2473-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2474" : helpers.makeTestYear("America/Adak", [
		["2474-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2474-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2474-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2474-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2475" : helpers.makeTestYear("America/Adak", [
		["2475-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2475-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2475-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2475-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2476" : helpers.makeTestYear("America/Adak", [
		["2476-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2476-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2476-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2476-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2477" : helpers.makeTestYear("America/Adak", [
		["2477-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2477-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2477-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2477-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2478" : helpers.makeTestYear("America/Adak", [
		["2478-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2478-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2478-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2478-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2479" : helpers.makeTestYear("America/Adak", [
		["2479-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2479-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2479-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2479-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2480" : helpers.makeTestYear("America/Adak", [
		["2480-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2480-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2480-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2480-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2481" : helpers.makeTestYear("America/Adak", [
		["2481-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2481-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2481-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2481-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2482" : helpers.makeTestYear("America/Adak", [
		["2482-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2482-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2482-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2482-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2483" : helpers.makeTestYear("America/Adak", [
		["2483-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2483-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2483-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2483-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2484" : helpers.makeTestYear("America/Adak", [
		["2484-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2484-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2484-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2484-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2485" : helpers.makeTestYear("America/Adak", [
		["2485-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2485-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2485-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2485-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2486" : helpers.makeTestYear("America/Adak", [
		["2486-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2486-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2486-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2486-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2487" : helpers.makeTestYear("America/Adak", [
		["2487-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2487-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2487-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2487-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2488" : helpers.makeTestYear("America/Adak", [
		["2488-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2488-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2488-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2488-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2489" : helpers.makeTestYear("America/Adak", [
		["2489-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2489-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2489-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2489-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2490" : helpers.makeTestYear("America/Adak", [
		["2490-03-12T11:59:59+00:00", "01:59:59", "HST", 600],
		["2490-03-12T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2490-11-05T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2490-11-05T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2491" : helpers.makeTestYear("America/Adak", [
		["2491-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2491-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2491-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2491-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2492" : helpers.makeTestYear("America/Adak", [
		["2492-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2492-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2492-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2492-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2493" : helpers.makeTestYear("America/Adak", [
		["2493-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2493-03-08T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2493-11-01T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2493-11-01T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2494" : helpers.makeTestYear("America/Adak", [
		["2494-03-14T11:59:59+00:00", "01:59:59", "HST", 600],
		["2494-03-14T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2494-11-07T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2494-11-07T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2495" : helpers.makeTestYear("America/Adak", [
		["2495-03-13T11:59:59+00:00", "01:59:59", "HST", 600],
		["2495-03-13T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2495-11-06T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2495-11-06T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2496" : helpers.makeTestYear("America/Adak", [
		["2496-03-11T11:59:59+00:00", "01:59:59", "HST", 600],
		["2496-03-11T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2496-11-04T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2496-11-04T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2497" : helpers.makeTestYear("America/Adak", [
		["2497-03-10T11:59:59+00:00", "01:59:59", "HST", 600],
		["2497-03-10T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2497-11-03T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2497-11-03T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2498" : helpers.makeTestYear("America/Adak", [
		["2498-03-09T11:59:59+00:00", "01:59:59", "HST", 600],
		["2498-03-09T12:00:00+00:00", "03:00:00", "HDT", 540],
		["2498-11-02T10:59:59+00:00", "01:59:59", "HDT", 540],
		["2498-11-02T11:00:00+00:00", "01:00:00", "HST", 600]
	]),

	"2499" : helpers.makeTestYear("America/Adak", [
		["2499-03-08T11:59:59+00:00", "01:59:59", "HST", 600],
		["2499-03-08T12:00:00+00:00", "03:00:00", "HDT", 540]
	])
};