"use strict";

var helpers = require("../../helpers/helpers");

exports["Antarctica/Troll"] = {

	"guess:by:offset" : helpers.makeTestGuess("Antarctica/Troll", { offset: true }),

	"guess:by:abbr" : helpers.makeTestGuess("Antarctica/Troll", { abbr: true }),

	"2005" : helpers.makeTestYear("Antarctica/Troll", [
		["2005-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2005-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2005-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2005-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2006" : helpers.makeTestYear("Antarctica/Troll", [
		["2006-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2006-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2006-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2006-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2007" : helpers.makeTestYear("Antarctica/Troll", [
		["2007-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2007-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2007-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2007-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2008" : helpers.makeTestYear("Antarctica/Troll", [
		["2008-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2008-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2008-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2008-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2009" : helpers.makeTestYear("Antarctica/Troll", [
		["2009-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2009-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2009-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2009-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2010" : helpers.makeTestYear("Antarctica/Troll", [
		["2010-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2010-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2010-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2010-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2011" : helpers.makeTestYear("Antarctica/Troll", [
		["2011-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2011-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2011-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2011-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2012" : helpers.makeTestYear("Antarctica/Troll", [
		["2012-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2012-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2012-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2012-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2013" : helpers.makeTestYear("Antarctica/Troll", [
		["2013-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2013-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2013-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2013-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2014" : helpers.makeTestYear("Antarctica/Troll", [
		["2014-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2014-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2014-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2014-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2015" : helpers.makeTestYear("Antarctica/Troll", [
		["2015-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2015-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2015-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2015-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2016" : helpers.makeTestYear("Antarctica/Troll", [
		["2016-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2016-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2016-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2016-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2017" : helpers.makeTestYear("Antarctica/Troll", [
		["2017-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2017-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2017-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2017-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2018" : helpers.makeTestYear("Antarctica/Troll", [
		["2018-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2018-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2018-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2018-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2019" : helpers.makeTestYear("Antarctica/Troll", [
		["2019-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2019-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2019-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2019-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2020" : helpers.makeTestYear("Antarctica/Troll", [
		["2020-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2020-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2020-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2020-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2021" : helpers.makeTestYear("Antarctica/Troll", [
		["2021-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2021-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2021-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2021-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2022" : helpers.makeTestYear("Antarctica/Troll", [
		["2022-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2022-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2022-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2022-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2023" : helpers.makeTestYear("Antarctica/Troll", [
		["2023-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2023-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2023-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2023-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2024" : helpers.makeTestYear("Antarctica/Troll", [
		["2024-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2024-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2024-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2024-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2025" : helpers.makeTestYear("Antarctica/Troll", [
		["2025-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2025-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2025-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2025-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2026" : helpers.makeTestYear("Antarctica/Troll", [
		["2026-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2026-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2026-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2026-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2027" : helpers.makeTestYear("Antarctica/Troll", [
		["2027-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2027-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2027-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2027-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2028" : helpers.makeTestYear("Antarctica/Troll", [
		["2028-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2028-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2028-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2028-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2029" : helpers.makeTestYear("Antarctica/Troll", [
		["2029-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2029-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2029-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2029-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2030" : helpers.makeTestYear("Antarctica/Troll", [
		["2030-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2030-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2030-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2030-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2031" : helpers.makeTestYear("Antarctica/Troll", [
		["2031-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2031-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2031-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2031-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2032" : helpers.makeTestYear("Antarctica/Troll", [
		["2032-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2032-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2032-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2032-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2033" : helpers.makeTestYear("Antarctica/Troll", [
		["2033-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2033-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2033-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2033-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2034" : helpers.makeTestYear("Antarctica/Troll", [
		["2034-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2034-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2034-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2034-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2035" : helpers.makeTestYear("Antarctica/Troll", [
		["2035-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2035-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2035-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2035-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2036" : helpers.makeTestYear("Antarctica/Troll", [
		["2036-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2036-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2036-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2036-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2037" : helpers.makeTestYear("Antarctica/Troll", [
		["2037-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2037-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2037-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2037-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2038" : helpers.makeTestYear("Antarctica/Troll", [
		["2038-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2038-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2038-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2038-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2039" : helpers.makeTestYear("Antarctica/Troll", [
		["2039-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2039-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2039-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2039-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2040" : helpers.makeTestYear("Antarctica/Troll", [
		["2040-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2040-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2040-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2040-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2041" : helpers.makeTestYear("Antarctica/Troll", [
		["2041-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2041-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2041-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2041-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2042" : helpers.makeTestYear("Antarctica/Troll", [
		["2042-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2042-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2042-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2042-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2043" : helpers.makeTestYear("Antarctica/Troll", [
		["2043-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2043-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2043-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2043-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2044" : helpers.makeTestYear("Antarctica/Troll", [
		["2044-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2044-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2044-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2044-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2045" : helpers.makeTestYear("Antarctica/Troll", [
		["2045-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2045-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2045-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2045-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2046" : helpers.makeTestYear("Antarctica/Troll", [
		["2046-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2046-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2046-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2046-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2047" : helpers.makeTestYear("Antarctica/Troll", [
		["2047-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2047-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2047-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2047-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2048" : helpers.makeTestYear("Antarctica/Troll", [
		["2048-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2048-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2048-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2048-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2049" : helpers.makeTestYear("Antarctica/Troll", [
		["2049-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2049-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2049-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2049-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2050" : helpers.makeTestYear("Antarctica/Troll", [
		["2050-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2050-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2050-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2050-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2051" : helpers.makeTestYear("Antarctica/Troll", [
		["2051-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2051-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2051-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2051-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2052" : helpers.makeTestYear("Antarctica/Troll", [
		["2052-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2052-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2052-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2052-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2053" : helpers.makeTestYear("Antarctica/Troll", [
		["2053-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2053-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2053-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2053-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2054" : helpers.makeTestYear("Antarctica/Troll", [
		["2054-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2054-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2054-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2054-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2055" : helpers.makeTestYear("Antarctica/Troll", [
		["2055-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2055-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2055-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2055-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2056" : helpers.makeTestYear("Antarctica/Troll", [
		["2056-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2056-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2056-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2056-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2057" : helpers.makeTestYear("Antarctica/Troll", [
		["2057-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2057-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2057-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2057-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2058" : helpers.makeTestYear("Antarctica/Troll", [
		["2058-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2058-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2058-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2058-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2059" : helpers.makeTestYear("Antarctica/Troll", [
		["2059-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2059-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2059-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2059-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2060" : helpers.makeTestYear("Antarctica/Troll", [
		["2060-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2060-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2060-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2060-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2061" : helpers.makeTestYear("Antarctica/Troll", [
		["2061-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2061-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2061-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2061-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2062" : helpers.makeTestYear("Antarctica/Troll", [
		["2062-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2062-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2062-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2062-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2063" : helpers.makeTestYear("Antarctica/Troll", [
		["2063-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2063-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2063-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2063-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2064" : helpers.makeTestYear("Antarctica/Troll", [
		["2064-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2064-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2064-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2064-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2065" : helpers.makeTestYear("Antarctica/Troll", [
		["2065-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2065-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2065-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2065-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2066" : helpers.makeTestYear("Antarctica/Troll", [
		["2066-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2066-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2066-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2066-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2067" : helpers.makeTestYear("Antarctica/Troll", [
		["2067-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2067-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2067-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2067-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2068" : helpers.makeTestYear("Antarctica/Troll", [
		["2068-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2068-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2068-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2068-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2069" : helpers.makeTestYear("Antarctica/Troll", [
		["2069-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2069-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2069-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2069-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2070" : helpers.makeTestYear("Antarctica/Troll", [
		["2070-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2070-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2070-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2070-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2071" : helpers.makeTestYear("Antarctica/Troll", [
		["2071-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2071-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2071-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2071-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2072" : helpers.makeTestYear("Antarctica/Troll", [
		["2072-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2072-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2072-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2072-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2073" : helpers.makeTestYear("Antarctica/Troll", [
		["2073-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2073-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2073-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2073-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2074" : helpers.makeTestYear("Antarctica/Troll", [
		["2074-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2074-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2074-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2074-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2075" : helpers.makeTestYear("Antarctica/Troll", [
		["2075-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2075-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2075-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2075-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2076" : helpers.makeTestYear("Antarctica/Troll", [
		["2076-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2076-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2076-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2076-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2077" : helpers.makeTestYear("Antarctica/Troll", [
		["2077-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2077-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2077-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2077-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2078" : helpers.makeTestYear("Antarctica/Troll", [
		["2078-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2078-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2078-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2078-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2079" : helpers.makeTestYear("Antarctica/Troll", [
		["2079-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2079-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2079-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2079-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2080" : helpers.makeTestYear("Antarctica/Troll", [
		["2080-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2080-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2080-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2080-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2081" : helpers.makeTestYear("Antarctica/Troll", [
		["2081-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2081-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2081-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2081-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2082" : helpers.makeTestYear("Antarctica/Troll", [
		["2082-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2082-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2082-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2082-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2083" : helpers.makeTestYear("Antarctica/Troll", [
		["2083-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2083-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2083-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2083-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2084" : helpers.makeTestYear("Antarctica/Troll", [
		["2084-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2084-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2084-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2084-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2085" : helpers.makeTestYear("Antarctica/Troll", [
		["2085-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2085-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2085-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2085-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2086" : helpers.makeTestYear("Antarctica/Troll", [
		["2086-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2086-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2086-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2086-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2087" : helpers.makeTestYear("Antarctica/Troll", [
		["2087-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2087-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2087-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2087-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2088" : helpers.makeTestYear("Antarctica/Troll", [
		["2088-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2088-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2088-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2088-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2089" : helpers.makeTestYear("Antarctica/Troll", [
		["2089-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2089-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2089-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2089-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2090" : helpers.makeTestYear("Antarctica/Troll", [
		["2090-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2090-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2090-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2090-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2091" : helpers.makeTestYear("Antarctica/Troll", [
		["2091-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2091-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2091-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2091-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2092" : helpers.makeTestYear("Antarctica/Troll", [
		["2092-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2092-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2092-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2092-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2093" : helpers.makeTestYear("Antarctica/Troll", [
		["2093-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2093-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2093-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2093-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2094" : helpers.makeTestYear("Antarctica/Troll", [
		["2094-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2094-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2094-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2094-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2095" : helpers.makeTestYear("Antarctica/Troll", [
		["2095-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2095-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2095-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2095-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2096" : helpers.makeTestYear("Antarctica/Troll", [
		["2096-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2096-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2096-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2096-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2097" : helpers.makeTestYear("Antarctica/Troll", [
		["2097-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2097-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2097-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2097-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2098" : helpers.makeTestYear("Antarctica/Troll", [
		["2098-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2098-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2098-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2098-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2099" : helpers.makeTestYear("Antarctica/Troll", [
		["2099-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2099-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2099-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2099-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2100" : helpers.makeTestYear("Antarctica/Troll", [
		["2100-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2100-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2100-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2100-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2101" : helpers.makeTestYear("Antarctica/Troll", [
		["2101-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2101-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2101-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2101-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2102" : helpers.makeTestYear("Antarctica/Troll", [
		["2102-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2102-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2102-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2102-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2103" : helpers.makeTestYear("Antarctica/Troll", [
		["2103-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2103-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2103-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2103-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2104" : helpers.makeTestYear("Antarctica/Troll", [
		["2104-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2104-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2104-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2104-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2105" : helpers.makeTestYear("Antarctica/Troll", [
		["2105-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2105-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2105-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2105-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2106" : helpers.makeTestYear("Antarctica/Troll", [
		["2106-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2106-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2106-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2106-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2107" : helpers.makeTestYear("Antarctica/Troll", [
		["2107-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2107-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2107-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2107-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2108" : helpers.makeTestYear("Antarctica/Troll", [
		["2108-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2108-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2108-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2108-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2109" : helpers.makeTestYear("Antarctica/Troll", [
		["2109-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2109-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2109-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2109-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2110" : helpers.makeTestYear("Antarctica/Troll", [
		["2110-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2110-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2110-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2110-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2111" : helpers.makeTestYear("Antarctica/Troll", [
		["2111-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2111-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2111-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2111-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2112" : helpers.makeTestYear("Antarctica/Troll", [
		["2112-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2112-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2112-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2112-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2113" : helpers.makeTestYear("Antarctica/Troll", [
		["2113-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2113-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2113-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2113-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2114" : helpers.makeTestYear("Antarctica/Troll", [
		["2114-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2114-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2114-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2114-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2115" : helpers.makeTestYear("Antarctica/Troll", [
		["2115-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2115-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2115-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2115-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2116" : helpers.makeTestYear("Antarctica/Troll", [
		["2116-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2116-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2116-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2116-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2117" : helpers.makeTestYear("Antarctica/Troll", [
		["2117-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2117-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2117-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2117-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2118" : helpers.makeTestYear("Antarctica/Troll", [
		["2118-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2118-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2118-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2118-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2119" : helpers.makeTestYear("Antarctica/Troll", [
		["2119-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2119-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2119-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2119-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2120" : helpers.makeTestYear("Antarctica/Troll", [
		["2120-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2120-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2120-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2120-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2121" : helpers.makeTestYear("Antarctica/Troll", [
		["2121-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2121-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2121-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2121-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2122" : helpers.makeTestYear("Antarctica/Troll", [
		["2122-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2122-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2122-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2122-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2123" : helpers.makeTestYear("Antarctica/Troll", [
		["2123-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2123-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2123-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2123-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2124" : helpers.makeTestYear("Antarctica/Troll", [
		["2124-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2124-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2124-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2124-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2125" : helpers.makeTestYear("Antarctica/Troll", [
		["2125-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2125-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2125-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2125-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2126" : helpers.makeTestYear("Antarctica/Troll", [
		["2126-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2126-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2126-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2126-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2127" : helpers.makeTestYear("Antarctica/Troll", [
		["2127-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2127-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2127-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2127-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2128" : helpers.makeTestYear("Antarctica/Troll", [
		["2128-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2128-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2128-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2128-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2129" : helpers.makeTestYear("Antarctica/Troll", [
		["2129-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2129-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2129-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2129-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2130" : helpers.makeTestYear("Antarctica/Troll", [
		["2130-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2130-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2130-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2130-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2131" : helpers.makeTestYear("Antarctica/Troll", [
		["2131-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2131-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2131-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2131-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2132" : helpers.makeTestYear("Antarctica/Troll", [
		["2132-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2132-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2132-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2132-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2133" : helpers.makeTestYear("Antarctica/Troll", [
		["2133-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2133-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2133-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2133-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2134" : helpers.makeTestYear("Antarctica/Troll", [
		["2134-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2134-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2134-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2134-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2135" : helpers.makeTestYear("Antarctica/Troll", [
		["2135-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2135-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2135-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2135-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2136" : helpers.makeTestYear("Antarctica/Troll", [
		["2136-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2136-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2136-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2136-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2137" : helpers.makeTestYear("Antarctica/Troll", [
		["2137-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2137-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2137-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2137-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2138" : helpers.makeTestYear("Antarctica/Troll", [
		["2138-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2138-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2138-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2138-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2139" : helpers.makeTestYear("Antarctica/Troll", [
		["2139-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2139-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2139-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2139-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2140" : helpers.makeTestYear("Antarctica/Troll", [
		["2140-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2140-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2140-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2140-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2141" : helpers.makeTestYear("Antarctica/Troll", [
		["2141-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2141-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2141-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2141-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2142" : helpers.makeTestYear("Antarctica/Troll", [
		["2142-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2142-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2142-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2142-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2143" : helpers.makeTestYear("Antarctica/Troll", [
		["2143-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2143-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2143-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2143-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2144" : helpers.makeTestYear("Antarctica/Troll", [
		["2144-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2144-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2144-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2144-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2145" : helpers.makeTestYear("Antarctica/Troll", [
		["2145-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2145-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2145-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2145-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2146" : helpers.makeTestYear("Antarctica/Troll", [
		["2146-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2146-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2146-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2146-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2147" : helpers.makeTestYear("Antarctica/Troll", [
		["2147-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2147-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2147-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2147-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2148" : helpers.makeTestYear("Antarctica/Troll", [
		["2148-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2148-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2148-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2148-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2149" : helpers.makeTestYear("Antarctica/Troll", [
		["2149-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2149-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2149-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2149-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2150" : helpers.makeTestYear("Antarctica/Troll", [
		["2150-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2150-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2150-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2150-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2151" : helpers.makeTestYear("Antarctica/Troll", [
		["2151-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2151-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2151-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2151-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2152" : helpers.makeTestYear("Antarctica/Troll", [
		["2152-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2152-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2152-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2152-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2153" : helpers.makeTestYear("Antarctica/Troll", [
		["2153-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2153-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2153-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2153-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2154" : helpers.makeTestYear("Antarctica/Troll", [
		["2154-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2154-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2154-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2154-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2155" : helpers.makeTestYear("Antarctica/Troll", [
		["2155-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2155-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2155-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2155-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2156" : helpers.makeTestYear("Antarctica/Troll", [
		["2156-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2156-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2156-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2156-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2157" : helpers.makeTestYear("Antarctica/Troll", [
		["2157-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2157-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2157-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2157-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2158" : helpers.makeTestYear("Antarctica/Troll", [
		["2158-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2158-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2158-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2158-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2159" : helpers.makeTestYear("Antarctica/Troll", [
		["2159-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2159-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2159-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2159-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2160" : helpers.makeTestYear("Antarctica/Troll", [
		["2160-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2160-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2160-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2160-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2161" : helpers.makeTestYear("Antarctica/Troll", [
		["2161-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2161-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2161-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2161-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2162" : helpers.makeTestYear("Antarctica/Troll", [
		["2162-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2162-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2162-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2162-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2163" : helpers.makeTestYear("Antarctica/Troll", [
		["2163-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2163-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2163-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2163-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2164" : helpers.makeTestYear("Antarctica/Troll", [
		["2164-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2164-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2164-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2164-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2165" : helpers.makeTestYear("Antarctica/Troll", [
		["2165-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2165-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2165-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2165-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2166" : helpers.makeTestYear("Antarctica/Troll", [
		["2166-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2166-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2166-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2166-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2167" : helpers.makeTestYear("Antarctica/Troll", [
		["2167-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2167-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2167-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2167-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2168" : helpers.makeTestYear("Antarctica/Troll", [
		["2168-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2168-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2168-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2168-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2169" : helpers.makeTestYear("Antarctica/Troll", [
		["2169-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2169-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2169-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2169-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2170" : helpers.makeTestYear("Antarctica/Troll", [
		["2170-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2170-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2170-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2170-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2171" : helpers.makeTestYear("Antarctica/Troll", [
		["2171-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2171-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2171-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2171-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2172" : helpers.makeTestYear("Antarctica/Troll", [
		["2172-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2172-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2172-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2172-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2173" : helpers.makeTestYear("Antarctica/Troll", [
		["2173-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2173-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2173-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2173-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2174" : helpers.makeTestYear("Antarctica/Troll", [
		["2174-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2174-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2174-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2174-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2175" : helpers.makeTestYear("Antarctica/Troll", [
		["2175-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2175-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2175-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2175-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2176" : helpers.makeTestYear("Antarctica/Troll", [
		["2176-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2176-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2176-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2176-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2177" : helpers.makeTestYear("Antarctica/Troll", [
		["2177-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2177-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2177-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2177-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2178" : helpers.makeTestYear("Antarctica/Troll", [
		["2178-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2178-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2178-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2178-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2179" : helpers.makeTestYear("Antarctica/Troll", [
		["2179-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2179-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2179-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2179-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2180" : helpers.makeTestYear("Antarctica/Troll", [
		["2180-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2180-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2180-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2180-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2181" : helpers.makeTestYear("Antarctica/Troll", [
		["2181-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2181-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2181-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2181-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2182" : helpers.makeTestYear("Antarctica/Troll", [
		["2182-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2182-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2182-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2182-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2183" : helpers.makeTestYear("Antarctica/Troll", [
		["2183-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2183-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2183-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2183-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2184" : helpers.makeTestYear("Antarctica/Troll", [
		["2184-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2184-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2184-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2184-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2185" : helpers.makeTestYear("Antarctica/Troll", [
		["2185-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2185-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2185-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2185-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2186" : helpers.makeTestYear("Antarctica/Troll", [
		["2186-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2186-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2186-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2186-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2187" : helpers.makeTestYear("Antarctica/Troll", [
		["2187-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2187-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2187-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2187-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2188" : helpers.makeTestYear("Antarctica/Troll", [
		["2188-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2188-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2188-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2188-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2189" : helpers.makeTestYear("Antarctica/Troll", [
		["2189-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2189-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2189-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2189-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2190" : helpers.makeTestYear("Antarctica/Troll", [
		["2190-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2190-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2190-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2190-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2191" : helpers.makeTestYear("Antarctica/Troll", [
		["2191-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2191-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2191-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2191-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2192" : helpers.makeTestYear("Antarctica/Troll", [
		["2192-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2192-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2192-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2192-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2193" : helpers.makeTestYear("Antarctica/Troll", [
		["2193-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2193-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2193-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2193-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2194" : helpers.makeTestYear("Antarctica/Troll", [
		["2194-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2194-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2194-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2194-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2195" : helpers.makeTestYear("Antarctica/Troll", [
		["2195-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2195-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2195-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2195-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2196" : helpers.makeTestYear("Antarctica/Troll", [
		["2196-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2196-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2196-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2196-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2197" : helpers.makeTestYear("Antarctica/Troll", [
		["2197-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2197-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2197-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2197-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2198" : helpers.makeTestYear("Antarctica/Troll", [
		["2198-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2198-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2198-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2198-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2199" : helpers.makeTestYear("Antarctica/Troll", [
		["2199-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2199-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2199-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2199-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2200" : helpers.makeTestYear("Antarctica/Troll", [
		["2200-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2200-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2200-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2200-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2201" : helpers.makeTestYear("Antarctica/Troll", [
		["2201-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2201-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2201-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2201-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2202" : helpers.makeTestYear("Antarctica/Troll", [
		["2202-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2202-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2202-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2202-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2203" : helpers.makeTestYear("Antarctica/Troll", [
		["2203-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2203-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2203-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2203-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2204" : helpers.makeTestYear("Antarctica/Troll", [
		["2204-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2204-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2204-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2204-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2205" : helpers.makeTestYear("Antarctica/Troll", [
		["2205-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2205-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2205-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2205-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2206" : helpers.makeTestYear("Antarctica/Troll", [
		["2206-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2206-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2206-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2206-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2207" : helpers.makeTestYear("Antarctica/Troll", [
		["2207-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2207-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2207-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2207-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2208" : helpers.makeTestYear("Antarctica/Troll", [
		["2208-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2208-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2208-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2208-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2209" : helpers.makeTestYear("Antarctica/Troll", [
		["2209-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2209-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2209-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2209-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2210" : helpers.makeTestYear("Antarctica/Troll", [
		["2210-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2210-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2210-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2210-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2211" : helpers.makeTestYear("Antarctica/Troll", [
		["2211-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2211-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2211-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2211-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2212" : helpers.makeTestYear("Antarctica/Troll", [
		["2212-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2212-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2212-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2212-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2213" : helpers.makeTestYear("Antarctica/Troll", [
		["2213-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2213-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2213-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2213-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2214" : helpers.makeTestYear("Antarctica/Troll", [
		["2214-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2214-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2214-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2214-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2215" : helpers.makeTestYear("Antarctica/Troll", [
		["2215-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2215-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2215-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2215-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2216" : helpers.makeTestYear("Antarctica/Troll", [
		["2216-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2216-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2216-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2216-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2217" : helpers.makeTestYear("Antarctica/Troll", [
		["2217-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2217-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2217-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2217-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2218" : helpers.makeTestYear("Antarctica/Troll", [
		["2218-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2218-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2218-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2218-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2219" : helpers.makeTestYear("Antarctica/Troll", [
		["2219-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2219-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2219-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2219-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2220" : helpers.makeTestYear("Antarctica/Troll", [
		["2220-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2220-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2220-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2220-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2221" : helpers.makeTestYear("Antarctica/Troll", [
		["2221-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2221-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2221-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2221-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2222" : helpers.makeTestYear("Antarctica/Troll", [
		["2222-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2222-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2222-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2222-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2223" : helpers.makeTestYear("Antarctica/Troll", [
		["2223-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2223-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2223-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2223-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2224" : helpers.makeTestYear("Antarctica/Troll", [
		["2224-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2224-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2224-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2224-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2225" : helpers.makeTestYear("Antarctica/Troll", [
		["2225-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2225-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2225-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2225-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2226" : helpers.makeTestYear("Antarctica/Troll", [
		["2226-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2226-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2226-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2226-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2227" : helpers.makeTestYear("Antarctica/Troll", [
		["2227-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2227-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2227-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2227-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2228" : helpers.makeTestYear("Antarctica/Troll", [
		["2228-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2228-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2228-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2228-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2229" : helpers.makeTestYear("Antarctica/Troll", [
		["2229-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2229-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2229-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2229-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2230" : helpers.makeTestYear("Antarctica/Troll", [
		["2230-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2230-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2230-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2230-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2231" : helpers.makeTestYear("Antarctica/Troll", [
		["2231-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2231-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2231-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2231-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2232" : helpers.makeTestYear("Antarctica/Troll", [
		["2232-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2232-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2232-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2232-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2233" : helpers.makeTestYear("Antarctica/Troll", [
		["2233-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2233-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2233-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2233-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2234" : helpers.makeTestYear("Antarctica/Troll", [
		["2234-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2234-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2234-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2234-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2235" : helpers.makeTestYear("Antarctica/Troll", [
		["2235-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2235-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2235-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2235-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2236" : helpers.makeTestYear("Antarctica/Troll", [
		["2236-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2236-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2236-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2236-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2237" : helpers.makeTestYear("Antarctica/Troll", [
		["2237-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2237-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2237-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2237-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2238" : helpers.makeTestYear("Antarctica/Troll", [
		["2238-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2238-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2238-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2238-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2239" : helpers.makeTestYear("Antarctica/Troll", [
		["2239-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2239-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2239-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2239-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2240" : helpers.makeTestYear("Antarctica/Troll", [
		["2240-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2240-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2240-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2240-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2241" : helpers.makeTestYear("Antarctica/Troll", [
		["2241-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2241-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2241-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2241-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2242" : helpers.makeTestYear("Antarctica/Troll", [
		["2242-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2242-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2242-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2242-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2243" : helpers.makeTestYear("Antarctica/Troll", [
		["2243-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2243-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2243-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2243-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2244" : helpers.makeTestYear("Antarctica/Troll", [
		["2244-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2244-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2244-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2244-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2245" : helpers.makeTestYear("Antarctica/Troll", [
		["2245-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2245-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2245-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2245-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2246" : helpers.makeTestYear("Antarctica/Troll", [
		["2246-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2246-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2246-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2246-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2247" : helpers.makeTestYear("Antarctica/Troll", [
		["2247-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2247-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2247-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2247-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2248" : helpers.makeTestYear("Antarctica/Troll", [
		["2248-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2248-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2248-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2248-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2249" : helpers.makeTestYear("Antarctica/Troll", [
		["2249-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2249-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2249-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2249-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2250" : helpers.makeTestYear("Antarctica/Troll", [
		["2250-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2250-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2250-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2250-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2251" : helpers.makeTestYear("Antarctica/Troll", [
		["2251-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2251-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2251-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2251-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2252" : helpers.makeTestYear("Antarctica/Troll", [
		["2252-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2252-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2252-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2252-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2253" : helpers.makeTestYear("Antarctica/Troll", [
		["2253-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2253-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2253-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2253-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2254" : helpers.makeTestYear("Antarctica/Troll", [
		["2254-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2254-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2254-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2254-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2255" : helpers.makeTestYear("Antarctica/Troll", [
		["2255-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2255-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2255-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2255-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2256" : helpers.makeTestYear("Antarctica/Troll", [
		["2256-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2256-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2256-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2256-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2257" : helpers.makeTestYear("Antarctica/Troll", [
		["2257-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2257-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2257-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2257-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2258" : helpers.makeTestYear("Antarctica/Troll", [
		["2258-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2258-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2258-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2258-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2259" : helpers.makeTestYear("Antarctica/Troll", [
		["2259-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2259-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2259-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2259-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2260" : helpers.makeTestYear("Antarctica/Troll", [
		["2260-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2260-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2260-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2260-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2261" : helpers.makeTestYear("Antarctica/Troll", [
		["2261-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2261-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2261-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2261-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2262" : helpers.makeTestYear("Antarctica/Troll", [
		["2262-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2262-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2262-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2262-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2263" : helpers.makeTestYear("Antarctica/Troll", [
		["2263-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2263-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2263-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2263-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2264" : helpers.makeTestYear("Antarctica/Troll", [
		["2264-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2264-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2264-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2264-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2265" : helpers.makeTestYear("Antarctica/Troll", [
		["2265-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2265-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2265-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2265-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2266" : helpers.makeTestYear("Antarctica/Troll", [
		["2266-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2266-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2266-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2266-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2267" : helpers.makeTestYear("Antarctica/Troll", [
		["2267-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2267-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2267-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2267-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2268" : helpers.makeTestYear("Antarctica/Troll", [
		["2268-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2268-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2268-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2268-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2269" : helpers.makeTestYear("Antarctica/Troll", [
		["2269-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2269-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2269-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2269-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2270" : helpers.makeTestYear("Antarctica/Troll", [
		["2270-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2270-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2270-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2270-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2271" : helpers.makeTestYear("Antarctica/Troll", [
		["2271-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2271-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2271-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2271-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2272" : helpers.makeTestYear("Antarctica/Troll", [
		["2272-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2272-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2272-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2272-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2273" : helpers.makeTestYear("Antarctica/Troll", [
		["2273-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2273-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2273-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2273-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2274" : helpers.makeTestYear("Antarctica/Troll", [
		["2274-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2274-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2274-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2274-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2275" : helpers.makeTestYear("Antarctica/Troll", [
		["2275-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2275-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2275-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2275-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2276" : helpers.makeTestYear("Antarctica/Troll", [
		["2276-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2276-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2276-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2276-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2277" : helpers.makeTestYear("Antarctica/Troll", [
		["2277-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2277-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2277-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2277-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2278" : helpers.makeTestYear("Antarctica/Troll", [
		["2278-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2278-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2278-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2278-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2279" : helpers.makeTestYear("Antarctica/Troll", [
		["2279-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2279-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2279-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2279-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2280" : helpers.makeTestYear("Antarctica/Troll", [
		["2280-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2280-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2280-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2280-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2281" : helpers.makeTestYear("Antarctica/Troll", [
		["2281-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2281-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2281-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2281-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2282" : helpers.makeTestYear("Antarctica/Troll", [
		["2282-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2282-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2282-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2282-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2283" : helpers.makeTestYear("Antarctica/Troll", [
		["2283-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2283-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2283-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2283-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2284" : helpers.makeTestYear("Antarctica/Troll", [
		["2284-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2284-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2284-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2284-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2285" : helpers.makeTestYear("Antarctica/Troll", [
		["2285-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2285-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2285-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2285-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2286" : helpers.makeTestYear("Antarctica/Troll", [
		["2286-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2286-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2286-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2286-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2287" : helpers.makeTestYear("Antarctica/Troll", [
		["2287-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2287-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2287-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2287-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2288" : helpers.makeTestYear("Antarctica/Troll", [
		["2288-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2288-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2288-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2288-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2289" : helpers.makeTestYear("Antarctica/Troll", [
		["2289-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2289-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2289-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2289-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2290" : helpers.makeTestYear("Antarctica/Troll", [
		["2290-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2290-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2290-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2290-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2291" : helpers.makeTestYear("Antarctica/Troll", [
		["2291-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2291-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2291-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2291-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2292" : helpers.makeTestYear("Antarctica/Troll", [
		["2292-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2292-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2292-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2292-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2293" : helpers.makeTestYear("Antarctica/Troll", [
		["2293-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2293-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2293-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2293-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2294" : helpers.makeTestYear("Antarctica/Troll", [
		["2294-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2294-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2294-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2294-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2295" : helpers.makeTestYear("Antarctica/Troll", [
		["2295-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2295-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2295-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2295-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2296" : helpers.makeTestYear("Antarctica/Troll", [
		["2296-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2296-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2296-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2296-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2297" : helpers.makeTestYear("Antarctica/Troll", [
		["2297-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2297-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2297-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2297-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2298" : helpers.makeTestYear("Antarctica/Troll", [
		["2298-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2298-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2298-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2298-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2299" : helpers.makeTestYear("Antarctica/Troll", [
		["2299-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2299-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2299-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2299-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2300" : helpers.makeTestYear("Antarctica/Troll", [
		["2300-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2300-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2300-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2300-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2301" : helpers.makeTestYear("Antarctica/Troll", [
		["2301-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2301-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2301-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2301-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2302" : helpers.makeTestYear("Antarctica/Troll", [
		["2302-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2302-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2302-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2302-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2303" : helpers.makeTestYear("Antarctica/Troll", [
		["2303-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2303-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2303-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2303-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2304" : helpers.makeTestYear("Antarctica/Troll", [
		["2304-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2304-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2304-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2304-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2305" : helpers.makeTestYear("Antarctica/Troll", [
		["2305-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2305-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2305-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2305-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2306" : helpers.makeTestYear("Antarctica/Troll", [
		["2306-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2306-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2306-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2306-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2307" : helpers.makeTestYear("Antarctica/Troll", [
		["2307-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2307-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2307-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2307-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2308" : helpers.makeTestYear("Antarctica/Troll", [
		["2308-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2308-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2308-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2308-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2309" : helpers.makeTestYear("Antarctica/Troll", [
		["2309-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2309-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2309-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2309-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2310" : helpers.makeTestYear("Antarctica/Troll", [
		["2310-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2310-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2310-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2310-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2311" : helpers.makeTestYear("Antarctica/Troll", [
		["2311-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2311-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2311-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2311-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2312" : helpers.makeTestYear("Antarctica/Troll", [
		["2312-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2312-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2312-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2312-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2313" : helpers.makeTestYear("Antarctica/Troll", [
		["2313-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2313-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2313-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2313-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2314" : helpers.makeTestYear("Antarctica/Troll", [
		["2314-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2314-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2314-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2314-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2315" : helpers.makeTestYear("Antarctica/Troll", [
		["2315-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2315-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2315-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2315-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2316" : helpers.makeTestYear("Antarctica/Troll", [
		["2316-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2316-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2316-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2316-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2317" : helpers.makeTestYear("Antarctica/Troll", [
		["2317-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2317-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2317-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2317-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2318" : helpers.makeTestYear("Antarctica/Troll", [
		["2318-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2318-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2318-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2318-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2319" : helpers.makeTestYear("Antarctica/Troll", [
		["2319-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2319-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2319-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2319-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2320" : helpers.makeTestYear("Antarctica/Troll", [
		["2320-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2320-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2320-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2320-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2321" : helpers.makeTestYear("Antarctica/Troll", [
		["2321-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2321-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2321-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2321-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2322" : helpers.makeTestYear("Antarctica/Troll", [
		["2322-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2322-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2322-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2322-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2323" : helpers.makeTestYear("Antarctica/Troll", [
		["2323-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2323-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2323-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2323-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2324" : helpers.makeTestYear("Antarctica/Troll", [
		["2324-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2324-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2324-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2324-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2325" : helpers.makeTestYear("Antarctica/Troll", [
		["2325-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2325-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2325-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2325-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2326" : helpers.makeTestYear("Antarctica/Troll", [
		["2326-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2326-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2326-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2326-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2327" : helpers.makeTestYear("Antarctica/Troll", [
		["2327-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2327-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2327-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2327-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2328" : helpers.makeTestYear("Antarctica/Troll", [
		["2328-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2328-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2328-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2328-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2329" : helpers.makeTestYear("Antarctica/Troll", [
		["2329-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2329-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2329-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2329-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2330" : helpers.makeTestYear("Antarctica/Troll", [
		["2330-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2330-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2330-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2330-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2331" : helpers.makeTestYear("Antarctica/Troll", [
		["2331-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2331-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2331-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2331-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2332" : helpers.makeTestYear("Antarctica/Troll", [
		["2332-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2332-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2332-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2332-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2333" : helpers.makeTestYear("Antarctica/Troll", [
		["2333-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2333-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2333-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2333-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2334" : helpers.makeTestYear("Antarctica/Troll", [
		["2334-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2334-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2334-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2334-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2335" : helpers.makeTestYear("Antarctica/Troll", [
		["2335-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2335-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2335-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2335-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2336" : helpers.makeTestYear("Antarctica/Troll", [
		["2336-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2336-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2336-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2336-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2337" : helpers.makeTestYear("Antarctica/Troll", [
		["2337-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2337-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2337-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2337-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2338" : helpers.makeTestYear("Antarctica/Troll", [
		["2338-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2338-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2338-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2338-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2339" : helpers.makeTestYear("Antarctica/Troll", [
		["2339-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2339-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2339-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2339-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2340" : helpers.makeTestYear("Antarctica/Troll", [
		["2340-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2340-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2340-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2340-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2341" : helpers.makeTestYear("Antarctica/Troll", [
		["2341-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2341-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2341-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2341-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2342" : helpers.makeTestYear("Antarctica/Troll", [
		["2342-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2342-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2342-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2342-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2343" : helpers.makeTestYear("Antarctica/Troll", [
		["2343-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2343-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2343-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2343-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2344" : helpers.makeTestYear("Antarctica/Troll", [
		["2344-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2344-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2344-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2344-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2345" : helpers.makeTestYear("Antarctica/Troll", [
		["2345-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2345-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2345-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2345-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2346" : helpers.makeTestYear("Antarctica/Troll", [
		["2346-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2346-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2346-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2346-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2347" : helpers.makeTestYear("Antarctica/Troll", [
		["2347-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2347-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2347-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2347-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2348" : helpers.makeTestYear("Antarctica/Troll", [
		["2348-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2348-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2348-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2348-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2349" : helpers.makeTestYear("Antarctica/Troll", [
		["2349-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2349-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2349-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2349-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2350" : helpers.makeTestYear("Antarctica/Troll", [
		["2350-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2350-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2350-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2350-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2351" : helpers.makeTestYear("Antarctica/Troll", [
		["2351-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2351-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2351-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2351-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2352" : helpers.makeTestYear("Antarctica/Troll", [
		["2352-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2352-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2352-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2352-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2353" : helpers.makeTestYear("Antarctica/Troll", [
		["2353-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2353-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2353-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2353-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2354" : helpers.makeTestYear("Antarctica/Troll", [
		["2354-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2354-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2354-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2354-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2355" : helpers.makeTestYear("Antarctica/Troll", [
		["2355-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2355-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2355-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2355-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2356" : helpers.makeTestYear("Antarctica/Troll", [
		["2356-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2356-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2356-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2356-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2357" : helpers.makeTestYear("Antarctica/Troll", [
		["2357-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2357-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2357-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2357-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2358" : helpers.makeTestYear("Antarctica/Troll", [
		["2358-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2358-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2358-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2358-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2359" : helpers.makeTestYear("Antarctica/Troll", [
		["2359-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2359-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2359-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2359-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2360" : helpers.makeTestYear("Antarctica/Troll", [
		["2360-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2360-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2360-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2360-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2361" : helpers.makeTestYear("Antarctica/Troll", [
		["2361-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2361-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2361-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2361-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2362" : helpers.makeTestYear("Antarctica/Troll", [
		["2362-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2362-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2362-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2362-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2363" : helpers.makeTestYear("Antarctica/Troll", [
		["2363-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2363-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2363-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2363-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2364" : helpers.makeTestYear("Antarctica/Troll", [
		["2364-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2364-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2364-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2364-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2365" : helpers.makeTestYear("Antarctica/Troll", [
		["2365-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2365-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2365-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2365-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2366" : helpers.makeTestYear("Antarctica/Troll", [
		["2366-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2366-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2366-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2366-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2367" : helpers.makeTestYear("Antarctica/Troll", [
		["2367-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2367-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2367-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2367-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2368" : helpers.makeTestYear("Antarctica/Troll", [
		["2368-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2368-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2368-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2368-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2369" : helpers.makeTestYear("Antarctica/Troll", [
		["2369-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2369-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2369-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2369-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2370" : helpers.makeTestYear("Antarctica/Troll", [
		["2370-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2370-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2370-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2370-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2371" : helpers.makeTestYear("Antarctica/Troll", [
		["2371-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2371-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2371-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2371-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2372" : helpers.makeTestYear("Antarctica/Troll", [
		["2372-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2372-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2372-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2372-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2373" : helpers.makeTestYear("Antarctica/Troll", [
		["2373-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2373-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2373-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2373-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2374" : helpers.makeTestYear("Antarctica/Troll", [
		["2374-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2374-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2374-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2374-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2375" : helpers.makeTestYear("Antarctica/Troll", [
		["2375-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2375-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2375-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2375-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2376" : helpers.makeTestYear("Antarctica/Troll", [
		["2376-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2376-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2376-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2376-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2377" : helpers.makeTestYear("Antarctica/Troll", [
		["2377-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2377-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2377-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2377-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2378" : helpers.makeTestYear("Antarctica/Troll", [
		["2378-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2378-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2378-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2378-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2379" : helpers.makeTestYear("Antarctica/Troll", [
		["2379-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2379-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2379-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2379-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2380" : helpers.makeTestYear("Antarctica/Troll", [
		["2380-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2380-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2380-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2380-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2381" : helpers.makeTestYear("Antarctica/Troll", [
		["2381-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2381-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2381-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2381-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2382" : helpers.makeTestYear("Antarctica/Troll", [
		["2382-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2382-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2382-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2382-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2383" : helpers.makeTestYear("Antarctica/Troll", [
		["2383-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2383-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2383-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2383-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2384" : helpers.makeTestYear("Antarctica/Troll", [
		["2384-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2384-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2384-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2384-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2385" : helpers.makeTestYear("Antarctica/Troll", [
		["2385-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2385-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2385-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2385-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2386" : helpers.makeTestYear("Antarctica/Troll", [
		["2386-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2386-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2386-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2386-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2387" : helpers.makeTestYear("Antarctica/Troll", [
		["2387-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2387-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2387-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2387-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2388" : helpers.makeTestYear("Antarctica/Troll", [
		["2388-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2388-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2388-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2388-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2389" : helpers.makeTestYear("Antarctica/Troll", [
		["2389-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2389-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2389-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2389-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2390" : helpers.makeTestYear("Antarctica/Troll", [
		["2390-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2390-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2390-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2390-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2391" : helpers.makeTestYear("Antarctica/Troll", [
		["2391-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2391-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2391-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2391-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2392" : helpers.makeTestYear("Antarctica/Troll", [
		["2392-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2392-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2392-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2392-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2393" : helpers.makeTestYear("Antarctica/Troll", [
		["2393-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2393-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2393-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2393-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2394" : helpers.makeTestYear("Antarctica/Troll", [
		["2394-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2394-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2394-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2394-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2395" : helpers.makeTestYear("Antarctica/Troll", [
		["2395-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2395-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2395-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2395-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2396" : helpers.makeTestYear("Antarctica/Troll", [
		["2396-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2396-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2396-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2396-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2397" : helpers.makeTestYear("Antarctica/Troll", [
		["2397-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2397-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2397-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2397-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2398" : helpers.makeTestYear("Antarctica/Troll", [
		["2398-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2398-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2398-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2398-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2399" : helpers.makeTestYear("Antarctica/Troll", [
		["2399-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2399-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2399-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2399-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2400" : helpers.makeTestYear("Antarctica/Troll", [
		["2400-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2400-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2400-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2400-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2401" : helpers.makeTestYear("Antarctica/Troll", [
		["2401-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2401-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2401-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2401-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2402" : helpers.makeTestYear("Antarctica/Troll", [
		["2402-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2402-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2402-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2402-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2403" : helpers.makeTestYear("Antarctica/Troll", [
		["2403-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2403-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2403-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2403-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2404" : helpers.makeTestYear("Antarctica/Troll", [
		["2404-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2404-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2404-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2404-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2405" : helpers.makeTestYear("Antarctica/Troll", [
		["2405-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2405-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2405-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2405-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2406" : helpers.makeTestYear("Antarctica/Troll", [
		["2406-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2406-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2406-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2406-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2407" : helpers.makeTestYear("Antarctica/Troll", [
		["2407-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2407-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2407-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2407-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2408" : helpers.makeTestYear("Antarctica/Troll", [
		["2408-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2408-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2408-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2408-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2409" : helpers.makeTestYear("Antarctica/Troll", [
		["2409-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2409-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2409-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2409-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2410" : helpers.makeTestYear("Antarctica/Troll", [
		["2410-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2410-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2410-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2410-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2411" : helpers.makeTestYear("Antarctica/Troll", [
		["2411-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2411-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2411-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2411-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2412" : helpers.makeTestYear("Antarctica/Troll", [
		["2412-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2412-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2412-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2412-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2413" : helpers.makeTestYear("Antarctica/Troll", [
		["2413-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2413-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2413-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2413-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2414" : helpers.makeTestYear("Antarctica/Troll", [
		["2414-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2414-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2414-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2414-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2415" : helpers.makeTestYear("Antarctica/Troll", [
		["2415-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2415-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2415-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2415-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2416" : helpers.makeTestYear("Antarctica/Troll", [
		["2416-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2416-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2416-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2416-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2417" : helpers.makeTestYear("Antarctica/Troll", [
		["2417-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2417-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2417-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2417-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2418" : helpers.makeTestYear("Antarctica/Troll", [
		["2418-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2418-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2418-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2418-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2419" : helpers.makeTestYear("Antarctica/Troll", [
		["2419-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2419-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2419-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2419-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2420" : helpers.makeTestYear("Antarctica/Troll", [
		["2420-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2420-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2420-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2420-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2421" : helpers.makeTestYear("Antarctica/Troll", [
		["2421-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2421-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2421-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2421-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2422" : helpers.makeTestYear("Antarctica/Troll", [
		["2422-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2422-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2422-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2422-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2423" : helpers.makeTestYear("Antarctica/Troll", [
		["2423-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2423-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2423-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2423-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2424" : helpers.makeTestYear("Antarctica/Troll", [
		["2424-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2424-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2424-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2424-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2425" : helpers.makeTestYear("Antarctica/Troll", [
		["2425-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2425-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2425-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2425-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2426" : helpers.makeTestYear("Antarctica/Troll", [
		["2426-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2426-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2426-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2426-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2427" : helpers.makeTestYear("Antarctica/Troll", [
		["2427-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2427-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2427-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2427-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2428" : helpers.makeTestYear("Antarctica/Troll", [
		["2428-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2428-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2428-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2428-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2429" : helpers.makeTestYear("Antarctica/Troll", [
		["2429-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2429-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2429-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2429-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2430" : helpers.makeTestYear("Antarctica/Troll", [
		["2430-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2430-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2430-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2430-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2431" : helpers.makeTestYear("Antarctica/Troll", [
		["2431-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2431-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2431-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2431-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2432" : helpers.makeTestYear("Antarctica/Troll", [
		["2432-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2432-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2432-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2432-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2433" : helpers.makeTestYear("Antarctica/Troll", [
		["2433-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2433-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2433-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2433-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2434" : helpers.makeTestYear("Antarctica/Troll", [
		["2434-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2434-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2434-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2434-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2435" : helpers.makeTestYear("Antarctica/Troll", [
		["2435-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2435-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2435-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2435-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2436" : helpers.makeTestYear("Antarctica/Troll", [
		["2436-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2436-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2436-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2436-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2437" : helpers.makeTestYear("Antarctica/Troll", [
		["2437-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2437-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2437-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2437-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2438" : helpers.makeTestYear("Antarctica/Troll", [
		["2438-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2438-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2438-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2438-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2439" : helpers.makeTestYear("Antarctica/Troll", [
		["2439-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2439-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2439-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2439-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2440" : helpers.makeTestYear("Antarctica/Troll", [
		["2440-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2440-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2440-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2440-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2441" : helpers.makeTestYear("Antarctica/Troll", [
		["2441-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2441-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2441-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2441-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2442" : helpers.makeTestYear("Antarctica/Troll", [
		["2442-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2442-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2442-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2442-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2443" : helpers.makeTestYear("Antarctica/Troll", [
		["2443-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2443-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2443-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2443-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2444" : helpers.makeTestYear("Antarctica/Troll", [
		["2444-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2444-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2444-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2444-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2445" : helpers.makeTestYear("Antarctica/Troll", [
		["2445-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2445-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2445-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2445-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2446" : helpers.makeTestYear("Antarctica/Troll", [
		["2446-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2446-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2446-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2446-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2447" : helpers.makeTestYear("Antarctica/Troll", [
		["2447-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2447-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2447-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2447-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2448" : helpers.makeTestYear("Antarctica/Troll", [
		["2448-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2448-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2448-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2448-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2449" : helpers.makeTestYear("Antarctica/Troll", [
		["2449-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2449-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2449-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2449-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2450" : helpers.makeTestYear("Antarctica/Troll", [
		["2450-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2450-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2450-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2450-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2451" : helpers.makeTestYear("Antarctica/Troll", [
		["2451-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2451-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2451-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2451-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2452" : helpers.makeTestYear("Antarctica/Troll", [
		["2452-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2452-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2452-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2452-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2453" : helpers.makeTestYear("Antarctica/Troll", [
		["2453-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2453-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2453-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2453-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2454" : helpers.makeTestYear("Antarctica/Troll", [
		["2454-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2454-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2454-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2454-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2455" : helpers.makeTestYear("Antarctica/Troll", [
		["2455-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2455-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2455-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2455-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2456" : helpers.makeTestYear("Antarctica/Troll", [
		["2456-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2456-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2456-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2456-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2457" : helpers.makeTestYear("Antarctica/Troll", [
		["2457-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2457-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2457-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2457-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2458" : helpers.makeTestYear("Antarctica/Troll", [
		["2458-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2458-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2458-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2458-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2459" : helpers.makeTestYear("Antarctica/Troll", [
		["2459-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2459-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2459-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2459-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2460" : helpers.makeTestYear("Antarctica/Troll", [
		["2460-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2460-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2460-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2460-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2461" : helpers.makeTestYear("Antarctica/Troll", [
		["2461-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2461-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2461-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2461-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2462" : helpers.makeTestYear("Antarctica/Troll", [
		["2462-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2462-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2462-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2462-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2463" : helpers.makeTestYear("Antarctica/Troll", [
		["2463-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2463-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2463-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2463-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2464" : helpers.makeTestYear("Antarctica/Troll", [
		["2464-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2464-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2464-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2464-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2465" : helpers.makeTestYear("Antarctica/Troll", [
		["2465-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2465-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2465-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2465-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2466" : helpers.makeTestYear("Antarctica/Troll", [
		["2466-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2466-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2466-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2466-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2467" : helpers.makeTestYear("Antarctica/Troll", [
		["2467-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2467-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2467-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2467-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2468" : helpers.makeTestYear("Antarctica/Troll", [
		["2468-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2468-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2468-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2468-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2469" : helpers.makeTestYear("Antarctica/Troll", [
		["2469-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2469-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2469-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2469-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2470" : helpers.makeTestYear("Antarctica/Troll", [
		["2470-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2470-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2470-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2470-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2471" : helpers.makeTestYear("Antarctica/Troll", [
		["2471-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2471-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2471-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2471-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2472" : helpers.makeTestYear("Antarctica/Troll", [
		["2472-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2472-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2472-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2472-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2473" : helpers.makeTestYear("Antarctica/Troll", [
		["2473-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2473-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2473-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2473-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2474" : helpers.makeTestYear("Antarctica/Troll", [
		["2474-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2474-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2474-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2474-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2475" : helpers.makeTestYear("Antarctica/Troll", [
		["2475-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2475-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2475-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2475-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2476" : helpers.makeTestYear("Antarctica/Troll", [
		["2476-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2476-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2476-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2476-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2477" : helpers.makeTestYear("Antarctica/Troll", [
		["2477-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2477-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2477-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2477-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2478" : helpers.makeTestYear("Antarctica/Troll", [
		["2478-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2478-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2478-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2478-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2479" : helpers.makeTestYear("Antarctica/Troll", [
		["2479-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2479-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2479-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2479-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2480" : helpers.makeTestYear("Antarctica/Troll", [
		["2480-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2480-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2480-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2480-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2481" : helpers.makeTestYear("Antarctica/Troll", [
		["2481-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2481-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2481-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2481-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2482" : helpers.makeTestYear("Antarctica/Troll", [
		["2482-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2482-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2482-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2482-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2483" : helpers.makeTestYear("Antarctica/Troll", [
		["2483-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2483-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2483-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2483-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2484" : helpers.makeTestYear("Antarctica/Troll", [
		["2484-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2484-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2484-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2484-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2485" : helpers.makeTestYear("Antarctica/Troll", [
		["2485-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2485-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2485-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2485-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2486" : helpers.makeTestYear("Antarctica/Troll", [
		["2486-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2486-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2486-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2486-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2487" : helpers.makeTestYear("Antarctica/Troll", [
		["2487-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2487-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2487-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2487-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2488" : helpers.makeTestYear("Antarctica/Troll", [
		["2488-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2488-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2488-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2488-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2489" : helpers.makeTestYear("Antarctica/Troll", [
		["2489-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2489-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2489-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2489-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2490" : helpers.makeTestYear("Antarctica/Troll", [
		["2490-03-26T00:59:59+00:00", "00:59:59", "+00", 0],
		["2490-03-26T01:00:00+00:00", "03:00:00", "+02", -120],
		["2490-10-29T00:59:59+00:00", "02:59:59", "+02", -120],
		["2490-10-29T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2491" : helpers.makeTestYear("Antarctica/Troll", [
		["2491-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2491-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2491-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2491-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2492" : helpers.makeTestYear("Antarctica/Troll", [
		["2492-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2492-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2492-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2492-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2493" : helpers.makeTestYear("Antarctica/Troll", [
		["2493-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2493-03-29T01:00:00+00:00", "03:00:00", "+02", -120],
		["2493-10-25T00:59:59+00:00", "02:59:59", "+02", -120],
		["2493-10-25T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2494" : helpers.makeTestYear("Antarctica/Troll", [
		["2494-03-28T00:59:59+00:00", "00:59:59", "+00", 0],
		["2494-03-28T01:00:00+00:00", "03:00:00", "+02", -120],
		["2494-10-31T00:59:59+00:00", "02:59:59", "+02", -120],
		["2494-10-31T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2495" : helpers.makeTestYear("Antarctica/Troll", [
		["2495-03-27T00:59:59+00:00", "00:59:59", "+00", 0],
		["2495-03-27T01:00:00+00:00", "03:00:00", "+02", -120],
		["2495-10-30T00:59:59+00:00", "02:59:59", "+02", -120],
		["2495-10-30T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2496" : helpers.makeTestYear("Antarctica/Troll", [
		["2496-03-25T00:59:59+00:00", "00:59:59", "+00", 0],
		["2496-03-25T01:00:00+00:00", "03:00:00", "+02", -120],
		["2496-10-28T00:59:59+00:00", "02:59:59", "+02", -120],
		["2496-10-28T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2497" : helpers.makeTestYear("Antarctica/Troll", [
		["2497-03-31T00:59:59+00:00", "00:59:59", "+00", 0],
		["2497-03-31T01:00:00+00:00", "03:00:00", "+02", -120],
		["2497-10-27T00:59:59+00:00", "02:59:59", "+02", -120],
		["2497-10-27T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2498" : helpers.makeTestYear("Antarctica/Troll", [
		["2498-03-30T00:59:59+00:00", "00:59:59", "+00", 0],
		["2498-03-30T01:00:00+00:00", "03:00:00", "+02", -120],
		["2498-10-26T00:59:59+00:00", "02:59:59", "+02", -120],
		["2498-10-26T01:00:00+00:00", "01:00:00", "+00", 0]
	]),

	"2499" : helpers.makeTestYear("Antarctica/Troll", [
		["2499-03-29T00:59:59+00:00", "00:59:59", "+00", 0],
		["2499-03-29T01:00:00+00:00", "03:00:00", "+02", -120]
	])
};