"use strict";

var helpers = require("../../helpers/helpers");

exports["Pacific/Apia"] = {

	"guess:by:offset" : helpers.makeTestGuess("Pacific/Apia", { offset: true }),

	"guess:by:abbr" : helpers.makeTestGuess("Pacific/Apia", { abbr: true }),

	"1911" : helpers.makeTestYear("Pacific/Apia", [
		["1911-01-01T11:26:55+00:00", "23:59:59", "LMT", 41216 / 60],
		["1911-01-01T11:26:56+00:00", "23:56:56", "-1130", 690]
	]),

	"1950" : helpers.makeTestYear("Pacific/Apia", [
		["1950-01-01T11:29:59+00:00", "23:59:59", "-1130", 690],
		["1950-01-01T11:30:00+00:00", "00:30:00", "-11", 660]
	]),

	"2010" : helpers.makeTestYear("Pacific/Apia", [
		["2010-09-26T10:59:59+00:00", "23:59:59", "-11", 660],
		["2010-09-26T11:00:00+00:00", "01:00:00", "-10", 600]
	]),

	"2011" : helpers.makeTestYear("Pacific/Apia", [
		["2011-04-02T13:59:59+00:00", "03:59:59", "-10", 600],
		["2011-04-02T14:00:00+00:00", "03:00:00", "-11", 660],
		["2011-09-24T13:59:59+00:00", "02:59:59", "-11", 660],
		["2011-09-24T14:00:00+00:00", "04:00:00", "-10", 600],
		["2011-12-30T09:59:59+00:00", "23:59:59", "-10", 600],
		["2011-12-30T10:00:00+00:00", "00:00:00", "+14", -840]
	]),

	"2012" : helpers.makeTestYear("Pacific/Apia", [
		["2012-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2012-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2012-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2012-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2013" : helpers.makeTestYear("Pacific/Apia", [
		["2013-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2013-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2013-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2013-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2014" : helpers.makeTestYear("Pacific/Apia", [
		["2014-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2014-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2014-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2014-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2015" : helpers.makeTestYear("Pacific/Apia", [
		["2015-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2015-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2015-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2015-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2016" : helpers.makeTestYear("Pacific/Apia", [
		["2016-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2016-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2016-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2016-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2017" : helpers.makeTestYear("Pacific/Apia", [
		["2017-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2017-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2017-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2017-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2018" : helpers.makeTestYear("Pacific/Apia", [
		["2018-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2018-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2018-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2018-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2019" : helpers.makeTestYear("Pacific/Apia", [
		["2019-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2019-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2019-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2019-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2020" : helpers.makeTestYear("Pacific/Apia", [
		["2020-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2020-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2020-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2020-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2021" : helpers.makeTestYear("Pacific/Apia", [
		["2021-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2021-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2021-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2021-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2022" : helpers.makeTestYear("Pacific/Apia", [
		["2022-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2022-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2022-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2022-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2023" : helpers.makeTestYear("Pacific/Apia", [
		["2023-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2023-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2023-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2023-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2024" : helpers.makeTestYear("Pacific/Apia", [
		["2024-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2024-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2024-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2024-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2025" : helpers.makeTestYear("Pacific/Apia", [
		["2025-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2025-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2025-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2025-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2026" : helpers.makeTestYear("Pacific/Apia", [
		["2026-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2026-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2026-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2026-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2027" : helpers.makeTestYear("Pacific/Apia", [
		["2027-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2027-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2027-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2027-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2028" : helpers.makeTestYear("Pacific/Apia", [
		["2028-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2028-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2028-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2028-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2029" : helpers.makeTestYear("Pacific/Apia", [
		["2029-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2029-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2029-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2029-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2030" : helpers.makeTestYear("Pacific/Apia", [
		["2030-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2030-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2030-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2030-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2031" : helpers.makeTestYear("Pacific/Apia", [
		["2031-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2031-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2031-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2031-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2032" : helpers.makeTestYear("Pacific/Apia", [
		["2032-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2032-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2032-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2032-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2033" : helpers.makeTestYear("Pacific/Apia", [
		["2033-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2033-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2033-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2033-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2034" : helpers.makeTestYear("Pacific/Apia", [
		["2034-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2034-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2034-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2034-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2035" : helpers.makeTestYear("Pacific/Apia", [
		["2035-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2035-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2035-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2035-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2036" : helpers.makeTestYear("Pacific/Apia", [
		["2036-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2036-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2036-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2036-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2037" : helpers.makeTestYear("Pacific/Apia", [
		["2037-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2037-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2037-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2037-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2038" : helpers.makeTestYear("Pacific/Apia", [
		["2038-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2038-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2038-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2038-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2039" : helpers.makeTestYear("Pacific/Apia", [
		["2039-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2039-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2039-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2039-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2040" : helpers.makeTestYear("Pacific/Apia", [
		["2040-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2040-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2040-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2040-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2041" : helpers.makeTestYear("Pacific/Apia", [
		["2041-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2041-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2041-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2041-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2042" : helpers.makeTestYear("Pacific/Apia", [
		["2042-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2042-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2042-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2042-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2043" : helpers.makeTestYear("Pacific/Apia", [
		["2043-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2043-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2043-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2043-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2044" : helpers.makeTestYear("Pacific/Apia", [
		["2044-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2044-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2044-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2044-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2045" : helpers.makeTestYear("Pacific/Apia", [
		["2045-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2045-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2045-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2045-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2046" : helpers.makeTestYear("Pacific/Apia", [
		["2046-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2046-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2046-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2046-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2047" : helpers.makeTestYear("Pacific/Apia", [
		["2047-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2047-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2047-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2047-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2048" : helpers.makeTestYear("Pacific/Apia", [
		["2048-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2048-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2048-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2048-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2049" : helpers.makeTestYear("Pacific/Apia", [
		["2049-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2049-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2049-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2049-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2050" : helpers.makeTestYear("Pacific/Apia", [
		["2050-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2050-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2050-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2050-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2051" : helpers.makeTestYear("Pacific/Apia", [
		["2051-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2051-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2051-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2051-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2052" : helpers.makeTestYear("Pacific/Apia", [
		["2052-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2052-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2052-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2052-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2053" : helpers.makeTestYear("Pacific/Apia", [
		["2053-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2053-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2053-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2053-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2054" : helpers.makeTestYear("Pacific/Apia", [
		["2054-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2054-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2054-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2054-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2055" : helpers.makeTestYear("Pacific/Apia", [
		["2055-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2055-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2055-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2055-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2056" : helpers.makeTestYear("Pacific/Apia", [
		["2056-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2056-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2056-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2056-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2057" : helpers.makeTestYear("Pacific/Apia", [
		["2057-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2057-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2057-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2057-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2058" : helpers.makeTestYear("Pacific/Apia", [
		["2058-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2058-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2058-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2058-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2059" : helpers.makeTestYear("Pacific/Apia", [
		["2059-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2059-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2059-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2059-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2060" : helpers.makeTestYear("Pacific/Apia", [
		["2060-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2060-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2060-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2060-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2061" : helpers.makeTestYear("Pacific/Apia", [
		["2061-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2061-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2061-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2061-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2062" : helpers.makeTestYear("Pacific/Apia", [
		["2062-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2062-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2062-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2062-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2063" : helpers.makeTestYear("Pacific/Apia", [
		["2063-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2063-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2063-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2063-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2064" : helpers.makeTestYear("Pacific/Apia", [
		["2064-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2064-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2064-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2064-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2065" : helpers.makeTestYear("Pacific/Apia", [
		["2065-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2065-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2065-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2065-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2066" : helpers.makeTestYear("Pacific/Apia", [
		["2066-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2066-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2066-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2066-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2067" : helpers.makeTestYear("Pacific/Apia", [
		["2067-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2067-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2067-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2067-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2068" : helpers.makeTestYear("Pacific/Apia", [
		["2068-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2068-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2068-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2068-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2069" : helpers.makeTestYear("Pacific/Apia", [
		["2069-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2069-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2069-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2069-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2070" : helpers.makeTestYear("Pacific/Apia", [
		["2070-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2070-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2070-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2070-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2071" : helpers.makeTestYear("Pacific/Apia", [
		["2071-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2071-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2071-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2071-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2072" : helpers.makeTestYear("Pacific/Apia", [
		["2072-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2072-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2072-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2072-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2073" : helpers.makeTestYear("Pacific/Apia", [
		["2073-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2073-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2073-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2073-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2074" : helpers.makeTestYear("Pacific/Apia", [
		["2074-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2074-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2074-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2074-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2075" : helpers.makeTestYear("Pacific/Apia", [
		["2075-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2075-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2075-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2075-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2076" : helpers.makeTestYear("Pacific/Apia", [
		["2076-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2076-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2076-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2076-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2077" : helpers.makeTestYear("Pacific/Apia", [
		["2077-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2077-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2077-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2077-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2078" : helpers.makeTestYear("Pacific/Apia", [
		["2078-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2078-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2078-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2078-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2079" : helpers.makeTestYear("Pacific/Apia", [
		["2079-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2079-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2079-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2079-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2080" : helpers.makeTestYear("Pacific/Apia", [
		["2080-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2080-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2080-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2080-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2081" : helpers.makeTestYear("Pacific/Apia", [
		["2081-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2081-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2081-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2081-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2082" : helpers.makeTestYear("Pacific/Apia", [
		["2082-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2082-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2082-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2082-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2083" : helpers.makeTestYear("Pacific/Apia", [
		["2083-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2083-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2083-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2083-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2084" : helpers.makeTestYear("Pacific/Apia", [
		["2084-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2084-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2084-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2084-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2085" : helpers.makeTestYear("Pacific/Apia", [
		["2085-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2085-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2085-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2085-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2086" : helpers.makeTestYear("Pacific/Apia", [
		["2086-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2086-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2086-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2086-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2087" : helpers.makeTestYear("Pacific/Apia", [
		["2087-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2087-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2087-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2087-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2088" : helpers.makeTestYear("Pacific/Apia", [
		["2088-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2088-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2088-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2088-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2089" : helpers.makeTestYear("Pacific/Apia", [
		["2089-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2089-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2089-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2089-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2090" : helpers.makeTestYear("Pacific/Apia", [
		["2090-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2090-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2090-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2090-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2091" : helpers.makeTestYear("Pacific/Apia", [
		["2091-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2091-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2091-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2091-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2092" : helpers.makeTestYear("Pacific/Apia", [
		["2092-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2092-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2092-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2092-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2093" : helpers.makeTestYear("Pacific/Apia", [
		["2093-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2093-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2093-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2093-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2094" : helpers.makeTestYear("Pacific/Apia", [
		["2094-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2094-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2094-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2094-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2095" : helpers.makeTestYear("Pacific/Apia", [
		["2095-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2095-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2095-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2095-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2096" : helpers.makeTestYear("Pacific/Apia", [
		["2096-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2096-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2096-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2096-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2097" : helpers.makeTestYear("Pacific/Apia", [
		["2097-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2097-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2097-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2097-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2098" : helpers.makeTestYear("Pacific/Apia", [
		["2098-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2098-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2098-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2098-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2099" : helpers.makeTestYear("Pacific/Apia", [
		["2099-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2099-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2099-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2099-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2100" : helpers.makeTestYear("Pacific/Apia", [
		["2100-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2100-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2100-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2100-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2101" : helpers.makeTestYear("Pacific/Apia", [
		["2101-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2101-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2101-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2101-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2102" : helpers.makeTestYear("Pacific/Apia", [
		["2102-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2102-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2102-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2102-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2103" : helpers.makeTestYear("Pacific/Apia", [
		["2103-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2103-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2103-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2103-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2104" : helpers.makeTestYear("Pacific/Apia", [
		["2104-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2104-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2104-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2104-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2105" : helpers.makeTestYear("Pacific/Apia", [
		["2105-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2105-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2105-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2105-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2106" : helpers.makeTestYear("Pacific/Apia", [
		["2106-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2106-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2106-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2106-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2107" : helpers.makeTestYear("Pacific/Apia", [
		["2107-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2107-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2107-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2107-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2108" : helpers.makeTestYear("Pacific/Apia", [
		["2108-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2108-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2108-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2108-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2109" : helpers.makeTestYear("Pacific/Apia", [
		["2109-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2109-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2109-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2109-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2110" : helpers.makeTestYear("Pacific/Apia", [
		["2110-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2110-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2110-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2110-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2111" : helpers.makeTestYear("Pacific/Apia", [
		["2111-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2111-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2111-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2111-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2112" : helpers.makeTestYear("Pacific/Apia", [
		["2112-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2112-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2112-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2112-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2113" : helpers.makeTestYear("Pacific/Apia", [
		["2113-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2113-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2113-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2113-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2114" : helpers.makeTestYear("Pacific/Apia", [
		["2114-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2114-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2114-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2114-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2115" : helpers.makeTestYear("Pacific/Apia", [
		["2115-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2115-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2115-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2115-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2116" : helpers.makeTestYear("Pacific/Apia", [
		["2116-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2116-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2116-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2116-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2117" : helpers.makeTestYear("Pacific/Apia", [
		["2117-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2117-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2117-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2117-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2118" : helpers.makeTestYear("Pacific/Apia", [
		["2118-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2118-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2118-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2118-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2119" : helpers.makeTestYear("Pacific/Apia", [
		["2119-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2119-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2119-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2119-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2120" : helpers.makeTestYear("Pacific/Apia", [
		["2120-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2120-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2120-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2120-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2121" : helpers.makeTestYear("Pacific/Apia", [
		["2121-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2121-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2121-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2121-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2122" : helpers.makeTestYear("Pacific/Apia", [
		["2122-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2122-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2122-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2122-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2123" : helpers.makeTestYear("Pacific/Apia", [
		["2123-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2123-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2123-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2123-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2124" : helpers.makeTestYear("Pacific/Apia", [
		["2124-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2124-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2124-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2124-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2125" : helpers.makeTestYear("Pacific/Apia", [
		["2125-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2125-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2125-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2125-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2126" : helpers.makeTestYear("Pacific/Apia", [
		["2126-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2126-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2126-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2126-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2127" : helpers.makeTestYear("Pacific/Apia", [
		["2127-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2127-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2127-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2127-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2128" : helpers.makeTestYear("Pacific/Apia", [
		["2128-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2128-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2128-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2128-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2129" : helpers.makeTestYear("Pacific/Apia", [
		["2129-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2129-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2129-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2129-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2130" : helpers.makeTestYear("Pacific/Apia", [
		["2130-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2130-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2130-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2130-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2131" : helpers.makeTestYear("Pacific/Apia", [
		["2131-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2131-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2131-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2131-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2132" : helpers.makeTestYear("Pacific/Apia", [
		["2132-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2132-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2132-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2132-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2133" : helpers.makeTestYear("Pacific/Apia", [
		["2133-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2133-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2133-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2133-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2134" : helpers.makeTestYear("Pacific/Apia", [
		["2134-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2134-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2134-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2134-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2135" : helpers.makeTestYear("Pacific/Apia", [
		["2135-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2135-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2135-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2135-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2136" : helpers.makeTestYear("Pacific/Apia", [
		["2136-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2136-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2136-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2136-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2137" : helpers.makeTestYear("Pacific/Apia", [
		["2137-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2137-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2137-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2137-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2138" : helpers.makeTestYear("Pacific/Apia", [
		["2138-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2138-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2138-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2138-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2139" : helpers.makeTestYear("Pacific/Apia", [
		["2139-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2139-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2139-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2139-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2140" : helpers.makeTestYear("Pacific/Apia", [
		["2140-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2140-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2140-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2140-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2141" : helpers.makeTestYear("Pacific/Apia", [
		["2141-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2141-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2141-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2141-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2142" : helpers.makeTestYear("Pacific/Apia", [
		["2142-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2142-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2142-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2142-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2143" : helpers.makeTestYear("Pacific/Apia", [
		["2143-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2143-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2143-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2143-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2144" : helpers.makeTestYear("Pacific/Apia", [
		["2144-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2144-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2144-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2144-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2145" : helpers.makeTestYear("Pacific/Apia", [
		["2145-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2145-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2145-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2145-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2146" : helpers.makeTestYear("Pacific/Apia", [
		["2146-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2146-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2146-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2146-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2147" : helpers.makeTestYear("Pacific/Apia", [
		["2147-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2147-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2147-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2147-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2148" : helpers.makeTestYear("Pacific/Apia", [
		["2148-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2148-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2148-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2148-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2149" : helpers.makeTestYear("Pacific/Apia", [
		["2149-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2149-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2149-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2149-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2150" : helpers.makeTestYear("Pacific/Apia", [
		["2150-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2150-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2150-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2150-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2151" : helpers.makeTestYear("Pacific/Apia", [
		["2151-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2151-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2151-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2151-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2152" : helpers.makeTestYear("Pacific/Apia", [
		["2152-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2152-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2152-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2152-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2153" : helpers.makeTestYear("Pacific/Apia", [
		["2153-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2153-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2153-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2153-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2154" : helpers.makeTestYear("Pacific/Apia", [
		["2154-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2154-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2154-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2154-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2155" : helpers.makeTestYear("Pacific/Apia", [
		["2155-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2155-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2155-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2155-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2156" : helpers.makeTestYear("Pacific/Apia", [
		["2156-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2156-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2156-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2156-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2157" : helpers.makeTestYear("Pacific/Apia", [
		["2157-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2157-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2157-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2157-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2158" : helpers.makeTestYear("Pacific/Apia", [
		["2158-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2158-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2158-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2158-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2159" : helpers.makeTestYear("Pacific/Apia", [
		["2159-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2159-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2159-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2159-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2160" : helpers.makeTestYear("Pacific/Apia", [
		["2160-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2160-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2160-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2160-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2161" : helpers.makeTestYear("Pacific/Apia", [
		["2161-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2161-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2161-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2161-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2162" : helpers.makeTestYear("Pacific/Apia", [
		["2162-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2162-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2162-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2162-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2163" : helpers.makeTestYear("Pacific/Apia", [
		["2163-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2163-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2163-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2163-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2164" : helpers.makeTestYear("Pacific/Apia", [
		["2164-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2164-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2164-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2164-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2165" : helpers.makeTestYear("Pacific/Apia", [
		["2165-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2165-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2165-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2165-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2166" : helpers.makeTestYear("Pacific/Apia", [
		["2166-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2166-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2166-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2166-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2167" : helpers.makeTestYear("Pacific/Apia", [
		["2167-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2167-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2167-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2167-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2168" : helpers.makeTestYear("Pacific/Apia", [
		["2168-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2168-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2168-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2168-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2169" : helpers.makeTestYear("Pacific/Apia", [
		["2169-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2169-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2169-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2169-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2170" : helpers.makeTestYear("Pacific/Apia", [
		["2170-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2170-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2170-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2170-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2171" : helpers.makeTestYear("Pacific/Apia", [
		["2171-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2171-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2171-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2171-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2172" : helpers.makeTestYear("Pacific/Apia", [
		["2172-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2172-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2172-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2172-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2173" : helpers.makeTestYear("Pacific/Apia", [
		["2173-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2173-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2173-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2173-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2174" : helpers.makeTestYear("Pacific/Apia", [
		["2174-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2174-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2174-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2174-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2175" : helpers.makeTestYear("Pacific/Apia", [
		["2175-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2175-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2175-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2175-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2176" : helpers.makeTestYear("Pacific/Apia", [
		["2176-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2176-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2176-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2176-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2177" : helpers.makeTestYear("Pacific/Apia", [
		["2177-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2177-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2177-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2177-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2178" : helpers.makeTestYear("Pacific/Apia", [
		["2178-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2178-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2178-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2178-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2179" : helpers.makeTestYear("Pacific/Apia", [
		["2179-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2179-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2179-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2179-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2180" : helpers.makeTestYear("Pacific/Apia", [
		["2180-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2180-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2180-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2180-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2181" : helpers.makeTestYear("Pacific/Apia", [
		["2181-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2181-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2181-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2181-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2182" : helpers.makeTestYear("Pacific/Apia", [
		["2182-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2182-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2182-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2182-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2183" : helpers.makeTestYear("Pacific/Apia", [
		["2183-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2183-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2183-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2183-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2184" : helpers.makeTestYear("Pacific/Apia", [
		["2184-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2184-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2184-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2184-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2185" : helpers.makeTestYear("Pacific/Apia", [
		["2185-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2185-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2185-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2185-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2186" : helpers.makeTestYear("Pacific/Apia", [
		["2186-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2186-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2186-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2186-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2187" : helpers.makeTestYear("Pacific/Apia", [
		["2187-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2187-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2187-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2187-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2188" : helpers.makeTestYear("Pacific/Apia", [
		["2188-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2188-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2188-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2188-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2189" : helpers.makeTestYear("Pacific/Apia", [
		["2189-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2189-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2189-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2189-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2190" : helpers.makeTestYear("Pacific/Apia", [
		["2190-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2190-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2190-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2190-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2191" : helpers.makeTestYear("Pacific/Apia", [
		["2191-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2191-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2191-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2191-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2192" : helpers.makeTestYear("Pacific/Apia", [
		["2192-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2192-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2192-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2192-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2193" : helpers.makeTestYear("Pacific/Apia", [
		["2193-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2193-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2193-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2193-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2194" : helpers.makeTestYear("Pacific/Apia", [
		["2194-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2194-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2194-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2194-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2195" : helpers.makeTestYear("Pacific/Apia", [
		["2195-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2195-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2195-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2195-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2196" : helpers.makeTestYear("Pacific/Apia", [
		["2196-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2196-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2196-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2196-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2197" : helpers.makeTestYear("Pacific/Apia", [
		["2197-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2197-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2197-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2197-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2198" : helpers.makeTestYear("Pacific/Apia", [
		["2198-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2198-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2198-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2198-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2199" : helpers.makeTestYear("Pacific/Apia", [
		["2199-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2199-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2199-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2199-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2200" : helpers.makeTestYear("Pacific/Apia", [
		["2200-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2200-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2200-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2200-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2201" : helpers.makeTestYear("Pacific/Apia", [
		["2201-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2201-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2201-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2201-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2202" : helpers.makeTestYear("Pacific/Apia", [
		["2202-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2202-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2202-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2202-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2203" : helpers.makeTestYear("Pacific/Apia", [
		["2203-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2203-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2203-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2203-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2204" : helpers.makeTestYear("Pacific/Apia", [
		["2204-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2204-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2204-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2204-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2205" : helpers.makeTestYear("Pacific/Apia", [
		["2205-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2205-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2205-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2205-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2206" : helpers.makeTestYear("Pacific/Apia", [
		["2206-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2206-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2206-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2206-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2207" : helpers.makeTestYear("Pacific/Apia", [
		["2207-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2207-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2207-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2207-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2208" : helpers.makeTestYear("Pacific/Apia", [
		["2208-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2208-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2208-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2208-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2209" : helpers.makeTestYear("Pacific/Apia", [
		["2209-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2209-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2209-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2209-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2210" : helpers.makeTestYear("Pacific/Apia", [
		["2210-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2210-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2210-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2210-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2211" : helpers.makeTestYear("Pacific/Apia", [
		["2211-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2211-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2211-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2211-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2212" : helpers.makeTestYear("Pacific/Apia", [
		["2212-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2212-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2212-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2212-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2213" : helpers.makeTestYear("Pacific/Apia", [
		["2213-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2213-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2213-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2213-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2214" : helpers.makeTestYear("Pacific/Apia", [
		["2214-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2214-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2214-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2214-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2215" : helpers.makeTestYear("Pacific/Apia", [
		["2215-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2215-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2215-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2215-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2216" : helpers.makeTestYear("Pacific/Apia", [
		["2216-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2216-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2216-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2216-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2217" : helpers.makeTestYear("Pacific/Apia", [
		["2217-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2217-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2217-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2217-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2218" : helpers.makeTestYear("Pacific/Apia", [
		["2218-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2218-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2218-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2218-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2219" : helpers.makeTestYear("Pacific/Apia", [
		["2219-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2219-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2219-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2219-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2220" : helpers.makeTestYear("Pacific/Apia", [
		["2220-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2220-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2220-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2220-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2221" : helpers.makeTestYear("Pacific/Apia", [
		["2221-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2221-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2221-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2221-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2222" : helpers.makeTestYear("Pacific/Apia", [
		["2222-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2222-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2222-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2222-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2223" : helpers.makeTestYear("Pacific/Apia", [
		["2223-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2223-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2223-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2223-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2224" : helpers.makeTestYear("Pacific/Apia", [
		["2224-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2224-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2224-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2224-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2225" : helpers.makeTestYear("Pacific/Apia", [
		["2225-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2225-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2225-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2225-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2226" : helpers.makeTestYear("Pacific/Apia", [
		["2226-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2226-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2226-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2226-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2227" : helpers.makeTestYear("Pacific/Apia", [
		["2227-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2227-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2227-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2227-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2228" : helpers.makeTestYear("Pacific/Apia", [
		["2228-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2228-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2228-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2228-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2229" : helpers.makeTestYear("Pacific/Apia", [
		["2229-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2229-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2229-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2229-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2230" : helpers.makeTestYear("Pacific/Apia", [
		["2230-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2230-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2230-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2230-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2231" : helpers.makeTestYear("Pacific/Apia", [
		["2231-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2231-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2231-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2231-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2232" : helpers.makeTestYear("Pacific/Apia", [
		["2232-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2232-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2232-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2232-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2233" : helpers.makeTestYear("Pacific/Apia", [
		["2233-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2233-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2233-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2233-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2234" : helpers.makeTestYear("Pacific/Apia", [
		["2234-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2234-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2234-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2234-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2235" : helpers.makeTestYear("Pacific/Apia", [
		["2235-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2235-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2235-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2235-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2236" : helpers.makeTestYear("Pacific/Apia", [
		["2236-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2236-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2236-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2236-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2237" : helpers.makeTestYear("Pacific/Apia", [
		["2237-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2237-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2237-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2237-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2238" : helpers.makeTestYear("Pacific/Apia", [
		["2238-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2238-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2238-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2238-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2239" : helpers.makeTestYear("Pacific/Apia", [
		["2239-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2239-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2239-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2239-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2240" : helpers.makeTestYear("Pacific/Apia", [
		["2240-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2240-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2240-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2240-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2241" : helpers.makeTestYear("Pacific/Apia", [
		["2241-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2241-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2241-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2241-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2242" : helpers.makeTestYear("Pacific/Apia", [
		["2242-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2242-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2242-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2242-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2243" : helpers.makeTestYear("Pacific/Apia", [
		["2243-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2243-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2243-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2243-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2244" : helpers.makeTestYear("Pacific/Apia", [
		["2244-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2244-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2244-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2244-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2245" : helpers.makeTestYear("Pacific/Apia", [
		["2245-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2245-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2245-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2245-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2246" : helpers.makeTestYear("Pacific/Apia", [
		["2246-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2246-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2246-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2246-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2247" : helpers.makeTestYear("Pacific/Apia", [
		["2247-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2247-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2247-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2247-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2248" : helpers.makeTestYear("Pacific/Apia", [
		["2248-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2248-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2248-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2248-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2249" : helpers.makeTestYear("Pacific/Apia", [
		["2249-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2249-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2249-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2249-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2250" : helpers.makeTestYear("Pacific/Apia", [
		["2250-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2250-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2250-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2250-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2251" : helpers.makeTestYear("Pacific/Apia", [
		["2251-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2251-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2251-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2251-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2252" : helpers.makeTestYear("Pacific/Apia", [
		["2252-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2252-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2252-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2252-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2253" : helpers.makeTestYear("Pacific/Apia", [
		["2253-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2253-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2253-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2253-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2254" : helpers.makeTestYear("Pacific/Apia", [
		["2254-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2254-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2254-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2254-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2255" : helpers.makeTestYear("Pacific/Apia", [
		["2255-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2255-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2255-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2255-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2256" : helpers.makeTestYear("Pacific/Apia", [
		["2256-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2256-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2256-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2256-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2257" : helpers.makeTestYear("Pacific/Apia", [
		["2257-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2257-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2257-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2257-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2258" : helpers.makeTestYear("Pacific/Apia", [
		["2258-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2258-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2258-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2258-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2259" : helpers.makeTestYear("Pacific/Apia", [
		["2259-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2259-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2259-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2259-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2260" : helpers.makeTestYear("Pacific/Apia", [
		["2260-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2260-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2260-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2260-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2261" : helpers.makeTestYear("Pacific/Apia", [
		["2261-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2261-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2261-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2261-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2262" : helpers.makeTestYear("Pacific/Apia", [
		["2262-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2262-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2262-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2262-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2263" : helpers.makeTestYear("Pacific/Apia", [
		["2263-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2263-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2263-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2263-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2264" : helpers.makeTestYear("Pacific/Apia", [
		["2264-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2264-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2264-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2264-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2265" : helpers.makeTestYear("Pacific/Apia", [
		["2265-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2265-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2265-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2265-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2266" : helpers.makeTestYear("Pacific/Apia", [
		["2266-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2266-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2266-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2266-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2267" : helpers.makeTestYear("Pacific/Apia", [
		["2267-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2267-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2267-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2267-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2268" : helpers.makeTestYear("Pacific/Apia", [
		["2268-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2268-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2268-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2268-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2269" : helpers.makeTestYear("Pacific/Apia", [
		["2269-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2269-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2269-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2269-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2270" : helpers.makeTestYear("Pacific/Apia", [
		["2270-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2270-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2270-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2270-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2271" : helpers.makeTestYear("Pacific/Apia", [
		["2271-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2271-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2271-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2271-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2272" : helpers.makeTestYear("Pacific/Apia", [
		["2272-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2272-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2272-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2272-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2273" : helpers.makeTestYear("Pacific/Apia", [
		["2273-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2273-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2273-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2273-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2274" : helpers.makeTestYear("Pacific/Apia", [
		["2274-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2274-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2274-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2274-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2275" : helpers.makeTestYear("Pacific/Apia", [
		["2275-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2275-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2275-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2275-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2276" : helpers.makeTestYear("Pacific/Apia", [
		["2276-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2276-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2276-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2276-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2277" : helpers.makeTestYear("Pacific/Apia", [
		["2277-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2277-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2277-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2277-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2278" : helpers.makeTestYear("Pacific/Apia", [
		["2278-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2278-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2278-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2278-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2279" : helpers.makeTestYear("Pacific/Apia", [
		["2279-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2279-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2279-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2279-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2280" : helpers.makeTestYear("Pacific/Apia", [
		["2280-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2280-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2280-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2280-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2281" : helpers.makeTestYear("Pacific/Apia", [
		["2281-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2281-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2281-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2281-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2282" : helpers.makeTestYear("Pacific/Apia", [
		["2282-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2282-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2282-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2282-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2283" : helpers.makeTestYear("Pacific/Apia", [
		["2283-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2283-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2283-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2283-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2284" : helpers.makeTestYear("Pacific/Apia", [
		["2284-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2284-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2284-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2284-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2285" : helpers.makeTestYear("Pacific/Apia", [
		["2285-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2285-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2285-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2285-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2286" : helpers.makeTestYear("Pacific/Apia", [
		["2286-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2286-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2286-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2286-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2287" : helpers.makeTestYear("Pacific/Apia", [
		["2287-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2287-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2287-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2287-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2288" : helpers.makeTestYear("Pacific/Apia", [
		["2288-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2288-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2288-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2288-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2289" : helpers.makeTestYear("Pacific/Apia", [
		["2289-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2289-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2289-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2289-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2290" : helpers.makeTestYear("Pacific/Apia", [
		["2290-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2290-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2290-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2290-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2291" : helpers.makeTestYear("Pacific/Apia", [
		["2291-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2291-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2291-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2291-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2292" : helpers.makeTestYear("Pacific/Apia", [
		["2292-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2292-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2292-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2292-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2293" : helpers.makeTestYear("Pacific/Apia", [
		["2293-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2293-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2293-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2293-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2294" : helpers.makeTestYear("Pacific/Apia", [
		["2294-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2294-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2294-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2294-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2295" : helpers.makeTestYear("Pacific/Apia", [
		["2295-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2295-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2295-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2295-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2296" : helpers.makeTestYear("Pacific/Apia", [
		["2296-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2296-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2296-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2296-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2297" : helpers.makeTestYear("Pacific/Apia", [
		["2297-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2297-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2297-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2297-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2298" : helpers.makeTestYear("Pacific/Apia", [
		["2298-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2298-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2298-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2298-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2299" : helpers.makeTestYear("Pacific/Apia", [
		["2299-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2299-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2299-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2299-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2300" : helpers.makeTestYear("Pacific/Apia", [
		["2300-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2300-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2300-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2300-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2301" : helpers.makeTestYear("Pacific/Apia", [
		["2301-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2301-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2301-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2301-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2302" : helpers.makeTestYear("Pacific/Apia", [
		["2302-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2302-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2302-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2302-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2303" : helpers.makeTestYear("Pacific/Apia", [
		["2303-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2303-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2303-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2303-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2304" : helpers.makeTestYear("Pacific/Apia", [
		["2304-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2304-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2304-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2304-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2305" : helpers.makeTestYear("Pacific/Apia", [
		["2305-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2305-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2305-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2305-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2306" : helpers.makeTestYear("Pacific/Apia", [
		["2306-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2306-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2306-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2306-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2307" : helpers.makeTestYear("Pacific/Apia", [
		["2307-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2307-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2307-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2307-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2308" : helpers.makeTestYear("Pacific/Apia", [
		["2308-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2308-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2308-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2308-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2309" : helpers.makeTestYear("Pacific/Apia", [
		["2309-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2309-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2309-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2309-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2310" : helpers.makeTestYear("Pacific/Apia", [
		["2310-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2310-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2310-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2310-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2311" : helpers.makeTestYear("Pacific/Apia", [
		["2311-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2311-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2311-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2311-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2312" : helpers.makeTestYear("Pacific/Apia", [
		["2312-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2312-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2312-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2312-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2313" : helpers.makeTestYear("Pacific/Apia", [
		["2313-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2313-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2313-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2313-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2314" : helpers.makeTestYear("Pacific/Apia", [
		["2314-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2314-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2314-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2314-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2315" : helpers.makeTestYear("Pacific/Apia", [
		["2315-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2315-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2315-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2315-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2316" : helpers.makeTestYear("Pacific/Apia", [
		["2316-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2316-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2316-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2316-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2317" : helpers.makeTestYear("Pacific/Apia", [
		["2317-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2317-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2317-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2317-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2318" : helpers.makeTestYear("Pacific/Apia", [
		["2318-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2318-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2318-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2318-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2319" : helpers.makeTestYear("Pacific/Apia", [
		["2319-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2319-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2319-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2319-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2320" : helpers.makeTestYear("Pacific/Apia", [
		["2320-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2320-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2320-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2320-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2321" : helpers.makeTestYear("Pacific/Apia", [
		["2321-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2321-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2321-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2321-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2322" : helpers.makeTestYear("Pacific/Apia", [
		["2322-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2322-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2322-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2322-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2323" : helpers.makeTestYear("Pacific/Apia", [
		["2323-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2323-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2323-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2323-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2324" : helpers.makeTestYear("Pacific/Apia", [
		["2324-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2324-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2324-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2324-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2325" : helpers.makeTestYear("Pacific/Apia", [
		["2325-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2325-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2325-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2325-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2326" : helpers.makeTestYear("Pacific/Apia", [
		["2326-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2326-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2326-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2326-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2327" : helpers.makeTestYear("Pacific/Apia", [
		["2327-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2327-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2327-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2327-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2328" : helpers.makeTestYear("Pacific/Apia", [
		["2328-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2328-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2328-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2328-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2329" : helpers.makeTestYear("Pacific/Apia", [
		["2329-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2329-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2329-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2329-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2330" : helpers.makeTestYear("Pacific/Apia", [
		["2330-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2330-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2330-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2330-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2331" : helpers.makeTestYear("Pacific/Apia", [
		["2331-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2331-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2331-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2331-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2332" : helpers.makeTestYear("Pacific/Apia", [
		["2332-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2332-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2332-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2332-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2333" : helpers.makeTestYear("Pacific/Apia", [
		["2333-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2333-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2333-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2333-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2334" : helpers.makeTestYear("Pacific/Apia", [
		["2334-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2334-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2334-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2334-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2335" : helpers.makeTestYear("Pacific/Apia", [
		["2335-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2335-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2335-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2335-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2336" : helpers.makeTestYear("Pacific/Apia", [
		["2336-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2336-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2336-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2336-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2337" : helpers.makeTestYear("Pacific/Apia", [
		["2337-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2337-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2337-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2337-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2338" : helpers.makeTestYear("Pacific/Apia", [
		["2338-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2338-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2338-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2338-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2339" : helpers.makeTestYear("Pacific/Apia", [
		["2339-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2339-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2339-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2339-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2340" : helpers.makeTestYear("Pacific/Apia", [
		["2340-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2340-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2340-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2340-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2341" : helpers.makeTestYear("Pacific/Apia", [
		["2341-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2341-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2341-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2341-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2342" : helpers.makeTestYear("Pacific/Apia", [
		["2342-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2342-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2342-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2342-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2343" : helpers.makeTestYear("Pacific/Apia", [
		["2343-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2343-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2343-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2343-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2344" : helpers.makeTestYear("Pacific/Apia", [
		["2344-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2344-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2344-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2344-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2345" : helpers.makeTestYear("Pacific/Apia", [
		["2345-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2345-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2345-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2345-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2346" : helpers.makeTestYear("Pacific/Apia", [
		["2346-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2346-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2346-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2346-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2347" : helpers.makeTestYear("Pacific/Apia", [
		["2347-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2347-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2347-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2347-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2348" : helpers.makeTestYear("Pacific/Apia", [
		["2348-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2348-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2348-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2348-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2349" : helpers.makeTestYear("Pacific/Apia", [
		["2349-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2349-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2349-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2349-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2350" : helpers.makeTestYear("Pacific/Apia", [
		["2350-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2350-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2350-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2350-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2351" : helpers.makeTestYear("Pacific/Apia", [
		["2351-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2351-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2351-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2351-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2352" : helpers.makeTestYear("Pacific/Apia", [
		["2352-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2352-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2352-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2352-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2353" : helpers.makeTestYear("Pacific/Apia", [
		["2353-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2353-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2353-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2353-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2354" : helpers.makeTestYear("Pacific/Apia", [
		["2354-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2354-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2354-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2354-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2355" : helpers.makeTestYear("Pacific/Apia", [
		["2355-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2355-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2355-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2355-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2356" : helpers.makeTestYear("Pacific/Apia", [
		["2356-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2356-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2356-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2356-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2357" : helpers.makeTestYear("Pacific/Apia", [
		["2357-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2357-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2357-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2357-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2358" : helpers.makeTestYear("Pacific/Apia", [
		["2358-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2358-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2358-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2358-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2359" : helpers.makeTestYear("Pacific/Apia", [
		["2359-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2359-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2359-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2359-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2360" : helpers.makeTestYear("Pacific/Apia", [
		["2360-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2360-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2360-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2360-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2361" : helpers.makeTestYear("Pacific/Apia", [
		["2361-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2361-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2361-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2361-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2362" : helpers.makeTestYear("Pacific/Apia", [
		["2362-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2362-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2362-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2362-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2363" : helpers.makeTestYear("Pacific/Apia", [
		["2363-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2363-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2363-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2363-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2364" : helpers.makeTestYear("Pacific/Apia", [
		["2364-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2364-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2364-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2364-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2365" : helpers.makeTestYear("Pacific/Apia", [
		["2365-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2365-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2365-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2365-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2366" : helpers.makeTestYear("Pacific/Apia", [
		["2366-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2366-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2366-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2366-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2367" : helpers.makeTestYear("Pacific/Apia", [
		["2367-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2367-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2367-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2367-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2368" : helpers.makeTestYear("Pacific/Apia", [
		["2368-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2368-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2368-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2368-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2369" : helpers.makeTestYear("Pacific/Apia", [
		["2369-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2369-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2369-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2369-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2370" : helpers.makeTestYear("Pacific/Apia", [
		["2370-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2370-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2370-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2370-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2371" : helpers.makeTestYear("Pacific/Apia", [
		["2371-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2371-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2371-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2371-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2372" : helpers.makeTestYear("Pacific/Apia", [
		["2372-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2372-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2372-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2372-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2373" : helpers.makeTestYear("Pacific/Apia", [
		["2373-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2373-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2373-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2373-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2374" : helpers.makeTestYear("Pacific/Apia", [
		["2374-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2374-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2374-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2374-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2375" : helpers.makeTestYear("Pacific/Apia", [
		["2375-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2375-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2375-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2375-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2376" : helpers.makeTestYear("Pacific/Apia", [
		["2376-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2376-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2376-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2376-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2377" : helpers.makeTestYear("Pacific/Apia", [
		["2377-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2377-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2377-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2377-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2378" : helpers.makeTestYear("Pacific/Apia", [
		["2378-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2378-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2378-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2378-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2379" : helpers.makeTestYear("Pacific/Apia", [
		["2379-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2379-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2379-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2379-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2380" : helpers.makeTestYear("Pacific/Apia", [
		["2380-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2380-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2380-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2380-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2381" : helpers.makeTestYear("Pacific/Apia", [
		["2381-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2381-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2381-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2381-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2382" : helpers.makeTestYear("Pacific/Apia", [
		["2382-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2382-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2382-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2382-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2383" : helpers.makeTestYear("Pacific/Apia", [
		["2383-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2383-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2383-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2383-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2384" : helpers.makeTestYear("Pacific/Apia", [
		["2384-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2384-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2384-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2384-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2385" : helpers.makeTestYear("Pacific/Apia", [
		["2385-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2385-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2385-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2385-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2386" : helpers.makeTestYear("Pacific/Apia", [
		["2386-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2386-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2386-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2386-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2387" : helpers.makeTestYear("Pacific/Apia", [
		["2387-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2387-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2387-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2387-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2388" : helpers.makeTestYear("Pacific/Apia", [
		["2388-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2388-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2388-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2388-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2389" : helpers.makeTestYear("Pacific/Apia", [
		["2389-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2389-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2389-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2389-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2390" : helpers.makeTestYear("Pacific/Apia", [
		["2390-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2390-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2390-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2390-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2391" : helpers.makeTestYear("Pacific/Apia", [
		["2391-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2391-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2391-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2391-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2392" : helpers.makeTestYear("Pacific/Apia", [
		["2392-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2392-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2392-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2392-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2393" : helpers.makeTestYear("Pacific/Apia", [
		["2393-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2393-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2393-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2393-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2394" : helpers.makeTestYear("Pacific/Apia", [
		["2394-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2394-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2394-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2394-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2395" : helpers.makeTestYear("Pacific/Apia", [
		["2395-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2395-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2395-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2395-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2396" : helpers.makeTestYear("Pacific/Apia", [
		["2396-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2396-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2396-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2396-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2397" : helpers.makeTestYear("Pacific/Apia", [
		["2397-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2397-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2397-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2397-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2398" : helpers.makeTestYear("Pacific/Apia", [
		["2398-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2398-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2398-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2398-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2399" : helpers.makeTestYear("Pacific/Apia", [
		["2399-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2399-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2399-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2399-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2400" : helpers.makeTestYear("Pacific/Apia", [
		["2400-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2400-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2400-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2400-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2401" : helpers.makeTestYear("Pacific/Apia", [
		["2401-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2401-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2401-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2401-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2402" : helpers.makeTestYear("Pacific/Apia", [
		["2402-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2402-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2402-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2402-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2403" : helpers.makeTestYear("Pacific/Apia", [
		["2403-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2403-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2403-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2403-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2404" : helpers.makeTestYear("Pacific/Apia", [
		["2404-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2404-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2404-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2404-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2405" : helpers.makeTestYear("Pacific/Apia", [
		["2405-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2405-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2405-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2405-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2406" : helpers.makeTestYear("Pacific/Apia", [
		["2406-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2406-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2406-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2406-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2407" : helpers.makeTestYear("Pacific/Apia", [
		["2407-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2407-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2407-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2407-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2408" : helpers.makeTestYear("Pacific/Apia", [
		["2408-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2408-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2408-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2408-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2409" : helpers.makeTestYear("Pacific/Apia", [
		["2409-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2409-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2409-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2409-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2410" : helpers.makeTestYear("Pacific/Apia", [
		["2410-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2410-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2410-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2410-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2411" : helpers.makeTestYear("Pacific/Apia", [
		["2411-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2411-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2411-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2411-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2412" : helpers.makeTestYear("Pacific/Apia", [
		["2412-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2412-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2412-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2412-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2413" : helpers.makeTestYear("Pacific/Apia", [
		["2413-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2413-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2413-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2413-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2414" : helpers.makeTestYear("Pacific/Apia", [
		["2414-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2414-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2414-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2414-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2415" : helpers.makeTestYear("Pacific/Apia", [
		["2415-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2415-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2415-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2415-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2416" : helpers.makeTestYear("Pacific/Apia", [
		["2416-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2416-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2416-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2416-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2417" : helpers.makeTestYear("Pacific/Apia", [
		["2417-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2417-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2417-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2417-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2418" : helpers.makeTestYear("Pacific/Apia", [
		["2418-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2418-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2418-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2418-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2419" : helpers.makeTestYear("Pacific/Apia", [
		["2419-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2419-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2419-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2419-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2420" : helpers.makeTestYear("Pacific/Apia", [
		["2420-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2420-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2420-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2420-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2421" : helpers.makeTestYear("Pacific/Apia", [
		["2421-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2421-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2421-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2421-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2422" : helpers.makeTestYear("Pacific/Apia", [
		["2422-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2422-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2422-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2422-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2423" : helpers.makeTestYear("Pacific/Apia", [
		["2423-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2423-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2423-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2423-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2424" : helpers.makeTestYear("Pacific/Apia", [
		["2424-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2424-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2424-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2424-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2425" : helpers.makeTestYear("Pacific/Apia", [
		["2425-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2425-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2425-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2425-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2426" : helpers.makeTestYear("Pacific/Apia", [
		["2426-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2426-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2426-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2426-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2427" : helpers.makeTestYear("Pacific/Apia", [
		["2427-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2427-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2427-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2427-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2428" : helpers.makeTestYear("Pacific/Apia", [
		["2428-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2428-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2428-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2428-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2429" : helpers.makeTestYear("Pacific/Apia", [
		["2429-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2429-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2429-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2429-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2430" : helpers.makeTestYear("Pacific/Apia", [
		["2430-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2430-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2430-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2430-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2431" : helpers.makeTestYear("Pacific/Apia", [
		["2431-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2431-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2431-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2431-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2432" : helpers.makeTestYear("Pacific/Apia", [
		["2432-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2432-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2432-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2432-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2433" : helpers.makeTestYear("Pacific/Apia", [
		["2433-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2433-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2433-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2433-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2434" : helpers.makeTestYear("Pacific/Apia", [
		["2434-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2434-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2434-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2434-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2435" : helpers.makeTestYear("Pacific/Apia", [
		["2435-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2435-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2435-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2435-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2436" : helpers.makeTestYear("Pacific/Apia", [
		["2436-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2436-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2436-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2436-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2437" : helpers.makeTestYear("Pacific/Apia", [
		["2437-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2437-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2437-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2437-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2438" : helpers.makeTestYear("Pacific/Apia", [
		["2438-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2438-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2438-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2438-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2439" : helpers.makeTestYear("Pacific/Apia", [
		["2439-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2439-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2439-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2439-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2440" : helpers.makeTestYear("Pacific/Apia", [
		["2440-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2440-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2440-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2440-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2441" : helpers.makeTestYear("Pacific/Apia", [
		["2441-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2441-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2441-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2441-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2442" : helpers.makeTestYear("Pacific/Apia", [
		["2442-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2442-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2442-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2442-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2443" : helpers.makeTestYear("Pacific/Apia", [
		["2443-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2443-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2443-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2443-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2444" : helpers.makeTestYear("Pacific/Apia", [
		["2444-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2444-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2444-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2444-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2445" : helpers.makeTestYear("Pacific/Apia", [
		["2445-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2445-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2445-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2445-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2446" : helpers.makeTestYear("Pacific/Apia", [
		["2446-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2446-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2446-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2446-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2447" : helpers.makeTestYear("Pacific/Apia", [
		["2447-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2447-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2447-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2447-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2448" : helpers.makeTestYear("Pacific/Apia", [
		["2448-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2448-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2448-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2448-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2449" : helpers.makeTestYear("Pacific/Apia", [
		["2449-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2449-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2449-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2449-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2450" : helpers.makeTestYear("Pacific/Apia", [
		["2450-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2450-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2450-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2450-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2451" : helpers.makeTestYear("Pacific/Apia", [
		["2451-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2451-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2451-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2451-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2452" : helpers.makeTestYear("Pacific/Apia", [
		["2452-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2452-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2452-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2452-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2453" : helpers.makeTestYear("Pacific/Apia", [
		["2453-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2453-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2453-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2453-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2454" : helpers.makeTestYear("Pacific/Apia", [
		["2454-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2454-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2454-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2454-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2455" : helpers.makeTestYear("Pacific/Apia", [
		["2455-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2455-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2455-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2455-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2456" : helpers.makeTestYear("Pacific/Apia", [
		["2456-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2456-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2456-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2456-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2457" : helpers.makeTestYear("Pacific/Apia", [
		["2457-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2457-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2457-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2457-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2458" : helpers.makeTestYear("Pacific/Apia", [
		["2458-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2458-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2458-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2458-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2459" : helpers.makeTestYear("Pacific/Apia", [
		["2459-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2459-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2459-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2459-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2460" : helpers.makeTestYear("Pacific/Apia", [
		["2460-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2460-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2460-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2460-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2461" : helpers.makeTestYear("Pacific/Apia", [
		["2461-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2461-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2461-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2461-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2462" : helpers.makeTestYear("Pacific/Apia", [
		["2462-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2462-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2462-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2462-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2463" : helpers.makeTestYear("Pacific/Apia", [
		["2463-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2463-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2463-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2463-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2464" : helpers.makeTestYear("Pacific/Apia", [
		["2464-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2464-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2464-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2464-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2465" : helpers.makeTestYear("Pacific/Apia", [
		["2465-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2465-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2465-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2465-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2466" : helpers.makeTestYear("Pacific/Apia", [
		["2466-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2466-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2466-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2466-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2467" : helpers.makeTestYear("Pacific/Apia", [
		["2467-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2467-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2467-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2467-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2468" : helpers.makeTestYear("Pacific/Apia", [
		["2468-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2468-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2468-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2468-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2469" : helpers.makeTestYear("Pacific/Apia", [
		["2469-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2469-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2469-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2469-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2470" : helpers.makeTestYear("Pacific/Apia", [
		["2470-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2470-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2470-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2470-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2471" : helpers.makeTestYear("Pacific/Apia", [
		["2471-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2471-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2471-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2471-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2472" : helpers.makeTestYear("Pacific/Apia", [
		["2472-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2472-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2472-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2472-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2473" : helpers.makeTestYear("Pacific/Apia", [
		["2473-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2473-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2473-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2473-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2474" : helpers.makeTestYear("Pacific/Apia", [
		["2474-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2474-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2474-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2474-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2475" : helpers.makeTestYear("Pacific/Apia", [
		["2475-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2475-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2475-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2475-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2476" : helpers.makeTestYear("Pacific/Apia", [
		["2476-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2476-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2476-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2476-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2477" : helpers.makeTestYear("Pacific/Apia", [
		["2477-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2477-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2477-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2477-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2478" : helpers.makeTestYear("Pacific/Apia", [
		["2478-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2478-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2478-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2478-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2479" : helpers.makeTestYear("Pacific/Apia", [
		["2479-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2479-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2479-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2479-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2480" : helpers.makeTestYear("Pacific/Apia", [
		["2480-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2480-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2480-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2480-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2481" : helpers.makeTestYear("Pacific/Apia", [
		["2481-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2481-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2481-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2481-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2482" : helpers.makeTestYear("Pacific/Apia", [
		["2482-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2482-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2482-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2482-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2483" : helpers.makeTestYear("Pacific/Apia", [
		["2483-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2483-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2483-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2483-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2484" : helpers.makeTestYear("Pacific/Apia", [
		["2484-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2484-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2484-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2484-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2485" : helpers.makeTestYear("Pacific/Apia", [
		["2485-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2485-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2485-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2485-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2486" : helpers.makeTestYear("Pacific/Apia", [
		["2486-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2486-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2486-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2486-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2487" : helpers.makeTestYear("Pacific/Apia", [
		["2487-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2487-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2487-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2487-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2488" : helpers.makeTestYear("Pacific/Apia", [
		["2488-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2488-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2488-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2488-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2489" : helpers.makeTestYear("Pacific/Apia", [
		["2489-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2489-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2489-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2489-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2490" : helpers.makeTestYear("Pacific/Apia", [
		["2490-04-01T13:59:59+00:00", "03:59:59", "+14", -840],
		["2490-04-01T14:00:00+00:00", "03:00:00", "+13", -780],
		["2490-09-23T13:59:59+00:00", "02:59:59", "+13", -780],
		["2490-09-23T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2491" : helpers.makeTestYear("Pacific/Apia", [
		["2491-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2491-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2491-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2491-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2492" : helpers.makeTestYear("Pacific/Apia", [
		["2492-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2492-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2492-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2492-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2493" : helpers.makeTestYear("Pacific/Apia", [
		["2493-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2493-04-04T14:00:00+00:00", "03:00:00", "+13", -780],
		["2493-09-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2493-09-26T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2494" : helpers.makeTestYear("Pacific/Apia", [
		["2494-04-03T13:59:59+00:00", "03:59:59", "+14", -840],
		["2494-04-03T14:00:00+00:00", "03:00:00", "+13", -780],
		["2494-09-25T13:59:59+00:00", "02:59:59", "+13", -780],
		["2494-09-25T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2495" : helpers.makeTestYear("Pacific/Apia", [
		["2495-04-02T13:59:59+00:00", "03:59:59", "+14", -840],
		["2495-04-02T14:00:00+00:00", "03:00:00", "+13", -780],
		["2495-09-24T13:59:59+00:00", "02:59:59", "+13", -780],
		["2495-09-24T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2496" : helpers.makeTestYear("Pacific/Apia", [
		["2496-03-31T13:59:59+00:00", "03:59:59", "+14", -840],
		["2496-03-31T14:00:00+00:00", "03:00:00", "+13", -780],
		["2496-09-29T13:59:59+00:00", "02:59:59", "+13", -780],
		["2496-09-29T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2497" : helpers.makeTestYear("Pacific/Apia", [
		["2497-04-06T13:59:59+00:00", "03:59:59", "+14", -840],
		["2497-04-06T14:00:00+00:00", "03:00:00", "+13", -780],
		["2497-09-28T13:59:59+00:00", "02:59:59", "+13", -780],
		["2497-09-28T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2498" : helpers.makeTestYear("Pacific/Apia", [
		["2498-04-05T13:59:59+00:00", "03:59:59", "+14", -840],
		["2498-04-05T14:00:00+00:00", "03:00:00", "+13", -780],
		["2498-09-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2498-09-27T14:00:00+00:00", "04:00:00", "+14", -840]
	]),

	"2499" : helpers.makeTestYear("Pacific/Apia", [
		["2499-04-04T13:59:59+00:00", "03:59:59", "+14", -840],
		["2499-04-04T14:00:00+00:00", "03:00:00", "+13", -780]
	])
};