package mpi.pt2pt; 

/****************************************************************************

 MESSAGE PASSING INTERFACE TEST CASE SUITE

 Copyright IBM Corp. 1995

 IBM Corp. hereby grants a non-exclusive license to use, copy, modify, and
 distribute this software for any purpose and without fee provided that the
 above copyright notice and the following paragraphs appear in all copies.

 IBM Corp. makes no representation that the test cases comprising this
 suite are correct or are an accurate representation of any standard.

 In no event shall IBM be liable to any party for direct, indirect, special
 incidental, or consequential damage arising out of the use of this software
 even if IBM Corp. has been advised of the possibility of such damage.

 IBM CORP. SPECIFICALLY DISCLAIMS ANY WARRANTIES INCLUDING, BUT NOT LIMITED
 TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS AND IBM
 CORP. HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

****************************************************************************

 These test cases reflect an interpretation of the MPI Standard.  They are
 are, in most cases, unit tests of specific MPI behaviors.  If a user of any
 test case from this set believes that the MPI Standard requires behavior
 different than that implied by the test case we would appreciate feedback.

 Comments may be sent to:
    Richard Treumann
    treumann@kgn.ibm.com

****************************************************************************

 MPI-Java version :
    Sung-Hoon Ko(shko@npac.syr.edu)
    Northeast Parallel Architectures Center at Syracuse University
    03/22/98

****************************************************************************
*/

//no detach?
import mpi.*;
import java.nio.ByteBuffer ;

public class buffer {
   static public void main(String[] args) throws MPIException {
	  try{
		buffer c = new buffer(args);
	  }catch(Exception e){
	  }
  }

  public buffer() {
  }

  public buffer(String[] args) throws Exception {

    int len,tasks,me,i,size,flag;
    int data[] = new int[100001];
    int sizeofint = 4;
  
    Status status;
    Request request;
    Errhandler warn;
 
    MPI.Init(args);    

                         
    me=MPI.COMM_WORLD.Rank();   
  int over = MPI.BSEND_OVERHEAD ;  // Checks constant correctly
                                     // initialized before MPI.Init().

    if(me==0) {
      size = MPI.COMM_WORLD.Pack_size( 100001, MPI.INT ) + over;      
      //System.out.println("over <"+over+">");
      //System.out.println(" size <"+size+">");
      //mpi.Buffer buf = new mpi.Buffer( size );
      ByteBuffer buf = ByteBuffer.allocateDirect ( size );
      MPI.Buffer_attach(buf);        
      
      for(i=0;i<100001;i++)  data[i] = i;

      request = MPI.COMM_WORLD.Ibsend(data,0,100001,MPI.INT,1,1); 
      status = request.Test();

    } else if(me == 1) {
      for(i=0;i<4000004;i++);

      MPI.COMM_WORLD.Recv(data,0,100001,MPI.INT,0,1);
      for(i=0;i<100001;i++)
	if(data[i] != i) { System.out.println("ERROR i = " + i); break; }
    }

    MPI.COMM_WORLD.Barrier();
    if(me == 1)  System.out.println("Buffer TESTS COMPLETE");
    MPI.Finalize();
  }
}

