Style
=====

The HTML generated by jquery-textcomplete is compatible with [Bootstrap](http://twbs.github.io/bootstrap/)'s dropdown. So all Bootstrap oriented css files are available.


Sample
------

Dropdown element's HTML structure is something like this:

```html
<ul class="dropdown-menu textcomplete-dropdown">
  <li class="textcomplete-item active" data-index="0"><a>...</a></li>
  <li class="textcomplete-item" data-index="1"><a>...</a></li>
  <li class="textcomplete-item" data-index="2"><a>...</a></li>
  <li class="textcomplete-item" data-index="3"><a>...</a></li>
  <li class="textcomplete-item" data-index="4"><a>...</a></li>
</ul>
```

Children of `a` elements (`...` above) depend on your `templateFunc`.

If you don't use Bootstrap, you can use the following sample to start writing your own style.

```css
.textcomplete-dropdown {
    border: 1px solid #ddd;
    background-color: white;
}

.textcomplete-dropdown li {
    border-top: 1px solid #ddd;
    padding: 2px 5px;
}

.textcomplete-dropdown li:first-child {
    border-top: none;
}

.textcomplete-dropdown li:hover,
.textcomplete-dropdown .active {
    background-color: rgb(110, 183, 219);
}

.textcomplete-dropdown {
    list-style: none;
    padding: 0;
    margin: 0;
}

.textcomplete-dropdown a:hover {
    cursor: pointer;
}
```
