/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocXml/ProviderInfraXml/ProviderRegXml.h"
#include "Doc/DocXml/ProviderInfraXml/SchemaSummaryXml.h"

#include "Doc/ProviderInfraDoc/CProviderRegDoc.h"
#include "Doc/ProviderInfraDoc/CSchemaSummaryDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/ProviderInfraXml/ProviderInfraXmlRoots.h"

using namespace Caf;

std::string XmlRoots::saveProviderRegToString(
	const SmartPtrCProviderRegDoc providerRegDoc) {
	CAF_CM_STATIC_FUNC_VALIDATE("XmlRoots", "saveProviderRegToString");

	std::string rc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(providerRegDoc);

		const std::string schemaNamespace = DocXmlUtils::getSchemaNamespace("fx");
		const std::string schemaLocation = DocXmlUtils::getSchemaLocation("fx/ProviderInfra.xsd");

		const SmartPtrCXmlElement rootXml = CXmlUtils::createRootElement(
			"providerReg", schemaNamespace, schemaLocation);
		ProviderRegXml::add(providerRegDoc, rootXml);

		rc = rootXml->saveToString();
	}
	CAF_CM_EXIT;

	return rc;
}

SmartPtrCProviderRegDoc XmlRoots::parseProviderRegFromString(
	const std::string xml) {
	CAF_CM_STATIC_FUNC_VALIDATE("XmlRoots", "parseProviderRegFromString");

	SmartPtrCProviderRegDoc providerRegDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_STRING(xml);

		const SmartPtrCXmlElement rootXml = CXmlUtils::parseString(xml, "caf:providerReg");
		providerRegDoc = ProviderRegXml::parse(rootXml);
	}
	CAF_CM_EXIT;

	return providerRegDoc;
}

void XmlRoots::saveProviderRegToFile(
	const SmartPtrCProviderRegDoc providerRegDoc,
	const std::string filePath) {
	CAF_CM_STATIC_FUNC_LOG_VALIDATE("XmlRoots", "saveProviderRegToFile");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(providerRegDoc);
		CAF_CM_VALIDATE_STRING(filePath);

		CAF_CM_LOG_DEBUG_VA1("Saving to file - %s", filePath.c_str());

		const std::string providerRegStr =
			saveProviderRegToString(providerRegDoc);
		FileSystemUtils::saveTextFile(filePath, providerRegStr);
	}
	CAF_CM_EXIT;
}

SmartPtrCProviderRegDoc XmlRoots::parseProviderRegFromFile(
	const std::string filePath) {
	CAF_CM_STATIC_FUNC_VALIDATE("XmlRoots", "parseProviderRegFromFile");

	SmartPtrCProviderRegDoc providerRegDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_STRING(filePath);

		const SmartPtrCXmlElement rootXml = CXmlUtils::parseFile(filePath, "caf:providerReg");
		providerRegDoc = ProviderRegXml::parse(rootXml);
	}
	CAF_CM_EXIT;

	return providerRegDoc;
}

std::string XmlRoots::saveSchemaSummaryToString(
	const SmartPtrCSchemaSummaryDoc schemaSummaryDoc) {
	CAF_CM_STATIC_FUNC_VALIDATE("XmlRoots", "saveSchemaSummaryToString");

	std::string rc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(schemaSummaryDoc);

		const std::string schemaNamespace = DocXmlUtils::getSchemaNamespace("fx");
		const std::string schemaLocation = DocXmlUtils::getSchemaLocation("fx/ProviderInfra.xsd");

		const SmartPtrCXmlElement rootXml = CXmlUtils::createRootElement(
			"schemaSummary", schemaNamespace, schemaLocation);
		SchemaSummaryXml::add(schemaSummaryDoc, rootXml);

		rc = rootXml->saveToString();
	}
	CAF_CM_EXIT;

	return rc;
}

SmartPtrCSchemaSummaryDoc XmlRoots::parseSchemaSummaryFromString(
	const std::string xml) {
	CAF_CM_STATIC_FUNC_VALIDATE("XmlRoots", "parseSchemaSummaryFromString");

	SmartPtrCSchemaSummaryDoc schemaSummaryDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_STRING(xml);

		const SmartPtrCXmlElement rootXml = CXmlUtils::parseString(xml, "caf:schemaSummary");
		schemaSummaryDoc = SchemaSummaryXml::parse(rootXml);
	}
	CAF_CM_EXIT;

	return schemaSummaryDoc;
}

void XmlRoots::saveSchemaSummaryToFile(
	const SmartPtrCSchemaSummaryDoc schemaSummaryDoc,
	const std::string filePath) {
	CAF_CM_STATIC_FUNC_LOG_VALIDATE("XmlRoots", "saveSchemaSummaryToFile");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(schemaSummaryDoc);
		CAF_CM_VALIDATE_STRING(filePath);

		CAF_CM_LOG_DEBUG_VA1("Saving to file - %s", filePath.c_str());

		const std::string schemaSummaryStr =
			saveSchemaSummaryToString(schemaSummaryDoc);
		FileSystemUtils::saveTextFile(filePath, schemaSummaryStr);
	}
	CAF_CM_EXIT;
}

SmartPtrCSchemaSummaryDoc XmlRoots::parseSchemaSummaryFromFile(
	const std::string filePath) {
	CAF_CM_STATIC_FUNC_VALIDATE("XmlRoots", "parseSchemaSummaryFromFile");

	SmartPtrCSchemaSummaryDoc schemaSummaryDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_STRING(filePath);

		const SmartPtrCXmlElement rootXml = CXmlUtils::parseFile(filePath, "caf:schemaSummary");
		schemaSummaryDoc = SchemaSummaryXml::parse(rootXml);
	}
	CAF_CM_EXIT;

	return schemaSummaryDoc;
}
