# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ClusterVersionDetails(Model):
    """The detail of the Service Fabric runtime version result.

    :param code_version: The Service Fabric runtime version of the cluster.
    :type code_version: str
    :param support_expiry_utc: The date of expiry of support of the version.
    :type support_expiry_utc: str
    :param environment: Indicates if this version is for Windows or Linux
     operating system. Possible values include: 'Windows', 'Linux'
    :type environment: str or ~azure.mgmt.servicefabric.models.enum
    """

    _attribute_map = {
        'code_version': {'key': 'codeVersion', 'type': 'str'},
        'support_expiry_utc': {'key': 'supportExpiryUtc', 'type': 'str'},
        'environment': {'key': 'environment', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ClusterVersionDetails, self).__init__(**kwargs)
        self.code_version = kwargs.get('code_version', None)
        self.support_expiry_utc = kwargs.get('support_expiry_utc', None)
        self.environment = kwargs.get('environment', None)
