# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AzureStorageInfoValue(Model):
    """Azure Files or Blob Storage access information value for dictionary
    storage.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param type: Type of storage. Possible values include: 'AzureFiles',
     'AzureBlob'
    :type type: str or ~azure.mgmt.web.models.AzureStorageType
    :param account_name: Name of the storage account.
    :type account_name: str
    :param share_name: Name of the file share (container name, for Blob
     storage).
    :type share_name: str
    :param access_key: Access key for the storage account.
    :type access_key: str
    :param mount_path: Path to mount the storage within the site's runtime
     environment.
    :type mount_path: str
    :ivar state: State of the storage account. Possible values include: 'Ok',
     'InvalidCredentials', 'InvalidShare'
    :vartype state: str or ~azure.mgmt.web.models.AzureStorageState
    """

    _validation = {
        'state': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'AzureStorageType'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'share_name': {'key': 'shareName', 'type': 'str'},
        'access_key': {'key': 'accessKey', 'type': 'str'},
        'mount_path': {'key': 'mountPath', 'type': 'str'},
        'state': {'key': 'state', 'type': 'AzureStorageState'},
    }

    def __init__(self, **kwargs):
        super(AzureStorageInfoValue, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.account_name = kwargs.get('account_name', None)
        self.share_name = kwargs.get('share_name', None)
        self.access_key = kwargs.get('access_key', None)
        self.mount_path = kwargs.get('mount_path', None)
        self.state = None
