#!/usr/bin/python
# -*- coding: utf-8 -*-
"""
Setup script for module fcgi downloaded from
http://alldunn.com/python/fcgi.py
"""

from distutils.core import setup

setup(
  #-- Package description
  name = 'python-fcgi',
  license = """This is free software.  You may use this software for any
purpose including modification/redistribution, so long as
this header remains intact and that you do not claim any
rights of ownership or authorship of this software.  This
software has been tested, but no warranty is expressed or
implied.
""",
  version = '19980130',
  description = 'Simple FastCGI module for Python',
  long_description = """Handles communication with the FastCGI module of the
web server without using the FastCGI developers kit, but
will also work in a non-FastCGI environment, (straight CGI.)
""",
  author = 'Robin Dunn et al',
  author_email = 'robin@alldunn.com',
  url = 'http://alldunn.com/python/fcgi.py',
  py_modules = [
    'fcgi',
  ],
  classifiers = [
    'Development Status :: 5 - Production/Stable',
    'Environment :: No Input/Output (Daemon)',
    'Intended Audience :: Developers',
    'Operating System :: OS Independent',
    'Programming Language :: Python',
  ]
)
