% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableGrob.r
\name{tableGrob}
\alias{tableGrob}
\alias{grid.table}
\alias{ttheme_default}
\alias{ttheme_minimal}
\alias{grid.table}
\alias{ttheme_default}
\alias{ttheme_minimal}
\title{Graphical display of a textual table}
\usage{
tableGrob(d, rows = rownames(d), cols = colnames(d),
  theme = ttheme_default(), vp = NULL, ...)

grid.table(...)

ttheme_default(base_size = 12, base_colour = "black", base_family = "",
  parse = FALSE, padding = unit(c(4, 4), "mm"), ...)

ttheme_minimal(base_size = 12, base_colour = "black", base_family = "",
  parse = FALSE, padding = unit(c(4, 4), "mm"), ...)
}
\arguments{
\item{d}{data.frame or matrix}

\item{rows}{optional vector to specify row names}

\item{cols}{optional vector to specify column names}

\item{theme}{list of theme parameters}

\item{vp}{optional viewport}

\item{...}{further arguments to control the gtable}

\item{base_size}{default font size}

\item{base_colour}{default font colour}

\item{base_family}{default font family}

\item{parse}{logical, default behaviour for parsing text as plotmath}

\item{padding}{length-2 unit vector specifying the horizontal and vertical padding of text within each cell}
}
\value{
A gtable.
}
\description{
Create a gtable containing text grobs representing a character matrix.
}
\section{Functions}{
\itemize{
\item \code{tableGrob}: return a grob

\item \code{grid.table}: draw a text table

\item \code{ttheme_default}: default theme for text tables

\item \code{ttheme_minimal}: minimalist theme for text tables
}}

\examples{
library(grid)
d <- head(iris, 3)
g <- tableGrob(d)
grid.newpage()
grid.draw(g)
}
