% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_analysis_results.R
\name{AnalysisResults_plot}
\alias{AnalysisResults_plot}
\alias{plot.AnalysisResults}
\title{Analysis Results Plotting - Conditional Power Plot}
\usage{
\method{plot}{AnalysisResults}(x, y, ..., nPlanned = NA_real_,
  stage = x$getNumberOfStages(), allocationRatioPlanned = NA_real_,
  main = NA_character_, xlab = NA_character_, ylab = NA_character_,
  legendTitle = "", palette = "Set1", legendPosition = NA_integer_,
  type = 1L)
}
\arguments{
\item{x}{The analysis results at given stage, obtained from \code{\link{getAnalysisResults}}.}

\item{y}{Not available for this kind of plot (is only defined to be compatible to the generic plot function).}

\item{...}{Optional \code{ggplot2} arguments.}

\item{nPlanned}{The sample size planned for the subsequent stages. 
It should be a vector with length equal to the remaining stages and is the 
overall sample size in the two treatment groups if two groups are considered.}

\item{stage}{The stage number (optional). Default: total number of existing stages in the data input
used to create the analysis results.}

\item{allocationRatioPlanned}{The allocation ratio n1/n2 for two treatment groups planned for 
the subsequent stages, the default value is 1.}

\item{main}{The main title, default is \code{"Dataset"}.}

\item{xlab}{The x-axis label, default is \code{"Stage"}.}

\item{ylab}{The y-axis label.}

\item{legendTitle}{The legend title, default is \code{""}.}

\item{palette}{The palette, default is \code{"Set1"}.}

\item{legendPosition}{The position of the legend. 
By default (\code{NA_integer_}) the algorithm tries to find a suitable position. 
Choose one of the following values to specify the position manually:
\itemize{
  \item \code{0}: legend position outside plot
  \item \code{1}: legend position left top
  \item \code{2}: legend position left center
  \item \code{3}: legend position left bottom
  \item \code{4}: legend position right top
  \item \code{5}: legend position right center
  \item \code{6}: legend position right bottom
}}

\item{type}{The plot type (default = 1). Note that at the moment only one type (the conditional power plot) is available.}
}
\description{
Plots the conditional power together with the likelihood function.
}
\details{
The conditional power is calculated only if effect size and sample size is specified.
}
\examples{

design <- getDesignGroupSequential(kMax = 2)

dataExample <- getDataset(
    n = c(20, 30),
	   means = c(50, 51),
	   stDevs = c(130, 140)
)

result <- getAnalysisResults(design = design, 
	   dataInput = dataExample, thetaH0 = 20, 
	   nPlanned = c(30), thetaH1 = 1.5, stage = 1) 

if (require(ggplot2)) plot(result, thetaRange = c(0, 100))

}
