/******************************************************************************
 *
 * Copyright(c) 2007 - 2017 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

/*Image2HeaderVersion: R3 1.5.12*/
#include "mp_precomp.h"
#include "../phydm_precomp.h"

#define CUT_DONT_CARE	0xf
#define RFE_DONT_CARE	0xff
#define PARA_IF 0x8
#define PARA_ELSE_IF	0x9
#define PARA_ELSE	0xa
#define PARA_END	0xb
#define PARA_CHK	0x4


#if (RTL8822C_SUPPORT == 1)
static boolean
halbb_sel_headline(struct dm_struct *dm, u32 *array, u32 array_len,
				  u8 *headline_size, u8 *headline_idx)
{
	boolean case_match = false;
	u32 cut_drv = (u32)dm->cut_version;
	u32 rfe_drv = (u32)dm->rfe_type;
	u32 cut_para = 0, rfe_para = 0;
	u32 compare_target = 0;
	u32 cut_max = 0;
	u32 i = 0;

	*headline_idx = 0;
	*headline_size = 0;

	while ((i + 1) < array_len) {
		if ((array[i] >> 28) != 0xf) {
			*headline_size = (u8)i;
			break;
		}
		PHYDM_DBG(dm, ODM_COMP_INIT, "array[%02d]=0x%08x, array[%02d]=0x%08x\n",
			   i, array[i], i+1, array[i+1]);
		i += 2;
	}

	PHYDM_DBG(dm, ODM_COMP_INIT, "headline_size=%d\n", i);

	if (i == 0)
		return true;

	/*case_idx:1 {RFE:Match, CUT:Match}*/
	compare_target = ((cut_drv & 0x0f) << 24) | (rfe_drv & 0xff);
	PHYDM_DBG(dm, ODM_COMP_INIT, "[1] CHK {RFE:Match, CUT:Match}\n");
	for (i = 0; i < *headline_size; i += 2) {
		if ((array[i] & 0x0f0000ff) == compare_target) {
			*headline_idx = (u8)(i >> 1);
			return true;
		}
	}
	PHYDM_DBG(dm, ODM_COMP_INIT, "	 fail\n");

	/*case_idx:2 {RFE:Match, CUT:Dont care}*/
	compare_target = (CUT_DONT_CARE << 24) | (rfe_drv & 0xff);
	PHYDM_DBG(dm, ODM_COMP_INIT, "[2] CHK {RFE:Match, CUT:Dont_Care}\n");
	for (i = 0; i < *headline_size; i += 2) {
		if ((array[i] & 0x0f0000ff) == compare_target) {
			*headline_idx = (u8)(i >> 1);
			return true;
		}
	}
	PHYDM_DBG(dm, ODM_COMP_INIT, "	 fail\n");

	/*case_idx:3 {RFE:Match, CUT:Max_in_table}*/
	PHYDM_DBG(dm, ODM_COMP_INIT, "[3] CHK {RFE:Match, CUT:Max_in_Table}\n");
	for (i = 0; i < *headline_size; i += 2) {
		rfe_para = array[i] & 0xff;
		cut_para = (array[i] & 0x0f000000) >> 24;
		if (rfe_para == rfe_drv) {
			if (cut_para >= cut_max) {
				cut_max = cut_para;
				*headline_idx = (u8)(i >> 1);
				PHYDM_DBG(dm, ODM_COMP_INIT, "cut_max:%d\n", cut_max);
				case_match = true;
			}
		}
	}
	if (case_match) {
		return true;
	}
	PHYDM_DBG(dm, ODM_COMP_INIT, "	 fail\n");

	/*case_idx:4 {RFE:Dont Care, CUT:Max_in_table}*/
	PHYDM_DBG(dm, ODM_COMP_INIT, "[4] CHK {RFE:Dont_Care, CUT:Max_in_Table}\n");
	for (i = 0; i < *headline_size; i += 2) {
		rfe_para = array[i] & 0xff;
		cut_para = (array[i] & 0x0f000000) >> 24;
		if (rfe_para == RFE_DONT_CARE) {
			if (cut_para >= cut_max) {
				cut_max = cut_para;
				*headline_idx = (u8)(i >> 1);
				PHYDM_DBG(dm, ODM_COMP_INIT, "cut_max:%d\n", cut_max);
				case_match = true;
			}
		}
	}
	if (case_match) {
		return true;
	}
	PHYDM_DBG(dm, ODM_COMP_INIT, "	 fail\n");

	/*case_idx:5 {RFE:Not_Match, CUT:Not_Match}*/
	PHYDM_DBG(dm, ODM_COMP_INIT, "[5] CHK {RFE:Not_Match, CUT:Not_Match}\n");
	PHYDM_DBG(dm, ODM_COMP_INIT, "	 all fail\n");
	return false;
}

static void
halbb_flag_2_default(boolean *is_matched, boolean *find_target)
{
	*is_matched = true;
	*find_target = false;
}


/******************************************************************************
 *                           agc_tab.TXT
 ******************************************************************************/

const u32 array_mp_8822c_agc_tab[] = {
		0xF3FFFFFF, 0x00000000,
		0xF0FFFF15, 0x00000001,
		0xF0FFFF16, 0x00000002,
	0x83ffffff,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x300001FF,
		0x1D90, 0x300101FE,
		0x1D90, 0x300201FD,
		0x1D90, 0x300301FC,
		0x1D90, 0x300401FB,
		0x1D90, 0x300501FA,
		0x1D90, 0x300601F9,
		0x1D90, 0x300701F8,
		0x1D90, 0x300801F7,
		0x1D90, 0x300901F6,
		0x1D90, 0x300A01F5,
		0x1D90, 0x300B01F4,
		0x1D90, 0x300C01F3,
		0x1D90, 0x300D01F2,
		0x1D90, 0x300E01F1,
		0x1D90, 0x300F01F0,
		0x1D90, 0x301001EF,
		0x1D90, 0x301101EE,
		0x1D90, 0x301201ED,
		0x1D90, 0x301301EC,
		0x1D90, 0x301401EB,
		0x1D90, 0x301501EA,
		0x1D90, 0x301601E9,
		0x1D90, 0x301701E8,
		0x1D90, 0x301801E7,
		0x1D90, 0x301901E5,
		0x1D90, 0x301A01E4,
		0x1D90, 0x301B01C5,
		0x1D90, 0x301C01C4,
		0x1D90, 0x301D01C3,
		0x1D90, 0x301E01C2,
		0x1D90, 0x301F0188,
		0x1D90, 0x30200187,
		0x1D90, 0x30210186,
		0x1D90, 0x30220184,
		0x1D90, 0x30230183,
		0x1D90, 0x30240182,
		0x1D90, 0x30250181,
		0x1D90, 0x30260148,
		0x1D90, 0x30270147,
		0x1D90, 0x30280146,
		0x1D90, 0x30290144,
		0x1D90, 0x302A0143,
		0x1D90, 0x302B0142,
		0x1D90, 0x302C0141,
		0x1D90, 0x302D00C8,
		0x1D90, 0x302E00C7,
		0x1D90, 0x302F00C6,
		0x1D90, 0x303000C5,
		0x1D90, 0x303100C4,
		0x1D90, 0x303200C3,
		0x1D90, 0x30330048,
		0x1D90, 0x30340047,
		0x1D90, 0x30350046,
		0x1D90, 0x30360045,
		0x1D90, 0x30370025,
		0x1D90, 0x30380024,
		0x1D90, 0x30390023,
		0x1D90, 0x303A0022,
		0x1D90, 0x303B0021,
		0x1D90, 0x303C0020,
		0x1D90, 0x303D0003,
		0x1D90, 0x303E0002,
		0x1D90, 0x303F0001,
	0x90ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x300001FF,
		0x1D90, 0x300101FE,
		0x1D90, 0x300201FD,
		0x1D90, 0x300301FC,
		0x1D90, 0x300401FB,
		0x1D90, 0x300501FA,
		0x1D90, 0x300601F9,
		0x1D90, 0x300701F8,
		0x1D90, 0x300801F7,
		0x1D90, 0x300901F6,
		0x1D90, 0x300A01F5,
		0x1D90, 0x300B01F4,
		0x1D90, 0x300C01F3,
		0x1D90, 0x300D01F2,
		0x1D90, 0x300E01F1,
		0x1D90, 0x300F01F0,
		0x1D90, 0x301001EF,
		0x1D90, 0x301101EE,
		0x1D90, 0x301201ED,
		0x1D90, 0x301301EC,
		0x1D90, 0x301401EB,
		0x1D90, 0x301501EA,
		0x1D90, 0x301601E9,
		0x1D90, 0x301701E8,
		0x1D90, 0x301801E7,
		0x1D90, 0x301901E5,
		0x1D90, 0x301A01E4,
		0x1D90, 0x301B01C5,
		0x1D90, 0x301C01C4,
		0x1D90, 0x301D01C3,
		0x1D90, 0x301E01C2,
		0x1D90, 0x301F0188,
		0x1D90, 0x30200187,
		0x1D90, 0x30210186,
		0x1D90, 0x30220184,
		0x1D90, 0x30230183,
		0x1D90, 0x30240182,
		0x1D90, 0x30250181,
		0x1D90, 0x30260148,
		0x1D90, 0x30270147,
		0x1D90, 0x30280146,
		0x1D90, 0x30290144,
		0x1D90, 0x302A0143,
		0x1D90, 0x302B0142,
		0x1D90, 0x302C0141,
		0x1D90, 0x302D00C8,
		0x1D90, 0x302E00C7,
		0x1D90, 0x302F00C6,
		0x1D90, 0x303000C5,
		0x1D90, 0x303100C4,
		0x1D90, 0x303200C3,
		0x1D90, 0x30330048,
		0x1D90, 0x30340047,
		0x1D90, 0x30350046,
		0x1D90, 0x30360045,
		0x1D90, 0x30370025,
		0x1D90, 0x30380024,
		0x1D90, 0x30390023,
		0x1D90, 0x303A0022,
		0x1D90, 0x303B0021,
		0x1D90, 0x303C0020,
		0x1D90, 0x303D0003,
		0x1D90, 0x303E0002,
		0x1D90, 0x303F0001,
	0x90ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x300001FF,
		0x1D90, 0x300101FE,
		0x1D90, 0x300201FD,
		0x1D90, 0x300301FC,
		0x1D90, 0x300401FB,
		0x1D90, 0x300501FA,
		0x1D90, 0x300601F9,
		0x1D90, 0x300701F8,
		0x1D90, 0x300801F7,
		0x1D90, 0x300901F6,
		0x1D90, 0x300A01F5,
		0x1D90, 0x300B01F4,
		0x1D90, 0x300C01F3,
		0x1D90, 0x300D01F2,
		0x1D90, 0x300E01F1,
		0x1D90, 0x300F01F0,
		0x1D90, 0x301001EF,
		0x1D90, 0x301101EE,
		0x1D90, 0x301201ED,
		0x1D90, 0x301301EC,
		0x1D90, 0x301401EB,
		0x1D90, 0x301501EA,
		0x1D90, 0x301601E9,
		0x1D90, 0x301701E8,
		0x1D90, 0x301801E7,
		0x1D90, 0x301901E5,
		0x1D90, 0x301A01E4,
		0x1D90, 0x301B01C5,
		0x1D90, 0x301C01C4,
		0x1D90, 0x301D01C3,
		0x1D90, 0x301E01C2,
		0x1D90, 0x301F0188,
		0x1D90, 0x30200187,
		0x1D90, 0x30210186,
		0x1D90, 0x30220184,
		0x1D90, 0x30230183,
		0x1D90, 0x30240182,
		0x1D90, 0x30250181,
		0x1D90, 0x30260148,
		0x1D90, 0x30270147,
		0x1D90, 0x30280146,
		0x1D90, 0x30290144,
		0x1D90, 0x302A0143,
		0x1D90, 0x302B0142,
		0x1D90, 0x302C0141,
		0x1D90, 0x302D00C8,
		0x1D90, 0x302E00C7,
		0x1D90, 0x302F00C6,
		0x1D90, 0x303000C5,
		0x1D90, 0x303100C4,
		0x1D90, 0x303200C3,
		0x1D90, 0x30330048,
		0x1D90, 0x30340047,
		0x1D90, 0x30350046,
		0x1D90, 0x30360045,
		0x1D90, 0x30370025,
		0x1D90, 0x30380024,
		0x1D90, 0x30390023,
		0x1D90, 0x303A0022,
		0x1D90, 0x303B0021,
		0x1D90, 0x303C0020,
		0x1D90, 0x303D0003,
		0x1D90, 0x303E0002,
		0x1D90, 0x303F0001,
	0xA0000000,	0x00000000,
		0x1D90, 0x300001FF,
		0x1D90, 0x300101FE,
		0x1D90, 0x300201FD,
		0x1D90, 0x300301FC,
		0x1D90, 0x300401FB,
		0x1D90, 0x300501FA,
		0x1D90, 0x300601F9,
		0x1D90, 0x300701F8,
		0x1D90, 0x300801F7,
		0x1D90, 0x300901F6,
		0x1D90, 0x300A01F5,
		0x1D90, 0x300B01F4,
		0x1D90, 0x300C01F3,
		0x1D90, 0x300D01F2,
		0x1D90, 0x300E01F1,
		0x1D90, 0x300F01F0,
		0x1D90, 0x301001EF,
		0x1D90, 0x301101EE,
		0x1D90, 0x301201ED,
		0x1D90, 0x301301EC,
		0x1D90, 0x301401EB,
		0x1D90, 0x301501EA,
		0x1D90, 0x301601E9,
		0x1D90, 0x301701E8,
		0x1D90, 0x301801E7,
		0x1D90, 0x301901E5,
		0x1D90, 0x301A01E4,
		0x1D90, 0x301B01C5,
		0x1D90, 0x301C01C4,
		0x1D90, 0x301D01C3,
		0x1D90, 0x301E01C2,
		0x1D90, 0x301F0188,
		0x1D90, 0x30200187,
		0x1D90, 0x30210186,
		0x1D90, 0x30220184,
		0x1D90, 0x30230183,
		0x1D90, 0x30240182,
		0x1D90, 0x30250181,
		0x1D90, 0x30260148,
		0x1D90, 0x30270147,
		0x1D90, 0x30280146,
		0x1D90, 0x30290144,
		0x1D90, 0x302A0143,
		0x1D90, 0x302B0142,
		0x1D90, 0x302C0141,
		0x1D90, 0x302D00C8,
		0x1D90, 0x302E00C7,
		0x1D90, 0x302F00C6,
		0x1D90, 0x303000C5,
		0x1D90, 0x303100C4,
		0x1D90, 0x303200C3,
		0x1D90, 0x30330048,
		0x1D90, 0x30340047,
		0x1D90, 0x30350046,
		0x1D90, 0x30360045,
		0x1D90, 0x30370025,
		0x1D90, 0x30380024,
		0x1D90, 0x30390023,
		0x1D90, 0x303A0022,
		0x1D90, 0x303B0021,
		0x1D90, 0x303C0020,
		0x1D90, 0x303D0003,
		0x1D90, 0x303E0002,
		0x1D90, 0x303F0001,
	0xB0000000,	0x00000000,
	0x83ffffff,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x3040011F,
		0x1D90, 0x3041011F,
		0x1D90, 0x3042011F,
		0x1D90, 0x3043011F,
		0x1D90, 0x3044011F,
		0x1D90, 0x3045011F,
		0x1D90, 0x3046011F,
		0x1D90, 0x3047011F,
		0x1D90, 0x3048011F,
		0x1D90, 0x3049011F,
		0x1D90, 0x304A011F,
		0x1D90, 0x304B011F,
		0x1D90, 0x304C011F,
		0x1D90, 0x304D011F,
		0x1D90, 0x304E011F,
		0x1D90, 0x304F00F4,
		0x1D90, 0x305000F3,
		0x1D90, 0x305100F2,
		0x1D90, 0x305200F1,
		0x1D90, 0x305300F0,
		0x1D90, 0x305400EF,
		0x1D90, 0x305500EE,
		0x1D90, 0x305600ED,
		0x1D90, 0x305700EC,
		0x1D90, 0x305800EB,
		0x1D90, 0x305900EA,
		0x1D90, 0x305A00E9,
		0x1D90, 0x305B00E8,
		0x1D90, 0x305C00E7,
		0x1D90, 0x305D00E6,
		0x1D90, 0x305E00E4,
		0x1D90, 0x305F00E3,
		0x1D90, 0x306000E2,
		0x1D90, 0x306100C4,
		0x1D90, 0x306200C3,
		0x1D90, 0x306300C2,
		0x1D90, 0x306400A4,
		0x1D90, 0x306500A3,
		0x1D90, 0x306600A2,
		0x1D90, 0x306700A1,
		0x1D90, 0x30680084,
		0x1D90, 0x30690083,
		0x1D90, 0x306A0082,
		0x1D90, 0x306B0081,
		0x1D90, 0x306C0080,
		0x1D90, 0x306D0067,
		0x1D90, 0x306E0066,
		0x1D90, 0x306F0065,
		0x1D90, 0x30700064,
		0x1D90, 0x30710063,
		0x1D90, 0x30720044,
		0x1D90, 0x30730043,
		0x1D90, 0x30740042,
		0x1D90, 0x30750041,
		0x1D90, 0x30760024,
		0x1D90, 0x30770023,
		0x1D90, 0x30780022,
		0x1D90, 0x30790021,
		0x1D90, 0x307A0020,
		0x1D90, 0x307B0004,
		0x1D90, 0x307C0003,
		0x1D90, 0x307D0002,
		0x1D90, 0x307E0001,
		0x1D90, 0x307F0000,
	0x90ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x304001FD,
		0x1D90, 0x304101FC,
		0x1D90, 0x304201FB,
		0x1D90, 0x304301FA,
		0x1D90, 0x304401F9,
		0x1D90, 0x304501F8,
		0x1D90, 0x304601F7,
		0x1D90, 0x304701F6,
		0x1D90, 0x304801F5,
		0x1D90, 0x304901F4,
		0x1D90, 0x304A01F3,
		0x1D90, 0x304B01F2,
		0x1D90, 0x304C01F1,
		0x1D90, 0x304D01F0,
		0x1D90, 0x304E01EF,
		0x1D90, 0x304F00EE,
		0x1D90, 0x305000ED,
		0x1D90, 0x305100EC,
		0x1D90, 0x305200EB,
		0x1D90, 0x305300EA,
		0x1D90, 0x305400E9,
		0x1D90, 0x305500E8,
		0x1D90, 0x305600E7,
		0x1D90, 0x305700E6,
		0x1D90, 0x305800E5,
		0x1D90, 0x305900E4,
		0x1D90, 0x305A00E3,
		0x1D90, 0x305B00C3,
		0x1D90, 0x305C00C2,
		0x1D90, 0x305D00A4,
		0x1D90, 0x305E00A3,
		0x1D90, 0x305F00A2,
		0x1D90, 0x306000A1,
		0x1D90, 0x30610085,
		0x1D90, 0x30620084,
		0x1D90, 0x30630083,
		0x1D90, 0x30640082,
		0x1D90, 0x30650069,
		0x1D90, 0x30660068,
		0x1D90, 0x30670067,
		0x1D90, 0x30680066,
		0x1D90, 0x30690065,
		0x1D90, 0x306A0064,
		0x1D90, 0x306B0063,
		0x1D90, 0x306C0043,
		0x1D90, 0x306D0042,
		0x1D90, 0x306E0041,
		0x1D90, 0x306F0025,
		0x1D90, 0x30700024,
		0x1D90, 0x30710023,
		0x1D90, 0x30720022,
		0x1D90, 0x30730021,
		0x1D90, 0x30740020,
		0x1D90, 0x30750004,
		0x1D90, 0x30760003,
		0x1D90, 0x30770002,
		0x1D90, 0x30780001,
		0x1D90, 0x30790000,
		0x1D90, 0x307A0000,
		0x1D90, 0x307B0000,
		0x1D90, 0x307C0000,
		0x1D90, 0x307D0000,
		0x1D90, 0x307E0000,
		0x1D90, 0x307F0000,
	0x90ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x304001FD,
		0x1D90, 0x304101FC,
		0x1D90, 0x304201FB,
		0x1D90, 0x304301FA,
		0x1D90, 0x304401F9,
		0x1D90, 0x304501F8,
		0x1D90, 0x304601F7,
		0x1D90, 0x304701F6,
		0x1D90, 0x304801F5,
		0x1D90, 0x304901F4,
		0x1D90, 0x304A01F3,
		0x1D90, 0x304B01F2,
		0x1D90, 0x304C01F1,
		0x1D90, 0x304D01F0,
		0x1D90, 0x304E01EF,
		0x1D90, 0x304F00EE,
		0x1D90, 0x305000ED,
		0x1D90, 0x305100EC,
		0x1D90, 0x305200EB,
		0x1D90, 0x305300EA,
		0x1D90, 0x305400E9,
		0x1D90, 0x305500E8,
		0x1D90, 0x305600E7,
		0x1D90, 0x305700E6,
		0x1D90, 0x305800E5,
		0x1D90, 0x305900E4,
		0x1D90, 0x305A00E3,
		0x1D90, 0x305B00C3,
		0x1D90, 0x305C00C2,
		0x1D90, 0x305D00A4,
		0x1D90, 0x305E00A3,
		0x1D90, 0x305F00A2,
		0x1D90, 0x306000A1,
		0x1D90, 0x30610085,
		0x1D90, 0x30620084,
		0x1D90, 0x30630083,
		0x1D90, 0x30640082,
		0x1D90, 0x30650069,
		0x1D90, 0x30660068,
		0x1D90, 0x30670067,
		0x1D90, 0x30680066,
		0x1D90, 0x30690065,
		0x1D90, 0x306A0064,
		0x1D90, 0x306B0063,
		0x1D90, 0x306C0043,
		0x1D90, 0x306D0042,
		0x1D90, 0x306E0041,
		0x1D90, 0x306F0025,
		0x1D90, 0x30700024,
		0x1D90, 0x30710023,
		0x1D90, 0x30720022,
		0x1D90, 0x30730021,
		0x1D90, 0x30740020,
		0x1D90, 0x30750004,
		0x1D90, 0x30760003,
		0x1D90, 0x30770002,
		0x1D90, 0x30780001,
		0x1D90, 0x30790000,
		0x1D90, 0x307A0000,
		0x1D90, 0x307B0000,
		0x1D90, 0x307C0000,
		0x1D90, 0x307D0000,
		0x1D90, 0x307E0000,
		0x1D90, 0x307F0000,
	0xA0000000,	0x00000000,
		0x1D90, 0x3040011F,
		0x1D90, 0x3041011F,
		0x1D90, 0x3042011F,
		0x1D90, 0x3043011F,
		0x1D90, 0x3044011F,
		0x1D90, 0x3045011F,
		0x1D90, 0x3046011F,
		0x1D90, 0x3047011F,
		0x1D90, 0x3048011F,
		0x1D90, 0x3049011F,
		0x1D90, 0x304A011F,
		0x1D90, 0x304B011F,
		0x1D90, 0x304C011F,
		0x1D90, 0x304D011F,
		0x1D90, 0x304E011F,
		0x1D90, 0x304F00F4,
		0x1D90, 0x305000F3,
		0x1D90, 0x305100F2,
		0x1D90, 0x305200F1,
		0x1D90, 0x305300F0,
		0x1D90, 0x305400EF,
		0x1D90, 0x305500EE,
		0x1D90, 0x305600ED,
		0x1D90, 0x305700EC,
		0x1D90, 0x305800EB,
		0x1D90, 0x305900EA,
		0x1D90, 0x305A00E9,
		0x1D90, 0x305B00E8,
		0x1D90, 0x305C00E7,
		0x1D90, 0x305D00E6,
		0x1D90, 0x305E00E4,
		0x1D90, 0x305F00E3,
		0x1D90, 0x306000E2,
		0x1D90, 0x306100C4,
		0x1D90, 0x306200C3,
		0x1D90, 0x306300C2,
		0x1D90, 0x306400A4,
		0x1D90, 0x306500A3,
		0x1D90, 0x306600A2,
		0x1D90, 0x306700A1,
		0x1D90, 0x30680084,
		0x1D90, 0x30690083,
		0x1D90, 0x306A0082,
		0x1D90, 0x306B0081,
		0x1D90, 0x306C0080,
		0x1D90, 0x306D0067,
		0x1D90, 0x306E0066,
		0x1D90, 0x306F0065,
		0x1D90, 0x30700064,
		0x1D90, 0x30710063,
		0x1D90, 0x30720044,
		0x1D90, 0x30730043,
		0x1D90, 0x30740042,
		0x1D90, 0x30750041,
		0x1D90, 0x30760024,
		0x1D90, 0x30770023,
		0x1D90, 0x30780022,
		0x1D90, 0x30790021,
		0x1D90, 0x307A0020,
		0x1D90, 0x307B0004,
		0x1D90, 0x307C0003,
		0x1D90, 0x307D0002,
		0x1D90, 0x307E0001,
		0x1D90, 0x307F0000,
	0xB0000000,	0x00000000,
	0x83ffffff,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x308000FF,
		0x1D90, 0x308100FF,
		0x1D90, 0x308200FF,
		0x1D90, 0x308300FF,
		0x1D90, 0x308400FF,
		0x1D90, 0x308500FF,
		0x1D90, 0x308600FE,
		0x1D90, 0x308700FD,
		0x1D90, 0x308800FC,
		0x1D90, 0x308900FB,
		0x1D90, 0x308A00FA,
		0x1D90, 0x308B00F9,
		0x1D90, 0x308C00F8,
		0x1D90, 0x308D00F7,
		0x1D90, 0x308E00F6,
		0x1D90, 0x308F00F5,
		0x1D90, 0x309000F4,
		0x1D90, 0x309100F3,
		0x1D90, 0x309200F2,
		0x1D90, 0x309300F1,
		0x1D90, 0x309400F0,
		0x1D90, 0x309500EF,
		0x1D90, 0x309600EE,
		0x1D90, 0x309700ED,
		0x1D90, 0x309800EC,
		0x1D90, 0x309900EB,
		0x1D90, 0x309A00EA,
		0x1D90, 0x309B00E8,
		0x1D90, 0x309C00E7,
		0x1D90, 0x309D00E6,
		0x1D90, 0x309E00E5,
		0x1D90, 0x309F00E4,
		0x1D90, 0x30A000C4,
		0x1D90, 0x30A100C3,
		0x1D90, 0x30A200C2,
		0x1D90, 0x30A300C1,
		0x1D90, 0x30A400A3,
		0x1D90, 0x30A500A2,
		0x1D90, 0x30A600A1,
		0x1D90, 0x30A70085,
		0x1D90, 0x30A80084,
		0x1D90, 0x30A90083,
		0x1D90, 0x30AA0082,
		0x1D90, 0x30AB0081,
		0x1D90, 0x30AC0067,
		0x1D90, 0x30AD0066,
		0x1D90, 0x30AE0065,
		0x1D90, 0x30AF0064,
		0x1D90, 0x30B00063,
		0x1D90, 0x30B10044,
		0x1D90, 0x30B20043,
		0x1D90, 0x30B30042,
		0x1D90, 0x30B40026,
		0x1D90, 0x30B50025,
		0x1D90, 0x30B60024,
		0x1D90, 0x30B70023,
		0x1D90, 0x30B80022,
		0x1D90, 0x30B90021,
		0x1D90, 0x30BA0005,
		0x1D90, 0x30BB0004,
		0x1D90, 0x30BC0003,
		0x1D90, 0x30BD0002,
		0x1D90, 0x30BE0001,
		0x1D90, 0x30BF0000,
	0x90ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x308000FA,
		0x1D90, 0x308100F9,
		0x1D90, 0x308200F8,
		0x1D90, 0x308300F7,
		0x1D90, 0x308400F6,
		0x1D90, 0x308500F5,
		0x1D90, 0x308600F4,
		0x1D90, 0x308700F3,
		0x1D90, 0x308800F2,
		0x1D90, 0x308900F1,
		0x1D90, 0x308A00F0,
		0x1D90, 0x308B00EF,
		0x1D90, 0x308C00EE,
		0x1D90, 0x308D00ED,
		0x1D90, 0x308E00EC,
		0x1D90, 0x308F00EB,
		0x1D90, 0x309000EA,
		0x1D90, 0x309100E8,
		0x1D90, 0x309200E7,
		0x1D90, 0x309300E6,
		0x1D90, 0x309400E5,
		0x1D90, 0x309500E4,
		0x1D90, 0x309600C4,
		0x1D90, 0x309700C3,
		0x1D90, 0x309800C2,
		0x1D90, 0x309900C1,
		0x1D90, 0x309A00A3,
		0x1D90, 0x309B00A2,
		0x1D90, 0x309C00A1,
		0x1D90, 0x309D0085,
		0x1D90, 0x309E0084,
		0x1D90, 0x309F0083,
		0x1D90, 0x30A00082,
		0x1D90, 0x30A10081,
		0x1D90, 0x30A20067,
		0x1D90, 0x30A30066,
		0x1D90, 0x30A40065,
		0x1D90, 0x30A50064,
		0x1D90, 0x30A60063,
		0x1D90, 0x30A70044,
		0x1D90, 0x30A80043,
		0x1D90, 0x30A90042,
		0x1D90, 0x30AA0026,
		0x1D90, 0x30AB0025,
		0x1D90, 0x30AC0024,
		0x1D90, 0x30AD0023,
		0x1D90, 0x30AE0022,
		0x1D90, 0x30AF0021,
		0x1D90, 0x30B00005,
		0x1D90, 0x30B10004,
		0x1D90, 0x30B20003,
		0x1D90, 0x30B30002,
		0x1D90, 0x30B40001,
		0x1D90, 0x30B50000,
		0x1D90, 0x30B60000,
		0x1D90, 0x30B70000,
		0x1D90, 0x30B80000,
		0x1D90, 0x30B90000,
		0x1D90, 0x30BA0000,
		0x1D90, 0x30BB0000,
		0x1D90, 0x30BC0000,
		0x1D90, 0x30BD0000,
		0x1D90, 0x30BE0000,
		0x1D90, 0x30BF0000,
	0x90ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x308000FA,
		0x1D90, 0x308100F9,
		0x1D90, 0x308200F8,
		0x1D90, 0x308300F7,
		0x1D90, 0x308400F6,
		0x1D90, 0x308500F5,
		0x1D90, 0x308600F4,
		0x1D90, 0x308700F3,
		0x1D90, 0x308800F2,
		0x1D90, 0x308900F1,
		0x1D90, 0x308A00F0,
		0x1D90, 0x308B00EF,
		0x1D90, 0x308C00EE,
		0x1D90, 0x308D00ED,
		0x1D90, 0x308E00EC,
		0x1D90, 0x308F00EB,
		0x1D90, 0x309000EA,
		0x1D90, 0x309100E8,
		0x1D90, 0x309200E7,
		0x1D90, 0x309300E6,
		0x1D90, 0x309400E5,
		0x1D90, 0x309500E4,
		0x1D90, 0x309600C4,
		0x1D90, 0x309700C3,
		0x1D90, 0x309800C2,
		0x1D90, 0x309900C1,
		0x1D90, 0x309A00A3,
		0x1D90, 0x309B00A2,
		0x1D90, 0x309C00A1,
		0x1D90, 0x309D0085,
		0x1D90, 0x309E0084,
		0x1D90, 0x309F0083,
		0x1D90, 0x30A00082,
		0x1D90, 0x30A10081,
		0x1D90, 0x30A20067,
		0x1D90, 0x30A30066,
		0x1D90, 0x30A40065,
		0x1D90, 0x30A50064,
		0x1D90, 0x30A60063,
		0x1D90, 0x30A70044,
		0x1D90, 0x30A80043,
		0x1D90, 0x30A90042,
		0x1D90, 0x30AA0026,
		0x1D90, 0x30AB0025,
		0x1D90, 0x30AC0024,
		0x1D90, 0x30AD0023,
		0x1D90, 0x30AE0022,
		0x1D90, 0x30AF0021,
		0x1D90, 0x30B00005,
		0x1D90, 0x30B10004,
		0x1D90, 0x30B20003,
		0x1D90, 0x30B30002,
		0x1D90, 0x30B40001,
		0x1D90, 0x30B50000,
		0x1D90, 0x30B60000,
		0x1D90, 0x30B70000,
		0x1D90, 0x30B80000,
		0x1D90, 0x30B90000,
		0x1D90, 0x30BA0000,
		0x1D90, 0x30BB0000,
		0x1D90, 0x30BC0000,
		0x1D90, 0x30BD0000,
		0x1D90, 0x30BE0000,
		0x1D90, 0x30BF0000,
	0xA0000000,	0x00000000,
		0x1D90, 0x308000FF,
		0x1D90, 0x308100FF,
		0x1D90, 0x308200FF,
		0x1D90, 0x308300FF,
		0x1D90, 0x308400FF,
		0x1D90, 0x308500FF,
		0x1D90, 0x308600FE,
		0x1D90, 0x308700FD,
		0x1D90, 0x308800FC,
		0x1D90, 0x308900FB,
		0x1D90, 0x308A00FA,
		0x1D90, 0x308B00F9,
		0x1D90, 0x308C00F8,
		0x1D90, 0x308D00F7,
		0x1D90, 0x308E00F6,
		0x1D90, 0x308F00F5,
		0x1D90, 0x309000F4,
		0x1D90, 0x309100F3,
		0x1D90, 0x309200F2,
		0x1D90, 0x309300F1,
		0x1D90, 0x309400F0,
		0x1D90, 0x309500EF,
		0x1D90, 0x309600EE,
		0x1D90, 0x309700ED,
		0x1D90, 0x309800EC,
		0x1D90, 0x309900EB,
		0x1D90, 0x309A00EA,
		0x1D90, 0x309B00E8,
		0x1D90, 0x309C00E7,
		0x1D90, 0x309D00E6,
		0x1D90, 0x309E00E5,
		0x1D90, 0x309F00E4,
		0x1D90, 0x30A000C4,
		0x1D90, 0x30A100C3,
		0x1D90, 0x30A200C2,
		0x1D90, 0x30A300C1,
		0x1D90, 0x30A400A3,
		0x1D90, 0x30A500A2,
		0x1D90, 0x30A600A1,
		0x1D90, 0x30A70085,
		0x1D90, 0x30A80084,
		0x1D90, 0x30A90083,
		0x1D90, 0x30AA0082,
		0x1D90, 0x30AB0081,
		0x1D90, 0x30AC0067,
		0x1D90, 0x30AD0066,
		0x1D90, 0x30AE0065,
		0x1D90, 0x30AF0064,
		0x1D90, 0x30B00063,
		0x1D90, 0x30B10044,
		0x1D90, 0x30B20043,
		0x1D90, 0x30B30042,
		0x1D90, 0x30B40026,
		0x1D90, 0x30B50025,
		0x1D90, 0x30B60024,
		0x1D90, 0x30B70023,
		0x1D90, 0x30B80022,
		0x1D90, 0x30B90021,
		0x1D90, 0x30BA0005,
		0x1D90, 0x30BB0004,
		0x1D90, 0x30BC0003,
		0x1D90, 0x30BD0002,
		0x1D90, 0x30BE0001,
		0x1D90, 0x30BF0000,
	0xB0000000,	0x00000000,
	0x83ffffff,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x30C000FF,
		0x1D90, 0x30C100FF,
		0x1D90, 0x30C200FF,
		0x1D90, 0x30C300FF,
		0x1D90, 0x30C400FF,
		0x1D90, 0x30C500FF,
		0x1D90, 0x30C600FE,
		0x1D90, 0x30C700FD,
		0x1D90, 0x30C800FC,
		0x1D90, 0x30C900FB,
		0x1D90, 0x30CA00FA,
		0x1D90, 0x30CB00F9,
		0x1D90, 0x30CC00F8,
		0x1D90, 0x30CD00F7,
		0x1D90, 0x30CE00F6,
		0x1D90, 0x30CF00F5,
		0x1D90, 0x30D000F4,
		0x1D90, 0x30D100F3,
		0x1D90, 0x30D200F2,
		0x1D90, 0x30D300F1,
		0x1D90, 0x30D400F0,
		0x1D90, 0x30D500EF,
		0x1D90, 0x30D600EE,
		0x1D90, 0x30D700ED,
		0x1D90, 0x30D800EC,
		0x1D90, 0x30D900EB,
		0x1D90, 0x30DA00EA,
		0x1D90, 0x30DB00E8,
		0x1D90, 0x30DC00E7,
		0x1D90, 0x30DD00E6,
		0x1D90, 0x30DE00E5,
		0x1D90, 0x30DF00E4,
		0x1D90, 0x30E000E3,
		0x1D90, 0x30E100E2,
		0x1D90, 0x30E200A6,
		0x1D90, 0x30E300A5,
		0x1D90, 0x30E400A4,
		0x1D90, 0x30E500A3,
		0x1D90, 0x30E600A2,
		0x1D90, 0x30E70086,
		0x1D90, 0x30E80085,
		0x1D90, 0x30E90084,
		0x1D90, 0x30EA0083,
		0x1D90, 0x30EB0082,
		0x1D90, 0x30EC0067,
		0x1D90, 0x30ED0066,
		0x1D90, 0x30EE0065,
		0x1D90, 0x30EF0064,
		0x1D90, 0x30F00063,
		0x1D90, 0x30F10045,
		0x1D90, 0x30F20044,
		0x1D90, 0x30F30043,
		0x1D90, 0x30F40042,
		0x1D90, 0x30F50025,
		0x1D90, 0x30F60024,
		0x1D90, 0x30F70023,
		0x1D90, 0x30F80022,
		0x1D90, 0x30F90021,
		0x1D90, 0x30FA0005,
		0x1D90, 0x30FB0004,
		0x1D90, 0x30FC0003,
		0x1D90, 0x30FD0002,
		0x1D90, 0x30FE0001,
		0x1D90, 0x30FF0000,
	0x90ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x30C000F8,
		0x1D90, 0x30C100F7,
		0x1D90, 0x30C200F6,
		0x1D90, 0x30C300F5,
		0x1D90, 0x30C400F4,
		0x1D90, 0x30C500F3,
		0x1D90, 0x30C600F2,
		0x1D90, 0x30C700F1,
		0x1D90, 0x30C800F0,
		0x1D90, 0x30C900EF,
		0x1D90, 0x30CA00EE,
		0x1D90, 0x30CB00ED,
		0x1D90, 0x30CC00EC,
		0x1D90, 0x30CD00EB,
		0x1D90, 0x30CE00EA,
		0x1D90, 0x30CF00E8,
		0x1D90, 0x30D000E7,
		0x1D90, 0x30D100E6,
		0x1D90, 0x30D200E5,
		0x1D90, 0x30D300E4,
		0x1D90, 0x30D400E3,
		0x1D90, 0x30D500E2,
		0x1D90, 0x30D600A6,
		0x1D90, 0x30D700A5,
		0x1D90, 0x30D800A4,
		0x1D90, 0x30D900A3,
		0x1D90, 0x30DA00A2,
		0x1D90, 0x30DB0086,
		0x1D90, 0x30DC0085,
		0x1D90, 0x30DD0084,
		0x1D90, 0x30DE0083,
		0x1D90, 0x30DF0081,
		0x1D90, 0x30E00068,
		0x1D90, 0x30E10067,
		0x1D90, 0x30E20066,
		0x1D90, 0x30E30065,
		0x1D90, 0x30E40064,
		0x1D90, 0x30E50045,
		0x1D90, 0x30E60044,
		0x1D90, 0x30E70043,
		0x1D90, 0x30E80042,
		0x1D90, 0x30E90025,
		0x1D90, 0x30EA0024,
		0x1D90, 0x30EB0023,
		0x1D90, 0x30EC0022,
		0x1D90, 0x30ED0021,
		0x1D90, 0x30EE0005,
		0x1D90, 0x30EF0004,
		0x1D90, 0x30F00003,
		0x1D90, 0x30F10002,
		0x1D90, 0x30F20001,
		0x1D90, 0x30F30000,
		0x1D90, 0x30F40000,
		0x1D90, 0x30F50000,
		0x1D90, 0x30F60000,
		0x1D90, 0x30F70000,
		0x1D90, 0x30F80000,
		0x1D90, 0x30F90000,
		0x1D90, 0x30FA0000,
		0x1D90, 0x30FB0000,
		0x1D90, 0x30FC0000,
		0x1D90, 0x30FD0000,
		0x1D90, 0x30FE0000,
		0x1D90, 0x30FF0000,
	0x90ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x30C000F8,
		0x1D90, 0x30C100F7,
		0x1D90, 0x30C200F6,
		0x1D90, 0x30C300F5,
		0x1D90, 0x30C400F4,
		0x1D90, 0x30C500F3,
		0x1D90, 0x30C600F2,
		0x1D90, 0x30C700F1,
		0x1D90, 0x30C800F0,
		0x1D90, 0x30C900EF,
		0x1D90, 0x30CA00EE,
		0x1D90, 0x30CB00ED,
		0x1D90, 0x30CC00EC,
		0x1D90, 0x30CD00EB,
		0x1D90, 0x30CE00EA,
		0x1D90, 0x30CF00E8,
		0x1D90, 0x30D000E7,
		0x1D90, 0x30D100E6,
		0x1D90, 0x30D200E5,
		0x1D90, 0x30D300E4,
		0x1D90, 0x30D400E3,
		0x1D90, 0x30D500E2,
		0x1D90, 0x30D600A6,
		0x1D90, 0x30D700A5,
		0x1D90, 0x30D800A4,
		0x1D90, 0x30D900A3,
		0x1D90, 0x30DA00A2,
		0x1D90, 0x30DB0086,
		0x1D90, 0x30DC0085,
		0x1D90, 0x30DD0084,
		0x1D90, 0x30DE0083,
		0x1D90, 0x30DF0081,
		0x1D90, 0x30E00068,
		0x1D90, 0x30E10067,
		0x1D90, 0x30E20066,
		0x1D90, 0x30E30065,
		0x1D90, 0x30E40064,
		0x1D90, 0x30E50045,
		0x1D90, 0x30E60044,
		0x1D90, 0x30E70043,
		0x1D90, 0x30E80042,
		0x1D90, 0x30E90025,
		0x1D90, 0x30EA0024,
		0x1D90, 0x30EB0023,
		0x1D90, 0x30EC0022,
		0x1D90, 0x30ED0021,
		0x1D90, 0x30EE0005,
		0x1D90, 0x30EF0004,
		0x1D90, 0x30F00003,
		0x1D90, 0x30F10002,
		0x1D90, 0x30F20001,
		0x1D90, 0x30F30000,
		0x1D90, 0x30F40000,
		0x1D90, 0x30F50000,
		0x1D90, 0x30F60000,
		0x1D90, 0x30F70000,
		0x1D90, 0x30F80000,
		0x1D90, 0x30F90000,
		0x1D90, 0x30FA0000,
		0x1D90, 0x30FB0000,
		0x1D90, 0x30FC0000,
		0x1D90, 0x30FD0000,
		0x1D90, 0x30FE0000,
		0x1D90, 0x30FF0000,
	0xA0000000,	0x00000000,
		0x1D90, 0x30C000FF,
		0x1D90, 0x30C100FF,
		0x1D90, 0x30C200FF,
		0x1D90, 0x30C300FF,
		0x1D90, 0x30C400FF,
		0x1D90, 0x30C500FF,
		0x1D90, 0x30C600FE,
		0x1D90, 0x30C700FD,
		0x1D90, 0x30C800FC,
		0x1D90, 0x30C900FB,
		0x1D90, 0x30CA00FA,
		0x1D90, 0x30CB00F9,
		0x1D90, 0x30CC00F8,
		0x1D90, 0x30CD00F7,
		0x1D90, 0x30CE00F6,
		0x1D90, 0x30CF00F5,
		0x1D90, 0x30D000F4,
		0x1D90, 0x30D100F3,
		0x1D90, 0x30D200F2,
		0x1D90, 0x30D300F1,
		0x1D90, 0x30D400F0,
		0x1D90, 0x30D500EF,
		0x1D90, 0x30D600EE,
		0x1D90, 0x30D700ED,
		0x1D90, 0x30D800EC,
		0x1D90, 0x30D900EB,
		0x1D90, 0x30DA00EA,
		0x1D90, 0x30DB00E8,
		0x1D90, 0x30DC00E7,
		0x1D90, 0x30DD00E6,
		0x1D90, 0x30DE00E5,
		0x1D90, 0x30DF00E4,
		0x1D90, 0x30E000E3,
		0x1D90, 0x30E100E2,
		0x1D90, 0x30E200A6,
		0x1D90, 0x30E300A5,
		0x1D90, 0x30E400A4,
		0x1D90, 0x30E500A3,
		0x1D90, 0x30E600A2,
		0x1D90, 0x30E70086,
		0x1D90, 0x30E80085,
		0x1D90, 0x30E90084,
		0x1D90, 0x30EA0083,
		0x1D90, 0x30EB0082,
		0x1D90, 0x30EC0067,
		0x1D90, 0x30ED0066,
		0x1D90, 0x30EE0065,
		0x1D90, 0x30EF0064,
		0x1D90, 0x30F00063,
		0x1D90, 0x30F10045,
		0x1D90, 0x30F20044,
		0x1D90, 0x30F30043,
		0x1D90, 0x30F40042,
		0x1D90, 0x30F50025,
		0x1D90, 0x30F60024,
		0x1D90, 0x30F70023,
		0x1D90, 0x30F80022,
		0x1D90, 0x30F90021,
		0x1D90, 0x30FA0005,
		0x1D90, 0x30FB0004,
		0x1D90, 0x30FC0003,
		0x1D90, 0x30FD0002,
		0x1D90, 0x30FE0001,
		0x1D90, 0x30FF0000,
	0xB0000000,	0x00000000,
	0x83ffffff,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x310001FF,
		0x1D90, 0x310101FF,
		0x1D90, 0x310201FF,
		0x1D90, 0x310301FF,
		0x1D90, 0x310401FE,
		0x1D90, 0x310501FD,
		0x1D90, 0x310601FC,
		0x1D90, 0x310701FB,
		0x1D90, 0x310801FA,
		0x1D90, 0x310901F9,
		0x1D90, 0x310A01F8,
		0x1D90, 0x310B01F7,
		0x1D90, 0x310C01F6,
		0x1D90, 0x310D01F5,
		0x1D90, 0x310E01F4,
		0x1D90, 0x310F01F3,
		0x1D90, 0x311001F2,
		0x1D90, 0x311101F1,
		0x1D90, 0x311201F0,
		0x1D90, 0x311301EF,
		0x1D90, 0x311401EE,
		0x1D90, 0x311501ED,
		0x1D90, 0x311601EC,
		0x1D90, 0x311701EB,
		0x1D90, 0x311801EA,
		0x1D90, 0x311901E9,
		0x1D90, 0x311A01E8,
		0x1D90, 0x311B01E7,
		0x1D90, 0x311C01E5,
		0x1D90, 0x311D01E4,
		0x1D90, 0x311E01C5,
		0x1D90, 0x311F01C4,
		0x1D90, 0x312001C3,
		0x1D90, 0x312101C2,
		0x1D90, 0x31220188,
		0x1D90, 0x31230187,
		0x1D90, 0x31240186,
		0x1D90, 0x31250184,
		0x1D90, 0x31260183,
		0x1D90, 0x31270182,
		0x1D90, 0x31280181,
		0x1D90, 0x31290148,
		0x1D90, 0x312A0147,
		0x1D90, 0x312B0146,
		0x1D90, 0x312C0144,
		0x1D90, 0x312D0143,
		0x1D90, 0x312E0142,
		0x1D90, 0x312F0141,
		0x1D90, 0x313000C8,
		0x1D90, 0x313100C7,
		0x1D90, 0x313200C6,
		0x1D90, 0x313300C5,
		0x1D90, 0x313400C4,
		0x1D90, 0x313500C3,
		0x1D90, 0x31360048,
		0x1D90, 0x31370047,
		0x1D90, 0x31380046,
		0x1D90, 0x31390045,
		0x1D90, 0x313A0025,
		0x1D90, 0x313B0024,
		0x1D90, 0x313C0023,
		0x1D90, 0x313D0022,
		0x1D90, 0x313E0021,
		0x1D90, 0x313F0020,
	0x90ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x310001FF,
		0x1D90, 0x310101FF,
		0x1D90, 0x310201FF,
		0x1D90, 0x310301FF,
		0x1D90, 0x310401FE,
		0x1D90, 0x310501FD,
		0x1D90, 0x310601FC,
		0x1D90, 0x310701FB,
		0x1D90, 0x310801FA,
		0x1D90, 0x310901F9,
		0x1D90, 0x310A01F8,
		0x1D90, 0x310B01F7,
		0x1D90, 0x310C01F6,
		0x1D90, 0x310D01F5,
		0x1D90, 0x310E01F4,
		0x1D90, 0x310F01F3,
		0x1D90, 0x311001F2,
		0x1D90, 0x311101F1,
		0x1D90, 0x311201F0,
		0x1D90, 0x311301EF,
		0x1D90, 0x311401EE,
		0x1D90, 0x311501ED,
		0x1D90, 0x311601EC,
		0x1D90, 0x311701EB,
		0x1D90, 0x311801EA,
		0x1D90, 0x311901E9,
		0x1D90, 0x311A01E8,
		0x1D90, 0x311B01E7,
		0x1D90, 0x311C01E5,
		0x1D90, 0x311D01E4,
		0x1D90, 0x311E01C5,
		0x1D90, 0x311F01C4,
		0x1D90, 0x312001C3,
		0x1D90, 0x312101C2,
		0x1D90, 0x31220188,
		0x1D90, 0x31230187,
		0x1D90, 0x31240186,
		0x1D90, 0x31250184,
		0x1D90, 0x31260183,
		0x1D90, 0x31270182,
		0x1D90, 0x31280181,
		0x1D90, 0x31290148,
		0x1D90, 0x312A0147,
		0x1D90, 0x312B0146,
		0x1D90, 0x312C0144,
		0x1D90, 0x312D0143,
		0x1D90, 0x312E0142,
		0x1D90, 0x312F0141,
		0x1D90, 0x313000C8,
		0x1D90, 0x313100C7,
		0x1D90, 0x313200C6,
		0x1D90, 0x313300C5,
		0x1D90, 0x313400C4,
		0x1D90, 0x313500C3,
		0x1D90, 0x31360048,
		0x1D90, 0x31370047,
		0x1D90, 0x31380046,
		0x1D90, 0x31390045,
		0x1D90, 0x313A0025,
		0x1D90, 0x313B0024,
		0x1D90, 0x313C0023,
		0x1D90, 0x313D0022,
		0x1D90, 0x313E0021,
		0x1D90, 0x313F0020,
	0x90ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x310001FF,
		0x1D90, 0x310101FF,
		0x1D90, 0x310201FF,
		0x1D90, 0x310301FF,
		0x1D90, 0x310401FE,
		0x1D90, 0x310501FD,
		0x1D90, 0x310601FC,
		0x1D90, 0x310701FB,
		0x1D90, 0x310801FA,
		0x1D90, 0x310901F9,
		0x1D90, 0x310A01F8,
		0x1D90, 0x310B01F7,
		0x1D90, 0x310C01F6,
		0x1D90, 0x310D01F5,
		0x1D90, 0x310E01F4,
		0x1D90, 0x310F01F3,
		0x1D90, 0x311001F2,
		0x1D90, 0x311101F1,
		0x1D90, 0x311201F0,
		0x1D90, 0x311301EF,
		0x1D90, 0x311401EE,
		0x1D90, 0x311501ED,
		0x1D90, 0x311601EC,
		0x1D90, 0x311701EB,
		0x1D90, 0x311801EA,
		0x1D90, 0x311901E9,
		0x1D90, 0x311A01E8,
		0x1D90, 0x311B01E7,
		0x1D90, 0x311C01E5,
		0x1D90, 0x311D01E4,
		0x1D90, 0x311E01C5,
		0x1D90, 0x311F01C4,
		0x1D90, 0x312001C3,
		0x1D90, 0x312101C2,
		0x1D90, 0x31220188,
		0x1D90, 0x31230187,
		0x1D90, 0x31240186,
		0x1D90, 0x31250184,
		0x1D90, 0x31260183,
		0x1D90, 0x31270182,
		0x1D90, 0x31280181,
		0x1D90, 0x31290148,
		0x1D90, 0x312A0147,
		0x1D90, 0x312B0146,
		0x1D90, 0x312C0144,
		0x1D90, 0x312D0143,
		0x1D90, 0x312E0142,
		0x1D90, 0x312F0141,
		0x1D90, 0x313000C8,
		0x1D90, 0x313100C7,
		0x1D90, 0x313200C6,
		0x1D90, 0x313300C5,
		0x1D90, 0x313400C4,
		0x1D90, 0x313500C3,
		0x1D90, 0x31360048,
		0x1D90, 0x31370047,
		0x1D90, 0x31380046,
		0x1D90, 0x31390045,
		0x1D90, 0x313A0025,
		0x1D90, 0x313B0024,
		0x1D90, 0x313C0023,
		0x1D90, 0x313D0022,
		0x1D90, 0x313E0021,
		0x1D90, 0x313F0020,
	0xA0000000,	0x00000000,
		0x1D90, 0x310001FF,
		0x1D90, 0x310101FF,
		0x1D90, 0x310201FF,
		0x1D90, 0x310301FF,
		0x1D90, 0x310401FE,
		0x1D90, 0x310501FD,
		0x1D90, 0x310601FC,
		0x1D90, 0x310701FB,
		0x1D90, 0x310801FA,
		0x1D90, 0x310901F9,
		0x1D90, 0x310A01F8,
		0x1D90, 0x310B01F7,
		0x1D90, 0x310C01F6,
		0x1D90, 0x310D01F5,
		0x1D90, 0x310E01F4,
		0x1D90, 0x310F01F3,
		0x1D90, 0x311001F2,
		0x1D90, 0x311101F1,
		0x1D90, 0x311201F0,
		0x1D90, 0x311301EF,
		0x1D90, 0x311401EE,
		0x1D90, 0x311501ED,
		0x1D90, 0x311601EC,
		0x1D90, 0x311701EB,
		0x1D90, 0x311801EA,
		0x1D90, 0x311901E9,
		0x1D90, 0x311A01E8,
		0x1D90, 0x311B01E7,
		0x1D90, 0x311C01E5,
		0x1D90, 0x311D01E4,
		0x1D90, 0x311E01C5,
		0x1D90, 0x311F01C4,
		0x1D90, 0x312001C3,
		0x1D90, 0x312101C2,
		0x1D90, 0x31220188,
		0x1D90, 0x31230187,
		0x1D90, 0x31240186,
		0x1D90, 0x31250184,
		0x1D90, 0x31260183,
		0x1D90, 0x31270182,
		0x1D90, 0x31280181,
		0x1D90, 0x31290148,
		0x1D90, 0x312A0147,
		0x1D90, 0x312B0146,
		0x1D90, 0x312C0144,
		0x1D90, 0x312D0143,
		0x1D90, 0x312E0142,
		0x1D90, 0x312F0141,
		0x1D90, 0x313000C8,
		0x1D90, 0x313100C7,
		0x1D90, 0x313200C6,
		0x1D90, 0x313300C5,
		0x1D90, 0x313400C4,
		0x1D90, 0x313500C3,
		0x1D90, 0x31360048,
		0x1D90, 0x31370047,
		0x1D90, 0x31380046,
		0x1D90, 0x31390045,
		0x1D90, 0x313A0025,
		0x1D90, 0x313B0024,
		0x1D90, 0x313C0023,
		0x1D90, 0x313D0022,
		0x1D90, 0x313E0021,
		0x1D90, 0x313F0020,
	0xB0000000,	0x00000000,
	0x83ffffff,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x314001FF,
		0x1D90, 0x314101FF,
		0x1D90, 0x314201FF,
		0x1D90, 0x314301FF,
		0x1D90, 0x314401FF,
		0x1D90, 0x314501FF,
		0x1D90, 0x314601FE,
		0x1D90, 0x314701FD,
		0x1D90, 0x314801FC,
		0x1D90, 0x314901FB,
		0x1D90, 0x314A01FA,
		0x1D90, 0x314B01F9,
		0x1D90, 0x314C01F8,
		0x1D90, 0x314D01F7,
		0x1D90, 0x314E01F6,
		0x1D90, 0x314F01F5,
		0x1D90, 0x315001F4,
		0x1D90, 0x315101F3,
		0x1D90, 0x315201F2,
		0x1D90, 0x315301F1,
		0x1D90, 0x315401F0,
		0x1D90, 0x315501EF,
		0x1D90, 0x315601EE,
		0x1D90, 0x315701ED,
		0x1D90, 0x315801EC,
		0x1D90, 0x315901EB,
		0x1D90, 0x315A01EA,
		0x1D90, 0x315B01E9,
		0x1D90, 0x315C01E7,
		0x1D90, 0x315D01E6,
		0x1D90, 0x315E01E5,
		0x1D90, 0x315F01E4,
		0x1D90, 0x316001A8,
		0x1D90, 0x316101A7,
		0x1D90, 0x316201A6,
		0x1D90, 0x316301A5,
		0x1D90, 0x31640185,
		0x1D90, 0x31650184,
		0x1D90, 0x31660183,
		0x1D90, 0x31670182,
		0x1D90, 0x31680149,
		0x1D90, 0x31690148,
		0x1D90, 0x316A0147,
		0x1D90, 0x316B0145,
		0x1D90, 0x316C0144,
		0x1D90, 0x316D0143,
		0x1D90, 0x316E0142,
		0x1D90, 0x316F00E6,
		0x1D90, 0x317000E5,
		0x1D90, 0x317100C9,
		0x1D90, 0x317200C8,
		0x1D90, 0x317300C7,
		0x1D90, 0x317400C6,
		0x1D90, 0x317500C5,
		0x1D90, 0x317600C4,
		0x1D90, 0x317700C3,
		0x1D90, 0x31780088,
		0x1D90, 0x31790087,
		0x1D90, 0x317A0086,
		0x1D90, 0x317B0085,
		0x1D90, 0x317C0026,
		0x1D90, 0x317D0025,
		0x1D90, 0x317E0024,
		0x1D90, 0x317F0023,
	0x90ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x314001FF,
		0x1D90, 0x314101FF,
		0x1D90, 0x314201FF,
		0x1D90, 0x314301FF,
		0x1D90, 0x314401FF,
		0x1D90, 0x314501FF,
		0x1D90, 0x314601FE,
		0x1D90, 0x314701FD,
		0x1D90, 0x314801FC,
		0x1D90, 0x314901FB,
		0x1D90, 0x314A01FA,
		0x1D90, 0x314B01F9,
		0x1D90, 0x314C01F8,
		0x1D90, 0x314D01F7,
		0x1D90, 0x314E01F6,
		0x1D90, 0x314F01F5,
		0x1D90, 0x315001F4,
		0x1D90, 0x315101F3,
		0x1D90, 0x315201F2,
		0x1D90, 0x315301F1,
		0x1D90, 0x315401F0,
		0x1D90, 0x315501EF,
		0x1D90, 0x315601EE,
		0x1D90, 0x315701ED,
		0x1D90, 0x315801EC,
		0x1D90, 0x315901EB,
		0x1D90, 0x315A01EA,
		0x1D90, 0x315B01E9,
		0x1D90, 0x315C01E7,
		0x1D90, 0x315D01E6,
		0x1D90, 0x315E01E5,
		0x1D90, 0x315F01E4,
		0x1D90, 0x316001A8,
		0x1D90, 0x316101A7,
		0x1D90, 0x316201A6,
		0x1D90, 0x316301A5,
		0x1D90, 0x31640185,
		0x1D90, 0x31650184,
		0x1D90, 0x31660183,
		0x1D90, 0x31670182,
		0x1D90, 0x31680149,
		0x1D90, 0x31690148,
		0x1D90, 0x316A0147,
		0x1D90, 0x316B0145,
		0x1D90, 0x316C0144,
		0x1D90, 0x316D0143,
		0x1D90, 0x316E0142,
		0x1D90, 0x316F00E6,
		0x1D90, 0x317000E5,
		0x1D90, 0x317100C9,
		0x1D90, 0x317200C8,
		0x1D90, 0x317300C7,
		0x1D90, 0x317400C6,
		0x1D90, 0x317500C5,
		0x1D90, 0x317600C4,
		0x1D90, 0x317700C3,
		0x1D90, 0x31780088,
		0x1D90, 0x31790087,
		0x1D90, 0x317A0086,
		0x1D90, 0x317B0085,
		0x1D90, 0x317C0026,
		0x1D90, 0x317D0025,
		0x1D90, 0x317E0024,
		0x1D90, 0x317F0023,
	0x90ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x314001FF,
		0x1D90, 0x314101FF,
		0x1D90, 0x314201FF,
		0x1D90, 0x314301FF,
		0x1D90, 0x314401FF,
		0x1D90, 0x314501FF,
		0x1D90, 0x314601FE,
		0x1D90, 0x314701FD,
		0x1D90, 0x314801FC,
		0x1D90, 0x314901FB,
		0x1D90, 0x314A01FA,
		0x1D90, 0x314B01F9,
		0x1D90, 0x314C01F8,
		0x1D90, 0x314D01F7,
		0x1D90, 0x314E01F6,
		0x1D90, 0x314F01F5,
		0x1D90, 0x315001F4,
		0x1D90, 0x315101F3,
		0x1D90, 0x315201F2,
		0x1D90, 0x315301F1,
		0x1D90, 0x315401F0,
		0x1D90, 0x315501EF,
		0x1D90, 0x315601EE,
		0x1D90, 0x315701ED,
		0x1D90, 0x315801EC,
		0x1D90, 0x315901EB,
		0x1D90, 0x315A01EA,
		0x1D90, 0x315B01E9,
		0x1D90, 0x315C01E7,
		0x1D90, 0x315D01E6,
		0x1D90, 0x315E01E5,
		0x1D90, 0x315F01E4,
		0x1D90, 0x316001A8,
		0x1D90, 0x316101A7,
		0x1D90, 0x316201A6,
		0x1D90, 0x316301A5,
		0x1D90, 0x31640185,
		0x1D90, 0x31650184,
		0x1D90, 0x31660183,
		0x1D90, 0x31670182,
		0x1D90, 0x31680149,
		0x1D90, 0x31690148,
		0x1D90, 0x316A0147,
		0x1D90, 0x316B0145,
		0x1D90, 0x316C0144,
		0x1D90, 0x316D0143,
		0x1D90, 0x316E0142,
		0x1D90, 0x316F00E6,
		0x1D90, 0x317000E5,
		0x1D90, 0x317100C9,
		0x1D90, 0x317200C8,
		0x1D90, 0x317300C7,
		0x1D90, 0x317400C6,
		0x1D90, 0x317500C5,
		0x1D90, 0x317600C4,
		0x1D90, 0x317700C3,
		0x1D90, 0x31780088,
		0x1D90, 0x31790087,
		0x1D90, 0x317A0086,
		0x1D90, 0x317B0085,
		0x1D90, 0x317C0026,
		0x1D90, 0x317D0025,
		0x1D90, 0x317E0024,
		0x1D90, 0x317F0023,
	0xA0000000,	0x00000000,
		0x1D90, 0x314001FF,
		0x1D90, 0x314101FF,
		0x1D90, 0x314201FF,
		0x1D90, 0x314301FF,
		0x1D90, 0x314401FF,
		0x1D90, 0x314501FF,
		0x1D90, 0x314601FE,
		0x1D90, 0x314701FD,
		0x1D90, 0x314801FC,
		0x1D90, 0x314901FB,
		0x1D90, 0x314A01FA,
		0x1D90, 0x314B01F9,
		0x1D90, 0x314C01F8,
		0x1D90, 0x314D01F7,
		0x1D90, 0x314E01F6,
		0x1D90, 0x314F01F5,
		0x1D90, 0x315001F4,
		0x1D90, 0x315101F3,
		0x1D90, 0x315201F2,
		0x1D90, 0x315301F1,
		0x1D90, 0x315401F0,
		0x1D90, 0x315501EF,
		0x1D90, 0x315601EE,
		0x1D90, 0x315701ED,
		0x1D90, 0x315801EC,
		0x1D90, 0x315901EB,
		0x1D90, 0x315A01EA,
		0x1D90, 0x315B01E9,
		0x1D90, 0x315C01E7,
		0x1D90, 0x315D01E6,
		0x1D90, 0x315E01E5,
		0x1D90, 0x315F01E4,
		0x1D90, 0x316001A8,
		0x1D90, 0x316101A7,
		0x1D90, 0x316201A6,
		0x1D90, 0x316301A5,
		0x1D90, 0x31640185,
		0x1D90, 0x31650184,
		0x1D90, 0x31660183,
		0x1D90, 0x31670182,
		0x1D90, 0x31680149,
		0x1D90, 0x31690148,
		0x1D90, 0x316A0147,
		0x1D90, 0x316B0145,
		0x1D90, 0x316C0144,
		0x1D90, 0x316D0143,
		0x1D90, 0x316E0142,
		0x1D90, 0x316F00E6,
		0x1D90, 0x317000E5,
		0x1D90, 0x317100C9,
		0x1D90, 0x317200C8,
		0x1D90, 0x317300C7,
		0x1D90, 0x317400C6,
		0x1D90, 0x317500C5,
		0x1D90, 0x317600C4,
		0x1D90, 0x317700C3,
		0x1D90, 0x31780088,
		0x1D90, 0x31790087,
		0x1D90, 0x317A0086,
		0x1D90, 0x317B0085,
		0x1D90, 0x317C0026,
		0x1D90, 0x317D0025,
		0x1D90, 0x317E0024,
		0x1D90, 0x317F0023,
	0xB0000000,	0x00000000,
	0x83ffffff,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x318001FE,
		0x1D90, 0x318101FD,
		0x1D90, 0x318201FC,
		0x1D90, 0x318301FB,
		0x1D90, 0x318401FA,
		0x1D90, 0x318501F9,
		0x1D90, 0x318601F8,
		0x1D90, 0x318701F7,
		0x1D90, 0x318801F6,
		0x1D90, 0x318901F5,
		0x1D90, 0x318A01F4,
		0x1D90, 0x318B01F3,
		0x1D90, 0x318C01F2,
		0x1D90, 0x318D01F1,
		0x1D90, 0x318E01F0,
		0x1D90, 0x318F01EF,
		0x1D90, 0x319001EE,
		0x1D90, 0x319101ED,
		0x1D90, 0x319201EC,
		0x1D90, 0x319301EB,
		0x1D90, 0x319401EA,
		0x1D90, 0x319501E9,
		0x1D90, 0x319601E7,
		0x1D90, 0x319701E6,
		0x1D90, 0x319801E5,
		0x1D90, 0x319901E4,
		0x1D90, 0x319A01A8,
		0x1D90, 0x319B01A7,
		0x1D90, 0x319C01A6,
		0x1D90, 0x319D01A5,
		0x1D90, 0x319E0185,
		0x1D90, 0x319F0184,
		0x1D90, 0x31A00183,
		0x1D90, 0x31A10182,
		0x1D90, 0x31A20149,
		0x1D90, 0x31A30148,
		0x1D90, 0x31A40147,
		0x1D90, 0x31A50145,
		0x1D90, 0x31A60144,
		0x1D90, 0x31A70143,
		0x1D90, 0x31A80142,
		0x1D90, 0x31A900E6,
		0x1D90, 0x31AA00E5,
		0x1D90, 0x31AB00C9,
		0x1D90, 0x31AC00C8,
		0x1D90, 0x31AD00C7,
		0x1D90, 0x31AE00C6,
		0x1D90, 0x31AF00C5,
		0x1D90, 0x31B000C4,
		0x1D90, 0x31B100C3,
		0x1D90, 0x31B20088,
		0x1D90, 0x31B30087,
		0x1D90, 0x31B40086,
		0x1D90, 0x31B50085,
		0x1D90, 0x31B60026,
		0x1D90, 0x31B70025,
		0x1D90, 0x31B80024,
		0x1D90, 0x31B90023,
		0x1D90, 0x31BA0022,
		0x1D90, 0x31BB0021,
		0x1D90, 0x31BC0020,
		0x1D90, 0x31BD0003,
		0x1D90, 0x31BE0002,
		0x1D90, 0x31BF0001,
	0x90ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x318001FE,
		0x1D90, 0x318101FD,
		0x1D90, 0x318201FC,
		0x1D90, 0x318301FB,
		0x1D90, 0x318401FA,
		0x1D90, 0x318501F9,
		0x1D90, 0x318601F8,
		0x1D90, 0x318701F7,
		0x1D90, 0x318801F6,
		0x1D90, 0x318901F5,
		0x1D90, 0x318A01F4,
		0x1D90, 0x318B01F3,
		0x1D90, 0x318C01F2,
		0x1D90, 0x318D01F1,
		0x1D90, 0x318E01F0,
		0x1D90, 0x318F01EF,
		0x1D90, 0x319001EE,
		0x1D90, 0x319101ED,
		0x1D90, 0x319201EC,
		0x1D90, 0x319301EB,
		0x1D90, 0x319401EA,
		0x1D90, 0x319501E9,
		0x1D90, 0x319601E7,
		0x1D90, 0x319701E6,
		0x1D90, 0x319801E5,
		0x1D90, 0x319901E4,
		0x1D90, 0x319A01A8,
		0x1D90, 0x319B01A7,
		0x1D90, 0x319C01A6,
		0x1D90, 0x319D01A5,
		0x1D90, 0x319E0185,
		0x1D90, 0x319F0184,
		0x1D90, 0x31A00183,
		0x1D90, 0x31A10182,
		0x1D90, 0x31A20149,
		0x1D90, 0x31A30148,
		0x1D90, 0x31A40147,
		0x1D90, 0x31A50145,
		0x1D90, 0x31A60144,
		0x1D90, 0x31A70143,
		0x1D90, 0x31A80142,
		0x1D90, 0x31A900E6,
		0x1D90, 0x31AA00E5,
		0x1D90, 0x31AB00C9,
		0x1D90, 0x31AC00C8,
		0x1D90, 0x31AD00C7,
		0x1D90, 0x31AE00C6,
		0x1D90, 0x31AF00C5,
		0x1D90, 0x31B000C4,
		0x1D90, 0x31B100C3,
		0x1D90, 0x31B20088,
		0x1D90, 0x31B30087,
		0x1D90, 0x31B40086,
		0x1D90, 0x31B50085,
		0x1D90, 0x31B60026,
		0x1D90, 0x31B70025,
		0x1D90, 0x31B80024,
		0x1D90, 0x31B90023,
		0x1D90, 0x31BA0022,
		0x1D90, 0x31BB0021,
		0x1D90, 0x31BC0020,
		0x1D90, 0x31BD0003,
		0x1D90, 0x31BE0002,
		0x1D90, 0x31BF0001,
	0x90ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x318001FE,
		0x1D90, 0x318101FD,
		0x1D90, 0x318201FC,
		0x1D90, 0x318301FB,
		0x1D90, 0x318401FA,
		0x1D90, 0x318501F9,
		0x1D90, 0x318601F8,
		0x1D90, 0x318701F7,
		0x1D90, 0x318801F6,
		0x1D90, 0x318901F5,
		0x1D90, 0x318A01F4,
		0x1D90, 0x318B01F3,
		0x1D90, 0x318C01F2,
		0x1D90, 0x318D01F1,
		0x1D90, 0x318E01F0,
		0x1D90, 0x318F01EF,
		0x1D90, 0x319001EE,
		0x1D90, 0x319101ED,
		0x1D90, 0x319201EC,
		0x1D90, 0x319301EB,
		0x1D90, 0x319401EA,
		0x1D90, 0x319501E9,
		0x1D90, 0x319601E7,
		0x1D90, 0x319701E6,
		0x1D90, 0x319801E5,
		0x1D90, 0x319901E4,
		0x1D90, 0x319A01A8,
		0x1D90, 0x319B01A7,
		0x1D90, 0x319C01A6,
		0x1D90, 0x319D01A5,
		0x1D90, 0x319E0185,
		0x1D90, 0x319F0184,
		0x1D90, 0x31A00183,
		0x1D90, 0x31A10182,
		0x1D90, 0x31A20149,
		0x1D90, 0x31A30148,
		0x1D90, 0x31A40147,
		0x1D90, 0x31A50145,
		0x1D90, 0x31A60144,
		0x1D90, 0x31A70143,
		0x1D90, 0x31A80142,
		0x1D90, 0x31A900E6,
		0x1D90, 0x31AA00E5,
		0x1D90, 0x31AB00C9,
		0x1D90, 0x31AC00C8,
		0x1D90, 0x31AD00C7,
		0x1D90, 0x31AE00C6,
		0x1D90, 0x31AF00C5,
		0x1D90, 0x31B000C4,
		0x1D90, 0x31B100C3,
		0x1D90, 0x31B20088,
		0x1D90, 0x31B30087,
		0x1D90, 0x31B40086,
		0x1D90, 0x31B50085,
		0x1D90, 0x31B60026,
		0x1D90, 0x31B70025,
		0x1D90, 0x31B80024,
		0x1D90, 0x31B90023,
		0x1D90, 0x31BA0022,
		0x1D90, 0x31BB0021,
		0x1D90, 0x31BC0020,
		0x1D90, 0x31BD0003,
		0x1D90, 0x31BE0002,
		0x1D90, 0x31BF0001,
	0xA0000000,	0x00000000,
		0x1D90, 0x318001FE,
		0x1D90, 0x318101FD,
		0x1D90, 0x318201FC,
		0x1D90, 0x318301FB,
		0x1D90, 0x318401FA,
		0x1D90, 0x318501F9,
		0x1D90, 0x318601F8,
		0x1D90, 0x318701F7,
		0x1D90, 0x318801F6,
		0x1D90, 0x318901F5,
		0x1D90, 0x318A01F4,
		0x1D90, 0x318B01F3,
		0x1D90, 0x318C01F2,
		0x1D90, 0x318D01F1,
		0x1D90, 0x318E01F0,
		0x1D90, 0x318F01EF,
		0x1D90, 0x319001EE,
		0x1D90, 0x319101ED,
		0x1D90, 0x319201EC,
		0x1D90, 0x319301EB,
		0x1D90, 0x319401EA,
		0x1D90, 0x319501E9,
		0x1D90, 0x319601E7,
		0x1D90, 0x319701E6,
		0x1D90, 0x319801E5,
		0x1D90, 0x319901E4,
		0x1D90, 0x319A01A8,
		0x1D90, 0x319B01A7,
		0x1D90, 0x319C01A6,
		0x1D90, 0x319D01A5,
		0x1D90, 0x319E0185,
		0x1D90, 0x319F0184,
		0x1D90, 0x31A00183,
		0x1D90, 0x31A10182,
		0x1D90, 0x31A20149,
		0x1D90, 0x31A30148,
		0x1D90, 0x31A40147,
		0x1D90, 0x31A50145,
		0x1D90, 0x31A60144,
		0x1D90, 0x31A70143,
		0x1D90, 0x31A80142,
		0x1D90, 0x31A900E6,
		0x1D90, 0x31AA00E5,
		0x1D90, 0x31AB00C9,
		0x1D90, 0x31AC00C8,
		0x1D90, 0x31AD00C7,
		0x1D90, 0x31AE00C6,
		0x1D90, 0x31AF00C5,
		0x1D90, 0x31B000C4,
		0x1D90, 0x31B100C3,
		0x1D90, 0x31B20088,
		0x1D90, 0x31B30087,
		0x1D90, 0x31B40086,
		0x1D90, 0x31B50085,
		0x1D90, 0x31B60026,
		0x1D90, 0x31B70025,
		0x1D90, 0x31B80024,
		0x1D90, 0x31B90023,
		0x1D90, 0x31BA0022,
		0x1D90, 0x31BB0021,
		0x1D90, 0x31BC0020,
		0x1D90, 0x31BD0003,
		0x1D90, 0x31BE0002,
		0x1D90, 0x31BF0001,
	0xB0000000,	0x00000000,
	0x83ffffff,	0x00000000,	0x40000000,	0x00000000,
		0x1D70, 0x22222222,
		0x1D70, 0x20202020,
	0x90ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x1D70, 0x22222222,
		0x1D70, 0x20202020,
	0x90ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x1D70, 0x22222222,
		0x1D70, 0x20202020,
	0xA0000000,	0x00000000,
		0x1D70, 0x22222222,
		0x1D70, 0x20202020,
	0xB0000000,	0x00000000,

};

void
odm_read_and_config_mp_8822c_agc_tab(struct dm_struct *dm)
{
	boolean is_matched, find_target;
	u32 cfg_target = 0, cfg_para = 0;
	u32 i = 0;
	u32 array_len = 0;
	u32 *array = NULL;
	u32 v1 = 0, v2 = 0;
	u8 h_size = 0;
	u8 h_idx = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	array_len =
		sizeof(array_mp_8822c_agc_tab) / sizeof(u32);
	array = (u32 *)array_mp_8822c_agc_tab;

	if (!halbb_sel_headline(dm, array, array_len, &h_size, &h_idx)) {
		PHYDM_DBG(dm, ODM_COMP_INIT, "No any match case.\n");
		return;
	}
	PHYDM_DBG(dm, ODM_COMP_INIT, "len = %d, h_size = %d, h_idx = %d\n",
			  array_len, h_size, h_idx);

	if (h_size != 0) {
		cfg_target = array[h_idx << 1] & 0x0fffffff;
	}

	i += h_size;

	PHYDM_DBG(dm, ODM_COMP_INIT, "cfg_target = 0x%x\n", cfg_target);
	PHYDM_DBG(dm, ODM_COMP_INIT, "array[i] = 0x%x, array[i+1] = 0x%x\n",
			  array[i], array[i + 1]);

	halbb_flag_2_default(&is_matched, &find_target);
	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];
		i += 2;

		switch (v1 >> 28) {
		case PARA_IF:
		case PARA_ELSE_IF:
			cfg_para = v1 & 0x0fffffff;
			PHYDM_DBG(dm, ODM_COMP_INIT, "*if (cart=%d, rfe=%d)\n",
			       (cfg_para & 0x0f000000) >> 24, cfg_para & 0xff);
			break;
		case PARA_ELSE:
			PHYDM_DBG(dm, ODM_COMP_INIT, "*else\n");
			is_matched = false;
			if (!find_target) {
				PHYDM_DBG(dm, ODM_COMP_INIT, "Init Fail in Reg 0x%x\n", array[i]);
				return;
			}
			break;
		case PARA_END:
			PHYDM_DBG(dm, ODM_COMP_INIT, "*endif\n");
			halbb_flag_2_default(&is_matched, &find_target);
			break;
		case PARA_CHK:
			/*Check this para meets driver's requirement or not*/
			if (find_target) {
				PHYDM_DBG(dm, ODM_COMP_INIT, "	 skip\n");
				is_matched = false;
				break;
			}

			if (cfg_para == cfg_target) {
				is_matched = true;
				find_target = true;
			} else {
				is_matched = false;
				find_target = false;
			}
			PHYDM_DBG(dm, ODM_COMP_INIT, "	 match=%d\n", is_matched);
			break;
		default:
			if (is_matched)
					odm_config_bb_agc_8822c(dm, v1, MASKDWORD, v2);
			break;
		}
	}
	PHYDM_DBG(dm, ODM_COMP_INIT, "BBCR Init Success\n");
}

u32
odm_get_version_mp_8822c_agc_tab(void)
{
		return 61;
}

/******************************************************************************
 *                           phy_reg.TXT
 ******************************************************************************/

const u32 array_mp_8822c_phy_reg[] = {
		0xF3FFFFFF, 0x00000000,
		0xF3FFFF15, 0x00000001,
		0xF3FFFF16, 0x00000002,
		0xF4FFFF15, 0x00000003,
		0xF4FFFF16, 0x00000004,
		0xF5FFFF15, 0x00000005,
		0xF5FFFF16, 0x00000006,
		0x1D0C, 0x00410000,
		0x1C3C, 0x01038040,
		0x1C90, 0x00E49708,
		0x800, 0x00000000,
		0x804, 0xD6300000,
		0x808, 0x60956093,
		0x80C, 0x00000025,
		0x810, 0x11B019B0,
		0x814, 0x00904080,
		0x818, 0xC30056F1,
		0x81C, 0x00050000,
		0x820, 0x11111111,
		0x824, 0xC3C3CCC4,
		0x828, 0x30FB186C,
		0x82C, 0x185D6556,
		0x830, 0x1751145B,
		0x834, 0x776995D7,
		0x838, 0x74777A7D,
		0x83C, 0xF9AA9982,
		0x840, 0x89AA9ABB,
		0x844, 0x0DEEDDC1,
		0x848, 0xCDEEDEFF,
		0x84C, 0xFFFF5555,
		0x850, 0x6F7A727D,
		0x854, 0x6C776F7A,
		0x858, 0x6F7A6C77,
		0x85C, 0x69746974,
		0x860, 0x6F7A6C77,
		0x864, 0x6C776C77,
		0x868, 0x727D6F7A,
		0x86C, 0x69D7B196,
		0x870, 0x1A6D769B,
		0x874, 0x55823917,
		0x878, 0x00C025BD,
		0x87C, 0x4140557D,
		0x880, 0x9A1D9D47,
		0x884, 0x1DE7134F,
		0x888, 0x2857A857,
		0x88C, 0x520E8A24,
		0x890, 0x8F628C44,
		0x894, 0x72745F43,
		0x898, 0x03F02F0D,
		0x89C, 0x5DB6886F,
		0x8A0, 0x07DC309F,
		0x8A4, 0x09412495,
		0x8A8, 0x222222A9,
		0x8AC, 0x89628C44,
		0x8B0, 0x72745F43,
		0x8B4, 0x03F02F0D,
		0x8B8, 0x55B6886F,
		0x8BC, 0x07D0309F,
		0x8C0, 0x70404023,
		0x8C4, 0x00440001,
		0x8C8, 0x7A7A2E26,
		0x8CC, 0x25297777,
		0x8D0, 0x6CEB6DCE,
		0x8D4, 0x0005A632,
		0x8D8, 0x00000000,
		0x8DC, 0x00000000,
		0x8E0, 0x00000000,
		0x8E4, 0x00000000,
		0x8E8, 0x00000000,
		0x8EC, 0x00000000,
		0x8F0, 0x00000000,
		0x8F4, 0x00000000,
		0x8F8, 0x25239843,
		0x900, 0x00000000,
		0x904, 0x00000000,
		0x908, 0x000008CB,
		0x90C, 0x00000000,
		0x910, 0x00000000,
		0x914, 0x20000000,
		0x918, 0x20000000,
		0x91C, 0x20000000,
		0x920, 0x20000000,
		0x924, 0x00000000,
		0x928, 0x0000003A,
		0x92C, 0x0000003A,
		0x930, 0x0000003A,
		0x934, 0x0000003A,
		0x938, 0x0000000F,
		0x93C, 0x00000000,
		0x940, 0x4E1F3E81,
		0x944, 0x4E1F3E81,
		0x948, 0x4E1F3E81,
		0x94C, 0x4E1F3E81,
		0x950, 0x03020100,
		0x954, 0x07060504,
		0x958, 0x0B0A0908,
		0x95C, 0x0F0E0D0C,
		0x960, 0x13121110,
		0x964, 0x17161514,
		0x968, 0x03020100,
		0x96C, 0x07060504,
		0x970, 0x0B0A0908,
		0x974, 0x0F0E0D0C,
		0x978, 0x13121110,
		0x97C, 0x17161514,
		0x980, 0x03020100,
		0x984, 0x07060504,
		0x988, 0x0B0A0908,
		0x98C, 0x0F0E0D0C,
		0x990, 0x13121110,
		0x994, 0x17161514,
		0x998, 0x03020100,
		0x99C, 0x07060504,
		0x9A0, 0x0B0A0908,
		0x9A4, 0x0F0E0D0C,
		0x9A8, 0x13121110,
		0x9AC, 0x17161514,
		0x9B0, 0x00002200,
		0x9B4, 0xDB6FFF00,
		0x9B8, 0x00400064,
		0x9BC, 0x00000000,
		0x9C0, 0x01010101,
		0x9C4, 0x00640064,
		0x9C8, 0x00640064,
		0x9CC, 0x00007777,
		0x9D0, 0x00000000,
		0x9D4, 0x00000000,
		0x9D8, 0x00000000,
		0x9DC, 0x00000000,
		0x9E0, 0x00000000,
		0x9E4, 0x00000000,
		0x9E8, 0x00000000,
		0x9EC, 0x00000000,
		0x9F0, 0x100024E0,
		0x9F4, 0x00000000,
		0x9F8, 0x00000000,
		0xA00, 0x02001208,
		0xA04, 0x00000000,
		0xA08, 0x00000000,
		0xA0C, 0x00000000,
		0xA10, 0x00000000,
		0xA14, 0x00000000,
		0xA18, 0x00000000,
		0xA1C, 0x00000000,
		0xA20, 0xCB31B333,
		0xA24, 0x00275485,
		0xA28, 0x00166366,
		0xA2C, 0x00275485,
		0xA30, 0x00166366,
		0xA34, 0x00275485,
		0xA38, 0x00200400,
		0xA3C, 0x00200400,
		0xA40, 0xB35DC5BD,
		0xA44, 0x3033BEBD,
		0xA48, 0x2A521254,
		0xA4C, 0xA2733345,
		0xA50, 0x617BE003,
		0xA54, 0x50000968,
		0xA58, 0x00020000,
		0xA5C, 0x01000000,
		0xA60, 0x02000000,
		0xA64, 0x03000000,
		0xA68, 0x00020000,
		0xA6C, 0x00000000,
		0xA70, 0x00000000,
		0xA74, 0x00000000,
		0xA78, 0x00000000,
		0xA7C, 0x00000000,
		0xA80, 0x00000000,
		0xA84, 0x00000000,
		0xA88, 0x00000000,
		0xA8C, 0x00000000,
		0xA90, 0x00000000,
		0xA94, 0x00000000,
		0xA98, 0x00000000,
		0xA9C, 0x00000000,
		0xAA0, 0x00000000,
		0xAA4, 0x00000000,
		0xAA8, 0x00000000,
		0xAAC, 0x00000000,
		0xAB0, 0x00000000,
		0xAB4, 0x00000000,
		0xAB8, 0x00000000,
		0xABC, 0x00000000,
		0xAC0, 0x00000000,
		0xAC4, 0x00000000,
		0xAC8, 0x00000000,
		0xACC, 0x00000000,
		0xAD0, 0x00000000,
		0xAD4, 0x00000000,
		0xAD8, 0x00000000,
		0xADC, 0x00000000,
		0xAE0, 0x00000000,
		0xAE4, 0x00000000,
		0xAE8, 0x00000000,
		0xAEC, 0x00000000,
		0xAF0, 0x00000000,
		0xAF4, 0x00000000,
		0xAF8, 0x00000000,
		0xB00, 0x00000000,
		0xB04, 0x00000000,
		0xB08, 0x00000000,
		0xB0C, 0x00000000,
		0xB10, 0x00000000,
		0xB14, 0x00000000,
		0xB18, 0x00000000,
		0xB1C, 0x00000000,
		0xB20, 0x00000000,
		0xB24, 0x00000000,
		0xB28, 0x00000000,
		0xB2C, 0x00000000,
		0xB30, 0x00000000,
		0xB34, 0x00000000,
		0xB38, 0x00000000,
		0xB3C, 0x00000000,
		0xB40, 0x00000000,
		0xB44, 0x00000000,
		0xB48, 0x00000000,
		0xB4C, 0x00000000,
		0xB50, 0x00000000,
		0xB54, 0x00000000,
		0xB58, 0x00060100,
		0xB5C, 0x00000000,
		0xB60, 0x00000000,
		0xB64, 0x00000000,
		0xB68, 0x00000000,
		0xB6C, 0x00000000,
		0xB70, 0x00000000,
		0xB74, 0x00000000,
		0xB78, 0x00000000,
		0xB7C, 0x00000000,
		0xB80, 0x00000000,
		0xB84, 0x00000000,
		0xB88, 0x00000000,
		0xB8C, 0x00000000,
		0xB90, 0x00000000,
		0xB94, 0x00000000,
		0xB98, 0x00000000,
		0xB9C, 0x00000000,
		0xBA0, 0x00000000,
		0xBA4, 0x00000000,
		0xBA8, 0x00000000,
		0xBAC, 0x00000000,
		0xBB0, 0x00000000,
		0xBB4, 0x00000000,
		0xBB8, 0x00000000,
		0xBBC, 0x00000000,
		0xBC0, 0x00000000,
		0xBC4, 0x00000000,
		0xBC8, 0x00000000,
		0xBCC, 0x00000000,
		0xBD0, 0x00000000,
		0xBD4, 0x00000000,
		0xBD8, 0x00000000,
		0xBDC, 0x00000000,
		0xBE0, 0x00000000,
		0xBE4, 0x00000000,
		0xBE8, 0x00000000,
		0xBEC, 0x00000000,
		0xBF0, 0x00000000,
		0xBF4, 0x00000000,
		0xBF8, 0x00000000,
		0xC00, 0x0C8BA0D6,
		0xC04, 0x00000001,
		0xC08, 0x00000000,
		0xC0C, 0x02F1D8B7,
		0xC10, 0x000000B0,
		0xC14, 0x0000D891,
		0xC18, 0x00087672,
		0xC1C, 0x15260000,
		0xC20, 0x00000000,
		0xC24, 0x406000FF,
		0xC28, 0x06400F76,
		0xC2C, 0xE30020E1,
		0xC30, 0x140C9494,
		0xC34, 0x00A04946,
		0xC38, 0x011D4820,
		0xC3C, 0x168DB61B,
		0xC40, 0x009C50F8,
		0xC44, 0x2013BAD1,
		0xC48, 0xFFFFF7CC,
		0xC4C, 0xA000FFFF,
		0xC50, 0x20D0F800,
		0xC54, 0x941A0200,
		0xC58, 0x18380111,
		0xC5C, 0x006E01B8,
		0xC60, 0x2CA5555B,
		0xC64, 0x0210005F,
		0xC68, 0x039A5300,
		0xC6C, 0x0265C2BA,
		0xC70, 0x000CEB21,
		0xC74, 0x0E149CA1,
		0xC78, 0x1AB4956B,
		0xC7C, 0x00000ABF,
		0xC80, 0xC02A8799,
		0xC84, 0x06C636C6,
		0xC88, 0x08090202,
		0xC8C, 0x00204048,
		0xC90, 0x00F85F85,
		0xC94, 0x00000F85,
		0xC98, 0x58385858,
		0xC9C, 0x18382838,
		0xCA0, 0x00002838,
		0xCA4, 0x3A253A3A,
		0xCA8, 0x10251A25,
		0xCAC, 0x00001025,
		0xCB0, 0x3A133A3A,
		0xCB4, 0x08130D13,
		0xCB8, 0x00000813,
		0xCBC, 0x001F1066,
		0xCC0, 0x88A00400,
		0xCC4, 0x00200400,
		0xCC8, 0x0B200400,
		0xCCC, 0x00600400,
		0xCD0, 0x22220092,
		0xCD4, 0x22220707,
		0xCD8, 0x22222222,
		0xCDC, 0x22222222,
		0xCE0, 0x22222222,
		0xCE4, 0x22222222,
		0xCE8, 0x00002222,
		0xCEC, 0x00000000,
		0xCF0, 0x00000000,
		0xCF4, 0x00000000,
		0xCF8, 0x00000000,
		0xD00, 0x1083A10A,
		0xD04, 0x0EC42948,
		0xD08, 0x10852108,
		0xD0C, 0x0CC41D08,
		0xD10, 0x108620EC,
		0xD14, 0x0CA42108,
		0xD18, 0x107620E8,
		0xD1C, 0x0E742108,
		0xD20, 0x0E8618C8,
		0xD24, 0x00000108,
		0xD28, 0x288C224C,
		0xD2C, 0x11C6320C,
		0xD30, 0x30CEBD98,
		0xD34, 0x10C31908,
		0xD38, 0x310A318C,
		0xD3C, 0x18C41D08,
		0xD40, 0x28CC4190,
		0xD44, 0x19062108,
		0xD48, 0x294A5A17,
		0xD4C, 0x00000108,
		0xD50, 0x10A3A908,
		0xD54, 0x10842148,
		0xD58, 0x14C5314A,
		0xD5C, 0x1086258C,
		0xD60, 0x10A42948,
		0xD64, 0x10842108,
		0xD68, 0x08C42108,
		0xD6C, 0x10842148,
		0xD70, 0x08822084,
		0xD74, 0x10841D04,
		0xD78, 0x08421088,
		0xD7C, 0x1083A104,
		0xD80, 0x10842108,
		0xD84, 0x1085294A,
		0xD88, 0x08822104,
		0xD8C, 0x10852948,
		0xD90, 0x08421084,
		0xD94, 0x10852104,
		0xD98, 0x08421084,
		0xD9C, 0x10863184,
		0xDA0, 0x1083B10A,
		0xDA4, 0x10842148,
		0xDA8, 0x1984718C,
		0xDAC, 0x108C33AF,
		0xDB0, 0x00000000,
		0xDB4, 0x00000000,
		0xDB8, 0x00000000,
		0xDBC, 0x00000000,
		0xDC0, 0x00000000,
		0xDC4, 0x00000000,
		0xDC8, 0x00000000,
		0xDCC, 0x00000000,
		0xDD0, 0x00000000,
		0xDD4, 0x00000000,
		0xDD8, 0x00000000,
		0xDDC, 0x00000000,
		0xDE0, 0x00000000,
		0xDE4, 0x00000000,
		0xDE8, 0x00000000,
		0xDEC, 0x00000000,
		0xDF0, 0x00000000,
		0xDF4, 0x00000000,
		0xDF8, 0x00000000,
		0x1800, 0x00033312,
		0x1804, 0x00033312,
		0x180C, 0x17F40060,
		0x1810, 0x62F508C4,
		0x1814, 0x506AA5B4,
		0x1818, 0x000014FF,
		0x181C, 0x00000000,
		0x1820, 0x02D508CC,
		0x1824, 0x506AA5B4,
		0x1828, 0x000004FD,
		0x182C, 0x00000000,
		0x1834, 0x00000000,
	0x83ffffff,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x20000000,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x20100000,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x20100000,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x20100000,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x20100000,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x20100000,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x20100000,
	0xA0000000,	0x00000000,
		0x1838, 0x20000000,
	0xB0000000,	0x00000000,
		0x183C, 0x00000000,
	0x83ffffff,	0x00000000,	0x40000000,	0x00000000,
		0x1840, 0x00000000,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x1840, 0x00002300,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x1840, 0x00002300,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x1840, 0x00002300,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x1840, 0x00002300,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x1840, 0x00002300,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x1840, 0x00002300,
	0xA0000000,	0x00000000,
		0x1840, 0x00000000,
	0xB0000000,	0x00000000,
		0x1844, 0x00000000,
		0x1848, 0x00000000,
		0x184C, 0x00000000,
		0x1850, 0x00000000,
		0x1854, 0x00000000,
		0x1858, 0x00000000,
		0x185C, 0x00000000,
		0x1860, 0xF0040FF8,
		0x1864, 0x7F000000,
		0x1868, 0x00000000,
	0x83ffffff,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x0000FF00,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x0000FF02,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x0000FF02,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x0000FF02,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x0000FF02,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x0000FF02,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x0000FF02,
	0xA0000000,	0x00000000,
		0x186C, 0x0000FF00,
	0xB0000000,	0x00000000,
		0x1870, 0x00000000,
		0x1874, 0x00000000,
		0x1878, 0x00000000,
		0x187C, 0x00000000,
		0x1880, 0x00000000,
	0x83ffffff,	0x00000000,	0x40000000,	0x00000000,
		0x1884, 0x02B00000,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x1884, 0x03B00000,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x1884, 0x03B00000,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x1884, 0x03B00000,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x1884, 0x03B00000,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x1884, 0x03B00000,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x1884, 0x03B00000,
	0xA0000000,	0x00000000,
		0x1884, 0x02B00000,
	0xB0000000,	0x00000000,
		0x1888, 0x00000000,
		0x188C, 0x00000000,
		0x1890, 0x00000000,
		0x1894, 0x00000000,
		0x1898, 0x00000000,
		0x18A0, 0x00510000,
		0x18A4, 0x183C1F7F,
		0x18A8, 0x0A02C99A,
		0x18AC, 0x00004200,
		0x18B0, 0x0809FB08,
		0x18B0, 0x0809FB09,
		0x18B4, 0x00000000,
		0x18B8, 0x00000000,
		0x18BC, 0x00C3FF80,
		0x18C0, 0x0002D100,
		0x18C4, 0x00000004,
		0x18C8, 0x001FFFE0,
		0x18CC, 0x0809FB08,
		0x18CC, 0x0809FB09,
		0x18D0, 0x00000000,
		0x18D4, 0x00000000,
		0x18D8, 0x00C3FF80,
		0x18DC, 0x0002D100,
		0x18E0, 0x00000004,
		0x18E4, 0x001FFFE0,
		0x18E8, 0x00800000,
		0x18EC, 0x1EC08000,
		0x18F0, 0x7F000064,
		0x18F4, 0x1F7DE75C,
		0x18F8, 0x7F7F7F7F,
		0x18FC, 0x7F7F7F7F,
		0x1900, 0xA7A7A7A7,
		0x1904, 0x95959595,
		0x1908, 0x00777788,
		0x190C, 0x77776666,
		0x1910, 0x00033333,
		0x1914, 0xAAAC875A,
		0x1918, 0x2AA2A8A2,
		0x191C, 0x2AAAA8A2,
		0x1920, 0x00878766,
		0x1924, 0x000C4924,
		0x1928, 0x5669B6C0,
		0x192C, 0x00409190,
		0x1930, 0xB85C0492,
		0x1934, 0x00B4A298,
		0x1938, 0x00030151,
		0x193C, 0x0058C618,
		0x1940, 0x41000000,
		0x1944, 0x00000BCB,
		0x1948, 0xAAAAAAAA,
		0x194C, 0x00B99999,
		0x1950, 0x88886665,
		0x1954, 0x08888888,
		0x1958, 0x00000618,
		0x195C, 0x00000000,
		0x1960, 0x00000000,
		0x1964, 0x00000000,
		0x1968, 0x00000000,
		0x196C, 0x00000000,
		0x1970, 0x00000000,
		0x1974, 0x00000000,
		0x1978, 0x00000000,
		0x197C, 0x00000000,
		0x1980, 0x00000000,
		0x1984, 0x00000000,
		0x1988, 0x00000000,
		0x198C, 0x00000000,
		0x1990, 0x00000000,
		0x1994, 0x00000000,
		0x1998, 0x00000000,
		0x199C, 0x00000000,
		0x19A0, 0x00000000,
		0x19A4, 0x00000000,
		0x19A8, 0x00000000,
		0x19AC, 0x00000000,
		0x19B0, 0x00000000,
		0x19B4, 0x00000000,
		0x19B8, 0x00000000,
		0x19BC, 0x00000000,
		0x19C0, 0x00000000,
		0x19C4, 0x00000000,
		0x19C8, 0x00000000,
		0x19CC, 0x00000000,
		0x19D0, 0x00000000,
		0x19D4, 0x00000000,
		0x19D8, 0x00000000,
		0x19DC, 0x00000000,
		0x19E0, 0x00000000,
		0x19E4, 0x00000000,
		0x19E8, 0x00000000,
		0x19EC, 0x00000000,
		0x19F0, 0x00000000,
		0x19F4, 0x00000000,
		0x19F8, 0x00000000,
		0x1C00, 0x00000000,
		0x1C04, 0x00000000,
		0x1C08, 0x00000000,
		0x1C0C, 0x00000000,
		0x1C10, 0x00000000,
		0x1C14, 0x00000000,
		0x1C18, 0x00000000,
		0x1C1C, 0x00000000,
		0x1C20, 0x03C23F00,
		0x1C24, 0xF101F002,
		0x1C28, 0x0FFE0010,
		0x1C2C, 0x453090FF,
		0x1C30, 0xFE0090FE,
		0x1C34, 0xE4E42000,
		0x1C38, 0xFFA1005E,
		0x1C40, 0x8F588837,
		0x1C44, 0x04400700,
		0x1C48, 0x00000000,
		0x1C4C, 0x00000200,
		0x1C50, 0x8E588837,
		0x1C54, 0x04400300,
		0x1C58, 0x00000000,
		0x1C5C, 0xFFFFFFFF,
		0x1C60, 0x0F030032,
		0x1C64, 0x360F0008,
		0x1C68, 0x007F0000,
		0x1C6C, 0x00010000,
		0x1C70, 0x00037FFE,
		0x1C74, 0x00000000,
		0x1C78, 0x00020000,
		0x1C7C, 0x00310000,
		0x1C80, 0x0E38E000,
		0x1C84, 0x245120D4,
		0x1C88, 0xC8400483,
		0x1C8C, 0x40005A20,
	0x83ffffff,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0x00000000,
		0x1C98, 0x00000000,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0x00000B0E,
		0x1C98, 0x00450000,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0x00000B0E,
		0x1C98, 0x00450000,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0x00000B0E,
		0x1C98, 0x00450000,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0x00000B0E,
		0x1C98, 0x00450000,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0x00000B0E,
		0x1C98, 0x00450000,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0x00000B0E,
		0x1C98, 0x00450000,
	0xA0000000,	0x00000000,
		0x1C94, 0x00000000,
		0x1C98, 0x00000000,
	0xB0000000,	0x00000000,
		0x1C9C, 0x00000000,
		0x1CA0, 0x00000000,
		0x1CA4, 0x20000000,
		0x1CA8, 0x0E000000,
		0x1CAC, 0xE424A2CC,
		0x1CB0, 0x00000000,
		0x1CB4, 0x00000000,
		0x1CB8, 0x24800000,
		0x1CBC, 0x60004800,
		0x1CC0, 0x24800000,
		0x1CC4, 0x60004800,
		0x1CC8, 0xF0444900,
		0x1CCC, 0x030300F1,
		0x1CD0, 0x0F000000,
		0x1CD4, 0x02024B00,
		0x1CD8, 0x04000000,
		0x1CDC, 0x10000000,
		0x1CE0, 0x60000000,
		0x1CE4, 0x00000000,
		0x1CE8, 0xC0000000,
		0x1CEC, 0x00000000,
		0x1CF0, 0x00000000,
		0x1CF4, 0xE4000000,
		0x1CF8, 0x00000000,
		0x1D00, 0x00000000,
		0x1D04, 0x08A3C000,
		0x1D08, 0xA0000000,
		0x1D10, 0x08B5BBBB,
		0x1D14, 0x77777777,
		0x1D18, 0x99999999,
		0x1D1C, 0x99999999,
		0x1D20, 0x000081E0,
		0x1D24, 0x00000000,
		0x1D28, 0x00000000,
		0x1D2C, 0xC0000000,
		0x1D30, 0x50009C00,
		0x1D34, 0x00000000,
		0x1D38, 0x00000000,
		0x1D3C, 0xF8000000,
		0x1D40, 0x00000000,
		0x1D44, 0x74740000,
		0x1D48, 0x14147474,
		0x1D4C, 0x00FFFF14,
		0x1D50, 0x00000000,
		0x1D54, 0x03A00000,
		0x1D58, 0x80800000,
		0x1D5C, 0x00000000,
		0x1D60, 0x00000000,
		0x1D64, 0x88000000,
		0x1D68, 0x00000000,
		0x1D6C, 0x666D8001,
		0x1D70, 0x20202020,
		0x1D74, 0x4E4E4E4E,
		0x1D78, 0x18189818,
		0x1D7C, 0x0005A000,
		0x1D80, 0x00080000,
		0x1D84, 0x00080000,
		0x1D88, 0x000000EF,
		0x1D8C, 0x0C0C0C0C,
		0x1D90, 0x103F003F,
		0x1D94, 0x00000000,
		0x1D98, 0x00000000,
		0x1D9C, 0x00000000,
		0x1DA0, 0x00000000,
		0x1DA4, 0x00000000,
		0x1DA8, 0x00000000,
		0x1DAC, 0x00000000,
		0x1DB0, 0x00000000,
		0x1DB4, 0x00000000,
		0x1DB8, 0x00000000,
		0x1DBC, 0x00000000,
		0x1DC0, 0x00000000,
		0x1DC4, 0x00000000,
		0x1DC8, 0x00000000,
		0x1DCC, 0x00000000,
		0x1DD0, 0x00000000,
		0x1DD4, 0x00000000,
		0x1DD8, 0x00000000,
		0x1DDC, 0x1FDF0000,
		0x1DE0, 0x01010000,
		0x1DE4, 0x05210123,
		0x1DE8, 0xFFFF4848,
		0x1DEC, 0x00000000,
		0x1DF0, 0x00000000,
		0x1DF4, 0x80000002,
		0x1DF8, 0x00000000,
		0x1E00, 0x00000000,
		0x1E04, 0x00000000,
		0x1E08, 0x00000000,
		0x1E0C, 0x00000000,
		0x1E10, 0x00000000,
		0x1E14, 0x00000000,
		0x1E18, 0x00000000,
		0x1E1C, 0x00000000,
		0x1E20, 0x00000000,
		0x1E24, 0x80003000,
		0x1E28, 0x000CC0C3,
		0x1E2C, 0xE4E40000,
		0x1E30, 0xE4E4E4E4,
		0x1E34, 0xF3001234,
		0x1E38, 0x00000000,
		0x1E3C, 0x00000000,
		0x1E40, 0x00000000,
		0x1E44, 0x00000000,
		0x1E48, 0x00000000,
		0x1E4C, 0x00000000,
		0x1E50, 0x00000000,
		0x1E54, 0x00000000,
		0x1E58, 0x00000000,
		0x1E5C, 0xC1000000,
		0x1E60, 0x00000000,
		0x1E64, 0xF3A00001,
		0x1E68, 0x0028846E,
		0x1E6C, 0x40274906,
		0x1E70, 0x00001000,
		0x1E74, 0x00000000,
		0x1E78, 0x00000000,
		0x1E7C, 0x00000000,
		0x1E80, 0x00000000,
		0x1E84, 0x00000000,
		0x1E84, 0x40000000,
		0x1E84, 0x41000000,
		0x1E84, 0x42000000,
		0x1E84, 0x43000000,
		0x1E84, 0x44000000,
		0x1E84, 0x45000000,
		0x1E84, 0x46000000,
		0x1E84, 0x47000000,
		0x1E84, 0x48000000,
		0x1E84, 0x49000000,
		0x1E84, 0x4A000000,
		0x1E84, 0x4B000000,
		0x1E84, 0x4C000000,
		0x1E84, 0x4D000000,
		0x1E84, 0x4E000000,
		0x1E84, 0x4F000000,
		0x1E84, 0x50000000,
		0x1E84, 0x51000000,
		0x1E84, 0x52000000,
		0x1E84, 0x53000000,
		0x1E84, 0x54000000,
		0x1E84, 0x55000000,
		0x1E84, 0x56000000,
		0x1E84, 0x57000000,
		0x1E84, 0x58000000,
		0x1E84, 0x59000000,
		0x1E84, 0x5A000000,
		0x1E84, 0x5B000000,
		0x1E84, 0x5C000000,
		0x1E84, 0x5D000000,
		0x1E84, 0x5E000000,
		0x1E84, 0x5F000000,
		0x1E84, 0x60000000,
		0x1E84, 0x61000000,
		0x1E84, 0x62000000,
		0x1E84, 0x63000000,
		0x1E84, 0x64000000,
		0x1E84, 0x65000000,
		0x1E84, 0x66000000,
		0x1E84, 0x67000000,
		0x1E84, 0x68000000,
		0x1E84, 0x69000000,
		0x1E84, 0x6A000000,
		0x1E84, 0x6B000000,
		0x1E84, 0x6C000000,
		0x1E84, 0x6D000000,
		0x1E84, 0x6E000000,
		0x1E84, 0x6F000000,
		0x1E84, 0x70000000,
		0x1E84, 0x71000000,
		0x1E84, 0x72000000,
		0x1E84, 0x73000000,
		0x1E84, 0x74000000,
		0x1E84, 0x75000000,
		0x1E84, 0x76000000,
		0x1E84, 0x77000000,
		0x1E84, 0x78000000,
		0x1E84, 0x79000000,
		0x1E84, 0x7A000000,
		0x1E84, 0x7B000000,
		0x1E84, 0x7C000000,
		0x1E84, 0x7D000000,
		0x1E84, 0x7E000000,
		0x1E84, 0x7F000000,
		0x1E84, 0x80000000,
		0x1E84, 0x00000000,
		0x1E88, 0x0200FC1C,
		0x1E8C, 0x00000000,
		0x1E90, 0x00000000,
		0x1E94, 0x04000000,
		0x1E98, 0x00000000,
		0x1E9C, 0x00000000,
		0x1EA0, 0x00000000,
		0x1EA4, 0x00000000,
		0x1EA8, 0xAA464646,
		0x1EAC, 0x01800030,
		0x1EB0, 0x00003002,
		0x1EB4, 0x31800002,
		0x1EB8, 0x00000000,
		0x1EBC, 0x00000000,
		0x1EC0, 0x00000000,
		0x1EC4, 0x00000000,
		0x1EC8, 0x00000000,
		0x1ECC, 0x00000000,
		0x1ED0, 0x00000000,
		0x1ED4, 0x8000000A,
		0x1ED8, 0x800B03E8,
		0x1EDC, 0x83E90FFF,
		0x1EE0, 0x8000FFFF,
		0x1EE4, 0x70000000,
		0x1EE8, 0x00000000,
		0x1EEC, 0x0280A933,
		0x1EF0, 0x00000A80,
		0x1EF4, 0x00001266,
		0x1EF8, 0x01000100,
		0x3A00, 0x0004080C,
		0x3A04, 0x1C202428,
		0x3A08, 0x0C101418,
		0x3A0C, 0x181C2024,
		0x3A10, 0x080C1014,
		0x3A14, 0x181C2024,
		0x3A18, 0x080C1014,
		0x3A1C, 0x00000000,
		0x3A20, 0x00000000,
		0x3A24, 0x00000000,
		0x3A28, 0x00000000,
		0x3A2C, 0x181C2024,
		0x3A30, 0x080C1014,
		0x3A34, 0x20240004,
		0x3A38, 0x1014181C,
		0x3A3C, 0x0004080C,
		0x3A40, 0x00000000,
		0x3A44, 0x00000000,
		0x3A48, 0x00000000,
		0x3A4C, 0x00000000,
		0x3A50, 0x00000000,
		0x3A54, 0x00000000,
		0x3A58, 0x00000000,
		0x3A5C, 0x00000000,
		0x3A60, 0x00000000,
		0x3A64, 0x00000000,
		0x3A68, 0x00000000,
		0x3A6C, 0x00000000,
		0x3A70, 0x00000000,
		0x3A74, 0x00000000,
		0x3A78, 0x00000000,
		0x3A7C, 0x00000000,
		0x3A80, 0x00000000,
		0x3A84, 0x00000000,
		0x3A88, 0x00000000,
		0x3A8C, 0x00000000,
		0x3A90, 0x00000000,
		0x3A94, 0x00000000,
		0x3A98, 0x00000000,
		0x3A9C, 0x00000000,
		0x3AA0, 0x00000000,
		0x3AA4, 0x00000000,
		0x4000, 0xA6A6A6A6,
		0x4004, 0x95959595,
		0x4008, 0x00777777,
		0x400C, 0x77776666,
		0x4010, 0x00033333,
		0x4014, 0xAAAC875A,
		0x4018, 0x2AA2A8A2,
		0x401C, 0x2AAAA8A2,
		0x4020, 0x00878766,
		0x4024, 0x000C4924,
		0x4028, 0x5669B6C0,
		0x402C, 0x00409190,
		0x4030, 0xB85C0492,
		0x4034, 0x00B4A298,
		0x4038, 0x00030151,
		0x403C, 0x0058C618,
		0x4040, 0x41000000,
		0x4044, 0x00000BCB,
		0x4048, 0xAAAAAAAA,
		0x404C, 0x00B98989,
		0x4050, 0x88886665,
		0x4054, 0x08888888,
		0x4058, 0x00000618,
		0x405C, 0x00000000,
		0x4060, 0x00000000,
		0x4064, 0x00000000,
		0x4068, 0x00000000,
		0x406C, 0x00000000,
		0x4070, 0x00000000,
		0x4074, 0x00000000,
		0x4078, 0x00000000,
		0x407C, 0x00000000,
		0x4080, 0x00000000,
		0x4084, 0x00000000,
		0x4088, 0x00000000,
		0x408C, 0x00000000,
		0x4090, 0x00000000,
		0x4094, 0x00000000,
		0x4098, 0x00000000,
		0x409C, 0x00000000,
		0x40A0, 0x00000000,
		0x40A4, 0x00000000,
		0x40A8, 0x00000000,
		0x40AC, 0x00000000,
		0x40B0, 0x00000000,
		0x40B4, 0x00000000,
		0x40B8, 0x00000000,
		0x40BC, 0x00000000,
		0x40C0, 0x00000000,
		0x40C4, 0x00000000,
		0x40C8, 0x00000000,
		0x40CC, 0x00000000,
		0x40D0, 0x00000000,
		0x40D4, 0x00000000,
		0x40D8, 0x00000000,
		0x40DC, 0x00000000,
		0x40E0, 0x00000000,
		0x40E4, 0x00000000,
		0x40E8, 0x00000000,
		0x40EC, 0x00000000,
		0x40F0, 0x00000000,
		0x40F4, 0x00000000,
		0x40F8, 0x00000000,
		0x4100, 0x00033312,
		0x4104, 0x00033312,
		0x410C, 0x17F40060,
		0x4110, 0x62D508C4,
		0x4114, 0x506AA5B4,
		0x4118, 0x000014FF,
		0x411C, 0x00000000,
		0x4120, 0x02D508CC,
		0x4124, 0x506AA5B4,
		0x4128, 0x000004FD,
		0x412C, 0x00000000,
		0x4134, 0x00000000,
	0x83ffffff,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x20000000,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x20100000,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x20100000,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x20100000,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x20100000,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x20100000,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x20100000,
	0xA0000000,	0x00000000,
		0x4138, 0x20000000,
	0xB0000000,	0x00000000,
		0x413C, 0x00000000,
		0x4140, 0x00000000,
	0x83ffffff,	0x00000000,	0x40000000,	0x00000000,
		0x4144, 0x00000000,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x4144, 0x00002030,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x4144, 0x00002030,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x4144, 0x00002030,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x4144, 0x00002030,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x4144, 0x00002030,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x4144, 0x00002030,
	0xA0000000,	0x00000000,
		0x4144, 0x00000000,
	0xB0000000,	0x00000000,
		0x4148, 0x00000000,
		0x414C, 0x00000000,
		0x4150, 0x00000000,
		0x4154, 0x00000000,
		0x4158, 0x00000000,
		0x415C, 0x00000000,
		0x4160, 0xF0040FF8,
		0x4164, 0x7F000000,
		0x4168, 0x00000000,
	0x83ffffff,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x00008000,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x00008002,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x00008002,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x00008002,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x00008002,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x00008002,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x00008002,
	0xA0000000,	0x00000000,
		0x416C, 0x00008000,
	0xB0000000,	0x00000000,
		0x4170, 0x00000000,
		0x4174, 0x00000000,
		0x4178, 0x00000000,
		0x417C, 0x00000000,
		0x4180, 0x00000000,
	0x83ffffff,	0x00000000,	0x40000000,	0x00000000,
		0x4184, 0x02B00000,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x4184, 0x03B00000,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x4184, 0x03B00000,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x4184, 0x03B00000,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x4184, 0x03B00000,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x4184, 0x03B00000,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x4184, 0x03B00000,
	0xA0000000,	0x00000000,
		0x4184, 0x02B00000,
	0xB0000000,	0x00000000,
		0x4188, 0x00000000,
		0x418C, 0x00000000,
		0x4190, 0x00000000,
		0x4194, 0x00000000,
		0x4198, 0x00000000,
		0x41A0, 0x00510000,
		0x41A4, 0x183C1F7F,
		0x41A8, 0x1402C99A,
		0x41AC, 0x00004200,
		0x41B0, 0x0809FB08,
		0x41B0, 0x0809FB09,
		0x41B4, 0x00000000,
		0x41B8, 0x00000000,
		0x41BC, 0x00C3FF80,
		0x41C0, 0x0002D100,
		0x41C4, 0x00000004,
		0x41C8, 0x001FFFE0,
		0x41CC, 0x0809FB08,
		0x41CC, 0x0809FB09,
		0x41D0, 0x00000000,
		0x41D4, 0x00000000,
		0x41D8, 0x00C3FF80,
		0x41DC, 0x0002D100,
		0x41E0, 0x00000004,
		0x41E4, 0x001FFFE0,
		0x41E8, 0x00000200,
		0x41EC, 0x1E008000,
		0x41F0, 0x7F000064,
		0x41F4, 0x1F7DE75C,
		0x41F8, 0x7F7F7F7F,
		0x41FC, 0x7F7F7F7F,
		0x1830, 0x700B8001,
		0x1830, 0x700B8001,
		0x1830, 0x70144001,
		0x1830, 0x70244001,
		0x1830, 0x70344001,
		0x1830, 0x70444001,
		0x1830, 0x705B8001,
		0x1830, 0x70644001,
		0x1830, 0x707B8001,
		0x1830, 0x708B8001,
		0x1830, 0x709B8001,
		0x1830, 0x70AB8001,
		0x1830, 0x70BB8001,
		0x1830, 0x70CB8001,
		0x1830, 0x70DB8001,
		0x1830, 0x70EB8001,
		0x1830, 0x70FB8001,
		0x1830, 0x70FB8001,
		0x4130, 0x700B8001,
		0x4130, 0x700B8001,
		0x4130, 0x70144001,
		0x4130, 0x70244001,
		0x4130, 0x70344001,
		0x4130, 0x70444001,
		0x4130, 0x705B8001,
		0x4130, 0x70644001,
		0x4130, 0x707B8001,
		0x4130, 0x708B8001,
		0x4130, 0x709B8001,
		0x4130, 0x70AB8001,
		0x4130, 0x70BB8001,
		0x4130, 0x70CB8001,
		0x4130, 0x70DB8001,
		0x4130, 0x70EB8001,
		0x4130, 0x70FB8001,
		0x4130, 0x70FB8001,
		0x1A00, 0x00D047C8,
		0x1A04, 0xC0000008,
		0x1A08, 0x88838300,
		0x1A0C, 0x2E20100F,
		0x1A10, 0x9500BB78,
		0x1A14, 0x111440A8,
		0x1A18, 0x00881117,
		0x1A1C, 0x89140F00,
		0x1A20, 0x52840000,
		0x1A24, 0x3E18FEC8,
		0x1A28, 0x00150A88,
		0x1A2C, 0x12988000,
		0x1A30, 0x10114007,
		0x1A34, 0x1011C007,
		0x1A38, 0x00000000,
		0x1A3C, 0x00000000,
		0x1A40, 0x00000000,
		0x1A44, 0x00000000,
		0x1A48, 0x000C0000,
		0x1A4C, 0xB00000C0,
		0x1A50, 0x22040700,
		0x1A54, 0x09003000,
		0x1A58, 0x00000881,
		0x1A5C, 0x00000128,
		0x1A60, 0x85830000,
		0x1A64, 0x00000128,
		0x1A68, 0x00222211,
		0x1A6C, 0x00000000,
		0x1A70, 0x00008000,
		0x1A74, 0x00000048,
		0x1A78, 0x000089F0,
		0x1A7C, 0x225B0606,
		0x1A80, 0x208A7532,
		0x1A84, 0x85200200,
		0x1A88, 0x048C0000,
		0x1A8C, 0x00000000,
		0x1A90, 0x00000000,
		0x1A94, 0x00000000,
		0x1A98, 0xACC4C040,
		0x1A9C, 0x0016C8B2,
		0x1AA0, 0x00FAF0DE,
		0x1AA4, 0x00020000,
		0x1AA8, 0xBA0F0004,
		0x1AAC, 0x00122344,
		0x1AB0, 0x0FFFFFFF,
		0x1AB4, 0x0F201402,
		0x1AB8, 0x00000000,
		0x1ABC, 0xC2008080,
		0x1AC0, 0x54D0A742,
		0x1AC4, 0x00000000,
		0x1AC8, 0x00000807,
		0x1ACC, 0x00000707,
		0x1AD0, 0xA33529CE,
		0x1AD4, 0x0D8D8452,
		0x1AD8, 0x08024024,
		0x1ADC, 0x000D0001,
		0x1AE0, 0x00600391,
		0x1AE4, 0x08000080,
		0x1AE8, 0xC2100002,
		0x1AEC, 0x000000F6,
		0x1AF0, 0x00000000,
		0x1AF4, 0x00000000,
		0x1AF8, 0x00000000,
		0x1AFC, 0x00000000,
		0x1D0C, 0x00400000,
		0x1D0C, 0x00410000,
		0x1EE8, 0x00000003,
		0xC0C, 0x02F1D8BF,
		0x1D94, 0x40000000,
		0x1D94, 0x40010000,
		0x1D94, 0x40020000,
		0x1D94, 0x40030000,
		0x1D94, 0x40040000,
		0x1D94, 0x40050000,
		0x1D94, 0x40060000,
		0x1D94, 0x40070000,
		0x1D94, 0x40080000,
		0x1D94, 0x40090000,
		0x1D94, 0x400A0000,
		0x1D94, 0x400B0000,
		0x1D94, 0x400C0000,
		0x1D94, 0x400D0000,
		0x1D94, 0x400E0000,
		0x1D94, 0x400F0000,
		0x1D94, 0x40100000,
		0x1D94, 0x40110000,
		0x1D94, 0x40120000,
		0x1D94, 0x40130000,
		0x1D94, 0x40140000,
		0x1D94, 0x40150000,
		0x1D94, 0x40160000,
		0x1D94, 0x40170000,
		0x1D94, 0x40180000,
		0x1D94, 0x40190000,
		0x1D94, 0x401A0000,
		0x1D94, 0x401B0000,
		0x1D94, 0x401C0000,
		0x1D94, 0x401D0000,
		0x1D94, 0x401E0000,
		0x1D94, 0x401F0000,
		0x1D94, 0x40200000,
		0x1D94, 0x40210000,
		0x1D94, 0x40220000,
		0x1D94, 0x40230000,
		0x1D94, 0x40240000,
		0x1D94, 0x40250000,
		0x1D94, 0x40260000,
		0x1D94, 0x40270000,
		0x1D94, 0x40280000,
		0x1D94, 0x40290000,
		0x1D94, 0x402A0000,
		0x1D94, 0x402B0000,
		0x1D94, 0x402C0000,
		0x1D94, 0x402D0000,
		0x1D94, 0x402E0000,
		0x1D94, 0x402F0000,
		0x1D94, 0x40300000,
		0x1D94, 0x40310000,
		0x1D94, 0x40320000,
		0x1D94, 0x40330000,
		0x1D94, 0x40340000,
		0x1D94, 0x40350000,
		0x1D94, 0x40360000,
		0x1D94, 0x40370000,
		0x1D94, 0x40380000,
		0x1D94, 0x40390000,
		0x1D94, 0x403A0000,
		0x1D94, 0x403B0000,
		0x1D94, 0x403C0000,
		0x1D94, 0x403D0000,
		0x1D94, 0x403E0000,
		0x1D94, 0x403F0000,
		0x1D94, 0x40400000,
		0x1D94, 0x40410000,
		0x1D94, 0x40420000,
		0x1D94, 0x40430000,
		0x1D94, 0x40440000,
		0x1D94, 0x40450000,
		0x1D94, 0x40460000,
		0x1D94, 0x40470000,
		0x1D94, 0x40480000,
		0x1D94, 0x40490000,
		0x1D94, 0x404A0000,
		0x1D94, 0x404B0000,
		0x1D94, 0x404C0000,
		0x1D94, 0x404D0000,
		0x1D94, 0x404E0000,
		0x1D94, 0x404F0000,
		0x1D94, 0x40500000,
		0x1D94, 0x40510000,
		0x1D94, 0x40520000,
		0x1D94, 0x40530000,
		0x1D94, 0x40540000,
		0x1D94, 0x40550000,
		0x1D94, 0x40560000,
		0x1D94, 0x40570000,
		0x1D94, 0x40580000,
		0x1D94, 0x40590000,
		0x1D94, 0x405A0000,
		0x1D94, 0x405B0000,
		0x1D94, 0x405C0000,
		0x1D94, 0x405D0000,
		0x1D94, 0x405E0000,
		0x1D94, 0x405F0000,
		0x1D94, 0x40600000,
		0x1D94, 0x40610000,
		0x1D94, 0x40620000,
		0x1D94, 0x40630000,
		0x1D94, 0x40640000,
		0x1D94, 0x40650000,
		0x1D94, 0x40660000,
		0x1D94, 0x40670000,
		0x1D94, 0x40680000,
		0x1D94, 0x40690000,
		0x1D94, 0x406A0000,
		0x1D94, 0x406B0000,
		0x1D94, 0x406C0000,
		0x1D94, 0x406D0000,
		0x1D94, 0x406E0000,
		0x1D94, 0x406F0000,
		0x1D94, 0x40700000,
		0x1D94, 0x40710000,
		0x1D94, 0x40720000,
		0x1D94, 0x40730000,
		0x1D94, 0x40740000,
		0x1D94, 0x40750000,
		0x1D94, 0x40760000,
		0x1D94, 0x40770000,
		0x1D94, 0x40780000,
		0x1D94, 0x40790000,
		0x1D94, 0x407A0000,
		0x1D94, 0x407B0000,
		0x1D94, 0x407C0000,
		0x1D94, 0x407D0000,
		0x1D94, 0x407E0000,
		0x1D94, 0x407F0000,
		0x1D94, 0x40800000,
		0x1D94, 0x40810000,
		0x1D94, 0x40820000,
		0x1D94, 0x40830000,
		0x1D94, 0x40840000,
		0x1D94, 0x40850000,
		0x1D94, 0x40860000,
		0x1D94, 0x40870000,
		0x1D94, 0x40880000,
		0x1D94, 0x40890000,
		0x1D94, 0x408A0000,
		0x1D94, 0x408B0000,
		0x1D94, 0x408C0000,
		0x1D94, 0x408D0000,
		0x1D94, 0x408E0000,
		0x1D94, 0x408F0000,
		0x1D94, 0x40900000,
		0x1D94, 0x40910000,
		0x1D94, 0x40920000,
		0x1D94, 0x40930000,
		0x1D94, 0x40940000,
		0x1D94, 0x40950000,
		0x1D94, 0x40960000,
		0x1D94, 0x40970000,
		0x1D94, 0x40980000,
		0x1D94, 0x40990000,
		0x1D94, 0x409A0000,
		0x1D94, 0x409B0000,
		0x1D94, 0x409C0000,
		0x1D94, 0x409D0000,
		0x1D94, 0x409E0000,
		0x1D94, 0x409F0000,
		0x1D94, 0x40A00000,
		0x1D94, 0x40A10000,
		0x1D94, 0x40A20000,
		0x1D94, 0x40A30000,
		0x1D94, 0x40A40000,
		0x1D94, 0x40A50000,
		0x1D94, 0x40A60000,
		0x1D94, 0x40A70000,
		0x1D94, 0x40A80000,
		0x1D94, 0x40A90000,
		0x1D94, 0x40AA0000,
		0x1D94, 0x40AB0000,
		0x1D94, 0x40AC0000,
		0x1D94, 0x40AD0000,
		0x1D94, 0x40AE0000,
		0x1D94, 0x40AF0000,
		0x1D94, 0x40B00000,
		0x1D94, 0x40B10000,
		0x1D94, 0x40B20000,
		0x1D94, 0x40B30000,
		0x1D94, 0x40B40000,
		0x1D94, 0x40B50000,
		0x1D94, 0x40B60000,
		0x1D94, 0x40B70000,
		0x1D94, 0x40B80000,
		0x1D94, 0x40B90000,
		0x1D94, 0x40BA0000,
		0x1D94, 0x40BB0000,
		0x1D94, 0x40BC0000,
		0x1D94, 0x40BD0000,
		0x1D94, 0x40BE0000,
		0x1D94, 0x40BF0000,
		0x1D94, 0x40C00000,
		0x1D94, 0x40C10000,
		0x1D94, 0x40C20000,
		0x1D94, 0x40C30000,
		0x1D94, 0x40C40000,
		0x1D94, 0x40C50000,
		0x1D94, 0x40C60000,
		0x1D94, 0x40C70000,
		0x1D94, 0x40C80000,
		0x1D94, 0x40C90000,
		0x1D94, 0x40CA0000,
		0x1D94, 0x40CB0000,
		0x1D94, 0x40CC0000,
		0x1D94, 0x40CD0000,
		0x1D94, 0x40CE0000,
		0x1D94, 0x40CF0000,
		0x1D94, 0x40D00000,
		0x1D94, 0x40D10000,
		0x1D94, 0x40D20000,
		0x1D94, 0x40D30000,
		0x1D94, 0x40D40000,
		0x1D94, 0x40D50000,
		0x1D94, 0x40D60000,
		0x1D94, 0x40D70000,
		0x1D94, 0x40D80000,
		0x1D94, 0x40D90000,
		0x1D94, 0x40DA0000,
		0x1D94, 0x40DB0000,
		0x1D94, 0x40DC0000,
		0x1D94, 0x40DD0000,
		0x1D94, 0x40DE0000,
		0x1D94, 0x40DF0000,
		0x1D94, 0x40E00000,
		0x1D94, 0x40E10000,
		0x1D94, 0x40E20000,
		0x1D94, 0x40E30000,
		0x1D94, 0x40E40000,
		0x1D94, 0x40E50000,
		0x1D94, 0x40E60000,
		0x1D94, 0x40E70000,
		0x1D94, 0x40E80000,
		0x1D94, 0x40E90000,
		0x1D94, 0x40EA0000,
		0x1D94, 0x40EB0000,
		0x1D94, 0x40EC0000,
		0x1D94, 0x40ED0000,
		0x1D94, 0x40EE0000,
		0x1D94, 0x40EF0000,
		0x1D94, 0x40F00000,
		0x1D94, 0x40F10000,
		0x1D94, 0x40F20000,
		0x1D94, 0x40F30000,
		0x1D94, 0x40F40000,
		0x1D94, 0x40F50000,
		0x1D94, 0x40F60000,
		0x1D94, 0x40F70000,
		0x1D94, 0x40F80000,
		0x1D94, 0x40F90000,
		0x1D94, 0x40FA0000,
		0x1D94, 0x40FB0000,
		0x1D94, 0x40FC0000,
		0x1D94, 0x40FD0000,
		0x1D94, 0x40FE0000,
		0x1D94, 0x40FF0000,
		0xC0C, 0x02F1D8B7,
		0x1EE8, 0x00000000,

};

void
odm_read_and_config_mp_8822c_phy_reg(struct dm_struct *dm)
{
	boolean is_matched, find_target;
	u32 cfg_target = 0, cfg_para = 0;
	u32 i = 0;
	u32 array_len = 0;
	u32 *array = NULL;
	u32 v1 = 0, v2 = 0;
	u8 h_size = 0;
	u8 h_idx = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	array_len =
		sizeof(array_mp_8822c_phy_reg) / sizeof(u32);
	array = (u32 *)array_mp_8822c_phy_reg;

	if (!halbb_sel_headline(dm, array, array_len, &h_size, &h_idx)) {
		PHYDM_DBG(dm, ODM_COMP_INIT, "No any match case.\n");
		return;
	}
	PHYDM_DBG(dm, ODM_COMP_INIT, "len = %d, h_size = %d, h_idx = %d\n",
			  array_len, h_size, h_idx);

	if (h_size != 0) {
		cfg_target = array[h_idx << 1] & 0x0fffffff;
	}

	i += h_size;

	PHYDM_DBG(dm, ODM_COMP_INIT, "cfg_target = 0x%x\n", cfg_target);
	PHYDM_DBG(dm, ODM_COMP_INIT, "array[i] = 0x%x, array[i+1] = 0x%x\n",
			  array[i], array[i + 1]);

	halbb_flag_2_default(&is_matched, &find_target);
	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];
		i += 2;

		switch (v1 >> 28) {
		case PARA_IF:
		case PARA_ELSE_IF:
			cfg_para = v1 & 0x0fffffff;
			PHYDM_DBG(dm, ODM_COMP_INIT, "*if (cart=%d, rfe=%d)\n",
			       (cfg_para & 0x0f000000) >> 24, cfg_para & 0xff);
			break;
		case PARA_ELSE:
			PHYDM_DBG(dm, ODM_COMP_INIT, "*else\n");
			is_matched = false;
			if (!find_target) {
				PHYDM_DBG(dm, ODM_COMP_INIT, "Init Fail in Reg 0x%x\n", array[i]);
				return;
			}
			break;
		case PARA_END:
			PHYDM_DBG(dm, ODM_COMP_INIT, "*endif\n");
			halbb_flag_2_default(&is_matched, &find_target);
			break;
		case PARA_CHK:
			/*Check this para meets driver's requirement or not*/
			if (find_target) {
				PHYDM_DBG(dm, ODM_COMP_INIT, "	 skip\n");
				is_matched = false;
				break;
			}

			if (cfg_para == cfg_target) {
				is_matched = true;
				find_target = true;
			} else {
				is_matched = false;
				find_target = false;
			}
			PHYDM_DBG(dm, ODM_COMP_INIT, "	 match=%d\n", is_matched);
			break;
		default:
			if (is_matched)
					odm_config_bb_phy_8822c(dm, v1, MASKDWORD, v2);
			break;
		}
	}
	PHYDM_DBG(dm, ODM_COMP_INIT, "BBCR Init Success\n");
}

u32
odm_get_version_mp_8822c_phy_reg(void)
{
		return 61;
}

/******************************************************************************
 *                           phy_reg_pg.TXT
 ******************************************************************************/

#ifdef CONFIG_8822C
const u32 array_mp_8822c_phy_reg_pg[] = {
	0, 0, 0, 0x00000c20, 0xffffffff, 0x484c5054,
	0, 0, 0, 0x00000c24, 0xffffffff, 0x54585858,
	0, 0, 0, 0x00000c28, 0xffffffff, 0x44484c50,
	0, 0, 0, 0x00000c2c, 0xffffffff, 0x50545858,
	0, 0, 0, 0x00000c30, 0xffffffff, 0x4044484c,
	0, 0, 1, 0x00000c34, 0xffffffff, 0x50545858,
	0, 0, 1, 0x00000c38, 0xffffffff, 0x4044484c,
	0, 0, 0, 0x00000c3c, 0xffffffff, 0x50545858,
	0, 0, 0, 0x00000c40, 0xffffffff, 0x4044484c,
	0, 0, 0, 0x00000c44, 0xffffffff, 0x5858383c,
	0, 0, 1, 0x00000c48, 0xffffffff, 0x484c5054,
	0, 0, 1, 0x00000c4c, 0xffffffff, 0x383c4044,
	0, 1, 0, 0x00000e20, 0xffffffff, 0x484c5054,
	0, 1, 0, 0x00000e24, 0xffffffff, 0x54585858,
	0, 1, 0, 0x00000e28, 0xffffffff, 0x44484c50,
	0, 1, 0, 0x00000e2c, 0xffffffff, 0x50545858,
	0, 1, 0, 0x00000e30, 0xffffffff, 0x4044484c,
	0, 1, 1, 0x00000e34, 0xffffffff, 0x50545858,
	0, 1, 1, 0x00000e38, 0xffffffff, 0x4044484c,
	0, 1, 0, 0x00000e3c, 0xffffffff, 0x50545858,
	0, 1, 0, 0x00000e40, 0xffffffff, 0x4044484c,
	0, 1, 0, 0x00000e44, 0xffffffff, 0x5858383c,
	0, 1, 1, 0x00000e48, 0xffffffff, 0x484c5054,
	0, 1, 1, 0x00000e4c, 0xffffffff, 0x383c4044,
	1, 0, 0, 0x00000c24, 0xffffffff, 0x54585858,
	1, 0, 0, 0x00000c28, 0xffffffff, 0x44484c50,
	1, 0, 0, 0x00000c2c, 0xffffffff, 0x50545858,
	1, 0, 0, 0x00000c30, 0xffffffff, 0x4044484c,
	1, 0, 1, 0x00000c34, 0xffffffff, 0x50545858,
	1, 0, 1, 0x00000c38, 0xffffffff, 0x4044484c,
	1, 0, 0, 0x00000c3c, 0xffffffff, 0x50545858,
	1, 0, 0, 0x00000c40, 0xffffffff, 0x4044484c,
	1, 0, 0, 0x00000c44, 0xffffffff, 0x5858383c,
	1, 0, 1, 0x00000c48, 0xffffffff, 0x484c5054,
	1, 0, 1, 0x00000c4c, 0xffffffff, 0x383c4044,
	1, 1, 0, 0x00000e24, 0xffffffff, 0x54585858,
	1, 1, 0, 0x00000e28, 0xffffffff, 0x44484c50,
	1, 1, 0, 0x00000e2c, 0xffffffff, 0x50545858,
	1, 1, 0, 0x00000e30, 0xffffffff, 0x4044484c,
	1, 1, 1, 0x00000e34, 0xffffffff, 0x50545858,
	1, 1, 1, 0x00000e38, 0xffffffff, 0x4044484c,
	1, 1, 0, 0x00000e3c, 0xffffffff, 0x50545858,
	1, 1, 0, 0x00000e40, 0xffffffff, 0x4044484c,
	1, 1, 0, 0x00000e44, 0xffffffff, 0x5858383c,
	1, 1, 1, 0x00000e48, 0xffffffff, 0x484c5054,
	1, 1, 1, 0x00000e4c, 0xffffffff, 0x383c4044
};

#endif

void
odm_read_and_config_mp_8822c_phy_reg_pg(struct dm_struct *dm)
{
#ifdef CONFIG_8822C

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8822c_phy_reg_pg) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8822c_phy_reg_pg;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 2;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8822c(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

#endif /* end of HWIMG_SUPPORT*/

