set terminal cairolatex pdf color standalone
set output "mosolov-augmented-lagrangian-square-P1-Bi-0,4-cvg.tex"

set size square 
set colors classic
set logscale xy
set xrange [1:1e6]
set yrange [1e-10:10]
graph_ratio_xy = 6./11.
set xtics (\
        "[c]{$1$}" 1, \
        "[r]{$10^{3}$}" 1e3, \
        "[r]{$10^{6}$}" 1e6)
set ytics (\
        "[r]{$10^{-10}$}" 1e-10, \
        "[r]{$10^{-5}$}" 1e-5, \
        "[r]{$1$}" 1 )
set xlabel "[c]{$k$}"
set  label "[l]{residue}" at graph 0.03,0.95

# triangle a gauche
slope_D = graph_ratio_xy*(-1.0)
xD =  0.29
yD =  0.58
dxD = 0.15
dyD = dxD*slope_D
set label "[r]{\\scriptsize $-1$}" at graph xD-0.02, yD+0.5*dyD right
set arrow from graph xD,     yD     to graph xD,     yD+dyD nohead
set arrow from graph xD,     yD+dyD to graph xD+dxD, yD+dyD nohead
set arrow from graph xD+dxD, yD+dyD to graph xD,     yD     nohead

plot \
'< zcat ${GNUPLOT_LIB}/mosolov-augmented-lagrangian-square-10-P1-Bi-0,4-cvg.gdat.gz' \
    t '[r]{$h=1/10$}' \
    w l lw 2 lc 0 dt 3, \
'< zcat ${GNUPLOT_LIB}/mosolov-augmented-lagrangian-square-20-P1-Bi-0,4-cvg.gdat.gz' \
    t '[r]{$h=1/20$}' \
    w l lw 3 lc 1, \
'< zcat ${GNUPLOT_LIB}/mosolov-augmented-lagrangian-square-30-P1-Bi-0,4-cvg.gdat.gz' \
    t '[r]{$h=1/30$}' \
    w l lw 3 lc rgb "#008800", \
'< zcat ${GNUPLOT_LIB}/mosolov-augmented-lagrangian-square-40-P1-Bi-0,4-cvg.gdat.gz' \
    t '[r]{$h=1/40$}' \
    w l lw 3 lc 4
#'< zcat ${GNUPLOT_LIB}/mosolov-augmented-lagrangian-square-50-P1-Bi-0,4-cvg.gdat.gz' \
#    t '[r]{$h=1/50$}' \
#    w l lw 3 lc 0

#pause -1 "<return>"
