#ifndef _RHEOLEF_BASIS_FEM_PK_BERNSTEIN_H
#define _RHEOLEF_BASIS_FEM_PK_BERNSTEIN_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
/*Class:sherwin
NAME: @code{Bk} - Bernstein polynomial basis
@cindex  polynomial basis
@clindex space
@clindex basis
@clindex reference_element
@clindex basis_option
SYNOPSIS:
  space Vh(omega,"B5");
DESCRIPTION:
  @noindent
  This @code{basis} was initially introduced by Bernstein
  (Comm. Soc. Math. Kharkov, 2th series, 1912) and more
  recently used in the context of finite elements.
  It is indicated in the @code{space} (see @ref{space class})
  by a string starting with
  the letter @code{"B"},
  followed by digits indicating the polynomial order.

OPTIONS:
  This basis do not recognizes any option.
  See @ref{basis_option class}.

AUTHOR: Pierre.Saramito@imag.fr
DATE:   23 september 2017
End:
*/
//
// Bernstein Pk basis
//
// author: Pierre.Saramito@imag.fr
//
// date: 11 september 2017
//
#include "rheolef/basis.h"
namespace rheolef {

template<class T>
class basis_fem_Pk_bernstein: public basis_rep<T> {
public:

// typedefs:

  typedef basis_rep<T>              base;
  typedef reference_element::size_type size_type;
  typedef T                            value_type;

// allocators:

  basis_fem_Pk_bernstein (
    std::string              name,
    const basis_option& sopt);
  ~basis_fem_Pk_bernstein();

// accessors:

  std::string family_name() const { return "B"; }
  size_type degree() const { return _raw_basis.degree(); }
  bool is_nodal() const { return false; }

// evaluation of all basis functions at hat_x:

  void eval(
    reference_element                 hat_K,
    const point_basic<T>&             hat_x,
    arma::Col<T>&                     value) const;

// evaluate the gradient:

  void grad_eval(
    reference_element           hat_K,
    const point_basic<T>&       hat_x,
    std::vector<point_basic<T> >& value) const;

// internals:
  
  void _initialize (reference_element hat_K) const;
  void _compute_dofs (
    reference_element     hat_K, 
    const arma::Col<T>&   f_xnod, // scalar-valued case
          arma::Col<T>&   dof) const;

protected:
// data:
  basis_raw_basic<T> _raw_basis;
};

} // namespace rheolef
#endif // _RHEOLEF_BASIS_FEM_PK_BERNSTEIN_H
