#ifndef _RHEO_DIS_MEMORY_USAGE_H
#define _RHEO_DIS_MEMORY_USAGE_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

#include "rheolef/distributed.h"

namespace rheolef {

/*D:dis_memory_usage
NAME: @code{dis_memory_usage}, @code{seq_memory_usage} -- physical memory in use
SYNOPSIS:
  @noindent
  @example
    size_t dis_memory_usage();
    size_t seq_memory_usage();
    size_t dis_peak_memory_usage();
    size_t seq_peak_memory_usage();
    size_t memory_size();
  @end example

DESCRIPTION:       
  @noindent
  @code{seq_memory_usage} returns the current resident set size 
  (physical memory use) measured in bytes, 
  or zero if the value cannot be determined on this OS.

  @noindent
  @code{dis_memory_usage} returns the accumulated memory usage
  for all processed linked together via the default communicator.

  @noindent
  @code{seq_peak_memory_usage} returns the peak (maximum so far)
  resident set size (physical memory use) measured in bytes,
  or zero if the value cannot be determined on this OS.

  @noindent
  @code{dis_peak_memory_usage} returns the accumulated peak memory usage
  for all processed linked together via the default communicator.

  @code{memory_size} returns the size of physical memory (RAM) in bytes
  associated to the given process.

AUTHOR: 
    Pierre Saramito
    Pierre.Saramito@imag.fr
    LJK-IMAG, 38041 Grenoble cedex 9, France
DATE: 
    4 january 2018
End:
*/

size_t seq_memory_usage();
size_t dis_memory_usage();
size_t seq_peak_memory_usage();
size_t dis_peak_memory_usage();
size_t memory_size();

} // namespace rheolef
#endif // _RHEO_DIS_MEMORY_USAGE_H
