#ifndef _RHEOLEF_SOLVER_NO_TRILINOS_IFPACK_H
#define _RHEOLEF_SOLVER_NO_TRILINOS_IFPACK_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
// solver implementation: interface
//

#include "rheolef/config.h"

#if !defined(_RHEOLEF_HAVE_TRILINOS) && !defined(_RHEOLEF_HAVE_PASTIX)

#include "rheolef/solver.h"

namespace rheolef {

// =======================================================================
// rep
// =======================================================================
template<class T, class M>
class solver_no_trilinos_ifpack_rep : public solver_abstract_rep<T,M> {
public:
// typedef:

  typedef typename csr<T,M>::size_type size_type;

// allocator:

  solver_no_trilinos_ifpack_rep() : solver_abstract_rep<T,M>(solver_option()), _ic0() {}
  explicit solver_no_trilinos_ifpack_rep (const csr<T,M>& a, const solver_option& opt = solver_option());
  void update_values (const csr<T,M>& a);
  ~solver_no_trilinos_ifpack_rep ();

// accessors:

  vec<T,M> trans_solve (const vec<T,M>& rhs) const;
  vec<T,M> solve       (const vec<T,M>& rhs) const;

protected:
// data:
  csr<T,M> _ic0;
};

} // namespace rheolef
#endif // !defined(_RHEOLEF_HAVE_TRILINOS) && !defined(_RHEOLEF_HAVE_PASTIX)
#endif // _RHEOLEF_SOLVER_NO_TRILINOS_IFPACK_H
