import sys
import glob
from distutils.version import LooseVersion

CYTHON_VERSION = '0.23.4'

from Cython import __version__
if LooseVersion(__version__) < CYTHON_VERSION:
    raise RuntimeError('Cython >= %s needed to build scikit-image' % CYTHON_VERSION)

from Cython.Build import cythonize

from _build import _changed, process_tempita_pyx


pyx_files = []

for pyxfile in glob.glob('**/*.pyx', recursive=True) + glob.glob('**/*.pyx.in', recursive=True):
    if not _changed(pyxfile):
        continue

    if pyxfile.endswith('.pyx.in'):
        process_tempita_pyx(pyxfile)
        pyxfile = pyxfile.replace('.pyx.in', '.pyx')

    pyx_files.append(pyxfile)

cythonize(pyx_files, nthreads=int(sys.argv[1]))
