/******************************************************************************
*       SOFA, Simulation Open-Framework Architecture, version 1.0 beta 4      *
*                (c) 2006-2009 MGH, INRIA, USTL, UJF, CNRS                    *
*                                                                             *
* This library is free software; you can redistribute it and/or modify it     *
* under the terms of the GNU Lesser General Public License as published by    *
* the Free Software Foundation; either version 2.1 of the License, or (at     *
* your option) any later version.                                             *
*                                                                             *
* This library is distributed in the hope that it will be useful, but WITHOUT *
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or       *
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License *
* for more details.                                                           *
*                                                                             *
* You should have received a copy of the GNU Lesser General Public License    *
* along with this library; if not, write to the Free Software Foundation,     *
* Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA.          *
*******************************************************************************
*                               SOFA :: Modules                               *
*                                                                             *
* Authors: The SOFA Team and external contributors (see Authors.txt)          *
*                                                                             *
* Contact information: contact@sofa-framework.org                             *
******************************************************************************/
#ifndef SOFA_TYPEDEF_INTERACTIONFORCEFIELD_FLOAT_H
#define SOFA_TYPEDEF_INTERACTIONFORCEFIELD_FLOAT_H

#include <sofa/defaulttype/VecTypes.h>
#include <sofa/defaulttype/RigidTypes.h>


#include <sofa/component/interactionforcefield/InteractionEllipsoidForceField.h>
#include <sofa/component/interactionforcefield/RepulsiveSpringForceField.h>


//InteractionEllipsoidForceField undefined for float
//---------------------
typedef sofa::component::interactionforcefield::InteractionEllipsoidForceField<sofa::defaulttype::Vec3fTypes, sofa::defaulttype::Rigid3fTypes> InteractionEllipsoidForceField3f;

//RepulsiveSpringForceField
//---------------------
//Deformable
typedef sofa::component::interactionforcefield::RepulsiveSpringForceField<sofa::defaulttype::Vec1fTypes> RepulsiveSpringForceField1f;
typedef sofa::component::interactionforcefield::RepulsiveSpringForceField<sofa::defaulttype::Vec2fTypes> RepulsiveSpringForceField2f;
typedef sofa::component::interactionforcefield::RepulsiveSpringForceField<sofa::defaulttype::Vec3fTypes> RepulsiveSpringForceField3f;

#ifdef SOFA_FLOAT
typedef InteractionEllipsoidForceField3f InteractionEllipsoidForceField3; 
typedef RepulsiveSpringForceField1f    RepulsiveSpringForceField1;
typedef RepulsiveSpringForceField2f    RepulsiveSpringForceField2;
typedef RepulsiveSpringForceField3f    RepulsiveSpringForceField3;
#endif

#endif
