/* ====================================================================
 * Copyright (c) 2007,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_DIFFVIEWMODEL_H
#define _SC_DIFFVIEWMODEL_H

// sc
#include "sublib/TargetId.h"
#include "svn/Revision.h"
#include "svn/DiffSummarizeTypes.h"
#include "util/String.h"
class ScModel;
class DiffParam;
class DiffCmd;
class DiffThread;
namespace sc {
  class Error;
}

// qt
#include <QtCore/QObject>


class DiffViewModel : public QObject, public TargetId
{
  typedef QObject super;
   Q_OBJECT;

public:
  DiffViewModel( bool changePathOrUrl1, bool changePathOrUrl2,
    bool changeType, bool pegDiff, ScModel* model );
  ~DiffViewModel();

  // QObject
  bool event( QEvent* e );

public:
  void diff();
  void patch();
  void summarize();
  void diffResult( DiffParam*, const sc::Error* );

  bool getDir();
  const sc::String& getPathOrUrl1();
  const sc::String& getPathOrUrl2();
  const svn::RevisionPtr getRevisionPeg();
  const svn::RevisionPtr getRevision1();
  const svn::RevisionPtr getRevision2();
  bool getRecursive();
  bool getCopies();
  bool getDeletes();
  bool getPegDiff();

  bool getChangePathOrUrl1();
  bool getChangePathOrUrl2();
  bool getChangeType();

  bool hasSelection();
  void setSelection( const svn::DiffSummarizes& );

  /** stop diff thread. */
  void stop();
  /** diff thread runing? */
  bool runs();

  typedef std::vector<DiffCmd*> DiffCmds;

public slots:
  void setDir( bool );
  void setPathOrUrl1( const sc::String& pathOrUrl1 );
  void setPathOrUrl2( const sc::String& pathOrUrl2 );
  void setRevisionPeg( svn::RevisionPtr );
  void setRevision1( svn::RevisionPtr );
  void setRevision2( svn::RevisionPtr );
  void setRecursive( bool );
  void setCopies( bool );
  void setDeletes( bool );
  void setPegDiff( bool );

signals:
  void showPatch( const QString& name, const QString& file );
  void addSumEntry( svn::DiffSummarizePtr );

private:
  void createSelectionCmds( DiffCmds& );
  svn::RevisionPtr calcPegRev();

  ScModel*            _model;
  bool                _changePathOrUrl1;
  bool                _changePathOrUrl2;
  bool                _changeType;

  // state
  bool                _dir;
  sc::String          _pathOrUrl1;
  sc::String          _pathOrUrl2;
  svn::RevisionPtr    _revPeg;
  svn::RevisionPtr    _rev1;
  svn::RevisionPtr    _rev2;
  bool                _recursive;
  bool                _copies;
  bool                _deletes;
  bool                _pegDiff;
  DiffThread*         _diffThread;

  svn::DiffSummarizes _selection;
};

#endif // _SC_DIFFVIEWMODEL_H
