/* ====================================================================
 * Copyright (c) 2009  Martin Hauner
 *                     http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_WCVIEWITEMROXYMODEL_H
#define _SC_WCVIEWITEMROXYMODEL_H

// sc
#include "WcViewItemModel.h"
//#include "TextStatusFilter.h"
#include "util/String.h"
class Index;

// qt
#include <QtGui/QAbstractProxyModel>

/**
 * Proxy model forworking copy view.
 */
class WcViewItemProxyModel : public QAbstractProxyModel, public
  WcViewItemModel
{
  typedef QAbstractProxyModel super;
  Q_OBJECT

public:
  WcViewItemProxyModel();
  ~WcViewItemProxyModel();

  // QAbstractItemModel
  QModelIndex index( int row, int column, const QModelIndex& parent )
    const;
  QModelIndex parent( const QModelIndex& index ) const;
  int columnCount( const QModelIndex& parent ) const;
  int rowCount( const QModelIndex& parent ) const;
  void setSourceModel( QAbstractItemModel* sourceModel );

  // QAbstractProxyModel
  QModelIndex mapFromSource( const QModelIndex& sourceIndex ) const;
  QModelIndex mapToSource( const QModelIndex& proxyIndex ) const;

  // WcViewItemModel
  QModelIndex index( const sc::String& name ) const;

public slots:
  // WcViewItemModel
  void insert( const sc::String& path, const WcViewItems& );
  void remove( const sc::String& path );

private:
  void disconnectModel();
  void connectModel();
  WcViewItemModel* sourceViewItemModel() const;

private slots:
  void srcColumnsAboutToBeInserted( const QModelIndex& srcParent,
    int start, int end );
  void srcColumnsAboutToBeRemoved( const QModelIndex& srcParent,
    int start, int end );
  void srcColumnsInserted( const QModelIndex& srcParent,
    int start, int end );
  void srcColumnsRemoved( const QModelIndex& srcParent,
    int start, int end );
  void srcDataChanged( const QModelIndex& srcTopLeft, const QModelIndex&
    srcBottomRight );
  void srcHeaderDataChanged( Qt::Orientation orientation,
    int first, int last );
  void srcLayoutAboutToBeChanged();
  void srcLayoutChanged();
  void srcModelReset();
  void srcRowsAboutToBeInserted( const QModelIndex& srcParent,
    int start, int end );
  void srcRowsAboutToBeRemoved( const QModelIndex& srcParent,
    int start, int end );
  void srcRowsInserted( const QModelIndex& srcParent,
    int start, int end );
  void srcRowsRemoved( const QModelIndex& srcParent,
    int start, int end );

private:
  Index* _index;

  // test support
  friend class WcViewItemProxyModelTest;
};

#endif // _SC_WCVIEWITEMROXYMODEL_H
