/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3u-20020503-1857 (Alpha 5)
 * And later MANUALLY edited at the end.
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIGPYTHON
/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__)
#       if defined(_MSC_VER)
#               if defined(STATIC_LINKED)
#                       define SWIGEXPORT(a) a
#               else
#                       define SWIGEXPORT(a) __declspec(dllexport) a
#               endif
#       else
#               if defined(__BORLANDC__)
#                       define SWIGEXPORT(a) a _export
#               else
#                       define SWIGEXPORT(a) a
#       endif
#endif
#else
#       define SWIGEXPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef struct swig_type_info {
  char  *name;                 
  void *(*converter)(void *);
  char  *str;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE
SWIGEXPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGEXPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGEXPORT(void *) SWIG_TypeCast(swig_type_info *, void *);
#else

static swig_type_info *swig_type_list = 0;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti)
{
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = swig_type_list;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = swig_type_list;
  swig_type_list = ti;

  /* Build linked lists */
 l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty)
{
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  while (s) {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
	s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      return s;
    }
    s = s->next;
  }
  return 0;
}

/* Cast a pointer (needed for C++ inheritance */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) 
{
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Search for a swig_type_info structure */
SWIGRUNTIME(void *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = swig_type_list;
  while (ty) {
    if (ty->str && (strcmp(name,ty->str) == 0)) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

#endif

#ifdef __cplusplus
}
#endif



/***********************************************************************
 * python.swg
 *
 *     This file contains the runtime support for Python modules
 *     and includes code for managing global variables and pointer
 *     type checking.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 ************************************************************************/

#include <stdlib.h>
#include "Python.h"

#ifdef __cplusplus
extern "C" {
#endif

#define SWIG_PY_INT     1
#define SWIG_PY_FLOAT   2
#define SWIG_PY_STRING  3
#define SWIG_PY_POINTER 4

/* Constant information structure */
typedef struct swig_const_info {
    int type;
    char *name;
    long lvalue;
    double dvalue;
    void   *pvalue;
    swig_type_info **ptype;
} swig_const_info;

#ifdef SWIG_NOINCLUDE

SWIGEXPORT(PyObject *)        SWIG_newvarlink();
SWIGEXPORT(void)              SWIG_addvarlink(PyObject *, char *, PyObject *(*)(void), int (*)(PyObject *));
SWIGEXPORT(int)               SWIG_ConvertPtr(PyObject *, void **, swig_type_info *, int);
SWIGEXPORT(void)              SWIG_MakePtr(char *c, void *, swig_type_info *);
SWIGEXPORT(PyObject *)        SWIG_NewPointerObj(void *, swig_type_info *);
SWIGEXPORT(void)              SWIG_InstallConstants(PyObject *d, swig_const_info constants[]);

#else

/* -----------------------------------------------------------------------------
 * global variable support code.
 * ----------------------------------------------------------------------------- */

typedef struct swig_globalvar {   
  char       *name;                  /* Name of global variable */
  PyObject *(*get_attr)(void);       /* Return the current value */
  int       (*set_attr)(PyObject *); /* Set the value */
  struct swig_globalvar *next;
} swig_globalvar;

typedef struct swig_varlinkobject {
  PyObject_HEAD
  swig_globalvar *vars;
} swig_varlinkobject;

static PyObject *
swig_varlink_repr(swig_varlinkobject *v) {
  v = v;
  return PyString_FromString("<Global variables>");
}

static int
swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags) {
  swig_globalvar  *var;
  flags = flags;
  fprintf(fp,"Global variables { ");
  for (var = v->vars; var; var=var->next) {
    fprintf(fp,"%s", var->name);
    if (var->next) fprintf(fp,", ");
  }
  fprintf(fp," }\n");
  return 0;
}

static PyObject *
swig_varlink_getattr(swig_varlinkobject *v, char *n) {
  swig_globalvar *var = v->vars;
  while (var) {
    if (strcmp(var->name,n) == 0) {
      return (*var->get_attr)();
    }
    var = var->next;
  }
  PyErr_SetString(PyExc_NameError,"Unknown C global variable");
  return NULL;
}

static int
swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p) {
  swig_globalvar *var = v->vars;
  while (var) {
    if (strcmp(var->name,n) == 0) {
      return (*var->set_attr)(p);
    }
    var = var->next;
  }
  PyErr_SetString(PyExc_NameError,"Unknown C global variable");
  return 1;
}

statichere PyTypeObject varlinktype = {
  PyObject_HEAD_INIT(0)              
  0,
  "swigvarlink",                      /* Type name    */
  sizeof(swig_varlinkobject),         /* Basic size   */
  0,                                  /* Itemsize     */
  0,                                  /* Deallocator  */ 
  (printfunc) swig_varlink_print,     /* Print        */
  (getattrfunc) swig_varlink_getattr, /* get attr     */
  (setattrfunc) swig_varlink_setattr, /* Set attr     */
  0,                                  /* tp_compare   */
  (reprfunc) swig_varlink_repr,       /* tp_repr      */    
  0,                                  /* tp_as_number */
  0,                                  /* tp_as_mapping*/
  0,                                  /* tp_hash      */
};

/* Create a variable linking object for use later */
SWIGRUNTIME(PyObject *)
SWIG_newvarlink(void) {
  swig_varlinkobject *result = 0;
  result = PyMem_NEW(swig_varlinkobject,1);
  varlinktype.ob_type = &PyType_Type;    /* Patch varlinktype into a PyType */
  result->ob_type = &varlinktype;
  result->vars = 0;
  result->ob_refcnt = 0;
  Py_XINCREF((PyObject *) result);
  return ((PyObject*) result);
}

SWIGRUNTIME(void)
SWIG_addvarlink(PyObject *p, char *name,
	   PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p)) {
  swig_varlinkobject *v;
  swig_globalvar *gv;
  v= (swig_varlinkobject *) p;
  gv = (swig_globalvar *) malloc(sizeof(swig_globalvar));
  gv->name = (char *) malloc(strlen(name)+1);
  strcpy(gv->name,name);
  gv->get_attr = get_attr;
  gv->set_attr = set_attr;
  gv->next = v->vars;
  v->vars = gv;
}
/* Convert a pointer value */
SWIGRUNTIME(int)
SWIG_ConvertPtr(PyObject *obj, void **ptr, swig_type_info *ty, int flags) {
  unsigned long p;
  register int d;
  swig_type_info *tc;
  char  *c;
  static PyObject *SWIG_this = 0;
  int    newref = 0;

  if (!obj || (obj == Py_None)) {
    *ptr = 0;
    return 0;
  }
#ifdef SWIG_COBJECT_TYPES
  if (!(PyCObject_Check(obj))) {
    if (!SWIG_this)
      SWIG_this = PyString_InternFromString("this");
    obj = PyObject_GetAttr(obj,SWIG_this);
    newref = 1;
    if (!obj) goto type_error;
    if (!PyCObject_Check(obj)) {
      Py_DECREF(obj);
      goto type_error;
    }
  } 
  *ptr = PyCObject_AsVoidPtr(obj);
  c = (char *) PyCObject_GetDesc(obj);
  if (newref) Py_DECREF(obj);
  goto cobject;
#else
  if (!(PyString_Check(obj))) {
    if (!SWIG_this)
      SWIG_this = PyString_InternFromString("this");
    obj = PyObject_GetAttr(obj,SWIG_this);
    newref = 1;
    if (!obj) goto type_error;
    if (!PyString_Check(obj)) {
      Py_DECREF(obj);
      goto type_error;
    }
  } 
  c = PyString_AsString(obj);
  p = 0;
  /* Pointer values must start with leading underscore */
  if (*c != '_') {
    *ptr = (void *) 0;
    if (strcmp(c,"NULL") == 0) {
      if (newref) Py_DECREF(obj);
      return 0;
    } else {
      if (newref) Py_DECREF(obj);
      goto type_error;
    }
  }
  c++;
  /* Extract hex value from pointer */
  while ((d = *c)) {
    if ((d >= '0') && (d <= '9'))
      p = (p << 4) + (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      p = (p << 4) + (d - ('a'-10));
    else
      break; 
    c++;
  }
  *ptr = (void *) p;
  if (newref) Py_DECREF(obj);
#endif

#ifdef SWIG_COBJECT_TYPES
cobject:
#endif

  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) goto type_error;
    *ptr = SWIG_TypeCast(tc,(void*)p);
  }
  return 0;

type_error:

  if (flags) {
    if (ty) {
      char *temp = (char *) malloc(64+strlen(ty->name));
      sprintf(temp,"Type error. Expected %s", ty->name);
      PyErr_SetString(PyExc_TypeError, temp);
      free((char *) temp);
    } else {
      PyErr_SetString(PyExc_TypeError,"Expected a pointer");
    }
  }
  return -1;
}

/* Take a pointer and convert it to a string */
SWIGRUNTIME(void) 
SWIG_MakePtr(char *c, void *ptr, swig_type_info *ty) {
  static char hex[17] = "0123456789abcdef";
  unsigned long p, s;
  char result[32], *r; 
  r = result;
  p = (unsigned long) ptr;
  if (p > 0) {
    while (p > 0) {
      s = p & 0xf;
      *(r++) = hex[s];
      p = p >> 4;
    }
    *r = '_';
    while (r >= result)
      *(c++) = *(r--);
    strcpy (c, ty->name);
  } else {
    strcpy (c, "NULL");
  }
}

/* Create a new pointer object */
SWIGRUNTIME(PyObject *)
SWIG_NewPointerObj(void *ptr, swig_type_info *type) {
  char result[512];
  PyObject *robj;
  if (!ptr) {
    Py_INCREF(Py_None);
    return Py_None;
  }
#ifdef SWIG_COBJECT_TYPES
  robj = PyCObject_FromVoidPtrAndDesc((void *) ptr, type->name, NULL);
#else
  SWIG_MakePtr(result,ptr,type);
  robj = PyString_FromString(result);
#endif
  return robj;
}

/* Install Constants */
SWIGRUNTIME(void)
SWIG_InstallConstants(PyObject *d, swig_const_info constants[]) {
  int i;
  PyObject *obj;
  for (i = 0; constants[i].type; i++) {
    switch(constants[i].type) {
    case SWIG_PY_INT:
      obj = PyInt_FromLong(constants[i].lvalue);
      break;
    case SWIG_PY_FLOAT:
      obj = PyFloat_FromDouble(constants[i].dvalue);
      break;
    case SWIG_PY_STRING:
      obj = PyString_FromString((char *) constants[i].pvalue);
      break;
    case SWIG_PY_POINTER:
      obj = SWIG_NewPointerObj(constants[i].pvalue, *(constants[i]).ptype);
      break;
    default:
      obj = 0;
      break;
    }
    if (obj) {
      PyDict_SetItemString(d,constants[i].name,obj);
      Py_DECREF(obj);
    }
  }
}

#endif

#ifdef __cplusplus
}
#endif



/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_DBFFile swig_types[0] 
static swig_type_info *swig_types[2];

/* -------- TYPES TABLE (END) -------- */


/*-----------------------------------------------
              @(target):= dbflibc.so
  ------------------------------------------------*/
#define SWIG_init    initdbflibc

#define SWIG_name    "dbflibc"

#include "shapefil.h"


/* Read one attribute from the dbf handle and return it as a new python object
 *
 * If an error occurs, set the appropriate Python exception and return
 * NULL.
 *
 * Assume that the values of the record and field arguments are valid.
 * The name argument will be passed to DBFGetFieldInfo as is and should
 * thus be either NULL or a pointer to an array of at least 12 chars
 */
static PyObject *
do_read_attribute(DBFInfo * handle, int record, int field, char * name)
{
    int type, width;
    PyObject *value;

    type = DBFGetFieldInfo(handle, field, name, &width, NULL);
    /* For strings NULL and the empty string are indistinguishable
     * in DBF files. We prefer empty strings instead for backwards
     * compatibility reasons because older wrapper versions returned
     * emtpy strings as empty strings.
     */
    if (type != FTString && DBFIsAttributeNULL(handle, record, field))
    {
	value = Py_None;
	Py_INCREF(value);
    }
    else
    {
	switch (type)
	{
	case FTString:
	{
	    const char * temp = DBFReadStringAttribute(handle, record, field);
	    if (temp)
	    {
		value = PyString_FromString(temp);
	    }
	    else
	    {
		PyErr_Format(PyExc_IOError,
			     "Can't read value for row %d column %d",
			     record, field);
		value = NULL;
	    }
	    break;
	}
	case FTInteger:
	    value = PyInt_FromLong(DBFReadIntegerAttribute(handle, record,
							   field));
	    break;
	case FTDouble:
	    value = PyFloat_FromDouble(DBFReadDoubleAttribute(handle, record,
							      field));
	    break;
	default:
	    PyErr_Format(PyExc_TypeError, "Invalid field data type %d",
			 type);
	    value = NULL;
	}
    }
    if (!value)
	return NULL;

    return value;
}    

/* the read_attribute method. Return the value of the given record and
 * field as a python object of the appropriate type.
 * 
 * In case of error, set a python exception and return NULL. Since that
 * value will be returned to the python interpreter as is, the
 * interpreter should recognize the exception.
 */

static PyObject *
DBFInfo_read_attribute(DBFInfo * handle, int record, int field)
{
    if (record < 0 || record >= DBFGetRecordCount(handle))
    {
	PyErr_Format(PyExc_ValueError,
		     "record index %d out of bounds (record count: %d)",
		     record, DBFGetRecordCount(handle));
	return NULL;
    }

    if (field < 0 || field >= DBFGetFieldCount(handle))
    {
	PyErr_Format(PyExc_ValueError,
		     "field index %d out of bounds (field count: %d)",
		     field, DBFGetFieldCount(handle));
	return NULL;
    }

    return do_read_attribute(handle, record, field, NULL);
}
    

/* the read_record method. Return the record record as a dictionary with
 * whose keys are the names of the fields, and their values as the
 * appropriate Python type.
 * 
 * In case of error, set a python exception and return NULL. Since that
 * value will be returned to the python interpreter as is, the
 * interpreter should recognize the exception.
 */

static PyObject *
DBFInfo_read_record(DBFInfo * handle, int record)
{
    int num_fields;
    int i;
    int type, width;
    char name[12];
    PyObject *dict;
    PyObject *value;

    if (record < 0 || record >= DBFGetRecordCount(handle))
    {
	PyErr_Format(PyExc_ValueError,
		     "record index %d out of bounds (record count: %d)",
		     record, DBFGetRecordCount(handle));
	return NULL;
    }

    dict = PyDict_New();
    if (!dict)
	return NULL;
	
    num_fields = DBFGetFieldCount(handle);
    for (i = 0; i < num_fields; i++)
    {
	value = do_read_attribute(handle, record, i, name);
	if (!value)
	    goto fail;

	PyDict_SetItemString(dict, name, value);
	Py_DECREF(value);
    }

    return dict;

 fail:
    Py_XDECREF(dict);
    return NULL;
}

/* the write_record method. Write the record record given wither as a
 * dictionary or a sequence (i.e. a list or a tuple).
 *
 * If it's a dictionary the keys must be the names of the fields and
 * their value must have a suitable type. Only the fields actually
 * contained in the dictionary are written. Fields for which there's no
 * item in the dict are not modified.
 *
 * If it's a sequence, all fields must be present in the right order.
 *
 * In case of error, set a python exception and return NULL. Since that
 * value will be returned to the python interpreter as is, the
 * interpreter should recognize the exception.
 *
 * The method is implemented with two c-functions, write_field to write
 * a single field and DBFInfo_write_record as the front-end.
 */


/* write a single field of a record. */
static int
write_field(DBFHandle handle, int record, int field, int type,
	    PyObject * value)
{
    char * string_value;
    int int_value;
    double double_value;

    if (value == Py_None)
    {
	if (!DBFWriteNULLAttribute(handle, record, field))
	{
	    PyErr_Format(PyExc_IOError,
			 "can't write NULL field %d of record %d",
			 field, record);
	    return 0;
	}
    }
    else
    {
	switch (type)
	{
	case FTString:
	    string_value = PyString_AsString(value);
	    if (!string_value)
		return 0;
	    if (!DBFWriteStringAttribute(handle, record, field, string_value))
	    {
		PyErr_Format(PyExc_IOError,
			     "can't write field %d of record %d",
			     field, record);
		return 0;
	    }
	    break;

	case FTInteger:
	    int_value = PyInt_AsLong(value);
	    if (int_value == -1 && PyErr_Occurred())
		return 0;
	    if (!DBFWriteIntegerAttribute(handle, record, field, int_value))
	    {
		PyErr_Format(PyExc_IOError,
			     "can't write field %d of record %d",
			     field, record);
		return 0;
	    }
	    break;

	case FTDouble:
	    double_value = PyFloat_AsDouble(value);
	    if (double_value == -1 && PyErr_Occurred())
		return 0;
	    if (!DBFWriteDoubleAttribute(handle, record, field, double_value))
	    {
		PyErr_Format(PyExc_IOError,
			     "can't write field %d of record %d",
			     field, record);
		return 0;
	    }
	    break;

	default:
	    PyErr_Format(PyExc_TypeError, "Invalid field data type %d", type);
	    return 0;
	}
    }

    return 1;
}

static
PyObject *
DBFInfo_write_record(DBFHandle handle, int record, PyObject *record_object)
{
    int num_fields;
    int i, length;
    int type, width;
    char name[12];
    PyObject * value = NULL;

    num_fields = DBFGetFieldCount(handle);

    /* We used to use PyMapping_Check to test whether record_object is a
     * dictionary like object instead of PySequence_Check to test
     * whether it's a sequence. Unfortunately in Python 2.3
     * PyMapping_Check returns true for lists and tuples too so the old
     * approach doesn't work anymore.
     */
    if (PySequence_Check(record_object))
    {
	/* It's a sequence object. Iterate through all items in the
	 * sequence and write them to the appropriate field.
	 */
	length = PySequence_Length(record_object);
	if (length != num_fields)
	{
	    PyErr_SetString(PyExc_TypeError,
			    "record must have one item for each field");
	    goto fail;
	}
	for (i = 0; i < length; i++)
	{
	    type = DBFGetFieldInfo(handle, i, name, &width, NULL); 
	    value = PySequence_GetItem(record_object, i);
	    if (value)
	    {
		if (!write_field(handle, record, i, type, value))
		    goto fail;
		Py_DECREF(value);
	    }
	    else
	    {
		goto fail;
	    }
	}
    }
    else
    {
	/* It's a dictionary-like object. Iterate over the names of the
         * known fields and write the corresponding item
	 */
	for (i = 0; i < num_fields; i++)
	{
	    type = DBFGetFieldInfo(handle, i, name, &width, NULL);

	    /* if the dictionary has the key name write that object to
	     * the appropriate field, other wise just clear the python
	     * exception and do nothing.
	     */
	    value = PyMapping_GetItemString(record_object, name);
	    if (value)
	    {
		if (!write_field(handle, record, i, type, value))
		    goto fail;
		Py_DECREF(value);
	    }
	    else
	    {
		PyErr_Clear();
	    }
	}
    }

    Py_INCREF(Py_None);
    return Py_None;

 fail:
    Py_XDECREF(value);
    return NULL;
}

static
void
DBFInfo_commit(DBFHandle handle)
{
#if HAVE_UPDATE_HEADER
    DBFUpdateHeader(handle);
#endif
}

static PyObject* l_output_helper(PyObject* target, PyObject* o) {
    PyObject*   o2;
    if (!target) {                   
        target = o;
    } else if (target == Py_None) {  
        Py_DECREF(Py_None);
        target = o;
    } else {                         
        if (!PyList_Check(target)) {
            o2 = target;
            target = PyList_New(0);
            PyList_Append(target, o2);
	    Py_XDECREF(o2);
        }
        PyList_Append(target,o);
	Py_XDECREF(o);
    }
    return target;
}

static PyObject* t_output_helper(PyObject* target, PyObject* o) {
    PyObject*   o2;
    PyObject*   o3;

    if (!target) {                   
        target = o;
    } else if (target == Py_None) {  
        Py_DECREF(Py_None);
        target = o;
    } else {                         
        if (!PyTuple_Check(target)) {
            o2 = target;
            target = PyTuple_New(1);
            PyTuple_SetItem(target, 0, o2);
        }
        o3 = PyTuple_New(1);            
        PyTuple_SetItem(o3, 0, o);      

        o2 = target;
        target = PySequence_Concat(o2, o3); 
        Py_DECREF(o2);                      
        Py_DECREF(o3);
    }
    return target;
}

#define  SWIG_MemoryError    1
#define  SWIG_IOError        2
#define  SWIG_RuntimeError   3
#define  SWIG_IndexError     4
#define  SWIG_TypeError      5
#define  SWIG_DivisionByZero 6
#define  SWIG_OverflowError  7
#define  SWIG_SyntaxError    8
#define  SWIG_ValueError     9
#define  SWIG_SystemError   10
#define  SWIG_UnknownError  99

static void _SWIG_exception(int code, char *msg) {
  switch(code) {
  case SWIG_MemoryError:
    PyErr_SetString(PyExc_MemoryError,msg);
    break;
  case SWIG_IOError:
    PyErr_SetString(PyExc_IOError,msg);
    break;
  case SWIG_RuntimeError:
    PyErr_SetString(PyExc_RuntimeError,msg);
    break;
  case SWIG_IndexError:
    PyErr_SetString(PyExc_IndexError,msg);
    break;
  case SWIG_TypeError:
    PyErr_SetString(PyExc_TypeError,msg);
    break;
  case SWIG_DivisionByZero:
    PyErr_SetString(PyExc_ZeroDivisionError,msg);
    break;
  case SWIG_OverflowError:
    PyErr_SetString(PyExc_OverflowError,msg);
    break;
  case SWIG_SyntaxError:
    PyErr_SetString(PyExc_SyntaxError,msg);
    break;
  case SWIG_ValueError:
    PyErr_SetString(PyExc_ValueError,msg);
    break;
  case SWIG_SystemError:
    PyErr_SetString(PyExc_SystemError,msg);
    break;
  default:
    PyErr_SetString(PyExc_RuntimeError,msg);
    break;
  }
}

#define SWIG_exception(a,b) { _SWIG_exception(a,b); return NULL; }

    typedef struct {
	DBFHandle handle;
    } DBFFile;

#define NOCHECK_delete_DBFFile
#define NOCHECK_DBFFile_close

    DBFFile * open_DBFFile(const char * file, const char * mode)
    {
	DBFFile * self = malloc(sizeof(DBFFile));
	if (self)
	    self->handle = DBFOpen(file, mode);
	return self;
    }

    DBFFile * create_DBFFile(const char * file)
    {
	DBFFile * self = malloc(sizeof(DBFFile));
	if (self)
	    self->handle = DBFCreate(file);
	return self;
    }
#ifdef __cplusplus
extern "C" {
#endif
static PyObject *_wrap_open(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    char *arg0 ;
    char *arg1 = "rb" ;
    DBFFile *result ;
    
    if(!PyArg_ParseTuple(args,"s|s:open",&arg0,&arg1)) return NULL;
    {
        result = (DBFFile *)open_DBFFile((char const *)arg0,(char const *)arg1);
        ;
        if (!result)
        {
            SWIG_exception(SWIG_MemoryError, "no memory");
        }
        else if (!result->handle)
        {
            SWIG_exception(SWIG_IOError, "open_DBFFile failed");
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_DBFFile);
    return resultobj;
}


static PyObject *_wrap_create(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    char *arg0 ;
    DBFFile *result ;
    
    if(!PyArg_ParseTuple(args,"s:create",&arg0)) return NULL;
    {
        result = (DBFFile *)create_DBFFile((char const *)arg0);
        ;
        if (!result)
        {
            SWIG_exception(SWIG_MemoryError, "no memory");
        }
        else if (!result->handle)
        {
            SWIG_exception(SWIG_IOError, "create_DBFFile failed");
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_DBFFile);
    return resultobj;
}


DBFFile * new_DBFFile(char const *file,char const *mode) {
    {
        DBFFile * self = malloc(sizeof(DBFFile));
        if (self)
        self->handle = DBFOpen(file, mode);
        return self;
    }
}


static PyObject *_wrap_new_DBFFile(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    char *arg0 ;
    char *arg1 = "rb" ;
    DBFFile *result ;
    
    if(!PyArg_ParseTuple(args,"s|s:new_DBFFile",&arg0,&arg1)) return NULL;
    {
        result = (DBFFile *)new_DBFFile((char const *)arg0,(char const *)arg1);
        ;
        if (!result)
        {
            SWIG_exception(SWIG_MemoryError, "no memory");
        }
        else if (!result->handle)
        {
            SWIG_exception(SWIG_IOError, "new_DBFFile failed");
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_DBFFile);
    return resultobj;
}


void  delete_DBFFile(DBFFile *self) {
    {
        if (self->handle)
        DBFClose(self->handle);
        free(self);
    }
}


static PyObject *_wrap_delete_DBFFile(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    DBFFile *arg0 ;
    PyObject * argo0 =0 ;
    
    if(!PyArg_ParseTuple(args,"O:delete_DBFFile",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_DBFFile,1)) == -1) return NULL;
    {
        #ifndef NOCHECK_delete_DBFFile
        if (!arg0 || !arg0->handle)
        SWIG_exception(SWIG_TypeError, "dbffile already closed");
        #endif
    }
    delete_DBFFile(arg0);
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


void  DBFFile_close(DBFFile *self) {
    {
        if (self->handle)
        DBFClose(self->handle);
        self->handle = NULL;
    }
}


static PyObject *_wrap_DBFFile_close(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    DBFFile *arg0 ;
    PyObject * argo0 =0 ;
    
    if(!PyArg_ParseTuple(args,"O:DBFFile_close",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_DBFFile,1)) == -1) return NULL;
    {
        #ifndef NOCHECK_DBFFile_close
        if (!arg0 || !arg0->handle)
        SWIG_exception(SWIG_TypeError, "dbffile already closed");
        #endif
    }
    DBFFile_close(arg0);
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


int  DBFFile_field_count(DBFFile *self) {
    {
        return DBFGetFieldCount(self->handle);
    }
}


static PyObject *_wrap_DBFFile_field_count(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    DBFFile *arg0 ;
    PyObject * argo0 =0 ;
    int result ;
    
    if(!PyArg_ParseTuple(args,"O:DBFFile_field_count",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_DBFFile,1)) == -1) return NULL;
    {
        #ifndef NOCHECK_DBFFile_field_count
        if (!arg0 || !arg0->handle)
        SWIG_exception(SWIG_TypeError, "dbffile already closed");
        #endif
    }
    result = (int )DBFFile_field_count(arg0);
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


int  DBFFile_record_count(DBFFile *self) {
    {
        return DBFGetRecordCount(self->handle);
    }
}


static PyObject *_wrap_DBFFile_record_count(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    DBFFile *arg0 ;
    PyObject * argo0 =0 ;
    int result ;
    
    if(!PyArg_ParseTuple(args,"O:DBFFile_record_count",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_DBFFile,1)) == -1) return NULL;
    {
        #ifndef NOCHECK_DBFFile_record_count
        if (!arg0 || !arg0->handle)
        SWIG_exception(SWIG_TypeError, "dbffile already closed");
        #endif
    }
    result = (int )DBFFile_record_count(arg0);
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


int  DBFFile_field_info(DBFFile *self,int iField,char *fieldname_out,int *output_width,int *output_decimals) {
    {
        return DBFGetFieldInfo(self->handle, iField, fieldname_out,
        output_width, output_decimals);
    }
}


static PyObject *_wrap_DBFFile_field_info(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    DBFFile *arg0 ;
    int arg1 ;
    char *arg2 ;
    int *arg3 ;
    int *arg4 ;
    char temp[12] ;
    int temp0 ;
    int temp1 ;
    PyObject * argo0 =0 ;
    int result ;
    
    {
        arg2 = temp;
    }
    {
        arg3 = &temp0;
    }
    {
        arg4 = &temp1;
    }
    if(!PyArg_ParseTuple(args,"Oi:DBFFile_field_info",&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_DBFFile,1)) == -1) return NULL;
    {
        #ifndef NOCHECK_DBFFile_field_info
        if (!arg0 || !arg0->handle)
        SWIG_exception(SWIG_TypeError, "dbffile already closed");
        #endif
    }
    result = (int )DBFFile_field_info(arg0,arg1,arg2,arg3,arg4);
    resultobj = PyInt_FromLong((long)result);
    {
        PyObject * string = PyString_FromString(arg2);
        resultobj = t_output_helper(resultobj,string);
    }
    {
        PyObject *o;
        o = PyInt_FromLong((long) (*arg3));
        resultobj = t_output_helper(resultobj, o);
    }
    {
        PyObject *o;
        o = PyInt_FromLong((long) (*arg4));
        resultobj = t_output_helper(resultobj, o);
    }
    return resultobj;
}


PyObject * DBFFile_read_record(DBFFile *self,int record) {
    {
        return DBFInfo_read_record(self->handle, record);
    }
}


static PyObject *_wrap_DBFFile_read_record(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    DBFFile *arg0 ;
    int arg1 ;
    PyObject * argo0 =0 ;
    PyObject *result ;
    
    if(!PyArg_ParseTuple(args,"Oi:DBFFile_read_record",&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_DBFFile,1)) == -1) return NULL;
    {
        #ifndef NOCHECK_DBFFile_read_record
        if (!arg0 || !arg0->handle)
        SWIG_exception(SWIG_TypeError, "dbffile already closed");
        #endif
    }
    result = (PyObject *)DBFFile_read_record(arg0,arg1);
    {
        resultobj = result;
    }
    return resultobj;
}


PyObject * DBFFile_read_attribute(DBFFile *self,int record,int field) {
    {
        return DBFInfo_read_attribute(self->handle, record, field);
    }
}


static PyObject *_wrap_DBFFile_read_attribute(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    DBFFile *arg0 ;
    int arg1 ;
    int arg2 ;
    PyObject * argo0 =0 ;
    PyObject *result ;
    
    if(!PyArg_ParseTuple(args,"Oii:DBFFile_read_attribute",&argo0,&arg1,&arg2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_DBFFile,1)) == -1) return NULL;
    {
        #ifndef NOCHECK_DBFFile_read_attribute
        if (!arg0 || !arg0->handle)
        SWIG_exception(SWIG_TypeError, "dbffile already closed");
        #endif
    }
    result = (PyObject *)DBFFile_read_attribute(arg0,arg1,arg2);
    {
        resultobj = result;
    }
    return resultobj;
}


int  DBFFile_add_field(DBFFile *self,char const *pszFieldName,DBFFieldType eType,int nWidth,int nDecimals) {
    {
        return DBFAddField(self->handle, pszFieldName, eType, nWidth,
        nDecimals);
    }
}


static PyObject *_wrap_DBFFile_add_field(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    DBFFile *arg0 ;
    char *arg1 ;
    int arg2 ;
    int arg3 ;
    int arg4 ;
    PyObject * argo0 =0 ;
    int result ;
    
    if(!PyArg_ParseTuple(args,"Osiii:DBFFile_add_field",&argo0,&arg1,&arg2,&arg3,&arg4)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_DBFFile,1)) == -1) return NULL;
    {
        #ifndef NOCHECK_DBFFile_add_field
        if (!arg0 || !arg0->handle)
        SWIG_exception(SWIG_TypeError, "dbffile already closed");
        #endif
    }
    {
        result = (int )DBFFile_add_field(arg0,(char const *)arg1,(DBFFieldType )arg2,arg3,arg4);
        ;
        if (result < 0)
        {
            SWIG_exception(SWIG_RuntimeError, "add_field failed");
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


PyObject * DBFFile_write_record(DBFFile *self,int record,PyObject *dict_or_sequence) {
    {
        return DBFInfo_write_record(self->handle, record,
        dict_or_sequence);
    }
}


static PyObject *_wrap_DBFFile_write_record(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    DBFFile *arg0 ;
    int arg1 ;
    PyObject *arg2 ;
    PyObject * argo0 =0 ;
    PyObject * obj2  = 0 ;
    PyObject *result ;
    
    if(!PyArg_ParseTuple(args,"OiO:DBFFile_write_record",&argo0,&arg1,&obj2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_DBFFile,1)) == -1) return NULL;
    {
        arg2 = obj2;
    }
    {
        #ifndef NOCHECK_DBFFile_write_record
        if (!arg0 || !arg0->handle)
        SWIG_exception(SWIG_TypeError, "dbffile already closed");
        #endif
    }
    result = (PyObject *)DBFFile_write_record(arg0,arg1,arg2);
    {
        resultobj = result;
    }
    return resultobj;
}


void  DBFFile_commit(DBFFile *self) {
    {
        DBFInfo_commit(self->handle);
    }
}


static PyObject *_wrap_DBFFile_commit(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    DBFFile *arg0 ;
    PyObject * argo0 =0 ;
    
    if(!PyArg_ParseTuple(args,"O:DBFFile_commit",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_DBFFile,1)) == -1) return NULL;
    {
        #ifndef NOCHECK_DBFFile_commit
        if (!arg0 || !arg0->handle)
        SWIG_exception(SWIG_TypeError, "dbffile already closed");
        #endif
    }
    DBFFile_commit(arg0);
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyMethodDef dbflibcMethods[] = {
	 { "open", _wrap_open, METH_VARARGS },
	 { "create", _wrap_create, METH_VARARGS },
	 { "new_DBFFile", _wrap_new_DBFFile, METH_VARARGS },
	 { "delete_DBFFile", _wrap_delete_DBFFile, METH_VARARGS },
	 { "DBFFile_close", _wrap_DBFFile_close, METH_VARARGS },
	 { "DBFFile_field_count", _wrap_DBFFile_field_count, METH_VARARGS },
	 { "DBFFile_record_count", _wrap_DBFFile_record_count, METH_VARARGS },
	 { "DBFFile_field_info", _wrap_DBFFile_field_info, METH_VARARGS },
	 { "DBFFile_read_record", _wrap_DBFFile_read_record, METH_VARARGS },
	 { "DBFFile_read_attribute", _wrap_DBFFile_read_attribute, METH_VARARGS },
	 { "DBFFile_add_field", _wrap_DBFFile_add_field, METH_VARARGS },
	 { "DBFFile_write_record", _wrap_DBFFile_write_record, METH_VARARGS },
	 { "DBFFile_commit", _wrap_DBFFile_commit, METH_VARARGS },
	 { NULL, NULL }
};

#ifdef __cplusplus
}
#endif

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static swig_type_info _swigt__p_DBFFile[] = {{"_p_DBFFile", 0, "DBFFile *"},{"_p_DBFFile"},{0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_DBFFile, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

static swig_const_info swig_const_table[] = {
    { SWIG_PY_INT,     "FTString", (long) FTString, 0, 0, 0},
    { SWIG_PY_INT,     "FTInteger", (long) FTInteger, 0, 0, 0},
    { SWIG_PY_INT,     "FTDouble", (long) FTDouble, 0, 0, 0},
    { SWIG_PY_INT,     "FTInvalid", (long) FTInvalid, 0, 0, 0},
    { SWIG_PY_INT,     "_have_commit", (long) HAVE_UPDATE_HEADER, 0, 0, 0},
{0}};

static PyObject *SWIG_globals;
#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT(void) initdbflibc(void) {
    PyObject *m, *d;
    int i;
    SWIG_globals = SWIG_newvarlink();
    m = Py_InitModule("dbflibc", dbflibcMethods);
    d = PyModule_GetDict(m);
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
    }
    SWIG_InstallConstants(d,swig_const_table);

#   if PY_VERSION_HEX >=0x02040000 
    /* because we are in a python module now, we can give out
     * pointers to python's locale agonistic function 
     * XXX this clearly is a hack
     */
    DBFSetatof_function(&PyOS_ascii_atof);
#   endif

}

