/****************************************************************************
 *
 * This file is part of the ViSP software.
 * Copyright (C) 2005 - 2017 by Inria. All rights reserved.
 *
 * This software is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file LICENSE.txt at the root directory of this source
 * distribution for additional information about the GNU GPL.
 *
 * For using ViSP with software that can not be combined with the GNU
 * GPL, please contact Inria about acquiring a ViSP Professional
 * Edition License.
 *
 * See http://visp.inria.fr for more information.
 *
 * This software was developed at:
 * Inria Rennes - Bretagne Atlantique
 * Campus Universitaire de Beaulieu
 * 35042 Rennes Cedex
 * France
 *
 * If you have questions regarding the use of this file, please contact
 * Inria at visp@inria.fr
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Description:
 * Compute the pose of a 3D object using the RANSAC method.
 *
 * Author:
 * Souriya Trinh
 *
 *****************************************************************************/

#include <algorithm>
#include <iomanip>
#include <map>
#include <sstream>
#include <visp3/core/vpGaussRand.h>
#include <visp3/core/vpHomogeneousMatrix.h>
#include <visp3/core/vpIoTools.h>
#include <visp3/core/vpMath.h>
#include <visp3/core/vpPoint.h>
#include <visp3/vision/vpPose.h>

// Stanford Bunny Model points
const std::string file_content = "0.038043 0.109755 0.016169 "
                                 "-0.080459 0.135827 0.050032 "
                                 "-0.080437 0.137229 0.049095 "
                                 "-0.039537 0.165252 0.003107 "
                                 "-0.029517 0.175738 -0.005254 "
                                 "-0.076590 0.172837 -0.038783 "
                                 "0.037067 0.109719 0.023178 "
                                 "0.002482 0.038559 0.046163 "
                                 "-0.071500 0.163630 -0.013838 "
                                 "-0.063129 0.154030 -0.010769 "
                                 "0.038061 0.108343 0.022172 "
                                 "-0.038632 0.167867 0.002788 "
                                 "0.001485 0.039988 0.046431 "
                                 "0.002487 0.039963 0.046169 "
                                 "-0.076694 0.171427 -0.035893 "
                                 "-0.037523 0.124042 0.025944 "
                                 "-0.057469 0.041348 0.046193 "
                                 "-0.044485 0.041114 0.043653 "
                                 "-0.043493 0.041078 0.043361 "
                                 "-0.062047 0.176838 -0.060831 "
                                 "-0.022629 0.157855 -0.004227 "
                                 "-0.058497 0.042632 0.044737 "
                                 "-0.043500 0.042437 0.043101 "
                                 "-0.038476 0.042327 0.041891 "
                                 "-0.021510 0.043531 0.053479 "
                                 "-0.001517 0.042851 0.046801 "
                                 "-0.035500 0.174151 -0.001806 "
                                 "0.043233 0.089594 -0.006456 "
                                 "-0.058494 0.043959 0.043965 "
                                 "-0.052515 0.043997 0.044898 "
                                 "-0.021503 0.044884 0.053016 "
                                 "-0.019514 0.044832 0.052531 "
                                 "-0.026748 0.109750 0.038619 "
                                 "-0.080524 0.148418 0.038173 "
                                 "-0.041486 0.169687 0.001623 "
                                 "-0.063449 0.097112 -0.017938 "
                                 "-0.054487 0.045217 0.043831 "
                                 "-0.053511 0.045215 0.043764 "
                                 "-0.037512 0.045091 0.040752 "
                                 "-0.088156 0.151596 0.022886 "
                                 "-0.025891 0.048891 0.049042 "
                                 "-0.071506 0.148353 0.040851 "
                                 "0.027212 0.088765 -0.022232 "
                                 "-0.054494 0.046553 0.042265 "
                                 "-0.058656 0.152453 0.032611 "
                                 "-0.070511 0.148356 0.040726 "
                                 "-0.023471 0.183379 -0.010712 "
                                 "-0.072524 0.137240 0.048963 "
                                 "0.039501 0.046973 0.031597 "
                                 "0.045346 0.082603 0.023076 "
                                 "-0.061964 0.147832 -0.004318 "
                                 "-0.034505 0.049198 0.039001 "
                                 "-0.027492 0.049767 0.045472 "
                                 "-0.078513 0.145668 0.042746 "
                                 "-0.046493 0.165223 0.004593 "
                                 "0.032495 0.048497 0.032163 "
                                 "0.041518 0.048439 0.032146 "
                                 "-0.064113 0.155183 -0.040605 "
                                 "-0.044898 0.168579 0.001542 "
                                 "-0.051381 0.050043 0.034731 "
                                 "-0.032509 0.050660 0.038421 "
                                 "0.006619 0.047417 0.050356 "
                                 "-0.015062 0.160937 -0.011420 "
                                 "-0.080526 0.149910 0.035970 "
                                 "-0.040710 0.050423 0.039629 "
                                 "-0.031463 0.051903 0.037377 "
                                 "-0.006309 0.051457 0.052597 "
                                 "-0.056444 0.115317 0.036137 "
                                 "-0.063698 0.164648 -0.028601 "
                                 "0.034501 0.051352 0.032162 "
                                 "-0.083451 0.149763 0.033502 "
                                 "-0.064494 0.149793 0.037510 "
                                 "-0.063485 0.149796 0.037152 "
                                 "0.031455 0.113206 0.029881 "
                                 "-0.045515 0.053319 0.038154 "
                                 "0.010509 0.054658 0.052359 "
                                 "-0.057480 0.115365 0.036701 "
                                 "0.037597 0.088359 -0.014764 "
                                 "0.035531 0.052720 0.031990 "
                                 "-0.064662 0.151974 0.036264 "
                                 "-0.018605 0.049922 0.047107 "
                                 "-0.000094 0.052014 0.054278 "
                                 "-0.075359 0.113961 -0.005684 "
                                 "0.036518 0.054117 0.031704 "
                                 "-0.013502 0.057389 0.051750 "
                                 "0.009410 0.060149 0.052895 "
                                 "-0.018488 0.122208 0.030928 "
                                 "0.038169 0.109765 0.014166 "
                                 "-0.042948 0.170625 -0.000616 "
                                 "-0.053583 0.055075 0.011440 "
                                 "-0.017474 0.058729 0.050990 "
                                 "-0.013551 0.058830 0.052544 "
                                 "0.000322 0.058135 0.054484 "
                                 "0.008500 0.058924 0.053176 "
                                 "-0.069486 0.116115 0.051835 "
                                 "-0.052433 0.115217 0.034103 "
                                 "-0.085941 0.125175 0.049068 "
                                 "-0.072600 0.145757 -0.016854 "
                                 "-0.021451 0.184864 -0.013038 "
                                 "-0.027746 0.064856 0.037498 "
                                 "-0.017457 0.060172 0.051453 "
                                 "-0.014477 0.060305 0.052805 "
                                 "-0.013472 0.060385 0.053624 "
                                 "0.010494 0.118230 0.036879 "
                                 "-0.025456 0.120601 0.028847 "
                                 "-0.024489 0.120706 0.029404 "
                                 "-0.051475 0.115278 0.033811 "
                                 "-0.023488 0.122057 0.027634 "
                                 "0.038511 0.058329 0.031423 "
                                 "-0.076502 0.121776 0.052772 "
                                 "-0.014480 0.061748 0.053510 "
                                 "0.003858 0.062044 0.056777 "
                                 "0.011472 0.118200 0.036572 "
                                 "-0.077835 0.145715 0.043808 "
                                 "0.039532 0.059677 0.030697 "
                                 "-0.054472 0.060781 0.026950 "
                                 "-0.048101 0.135891 0.016805 "
                                 "-0.014501 0.063146 0.053679 "
                                 "-0.005881 0.062411 0.056478 "
                                 "-0.062841 0.144409 -0.007635 "
                                 "-0.020619 0.186125 -0.015175 "
                                 "-0.057485 0.062333 0.028342 "
                                 "-0.047781 0.063839 0.037342 "
                                 "-0.069510 0.148387 0.040505 "
                                 "0.011484 0.123198 0.034270 "
                                 "-0.009507 0.125161 0.031090 "
                                 "-0.062211 0.147546 -0.005052 "
                                 "-0.053516 0.064085 0.033078 "
                                 "-0.026557 0.064650 0.039328 "
                                 "0.046038 0.067997 0.025283 "
                                 "0.009517 0.066006 0.054677 "
                                 "0.011502 0.119616 0.035894 "
                                 "-0.047437 0.120726 0.028345 "
                                 "-0.011482 0.125053 0.030655 "
                                 "0.051514 0.063765 0.028901 "
                                 "-0.044486 0.066153 0.040137 "
                                 "-0.012589 0.069082 0.054415 "
                                 "0.010512 0.067367 0.054298 "
                                 "-0.048480 0.117974 0.031095 "
                                 "-0.049455 0.118007 0.031644 "
                                 "-0.091160 0.146144 0.025161 "
                                 "0.042563 0.065071 0.027562 "
                                 "-0.005859 0.087537 -0.037176 "
                                 "-0.044518 0.067563 0.040463 "
                                 "0.000030 0.068579 0.056492 "
                                 "0.010524 0.068777 0.054575 "
                                 "-0.047469 0.117985 0.030630 "
                                 "-0.081528 0.148400 0.037410 "
                                 "-0.029791 0.154227 -0.004672 "
                                 "-0.016743 0.123139 0.030848 "
                                 "0.053516 0.066419 0.026864 "
                                 "-0.071191 0.155859 0.001279 "
                                 "-0.036068 0.156277 -0.010490 "
                                 "0.042534 0.067858 0.027368 "
                                 "0.044646 0.069351 0.024242 "
                                 "0.047498 0.067780 0.026220 "
                                 "-0.047725 0.135673 0.014006 "
                                 "-0.065141 0.159482 -0.056501 "
                                 "-0.046491 0.070446 0.041037 "
                                 "-0.045986 0.073503 0.042256 "
                                 "-0.038661 0.063179 0.041795 "
                                 "-0.003043 0.073778 0.059461 "
                                 "0.009520 0.071626 0.055408 "
                                 "0.036826 0.109713 0.024182 "
                                 "0.043569 0.069164 0.025997 "
                                 "0.049500 0.069124 0.025332 "
                                 "0.051511 0.069144 0.025235 "
                                 "-0.069372 0.180628 -0.057909 "
                                 "-0.072540 0.162229 -0.011353 "
                                 "-0.020454 0.184888 -0.013987 "
                                 "-0.048492 0.071808 0.040533 "
                                 "-0.009124 0.125328 0.030976 "
                                 "-0.017522 0.187118 -0.019415 "
                                 "-0.018462 0.072978 0.054580 "
                                 "-0.080508 0.121673 0.049920 "
                                 "0.043584 0.070558 0.025859 "
                                 "-0.011119 0.163582 -0.018751 "
                                 "-0.019434 0.184905 -0.015328 "
                                 "-0.027457 0.073402 0.042686 "
                                 "-0.031497 0.117989 0.030856 "
                                 "-0.019943 0.187176 -0.015950 "
                                 "-0.091048 0.113254 0.017639 "
                                 "-0.089443 0.151569 0.016470 "
                                 "0.006504 0.123782 0.033960 "
                                 "-0.072537 0.138625 0.048318 "
                                 "-0.000692 0.100255 0.047827 "
                                 "-0.076123 0.163992 -0.018367 "
                                 "-0.008085 0.125292 0.031359 "
                                 "-0.020456 0.077205 0.054931 "
                                 "-0.011270 0.120275 0.036868 "
                                 "-0.068487 0.120374 0.052788 "
                                 "-0.036504 0.168234 0.000586 "
                                 "-0.046713 0.131987 0.005569 "
                                 "-0.064501 0.077478 0.041325 "
                                 "-0.029667 0.077446 0.041883 "
                                 "0.009089 0.080660 0.054966 "
                                 "-0.079510 0.149797 0.036758 "
                                 "-0.017682 0.082305 0.057622 "
                                 "-0.071505 0.147007 0.042162 "
                                 "-0.082501 0.107588 0.027351 "
                                 "-0.078078 0.154685 0.029078 "
                                 "-0.031275 0.118165 0.030639 "
                                 "-0.050393 0.085761 0.046102 "
                                 "-0.053471 0.115278 0.034303 "
                                 "0.007481 0.115492 0.039253 "
                                 "-0.075260 0.127230 0.053502 "
                                 "-0.042039 0.084825 0.042519 "
                                 "-0.007645 0.079109 0.058188 "
                                 "0.018475 0.082463 0.051596 "
                                 "-0.074281 0.117286 0.053631 "
                                 "-0.065353 0.085654 0.044968 "
                                 "-0.059945 0.074585 0.041788 "
                                 "-0.037174 0.081950 0.043756 "
                                 "-0.068377 0.176522 -0.058018 "
                                 "0.017494 0.083857 0.051403 "
                                 "0.018494 0.083833 0.051046 "
                                 "0.019476 0.083796 0.050749 "
                                 "-0.047453 0.119349 0.029360 "
                                 "-0.003971 0.124981 0.033251 "
                                 "-0.025836 0.094514 -0.026615 "
                                 "0.017485 0.085207 0.050786 "
                                 "0.020474 0.085138 0.050012 "
                                 "-0.074496 0.130260 0.052409 "
                                 "-0.026922 0.181455 -0.007884 "
                                 "-0.032593 0.177828 -0.005142 "
                                 "-0.030548 0.087232 0.043284 "
                                 "-0.020478 0.086949 0.055949 "
                                 "-0.012103 0.092198 0.056667 "
                                 "0.008495 0.086943 0.055839 "
                                 "-0.092808 0.120209 0.041284 "
                                 "0.021487 0.086500 0.049224 "
                                 "-0.023441 0.181825 -0.010570 "
                                 "-0.036983 0.092657 0.044193 "
                                 "0.005296 0.086140 0.057126 "
                                 "0.009509 0.088290 0.055046 "
                                 "0.018490 0.087902 0.049248 "
                                 "0.022460 0.087857 0.048776 "
                                 "0.037946 0.109770 0.017170 "
                                 "-0.058473 0.115363 0.036971 "
                                 "0.040458 0.097140 0.028174 "
                                 "0.039909 0.107011 0.006164 "
                                 "-0.071514 0.088744 0.041619 "
                                 "0.011490 0.089612 0.054036 "
                                 "-0.010050 0.166619 -0.017705 "
                                 "0.019647 0.086817 0.049574 "
                                 "0.022481 0.089252 0.048474 "
                                 "-0.018485 0.091067 0.055002 "
                                 "-0.038692 0.115422 0.033305 "
                                 "-0.069491 0.124597 0.052657 "
                                 "-0.004492 0.123763 0.034322 "
                                 "-0.070533 0.144185 0.044275 "
                                 "-0.070146 0.089763 0.042620 "
                                 "0.012498 0.092313 0.052383 "
                                 "-0.018064 0.122407 0.030816 "
                                 "-0.018232 0.187056 -0.018294 "
                                 "-0.072494 0.092871 0.041339 "
                                 "0.017475 0.093454 0.048154 "
                                 "-0.018226 0.117876 0.036486 "
                                 "-0.059685 0.147446 0.036516 "
                                 "-0.071526 0.094419 0.041653 "
                                 "-0.050053 0.096180 0.044423 "
                                 "0.013460 0.094917 0.050136 "
                                 "-0.072540 0.095957 0.041270 "
                                 "-0.056884 0.092762 0.045348 "
                                 "-0.040294 0.098952 0.041786 "
                                 "-0.024503 0.096017 0.044275 "
                                 "-0.014473 0.096429 0.052209 "
                                 "-0.013468 0.096423 0.052316 "
                                 "0.022488 0.096164 0.046634 "
                                 "-0.044495 0.120650 0.027643 "
                                 "-0.073439 0.148627 -0.029805 "
                                 "0.006439 0.132232 0.014596 "
                                 "-0.080457 0.138622 0.048117 "
                                 "-0.027509 0.181505 -0.008742 "
                                 "-0.071519 0.097212 0.040997 "
                                 "-0.053895 0.097200 0.043345 "
                                 "-0.024482 0.097451 0.044460 "
                                 "-0.023481 0.097449 0.044821 "
                                 "-0.009483 0.097835 0.051868 "
                                 "-0.002497 0.097829 0.052428 "
                                 "-0.000511 0.097839 0.052433 "
                                 "0.001458 0.097737 0.051907 "
                                 "-0.020496 0.098841 0.044481 "
                                 "-0.013463 0.098956 0.047529 "
                                 "0.023359 0.095899 0.046777 "
                                 "0.020477 0.098952 0.046347 "
                                 "-0.011316 0.129221 0.002910 "
                                 "-0.079478 0.142827 0.045105 "
                                 "-0.046949 0.093514 -0.021920 "
                                 "-0.070498 0.099990 0.040323 "
                                 "-0.059835 0.102266 0.042689 "
                                 "-0.029833 0.101135 0.043080 "
                                 "-0.019498 0.100240 0.044034 "
                                 "-0.016507 0.100263 0.043963 "
                                 "-0.015502 0.100285 0.044225 "
                                 "-0.012572 0.100502 0.044597 "
                                 "0.001493 0.100277 0.046986 "
                                 "0.011888 0.102476 0.047452 "
                                 "0.019476 0.100345 0.046212 "
                                 "-0.046466 0.167133 0.003131 "
                                 "-0.070478 0.114632 0.051042 "
                                 "-0.065862 0.153866 -0.001908 "
                                 "-0.016492 0.101629 0.043954 "
                                 "-0.033748 0.119587 0.029726 "
                                 "-0.001496 0.101631 0.044188 "
                                 "-0.074502 0.116130 0.052068 "
                                 "-0.024607 0.157782 -0.002504 "
                                 "-0.074558 0.102629 0.036985 "
                                 "-0.044387 0.106839 0.040714 "
                                 "-0.018030 0.106099 0.042558 "
                                 "-0.014500 0.103011 0.043250 "
                                 "-0.012495 0.103038 0.043735 "
                                 "-0.006500 0.103045 0.043680 "
                                 "-0.001500 0.103045 0.044056 "
                                 "0.035089 0.111006 -0.001837 "
                                 "-0.068495 0.121776 0.052768 "
                                 "-0.046574 0.153815 0.009349 "
                                 "-0.074536 0.104026 0.036830 "
                                 "-0.047007 0.099425 0.042698 "
                                 "-0.001513 0.104469 0.044133 "
                                 "-0.042032 0.171559 -0.001711 "
                                 "-0.008282 0.101652 0.043830 "
                                 "-0.006486 0.108283 0.043970 "
                                 "-0.001528 0.105863 0.043996 "
                                 "0.024524 0.105615 0.039234 "
                                 "0.021424 0.121505 0.031182 "
                                 "0.017255 0.109608 0.039746 "
                                 "-0.035520 0.169730 -0.000115 "
                                 "0.024505 0.108393 0.038558 "
                                 "-0.029469 0.178820 -0.005543 "
                                 "-0.000500 0.100727 0.046395 "
                                 "-0.069489 0.109539 0.038095 "
                                 "-0.068505 0.109678 0.037959 "
                                 "-0.066496 0.109745 0.037770 "
                                 "0.005485 0.109984 0.041677 "
                                 "0.023135 0.125159 0.021213 "
                                 "-0.040910 0.173193 -0.005611 "
                                 "-0.032536 0.172727 -0.002702 "
                                 "0.006478 0.111357 0.041027 "
                                 "0.022491 0.111137 0.037371 "
                                 "-0.050136 0.110464 0.037566 "
                                 "-0.019238 0.036205 0.052830 "
                                 "-0.005178 0.036734 0.048450 "
                                 "-0.004153 0.036789 0.048168 "
                                 "-0.031089 0.159271 -0.013062 "
                                 "0.017745 0.037928 0.042910 "
                                 "-0.073907 0.171564 -0.047586 "
                                 "-0.018941 0.037618 0.053049 "
                                 "0.007356 0.038818 0.045452 "
                                 "0.018182 0.036268 0.042512 "
                                 "-0.053475 0.036001 0.046489 "
                                 "-0.050165 0.036131 0.046172 "
                                 "-0.043194 0.036383 0.044045 "
                                 "0.022179 0.040783 0.040543 "
                                 "0.018183 0.102054 0.045770 "
                                 "0.026779 0.040277 0.031351 "
                                 "-0.054330 0.097111 -0.022408 "
                                 "-0.000216 0.041170 0.046762 "
                                 "0.000822 0.041223 0.046540 "
                                 "0.025055 0.042091 0.037664 "
                                 "0.026269 0.039553 0.030992 "
                                 "-0.029066 0.093469 -0.024545 "
                                 "-0.039288 0.044575 0.041301 "
                                 "-0.006058 0.045881 0.047354 "
                                 "-0.066457 0.110304 0.037295 "
                                 "0.011942 0.123166 0.033243 "
                                 "-0.022142 0.043052 0.053661 "
                                 "-0.021404 0.045562 0.053215 "
                                 "-0.086889 0.102318 0.023370 "
                                 "-0.015871 0.161111 -0.009045 "
                                 "0.017650 0.043039 0.044185 "
                                 "0.041315 0.045195 0.029602 "
                                 "-0.040635 0.159922 0.002471 "
                                 "-0.020287 0.044518 0.052893 "
                                 "-0.012904 0.181603 -0.024044 "
                                 "0.011322 0.045022 0.044806 "
                                 "0.040105 0.046687 0.031387 "
                                 "0.043756 0.046763 0.029636 "
                                 "0.049174 0.044307 0.021629 "
                                 "0.050879 0.046558 0.022316 "
                                 "0.051380 0.046479 0.021262 "
                                 "-0.054311 0.149562 0.026707 "
                                 "-0.047190 0.156504 0.008879 "
                                 "-0.018702 0.045934 0.051674 "
                                 "-0.055378 0.151032 0.028750 "
                                 "-0.013113 0.184484 -0.026054 "
                                 "0.028021 0.046282 0.036458 "
                                 "0.017700 0.103348 0.045066 "
                                 "-0.067150 0.145376 0.041641 "
                                 "-0.032860 0.153633 -0.000344 "
                                 "0.009909 0.048971 0.049252 "
                                 "0.010676 0.048959 0.048584 "
                                 "0.033645 0.049093 0.031488 "
                                 "0.043084 0.049674 0.032233 "
                                 "0.054174 0.049532 0.021869 "
                                 "0.036990 0.111103 0.004167 "
                                 "-0.011129 0.182158 -0.027227 "
                                 "-0.023928 0.181600 -0.010098 "
                                 "0.055409 0.050963 0.021892 "
                                 "-0.054071 0.123768 0.038080 "
                                 "-0.016353 0.160230 -0.010916 "
                                 "0.015237 0.121915 0.032797 "
                                 "-0.071652 0.139715 0.047438 "
                                 "0.020741 0.055550 0.048100 "
                                 "0.023003 0.049323 0.039928 "
                                 "-0.023553 0.156826 -0.005180 "
                                 "-0.049505 0.050280 0.036331 "
                                 "-0.029135 0.177171 -0.005342 "
                                 "0.035495 0.103128 -0.011159 "
                                 "0.059989 0.062227 0.021516 "
                                 "0.012111 0.116449 0.037015 "
                                 "-0.054345 0.151005 0.026686 "
                                 "0.013667 0.055693 0.050689 "
                                 "0.043020 0.049120 0.032996 "
                                 "0.053744 0.054858 0.027754 "
                                 "-0.062742 0.148221 0.037477 "
                                 "-0.049178 0.130401 0.030288 "
                                 "0.039228 0.108354 0.009166 "
                                 "0.010869 0.057643 0.052478 "
                                 "0.058756 0.057992 0.021536 "
                                 "-0.055127 0.047834 0.040050 "
                                 "-0.072139 0.128420 0.051978 "
                                 "-0.067933 0.145349 0.042265 "
                                 "0.051151 0.060858 0.029927 "
                                 "0.039303 0.101950 0.027071 "
                                 "-0.028849 0.162315 -0.003816 "
                                 "-0.071123 0.141136 0.046452 "
                                 "-0.036101 0.158265 0.004249 "
                                 "-0.069556 0.114278 0.050291 "
                                 "-0.089109 0.099057 0.008227 "
                                 "0.026136 0.060229 0.044245 "
                                 "0.040315 0.061632 0.030023 "
                                 "-0.070208 0.141157 0.046016 "
                                 "-0.015086 0.162585 -0.009690 "
                                 "-0.026913 0.180109 -0.007400 "
                                 "-0.001352 0.101336 0.044402 "
                                 "0.006923 0.063037 0.055588 "
                                 "0.007933 0.063074 0.055296 "
                                 "0.034320 0.060597 0.039225 "
                                 "0.035670 0.108162 -0.004821 "
                                 "0.019494 0.107309 0.040648 "
                                 "0.038763 0.104620 0.026268 "
                                 "-0.068821 0.145351 0.042741 "
                                 "-0.053805 0.048637 0.038267 "
                                 "-0.014344 0.162546 -0.010432 "
                                 "0.039538 0.100622 0.027388 "
                                 "-0.013982 0.178957 -0.021269 "
                                 "0.008946 0.064444 0.055029 "
                                 "0.012129 0.065567 0.053747 "
                                 "0.020511 0.065463 0.048451 "
                                 "0.052356 0.064799 0.028141 "
                                 "0.053298 0.064822 0.027758 "
                                 "-0.052653 0.152155 0.015019 "
                                 "0.036409 0.085446 -0.016706 "
                                 "0.028693 0.111728 0.034550 "
                                 "0.002438 0.114145 0.041742 "
                                 "-0.030297 0.121635 -0.007023 "
                                 "0.008263 0.110977 0.040210 "
                                 "0.037500 0.107296 0.026215 "
                                 "0.039845 0.059964 0.030392 "
                                 "-0.063695 0.167813 -0.041594 "
                                 "0.051687 0.064527 0.029555 "
                                 "0.027852 0.115393 0.031660 "
                                 "0.009143 0.112364 0.039751 "
                                 "0.017991 0.120614 0.033226 "
                                 "-0.069120 0.118603 0.052746 "
                                 "0.039512 0.070945 0.033551 "
                                 "0.056979 0.068693 0.022604 "
                                 "0.057617 0.068678 0.021770 "
                                 "0.058779 0.068629 0.019916 "
                                 "0.016910 0.120624 0.033430 "
                                 "-0.049644 0.132456 0.028190 "
                                 "-0.069785 0.145343 0.043102 "
                                 "-0.010211 0.168384 -0.018420 "
                                 "-0.010519 0.165484 -0.017015 "
                                 "-0.013977 0.164028 -0.011589 "
                                 "0.007651 0.075327 0.056504 "
                                 "-0.007476 0.101243 0.044380 "
                                 "-0.062397 0.162983 -0.056654 "
                                 "-0.010634 0.174261 -0.022600 "
                                 "0.029870 0.114081 0.031047 "
                                 "0.026908 0.070176 0.043296 "
                                 "0.032967 0.077598 0.041811 "
                                 "0.040252 0.102372 0.026220 "
                                 "-0.060796 0.125745 0.042799 "
                                 "-0.002700 0.109146 -0.021617 "
                                 "-0.053082 0.139518 0.026662 "
                                 "-0.072831 0.136891 0.049250 "
                                 "-0.022318 0.181221 -0.012616 "
                                 "-0.062587 0.137282 0.036031 "
                                 "0.036468 0.111067 0.002168 "
                                 "0.022493 0.120697 0.030928 "
                                 "-0.068515 0.132239 0.047795 "
                                 "0.015592 0.078141 0.054165 "
                                 "-0.044768 0.146394 0.003586 "
                                 "0.004576 0.108164 0.041888 "
                                 "0.042099 0.093008 0.027170 "
                                 "-0.063799 0.143909 0.038920 "
                                 "-0.065799 0.120921 0.051999 "
                                 "-0.061867 0.112377 0.036730 "
                                 "-0.033558 0.173613 -0.001108 "
                                 "0.010985 0.123169 0.033628 "
                                 "-0.069391 0.117164 0.052337 "
                                 "-0.049240 0.118066 0.031545 "
                                 "0.045144 0.080268 0.023028 "
                                 "0.045515 0.080198 0.021690 "
                                 "-0.009929 0.166943 -0.018055 "
                                 "0.033894 0.111352 0.028046 "
                                 "-0.068718 0.114088 0.050433 "
                                 "-0.062044 0.114243 0.037354 "
                                 "0.027865 0.103405 0.039124 "
                                 "-0.055094 0.114335 0.035233 "
                                 "0.026730 0.079214 0.047114 "
                                 "-0.046699 0.122484 0.027073 "
                                 "-0.009970 0.167686 -0.017702 "
                                 "0.043315 0.083190 0.027513 "
                                 "0.022758 0.094213 0.047144 "
                                 "-0.045635 0.123874 0.025084 "
                                 "0.020065 0.084847 0.050222 "
                                 "0.036554 0.108655 0.026577 "
                                 "-0.033646 0.165935 -0.004786 "
                                 "0.020807 0.086180 0.049534 "
                                 "0.004625 0.109546 0.041960 "
                                 "-0.069930 0.141590 0.046209 "
                                 "0.021629 0.087551 0.049039 "
                                 "0.039804 0.089822 0.033495 "
                                 "-0.048053 0.150190 -0.004201 "
                                 "-0.024682 0.159952 -0.001088 "
                                 "-0.050727 0.115538 0.033580 "
                                 "0.009088 0.097645 0.049418 "
                                 "-0.024774 0.180145 -0.009568 "
                                 "-0.061113 0.149657 0.036321 "
                                 "-0.017561 0.186044 -0.018449 "
                                 "-0.045252 0.122806 0.025016 "
                                 "-0.058955 0.151077 0.034187 "
                                 "-0.010889 0.108738 -0.021743 "
                                 "-0.073382 0.135448 0.050183 "
                                 "-0.048532 0.143887 0.006514 "
                                 "0.014126 0.090787 0.052728 "
                                 "-0.054919 0.148123 0.027541 "
                                 "-0.073651 0.180693 -0.054018 "
                                 "0.035433 0.111001 -0.000827 "
                                 "-0.074141 0.105214 0.036938 "
                                 "0.034274 0.091666 0.040805 "
                                 "-0.026146 0.180134 -0.008033 "
                                 "0.041527 0.097216 -0.003903 "
                                 "0.039787 0.104095 -0.000790 "
                                 "-0.010438 0.171321 -0.020552 "
                                 "0.040891 0.094256 -0.006770 "
                                 "-0.084037 0.145378 0.004810 "
                                 "0.019655 0.035085 -0.003456 "
                                 "0.017978 0.035483 -0.012673 "
                                 "0.017351 0.035184 -0.014686 "
                                 "0.016671 0.035381 -0.015659 "
                                 "0.022996 0.037585 0.033289 "
                                 "-0.089659 0.099833 0.017847 "
                                 "0.039376 0.039372 0.002323 "
                                 "0.016325 0.035201 -0.018314 "
                                 "0.024913 0.039060 0.032333 "
                                 "0.045899 0.041406 0.011234 "
                                 "0.045451 0.041238 0.010235 "
                                 "0.036964 0.040555 -0.001588 "
                                 "0.014050 0.037936 -0.021724 "
                                 "0.023136 0.040456 0.039246 "
                                 "-0.062395 0.163038 -0.054588 "
                                 "0.048458 0.043018 0.014220 "
                                 "0.041031 0.042290 -0.000688 "
                                 "0.020591 0.043659 -0.020978 "
                                 "-0.058686 0.060316 0.023126 "
                                 "-0.009223 0.174168 -0.028567 "
                                 "0.024695 0.042022 0.038270 "
                                 "-0.062676 0.177191 -0.057627 "
                                 "0.050252 0.044634 0.018204 "
                                 "0.025338 0.041873 -0.005885 "
                                 "0.022728 0.039972 -0.005642 "
                                 "0.017317 0.041198 -0.021676 "
                                 "0.040137 0.095364 -0.006888 "
                                 "-0.086614 0.111799 0.023338 "
                                 "-0.062457 0.177245 -0.058615 "
                                 "0.047024 0.045876 -0.000609 "
                                 "-0.062908 0.150560 -0.025587 "
                                 "0.052608 0.047598 0.021222 "
                                 "0.056546 0.049738 0.018075 "
                                 "0.047681 0.047268 -0.001643 "
                                 "0.022565 0.045669 -0.018540 "
                                 "0.018420 0.044214 -0.022632 "
                                 "-0.009629 0.168316 -0.023669 "
                                 "-0.014554 0.162843 -0.010082 "
                                 "0.047073 0.048551 -0.003646 "
                                 "0.031126 0.046970 -0.006535 "
                                 "0.028058 0.049173 -0.018234 "
                                 "0.019626 0.045759 -0.021723 "
                                 "0.018445 0.045652 -0.022673 "
                                 "-0.013671 0.162609 -0.015656 "
                                 "-0.064753 0.156678 -0.047594 "
                                 "0.048231 0.050030 -0.003699 "
                                 "-0.061903 0.152590 -0.029073 "
                                 "-0.064629 0.156694 -0.046598 "
                                 "-0.060478 0.144516 -0.003635 "
                                 "0.057159 0.050804 0.007605 "
                                 "0.053557 0.058091 -0.003559 "
                                 "0.050638 0.051672 -0.002735 "
                                 "-0.051929 0.136980 0.026387 "
                                 "-0.064488 0.156696 -0.045603 "
                                 "-0.036286 0.151198 0.000402 "
                                 "0.032998 0.051431 -0.007635 "
                                 "-0.063640 0.163113 -0.024591 "
                                 "-0.048075 0.134034 0.005399 "
                                 "-0.053174 0.150869 0.021398 "
                                 "-0.053869 0.152421 0.021400 "
                                 "0.061282 0.060979 0.008052 "
                                 "-0.049294 0.133961 0.001427 "
                                 "0.038369 0.088421 -0.013773 "
                                 "0.054270 0.057579 -0.001787 "
                                 "0.038928 0.064147 -0.010753 "
                                 "0.030796 0.048804 -0.007779 "
                                 "0.026392 0.054968 -0.020802 "
                                 "-0.050474 0.137043 0.022400 "
                                 "0.038624 0.089851 -0.012769 "
                                 "0.054545 0.058989 -0.001818 "
                                 "0.038123 0.057470 -0.005915 "
                                 "-0.025394 0.106122 -0.022387 "
                                 "0.055301 0.060464 -0.000843 "
                                 "-0.088206 0.135559 0.003366 "
                                 "0.039239 0.058959 -0.005124 "
                                 "-0.015832 0.184840 -0.020727 "
                                 "-0.063934 0.169417 -0.044580 "
                                 "-0.061679 0.175513 -0.061381 "
                                 "-0.061651 0.157813 -0.019788 "
                                 "0.056298 0.063302 0.001233 "
                                 "0.030795 0.058601 -0.017734 "
                                 "0.021937 0.055669 -0.027055 "
                                 "-0.094871 0.122902 0.022189 "
                                 "-0.091313 0.113305 0.016325 "
                                 "-0.010049 0.165099 -0.020759 "
                                 "-0.055288 0.147721 0.028349 "
                                 "-0.078988 0.138940 -0.004741 "
                                 "-0.062540 0.149101 -0.006575 "
                                 "-0.062522 0.149113 -0.005581 "
                                 "-0.052484 0.150872 0.017395 "
                                 "0.059075 0.067744 0.020163 "
                                 "0.042193 0.066261 -0.002834 "
                                 "0.042068 0.063212 -0.002158 "
                                 "-0.062769 0.175495 -0.061570 "
                                 "-0.068864 0.156533 -0.053205 "
                                 "-0.068854 0.147497 -0.029579 "
                                 "0.058829 0.069107 0.019159 "
                                 "0.058229 0.069067 0.006136 "
                                 "-0.048864 0.162635 -0.005797 "
                                 "-0.062219 0.177210 -0.060600 "
                                 "-0.016222 0.186444 -0.020735 "
                                 "0.059153 0.070495 0.013155 "
                                 "-0.090970 0.113313 0.018324 "
                                 "0.041049 0.106185 0.006150 "
                                 "-0.062655 0.150596 -0.022579 "
                                 "-0.051989 0.142827 0.018310 "
                                 "-0.010049 0.177211 -0.025754 "
                                 "0.038336 0.102640 -0.005826 "
                                 "-0.010940 0.165104 -0.015661 "
                                 "-0.039084 0.149487 -0.000629 "
                                 "-0.057085 0.136926 -0.005008 "
                                 "-0.079775 0.106127 0.031384 "
                                 "-0.086972 0.121397 -0.001898 "
                                 "-0.024832 0.093010 -0.031618 "
                                 "-0.025615 0.156162 -0.003544 "
                                 "-0.064398 0.155173 -0.041604 "
                                 "-0.053935 0.139875 0.028353 "
                                 "-0.010793 0.180280 -0.026745 "
                                 "-0.010315 0.180354 -0.028878 "
                                 "0.046126 0.073615 0.004216 "
                                 "0.031952 0.069103 -0.018709 "
                                 "-0.018142 0.159077 -0.009325 "
                                 "-0.063220 0.150553 -0.027592 "
                                 "-0.063051 0.152177 -0.008587 "
                                 "-0.053928 0.152376 0.022392 "
                                 "-0.092423 0.113974 0.016676 "
                                 "-0.061997 0.147610 -0.004622 "
                                 "-0.063084 0.164691 -0.032592 "
                                 "-0.010363 0.180289 -0.027734 "
                                 "0.039220 0.077501 -0.010108 "
                                 "0.029524 0.075033 -0.021815 "
                                 "-0.023646 0.184410 -0.015053 "
                                 "-0.052765 0.138519 0.026397 "
                                 "-0.026155 0.155801 -0.005687 "
                                 "-0.072526 0.149972 -0.042469 "
                                 "-0.072234 0.147352 -0.024232 "
                                 "-0.077900 0.105799 -0.007577 "
                                 "0.045717 0.079213 0.021174 "
                                 "0.041064 0.092872 -0.007795 "
                                 "0.046713 0.072341 0.005563 "
                                 "-0.063865 0.166212 -0.033602 "
                                 "-0.062874 0.175671 -0.055595 "
                                 "0.045825 0.080617 0.020170 "
                                 "-0.076643 0.149485 -0.008679 "
                                 "-0.063297 0.144361 -0.009605 "
                                 "0.045163 0.095673 0.008717 "
                                 "0.033399 0.080994 -0.018737 "
                                 "-0.081982 0.112797 -0.000848 "
                                 "-0.091672 0.117524 0.028069 "
                                 "-0.048022 0.144366 0.004427 "
                                 "0.044133 0.080232 -0.002522 "
                                 "0.037727 0.085584 -0.016367 "
                                 "-0.030192 0.153974 -0.003571 "
                                 "-0.062777 0.161085 -0.047210 "
                                 "-0.062519 0.144437 -0.006582 "
                                 "0.043849 0.084675 0.026172 "
                                 "-0.076848 0.148423 0.040238 "
                                 "-0.067453 0.180926 -0.058380 "
                                 "-0.045884 0.129671 0.002936 "
                                 "-0.093435 0.121095 0.042248 "
                                 "-0.067905 0.173751 -0.043985 "
                                 "-0.050555 0.136728 0.023252 "
                                 "-0.071802 0.181053 -0.055655 "
                                 "-0.010362 0.179472 -0.029571 "
                                 "-0.005897 0.098097 0.051999 "
                                 "-0.062828 0.151059 0.036055 "
                                 "-0.050078 0.136736 0.021957 "
                                 "-0.045979 0.167363 0.002591 "
                                 "-0.011364 0.182132 -0.028821 "
                                 "-0.052576 0.136549 0.028410 "
                                 "-0.063846 0.180771 -0.058948 "
                                 "0.003007 0.099142 0.049182 "
                                 "-0.064141 0.171114 -0.047178 "
                                 "-0.075916 0.179384 -0.051606 "
                                 "0.000053 0.097862 0.053297 "
                                 "-0.074748 0.158885 -0.007836 "
                                 "-0.011087 0.180248 -0.025982 "
                                 "-0.076524 0.178854 -0.050295 "
                                 "-0.086930 0.151358 0.010227 "
                                 "-0.019131 0.122285 0.030395 "
                                 "-0.058101 0.158247 0.004154 "
                                 "-0.082061 0.151973 0.004324 "
                                 "0.026954 0.116596 0.031065 "
                                 "-0.013723 0.183161 -0.024107 "
                                 "-0.082061 0.154804 0.013629 "
                                 "-0.085429 0.151325 0.028294 "
                                 "-0.076439 0.098866 -0.011539 "
                                 "-0.086549 0.109000 0.015694 "
                                 "-0.091717 0.141326 0.017134 "
                                 "-0.062003 0.154899 0.004205 "
                                 "-0.092111 0.128137 0.031104 "
                                 "-0.068605 0.155434 -0.051807 "
                                 "-0.005161 0.100957 0.044271 "
                                 "-0.044251 0.120873 0.027396 "
                                 "-0.089317 0.151601 0.019497 "
                                 "-0.063020 0.168283 -0.045257 "
                                 "-0.077704 0.175863 -0.045075 "
                                 "-0.091075 0.135224 0.016144 "
                                 "0.049370 0.069379 0.025027 "
                                 "-0.007104 0.125174 0.031741 "
                                 "0.033637 0.112962 -0.002307 "
                                 "-0.074694 0.111142 -0.007602 "
                                 "-0.017221 0.187225 -0.021155 "
                                 "-0.030168 0.118019 0.030802 "
                                 "-0.028460 0.125795 0.008832 "
                                 "0.057735 0.070506 0.007469 "
                                 "0.003964 0.097777 0.051060 "
                                 "0.032895 0.114630 -0.001059 "
                                 "0.027501 0.118700 -0.003048 "
                                 "-0.079635 0.167489 -0.036775 "
                                 "-0.017050 0.122405 0.031234 "
                                 "-0.007453 0.100521 0.046910 "
                                 "-0.053725 0.151161 0.024627 "
                                 "-0.045982 0.130505 0.004443 "
                                 "0.012743 0.127966 0.027041 "
                                 "0.025743 0.120365 -0.002249 "
                                 "-0.081065 0.111196 -0.000918 "
                                 "-0.051027 0.136724 0.024552 "
                                 "-0.067871 0.156792 0.022379 "
                                 "-0.063800 0.166551 -0.035494 "
                                 "0.060392 0.069417 0.011831 "
                                 "-0.047170 0.165970 0.003632 "
                                 "0.030267 0.120025 0.005493 "
                                 "-0.091498 0.150215 0.020796 "
                                 "-0.071332 0.151217 -0.043920 "
                                 "-0.087751 0.128902 0.000900 "
                                 "-0.063805 0.152122 -0.002245 "
                                 "-0.031285 0.119331 0.029156 "
                                 "0.022998 0.123119 -0.000380 "
                                 "0.022167 0.123584 -0.000681 "
                                 "-0.054554 0.160714 0.005405 "
                                 "0.057670 0.071756 0.018414 "
                                 "0.022042 0.124260 0.000701 "
                                 "-0.087413 0.093190 0.004840 "
                                 "-0.009347 0.098183 0.051937 "
                                 "-0.061079 0.151413 0.035139 "
                                 "0.002048 0.102202 0.043813 "
                                 "-0.066613 0.148623 0.039262 "
                                 "-0.055002 0.153297 0.028117 "
                                 "0.046790 0.073773 0.016792 "
                                 "-0.031448 0.177007 -0.013927 "
                                 "-0.001162 0.098034 0.052196 "
                                 "-0.051351 0.152104 0.013223 "
                                 "-0.042883 0.128827 0.014388 "
                                 "-0.022585 0.185119 -0.013184 "
                                 "0.032239 0.117348 0.023130 "
                                 "0.011504 0.129313 0.001094 "
                                 "-0.023460 0.184384 -0.011932 "
                                 "-0.075946 0.097459 -0.012513 "
                                 "-0.005179 0.129883 0.025223 "
                                 "0.005861 0.130491 0.001853 "
                                 "-0.029850 0.180049 -0.011606 "
                                 "-0.067096 0.164861 -0.018887 "
                                 "-0.073324 0.170102 -0.027685 "
                                 "0.052646 0.072994 0.020857 "
                                 "-0.003124 0.123427 0.034663 "
                                 "-0.014724 0.129248 0.015884 "
                                 "-0.075527 0.109807 -0.007602 "
                                 "-0.027112 0.124435 0.018388 "
                                 "-0.044261 0.122001 0.025892 "
                                 "-0.077187 0.153815 0.000184 "
                                 "-0.084777 0.095970 -0.003931 "
                                 "-0.047172 0.133935 0.009815 "
                                 "0.052984 0.069258 0.024906 "
                                 "0.052194 0.069772 0.024557 "
                                 "0.007149 0.123902 0.033879 "
                                 "-0.046057 0.131197 0.005824 "
                                 "0.007587 0.130944 0.001903 "
                                 "-0.072750 0.180616 -0.054977 "
                                 "-0.018876 0.105884 -0.022628 "
                                 "-0.017875 0.105871 -0.022589 "
                                 "-0.066685 0.036123 0.035141 "
                                 "-0.065936 0.036420 0.038649 "
                                 "-0.060884 0.036716 0.044984 "
                                 "-0.059243 0.036753 0.046137 "
                                 "-0.047036 0.035908 0.045106 "
                                 "-0.044737 0.035714 0.044172 "
                                 "-0.069135 0.035455 0.012250 "
                                 "-0.068464 0.035536 0.013028 "
                                 "-0.062423 0.035753 0.019657 "
                                 "-0.061746 0.042600 0.042925 "
                                 "-0.055906 0.037983 0.047068 "
                                 "-0.037607 0.036543 0.044419 "
                                 "-0.036930 0.036554 0.045141 "
                                 "-0.036270 0.036560 0.045881 "
                                 "-0.033821 0.036733 0.049100 "
                                 "-0.033215 0.036763 0.049913 "
                                 "-0.031638 0.036774 0.051182 "
                                 "-0.030039 0.036799 0.052422 "
                                 "-0.028341 0.036810 0.053558 "
                                 "-0.055235 0.043304 0.046580 "
                                 "-0.026570 0.038204 0.055248 "
                                 "-0.064199 0.042219 0.027537 "
                                 "-0.067406 0.035436 0.036194 "
                                 "-0.064134 0.044628 0.034748 "
                                 "-0.034115 0.042437 0.048702 "
                                 "-0.088565 0.096304 0.022720 "
                                 "-0.071415 0.038661 0.000579 "
                                 "-0.071384 0.035533 0.010286 "
                                 "-0.059415 0.039567 0.019974 "
                                 "-0.002780 0.100393 -0.023542 "
                                 "-0.030725 0.079300 0.041026 "
                                 "-0.089150 0.139122 0.037510 "
                                 "-0.064435 0.042410 0.030248 "
                                 "-0.064596 0.043007 0.035823 "
                                 "-0.038969 0.042042 0.041595 "
                                 "-0.024661 0.042233 0.053955 "
                                 "-0.078686 0.174223 -0.045863 "
                                 "-0.055578 0.159581 0.006379 "
                                 "-0.067561 0.044863 0.007377 "
                                 "-0.071811 0.095541 0.041327 "
                                 "-0.063288 0.044436 0.037293 "
                                 "-0.088305 0.149858 0.026519 "
                                 "-0.028815 0.043632 0.051009 "
                                 "-0.021138 0.098548 0.044502 "
                                 "-0.083902 0.105911 0.026288 "
                                 "-0.056782 0.043535 0.016717 "
                                 "-0.090816 0.116185 0.042702 "
                                 "-0.067315 0.044668 0.006020 "
                                 "-0.060400 0.047013 0.037152 "
                                 "-0.074680 0.157704 -0.005566 "
                                 "-0.045598 0.169625 -0.002419 "
                                 "-0.057758 0.047918 0.035950 "
                                 "-0.058863 0.156048 0.009540 "
                                 "-0.055124 0.048280 0.038911 "
                                 "-0.020816 0.079725 0.056038 "
                                 "-0.077790 0.164478 -0.025199 "
                                 "-0.078272 0.165861 -0.029036 "
                                 "-0.057476 0.047878 0.009161 "
                                 "-0.076982 0.179572 -0.051371 "
                                 "-0.079848 0.116269 0.048758 "
                                 "-0.023736 0.086541 0.054457 "
                                 "-0.078852 0.107465 0.032436 "
                                 "-0.032961 0.051054 0.038223 "
                                 "-0.075260 0.157705 -0.006422 "
                                 "-0.055289 0.160933 0.003284 "
                                 "-0.058227 0.048399 0.006759 "
                                 "-0.050039 0.047811 0.016868 "
                                 "-0.058040 0.060877 0.024555 "
                                 "-0.027311 0.091770 0.045195 "
                                 "-0.083080 0.081450 0.029210 "
                                 "-0.077793 0.167262 -0.029530 "
                                 "-0.075338 0.161792 -0.013478 "
                                 "-0.051770 0.051602 0.031230 "
                                 "-0.051573 0.052359 0.030554 "
                                 "-0.020587 0.094703 0.051310 "
                                 "-0.087066 0.141474 0.040183 "
                                 "-0.073808 0.102191 0.037495 "
                                 "-0.079748 0.078938 0.031423 "
                                 "-0.082082 0.150001 0.034405 "
                                 "-0.051491 0.052957 0.030880 "
                                 "-0.048255 0.053230 0.036171 "
                                 "-0.047395 0.035957 0.045283 "
                                 "-0.014451 0.103914 0.043265 "
                                 "-0.076840 0.178514 -0.050928 "
                                 "-0.077412 0.160346 -0.016940 "
                                 "-0.027792 0.053068 0.036540 "
                                 "-0.076742 0.164619 -0.022017 "
                                 "-0.051707 0.163863 0.002419 "
                                 "-0.079102 0.170034 -0.038269 "
                                 "-0.079102 0.171279 -0.041032 "
                                 "-0.050567 0.054554 0.017337 "
                                 "-0.052122 0.055334 0.025863 "
                                 "-0.077519 0.147451 0.041178 "
                                 "-0.071550 0.076334 0.037454 "
                                 "-0.085225 0.114025 0.048015 "
                                 "-0.088460 0.097654 0.022602 "
                                 "-0.079604 0.174107 -0.046390 "
                                 "-0.052890 0.055616 0.012484 "
                                 "-0.052288 0.055669 0.013306 "
                                 "-0.051297 0.055683 0.015038 "
                                 "-0.022939 0.098598 0.044810 "
                                 "-0.016571 0.056922 0.051097 "
                                 "-0.020326 0.082530 0.056871 "
                                 "-0.078583 0.087018 0.037216 "
                                 "-0.078901 0.172846 -0.044095 "
                                 "-0.057294 0.059745 0.022361 "
                                 "-0.053553 0.060429 0.026462 "
                                 "-0.043647 0.060159 0.039893 "
                                 "-0.026540 0.059202 0.038381 "
                                 "-0.068767 0.090095 0.042705 "
                                 "-0.077518 0.172972 -0.039913 "
                                 "-0.023874 0.105835 -0.022678 "
                                 "-0.053287 0.061060 0.028214 "
                                 "-0.043822 0.061568 0.040004 "
                                 "-0.085799 0.151046 0.029438 "
                                 "-0.016547 0.061194 0.052368 "
                                 "-0.090279 0.116199 0.043584 "
                                 "-0.077750 0.161717 -0.020949 "
                                 "-0.079195 0.168601 -0.036643 "
                                 "-0.085221 0.132036 0.049369 "
                                 "-0.053062 0.062559 0.030763 "
                                 "-0.051701 0.062677 0.032235 "
                                 "-0.051142 0.062742 0.033098 "
                                 "-0.016685 0.062588 0.052478 "
                                 "-0.074605 0.114104 -0.006416 "
                                 "-0.081131 0.129963 0.052448 "
                                 "-0.077190 0.117737 0.051681 "
                                 "-0.025047 0.094997 0.044896 "
                                 "-0.077356 0.163115 -0.021355 "
                                 "-0.026296 0.063447 0.039421 "
                                 "-0.016414 0.099612 0.044078 "
                                 "-0.074764 0.107316 0.036203 "
                                 "-0.066853 0.091456 0.043506 "
                                 "-0.082460 0.108623 0.027619 "
                                 "-0.078951 0.128836 0.054193 "
                                 "-0.045045 0.065713 0.039695 "
                                 "-0.025749 0.036557 0.054009 "
                                 "-0.016813 0.062115 0.052682 "
                                 "-0.016674 0.066891 0.053711 "
                                 "-0.011794 0.066719 0.054462 "
                                 "-0.076681 0.154876 -0.006314 "
                                 "-0.090499 0.148452 0.024515 "
                                 "-0.028731 0.074896 0.041482 "
                                 "0.010138 0.104418 -0.020246 "
                                 "-0.015186 0.168246 -0.021561 "
                                 "-0.042881 0.108469 -0.019386 "
                                 "-0.058997 0.084194 -0.020854 "
                                 "-0.091683 0.116094 0.040744 "
                                 "-0.085234 0.104506 0.024826 "
                                 "-0.071459 0.151188 -0.043322 "
                                 "-0.017603 0.071155 0.054519 "
                                 "-0.078807 0.106130 0.032485 "
                                 "-0.025047 0.080547 0.053580 "
                                 "-0.071901 0.152408 -0.043423 "
                                 "-0.023799 0.184341 -0.014597 "
                                 "-0.019317 0.075402 0.054688 "
                                 "-0.010806 0.034295 -0.025597 "
                                 "-0.008683 0.097657 -0.030445 "
                                 "-0.070396 0.038222 -0.000484 "
                                 "-0.064320 0.035936 0.024151 "
                                 "-0.070750 0.162623 -0.045378 "
                                 "-0.047784 0.038449 -0.012233 "
                                 "-0.067401 0.040625 -0.003341 "
                                 "0.012498 0.036363 -0.021917 "
                                 "-0.090556 0.129700 0.040228 "
                                 "-0.071563 0.151347 -0.043624 "
                                 "-0.044911 0.045780 -0.010946 "
                                 "-0.047318 0.039794 -0.012062 "
                                 "-0.068755 0.116060 -0.008746 "
                                 "-0.089126 0.137079 0.025122 "
                                 "-0.069476 0.042643 0.000668 "
                                 "-0.072853 0.035550 0.002529 "
                                 "-0.075578 0.154868 -0.000834 "
                                 "-0.054371 0.158326 -0.001789 "
                                 "-0.060851 0.155133 0.003690 "
                                 "-0.056894 0.158351 0.001188 "
                                 "-0.057497 0.158400 0.002092 "
                                 "-0.065238 0.041953 0.033705 "
                                 "-0.077268 0.155563 -0.011897 "
                                 "-0.043908 0.034308 -0.026883 "
                                 "-0.044744 0.039642 -0.021577 "
                                 "0.022162 0.095920 -0.021972 "
                                 "-0.068386 0.043493 0.004694 "
                                 "-0.068639 0.043534 0.005698 "
                                 "-0.038348 0.041711 -0.027346 "
                                 "-0.061186 0.044121 -0.004327 "
                                 "-0.059362 0.047606 0.000101 "
                                 "-0.039022 0.045911 -0.022759 "
                                 "-0.063007 0.045830 0.008721 "
                                 "-0.047064 0.168385 -0.001002 "
                                 "-0.038149 0.044868 -0.024210 "
                                 "-0.054255 0.049028 0.029769 "
                                 "-0.038766 0.045933 -0.022284 "
                                 "-0.041323 0.046240 -0.016312 "
                                 "-0.043267 0.046587 -0.011389 "
                                 "-0.075668 0.155622 -0.002603 "
                                 "-0.091032 0.144770 0.026167 "
                                 "-0.086328 0.151358 0.009233 "
                                 "-0.057566 0.048138 0.034664 "
                                 "-0.057553 0.048178 0.038938 "
                                 "-0.036151 0.047160 -0.021326 "
                                 "-0.082537 0.151557 0.003650 "
                                 "-0.041416 0.047637 -0.012230 "
                                 "-0.052279 0.049031 0.035659 "
                                 "-0.073572 0.148626 -0.026849 "
                                 "-0.036200 0.048331 -0.016295 "
                                 "-0.036606 0.048448 -0.014284 "
                                 "-0.053168 0.050303 -0.006388 "
                                 "-0.057148 0.052574 0.000631 "
                                 "-0.030353 0.049890 -0.019369 "
                                 "-0.052512 0.051984 -0.007188 "
                                 "0.011853 0.105542 -0.019754 "
                                 "-0.056771 0.057251 0.007253 "
                                 "-0.071828 0.141507 -0.008016 "
                                 "-0.051032 0.054419 0.019619 "
                                 "-0.088924 0.151541 0.021101 "
                                 "-0.052832 0.055837 -0.007420 "
                                 "-0.049863 0.054275 0.015634 "
                                 "-0.094007 0.129802 0.018180 "
                                 "-0.024936 0.054649 -0.028408 "
                                 "-0.075829 0.093523 -0.013687 "
                                 "0.018167 0.095997 -0.023265 "
                                 "-0.065589 0.167628 -0.059737 "
                                 "-0.074146 0.151129 -0.029188 "
                                 "0.016944 0.094696 -0.024307 "
                                 "-0.057089 0.060232 -0.002574 "
                                 "-0.037067 0.156264 -0.010370 "
                                 "-0.091018 0.149734 0.013441 "
                                 "-0.052736 0.163457 -0.000904 "
                                 "-0.078459 0.159178 -0.022073 "
                                 "-0.056704 0.111275 -0.017686 "
                                 "-0.079616 0.070320 0.016623 "
                                 "-0.040892 0.109911 -0.018800 "
                                 "-0.081009 0.136808 -0.002869 "
                                 "-0.062766 0.170921 -0.061607 "
                                 "-0.052123 0.049165 0.035634 "
                                 "0.040891 0.091776 -0.009100 "
                                 "0.015157 0.107807 -0.018185 "
                                 "-0.077880 0.103388 -0.008666 "
                                 "-0.040161 0.110268 -0.018707 "
                                 "-0.074397 0.160314 -0.030905 "
                                 "-0.008919 0.033847 -0.025125 "
                                 "0.029469 0.095176 -0.018643 "
                                 "-0.075086 0.067468 0.003551 "
                                 "-0.078424 0.146692 -0.003613 "
                                 "-0.091437 0.114681 0.021315 "
                                 "-0.090341 0.130900 0.040068 "
                                 "0.004647 0.093885 -0.032195 "
                                 "-0.077076 0.068957 0.008539 "
                                 "-0.065286 0.176792 -0.060802 "
                                 "-0.013252 0.180136 -0.028613 "
                                 "-0.052901 0.114056 -0.016235 "
                                 "-0.017913 0.184413 -0.023990 "
                                 "-0.079885 0.070630 0.012550 "
                                 "-0.079889 0.070630 0.013550 "
                                 "-0.025189 0.178943 -0.018780 "
                                 "-0.077799 0.073099 -0.005325 "
                                 "-0.080225 0.072000 0.005544 "
                                 "-0.080010 0.072030 0.018553 "
                                 "-0.079546 0.071986 0.019558 "
                                 "-0.026014 0.068834 -0.034504 "
                                 "-0.030094 0.067301 -0.027970 "
                                 "-0.030573 0.059945 -0.018933 "
                                 "-0.075706 0.070108 -0.000047 "
                                 "-0.039761 0.120231 -0.012793 "
                                 "-0.072928 0.148723 -0.032782 "
                                 "-0.038619 0.047455 -0.016386 "
                                 "0.027694 0.085014 -0.022063 "
                                 "-0.072448 0.148649 -0.034807 "
                                 "-0.082956 0.076257 0.016526 "
                                 "-0.066412 0.162305 -0.057942 "
                                 "-0.072012 0.148777 -0.035760 "
                                 "-0.077608 0.077089 -0.007600 "
                                 "-0.084539 0.077802 0.014517 "
                                 "-0.071014 0.148895 -0.037822 "
                                 "-0.075920 0.078323 -0.009591 "
                                 "-0.086853 0.081079 0.010849 "
                                 "-0.071911 0.144135 -0.014659 "
                                 "-0.074627 0.149901 -0.029871 "
                                 "-0.077891 0.079796 -0.008639 "
                                 "-0.082390 0.074996 0.003304 "
                                 "-0.070947 0.140954 -0.008050 "
                                 "-0.077146 0.156966 -0.011900 "
                                 "-0.073019 0.080841 -0.014580 "
                                 "-0.077886 0.081156 -0.009633 "
                                 "-0.036361 0.078336 -0.019535 "
                                 "-0.074019 0.082262 -0.014630 "
                                 "-0.075495 0.155610 -0.001907 "
                                 "-0.081644 0.129364 -0.004806 "
                                 "-0.032331 0.078279 -0.031704 "
                                 "-0.079744 0.081910 -0.007905 "
                                 "-0.089763 0.133813 0.039204 "
                                 "0.038710 0.105846 0.000022 "
                                 "-0.061587 0.117934 -0.010507 "
                                 "-0.075033 0.085103 -0.014560 "
                                 "-0.040541 0.166202 -0.012095 "
                                 "-0.087722 0.151511 0.024071 "
                                 "-0.033651 0.085644 -0.024757 "
                                 "-0.075237 0.086484 -0.014514 "
                                 "-0.087724 0.085428 0.014220 "
                                 "-0.089609 0.141602 0.031992 "
                                 "-0.075188 0.152833 -0.015966 "
                                 "-0.068568 0.156629 -0.052997 "
                                 "-0.009676 0.104885 -0.023104 "
                                 "-0.085360 0.109807 0.006222 "
                                 "-0.039019 0.174111 -0.009029 "
                                 "-0.027379 0.085971 -0.035654 "
                                 "-0.055531 0.040944 -0.009922 "
                                 "-0.086394 0.085570 -0.000840 "
                                 "-0.076358 0.141673 -0.005738 "
                                 "-0.032093 0.087730 -0.025498 "
                                 "-0.017229 0.104564 -0.022745 "
                                 "-0.049660 0.118919 -0.014131 "
                                 "-0.089823 0.092558 0.021822 "
                                 "-0.076654 0.113990 -0.004814 "
                                 "-0.092635 0.116935 0.008842 "
                                 "-0.041134 0.037889 -0.027518 "
                                 "-0.028876 0.046967 -0.026215 "
                                 "0.000689 0.105475 -0.021690 "
                                 "0.017762 0.100614 -0.022454 "
                                 "0.038365 0.101327 -0.007241 "
                                 "0.016593 0.100464 -0.022378 "
                                 "-0.025269 0.093126 -0.030867 "
                                 "-0.052243 0.126999 -0.005034 "
                                 "0.053623 0.058755 -0.002690 "
                                 "-0.048269 0.037339 -0.012384 "
                                 "-0.021680 0.184690 -0.018817 "
                                 "0.029353 0.117442 -0.002543 "
                                 "0.021961 0.100321 -0.021160 "
                                 "-0.012106 0.086958 -0.038462 "
                                 "-0.013342 0.112081 -0.018621 "
                                 "0.024541 0.081954 -0.024971 "
                                 "-0.007420 0.035877 -0.024927 "
                                 "-0.009175 0.087571 -0.037094 "
                                 "0.054837 0.073109 0.009023 "
                                 "0.055426 0.071416 0.006408 "
                                 "0.056334 0.071137 0.006716 "
                                 "-0.020732 0.114935 -0.016742 "
                                 "0.017679 0.085219 -0.028353 "
                                 "-0.018768 0.034185 -0.027695 "
                                 "-0.035284 0.173981 -0.012629 "
                                 "-0.026663 0.178341 -0.017682 "
                                 "-0.023595 0.180085 -0.019676 "
                                 "-0.014488 0.185446 -0.025770 "
                                 "-0.032519 0.174119 -0.014863 "
                                 "-0.065357 0.155100 0.005646 "
                                 "-0.064416 0.154996 0.005865 "
                                 "-0.044287 0.166804 -0.008538 "
                                 "-0.023240 0.093652 -0.032678 "
                                 "-0.055818 0.158024 -0.000145 "
                                 "-0.052392 0.160438 -0.003076 "
                                 "-0.041472 0.167040 -0.010815 "
                                 "-0.014584 0.185601 -0.026982 "
                                 "-0.026852 0.098187 -0.024073 "
                                 "-0.027912 0.034067 -0.029247 "
                                 "-0.025710 0.098352 -0.024235 "
                                 "-0.038543 0.038993 -0.028624 "
                                 "-0.052489 0.159007 -0.003405 "
                                 "-0.056184 0.037462 -0.010574 "
                                 "-0.010553 0.180959 -0.028854 "
                                 "-0.020256 0.036506 -0.028012 "
                                 "-0.019833 0.107697 -0.022052 "
                                 "-0.011421 0.107659 -0.022044 "
                                 "-0.059774 0.149902 -0.001229 "
                                 "-0.019309 0.036282 -0.027779 "
                                 "0.025109 0.111719 -0.012490 "
                                 "-0.026057 0.037591 -0.029189 "
                                 "0.011270 0.104834 -0.020502 "
                                 "0.023069 0.121925 -0.004197 "
                                 "0.046473 0.074730 0.007000 "
                                 "-0.039662 0.039902 -0.027457 "
                                 "-0.037022 0.041095 -0.028655 "
                                 "-0.009941 0.089177 -0.036764 "
                                 "-0.005608 0.125002 -0.009489 "
                                 "-0.033775 0.105400 -0.020968 "
                                 "-0.016581 0.035588 -0.026711 "
                                 "-0.058428 0.038335 -0.009417 "
                                 "-0.063375 0.036885 -0.008048 "
                                 "-0.011756 0.034513 -0.025836 "
                                 "0.006642 0.099379 -0.022123 "
                                 "0.039487 0.105310 0.000603 "
                                 "-0.061814 0.045340 -0.001725 "
                                 "-0.063482 0.035282 -0.008247 "
                                 "-0.055554 0.042026 -0.008894 "
                                 "-0.005249 0.101176 -0.023207 "
                                 "-0.028861 0.044835 -0.028193 "
                                 "-0.028589 0.093525 -0.025224 "
                                 "-0.058144 0.114319 -0.014834 "
                                 "-0.015397 0.125153 -0.004109 "
                                 "-0.010059 0.109235 -0.021708 "
                                 "-0.059319 0.114075 -0.014560 "
                                 "-0.010537 0.085053 -0.038446 "
                                 "-0.046412 0.035458 -0.018725 "
                                 "-0.065683 0.180548 -0.059031 "
                                 "0.014582 0.100670 -0.022593 "
                                 "-0.069184 0.181162 -0.058506 "
                                 "-0.002499 0.112386 -0.019640 "
                                 "-0.049884 0.034085 -0.013307 "
                                 "-0.006156 0.110566 -0.022214 "
                                 "-0.066229 0.042518 -0.003252 "
                                 "-0.009516 0.084860 -0.038222 "
                                 "-0.028518 0.094880 -0.024629 "
                                 "-0.040442 0.035113 -0.028939 "
                                 "-0.018198 0.089616 -0.037280 "
                                 "-0.063353 0.045449 0.000290 "
                                 "-0.035084 0.107815 -0.020111 "
                                 "-0.086923 0.112018 0.023246 "
                                 "0.032361 0.078690 -0.019246 "
                                 "0.027427 0.078192 -0.023091 "
                                 "0.005420 0.091290 -0.032762 "
                                 "-0.002657 0.089995 -0.035491 "
                                 "-0.009946 0.033902 -0.025192 "
                                 "0.004610 0.092806 -0.032334 "
                                 "0.001474 0.103921 -0.022070 "
                                 "-0.055345 0.138992 -0.003070 "
                                 "-0.049948 0.135176 0.001169 "
                                 "-0.048008 0.135924 0.010304 "
                                 "-0.020760 0.034720 -0.027738 "
                                 "0.030631 0.076191 -0.020965 "
                                 "-0.063071 0.173863 -0.061680 "
                                 "-0.038215 0.047167 -0.018189 "
                                 "-0.051474 0.135214 -0.000925 "
                                 "0.011863 0.089406 -0.030726 "
                                 "0.009956 0.089786 -0.031175 "
                                 "0.004929 0.114402 -0.020103 "
                                 "-0.061876 0.138649 -0.006770 "
                                 "0.027932 0.081332 -0.022263 "
                                 "0.051888 0.065658 -0.001557 "
                                 "0.018711 0.100467 -0.022355 "
                                 "-0.018396 0.036084 -0.027420 "
                                 "-0.028317 0.096340 -0.024150 "
                                 "0.001762 0.130465 0.001572 "
                                 "-0.032558 0.114916 -0.016084 "
                                 "-0.069082 0.181440 -0.056457 "
                                 "-0.057620 0.135609 -0.005468 "
                                 "0.021367 0.085150 -0.026249 "
                                 "-0.015764 0.035327 -0.026378 "
                                 "0.028626 0.063844 -0.020406 "
                                 "-0.036903 0.033739 -0.030894 "
                                 "-0.057875 0.134121 -0.005853 "
                                 "-0.043875 0.128361 0.000409 "
                                 "0.030532 0.081181 -0.020086 "
                                 "-0.020082 0.097870 -0.024530 "
                                 "0.015406 0.088042 -0.029297 "
                                 "-0.021725 0.126122 0.002697 "
                                 "0.012366 0.128443 -0.000398 "
                                 "0.016865 0.095885 -0.023523 "
                                 "-0.023274 0.106158 -0.022428 "
                                 "-0.064314 0.044528 -0.000908 "
                                 "-0.058084 0.132712 -0.006348 "
                                 "-0.040510 0.127658 -0.000962 "
                                 "-0.039493 0.127549 -0.000886 "
                                 "0.032698 0.111022 -0.007977 "
                                 "-0.057988 0.041427 -0.008327 "
                                 "-0.059581 0.038095 -0.009172 "
                                 "-0.046740 0.129245 0.000886 "
                                 "-0.040696 0.125707 -0.008047 "
                                 "-0.027903 0.124426 0.000511 "
                                 "0.003607 0.126142 -0.007161 "
                                 "0.018408 0.127764 0.003915 "
                                 "-0.065444 0.178190 -0.060631 "
                                 "-0.064392 0.178295 -0.060775 "
                                 "-0.042616 0.035917 -0.027130 "
                                 "0.011575 0.104003 -0.020168 "
                                 "0.035855 0.084336 -0.017290 "
                                 "0.057575 0.067384 0.002722 "
                                 "0.009753 0.120711 -0.014067 "
                                 "-0.037293 0.039467 -0.029119 "
                                 "0.039034 0.102562 -0.004541 "
                                 "-0.028854 0.124656 0.002099 "
                                 "-0.009828 0.034195 -0.024366 "
                                 "-0.014578 0.034825 -0.025972 "
                                 "-0.024541 0.034994 -0.028704 "
                                 "0.010385 0.036060 -0.022439 "
                                 "-0.007582 0.036205 -0.025079 "
                                 "-0.008587 0.036240 -0.025275 "
                                 "-0.068515 0.033856 -0.004706 "
                                 "0.008998 0.036490 -0.023427 "
                                 "-0.015608 0.037809 -0.026925 "
                                 "-0.070832 0.034582 -0.001037 "
                                 "-0.071532 0.034754 -0.000134 "
                                 "-0.029580 0.036889 0.052851 "
                                 "-0.063931 0.115260 -0.011323 "
                                 "-0.033262 0.042424 -0.030211 "
                                 "-0.057517 0.037335 -0.010190 "
                                 "0.029434 0.038378 -0.001734 "
                                 "-0.084040 0.132376 -0.001828 "
                                 "-0.008576 0.043164 -0.026091 "
                                 "-0.014324 0.103680 -0.023389 "
                                 "0.037023 0.040523 -0.002041 "
                                 "0.024475 0.040042 -0.005110 "
                                 "0.005315 0.042896 -0.024171 "
                                 "0.019159 0.100268 -0.022296 "
                                 "0.015149 0.100260 -0.022640 "
                                 "0.012143 0.100268 -0.022675 "
                                 "-0.011195 0.178453 -0.029630 "
                                 "-0.013516 0.162506 -0.015305 "
                                 "-0.011766 0.182389 -0.028750 "
                                 "-0.021881 0.107267 -0.022087 "
                                 "-0.070124 0.109501 0.038232 "
                                 "-0.056543 0.041557 -0.008718 "
                                 "-0.071200 0.150790 -0.043462 "
                                 "-0.063514 0.041263 -0.006393 "
                                 "-0.064494 0.041204 -0.005990 "
                                 "0.013531 0.047821 -0.026028 "
                                 "-0.023856 0.100178 -0.023968 "
                                 "-0.024856 0.100174 -0.023964 "
                                 "-0.046567 0.043315 -0.011194 "
                                 "0.041065 0.050916 -0.007309 "
                                 "-0.010696 0.176084 -0.029251 "
                                 "-0.008375 0.045859 -0.029537 "
                                 "0.028544 0.045965 -0.007084 "
                                 "0.001825 0.048337 -0.030067 "
                                 "-0.018756 0.044979 -0.027907 "
                                 "-0.016257 0.053183 -0.032944 "
                                 "-0.065583 0.062695 -0.002740 "
                                 "-0.053491 0.045812 -0.007550 "
                                 "0.022227 0.051381 -0.024145 "
                                 "-0.027082 0.048959 -0.025227 "
                                 "-0.027650 0.050413 -0.024084 "
                                 "-0.025115 0.163764 -0.015904 "
                                 "0.047380 0.047547 -0.002962 "
                                 "0.026329 0.051777 -0.020970 "
                                 "-0.032809 0.050877 -0.011141 "
                                 "-0.035189 0.171161 -0.014036 "
                                 "0.026360 0.053174 -0.020887 "
                                 "0.008578 0.054156 -0.030513 "
                                 "-0.052565 0.051568 -0.006607 "
                                 "-0.007171 0.054903 -0.033099 "
                                 "-0.010840 0.175678 -0.029032 "
                                 "-0.025680 0.061671 -0.031107 "
                                 "-0.067790 0.180834 -0.058549 "
                                 "0.011146 0.101633 -0.021979 "
                                 "-0.021147 0.037771 0.053826 "
                                 "0.036614 0.054238 -0.006713 "
                                 "-0.040331 0.107690 -0.019920 "
                                 "-0.042983 0.054604 -0.011188 "
                                 "-0.034077 0.172586 -0.014513 "
                                 "0.003429 0.056934 -0.031203 "
                                 "0.000547 0.063627 -0.034407 "
                                 "-0.038058 0.154792 -0.009202 "
                                 "-0.057976 0.145744 -0.001916 "
                                 "0.048347 0.058938 -0.004908 "
                                 "0.043359 0.058916 -0.004699 "
                                 "0.023338 0.060640 -0.025362 "
                                 "0.021085 0.061931 -0.026580 "
                                 "-0.044209 0.165146 -0.009112 "
                                 "0.011063 0.036040 -0.022358 "
                                 "-0.026875 0.105825 -0.022448 "
                                 "-0.025640 0.106222 -0.022782 "
                                 "-0.014088 0.062639 -0.036940 "
                                 "-0.054028 0.131061 -0.005002 "
                                 "-0.061313 0.103293 -0.018311 "
                                 "-0.064291 0.169609 -0.060793 "
                                 "-0.033408 0.056284 -0.010273 "
                                 "-0.073436 0.073412 0.034880 "
                                 "-0.043887 0.108471 -0.019159 "
                                 "-0.054118 0.157553 -0.002300 "
                                 "-0.057247 0.060528 -0.003067 "
                                 "0.026280 0.066086 -0.022657 "
                                 "0.021876 0.069295 -0.027500 "
                                 "-0.061063 0.138403 -0.006548 "
                                 "-0.078029 0.141290 -0.004917 "
                                 "-0.060035 0.121358 -0.008732 "
                                 "0.010879 0.066111 -0.031139 "
                                 "-0.002871 0.068252 -0.034506 "
                                 "-0.015884 0.037769 0.051576 "
                                 "0.012128 0.110130 -0.018785 "
                                 "-0.038213 0.169665 -0.012413 "
                                 "-0.021532 0.173488 -0.021241 "
                                 "-0.008517 0.074198 -0.037653 "
                                 "-0.065608 0.066936 -0.007497 "
                                 "-0.050280 0.143741 0.000824 "
                                 "-0.011878 0.107304 -0.022095 "
                                 "-0.040535 0.159216 -0.011492 "
                                 "0.028230 0.071783 -0.022893 "
                                 "-0.021022 0.065418 -0.036655 "
                                 "0.010141 0.103018 -0.020770 "
                                 "-0.051433 0.067108 -0.012491 "
                                 "-0.049160 0.160603 -0.005985 "
                                 "0.028264 0.073195 -0.022943 "
                                 "-0.015261 0.076268 -0.038966 "
                                 "-0.034533 0.064421 -0.014132 "
                                 "-0.043908 0.067784 -0.016159 "
                                 "-0.069183 0.153837 -0.049560 "
                                 "0.024869 0.084767 -0.024560 "
                                 "-0.000856 0.103081 -0.022665 "
                                 "-0.001863 0.103074 -0.022753 "
                                 "-0.059077 0.069973 -0.015104 "
                                 "-0.012182 0.178673 -0.029235 "
                                 "-0.012881 0.107288 -0.021846 "
                                 "-0.047615 0.037865 -0.012539 "
                                 "-0.067038 0.155239 -0.051934 "
                                 "-0.041303 0.084378 -0.021267 "
                                 "0.000115 0.110154 -0.020162 "
                                 "-0.021633 0.035044 -0.028053 "
                                 "-0.045200 0.165138 -0.008331 "
                                 "-0.069516 0.075346 -0.014957 "
                                 "-0.076657 0.075864 -0.007819 "
                                 "-0.067246 0.173921 -0.058281 "
                                 "-0.046064 0.151688 -0.005548 "
                                 "-0.016173 0.168253 -0.021040 "
                                 "0.008721 0.073259 -0.033724 "
                                 "0.005912 0.084442 -0.033198 "
                                 "-0.026776 0.036519 0.053822 "
                                 "-0.027674 0.086866 -0.036187 "
                                 "0.034221 0.081361 -0.018238 "
                                 "0.030238 0.081488 -0.020170 "
                                 "0.025200 0.081800 -0.024570 "
                                 "0.014356 0.076788 -0.030104 "
                                 "-0.064199 0.163840 -0.059407 "
                                 "-0.080908 0.111715 -0.000772 "
                                 "0.014113 0.087083 -0.030146 "
                                 "-0.074816 0.084473 -0.015099 "
                                 "-0.074011 0.141343 -0.006888 "
                                 "-0.076411 0.094841 -0.013406 "
                                 "-0.077868 0.101964 -0.009289 "
                                 "-0.068244 0.179461 -0.058921 "
                                 "-0.002226 0.083034 -0.037089 "
                                 "-0.022749 0.077591 -0.039002 "
                                 "-0.055926 0.079634 -0.020972 "
                                 "-0.065841 0.083605 -0.018912 "
                                 "-0.064292 0.168172 -0.060588 "
                                 "-0.075004 0.141334 -0.006491 "
                                 "-0.015214 0.091053 -0.037504 "
                                 "-0.054630 0.152755 -0.002679 "
                                 "0.033230 0.087092 -0.018683 "
                                 "0.011114 0.110132 -0.019128 "
                                 "-0.075927 0.125275 -0.008277 "
                                 "-0.015831 0.088312 -0.038067 "
                                 "-0.018345 0.033731 -0.026079 "
                                 "0.004456 0.033966 -0.021007 "
                                 "-0.003268 0.034370 -0.017376 "
                                 "0.011950 0.034304 -0.011204 "
                                 "-0.045950 0.035101 -0.022412 "
                                 "-0.031721 0.033828 -0.021186 "
                                 "0.007540 0.038802 -0.009431 "
                                 "-0.080480 0.114080 0.047569 "
                                 "-0.004172 0.039154 -0.014111 "
                                 "-0.032684 0.038589 -0.016529 "
                                 "-0.051977 0.034100 -0.013438 "
                                 "0.032543 0.038050 0.000016 "
                                 "0.033741 0.038472 -0.000065 "
                                 "-0.039195 0.034033 -0.015253 "
                                 "-0.073604 0.148628 -0.025599 "
                                 "0.007509 0.034411 0.004670 "
                                 "0.025586 0.034909 0.002751 "
                                 "-0.062356 0.033753 -0.009695 "
                                 "-0.042372 0.033809 -0.003477 "
                                 "0.017120 0.034271 0.001954 "
                                 "-0.059944 0.033627 -0.010153 "
                                 "-0.038120 0.038250 -0.006977 "
                                 "-0.004094 0.038391 0.008568 "
                                 "0.025074 0.034411 0.011174 "
                                 "0.044118 0.040892 0.004384 "
                                 "-0.048695 0.033571 -0.013389 "
                                 "-0.022206 0.038690 -0.017188 "
                                 "0.002026 0.034165 0.004107 "
                                 "-0.079652 0.070444 0.015237 "
                                 "0.048793 0.042901 0.011011 "
                                 "-0.089979 0.116378 0.044138 "
                                 "-0.069850 0.033539 0.004727 "
                                 "-0.029039 0.038221 0.002720 "
                                 "-0.069196 0.034579 -0.006020 "
                                 "0.005046 0.034177 0.015760 "
                                 "0.034111 0.035601 0.011664 "
                                 "-0.086781 0.115997 0.046920 "
                                 "0.002619 0.034323 0.019675 "
                                 "-0.051528 0.033550 0.007814 "
                                 "-0.034901 0.033747 0.010379 "
                                 "-0.030015 0.034351 0.018172 "
                                 "-0.027929 0.037711 0.020035 "
                                 "-0.072159 0.034912 0.007119 "
                                 "0.019617 0.034742 0.021397 "
                                 "-0.071684 0.035136 0.008802 "
                                 "-0.071483 0.036208 0.009431 "
                                 "-0.000694 0.038513 0.021743 "
                                 "0.048576 0.046442 0.024984 "
                                 "0.022319 0.035282 0.024092 "
                                 "0.034684 0.038735 0.024611 "
                                 "-0.070531 0.151779 -0.045373 "
                                 "-0.066422 0.035267 0.015055 "
                                 "-0.062077 0.034516 0.020294 "
                                 "-0.063971 0.034365 0.016456 "
                                 "-0.081219 0.078592 0.029019 "
                                 "-0.051600 0.066088 0.036174 "
                                 "0.031905 0.043740 0.029538 "
                                 "-0.063341 0.035770 0.018750 "
                                 "-0.004483 0.039218 0.035614 "
                                 "-0.082655 0.076999 0.021106 "
                                 "-0.055121 0.034056 0.024036 "
                                 "0.009041 0.035141 0.035926 "
                                 "0.012972 0.034672 0.029418 "
                                 "-0.070622 0.146831 -0.025571 "
                                 "-0.090089 0.112403 0.037453 "
                                 "-0.066997 0.062934 -0.001956 "
                                 "-0.035388 0.034596 0.034245 "
                                 "0.007859 0.039240 0.030372 "
                                 "-0.071388 0.147097 -0.026896 "
                                 "-0.078147 0.116431 0.050321 "
                                 "-0.070936 0.078069 0.038683 "
                                 "-0.075074 0.077317 0.034901 "
                                 "-0.016213 0.038057 0.016945 "
                                 "-0.006919 0.034711 0.042546 "
                                 "-0.050487 0.064658 0.035198 "
                                 "-0.064600 0.034724 0.026530 "
                                 "-0.031802 0.037839 0.032183 "
                                 "0.004891 0.034575 0.043617 "
                                 "-0.084324 0.077527 0.016962 "
                                 "-0.091292 0.116401 0.042037 "
                                 "-0.069946 0.064187 0.001256 "
                                 "-0.073267 0.148476 -0.029258 "
                                 "-0.084864 0.078984 0.019130 "
                                 "-0.069386 0.061033 0.009766 "
                                 "-0.036723 0.034210 0.026670 "
                                 "-0.024903 0.039047 0.038063 "
                                 "0.014685 0.037467 0.044223 "
                                 "-0.079247 0.080308 0.033239 "
                                 "-0.082419 0.078886 0.026767 "
                                 "-0.091014 0.114490 0.034742 "
                                 "-0.066996 0.034958 0.031010 "
                                 "-0.067902 0.146313 -0.025723 "
                                 "-0.053202 0.073352 0.041234 "
                                 "-0.037419 0.034781 0.041799 "
                                 "-0.012835 0.035252 0.050222 "
                                 "0.009197 0.039194 0.045161 "
                                 "-0.082296 0.077332 0.022849 "
                                 "-0.061775 0.065542 0.032955 "
                                 "-0.074682 0.066385 0.006255 "
                                 "-0.051757 0.056601 0.019874 "
                                 "-0.046877 0.035027 0.045407 "
                                 "-0.070681 0.109318 0.037859 "
                                 "-0.075092 0.066454 0.007232 "
                                 "-0.074437 0.065821 0.007911 "
                                 "0.004325 0.035606 0.045888 "
                                 "-0.089199 0.115860 0.044703 "
                                 "-0.066365 0.036009 0.037225 "
                                 "-0.038999 0.036125 0.042901 "
                                 "-0.072850 0.107163 0.037442 "
                                 "-0.076428 0.117143 0.051891 "
                                 "-0.079737 0.071741 0.005181 "
                                 "-0.084462 0.111705 0.028857 "
                                 "-0.060273 0.034788 0.045444 "
                                 "-0.030763 0.035297 0.052008 "
                                 "-0.082857 0.076402 0.018249 "
                                 "-0.074827 0.110670 0.046334 "
                                 "-0.079080 0.070406 0.008268 "
                                 "-0.076864 0.067957 0.011082 "
                                 "-0.069649 0.061738 0.018026 "
                                 "-0.058329 0.059742 0.021921 "
                                 "-0.075934 0.078899 0.035147 "
                                 "-0.065150 0.036692 0.040216 "
                                 "-0.069152 0.078835 0.040145 "
                                 "-0.035996 0.151076 -0.002026 "
                                 "-0.063069 0.150547 -0.026594 "
                                 "-0.069062 0.149033 -0.037134 "
                                 "-0.062215 0.166391 -0.060509 "
                                 "-0.062798 0.167240 -0.060784 "
                                 "-0.039381 0.154717 -0.008957 "
                                 "-0.049932 0.141822 0.003858 "
                                 "-0.064944 0.157314 -0.054480 "
                                 "-0.069406 0.153071 -0.048274 "
                                 "-0.044493 0.149423 -0.004750 "
                                 "-0.056918 0.136838 -0.005280 "
                                 "-0.064125 0.156393 -0.043120 "
                                 "-0.071932 0.149607 -0.039423 "
                                 "-0.009322 0.175020 -0.028678 "
                                 "-0.060545 0.169731 -0.062221 "
                                 "-0.068381 0.149044 -0.036363 "
                                 "-0.050757 0.137975 0.001565 "
                                 "-0.027652 0.155350 -0.003855 "
                                 "-0.027938 0.155215 -0.003967 "
                                 "-0.026306 0.157004 -0.009894 "
                                 "-0.028940 0.154865 -0.002858 "
                                 "-0.009716 0.176357 -0.030374 "
                                 "-0.008588 0.169530 -0.025410 "
                                 "-0.067979 0.154919 -0.051359 "
                                 "-0.018495 0.165075 -0.017689 "
                                 "-0.013589 0.169514 -0.023467 "
                                 "-0.009085 0.173025 -0.027717 "
                                 "-0.066223 0.155560 -0.052081 "
                                 "-0.029333 0.154386 -0.003606 "
                                 "-0.063933 0.153712 -0.036871 "
                                 "-0.028864 0.154571 -0.003558 "
                                 "-0.064135 0.160881 -0.057617 "
                                 "-0.072553 0.150608 -0.041367 "
                                 "-0.030385 0.154168 -0.002474 "
                                 "-0.009715 0.177216 -0.029461 "
                                 "-0.014691 0.160456 -0.011333 "
                                 "-0.063650 0.159498 -0.051954 "
                                 "-0.072177 0.146332 -0.024671 "
                                 "-0.020377 0.158233 -0.007259 "
                                 "-0.062349 0.141045 -0.006499 "
                                 "-0.064196 0.142314 -0.007840 "
                                 "-0.068829 0.148429 -0.034137 "
                                 "-0.067194 0.151677 -0.045577 "
                                 "-0.071411 0.144356 -0.015185 "
                                 "-0.009825 0.166960 -0.022046 "
                                 "-0.052896 0.143026 -0.000456 "
                                 "-0.032692 0.152804 -0.002950 "
                                 "-0.072038 0.149669 -0.039594 "
                                 "-0.072282 0.143895 -0.012909 ";

bool samePoints(const vpPoint &pt1, const vpPoint &pt2)
{
  return vpMath::equal(pt1.get_oX(), pt2.get_oX(), std::numeric_limits<double>::epsilon()) &&
         vpMath::equal(pt1.get_oY(), pt2.get_oY(), std::numeric_limits<double>::epsilon()) &&
         vpMath::equal(pt1.get_oZ(), pt2.get_oZ(), std::numeric_limits<double>::epsilon()) &&
         vpMath::equal(pt1.get_x(), pt2.get_x(), std::numeric_limits<double>::epsilon()) &&
         vpMath::equal(pt1.get_y(), pt2.get_y(), std::numeric_limits<double>::epsilon());
}

int checkInlierIndex(const std::vector<unsigned int> &vectorOfFoundInlierIndex,
                     const std::vector<bool> &vectorOfOutlierFlags)
{
  int nbInlierIndexOk = 0;

  for (std::vector<unsigned int>::const_iterator it = vectorOfFoundInlierIndex.begin();
       it != vectorOfFoundInlierIndex.end(); ++it) {
    if (!vectorOfOutlierFlags[*it]) {
      nbInlierIndexOk++;
    }
  }

  return nbInlierIndexOk;
}

bool checkInlierPoints(const std::vector<vpPoint> &vectorOfFoundInlierPoints,
                       const std::vector<unsigned int> &vectorOfFoundInlierIndex,
                       const std::vector<vpPoint> &bunnyModelPoints_noisy)
{
  for (size_t i = 0; i < vectorOfFoundInlierPoints.size(); i++) {
    if (!samePoints(vectorOfFoundInlierPoints[i], bunnyModelPoints_noisy[vectorOfFoundInlierIndex[i]])) {
      std::cerr << "Problem with the inlier index and the corresponding "
                   "inlier point !"
                << std::endl;
      return false;
    }
  }

  return true;
}

void readBunnyModelPoints(std::vector<vpPoint> &bunnyModelPoints, std::vector<vpPoint> &bunnyModelPoints_noisy)
{
  // Read the string
  std::istringstream iss_file_content(file_content);

  //  vpTranslationVector translation(-0.1, 0.15, 1.0);
  vpTranslationVector translation(-0.14568, 0.154567, 1.4462);
  //  vpRzyxVector zyxVector(vpMath::rad(10.0f), vpMath::rad(-15.0f),
  //  vpMath::rad(38.0f));
  vpRzyxVector zyxVector(vpMath::rad(12.4146f), vpMath::rad(-75.5478f), vpMath::rad(138.5607f));
  vpThetaUVector thetau(zyxVector);

  vpHomogeneousMatrix cMo_groundTruth(translation, thetau);

  vpGaussRand gaussian_noise(0.0002, 0.0 /*, time(NULL)*/);
  while (iss_file_content) {
    double oX, oY, oZ;
    iss_file_content >> oX >> oY >> oZ;

    vpPoint pt(oX, oY, oZ);
    pt.project(cMo_groundTruth);
    bunnyModelPoints.push_back(pt);

    // Add a small gaussian noise to data to be a little more realistic
    pt.set_x(pt.get_x() + gaussian_noise());
    pt.set_y(pt.get_y() + gaussian_noise());
    bunnyModelPoints_noisy.push_back(pt);
  }

  // Print the number of model points
  std::cout << "The raw model contains " << bunnyModelPoints.size() << " points." << std::endl;
  std::cout << "cMo_groundTruth=\n" << cMo_groundTruth << std::endl << std::endl;
}

bool testRansac(const std::vector<vpPoint> &bunnyModelPoints_original,
                const std::vector<vpPoint> &bunnyModelPoints_noisy_original, const size_t nb_model_points,
                const bool test_duplicate, const bool test_degenerate)
{
  std::vector<vpPoint> bunnyModelPoints = bunnyModelPoints_original;
  std::vector<vpPoint> bunnyModelPoints_noisy = bunnyModelPoints_noisy_original;
  // Resize
  if (nb_model_points > 0) {
    bunnyModelPoints.resize(nb_model_points);
    bunnyModelPoints_noisy.resize(nb_model_points);
  }

  vpPose ground_truth_pose, real_pose;
  ground_truth_pose.addPoints(bunnyModelPoints);
  real_pose.addPoints(bunnyModelPoints_noisy);

  vpHomogeneousMatrix cMo_dementhon, cMo_lagrange;
  real_pose.computePose(vpPose::DEMENTHON, cMo_dementhon);
  real_pose.computePose(vpPose::LAGRANGE, cMo_lagrange);
  double r_dementhon = real_pose.computeResidual(cMo_dementhon);
  double r_lagrange = real_pose.computeResidual(cMo_lagrange);

  vpHomogeneousMatrix cMo_estimated;
  if (r_lagrange < r_dementhon) {
    cMo_estimated = cMo_lagrange;
  } else {
    cMo_estimated = cMo_dementhon;
  }
  real_pose.computePose(vpPose::VIRTUAL_VS, cMo_estimated);
  double r_vvs = ground_truth_pose.computeResidual(cMo_estimated);

  std::cout << "\ncMo estimated using VVS on data with small gaussian noise:\n" << cMo_estimated << std::endl;
  std::cout << "Corresponding residual: " << r_vvs << std::endl;

  size_t nbOutliers = (size_t)(0.35 * bunnyModelPoints_noisy.size());
  vpGaussRand noise(0.01, 0.008 /*, time(NULL)*/);
  // Vector that indicates if the point is an outlier or not
  std::vector<bool> vectorOfOutlierFlags(bunnyModelPoints_noisy.size(), false);
  // Generate outliers points
  for (size_t i = 0; i < nbOutliers; i++) {
    bunnyModelPoints_noisy[i].set_x(bunnyModelPoints_noisy[i].get_x() + noise());
    bunnyModelPoints_noisy[i].set_y(bunnyModelPoints_noisy[i].get_y() + noise());
    vectorOfOutlierFlags[i] = true;
  }

  if (test_duplicate) {
    // Add some duplicate points
    size_t nbDuplicatePoints = 100;
    for (size_t i = 0; i < nbDuplicatePoints; i++) {
      size_t index = (size_t)rand() % bunnyModelPoints_noisy.size();
      vpPoint duplicatePoint = bunnyModelPoints_noisy[index];
      bunnyModelPoints_noisy.push_back(duplicatePoint);
      vectorOfOutlierFlags.push_back(true);
    }
  }

  if (test_degenerate) {
    // Add some degenerate points
    size_t nbDegeneratePoints = 100;
    double degenerate_tolerence = 9.999e-7; // 1e-6 is used in the code to
                                            // detect if a point is degenerate
                                            // or not
    std::vector<vpPoint> listOfDegeneratePoints;
    for (size_t i = 0; i < nbDegeneratePoints; i++) {
      size_t index = (size_t)rand() % bunnyModelPoints_noisy.size();
      vpPoint degeneratePoint = bunnyModelPoints_noisy[index];

      // Object point is degenerate
      degeneratePoint.set_oX(degeneratePoint.get_oX() + degenerate_tolerence);
      degeneratePoint.set_oY(degeneratePoint.get_oY() + degenerate_tolerence);
      degeneratePoint.set_oZ(degeneratePoint.get_oZ() - degenerate_tolerence);

      // Add duplicate 3D points
      listOfDegeneratePoints.push_back(degeneratePoint);

      // Image point is degenerate
      index = (size_t)rand() % bunnyModelPoints_noisy.size();
      degeneratePoint = bunnyModelPoints_noisy[index];

      degeneratePoint.set_x(degeneratePoint.get_x() + degenerate_tolerence);
      degeneratePoint.set_y(degeneratePoint.get_y() - degenerate_tolerence);

      // Add duplicate 2D points
      listOfDegeneratePoints.push_back(degeneratePoint);
    }

    for (std::vector<vpPoint>::const_iterator it_degenerate = listOfDegeneratePoints.begin();
         it_degenerate != listOfDegeneratePoints.end(); ++it_degenerate) {
      bunnyModelPoints_noisy.push_back(*it_degenerate);
      vectorOfOutlierFlags.push_back(true);
    }
  }

  // Shuffle the data vector
  std::vector<size_t> vectorOfIndex(bunnyModelPoints_noisy.size());
  for (size_t i = 0; i < vectorOfIndex.size(); i++) {
    vectorOfIndex[i] = i;
  }
  std::random_shuffle(vectorOfIndex.begin(), vectorOfIndex.end());

  std::vector<vpPoint> bunnyModelPoints_noisy_tmp = bunnyModelPoints_noisy;
  bunnyModelPoints_noisy.clear();
  std::vector<bool> vectorOfOutlierFlags_tmp = vectorOfOutlierFlags;
  vectorOfOutlierFlags.clear();
  for (std::vector<size_t>::const_iterator it = vectorOfIndex.begin(); it != vectorOfIndex.end(); ++it) {
    bunnyModelPoints_noisy.push_back(bunnyModelPoints_noisy_tmp[*it]);
    vectorOfOutlierFlags.push_back(vectorOfOutlierFlags_tmp[*it]);
  }

  // Add data to vpPose
  vpPose pose;
  vpPose pose_ransac, pose_ransac2;

#if defined(VISP_HAVE_PTHREAD) || (defined(_WIN32) && !defined(WINRT_8_0)) || defined(VISP_HAVE_OPENMP)
#define TEST_PARALLEL_RANSAC
#endif

  std::string appveyor_threading = "";
  try {
    appveyor_threading = vpIoTools::getenv("APPVEYOR_THREADING");
  } catch (...) {
  }

#ifdef TEST_PARALLEL_RANSAC
  vpPose pose_ransac_parallel, pose_ransac_parallel2;
  if (appveyor_threading == "true") {
    pose_ransac_parallel.setUseParallelRansac(true);
    pose_ransac_parallel2.setUseParallelRansac(true);

    pose_ransac_parallel.setRansacFilterFlags(vpPose::PREFILTER_DUPLICATE_POINTS + vpPose::CHECK_DEGENERATE_POINTS);
    pose_ransac_parallel2.setRansacFilterFlags(vpPose::PREFILTER_DUPLICATE_POINTS + vpPose::CHECK_DEGENERATE_POINTS);

#if !defined(VISP_HAVE_OPENMP)
    pose_ransac_parallel.setNbParallelRansacThreads(2);
    pose_ransac_parallel2.setNbParallelRansacThreads(2);
#endif
  }
#endif
  pose_ransac.setRansacFilterFlags(vpPose::PREFILTER_DUPLICATE_POINTS + vpPose::CHECK_DEGENERATE_POINTS);
  pose_ransac2.setRansacFilterFlags(vpPose::PREFILTER_DUPLICATE_POINTS + vpPose::CHECK_DEGENERATE_POINTS);
  for (std::vector<vpPoint>::const_iterator it = bunnyModelPoints_noisy.begin(); it != bunnyModelPoints_noisy.end();
       ++it) {
    pose.addPoint(*it);
  }
  // Test addPoints
  pose_ransac.addPoints(bunnyModelPoints_noisy);
  pose_ransac2.addPoints(bunnyModelPoints_noisy);
#ifdef TEST_PARALLEL_RANSAC
  if (appveyor_threading == "true") {
    pose_ransac_parallel.addPoints(bunnyModelPoints_noisy);
    pose_ransac_parallel2.addPoints(bunnyModelPoints_noisy);
  }
#endif

  // Print the number of points in the final data vector
  std::cout << "\nNumber of model points in the noisy data vector: " << bunnyModelPoints_noisy.size() << " points."
            << std::endl
            << std::endl;

  unsigned int nbInlierToReachConsensus = (unsigned int)(60.0 * (double)(bunnyModelPoints_noisy.size()) / 100.0);
  double threshold = 0.001;

  // RANSAC with 1000 iterations
  pose_ransac.setRansacNbInliersToReachConsensus(nbInlierToReachConsensus);
  pose_ransac.setRansacThreshold(threshold);
  pose_ransac.setRansacMaxTrials(1000);
#ifdef TEST_PARALLEL_RANSAC
  if (appveyor_threading == "true") {
    pose_ransac_parallel.setRansacNbInliersToReachConsensus(nbInlierToReachConsensus);
    pose_ransac_parallel.setRansacThreshold(threshold);
    pose_ransac_parallel.setRansacMaxTrials(1000);

    pose_ransac_parallel2.setRansacNbInliersToReachConsensus(nbInlierToReachConsensus);
    pose_ransac_parallel2.setRansacThreshold(threshold);
    pose_ransac_parallel2.setRansacMaxTrials(vpPose::computeRansacIterations(0.99, 0.4, 4, -1));
  }
#endif

  // RANSAC with p=0.99, epsilon=0.4
  pose_ransac2.setRansacNbInliersToReachConsensus(nbInlierToReachConsensus);
  pose_ransac2.setRansacThreshold(threshold);
  int ransac_iterations = vpPose::computeRansacIterations(0.99, 0.4, 4, -1);
  pose_ransac2.setRansacMaxTrials(ransac_iterations);
  std::cout << "Number of RANSAC iterations to ensure p=0.99 and epsilon=0.4: " << ransac_iterations << std::endl;

  vpHomogeneousMatrix cMo_estimated_RANSAC;
  double t_RANSAC = vpTime::measureTimeMs();
  pose_ransac.computePose(vpPose::RANSAC, cMo_estimated_RANSAC);
  t_RANSAC = vpTime::measureTimeMs() - t_RANSAC;

  std::cout << "\ncMo estimated with RANSAC (1000 iterations) on noisy data:\n" << cMo_estimated_RANSAC << std::endl;
  std::cout << "Computation time: " << t_RANSAC << " ms" << std::endl;

  double r_RANSAC_estimated = ground_truth_pose.computeResidual(cMo_estimated_RANSAC);
  std::cout << "Corresponding residual (1000 iterations): " << r_RANSAC_estimated << std::endl;

  vpHomogeneousMatrix cMo_estimated_RANSAC_2;
  t_RANSAC = vpTime::measureTimeMs();
  pose_ransac2.computePose(vpPose::RANSAC, cMo_estimated_RANSAC_2);
  t_RANSAC = vpTime::measureTimeMs() - t_RANSAC;

  std::cout << "\ncMo estimated with RANSAC (" << ransac_iterations << " iterations) on noisy data:\n"
            << cMo_estimated_RANSAC_2 << std::endl;
  std::cout << "Computation time: " << t_RANSAC << " ms" << std::endl;

  double r_RANSAC_estimated_2 = ground_truth_pose.computeResidual(cMo_estimated_RANSAC_2);
  std::cout << "Corresponding residual (" << ransac_iterations << " iterations): " << r_RANSAC_estimated_2 << std::endl;

  pose.computePose(vpPose::DEMENTHON, cMo_dementhon);
  pose.computePose(vpPose::LAGRANGE, cMo_lagrange);
  r_dementhon = pose.computeResidual(cMo_dementhon);
  r_lagrange = pose.computeResidual(cMo_lagrange);

  if (r_lagrange < r_dementhon) {
    cMo_estimated = cMo_lagrange;
  } else {
    cMo_estimated = cMo_dementhon;
  }

  pose.computePose(vpPose::VIRTUAL_VS, cMo_estimated);
  std::cout << "\ncMo estimated with only VVS on noisy data:\n" << cMo_estimated << std::endl;

  double r_estimated = ground_truth_pose.computeResidual(cMo_estimated);
  std::cout << "Corresponding residual: " << r_estimated << std::endl;

#ifdef TEST_PARALLEL_RANSAC
  double r_RANSAC_estimated_parallel = std::numeric_limits<double>::max();
  if (appveyor_threading == "true") {
    vpHomogeneousMatrix cMo_estimated_RANSAC_parallel;
    double t_RANSAC_parallel = vpTime::measureTimeMs();
    pose_ransac_parallel.computePose(vpPose::RANSAC, cMo_estimated_RANSAC_parallel);
    t_RANSAC_parallel = vpTime::measureTimeMs() - t_RANSAC_parallel;

    std::cout << "\ncMo estimated with parallel RANSAC (1000 iterations) on "
                 "noisy data:\n"
              << cMo_estimated_RANSAC_parallel << std::endl;
    std::cout << "Computation time: " << t_RANSAC_parallel << " ms" << std::endl;

    r_RANSAC_estimated_parallel = ground_truth_pose.computeResidual(cMo_estimated_RANSAC_parallel);
    std::cout << "Corresponding residual (1000 iterations): " << r_RANSAC_estimated_parallel << std::endl;

    vpHomogeneousMatrix cMo_estimated_RANSAC_parallel2;
    double t_RANSAC_parallel2 = vpTime::measureTimeMs();
    pose_ransac_parallel2.computePose(vpPose::RANSAC, cMo_estimated_RANSAC_parallel2);
    t_RANSAC_parallel2 = vpTime::measureTimeMs() - t_RANSAC_parallel2;

    std::cout << "\ncMo estimated with parallel RANSAC (" << ransac_iterations << " iterations) on noisy data:\n"
              << cMo_estimated_RANSAC_parallel2 << std::endl;
    std::cout << "Computation time: " << t_RANSAC_parallel2 << " ms" << std::endl;

    double r_RANSAC_estimated_parallel2 = ground_truth_pose.computeResidual(cMo_estimated_RANSAC_parallel2);
    std::cout << "Corresponding residual (" << ransac_iterations << " iterations): " << r_RANSAC_estimated_parallel2
              << std::endl;
  }
#endif

  // Check inlier index
  std::vector<unsigned int> vectorOfFoundInlierIndex = pose_ransac.getRansacInlierIndex();
  int nbInlierIndexOk = checkInlierIndex(vectorOfFoundInlierIndex, vectorOfOutlierFlags);

  int nbTrueInlierIndex = (int)std::count(vectorOfOutlierFlags.begin(), vectorOfOutlierFlags.end(), false);
  std::cout << "\nThere are " << nbInlierIndexOk << " true inliers found, " << vectorOfFoundInlierIndex.size()
            << " inliers returned and " << nbTrueInlierIndex << " true inliers." << std::endl;

  // Check inlier points returned
  std::vector<vpPoint> vectorOfFoundInlierPoints = pose_ransac.getRansacInliers();

  if (vectorOfFoundInlierPoints.size() != vectorOfFoundInlierIndex.size()) {
    std::cerr << "The number of inlier index is different with the number of "
                 "inlier points !"
              << std::endl;
    return false;
  }
  if (!checkInlierPoints(vectorOfFoundInlierPoints, vectorOfFoundInlierIndex, bunnyModelPoints_noisy)) {
    return false;
  }

  // Check for RANSAC with p=0.99, epsilon=0.4
  // Check inlier index
  std::cout << "\nCheck for RANSAC iterations: " << ransac_iterations << std::endl;
  std::vector<unsigned int> vectorOfFoundInlierIndex_2 = pose_ransac2.getRansacInlierIndex();
  nbInlierIndexOk = checkInlierIndex(vectorOfFoundInlierIndex_2, vectorOfOutlierFlags);

  std::cout << "There are " << nbInlierIndexOk << " true inliers found, " << vectorOfFoundInlierIndex_2.size()
            << " inliers returned and " << nbTrueInlierIndex << " true inliers." << std::endl;

  // Check inlier points returned
  std::vector<vpPoint> vectorOfFoundInlierPoints_2 = pose_ransac2.getRansacInliers();
  if (vectorOfFoundInlierPoints_2.size() != vectorOfFoundInlierIndex_2.size()) {
    std::cerr << "The number of inlier index is different with the number of "
                 "inlier points !"
              << std::endl;
    return false;
  }
  if (!checkInlierPoints(vectorOfFoundInlierPoints_2, vectorOfFoundInlierIndex_2, bunnyModelPoints_noisy)) {
    return false;
  }

#ifdef TEST_PARALLEL_RANSAC
  if (appveyor_threading == "true") {
    // Check for parallel RANSAC
    // Check inlier index
    std::cout << "\nCheck for parallel RANSAC (1000 iterations)" << std::endl;
    std::vector<unsigned int> vectorOfFoundInlierIndex_parallel = pose_ransac_parallel.getRansacInlierIndex();
    nbInlierIndexOk = checkInlierIndex(vectorOfFoundInlierIndex_parallel, vectorOfOutlierFlags);

    std::cout << "There are " << nbInlierIndexOk << " true inliers found, " << vectorOfFoundInlierIndex_parallel.size()
              << " inliers returned and " << nbTrueInlierIndex << " true inliers." << std::endl;

    // Check inlier points returned
    std::vector<vpPoint> vectorOfFoundInlierPoints_parallel = pose_ransac_parallel.getRansacInliers();
    if (vectorOfFoundInlierPoints_parallel.size() != vectorOfFoundInlierIndex_parallel.size()) {
      std::cerr << "The number of inlier index is different with the number "
                   "of inlier points !"
                << std::endl;
      return false;
    }
    if (!checkInlierPoints(vectorOfFoundInlierPoints_parallel, vectorOfFoundInlierIndex_parallel,
                           bunnyModelPoints_noisy)) {
      return false;
    }

    // Check for parallel RANSAC 2
    // Check inlier index
    std::cout << "\nCheck for parallel RANSAC (" << ransac_iterations << " iterations)" << std::endl;
    std::vector<unsigned int> vectorOfFoundInlierIndex_parallel2 = pose_ransac_parallel2.getRansacInlierIndex();
    nbInlierIndexOk = checkInlierIndex(vectorOfFoundInlierIndex_parallel2, vectorOfOutlierFlags);

    std::cout << "There are " << nbInlierIndexOk << " true inliers found, " << vectorOfFoundInlierIndex_parallel2.size()
              << " inliers returned and " << nbTrueInlierIndex << " true inliers." << std::endl;

    // Check inlier points returned
    std::vector<vpPoint> vectorOfFoundInlierPoints_parallel2 = pose_ransac_parallel2.getRansacInliers();
    if (vectorOfFoundInlierPoints_parallel2.size() != vectorOfFoundInlierIndex_parallel2.size()) {
      std::cerr << "The number of inlier index is different with the number "
                   "of inlier points !"
                << std::endl;
      return false;
    }
    if (!checkInlierPoints(vectorOfFoundInlierPoints_parallel2, vectorOfFoundInlierIndex_parallel2,
                           bunnyModelPoints_noisy)) {
      return false;
    }
  }
#endif

  if (r_RANSAC_estimated > threshold /*|| r_RANSAC_estimated_2 > threshold*/) {
    std::cerr << "The pose estimated with the RANSAC method is badly estimated!" << std::endl;
    std::cerr << "r_RANSAC_estimated=" << r_RANSAC_estimated << std::endl;
    std::cerr << "threshold=" << threshold << std::endl;
    return false;
  } else {
#ifdef TEST_PARALLEL_RANSAC
    if (appveyor_threading == "true") {
      if (r_RANSAC_estimated_parallel > threshold) {
        std::cerr << "The pose estimated with the parallel RANSAC method is "
                     "badly estimated!"
                  << std::endl;
        std::cerr << "r_RANSAC_estimated_parallel=" << r_RANSAC_estimated_parallel << std::endl;
        std::cerr << "threshold=" << threshold << std::endl;
        return false;
      }
    }
#endif
    std::cout << "The pose estimated with the RANSAC method is well estimated!" << std::endl;
  }

  return true;
}

/*!
  \example testPoseRansac2.cpp

  Compute the pose of a 3D object using the Ransac method.
*/
int main()
{
  // vpPose::computeRansacIterations
  int sample_sizes[] = {2, 3, 4, 5, 6, 7, 8};
  double epsilon[] = {0.05, 0.1, 0.2, 0.25, 0.3, 0.4, 0.5};

  // Format output
  std::cout << "       ";
  for (int cpt2 = 0; cpt2 < 7; cpt2++) {
    std::cout << std::setfill(' ') << std::setw(5) << epsilon[cpt2] << " ";
  }
  std::cout << std::endl;

  std::cout << std::setfill(' ') << std::setw(7) << "+";
  for (int cpt2 = 0; cpt2 < 6; cpt2++) {
    std::cout << std::setw(7) << "-------";
  }
  std::cout << std::endl;

  for (int cpt1 = 0; cpt1 < 7; cpt1++) {
    std::cout << std::setfill(' ') << std::setw(6) << sample_sizes[cpt1] << "|";

    for (int cpt2 = 0; cpt2 < 7; cpt2++) {
      int ransac_iters = vpPose::computeRansacIterations(0.99, epsilon[cpt2], sample_sizes[cpt1], -1);
      std::cout << std::setfill(' ') << std::setw(6) << ransac_iters;
    }
    std::cout << std::endl;
  }
  std::cout << std::endl;

  try {
    size_t model_sizes[] = {10, 20, 50, 100, 200, 500, 1000, 0, 0};
    bool duplicates[] = {false, false, false, false, false, false, false, false, true};
    bool degenerates[] = {false, false, false, false, false, false, true, true, true};
    int nb = 9;

    std::vector<vpPoint> bunnyModelPoints, bunnyModelPoints_noisy_original;
    readBunnyModelPoints(bunnyModelPoints, bunnyModelPoints_noisy_original);

    for (int cpt = 0; cpt < nb; cpt++) {
      std::cout << "\n\n====================================================="
                   "==============="
                << std::endl;
      if (model_sizes[cpt] == 0) {
        std::cout << "Test on " << bunnyModelPoints_noisy_original.size() << " model points." << std::endl;
      } else {
        std::cout << "Test on " << model_sizes[cpt] << " model points." << std::endl;
      }
      std::cout << "Test duplicate: " << duplicates[cpt] << " ; Test degenerate: " << degenerates[cpt] << std::endl;

      if (!testRansac(bunnyModelPoints, bunnyModelPoints_noisy_original, model_sizes[cpt], duplicates[cpt],
                      degenerates[cpt])) {
        return EXIT_FAILURE;
      }
    }

    std::cout << "\n\ntestPoseRansac2 is ok!" << std::endl;
    return EXIT_SUCCESS;
  } catch (vpException &e) {
    std::cout << "Catch an exception: " << e << std::endl;
    return EXIT_FAILURE;
  }
}
