/*
    sengine.h - search engines management for The WebDruid

    Copyright (C) 2003-2004  Fabien Chevalier (fabien@juliana-multimedia.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/

#define SE_MAXDNAME     63     /* search engine max diplay name length     */
#define SE_MAXDNSBEG    7      /* max dns beginning length                 */
#define SE_MAXDNSMID    31     /* max dns middle length                    */
#define SE_MAXDNSEXT    5      /* max dns extension length                 */
#define SE_MAXQTAG      6      /* max query tag (q=, p=, ...) type numbers */

/* structs */

struct snode {                        /* search string struct              */
   char         *string;              /* key phrase or key words           */
   struct list  *urls;                /* urls pointed to by these words    */
   u_long       count;
   struct snode *next;
};

typedef struct snode  *SNODEPTR;      /* Search string node pointer        */

struct sengine {
   const char  *display_name;         /* what the user will see            */
   u_long      count;
   SNODEPTR    *s_htab;               /* ...see above                      */
};

/* global variables */

extern struct sengine *sp_table;      /* search phrases table              */
extern int  n_sengines;               /* number of search engines in table */

/* exported functions */

extern int            sengine_find(char *hostname);
                                  /* find engine index given hostname     */

extern char           *sengine_search_phrase(int sengine_index, const char *srch_string);
                                  /* give search phrase                   */

extern int            sengine_parse(const char* filename);
                                  /* load list of engines from file       */

extern struct sengine *sengine_make_table();
                                  /* returns a sorted array of sengines   */

extern void           sengine_free_table(struct sengine *table[]);
                                  /* does what it says                    */

extern void           sengine_free_internal_table();
                                  /* must be called once before exit      */

extern int            sengine_add_search_phrase(char *sp,
                               char *url, u_long count,
                               struct sengine table[], int index);
                                  /* adds search phrase to given sengine
                                                                    table */

extern int            sengine_put_snode(char *sp,
                           char *url,
                           u_long count,
                           SNODEPTR *htab);
                                  /* puts search node in given htab       */
