#include <udposix.h>
#include <stddef.h>		/* for NULL */
#include <stdlib.h>		/* for getenv() */
#include <sys/types.h>		/* for <pwd.h> */
#include <pwd.h>		/* for getpw*() */


/*
 * Return the password data structure corresponding to the Unidata user.
 */
    const struct passwd*
getuduser()
{
    char		*logname;
    struct passwd	*pwent		= NULL;

    /*
     * `UDLOGNAME' is used in the following because `LOGNAME' is a
     * POSIX.1 standard.
     */
    if ((logname = getenv("UDLOGNAME")) != NULL)
	pwent	= getpwnam(logname);

    if (pwent == NULL) {
	int		iname;
	static char	*lognames[]	= {"unidata", "ldm", NULL};

	for (iname = 0; lognames[iname] != NULL; ++iname)
	    if ((pwent = getpwnam(lognames[iname])) != NULL)
		break;
    }

    return pwent;
}


/*
 * Return the installation prefix for Unidata software.
 */
    const char*
getudprefix()
{
    const char	*prefix	= getenv("UDPREFIX");

    if (prefix == NULL) {
	prefix	= getenv("UDHOME");
	if (prefix == NULL) {
	    const struct passwd	*pwent	= getuduser();

	    if (pwent == NULL) {
		prefix	= "";
	    } else {
		prefix	= pwent->pw_dir;
	    }
	}
    }

    return prefix;
}
