module optest(clk, mode, u1, s1, u2, s2, y);

input clk;
input [6:0] mode;

input [3:0] u1, u2;
input signed [3:0] s1, s2;

output reg [7:0] y;

always @(posedge clk) begin
	y <= 8'h42;
	case (mode)
		 0: y <= u1 << u2;
		 1: y <= u1 << s2;
		 2: y <= s1 << u2;
		 3: y <= s1 << s2;

		 4: y <= u1 >> u2;
		 5: y <= u1 >> s2;
		 6: y <= s1 >> u2;
		 7: y <= s1 >> s2;

		 8: y <= u1 <<< u2;
		 9: y <= u1 <<< s2;
		10: y <= s1 <<< u2;
		11: y <= s1 <<< s2;

		12: y <= u1 >>> u2;
		13: y <= u1 >>> s2;
		14: y <= s1 >>> u2;
		15: y <= s1 >>> s2;

		16: y <= u1 < u2;
		17: y <= u1 < s2;
		18: y <= s1 < u2;
		19: y <= s1 < s2;

		20: y <= u1 <= u2;
		21: y <= u1 <= s2;
		22: y <= s1 <= u2;
		23: y <= s1 <= s2;

		24: y <= u1 == u2;
		25: y <= u1 == s2;
		26: y <= s1 == u2;
		27: y <= s1 == s2;

		28: y <= u1 != u2;
		29: y <= u1 != s2;
		30: y <= s1 != u2;
		31: y <= s1 != s2;

		32: y <= u1 >= u2;
		33: y <= u1 >= s2;
		34: y <= s1 >= u2;
		35: y <= s1 >= s2;

		36: y <= u1 > u2;
		37: y <= u1 > s2;
		38: y <= s1 > u2;
		39: y <= s1 > s2;

		40: y <= u1 + u2;
		41: y <= u1 + s2;
		42: y <= s1 + u2;
		43: y <= s1 + s2;

		44: y <= u1 - u2;
		45: y <= u1 - s2;
		46: y <= s1 - u2;
		47: y <= s1 - s2;

		48: y <= u1 * u2;
		49: y <= u1 * s2;
		50: y <= s1 * u2;
		51: y <= s1 * s2;

		52: y <= u1 / u2;
		53: y <= u1 / s2;
		54: y <= s1 / u2;
		55: y <= s1 / s2;

		56: y <= u1 % u2;
		57: y <= u1 % s2;
		58: y <= s1 % u2;
		59: y <= s1 % s2;

		60: y <= 4'd2 ** u1;
		61: y <= 4'd2 ** s1;
		62: y <= 4'sd2 ** u1;
		63: y <= 4'sd2 ** s1;

		64: y <= +u1;
		65: y <= -u1;
		66: y <= ~u1;
		67: y <= !u1;

		68: y <= +s1;
		69: y <= -s1;
		70: y <= ~s1;
		71: y <= !s1;

		72: y <= { &u1, ~&u1, |u1, ~|u1, ^u1, ~^u1, ^~u1 };
		73: y <= { &s1, ~&s1, |s1, ~|s1, ^s1, ~^s1, ^~s1 };
		74: y <= { &u1[1:0], ~&u1[1:0], |u1[1:0], ~|u1[1:0], ^u1[1:0], ~^u1[1:0], ^~u1[1:0] };
		75: y <= { &s1[1:0], ~&s1[1:0], |s1[1:0], ~|s1[1:0], ^s1[1:0], ~^s1[1:0], ^~s1[1:0] };

		76: y <= { u1[1:0] && u2[1:0], u1[1:0] && u2[1:0], !u1[1:0] };
		77: y <= {4{u1[1:0]}};
		78: y <= {u1, u2} ^ {s1, s2};
		79: y <= {u1, u2} & {s1, s2};

		80: y <= u1[0] ? u1 : u2;
		81: y <= u1[0] ? u1 : s2;
		82: y <= u1[0] ? s1 : u2;
		83: y <= u1[0] ? s1 : s2;
	endcase
end

endmodule
