//
// Created by 张雪明 <zhangxueming@uniontech.com> on 2024/11/18.
//

#ifndef UOS_RECOVERY_MAIN_WINDOW_SNIPE_H
#define UOS_RECOVERY_MAIN_WINDOW_SNIPE_H

#include "interface/FrameProxyInterface.h"
#include "immutable/backup/ImmuBackupModule.h"
#include "immutable/restore/ImmuRestoreModule.h"
#include "immutable/factoryrestore/ImmuFactoryRestoreModule.h"
#include "advanced/AdvancedModule.h"
#include "common/LogDialog.h"
#include <DMainWindow>
#include <DButtonBox>
#include <DStackedWidget>
#include <DFrame>
#include <DDialog>
#include <DBackgroundGroup>
#include <QStack>
#include <QMap>
#include <QPair>
#include <QList>
#include <QStackedLayout>
#include <QWidget>
#include <DIconButton>
#include <DListView>
#include <DVerticalLine>
#include <QSplitter>

DCORE_USE_NAMESPACE
DGUI_USE_NAMESPACE
DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

class NavigationListView;

class MainWindowSnipe : public DMainWindow , public FrameProxyInterface {
    Q_OBJECT
public:
    explicit MainWindowSnipe(QWidget *parent = nullptr);

    ~MainWindowSnipe() override;

    void pushWidget(ModuleInterface *const inter, QWidget *const w) override;
    // 将窗口弹出出显示栈
    void popWidget() override;
    void popAllWidget() override;
    //将窗口弹出出显示栈并删除对象
    void popWidgetAndDelete() override;
    //显示上一步窗口
    void back() override;

    // 回退到主页
    void backHome() override;

    //返回按钮使能
    void enableBackWard(bool enable) override;
    //模块使能
    void enableModule(bool enable) override;
    // 设置模块可见
    void setModuleVisible(ModuleInterface *const inter, const bool visible) override;
    // 设置当前显示模块
    void setCurrentWidget(ModuleInterface *const inter, QWidget *const w) override;
    // 获取当前显示栈的索引
    ModuleInterface *getCurrentModule() override;

    void setMenuDisabled(bool disabled) override;
    void setQuitMenuDisabled(bool disabled) override;
    void setMenuActionEnabled(const QString &actionText, bool enabled) override;
    void setWindowFuncClose(bool enabled) override;

    void showSettingDialog() override;
    void showLogDialog() override;
    void showBackupFileManagerDialog() override;
    void ShowNewBackupPage();
    void ShowNewRestorePage();
    void ShowNewFactoryRestorePage();

protected:
    void closeEvent(QCloseEvent *event) override;

private:
    void initUI();
    void initNewUI();
    void updateSidebarSeparator();
    void updateSideBarSeparatorStyle();
    void updateSideBarSeparatorPosition();
    ErrorCode initRecoveryType();
    void navModuleClicked(int index);
    void updateTheme();

private Q_SLOTS:
    void initAllModule();
    void onItemChanged(bool checked);
    void onNewProcessInstance();
    void onBackWardClick();
    void ShowBackupPage();
    void ShowRestorePage();
    void ShowFactoryRestorePage();

private:
    ComDeepinDaemonUosrecoveryInterface *m_interface = nullptr;
    QHBoxLayout *m_centralLayout = nullptr;
    //DTK_WIDGET_NAMESPACE::DBackgroundGroup *m_rightView = nullptr;
    QFrame *m_rightView = nullptr;
    QStandardItemModel *m_navModel = nullptr;
    QWidget *m_titleWidget = nullptr;
    DIconButton *m_backwardBtn = nullptr;
    NavigationListView *m_leftNavView = nullptr;
    Dtk::Widget::DVerticalLine *m_separator = nullptr;
    Dtk::Widget::DHorizontalLine *m_hSeparator = nullptr;
    QWidget *m_rightWidget = nullptr;
    QStack<QPair<ModuleInterface *, QWidget *>> m_contentStack;
    QList<ModuleInterface*> m_modules;
    QHBoxLayout *m_mainLayout = nullptr; // m_contentLayout
    ImmuBackupModule *m_backupModule = nullptr;
    ImmuRestoreModule *m_restoreModule = nullptr;
    ImmuFactoryRestoreModule *m_factoryRestoreModule = nullptr;

    Dtk::Widget::DBlurEffectWidget *m_leftNavFrameBlurWidget = nullptr;

    QSplitter *m_splitter = nullptr;
    DIconButton *m_iconBtn = nullptr;
    QWidget *m_iconArea = nullptr;
    QFrame *m_leftNavFrame = nullptr;
    QFrame *m_centralView = nullptr;
    QFrame *m_rightAreaFrame = nullptr;
    QHBoxLayout *m_midLayout = nullptr;
    QVBoxLayout *m_rightLayout = nullptr;
    QHBoxLayout *m_rightBottomLayout = nullptr;
    QFrame *m_workspace = nullptr;

    QStringList m_iconUnselectedList;
    QStringList m_iconSelectedList;
    LogDialog *m_logDialog = nullptr;

    bool m_isCommunity = false;
    bool m_isDeepinBootKitExist = false;
    bool m_isGhostOnly = false;
    bool m_isSelinuxEnabled = false;
    bool m_isLVMOnly = false;
    bool m_isEncrypted = false;
    bool m_isDevice = false;
    bool m_isSupportSettings = false;
    bool m_isSupportV20BackupRestore = false;
    bool m_isFileMgrEncrypted = false;
    bool m_isImmutable = false;
    int m_osMajorVer = -1;
    int m_osMinorVer = -1;
    int m_systemSyncType = -1;
    int m_userDataSyncType = -1;
};
#endif //UOS_RECOVERY_MAIN_WINDOW_SNIPE_H
