//
// Created by 张雪明 <zhangxueming@uniontech.com> on 2024/11/19.
//

#ifndef UOS_RECOVERY_IMMU_FACTORY_RESTORE_MODULE_H
#define UOS_RECOVERY_IMMU_FACTORY_RESTORE_MODULE_H

#include "interface/ModuleInterface.h"
#include "common/ResultWidget.h"
#include "common/ProgressWidget.h"
#include "common/AuthorityUtils.h"
#include "ImmuFactoryRestoreWidget.h"
#include <QObject>

class FrameProxyInterface;

class ImmuFactoryRestoreModule : public QObject, public ModuleInterface
{
    Q_OBJECT
public:
    explicit ImmuFactoryRestoreModule(FrameProxyInterface *frame, ComDeepinDaemonUosrecoveryInterface *interface,
                               QObject *parent = nullptr);
    ~ImmuFactoryRestoreModule() override;

    void initialize() override;

    QString name() const override;

    QString icons() const override;

    QString text() const override;

    void active() override;

public Q_SLOTS:
    void onImmuFactoryRestore();
    void onBack();
    void onBackHome();
    void onShowResult(bool success, int operateType, const QString &errorMsg = "");
    void onShowResult(bool success, const Response &rsp);
    void onShowProgress(const QString &mainTitle, const QString &subTitle, const QString &warning);
    void updateProgress(const QString &progress);
    void onError(const QString &errMsg);
    void onSuccess(const QString &msg);
    void doAdminAuthorityTask(bool result, int type);

private:
    int reboot();
    bool showRebootDialog(const QString &title, const QString &msg, const QString &iconName,
                          const QString &leftBtnText, const QString &rightBtnText);
    void checkAdminAuthority(AuthorityType type);
    void factoryRestore();

private:
    ImmuFactoryRestoreWidget *m_restoreWidget = nullptr;
    ProgressWidgetV2 *m_progressWidget = nullptr;
    ResultWidgetV2 *m_resultWidget = nullptr;
    QString m_curSysOpID = "";
    AuthorityUtils *m_adminAuthUtils = nullptr;
    QPixmap m_initRestoreIcon;
};

#endif //UOS_RECOVERY_IMMU_FACTORY_RESTORE_MODULE_H
