MACRO(CONFIGURE_STATS_FRONTEND _NAME_TARGET)
    # Could use IF with VERSION_GREATER_EQUAL but that requires 3.7 or later.
    IF((${CMAKE_MAJOR_VERSION} GREATER 3) OR ((${CMAKE_MAJOR_VERSION} EQUAL 3) AND (${CMAKE_MINOR_VERSION} GREATER 13)))
        FIND_PACKAGE(SQLite3)
    ELSE()
        FIND_LIBRARY(SQLite3_LIBRARY sqlite3)
        IF(SQLite3_LIBRARY)
            CHECK_LIBRARY_EXISTS(${SQLite3_LIBRARY} sqlite3_exec "" SQLite3_HAS_)
            IF(SQLite3_HAS_)
                FIND_PATH(SQLite3_INCLUDE_DIR sqlite3.h)
                IF(SQLite3_INCLUDE_DIR)
                    SET(SQLite3_FOUND YES)
                    SET(SQLite3_LIBRARIES ${SQLite3_LIBRARY})
                    SET(SQLite3_INCLUDE_DIRS ${SQLite3_INCLUDE_DIR})
                ELSE()
                    MESSAGE(STATUS "Did not find sqlite3.h")
                ENDIF()
            ELSE()
                MESSAGE(STATUS "${SQLite3_LIBRARY} does not have sqlite3_exec()")
            ENDIF()
        ELSE()
            MESSAGE(STATUS "Did not find the sqlite3 library")
        ENDIF()
    ENDIF()

    IF(SQLite3_FOUND)
        TARGET_LINK_LIBRARIES(${_NAME_TARGET} PRIVATE ${SQLite3_LIBRARIES})
        TARGET_INCLUDE_DIRECTORIES(${_NAME_TARGET} PRIVATE ${SQLite3_INCLUDE_DIRS})
        MESSAGE(STATUS "Support for statistics front end - Ready")
    ELSE()
        MESSAGE(FATAL_ERROR "Support for statistics front end - Failed")
    ENDIF()
ENDMACRO()
