/*
 * Copyright 2021 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 */

#ifndef NXP_IMG_DEF_H
#define NXP_IMG_DEF_H

#include <export/common/tbbr/tbbr_img_def_exp.h>

#ifdef CONFIG_DDR_FIP_IMAGE
/* DDR FIP IMAGE ID */
#define DDR_FIP_IMAGE_ID		MAX_IMG_IDS_WITH_SPMDS

#define DDR_IMEM_UDIMM_1D_IMAGE_ID	MAX_IMG_IDS_WITH_SPMDS + 1
#define DDR_IMEM_UDIMM_2D_IMAGE_ID	MAX_IMG_IDS_WITH_SPMDS + 2

#define DDR_DMEM_UDIMM_1D_IMAGE_ID	MAX_IMG_IDS_WITH_SPMDS + 3
#define DDR_DMEM_UDIMM_2D_IMAGE_ID	MAX_IMG_IDS_WITH_SPMDS + 4

#define DDR_IMEM_RDIMM_1D_IMAGE_ID	MAX_IMG_IDS_WITH_SPMDS + 5
#define DDR_IMEM_RDIMM_2D_IMAGE_ID	MAX_IMG_IDS_WITH_SPMDS + 6

#define DDR_DMEM_RDIMM_1D_IMAGE_ID	MAX_IMG_IDS_WITH_SPMDS + 7
#define DDR_DMEM_RDIMM_2D_IMAGE_ID	MAX_IMG_IDS_WITH_SPMDS + 8

#define DDR_FW_KEY_CERT_ID		MAX_IMG_IDS_WITH_SPMDS + 9
#define DDR_UDIMM_FW_CONTENT_CERT_ID	MAX_IMG_IDS_WITH_SPMDS + 10
#define DDR_RDIMM_FW_CONTENT_CERT_ID	MAX_IMG_IDS_WITH_SPMDS + 11
/* Max Images */
#define MAX_IMG_WITH_DDR_IDS		MAX_IMG_IDS_WITH_SPMDS + 12
#else
#define MAX_IMG_WITH_DDR_IDS		MAX_IMG_IDS_WITH_SPMDS
#endif

#ifdef POLICY_FUSE_PROVISION
/* FUSE FIP IMAGE ID */
#define FUSE_FIP_IMAGE_ID		MAX_IMG_WITH_DDR_IDS

#define FUSE_PROV_IMAGE_ID		MAX_IMG_WITH_DDR_IDS + 1

#define FUSE_UP_IMAGE_ID		MAX_IMG_WITH_DDR_IDS + 2

#define MAX_IMG_WITH_FIMG_IDS		MAX_IMG_WITH_DDR_IDS + 3
#else
#define MAX_IMG_WITH_FIMG_IDS		MAX_IMG_WITH_DDR_IDS
#endif

#define MAX_NUMBER_IDS			MAX_IMG_WITH_FIMG_IDS

#endif	/* NXP_IMG_DEF_H */
