<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from xml/schema/CRM/Core/ActionSchedule.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:e6121895aa480e9b4fdbf171b01b91dc)
 */

/**
 * Database access object for the ActionSchedule entity.
 */
class CRM_Core_DAO_ActionSchedule extends CRM_Core_DAO {
  const EXT = 'civicrm';
  const TABLE_ADDED = '3.4';

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_action_schedule';

  /**
   * Field to show when displaying a record.
   *
   * @var string
   */
  public static $_labelField = 'title';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = FALSE;

  /**
   * Paths for accessing this entity in the UI.
   *
   * @var string[]
   */
  protected static $_paths = [
    'browse' => 'civicrm/admin/scheduleReminders',
    'add' => 'civicrm/admin/scheduleReminders/edit?reset=1&action=add',
    'update' => 'civicrm/admin/scheduleReminders/edit?reset=1&action=update&id=[id]',
    'delete' => 'civicrm/admin/scheduleReminders/edit?reset=1&action=delete&id=[id]',
  ];

  /**
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $id;

  /**
   * Name of the scheduled action
   *
   * @var string
   *   (SQL type: varchar(128))
   *   Note that values will be retrieved from the database as a string.
   */
  public $name;

  /**
   * Title of the action(reminder)
   *
   * @var string|null
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $title;

  /**
   * Recipient
   *
   * @var string|null
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $recipient;

  /**
   * Is this the recipient criteria limited to OR in addition to?
   *
   * @var int|string|null
   *   (SQL type: int)
   *   Note that values will be retrieved from the database as a string.
   */
  public $limit_to;

  /**
   * Entity value
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $entity_value;

  /**
   * Entity status
   *
   * @var string|null
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $entity_status;

  /**
   * Reminder Interval.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $start_action_offset;

  /**
   * Time units for reminder.
   *
   * @var string|null
   *   (SQL type: varchar(8))
   *   Note that values will be retrieved from the database as a string.
   */
  public $start_action_unit;

  /**
   * Reminder Action
   *
   * @var string|null
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $start_action_condition;

  /**
   * Entity date
   *
   * @var string|null
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $start_action_date;

  /**
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_repeat;

  /**
   * Time units for repetition of reminder.
   *
   * @var string|null
   *   (SQL type: varchar(8))
   *   Note that values will be retrieved from the database as a string.
   */
  public $repetition_frequency_unit;

  /**
   * Time interval for repeating the reminder.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $repetition_frequency_interval;

  /**
   * Time units till repetition of reminder.
   *
   * @var string|null
   *   (SQL type: varchar(8))
   *   Note that values will be retrieved from the database as a string.
   */
  public $end_frequency_unit;

  /**
   * Time interval till repeating the reminder.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $end_frequency_interval;

  /**
   * Reminder Action till repeating the reminder.
   *
   * @var string|null
   *   (SQL type: varchar(32))
   *   Note that values will be retrieved from the database as a string.
   */
  public $end_action;

  /**
   * Entity end date
   *
   * @var string|null
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $end_date;

  /**
   * Is this option active?
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_active;

  /**
   * Contact IDs to which reminder should be sent.
   *
   * @var string|null
   *   (SQL type: varchar(128))
   *   Note that values will be retrieved from the database as a string.
   */
  public $recipient_manual;

  /**
   * listing based on recipient field.
   *
   * @var string|null
   *   (SQL type: varchar(128))
   *   Note that values will be retrieved from the database as a string.
   */
  public $recipient_listing;

  /**
   * Body of the mailing in text format.
   *
   * @var string|null
   *   (SQL type: longtext)
   *   Note that values will be retrieved from the database as a string.
   */
  public $body_text;

  /**
   * Body of the mailing in html format.
   *
   * @var string|null
   *   (SQL type: longtext)
   *   Note that values will be retrieved from the database as a string.
   */
  public $body_html;

  /**
   * Content of the SMS text.
   *
   * @var string|null
   *   (SQL type: longtext)
   *   Note that values will be retrieved from the database as a string.
   */
  public $sms_body_text;

  /**
   * Subject of mailing
   *
   * @var string|null
   *   (SQL type: varchar(128))
   *   Note that values will be retrieved from the database as a string.
   */
  public $subject;

  /**
   * Record Activity for this reminder?
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $record_activity;

  /**
   * Name/ID of the mapping to use on this table
   *
   * @var string|null
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $mapping_id;

  /**
   * FK to Group
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $group_id;

  /**
   * FK to the message template.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $msg_template_id;

  /**
   * FK to the message template.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $sms_template_id;

  /**
   * Date on which the reminder be sent.
   *
   * @var string|null
   *   (SQL type: date)
   *   Note that values will be retrieved from the database as a string.
   */
  public $absolute_date;

  /**
   * Name in "from" field
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $from_name;

  /**
   * Email address in "from" field
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $from_email;

  /**
   * Send the message as email or sms or both.
   *
   * @var string|null
   *   (SQL type: varchar(128))
   *   Note that values will be retrieved from the database as a string.
   */
  public $mode;

  /**
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $sms_provider_id;

  /**
   * Used for repeating entity
   *
   * @var string|null
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $used_for;

  /**
   * Used for multilingual installation
   *
   * @var string|null
   *   (SQL type: varchar(128))
   *   Note that values will be retrieved from the database as a string.
   */
  public $filter_contact_language;

  /**
   * Used for multilingual installation
   *
   * @var string|null
   *   (SQL type: varchar(8))
   *   Note that values will be retrieved from the database as a string.
   */
  public $communication_language;

  /**
   * When was the scheduled reminder created.
   *
   * @var string
   *   (SQL type: timestamp)
   *   Note that values will be retrieved from the database as a string.
   */
  public $created_date;

  /**
   * When the reminder was created or modified.
   *
   * @var string
   *   (SQL type: timestamp)
   *   Note that values will be retrieved from the database as a string.
   */
  public $modified_date;

  /**
   * Earliest date to consider start events from.
   *
   * @var string
   *   (SQL type: timestamp)
   *   Note that values will be retrieved from the database as a string.
   */
  public $effective_start_date;

  /**
   * Latest date to consider end events from.
   *
   * @var string
   *   (SQL type: timestamp)
   *   Note that values will be retrieved from the database as a string.
   */
  public $effective_end_date;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_action_schedule';
    parent::__construct();
  }

  /**
   * Returns localized title of this entity.
   *
   * @param bool $plural
   *   Whether to return the plural version of the title.
   */
  public static function getEntityTitle($plural = FALSE) {
    return $plural ? ts('Scheduled Reminders') : ts('Scheduled Reminder');
  }

  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  public static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'group_id', 'civicrm_group', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'msg_template_id', 'civicrm_msg_template', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'sms_template_id', 'civicrm_msg_template', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'sms_provider_id', 'civicrm_sms_provider', 'id');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Action Schedule ID'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.id',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'Number',
          ],
          'readonly' => TRUE,
          'add' => '3.4',
        ],
        'name' => [
          'name' => 'name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Name'),
          'description' => ts('Name of the scheduled action'),
          'required' => TRUE,
          'maxlength' => 128,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.name',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
          'add' => '3.4',
        ],
        'title' => [
          'name' => 'title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Title'),
          'description' => ts('Title of the action(reminder)'),
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.title',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
          'add' => '3.4',
        ],
        'recipient' => [
          'name' => 'recipient',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Recipient'),
          'description' => ts('Recipient'),
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.recipient',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
            'label' => ts("Limit or Add Recipients"),
            'controlField' => 'mapping_id',
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_BAO_ActionSchedule::getRecipientOptions',
          ],
          'add' => '3.4',
        ],
        'limit_to' => [
          'name' => 'limit_to',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Limit To'),
          'description' => ts('Is this the recipient criteria limited to OR in addition to?'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.limit_to',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
            'label' => ts("Limit/Add"),
            'controlField' => 'mapping_id',
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_BAO_ActionSchedule::getLimitToOptions',
          ],
          'add' => '4.4',
        ],
        'entity_value' => [
          'name' => 'entity_value',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Entity Value'),
          'description' => ts('Entity value'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.entity_value',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'serialize' => self::SERIALIZE_SEPARATOR_TRIMMED,
          'html' => [
            'type' => 'Select',
            'label' => ts("Entity Value"),
            'controlField' => 'mapping_id',
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_BAO_ActionSchedule::getEntityValueOptions',
          ],
          'add' => '3.4',
        ],
        'entity_status' => [
          'name' => 'entity_status',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Entity Status'),
          'description' => ts('Entity status'),
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.entity_status',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'serialize' => self::SERIALIZE_SEPARATOR_TRIMMED,
          'html' => [
            'type' => 'Select',
            'label' => ts("Entity Status"),
            'controlField' => 'entity_value',
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_BAO_ActionSchedule::getEntityStatusOptions',
          ],
          'add' => '3.4',
        ],
        'start_action_offset' => [
          'name' => 'start_action_offset',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Start Action Offset'),
          'description' => ts('Reminder Interval.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.start_action_offset',
          'default' => '0',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'Number',
            'label' => ts("Start Action Offset"),
            'min' => '0',
          ],
          'add' => '3.4',
        ],
        'start_action_unit' => [
          'name' => 'start_action_unit',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Start Action Unit'),
          'description' => ts('Time units for reminder.'),
          'maxlength' => 8,
          'size' => CRM_Utils_Type::EIGHT,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.start_action_unit',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
            'label' => ts("Start Action Unit"),
            'controlField' => 'start_action_offset',
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_BAO_ActionSchedule::getDateUnits',
          ],
          'add' => '3.4',
        ],
        'start_action_condition' => [
          'name' => 'start_action_condition',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Start Action Condition'),
          'description' => ts('Reminder Action'),
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.start_action_condition',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
            'label' => ts("Start Condition"),
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_SelectValues::beforeAfter',
          ],
          'add' => '3.4',
        ],
        'start_action_date' => [
          'name' => 'start_action_date',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Start Action Date'),
          'description' => ts('Entity date'),
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.start_action_date',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
            'label' => ts("Start Date"),
            'controlField' => 'entity_value',
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_BAO_ActionSchedule::getActionDateOptions',
          ],
          'add' => '3.4',
        ],
        'is_repeat' => [
          'name' => 'is_repeat',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Repeat'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.is_repeat',
          'default' => '0',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
          'add' => '3.4',
        ],
        'repetition_frequency_unit' => [
          'name' => 'repetition_frequency_unit',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Repetition Frequency Unit'),
          'description' => ts('Time units for repetition of reminder.'),
          'maxlength' => 8,
          'size' => CRM_Utils_Type::EIGHT,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.repetition_frequency_unit',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
            'label' => ts("Repetition Frequency Unit"),
            'controlField' => 'repetition_frequency_interval',
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_BAO_ActionSchedule::getDateUnits',
          ],
          'add' => '3.4',
        ],
        'repetition_frequency_interval' => [
          'name' => 'repetition_frequency_interval',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Repetition Frequency Interval'),
          'description' => ts('Time interval for repeating the reminder.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.repetition_frequency_interval',
          'default' => '0',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'Number',
            'label' => ts("Repetition Frequency Interval"),
            'min' => '0',
          ],
          'add' => '3.4',
        ],
        'end_frequency_unit' => [
          'name' => 'end_frequency_unit',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('End Frequency Unit'),
          'description' => ts('Time units till repetition of reminder.'),
          'maxlength' => 8,
          'size' => CRM_Utils_Type::EIGHT,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.end_frequency_unit',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
            'label' => ts("End Frequency Unit"),
            'controlField' => 'end_frequency_interval',
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_BAO_ActionSchedule::getDateUnits',
          ],
          'add' => '3.4',
        ],
        'end_frequency_interval' => [
          'name' => 'end_frequency_interval',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('End Frequency Interval'),
          'description' => ts('Time interval till repeating the reminder.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.end_frequency_interval',
          'default' => '0',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'Number',
            'label' => ts("End Frequency Interval"),
            'min' => '0',
          ],
          'add' => '3.4',
        ],
        'end_action' => [
          'name' => 'end_action',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('End Action'),
          'description' => ts('Reminder Action till repeating the reminder.'),
          'maxlength' => 32,
          'size' => CRM_Utils_Type::MEDIUM,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.end_action',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
            'label' => ts("End Condition"),
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_SelectValues::beforeAfter',
          ],
          'add' => '3.4',
        ],
        'end_date' => [
          'name' => 'end_date',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('End Date'),
          'description' => ts('Entity end date'),
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.end_date',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
            'label' => ts("End Date"),
            'controlField' => 'entity_value',
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_BAO_ActionSchedule::getActionDateOptions',
          ],
          'add' => '3.4',
        ],
        'is_active' => [
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Schedule is Active?'),
          'description' => ts('Is this option active?'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.is_active',
          'default' => '1',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
            'label' => ts("Enabled"),
          ],
          'add' => '3.4',
        ],
        'recipient_manual' => [
          'name' => 'recipient_manual',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Recipient Manual'),
          'description' => ts('Contact IDs to which reminder should be sent.'),
          'maxlength' => 128,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.recipient_manual',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'serialize' => self::SERIALIZE_COMMA,
          'html' => [
            'type' => 'EntityRef',
            'label' => ts("Manual Recipients"),
          ],
          'add' => '3.4',
        ],
        'recipient_listing' => [
          'name' => 'recipient_listing',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Recipient Listing'),
          'description' => ts('listing based on recipient field.'),
          'maxlength' => 128,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.recipient_listing',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'serialize' => self::SERIALIZE_SEPARATOR_TRIMMED,
          'html' => [
            'type' => 'Select',
            'label' => ts("Recipient Roles"),
            'controlField' => 'recipient',
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_BAO_ActionSchedule::getRecipientListingOptions',
          ],
          'add' => '4.1',
        ],
        'body_text' => [
          'name' => 'body_text',
          'type' => CRM_Utils_Type::T_LONGTEXT,
          'title' => ts('Reminder Text'),
          'description' => ts('Body of the mailing in text format.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.body_text',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'TextArea',
          ],
          'add' => '3.4',
        ],
        'body_html' => [
          'name' => 'body_html',
          'type' => CRM_Utils_Type::T_LONGTEXT,
          'title' => ts('Reminder HTML'),
          'description' => ts('Body of the mailing in html format.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.body_html',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'RichTextEditor',
          ],
          'add' => '3.4',
        ],
        'sms_body_text' => [
          'name' => 'sms_body_text',
          'type' => CRM_Utils_Type::T_LONGTEXT,
          'title' => ts('SMS Reminder Text'),
          'description' => ts('Content of the SMS text.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.sms_body_text',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'TextArea',
          ],
          'add' => '4.5',
        ],
        'subject' => [
          'name' => 'subject',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Reminder Subject'),
          'description' => ts('Subject of mailing'),
          'maxlength' => 128,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.subject',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
          'add' => '3.4',
        ],
        'record_activity' => [
          'name' => 'record_activity',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Record Activity'),
          'description' => ts('Record Activity for this reminder?'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.record_activity',
          'default' => '0',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
          'add' => '3.4',
        ],
        'mapping_id' => [
          'name' => 'mapping_id',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Reminder For'),
          'description' => ts('Name/ID of the mapping to use on this table'),
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.mapping_id',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
            'label' => ts("Used For"),
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_BAO_ActionSchedule::getMappingOptions',
            'suffixes' => [
              'name',
              'label',
              'icon',
            ],
          ],
          'add' => '3.4',
        ],
        'group_id' => [
          'name' => 'group_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Group ID'),
          'description' => ts('FK to Group'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.group_id',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Group',
          'html' => [
            'type' => 'EntityRef',
            'label' => ts("Group"),
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_group',
            'keyColumn' => 'id',
            'labelColumn' => 'title',
            'prefetch' => 'disabled',
          ],
          'add' => '3.4',
        ],
        'msg_template_id' => [
          'name' => 'msg_template_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Message Template ID'),
          'description' => ts('FK to the message template.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.msg_template_id',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'FKClassName' => 'CRM_Core_DAO_MessageTemplate',
          'html' => [
            'label' => ts("Message Template"),
          ],
          'add' => NULL,
        ],
        'sms_template_id' => [
          'name' => 'sms_template_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('SMS Template ID'),
          'description' => ts('FK to the message template.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.sms_template_id',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'FKClassName' => 'CRM_Core_DAO_MessageTemplate',
          'html' => [
            'label' => ts("SMS Template"),
          ],
          'add' => NULL,
        ],
        'absolute_date' => [
          'name' => 'absolute_date',
          'type' => CRM_Utils_Type::T_DATE,
          'title' => ts('Fixed Date for Reminder'),
          'description' => ts('Date on which the reminder be sent.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.absolute_date',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
            'formatType' => 'activityDate',
          ],
          'add' => '4.1',
        ],
        'from_name' => [
          'name' => 'from_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Reminder from Name'),
          'description' => ts('Name in "from" field'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.from_name',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
            'label' => ts("From Name"),
          ],
          'add' => '4.5',
        ],
        'from_email' => [
          'name' => 'from_email',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Reminder From Email'),
          'description' => ts('Email address in "from" field'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.from_email',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'Email',
            'label' => ts("From Email"),
          ],
          'add' => '4.5',
        ],
        'mode' => [
          'name' => 'mode',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Message Mode'),
          'description' => ts('Send the message as email or sms or both.'),
          'maxlength' => 128,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.mode',
          'default' => 'Email',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'msg_mode',
            'optionEditPath' => 'civicrm/admin/options/msg_mode',
          ],
          'add' => '4.5',
        ],
        'sms_provider_id' => [
          'name' => 'sms_provider_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('SMS Provider ID'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.sms_provider_id',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'FKClassName' => 'CRM_SMS_DAO_Provider',
          'html' => [
            'type' => 'Select',
            'label' => ts("SMS Provider"),
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_SelectValues::smsProvider',
          ],
          'add' => '4.5',
        ],
        'used_for' => [
          'name' => 'used_for',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Used For'),
          'description' => ts('Used for repeating entity'),
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.used_for',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'label' => ts("Used For"),
          ],
          'add' => '4.6',
        ],
        'filter_contact_language' => [
          'name' => 'filter_contact_language',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Filter Contact Language'),
          'description' => ts('Used for multilingual installation'),
          'maxlength' => 128,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.filter_contact_language',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'serialize' => self::SERIALIZE_SEPARATOR_TRIMMED,
          'html' => [
            'type' => 'Select',
            'label' => ts("Recipients Language"),
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_BAO_ActionSchedule::getFilterContactLanguageOptions',
          ],
          'add' => '4.7',
        ],
        'communication_language' => [
          'name' => 'communication_language',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Communication Language'),
          'description' => ts('Used for multilingual installation'),
          'maxlength' => 8,
          'size' => CRM_Utils_Type::EIGHT,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.communication_language',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
            'label' => ts("Communication Language"),
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_BAO_ActionSchedule::getCommunicationLanguageOptions',
          ],
          'add' => '4.7',
        ],
        'action_schedule_created_date' => [
          'name' => 'created_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Created Date'),
          'description' => ts('When was the scheduled reminder created.'),
          'required' => FALSE,
          'usage' => [
            'import' => FALSE,
            'export' => TRUE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.created_date',
          'export' => TRUE,
          'default' => 'CURRENT_TIMESTAMP',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'add' => '5.34',
        ],
        'modified_date' => [
          'name' => 'modified_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Modified Date'),
          'description' => ts('When the reminder was created or modified.'),
          'required' => FALSE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.modified_date',
          'default' => 'CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP',
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'label' => ts("Modified Date"),
          ],
          'readonly' => TRUE,
          'add' => '5.34',
        ],
        'action_schedule_effective_start_date' => [
          'name' => 'effective_start_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Effective start date'),
          'description' => ts('Earliest date to consider start events from.'),
          'required' => FALSE,
          'usage' => [
            'import' => FALSE,
            'export' => TRUE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.effective_start_date',
          'export' => TRUE,
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
            'formatType' => 'activityDate',
          ],
          'add' => '5.34',
        ],
        'action_schedule_effective_end_date' => [
          'name' => 'effective_end_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Effective end date'),
          'description' => ts('Latest date to consider end events from.'),
          'required' => FALSE,
          'usage' => [
            'import' => FALSE,
            'export' => TRUE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_schedule.effective_end_date',
          'export' => TRUE,
          'table_name' => 'civicrm_action_schedule',
          'entity' => 'ActionSchedule',
          'bao' => 'CRM_Core_BAO_ActionSchedule',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
            'formatType' => 'activityDate',
          ],
          'add' => '5.34',
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  public static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }

  /**
   * Returns the names of this table
   *
   * @return string
   */
  public static function getTableName() {
    return self::$_tableName;
  }

  /**
   * Returns if this table needs to be logged
   *
   * @return bool
   */
  public function getLog() {
    return self::$_log;
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'action_schedule', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'action_schedule', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [
      'UI_name' => [
        'name' => 'UI_name',
        'field' => [
          0 => 'name',
        ],
        'localizable' => FALSE,
        'unique' => TRUE,
        'sig' => 'civicrm_action_schedule::1::name',
      ],
    ];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
