# CiviCRM 4.7.18

Released April 5, 2017

- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**

## <a name="features"></a>Features

### Core CiviCRM

- **[CRM-19385](https://issues.civicrm.org/jira/browse/CRM-19385) Look at
  REMOVING id column from cache tables
  ([10073](https://github.com/civicrm/civicrm-core/pull/10073) and
  [10019](https://github.com/civicrm/civicrm-core/pull/10019))**

  Cache tables no longer use auto-incremented ID fields.

- **[CRM-20062](https://issues.civicrm.org/jira/browse/CRM-20062) New counties
  of Kenya ([9937](https://github.com/civicrm/civicrm-core/pull/9937))**

  Kenya is now divided into 47 counties, treated as "state/province" in CiviCRM.

- **[CRM-20187](https://issues.civicrm.org/jira/browse/CRM-20187) allow class
  parameter for hook_civicrm_links()  
  ([9901](https://github.com/civicrm/civicrm-core/pull/9901))**

  Links provided to `hook_civicrm_links()` can now specify classes for the `<a>`
  element.

- **[CRM-20039](https://issues.civicrm.org/jira/browse/CRM-20039) Add
  supplemental address lines as criteria in Advanced Search
  ([9850](https://github.com/civicrm/civicrm-core/pull/9850))**

  Searching by supplemental address 1 and 2 (though not 3) is available in the
  Advanced Search.

- **[CRM-20219](https://issues.civicrm.org/jira/browse/CRM-20219) Switch
  activity date time to use datepicker in profiles
  ([9935](https://github.com/civicrm/civicrm-core/pull/9935))**

  The activity date/time field now uses the more standard datepicker rather than
  the jCalendar widget when used in a profile.

- **Tweak icon when expanding popup to fullscreen
  ([9961](https://github.com/civicrm/civicrm-core/pull/9961))**

  The expand icon becomes a compress icon after expanding a popup window.

- **[CRM-4287](https://issues.civicrm.org/jira/browse/CRM-4287) - Contact search
  for email address (& other details) shows only primary detail matches as
  results ([9772](https://github.com/civicrm/civicrm-core/pull/9772))**

  Search preferences now contain a setting for whether to restrict searches to
  primary address, phone, email, IM, and OpenID.

### CiviCase

- **[CRM-20302](https://issues.civicrm.org/jira/browse/CRM-20302) Case api
  improvements ([10017](https://github.com/civicrm/civicrm-core/pull/10017))**

  The Case API now allows for filtering by and returning cases with tags.

- **[CRM-20102](https://issues.civicrm.org/jira/browse/CRM-20102) Case table
  view ([9940](https://github.com/civicrm/civicrm-core/pull/9940))**

  The Activity API now allows for filtering by and returning activities with
  Case ID.  The Case API now properly handles SQL operators for the `contact_id`
  field and returns the `case_id.definition` joined field with proper formatting.

### CiviContribute

- **[CRM-20286](https://issues.civicrm.org/jira/browse/CRM-20286) Add card type
  field on search form
  ([9999](https://github.com/civicrm/civicrm-core/pull/9999))**

  The Find Contributions and Advanced Search now allow searching by card type.

- **[CRM-20282](https://issues.civicrm.org/jira/browse/CRM-20282) Add credit
  card type field for Bookkeeping report
  ([9995](https://github.com/civicrm/civicrm-core/pull/9995))**

  The bookkeeping report now allows for displaying and filtering by card type.

- **[CRM-19674](https://issues.civicrm.org/jira/browse/CRM-19674) Add ability to
  see at a glance if a contribution is part of a recurring series
  ([9421](https://github.com/civicrm/civicrm-core/pull/9421))**

  The display of recurring contributions in contribution search results is
  shorter.

- **[CRM-20272](https://issues.civicrm.org/jira/browse/CRM-20272) Add credit
  card type field for Contribution Summary Report
  ([9986](https://github.com/civicrm/civicrm-core/pull/9986))**

  The contribution summary report now allows for displaying and filtering by
  card type.

- **[CRM-19715](https://issues.civicrm.org/jira/browse/CRM-19715) Remove Close
  Accounting Period code
  ([9983](https://github.com/civicrm/civicrm-core/pull/9983) and
  [9955](https://github.com/civicrm/civicrm-core/pull/9955))**

  The Close Accounting Period interface is removed.

- **[CRM-20058](https://issues.civicrm.org/jira/browse/CRM-20058) Add Credit
  Card Payment link for partially paid contribution
  ([9860](https://github.com/civicrm/civicrm-core/pull/9860) and
  [9941](https://github.com/civicrm/civicrm-core/pull/9941))**

  There is now a separate link for the credit card payment form for partially
  paid contributions.

- **[CRM-20199](https://issues.civicrm.org/jira/browse/CRM-20199) Contribution
  searches all include an unindexed join
  ([9631](https://github.com/civicrm/civicrm-core/pull/9631))**

  The option value table is joined on contribution searches when option values
  could be provided through pseudoconstants, with improved performance.

- **[CRM-16189](https://issues.civicrm.org/jira/browse/CRM-16189) Improve
  support for Accrual Method bookkeeping
  ([8807](https://github.com/civicrm/civicrm-core/pull/8807)) (partial work)**

  The deferred revenue report now operates more like other reports.

- **[CRM-20251](https://issues.civicrm.org/jira/browse/CRM-20251) Make it easier
  to overwrite front end form help text regarding recurring
  ([9970](https://github.com/civicrm/civicrm-core/pull/9970))**

  The recurring contribution help text for donors is now prepared when building
  the form rather than on the template.  This makes it easier to modify in
  hooks.

- **[CRM-20252](https://issues.civicrm.org/jira/browse/CRM-20252) Improve text
  when processing possibly-delayed-payments
  ([9971](https://github.com/civicrm/civicrm-core/pull/9971))**

  The "Your contribution has been submitted" text on contribution forms now only
  appears if the site is still waiting on notification of a successful
  transaction.

### CiviEvent

- **[CRM-20213](https://issues.civicrm.org/jira/browse/CRM-20213) Switch
  participant_register_date to use datepicker in profiles
  ([9922](https://github.com/civicrm/civicrm-core/pull/9922))**

  The registration date field now uses the more standard datepicker rather than
  the jCalendar widget when used in a profile.

### CiviMember

- **[CRM-20294](https://issues.civicrm.org/jira/browse/CRM-20294) Update
  membership dates in profiles to use datepicker
  ([10005](https://github.com/civicrm/civicrm-core/pull/10005))**

  Membership join, start, end, and reminder date fields now use the more
  standard datepicker rather than the jCalendar widget when used in a profile.

### CiviMail

- **[CRM-19836](https://issues.civicrm.org/jira/browse/CRM-19836) Allow mail
  bounce processing to create activities for inbound email
  ([9655](https://github.com/civicrm/civicrm-core/pull/9655))**

  The bounce fetcher can now optionally create activities for tracked replies to
  CiviMail messages.

### CiviReport

- **[CRM-20255](https://issues.civicrm.org/jira/browse/CRM-20255) Add developer
  tabs to more reports
  ([9978](https://github.com/civicrm/civicrm-core/pull/9978))**

  The repeating contribution and event income reports now have the developer tab.

- **[CRM-20242](https://issues.civicrm.org/jira/browse/CRM-20242) Add developer
  Tab to Activity Detail report
  ([9965](https://github.com/civicrm/civicrm-core/pull/9965))**

  The Activity Detail report now has the developer tab.

### Drupal Integration Modules

- **[CRM-20186](https://issues.civicrm.org/jira/browse/CRM-20186) Expose legal
  name in views ([430](https://github.com/civicrm/civicrm-drupal/pull/430) and
  [429](https://github.com/civicrm/civicrm-drupal/pull/429))**

  The Legal Name field is now available in Drupal Views.

### WordPress Integration

- **[CRM-20225](https://issues.civicrm.org/jira/browse/CRM-20225) Add classes to
  WordPress basepage
  ([111](https://github.com/civicrm/civicrm-wordpress/pull/111))**

  When viewing a CiviCRM page using the basepage method, the `<body>` element is
  given a class name corresponding to the CiviCRM page.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **[CRM-19773](https://issues.civicrm.org/jira/browse/CRM-19773) Call
  hook_civicrm_selectWhereClause from the BAOs
  ([9923](https://github.com/civicrm/civicrm-core/pull/9923) and
  [9570](https://github.com/civicrm/civicrm-core/pull/9570)) (preliminary work)**

  Reports now check permissions more consistently for viewing entities.

- **[CRM-19124](https://issues.civicrm.org/jira/browse/CRM-19124) Date of birth
  format varies between hooks and API
  ([9847](https://github.com/civicrm/civicrm-core/pull/9847))**

  The birth date field is now *mostly* in the format `yyyymmddhhmmss` when it
  appears in hooks.

- **[CRM-19914](https://issues.civicrm.org/jira/browse/CRM-19914)
  civicrmHooks.php issues on windows
  ([9788](https://github.com/civicrm/civicrm-core/pull/9788))**

  On Windows systems, the path to a `civicrmHooks.php` file in the custom PHP
  directory was not resolving correctly.

- **[CRM-20216](https://issues.civicrm.org/jira/browse/CRM-20216) Dedupe rules
  should be prevented from being saved if Weight Threshold is null or zero
  ([10020](https://github.com/civicrm/civicrm-core/pull/10020))**

- **[CRM-19308](https://issues.civicrm.org/jira/browse/CRM-19308) Disallow
  false-y values for paths purged during cache clears
  ([8980](https://github.com/civicrm/civicrm-core/pull/8980))**

  This prevents the entire CiviCRM files directory from being deleted on cache
  clear in certain cases.

- **[CRM-19979](https://issues.civicrm.org/jira/browse/CRM-19979)
  GroupContact.delete does not work for contacts with status of Pending
  ([9789](https://github.com/civicrm/civicrm-core/pull/9789)) (completes prior
  work)**

  This fixes a problem where an enormous contribution value would cause an
  error on Authorize.net but nonetheless save the value in CiviCRM.

- **News dashlet - don't show count when it's zero
  ([10002](https://github.com/civicrm/civicrm-core/pull/10002))**

- **[CRM-20254](https://issues.civicrm.org/jira/browse/CRM-20254) Custom CSS
  files do not include cache buster
  ([9980](https://github.com/civicrm/civicrm-core/pull/9980))**

- **[CRM-19980](https://issues.civicrm.org/jira/browse/CRM-19980) FIx slow
  queries due to LOWER on contact name fields
  ([9802](https://github.com/civicrm/civicrm-core/pull/9802))**

  Some contact fields were being queried with the `LOWER()` function, blocking
  the performance benefit of indexes.  CiviCRM tables use case-insensitive
  collation, so queries will already be handled in case-insensitive way.

- **[CRM-19051](https://issues.civicrm.org/jira/browse/CRM-19051) Logging -
  setting to allow offline triggers not respected in all cases
  ([9602](https://github.com/civicrm/civicrm-core/pull/9602))**

- **Settings ([9420](https://github.com/civicrm/civicrm-core/pull/9420))**

  This resolves a code loop that could occur when retrieving domain settings and
  removes some obsolete functions from the domain BAO.

- **[CRM-20020](https://issues.civicrm.org/jira/browse/CRM-20020) Advanced
  search for parent group + another criteria ignores other criteria - shows all
  group members always
  ([9836](https://github.com/civicrm/civicrm-core/pull/9836))**

- **[CRM-20023](https://issues.civicrm.org/jira/browse/CRM-20023) Accept
  state_province_id without state_province in `CRM_Utils_Geocode_*`
  ([9958](https://github.com/civicrm/civicrm-core/pull/9958) and
  [9839](https://github.com/civicrm/civicrm-core/pull/9839))**

- **[CRM-20235](https://issues.civicrm.org/jira/browse/CRM-20235) Suppress
  annoying extension download error messages
  ([9954](https://github.com/civicrm/civicrm-core/pull/9954))**

  No longer generate a separate pop-up message when CiviCRM is unable to access
  the extension directory or write to the extensions folder.

- **[CRM-19958](https://issues.civicrm.org/jira/browse/CRM-19958) Problems with
  contact types (subtypes) which beginning with numbers
  ([9769](https://github.com/civicrm/civicrm-core/pull/9769))**

- **[CRM-18747](https://issues.civicrm.org/jira/browse/CRM-18747) group
  descriptions no longer included when listing in profiles
  ([9946](https://github.com/civicrm/civicrm-core/pull/9946))**

  When groups are included as a checkbox field in a profile form,
  the descriptions are now displayed as they were in CiviCRM 4.4.x and earlier.

- **[CRM-19993](https://issues.civicrm.org/jira/browse/CRM-19993) Fixes for ISO
  compliance with countries and counties
  ([9951](https://github.com/civicrm/civicrm-core/pull/9951))**

  A number of missing, misspelled, or out-of-date country and state/province
  names are fixed.

- **[CRM-19386](https://issues.civicrm.org/jira/browse/CRM-19386) Date format is
  not taken into account for custom field on activity import
  ([9072](https://github.com/civicrm/civicrm-core/pull/9072))**

- **[CRM-15505](https://issues.civicrm.org/jira/browse/CRM-15505) Mailing labels
  show the state/province name as the abbreviation rather than the full
  state/province name ([9911](https://github.com/civicrm/civicrm-core/pull/9911)
  and [9905](https://github.com/civicrm/civicrm-core/pull/9905))**

- **[CRM-20208](https://issues.civicrm.org/jira/browse/CRM-20208) Multiple names
  for Results Column in profiles
  ([10004](https://github.com/civicrm/civicrm-core/pull/10004))**

  When viewing a profile's fields, the confusing legacy term "In Selector" was
  still the label for whether a field appears in the results column.

- **[CRM-20270](https://issues.civicrm.org/jira/browse/CRM-20270) Test suite
  displays "PHP Warning: declare(encoding=...) ignored because Zend multibyte
  feature is turned off by settings in"
  ([9982](https://github.com/civicrm/civicrm-core/pull/9982))**

  The ezcMail package is updated.

- **[CRM-20232](https://issues.civicrm.org/jira/browse/CRM-20232) Not all
  relationship types available in relationship report filter.
  ([9947](https://github.com/civicrm/civicrm-core/pull/9947))**

  Symmetrical relationships (e.g. sibling, spouse, etc.) weren't available as
  filter options in the relationship report.

- **[CRM-19869](https://issues.civicrm.org/jira/browse/CRM-19869) CiviReport:
  Layout problem multiple-page PDF
  ([9670](https://github.com/civicrm/civicrm-core/pull/9670))**

- **[CRM-20179](https://issues.civicrm.org/jira/browse/CRM-20179) Upgrade jstree
  and other clientside performance fixes
  ([9899](https://github.com/civicrm/civicrm-core/pull/9899))**

### CiviContribute

- **[CRM-19710](https://issues.civicrm.org/jira/browse/CRM-19710) Preserve
  is_email_receipt parameter through to email sent
  ([10000](https://github.com/civicrm/civicrm-core/pull/10000))**

  In some cases, the `is_email_receipt` API parameter would fail to trigger a
  receipt getting sent.

- **[CRM-19900](https://issues.civicrm.org/jira/browse/CRM-19900) Enable/Disable
  payment processor from summary page only disables live
  ([9979](https://github.com/civicrm/civicrm-core/pull/9979))**

- **[CRM-20220](https://issues.civicrm.org/jira/browse/CRM-20220) Use text box
  for signature field on payment processor page
  ([9936](https://github.com/civicrm/civicrm-core/pull/9936))**

- **[CRM-20146](https://issues.civicrm.org/jira/browse/CRM-20146) check_number
  toggle: don't hardcode value
  ([9865](https://github.com/civicrm/civicrm-core/pull/9865))**

  The value of the "check" payment instrument was hard-coded for the purpose of
  showing and hiding the check number field.

- **[CRM-20334](https://issues.civicrm.org/jira/browse/CRM-20334) Fatal Error on
  Submit Credit Card Form
  ([10042](https://github.com/civicrm/civicrm-core/pull/10042))**

- **[CRM-20052](https://issues.civicrm.org/jira/browse/CRM-20052) BillingBlock
  js not loading as expected in Drupal 8
  ([9859](https://github.com/civicrm/civicrm-core/pull/9859))**

- **Civi\API\ExternalBatch - Improve test for variables_order/$_ENV
  ([9969](https://github.com/civicrm/civicrm-core/pull/9969))**

  The ExternalBatch API checks more accurately for a missing `$_ENV` variable.

- **[CRM-20025](https://issues.civicrm.org/jira/browse/CRM-20025) DB Error on
  email task for advanced search for contributions
  ([9952](https://github.com/civicrm/civicrm-core/pull/9952))**

- **[CRM-20247](https://issues.civicrm.org/jira/browse/CRM-20247) $is_recur not
  always assigned to the template for recurring contributions
  ([9966](https://github.com/civicrm/civicrm-core/pull/9966))**

- **[CRM-20248](https://issues.civicrm.org/jira/browse/CRM-20248) Dummy payment
  processor on dev sites uses Elavon, not dummy class
  ([9967](https://github.com/civicrm/civicrm-core/pull/9967))**

  The dummy payment processor ID has been updated in hard-coded sample data.

- **[CRM-19966](https://issues.civicrm.org/jira/browse/CRM-19966) Tax applied
  repeatedly when 'empty editing' contribution
  ([9948](https://github.com/civicrm/civicrm-core/pull/9948))**

- **[CRM-20193](https://issues.civicrm.org/jira/browse/CRM-20193) Draw currency
  from better table on Batch Transaction form
  ([9930](https://github.com/civicrm/civicrm-core/pull/9930))**

  Currency is now more accurately looked up from `civicrm_entity_financial_trxn`
  rather than `civicrm_contribution`.

- **[CRM-19937](https://issues.civicrm.org/jira/browse/CRM-19937) entering $
  (dollar sign) in other amount contribution box makes credit card forms go away
  ([9745](https://github.com/civicrm/civicrm-core/pull/9745))**

- **[CRM-19741](https://issues.civicrm.org/jira/browse/CRM-19741) Price set and
  price set value "label" fields are inconsistant to users
  ([9776](https://github.com/civicrm/civicrm-core/pull/9776))**

  This fixes a bug where the price field label was not saving properly when
  edited inline.

### CiviMail

- **[CRM-20299](https://issues.civicrm.org/jira/browse/CRM-20299) CiviMail UI:
  Recipient list does not update for advanced options
  ([10014](https://github.com/civicrm/civicrm-core/pull/10014))**

- **[CRM-19962](https://issues.civicrm.org/jira/browse/CRM-19962) Name field of
  AB mailing too short
  ([9815](https://github.com/civicrm/civicrm-core/pull/9815))**

  The `<input>` tag was missing the `type` attribute of `text`.

- **[CRM-20001](https://issues.civicrm.org/jira/browse/CRM-20001) Tokens in
  Subject not working
  ([9824](https://github.com/civicrm/civicrm-core/pull/9824))**

- **[CRM-20206](https://issues.civicrm.org/jira/browse/CRM-20206) `&` encoded to
  `&amp;` in plain text email checksum links
  ([9938](https://github.com/civicrm/civicrm-core/pull/9938) and
  [9917](https://github.com/civicrm/civicrm-core/pull/9917))**

### CiviMember

- **[CRM-19792](https://issues.civicrm.org/jira/browse/CRM-19792) Authorize.net
  membership renewals with credit card not processed though event regs are
  ([9662](https://github.com/civicrm/civicrm-core/pull/9662))**

  Renewing a membership would not always provide the email address to the
  payment processor.

- **[CRM-20342](https://issues.civicrm.org/jira/browse/CRM-20342) Fatal Error on
  View Membership ([10060](https://github.com/civicrm/civicrm-core/pull/10060))**

- **Enotice fix ([10032](https://github.com/civicrm/civicrm-core/pull/10032))**

  This fixes an occasional PHP notice for a missing variable when batch editing
  memberships.

### CiviEvent

- **[CRM-20347](https://issues.civicrm.org/jira/browse/CRM-20347) Fatal error on
  delete participant record with related contribution
  ([10061](https://github.com/civicrm/civicrm-core/pull/10061))**

- **[CRM-19273](https://issues.civicrm.org/jira/browse/CRM-19273) Changes to
  Event Selections on Pending (Pay Later) Contribution Not Creating Correct
  Financial Items Causing Imbalance in Accounting Batch Export
  ([9998](https://github.com/civicrm/civicrm-core/pull/9998)) (preliminary work)**

### Drupal Integration

- **[CRM-19835](https://issues.civicrm.org/jira/browse/CRM-19835) Installing
  into D8, DB requirements fail using non-standard port for MySQL
  ([9910](https://github.com/civicrm/civicrm-core/pull/9910) and
  [423](https://github.com/civicrm/civicrm-drupal/pull/423))**

- **[CRM-19856](https://issues.civicrm.org/jira/browse/CRM-19856) Get User
  record url fails in Drupal 8
  ([9521](https://github.com/civicrm/civicrm-core/pull/9521))**

### WordPress Integration

- **[CRM-19665](https://issues.civicrm.org/jira/browse/CRM-19665) Canonical URL
  for WP basepage pages is the basepage itself
  ([107](https://github.com/civicrm/civicrm-wordpress/pull/107))**

  The canonical URL is now set properly (for the new standard `get_canonical_url`
  filter as well as All-in-one SEO and Yoast SEO) when viewing a frontend page
  using the basepage (long URL) method.

## <a name="misc"></a>Miscellany

- **[CRM-20239](https://issues.civicrm.org/jira/browse/CRM-20239) Extra tests
  for the CRM_Contact_BAO_Individual::format function
  ([9963](https://github.com/civicrm/civicrm-core/pull/9963))**

- **[CRM-20157](https://issues.civicrm.org/jira/browse/CRM-20157) Code cleanup -
  remove unused & unuseful variables in dedupe classes
  ([9907](https://github.com/civicrm/civicrm-core/pull/9907))**

- **[CRM-20224](https://issues.civicrm.org/jira/browse/CRM-20224) Cleanup
  internal event names
  ([9943](https://github.com/civicrm/civicrm-core/pull/9943))**

- **Minor test tidy up.
  ([10044](https://github.com/civicrm/civicrm-core/pull/10044))**

- **Fix up test to create line_items & memberships accurately
  ([10029](https://github.com/civicrm/civicrm-core/pull/10029))**

- **extract two core API permission functions
  ([10016](https://github.com/civicrm/civicrm-core/pull/10016))**

  API permissions are moved to a function providing them.

- **New GenCodeChecksum for auto-generated DAO files
  ([10013](https://github.com/civicrm/civicrm-core/pull/10013))**

- **Minor comment fixes & function extraction.
  ([9751](https://github.com/civicrm/civicrm-core/pull/9751))**

  New `CRM_Core_Form` methods handle adding basic select fields and statistic
  fields to reports.

- **Fix test to use name that will not cause intermittant errors
  ([10011](https://github.com/civicrm/civicrm-core/pull/10011))**

- **Correct description of order api
  ([10008](https://github.com/civicrm/civicrm-core/pull/10008))**

- **(NFC) Update API examples and add example of using user_contact_id as id for
  current logged in user
  ([9959](https://github.com/civicrm/civicrm-core/pull/9959))**

- **Update to 4.7.18 ([9956](https://github.com/civicrm/civicrm-core/pull/9956))**

- **[CRM-20200](https://issues.civicrm.org/jira/browse/CRM-20200) Add
  .editorconfig for easier editor config / coding standards
  ([9912](https://github.com/civicrm/civicrm-core/pull/9912))**

- **comment changes only
  ([9931](https://github.com/civicrm/civicrm-core/pull/9931))**

- **Additional unit test, checking membership renewal
  ([9909](https://github.com/civicrm/civicrm-core/pull/9909))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andie Hunt; Agileware - Agileware Team; Arkadiusz
Rzadkowolski; Australian Greens - Seamus Lee; Black Brick Software - David
Hayes; Christian Wach; CiviCRM - Coleman Watts, Donald Lobo, Jitendra Purohit,
Kurund Jalmi, Tim Otten; CiviDesk - Sunil Pawar; CompuCorp - Michael Devery;
Ergon Logic Enterprises - Christopher Gervais; Erich Schulz; Fuzion - Chris
Burgess, Eileen McNaughton; Jérôme Lebleu; JMA Consulting - Edsel Lopez, Joe
Murray, Pradeep Nayak; Johan Vervloet; John Kingsnorth; Klaas Eikelboom;
Lighthouse Design and Consulting - Brian Shaughnessy; Matthew Wire; Progressive
Technology Project - Jamie McClelland; Romain Thouvenin; Sean Madsen; Semper IT -
Karin Gerritsen; Squiffle Consulting - Aidan Saunders; Tadpole Collective -
Kevin Cristiano; Vasantha Kaje; Vikas Kumar; We Move Europe/Caltha - Tomasz
Pietrzkowski; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Amnistía Internacional España - Fernando Rodríguez; Avietech - Jonathan Boeke;
Blackfly Solutions - Alan Dixon; British Humanist Association - Andrew West;
Circle Interactive - Dave Jenkins, Martin Castle; CiviCoop - Jaap Jansma;
CiviCRM - Monish Deb, Yashodha Chaku; CiviDesk - Nicolas Ganivet; CiviHosting -
Hershel Robinson; CompuCorp - Guanhuan Chen, Mirela Stanila; Dmitry Smirnov;
Forest CRM Consulting - Tamar Meir; Fuzion - Peter Davis; JMA Consulting - Jon
Goldberg; Korlon - Stuart Gaston; Minnesota Association of Veterinary
Technicians - Maureen Parks; Pawel Nowak; Skvare - Mark Hanna; Stuart Parker
