# CiviCRM 5.61.0

Released May 3, 2023

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| Fix problems installing or upgrading to a previous version?     |   no    |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Add template support for Imports
  ([dev/core#4130](https://lab.civicrm.org/dev/core/-/issues/4130):
  [25808](https://github.com/civicrm/civicrm-core/pull/25808))**

  This provides a nice-to-have functionality for non-Civi-Import imports - ie
  the import can store details from the initial DataSource screen - anyone who
  always has to remember to save dates will appreciate that. In addition for
  Civi-import imports it can store more nuanced defaults for Civi-Import (which
  works on the Contribution Import).

- **Define interfaces for interacting with newly cleaned up import code
  (Work Towards [dev/core#3514](https://lab.civicrm.org/dev/core/-/issues/3514):
  [25879](https://github.com/civicrm/civicrm-core/pull/25879))**

  Defines hook to alter data once it has been mapped but before work is done on
  it.

- **Civi-Import - Add Template search
  ([25939](https://github.com/civicrm/civicrm-core/pull/25939) and
  [25957](https://github.com/civicrm/civicrm-core/pull/25957))**

  Adds a Civi Import Template Search.

- **Add links to search kits to import preview screen, when Civi-Import is
  enabled ([25816](https://github.com/civicrm/civicrm-core/pull/25816))**

  Adds links to SearchKit user interface to the import screens when Civi-Import
  is enabled.

- **Civi-Import - improvements to the search display for imported rows
  ([25977](https://github.com/civicrm/civicrm-core/pull/25977))**

  Improves the Civi-Import user experience by disabling edit in place for
  imported rows and reordering the contribution id and status message columns.

- **Import data source Re-use already uploaded data, optionally on use of 'back'
  button ([25787](https://github.com/civicrm/civicrm-core/pull/25787))**

  Improves user experience when importing data by storing the uploaded file so
  you do not have to upload it again if you go back.

- **Add handling of `usage` to `DAO` generator
  ([25874](https://github.com/civicrm/civicrm-core/pull/25874) and
  [25934](https://github.com/civicrm/civicrm-core/pull/25934))**

  Adds handling of usage to DAO generator.

- **Afform - Support repeatable relationships
  ([25175](https://github.com/civicrm/civicrm-core/pull/25175))**

  Supports creating multiple relationships at once using the "Repeatable"
  feature in the relationship fields.

- **Afform - Allow contact created/modified date fields to be used as filters
  ([25824](https://github.com/civicrm/civicrm-core/pull/25824))**

  Makes the contact created/modified date fields available as filter options for
  relevant Afforms.

- **Afform - Show file field values for existing entities
  ([25294](https://github.com/civicrm/civicrm-core/pull/25294))**

  Improves the file-upload interface for existing entities.

- **Search kit - address issues
  ([dev/core#4153](https://lab.civicrm.org/dev/core/-/issues/4153):
  [25718](https://github.com/civicrm/civicrm-core/pull/25718))**

  Extends the address fields available for the PrimaryContact on search.

- **SearchKit - POC help text
  ([24819](https://github.com/civicrm/civicrm-core/pull/24819))**

  Improves user experience by adding some Help tooltips to SearchKit (which also
  serve as examples for developers).

- **SearchKit - Handle comma-separated values passed from Afform url
  ([25827](https://github.com/civicrm/civicrm-core/pull/25827))**

  Allows multiple filter values to be passed through the url to a SearchKit
  display.

- **SearchKit - Add select options for MONTH date filter
  ([25739](https://github.com/civicrm/civicrm-core/pull/25739))**

  Makes the "Month Only" field transformation in SearchKit into a dropdown
  select.

- **SearchKit - Add next_birthday calc field
  ([25740](https://github.com/civicrm/civicrm-core/pull/25740))**

  Adds a Next Birthday Calc field to Searchkit.

- **Speed up SearchKit results loading by 800ms
  ([25408](https://github.com/civicrm/civicrm-core/pull/25408))**

  Improves loading times for SearchKit results.

- **SearchKit - Pass entire record into `checkAccess`
  ([25969](https://github.com/civicrm/civicrm-core/pull/25969))**

   Makes SearchKit more efficient.

- **Add new `\Civi\Exception\DBQueryException` & throw that rather than a
  `PEAR_Exception`
  ([25634](https://github.com/civicrm/civicrm-core/pull/25634))**

  Improves logging of database query issues.

- **Log sending of Scheduled Reminders
  ([25933](https://github.com/civicrm/civicrm-core/pull/25933))**

  Adds a log line to know which was the last Scheduled Reminder that was being
  processed.

- **Manage groups - add dedicated url for edit/delete group
  ([25955](https://github.com/civicrm/civicrm-core/pull/25955))**

  In preparation for a "manage groups" screen in the Admin UI (see #25899) this
  updates the url for editing and deleting groups so it does not conflict with
  the url for browsing groups.

- **Extend Authx functionality to support validation of externally generated
  JWTs (Work Towards
  [dev/core#3133](https://lab.civicrm.org/dev/core/-/issues/3133):
  [25952](https://github.com/civicrm/civicrm-core/pull/25952))**

  Adds support for using externally generated JWTs e.g. by Auth0 to authenticate
  users using Authx

- **add locale param to smarty crmMoney()
  ([25726](https://github.com/civicrm/civicrm-core/pull/25726))**

  Adds new (optional) locale parameter to smarty function crmMoney().

- **AutoClean - Optionally allow explicit cleanup
  ([25858](https://github.com/civicrm/civicrm-core/pull/25858))**

  Allows some slightly different auto clean code-patterns that will give the
  same functionality.

### CiviContribute

- **PaymentProcessor - Enter title instead of name on form, call hooks
  ([25873](https://github.com/civicrm/civicrm-core/pull/25873))**

  Adds a new "Frontend title" to Payment Processors for end-users, and redefines
  "Title" as a backend field for admins.

### CiviEvent

- **FormBuilder: Can't set participant status type
  ([dev/core#4163](https://lab.civicrm.org/dev/core/-/issues/4163):
  [25750](https://github.com/civicrm/civicrm-core/pull/25750))**

  Adds the `ParticipantStatusType` entity to APIv4.

- ** Allow search on participant id
  ([dev/core#4176](https://lab.civicrm.org/dev/core/-/issues/4176):
  [25780](https://github.com/civicrm/civicrm-core/pull/25780))**

  Adds a Participant ID search field to the Participant Search.

### CiviPledge

- **Add support for pledge tokens
  ([dev/core#4079](https://lab.civicrm.org/dev/core/-/issues/4079):
  [25851](https://github.com/civicrm/civicrm-core/pull/25851))**

  Adds tokens for pledges.

### Drupal Integration

- **Expose "created date" to views
  ([569](https://github.com/civicrm/civicrm-drupal/pull/569))**

  Allows date formatting options on the `created date` in views.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Importing "No" values to Boolean field results in empty
  ([dev/core#3937](https://lab.civicrm.org/dev/core/-/issues/3937):
  [25900](https://github.com/civicrm/civicrm-core/pull/25900))**

- **is_drupal: move functionality that calls this deprecated variable to System
  classes  ([dev/core#4127](https://lab.civicrm.org/dev/core/-/issues/4127):
  [25574](https://github.com/civicrm/civicrm-core/pull/25574))**

  Move standalone profile modification to userSystem.

- **Possible issue with Token processor and Smarty
  (Work Towards [dev/core#4137](https://lab.civicrm.org/dev/core/-/issues/4137):
  [25727](https://github.com/civicrm/civicrm-core/pull/25727))**

  Ensures tokens filters are HTML-sensitive.

- **Notice on `isDuplicate` on profile form
  ([dev/core#4144](https://lab.civicrm.org/dev/core/-/issues/4144):
  [25657](https://github.com/civicrm/civicrm-core/pull/25657))**

  Fixes a smarty notice on isDuplicate.

- **User editable Message Templates, the Contact Action: Send an Email and the
  Contact Action: Print Merge/Document cannot use any Smarty Tokens with the
  crmDate function because CKEditor 4 unnecessarily HTML encodes single quotes
  (') and double quotes (")
  ([dev/core#4149](https://lab.civicrm.org/dev/core/-/issues/4149):
  [25681](https://github.com/civicrm/civicrm-core/pull/25681))**

  Changes CKEditor 4 default to not encode HTML entities by default which breaks
  Smarty syntax and prevents use of crmDate function

- **Data integrity issue: Some number fields change their values during data
  entry ([dev/core#4152](https://lab.civicrm.org/dev/core/-/issues/4152):
  [25876](https://github.com/civicrm/civicrm-core/pull/25876))**

  Fixes custom data code to not cast to a float.

- **Import search authorization issues
  ([dev/core#4184](https://lab.civicrm.org/dev/core/-/issues/4184):
  [25811](https://github.com/civicrm/civicrm-core/pull/25811))**

  Permits access to template user jobs (imports).

- **phpunit 9 compatibility
  (Work Towards [dev/core#4188](https://lab.civicrm.org/dev/core/-/issues/4188):
  [25947](https://github.com/civicrm/civicrm-core/pull/25947),
  [25946](https://github.com/civicrm/civicrm-core/pull/25946),
  [25949](https://github.com/civicrm/civicrm-core/pull/25949) and
  [25956](https://github.com/civicrm/civicrm-core/pull/25956))**

  Works towards phpunit 9 compatiablity by:

    - Updating CRM tests
    - Updating APIv3 tests
    - Updating APIv4 tests
    - Porting TAP printer
    - making the phpunit.xml.dist file compatible with phpunit8 + phpunit9

- **Cannot set Entityref fields via APIv4 Explorer - on multi-value data
  ([dev/core#4240](https://lab.civicrm.org/dev/core/-/issues/4240):
  [26067](https://github.com/civicrm/civicrm-core/pull/26067))**

- **blog warning: pass an array for included groups Caller:
  CRM_ACL_API::groupPermission Array ( [civi.tag] => deprecated )
  ([dev/core#4249](https://lab.civicrm.org/dev/core/-/issues/4249):
  [26099](https://github.com/civicrm/civicrm-core/pull/26099))**

  Ensures that no deprecation logging occurs from groupPermission having
  includeGroups as NULL rather than an empty array.

- **[Backport] Fix dedupe checking in afform for anonymous users
  ([25999](https://github.com/civicrm/civicrm-core/pull/25999))**

- **Afform - Required files causes form to never validate
  ([dev/core#4121](https://lab.civicrm.org/dev/core/-/issues/4121):
  [25666](https://github.com/civicrm/civicrm-core/pull/25666))**

- **Afform - set multi-select values from url
  ([25832](https://github.com/civicrm/civicrm-core/pull/25832))**

  Ensures that default values are set correctly for multi-valued fields

- **Afform - Fix showing default values for EntityRef fields
  ([26008](https://github.com/civicrm/civicrm-core/pull/26008))**

- **Afform: Fix dedupe rules for anonymous users
  ([25461](https://github.com/civicrm/civicrm-core/pull/25461))**

- **Api4 - Prevent developer error mixing up `addValue` with `addWhere`
  ([25905](https://github.com/civicrm/civicrm-core/pull/25905))**

  Adds a sanity check in the api to prevent the common mistake of
  accidentally using addValue as if it takes 3 arguments like addWhere.

- **APIv4 - Show actions as deprecated in the Explorer
  ([25402](https://github.com/civicrm/civicrm-core/pull/25402))**

- **APIv4 - Support `match` in replaceAction
  ([25770](https://github.com/civicrm/civicrm-core/pull/25770))**

  Allows the `replaceAction` to support non-id matching, the same way as the
  `saveAction` does.

- **Remove an attention-span's worth of cvs info
  ([26012](https://github.com/civicrm/civicrm-core/pull/26012))**

- **Send SMS: fix invalid htxt tag error
  ([26010](https://github.com/civicrm/civicrm-core/pull/26010))**

- **Clarify `entityID` types in Merger class
  ([26003](https://github.com/civicrm/civicrm-core/pull/26003))**

- **When importing invalid campaigns they pass validation (only to fail on
  import) ([25988](https://github.com/civicrm/civicrm-core/pull/25988))**

- **Allow to disable an invalid relationship (eg. contact subtype was changed so
  no longer valid)
  ([25647](https://github.com/civicrm/civicrm-core/pull/25647))**

- **Duplicate logging not needed for PEAR_Errors anymore
  ([25953](https://github.com/civicrm/civicrm-core/pull/25953))**

- **Flush cache that holds schema links information when saving UserJob
  ([25959](https://github.com/civicrm/civicrm-core/pull/25959))**

- **Check presence of field, rather than extra smarty variable for whether to
  display the field
  ([25917](https://github.com/civicrm/civicrm-core/pull/25917))**

- **Note API - Fix viewing, joining to, and updating Notes
  ([25672](https://github.com/civicrm/civicrm-core/pull/25672))**

- **civicrm_cache - Replace wonky index
  ([25885](https://github.com/civicrm/civicrm-core/pull/25885))**

- **Remove preferred_mail_format from tokens
  ([25883](https://github.com/civicrm/civicrm-core/pull/25883))**

- **SchemaHandler - Add IF EXISTS to dropTable function
  ([25881](https://github.com/civicrm/civicrm-core/pull/25881))**

  Prevents errors in the same way `dropColumn` does by checking that it exists
  before dropping.

- **Make `Finder::tableQuery` private, after universe search
  ([25859](https://github.com/civicrm/civicrm-core/pull/25859))**

- **WorkflowMessage - Enable strict parsing of annotations
  ([25818](https://github.com/civicrm/civicrm-core/pull/25818))**

- **Skip adding script when it won't have anything to run on
  ([25882](https://github.com/civicrm/civicrm-core/pull/25882))**

- **Logging ReportDetail: update breadcrumb to use CiviCRM Home for
  disambiguation with the "Home" Location Type translation.
  ([25805](https://github.com/civicrm/civicrm-core/pull/25805))**

- **Relationship Cache check
  ([25751](https://github.com/civicrm/civicrm-core/pull/25751))**

- **Change title of is_primary fields consistent with Email
  ([25700](https://github.com/civicrm/civicrm-core/pull/25700))**

- **Unconditionally assign `quickConfig`, add helper for `getPriceSetID`
  ([25719](https://github.com/civicrm/civicrm-core/pull/25719))**

- **Fix dedupe finder performance issue on looking up table size
  ([25527](https://github.com/civicrm/civicrm-core/pull/25527))**

- **don't show USPS warning when USPS lookup disabled
  ([25736](https://github.com/civicrm/civicrm-core/pull/25736))**

- **field separator is a required field
  ([25738](https://github.com/civicrm/civicrm-core/pull/25738))**

- **Use label, where present for import field labels
  ([25991](https://github.com/civicrm/civicrm-core/pull/25991))**

- **Show friendlier labels when Civi-Import enabled
  ([25896](https://github.com/civicrm/civicrm-core/pull/25896))**

- **Import link - fix search Import SearchDisplays to link to the created contact
  ([25712](https://github.com/civicrm/civicrm-core/pull/25712))**

- **Hyphenate Civi-Import in the title/label
  ([25474](https://github.com/civicrm/civicrm-core/pull/25474))**

- **Filter 'My imports' to only show non-expired
  ([25711](https://github.com/civicrm/civicrm-core/pull/25711))**

- **Update Import fix to leverage the new exception
  ([25725](https://github.com/civicrm/civicrm-core/pull/25725))**

- **Fix typing, comments in new StandardFilters class
  ([25730](https://github.com/civicrm/civicrm-core/pull/25730))**

- **Minor fixes to Civi-Import screen, populating defaults, missing `ts`
  ([25980](https://github.com/civicrm/civicrm-core/pull/25980))**

- **Fix enotice when using Civi-import
  ([25979](https://github.com/civicrm/civicrm-core/pull/25979))**
  
- **Fix cache clearing when import table is changed
  ([25774](https://github.com/civicrm/civicrm-core/pull/25774))**

- **Worldregion - For API-entity-naming, prefer "WorldRegion"
  ([25713](https://github.com/civicrm/civicrm-core/pull/25713))**

- **Pager missing on Aggregate By Relationship civireport
  ([25721](https://github.com/civicrm/civicrm-core/pull/25721))**

- **Fix profile search listings columns are sometimes blank.
  ([25782](https://github.com/civicrm/civicrm-core/pull/25782))**

- **Do not report missing triggers if the user cannot check them
  ([25820](https://github.com/civicrm/civicrm-core/pull/25820))**

- **don't create tagset markup if there's no tagset
  ([25884](https://github.com/civicrm/civicrm-core/pull/25884))**

- **ensure delays from transactions don't cause cache race condition
  ([25673](https://github.com/civicrm/civicrm-core/pull/25673))**

- **Fix bug in just-merged upgrade code
  ([25940](https://github.com/civicrm/civicrm-core/pull/25940))**

- **Fix really annoying notice on mispelt variable name `$isCheked`
  ([25759](https://github.com/civicrm/civicrm-core/pull/25759))**

- **Don't crash API4 if pseudoconstant lookups return nothing
  ([25028](https://github.com/civicrm/civicrm-core/pull/25028))**

- **Php8.2 stop accessing undefined form Property isQuickConfig in
  `PriceField:addQuickFormElement`
  ([25689](https://github.com/civicrm/civicrm-core/pull/25689))**

- **Avoid type error in CRM_Core_Form on php 8
  ([25853](https://github.com/civicrm/civicrm-core/pull/25853))**

- **CiviReport - Remove duplicate external identifier key in contact fields
  array, reduce notices
  ([25454](https://github.com/civicrm/civicrm-core/pull/25454))**

- **Stop passing `$this` as `$form` to previously shared, non-static, function
  ([25923](https://github.com/civicrm/civicrm-core/pull/25923))**

- **Remove un-used, un-displayed button
  ([25841](https://github.com/civicrm/civicrm-core/pull/25841))**

- **Avoid potentially undefined var
  ([26001](https://github.com/civicrm/civicrm-core/pull/26001))**

- **Smarty notice fix on Merge
  ([25772](https://github.com/civicrm/civicrm-core/pull/25772))**

- **APIv4 - Don't link to non-existent API entities
  ([25743](https://github.com/civicrm/civicrm-core/pull/25743))**

- **Fix handling of employer during contact-merge ([dev/core#4156](https://lab.civicrm.org/dev/core/-/issues/4156): [#26015](https://github.com/civicrm/civicrm-core/pull/26015))**

- **Contact with relationship fails to update when CiviMember is disabled ([dev/core#4225](https://lab.civicrm.org/dev/core/-/issues/4225):
  [#26140](https://github.com/civicrm/civicrm-core/pull/26140))**

- **Importer does not ""fill"" phone/email ([dev/core#4269](https://lab.civicrm.org/dev/core/-/issues/4269): [#26146](https://github.com/civicrm/civicrm-core/pull/26146))**

- **Importer - Ensure mapping ID is set in all places using import templates ([#26108](https://github.com/civicrm/civicrm-core/pull/26108))**

### CiviCampaign

- **Campaign - Make name index unique
  ([25995](https://github.com/civicrm/civicrm-core/pull/25995))**

### CiviCase

- **Civicase dashboard not displaying recently performed activities
  ([dev/core#3804](https://lab.civicrm.org/dev/core/-/issues/3804):
  [25954](https://github.com/civicrm/civicrm-core/pull/25954))**

- **Case start_date/end_date are not datetime
  ([25803](https://github.com/civicrm/civicrm-core/pull/25803))**

### CiviContribute

- **Fix bug in tax calculation when recurring overrides with a different value
  ([25707](https://github.com/civicrm/civicrm-core/pull/25707))**

- **🥚 Payment API creates Activity with subject: "$x Offline Payment for
  Contribution" even when a payment was captured online
  ([25997](https://github.com/civicrm/civicrm-core/pull/25997))**

- **Direct Debit agreement is always/never shown depending on which payment
  processor is the default
  ([dev/core#4204](https://lab.civicrm.org/dev/core/-/issues/4204):
  ([25918](https://github.com/civicrm/civicrm-core/pull/25918))**

  Ensures the Payment Agreement of the selected processor is displayed (instead
  of the payment agreement of the default payment processor).

- **only update `contributionRecur` when `templateContribution` is updated IF it
  is actively marked as such
  ([dev/core#4000](https://lab.civicrm.org/dev/core/-/issues/4000):
  [25776](https://github.com/civicrm/civicrm-core/pull/25776))**

- **Past campaigns are not to be assigned via batch update/update contributions
  ([dev/core#4124](https://lab.civicrm.org/dev/core/-/issues/4124):
  [25687](https://github.com/civicrm/civicrm-core/pull/25687))**

- **Fix import contribution url
  ([25895](https://github.com/civicrm/civicrm-core/pull/25895),
  [25907](https://github.com/civicrm/civicrm-core/pull/25907) and
  [25962](https://github.com/civicrm/civicrm-core/pull/25962))**

  Standardizes the contribution import url.

- **Update Contribution Import to use apiv4 field names, prior to adding hooks
  ([25886](https://github.com/civicrm/civicrm-core/pull/25886))**

- **APiv4 explorer - can't enter `contribution.contribution_recur_id`
  ([dev/core#4175](https://lab.civicrm.org/dev/core/-/issues/4175):
  [25804](https://github.com/civicrm/civicrm-core/pull/25804))**

### CiviMember

- **Fatal error on membership batch data entry with sending receipt
  ([dev/core#4247](https://lab.civicrm.org/dev/core/-/issues/4247):
  [26085](https://github.com/civicrm/civicrm-core/pull/26085))**

- **Countable error when creating a membership batch (if org ID is not 1)
  ([dev/core#4200](https://lab.civicrm.org/dev/core/-/issues/4200):
  [25906](https://github.com/civicrm/civicrm-core/pull/25906))**

- **🪥 Fix inconsistent terminology used when referring to Member Since,
  Membership Start Date and Membership Expiration Date
  ([24735](https://github.com/civicrm/civicrm-core/pull/24735) and
  [25761](https://github.com/civicrm/civicrm-core/pull/25761))**

- **Fix unreleased regression on Membership form validation ([dev/core#4272](https://lab.civicrm.org/dev/core/-/issues/4272): [#26141](https://github.com/civicrm/civicrm-core/pull/26141))**

### Drupal Integration

- **cv command fails on CiviCRM 5.48.2 on Drupal 9
  ([dev/core#3438](https://lab.civicrm.org/dev/core/-/issues/3438):
  [25728](https://github.com/civicrm/civicrm-core/pull/25728))**

  Prevents `cv` fatal error if logging before CMS bootstrap.

- **Use the backend theme when upgrading
  ([665](https://github.com/civicrm/civicrm-drupal/pull/665) and
  [81](https://github.com/civicrm/civicrm-drupal-8/pull/81))**

## <a name="misc"></a>Miscellany

- **Add getter for dedupeRuleGroupID
  ([25894](https://github.com/civicrm/civicrm-core/pull/25894))**

- **Move getSubmittedValues to `CRM_Core_Form`
  ([25877](https://github.com/civicrm/civicrm-core/pull/25877))**

- **Extract `isMembershipPriceSet` (`useForMember`)
  ([25754](https://github.com/civicrm/civicrm-core/pull/25754))**

- **CustomFields - drop unused 'javascript' column
  ([25958](https://github.com/civicrm/civicrm-core/pull/25958))**

- **UpdateConfigBackend: use api4 to flush the cache
  ([25913](https://github.com/civicrm/civicrm-core/pull/25913))**

- **Use API4 to create 'Assign Case Role' activity
  ([25880](https://github.com/civicrm/civicrm-core/pull/25880))**

- **Demolish the factory 🏭💥
  ([25975](https://github.com/civicrm/civicrm-core/pull/25975))**

- **BAO - deprecate create for writeRecord: SavedSearch
  ([25973](https://github.com/civicrm/civicrm-core/pull/25973))**

- **BAO - Deprecate `setIsActive` BAO functions
  ([25976](https://github.com/civicrm/civicrm-core/pull/25976))**

- **BAO - deprecate create for writeRecord: SubscriptionHistory
  ([25974](https://github.com/civicrm/civicrm-core/pull/25974))**

- **BAO - deprecate create for writeRecord: ACL
  ([25970](https://github.com/civicrm/civicrm-core/pull/25970))**

- **BAO - deprecate create for writeRecord: Batch
  ([25972](https://github.com/civicrm/civicrm-core/pull/25972))**

- **Updates pear/pear-core-minimal and guzzlehttp/psr7
  ([26082](https://github.com/civicrm/civicrm-core/pull/26082))**

- **Deprecate CRM_Utils_Hook::$nullObject
  ([25901](https://github.com/civicrm/civicrm-core/pull/25901))**

- **Remove 2021 noisily deprecated pdfCommon function
  ([25887](https://github.com/civicrm/civicrm-core/pull/25887))**

- **APIv4 - Deprecate unnecessary constants
  ([25781](https://github.com/civicrm/civicrm-core/pull/25781))**

- **BAO - Noisily deprecate and stop using deprecated functions
  ([25677](https://github.com/civicrm/civicrm-core/pull/25677))**

- **Remove dependence on cache/integration-tests
  ([25796](https://github.com/civicrm/civicrm-core/pull/25796))**

- **Remove function deprecated noisly in 2020
  ([25768](https://github.com/civicrm/civicrm-core/pull/25768))**

- **All your base are deleted
  ([25773](https://github.com/civicrm/civicrm-core/pull/25773))**

- **More deprecations of `del`
  ([25767](https://github.com/civicrm/civicrm-core/pull/25767))**

- **Consolidate `DataSource.tpl`
  ([25771](https://github.com/civicrm/civicrm-core/pull/25771))**

- **Remove unused var
  ([25857](https://github.com/civicrm/civicrm-core/pull/25857))**

- **Remove remaining non-variable variables
  ([25752](https://github.com/civicrm/civicrm-core/pull/25752))**

- **Deprecate pledge_payment::del
  ([25763](https://github.com/civicrm/civicrm-core/pull/25763))**

- **Remove deprecated calls from contribute, financial, remove ManagePremiums
  deprecated BAO ([25766](https://github.com/civicrm/civicrm-core/pull/25766))**

- **Deprecations on del functions
  ([25764](https://github.com/civicrm/civicrm-core/pull/25764))**

- **Deprecate relationship::del  
  ([25765](https://github.com/civicrm/civicrm-core/pull/25765))**

- **Noisily deprecate unused function
  ([25762](https://github.com/civicrm/civicrm-core/pull/25762))**

- **Code cleanup: Use `parent::buildForm` in contact import dataSource screen
  ([25757](https://github.com/civicrm/civicrm-core/pull/25757))**

- **Stop passing invariable variables to private function
  ([25676](https://github.com/civicrm/civicrm-core/pull/25676))**

- **Remove upgrade custom field handling from Dedupe code - previously shared
  function ([26004](https://github.com/civicrm/civicrm-core/pull/26004))**

- **Activity BAO - Remove unused classes/functions
  ([25971](https://github.com/civicrm/civicrm-core/pull/25971))**

- **Deprecated `buildSavedMappingFields` noisily
  ([25842](https://github.com/civicrm/civicrm-core/pull/25842))**

- **Code cleanup on aisle Hook ([25903](https://github.com/civicrm/civicrm-core/pull/25903))**

- **Deprecated code removal
  ([25710](https://github.com/civicrm/civicrm-core/pull/25710))**

- **Add deprecations to unreachable code in previously shared function
  ([25779](https://github.com/civicrm/civicrm-core/pull/25779))**

- **Stop using deprecated methods, `ufField::del`
  ([25747](https://github.com/civicrm/civicrm-core/pull/25747))**

- **Remove some deprecated del calls
  ([25746](https://github.com/civicrm/civicrm-core/pull/25746))**

- **Remove noisily deprecated code
  ([25965](https://github.com/civicrm/civicrm-core/pull/25965))**

- **Remove unvariable variables `toReturn` & `subName` from `Merger`
  ([25745](https://github.com/civicrm/civicrm-core/pull/25745))**

- **Remove do-nothing noisily deprecated formatting code
  ([25878](https://github.com/civicrm/civicrm-core/pull/25878))**

- **Post split code cleanup
  ([25862](https://github.com/civicrm/civicrm-core/pull/25862))**

- **Switch out the switch
  ([25868](https://github.com/civicrm/civicrm-core/pull/25868))**

- **set-version.php - Fix warning on PHP 8.1
  ([25786](https://github.com/civicrm/civicrm-core/pull/25786))**

- **[Test][Php8.2] Fix undeclared properties & other housekeeping
  ([25852](https://github.com/civicrm/civicrm-core/pull/25852))**

- **[php8.2] Create getter for `renewalMembershipID`, remove if
  ([25833](https://github.com/civicrm/civicrm-core/pull/25833))**

- **[PHP8.2] Declare outputHandler property in reports
  ([25875](https://github.com/civicrm/civicrm-core/pull/25875))**

- **PHP8 - Update symfony/var-dumper
  ([25850](https://github.com/civicrm/civicrm-core/pull/25850))**

- **[PHP8.2] declare deleteMessage on `entityFormTrait`
  ([25802](https://github.com/civicrm/civicrm-core/pull/25802))**

- **[PHP8.2] Remove unused setting on undeclared properties
  ([25831](https://github.com/civicrm/civicrm-core/pull/25831))**

- **[PHP8.2] Remove unused variabls from
  `Member_Form_Task_PDFLetter::postProcessMembers`
  ([25830](https://github.com/civicrm/civicrm-core/pull/25830))**

- **[REF][PHP8.2] Tidy up properties in api_v3_CaseContactTest
  ([25809](https://github.com/civicrm/civicrm-core/pull/25809))**

- **[PHP8.2] (Ref) Remove unused dynamic property in report form class
  ([25812](https://github.com/civicrm/civicrm-core/pull/25812))**

- **Php8.2 fixes in report `addToDeveloperTab` function
  ([25800](https://github.com/civicrm/civicrm-core/pull/25800))**

- **Php8.2 fixes in unit tests
  ([25797](https://github.com/civicrm/civicrm-core/pull/25797))**

- **[REF][PHP8.2] Refactor use of pageParams properties
  ([25795](https://github.com/civicrm/civicrm-core/pull/25795))**

- **[REF][PHP8.2] Refactor api_v3_ImTest with primary aim of improving PHP 8.2
  compatiability ([25792](https://github.com/civicrm/civicrm-core/pull/25792))**

- **[REF][PHP8.2] Refactor api_v3_PriceFieldValueTest with primary aim of
  improving PHP 8.2 compatiability
  ([25793](https://github.com/civicrm/civicrm-core/pull/25793))**

- **(REF) Remove unused onPopupClose variables
  ([25794](https://github.com/civicrm/civicrm-core/pull/25794))**

- **[REF][PHP8.2] Fix use of self in callables deprecation
  ([25791](https://github.com/civicrm/civicrm-core/pull/25791))**

- **[REF][PHP8.2] Declare property on CRM_Core_ErrorTest
  ([25788](https://github.com/civicrm/civicrm-core/pull/25788))**

- **[REF][PHP8.2] Declare property on CRM_Event_Import_Parser_ParticipantTest
  ([25789](https://github.com/civicrm/civicrm-core/pull/25789))**

- **[REF][PHP8.2] Declare property in CRM_Contact_Form_DedupeFind
  ([25834](https://github.com/civicrm/civicrm-core/pull/25834))**

- **[REF][PHP8.2] Don't use a property where a variable will do
  (CRM_Contact_Page_View_Summary)
  ([25828](https://github.com/civicrm/civicrm-core/pull/25828))**

- **[REF][PHP8.2] Only set properties which exist within
  ArrayFormatTrait->loadArray()
  ([25790](https://github.com/civicrm/civicrm-core/pull/25790))**

- **[REF] [php8.2] Remove unused parameters from
  `Contribute_PDFLetter::buildContributionArray`
  ([25829](https://github.com/civicrm/civicrm-core/pull/25829))**

- **[REF][PHP8.2] Remove property which is no longer used
  ([25889](https://github.com/civicrm/civicrm-core/pull/25889))**

- **[REF][PHP8.2] Refactor api_v3_ParticipantPaymentTest
  ([25864](https://github.com/civicrm/civicrm-core/pull/25864))**

- **[REF][PHP8.2] Refactor getParticipantOrderParams to never write a dynamic
  property ([25865](https://github.com/civicrm/civicrm-core/pull/25865))**

- **[REF][PHP8.2] Get rid of dynamic properties in
  CRM_Core_Payment_ProcessorFormTest
  ([25844](https://github.com/civicrm/civicrm-core/pull/25844))**

- **[REF][PHP8.2] Declare properties directly on CRM_Core_Form_EntityFormTrait
  ([25926](https://github.com/civicrm/civicrm-core/pull/25926))**

- **[REF][PHP8.2] Convert dynamic property into a variable
  ([25925](https://github.com/civicrm/civicrm-core/pull/25925))**

- **[REF][PHP8.2] Remove unused dyanamic property
  ([25921](https://github.com/civicrm/civicrm-core/pull/25921))**

- **[REF] Replace use of legacy `$dao->query()` with
  `CRM_Core_DAO::executeQuery()`
  ([25860](https://github.com/civicrm/civicrm-core/pull/25860))**

- **[REF] Improve function signature for `retrieve()` in `PaypalProIPN` , add
  test for when trxn_id is present
  ([25749](https://github.com/civicrm/civicrm-core/pull/25749))**

- **[REF] Fix issue where the strict typing was causing false notices to appear
  in Config And Log
  ([25814](https://github.com/civicrm/civicrm-core/pull/25814))**

- **(REF) PHPUnit - Allow env-var to specify version
  ([25836](https://github.com/civicrm/civicrm-core/pull/25836))**

- **[REF] Simplify import preProcess
  ([25869](https://github.com/civicrm/civicrm-core/pull/25869))**

- **[REF] Minor code simplification - extract `getHighlightedFields` in
  Contribution import `MapField`
  ([25866](https://github.com/civicrm/civicrm-core/pull/25866))**

- **[REF] Refactor location-related BAOs to use `writeRecord`
  ([25944](https://github.com/civicrm/civicrm-core/pull/25944))**

- **Refactor CRM_Core_BAO_Email to use DAO::writeRecord
  ([25937](https://github.com/civicrm/civicrm-core/pull/25937))**

- **[NFC] Test cleanup, prefer full form test flow
  ([25928](https://github.com/civicrm/civicrm-core/pull/25928))**

- **[NFC] Add metadata about import jobs to `MapField` form
  ([25891](https://github.com/civicrm/civicrm-core/pull/25891))**

- **[NFC] Remove some no-longer-used properties on Contribution import parser
  ([25867](https://github.com/civicrm/civicrm-core/pull/25867))**

- **[NFC] Don't have null values for required fields in Case test fixture
  ([25983](https://github.com/civicrm/civicrm-core/pull/25983))**

- **[NFC] Remove extraneous NULL
  ([25941](https://github.com/civicrm/civicrm-core/pull/25941))**

- **[NFC] hulk smash
  ([25902](https://github.com/civicrm/civicrm-core/pull/25902))**

- **[NFC] Fix PHP8.2 issues in the Mailing Contact Test
  ([25783](https://github.com/civicrm/civicrm-core/pull/25783))**

- **[NFC] Superficial cleanup in test class
  ([25708](https://github.com/civicrm/civicrm-core/pull/25708))**

- **[NFC] cleanup in `ChangeFeeSelectionTest`
  ([25798](https://github.com/civicrm/civicrm-core/pull/25798))**

- **[NFC] Minor tidy up in `MappingTest`
  ([25854](https://github.com/civicrm/civicrm-core/pull/25854))**

- **Remove references to deprecated `preferred_mail_format` in tests
  ([25890](https://github.com/civicrm/civicrm-core/pull/25890))**

- **[PHP8.2] Clean up in `apiv3_ParticipantTest` with view to 8.2 compatibility
  ([25801](https://github.com/civicrm/civicrm-core/pull/25801))**

- **[PHP8.2] [Test] Remove use of (often undeclared) property `_invoiceID` in
  tests & one instance of `paymentProcessorID2`
  ([25799](https://github.com/civicrm/civicrm-core/pull/25799))**

- **[Test] Strictness fixes - `CiviUntTestBaseClass`
  ([26011](https://github.com/civicrm/civicrm-core/pull/26011))**

- **[TESTS] Fix some campaign cleanup
  ([25996](https://github.com/civicrm/civicrm-core/pull/25996))**

- **Strictness cleanups in test class
  ([26005](https://github.com/civicrm/civicrm-core/pull/26005))**

- **Code cleanup in HookTest
  ([293](https://github.com/civicrm/civicrm-wordpress/pull/293))**

- **Type hints & strictness fixes within tests
  ([26013](https://github.com/civicrm/civicrm-core/pull/26013))**

- **Add unit test cover for test offline mail receipt
  ([25929](https://github.com/civicrm/civicrm-core/pull/25929))**

- **Fix intermittant test fail
  ([25924](https://github.com/civicrm/civicrm-core/pull/25924))**

- **Fix Contact Import tests custom date testing, remove duplicate handling
  ([25898](https://github.com/civicrm/civicrm-core/pull/25898))**

- **APIv4 - Add 'Update' to conformanceTest
  ([25674](https://github.com/civicrm/civicrm-core/pull/25674))**

- **Fix in ContributionTest class
  ([25722](https://github.com/civicrm/civicrm-core/pull/25722))**

- **CiviUnitTestCase - More aggressive simplifications
  ([25187](https://github.com/civicrm/civicrm-core/pull/25187))**

- **CiviUnitTestCase - During teardown, ensure that we cleanup locks
  ([25856](https://github.com/civicrm/civicrm-core/pull/25856))**

- **CiviUnitTestCase (etal) - Resolve spooky interaction
  ([25855](https://github.com/civicrm/civicrm-core/pull/25855))**

- **CiviUnitTestCase - Degrade gracefully on older DBMS
  ([25872](https://github.com/civicrm/civicrm-core/pull/25872))**

- **Add release notes for 5.61 ([#26117](https://github.com/civicrm/civicrm-core/pull/26117), [#26127](https://github.com/civicrm/civicrm-core/pull/26127))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; Agileware - Justin Freeman; Anthony Blond;
Benjamin W; BrightMinded Ltd - Bradley Taylor; CEDC - Laryn Kragt Bakker; CiviCRM -
Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku; Coop SymbioTIC - Mathieu Lutfy,
Samuel Vanhove, Shane Bill; Dave D; Freeform Solutions - Herb van den Dool; Fuzion - Luke
Stewart; Giant Rabbit - Anthony Nemirovsky; iXiam - Luciano Spiegel; JMA Consulting -
Seamus Lee; Lemniscus - Noah Miller; Megaphone Technology Consulting - Brienne Kordis,
Jon Goldberg; MJW Consulting - Matthew Wire; Progressive Technology Project - Jamie
McClelland; SYSTOPIA Organisationsberatung - Björn Endres; Third Sector Design - Kurund
Jalmi; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

AGH Strategies - Eli Lisseck; Andreas Howiller; Artful Robot - Rich Lott;
Blackfly Solutions - Alan Dixon; Guydn; Humanists UK - Andrew West; JMA
Consulting - Joe Murray; Joinery - Allen Shaw; Korlon - Stuart Gaston; Richard
Baugh; Squiffle Consulting - Aidan Saunders; SYSTOPIA - Johannes Franz; Giant
Rabbit: Tiago Bember; Third Sector Design - Michael McAndrew; WebmasterBouclier

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
