# CiviCRM 5.64.0

Released August 2, 2023

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **System Requirements - Raise minimum recommended PHP to 7.4
  ([26799](https://github.com/civicrm/civicrm-core/pull/26799))**

  Sites running PHP 7.3 will now display a "PHP Out-of-Date" warning on the
  system check.

- **Add LEFT, RIGHT and SUBSTRING SQL functions
  ([26549](https://github.com/civicrm/civicrm-core/pull/26549))**

  Adds LEFT, RIGHT and SUBSTRING SQL functions to APIv4.

- **Log server-side validation errors so it is easier to troubleshoot/debug
  afform issues ([25533](https://github.com/civicrm/civicrm-core/pull/25533))**

  Makes it easier to debug in afform by logging server-side validation errors.

- **Render Email input as type="email"
  ([26705](https://github.com/civicrm/civicrm-core/pull/26705) and
  [26802](https://github.com/civicrm/civicrm-core/pull/26802))**

  Makes core email field inputs display as type=email.  Email address validation
  is enforced on data entry but not when searching.

- **Specify 'match' in mgd.php files
  ([26608](https://github.com/civicrm/civicrm-core/pull/26608))**

  Adds 'match' param to reduce conflicts when resolving managed entities.

- **Towards consistency for displaying test entities. Stop hiding test entities
  on some dashboards
  ([23724](https://github.com/civicrm/civicrm-core/pull/23724))**

  Works towards consistent display of test entities by making all test entities
  show up on the relevant contact summary tabs and not on the user dashboard.

- **Add weights to contact search actions
  ([26719](https://github.com/civicrm/civicrm-core/pull/26719))**

  Adds weights to contact search actions so extensions can more easily
  manipulate them.

- **Add weight to Group Links
  ([26718](https://github.com/civicrm/civicrm-core/pull/26718))**

  Adds weights to group links so that extensions can more easily manipulate
  them.

- **Add import listing for admins
  ([26316](https://github.com/civicrm/civicrm-core/pull/26316))**

  Adds a searchkit search to display a list of imports run on the site for
  admins only to the civiimport extension.

- **Add All imports menu item for users with Administer Queues
  ([26516](https://github.com/civicrm/civicrm-core/pull/26516))**

  Adds a link to "All Imports" search to the menu bar for sites with the
  civiimport extension enabled.

- **[WIP] civicrm_admin_ui Find contacts replacement
  ([26381](https://github.com/civicrm/civicrm-core/pull/26381))**

  When using the core AdminUI extension, replaces the "Find contacts" search
  with a Search Kit + Form Builder version.

- **Remove Search Builder link from search results
  ([26670](https://github.com/civicrm/civicrm-core/pull/26670))**

  Removes the link to Search Builder from Advanced Search and Find Contacts
  results screens.

- **Add capitalize filter to tokens
  ([26662](https://github.com/civicrm/civicrm-core/pull/26662))**

  Adds a token filter: capitalize, to apply title-case/name-case to token-values.

- **crmMoney filter - allow coercing locale
  ([26383](https://github.com/civicrm/civicrm-core/pull/26383))**

  Adds a crmMoney filter to tokens, comparable to crmDate, for coercing money
  into a particular format.

- **Note Form: use EntityFormTrait and setEntityId for postProcess hooks
  ([26686](https://github.com/civicrm/civicrm-core/pull/26686))**

  Makes it easier for extension developers to use the postProcess hook when
  notes are edited.

- **Improve select for Add Navigation Menu Item > Parent
  ([26550](https://github.com/civicrm/civicrm-core/pull/26550))**

  Improves the "Add Navigation Menu Item" parent field by making it a select2,
  wider and the list ordered.

- **AdminUI: Convert Job Log page civicrm/admin/joblog
  ([26732](https://github.com/civicrm/civicrm-core/pull/26732))**

  Adds a "Job Log" page to the Admin UI extension.

- **AdminUI: Convert Mail Accounts page civicrm/admin/mailSettings
  ([26733](https://github.com/civicrm/civicrm-core/pull/26733))**

  Adds a "Mail Accounts" page to the Admin UI extension.

- **Add select2s for Contribution, etc
  ([26502](https://github.com/civicrm/civicrm-core/pull/26502))**

  Improves user experience by changing old-school selects to select2s on the
  following forms: Contribution, Manage Contribution Page, Manage Event
  Registration, Payments, PCPs, Pledges.

- **Put link first in SearchDisplay Links options
  ([26697](https://github.com/civicrm/civicrm-core/pull/26697))**

  Improves SearchKit -> SearchDisplay -> Links options user experience by
  reordering the fields.

- **Clarify dedupe rules as "Name or Email"
  ([26673](https://github.com/civicrm/civicrm-core/pull/26673))**

  Renames the default Organizational and Household dedupe rules from "Name and
  Email", to "Name or Email" which more accurately reflects how they work.

- **Move last (hopefully) custom search classes to the extension, unhide
  ([26664](https://github.com/civicrm/civicrm-core/pull/26664) and
  [26660](https://github.com/civicrm/civicrm-core/pull/26660))**

  Unhides the Legacy Custom Search extension so that users can uninstall it.

- **WorkflowMessage - Allow more dynamic-localized data. Unify language field.
  ([26618](https://github.com/civicrm/civicrm-core/pull/26618) and
  [26651](https://github.com/civicrm/civicrm-core/pull/26651))**

  Makes it possible for bespoke methods in WorkflowMessages to generate
  localized content.

- **Add deployID to civicrm.settings.php
  ([26632](https://github.com/civicrm/civicrm-core/pull/26632))**

  Adds deployID to civicrm.settings.php file for redis implementations.

- **Add Search Display of ACLs
  ([26624](https://github.com/civicrm/civicrm-core/pull/26624),
  [26627](https://github.com/civicrm/civicrm-core/pull/26627) and
  [26617](https://github.com/civicrm/civicrm-core/pull/26617))**

  Adds a search kit built search display of ACLs into the new admin ui extension
  and associated metadata that is needed.

- **Allow negative rules for ACLs
  ([dev/core#3753](https://lab.civicrm.org/dev/core/-/issues/3753):
  [26041](https://github.com/civicrm/civicrm-core/pull/26041))**

  Permits ACL rules that negate (deny) access.

- **Add "priority" column to ACLs and support ACL rule precedence  
  ([26592](https://github.com/civicrm/civicrm-core/pull/26592) and
  [26609](https://github.com/civicrm/civicrm-core/pull/26609))**

  Adds the concept of a priority to ACL rules. This allows for allow or deny
  rules to take precedence by the priority they are given.

- **Move standalone classes and standaloneusers extension into core
  ([26684](https://github.com/civicrm/civicrm-core/pull/26684),
  [26621](https://github.com/civicrm/civicrm-core/pull/26621) and
  [26631](https://github.com/civicrm/civicrm-core/pull/26631))**

  Adds support for Standalone builds.

- **SearchKit - Provide context information to subscribers
  ([26716](https://github.com/civicrm/civicrm-core/pull/26716))**

  Provides context information to subscribers in SearchKit.

- **SearchKit - Allow custom fields in join conditions
  ([26698](https://github.com/civicrm/civicrm-core/pull/26698))**

  Allows custom fields in SearchKit join conditions.

- **SearchKit - Expose expires_date field to UI
  ([26485](https://github.com/civicrm/civicrm-core/pull/26485))**

  Exposes expires_date field to the SearchKit UI.

- **API/SearchKit - Improve dynamic pseudoconstant lookups and ACL adminUI
  ([26639](https://github.com/civicrm/civicrm-core/pull/26639))**

  Improves metadata in the ACL entity, metadata handling in the API, and the
  new AdminUI "Manage ACL" screen.

- **APIv4 - Add EntitySet api for set-ops such as UNION
  ([26536](https://github.com/civicrm/civicrm-core/pull/26536) and
  [26583](https://github.com/civicrm/civicrm-core/pull/26583))**

  Makes it so one can use UNION in APIv4.

- **APIv4 - Remove gatekeeper permission check for AJAX endpoint (with tests)
  ([26391](https://github.com/civicrm/civicrm-core/pull/26391))**

  Historically the AJAX api has required either 'access CiviCRM' or 'access
  AJAX API' as a broad hedge against security vulnerabilities, but this
  interferes with legitimate use-cases for anonymous users to make ajax
  requests. Since http requests are allowed by anon, and many Civi pages now
  contain ajax elements, this PR replaces that broad hedge with unit tests for
  AJAX security.

- **APIv4 - Add more metadata to CustomValue entities; use AutoService
  ([26710](https://github.com/civicrm/civicrm-core/pull/26710))**

  Metadata improvements for multi-record custom field pseudo-entities.

- **Afform - Enable search operators to be exposed on the form
  ([26496](https://github.com/civicrm/civicrm-core/pull/26496))**

  Allows search operators to be selectable on the form by the end-user in Form
  Builder.

- **Form Builder - Clarify "Security" options
  ([26581](https://github.com/civicrm/civicrm-core/pull/26581))**

  Improves Form Builder user experience by clarifying Security options.

### CiviCampaign

- **Add apiv4 Survey entity
  ([26653](https://github.com/civicrm/civicrm-core/pull/26653))**

  Adds the Survey entity to Apiv4.

- **Add survey tokens
  ([26661](https://github.com/civicrm/civicrm-core/pull/26661))**

  Adds email tokens for survey data.

- **Add workflow message template for sign_petition, confirm petition
  ([26654](https://github.com/civicrm/civicrm-core/pull/26654))**

  Adds workflow message template for sign_petition and confirm petition.

### CiviCase

- **APIv4, Case API, configure options and suffixes for medium_id field
  ([25224](https://github.com/civicrm/civicrm-core/pull/25224))**

  Improves the APIv4 Case entity by making the options for `medium_id` a select
  instead of a free text field.

### CiviContribute

- **[AuthorizeNetIPN] Use API for failure updates
  ([26600](https://github.com/civicrm/civicrm-core/pull/26600))**

  Improves AuthorizeNetIPN integration by using APIv4 to log Failure updates.

- **Make the `recur_id` field of Contributions available to FormBuilder
  ([26745](https://github.com/civicrm/civicrm-core/pull/26745))**

  Makes the `recur_id` Contribution field available to FormBuilder.

### CiviEvent

- **Add unit test cover + nl2br for location in event emails
  ([26296](https://github.com/civicrm/civicrm-core/pull/26296))**

  Makes it so the html version of the event location token converts line breaks
  to page breaks.

- **Expose a few more event fields as tokens
  ([26575](https://github.com/civicrm/civicrm-core/pull/26575))**

  Makes the following information available as tokens when sending participants
  emails: `is_share`, `is_share:label`, `requires_approval`,
  `requires_approval:label` and `fee_label.`

- **Enhance examples to cover additional participants
  ([26573](https://github.com/civicrm/civicrm-core/pull/26573))**

  Adds additional examples to the event message templates preview and starts to
  flesh out the data to present for them

### CiviMail

- **CiviMail - New autocompletes for selecting recipients
  ([26585](https://github.com/civicrm/civicrm-core/pull/26585))**

  Breaks the "Recipients" field when building a CiviMail mailing into a select
  for groups to include and a select for groups to exclude.

- **Add missing Mailing Events to API4: Delivered, Forward, Reply
  ([26683](https://github.com/civicrm/civicrm-core/pull/26683))**

  Adds the mailing events: Delivered, Forward and Reply to APIv4.

- **Add calculated fields to API 4 for total mailing stats
  ([26689](https://github.com/civicrm/civicrm-core/pull/26689) and
  [26694](https://github.com/civicrm/civicrm-core/pull/26694))**

  Adds calculated fields to APIv4 for mailing stats, specifically: intended
  recipients, successful deliveries, unique and total opens, unique and total
  clicks, bounces, unsubscribes, opt outs, forwards and replies.

### Drupal Integration

- **Allow Drupal webstest user to view debug output
  ([26703](https://github.com/civicrm/civicrm-core/pull/26703))**

  Makes it so the drupal webtest user can view debug output to make it easier
  to debug.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Make frontend_title consistently required and use it in all front end
  presentations (Work Towards
  [dev/core#4213](https://lab.civicrm.org/dev/core/-/issues/4213):
  [26721](https://github.com/civicrm/civicrm-core/pull/26721))**

  Adds `frontend_title` to various data set up places.

- **How to activate downloaded translations?
  ([extensions/uplang#6](https://lab.civicrm.org/extensions/uplang/-/issues/6):
  [26564](https://github.com/civicrm/civicrm-core/pull/26564))**

  Fixes menu description translations on the Administration Console.

- **Migrate installers to "setup" API (Work Towards
  [dev/core#1615](https://lab.civicrm.org/dev/core/-/issues/1615):
  [26678](https://github.com/civicrm/civicrm-core/pull/26678) and
  [26677](https://github.com/civicrm/civicrm-core/pull/26677))**

  Adds some distmaker options to speed up frequent rebuilds. Work towards
  migrating the Joomla installer to use the setup api.

- **OAUTH2 google doesn't seem to give you refresh tokens easily
 ([dev/core#2184](https://lab.civicrm.org/dev/core/-/issues/2184):
 [26531](https://github.com/civicrm/civicrm-core/pull/26531))**

- **Errors on merging contacts with websites
 ([dev/core#2549](https://lab.civicrm.org/dev/core/-/issues/2549):
 [26605](https://github.com/civicrm/civicrm-core/pull/26605))**

- **Proposal: Create stub extensions for civicrm core + all components
  (Work Towards [dev/core#3961](https://lab.civicrm.org/dev/core/-/issues/3961):
  [26208](https://github.com/civicrm/civicrm-core/pull/26208))**

  Moves component Api4 files to component extensions.

- **Replace hard-coded call to legacyCustomSearch framework with a hook
  ([dev/core#4056](https://lab.civicrm.org/dev/core/-/issues/4056):
  [26611](https://github.com/civicrm/civicrm-core/pull/26611))**

- **Finish making legacycustomsearches optional
  (Work Towards [dev/core#4112](https://lab.civicrm.org/dev/core/-/issues/4112):
  [26614](https://github.com/civicrm/civicrm-core/pull/26614) and
  [26613](https://github.com/civicrm/civicrm-core/pull/26613))**

  Refactors code to move towards making legacycustomsearches optional.

- **SearchKit/FormBuilder - handling monetary totals
  ([dev/core#4207](https://lab.civicrm.org/dev/core/-/issues/4207):
  [26498](https://github.com/civicrm/civicrm-core/pull/26498))**

- **AdminUI: Redirection after creating new profile and adding fields is
  incorrect / not user friendly
  ([dev/core#4254](https://lab.civicrm.org/dev/core/-/issues/4254):
  [26470](https://github.com/civicrm/civicrm-core/pull/26470))**

- **SearchKit + FormBuilder: In place edit using a list view
  ([dev/core#4319](https://lab.civicrm.org/dev/core/-/issues/4319):
  [26473](https://github.com/civicrm/civicrm-core/pull/26473))**

  Fix in-place edit in SearchKit list and grid displays.

- **GroupTest occasionally failing due to new test
  ([dev/core#4327](https://lab.civicrm.org/dev/core/-/issues/4327):
  [26478](https://github.com/civicrm/civicrm-core/pull/26478))**

- **Prevent people from sneakily adding fields to your extension's reserved
  custom groups by using the Move action
  ([dev/core#4338](https://lab.civicrm.org/dev/core/-/issues/4338):
  [26518](https://github.com/civicrm/civicrm-core/pull/26518))**

- **SearchKit: two displays on dashboard using similar search incorrectly share
  Total value -- variable leakage?
  ([dev/core#4348](https://lab.civicrm.org/dev/core/-/issues/4348):
  [26480](https://github.com/civicrm/civicrm-core/pull/26480))**

- **New Activity with custom radio field gives fatal error
  ([dev/core#4355](https://lab.civicrm.org/dev/core/-/issues/4355):
  [26517](https://github.com/civicrm/civicrm-core/pull/26517))**

- **Verbiage changes on Find Groups screen
  ([dev/core#4358](https://lab.civicrm.org/dev/core/-/issues/4358):
  [26525](https://github.com/civicrm/civicrm-core/pull/26525))**

- **Afforms fields are doubled
  ([dev/core#4359](https://lab.civicrm.org/dev/core/-/issues/4359):
  [26528](https://github.com/civicrm/civicrm-core/pull/26528))**

- **AdminUI: Advanced Search not accessible and Redirect after Search Actions
  from Contacts in Group broken
  ([dev/core#4360](https://lab.civicrm.org/dev/core/-/issues/4360) and
  [dev/core#4384](https://lab.civicrm.org/dev/core/-/issues/4384):
  [26669](https://github.com/civicrm/civicrm-core/pull/26669))**

- **Trigger-based logging schema reconciliation fails when a column is renamed
  to a different upper/lower case
  ([dev/core#4369](https://lab.civicrm.org/dev/core/-/issues/4369):
  [26548](https://github.com/civicrm/civicrm-core/pull/26548))**

- **One of parameters (value: ) is not of the type CommaSeparatedIntegers for
  lesser-permissioned users
  ([dev/core#4383](https://lab.civicrm.org/dev/core/-/issues/4383):
  [26577](https://github.com/civicrm/civicrm-core/pull/26577))**

  Fixes a crash for lesser permissioned users.

- **parent_id constraint on civicrm_activity can lead to data loss
  ([dev/core#4451](https://lab.civicrm.org/dev/core/-/issues/4451):
  [26939](https://github.com/civicrm/civicrm-core/pull/26939))**

  This resolves a longstanding issue when follow-up activities were deleted when
  the parent activity was deleted.

- **SearchKit: Arithmetic field transformation broken
  ([dev/core#4455](https://lab.civicrm.org/dev/core/-/issues/4455):
  [26944](https://github.com/civicrm/civicrm-core/pull/26944))**

- **PHP 8 Compatibility Issue - strlen of array
  ([dev/core#4387](https://lab.civicrm.org/dev/core/-/issues/4387):
  [26598](https://github.com/civicrm/civicrm-core/pull/26598))**

- **Can't import using contact id
  (Work Towards
  [dev/core#4389](https://lab.civicrm.org/dev/core/-/issues/4389):
  [26607](https://github.com/civicrm/civicrm-core/pull/26607))**

  Improves import help text.

- **Installing a core extension results in an error
  ([dev/core#4391](https://lab.civicrm.org/dev/core/-/issues/4391):
  [26743](https://github.com/civicrm/civicrm-core/pull/26743))**

- **AdminUI: Allow searching by "LastName, FirstName" in Find Contacts
  ([dev/core#4396](https://lab.civicrm.org/dev/core/-/issues/4396):
  [26682](https://github.com/civicrm/civicrm-core/pull/26682))**

- **Translation for site default language not loaded
  ([dev/core#4409](https://lab.civicrm.org/dev/core/-/issues/4409):
  [26232](https://github.com/civicrm/civicrm-core/pull/26232) and
  [26785](https://github.com/civicrm/civicrm-core/pull/26785))**

- **Disabling and re-enabling a core extension removes it from the navigation
  menu and from SK
  ([dev/core#4413](https://lab.civicrm.org/dev/core/-/issues/4413):
  [26744](https://github.com/civicrm/civicrm-core/pull/26744))**

- **Membership tab on contribution page config broken
  ([dev/core#4419](https://lab.civicrm.org/dev/core/-/issues/4419):
  [26757](https://github.com/civicrm/civicrm-core/pull/26757))**

  Crash on membership tab of contribution page config.

- **Admin UI - be like regular civi and don't show reserved custom groups
  ([26668](https://github.com/civicrm/civicrm-core/pull/26668))**

- **AdminUI - Alter core forms to redirect to the new AdminUI afform pages
  ([26479](https://github.com/civicrm/civicrm-core/pull/26479))**

- **SearchKit - Fix check for smarty syntax in rewrite output
  ([26730](https://github.com/civicrm/civicrm-core/pull/26730))**

- **SearchKit - Tidy up admin buttons and table header sort icons
  ([26483](https://github.com/civicrm/civicrm-core/pull/26483))**

- **Update Api.php to correct external_identifier to type STRING
  ([26726](https://github.com/civicrm/civicrm-core/pull/26726) and
  [26728](https://github.com/civicrm/civicrm-core/pull/26728))**

- **APIv4 - Fix passing '0' as a function argument
  ([26553](https://github.com/civicrm/civicrm-core/pull/26553))**

- **Make implicit TRUE permissions check explicit in API 4 Explorer for PHP
  ([26514](https://github.com/civicrm/civicrm-core/pull/26514))**

- **Standalone - Fix some path calculations
  ([26649](https://github.com/civicrm/civicrm-core/pull/26649))**

- **Standalone - Auto-enable user subsystem. Tweak default user.
  ([26643](https://github.com/civicrm/civicrm-core/pull/26643))**

- **Standalone - Track logged-in user object
  ([26672](https://github.com/civicrm/civicrm-core/pull/26672))**

- **Standalone - Generate proper HTTP response code for permission-errors
  ([26657](https://github.com/civicrm/civicrm-core/pull/26657))**

- **Standalone - Suppress debug output
  ([26656](https://github.com/civicrm/civicrm-core/pull/26656))**

- **Remove obsolete 'Basic ACLs'
  ([26612](https://github.com/civicrm/civicrm-core/pull/26612))**

  Removes unused code for an old permissioning system that no longer
  exists.

- **Fix ACLs to use the correct name of the civicrm_group table
  ([26615](https://github.com/civicrm/civicrm-core/pull/26615))**

- **Contribution WorkflowTrait updates to support event template changes
  ([26633](https://github.com/civicrm/civicrm-core/pull/26633))**

- **Allows multiple Free Text fields to be added to form layout
  ([25271](https://github.com/civicrm/civicrm-core/pull/25271))**

- **Converting CryptoException into status messages
  ([dev/core#4308](https://lab.civicrm.org/dev/core/-/issues/4308):
  [26444](https://github.com/civicrm/civicrm-core/pull/26444))**

  Fixes a white screen of death if you change the CIVICRM_CRED_KEYS variable
  (or clone the site) and go to `/civicrm/admin/setting/smtp?reset=1`.

- **Remove 'Payment Amount (most recent)' column from membership report
  ([26566](https://github.com/civicrm/civicrm-core/pull/26566))**

- **Add additional message to invoice template if present
  ([26534](https://github.com/civicrm/civicrm-core/pull/26534))**

- **Expire notifications for Shared Address Contact Delete & Financial Types
  ([26503](https://github.com/civicrm/civicrm-core/pull/26503))**

- **Don't add Contact to Domain Group on edit
  ([26520](https://github.com/civicrm/civicrm-core/pull/26520))**

- **Don't check for PHP 5 on Mapping Settings
  ([26693](https://github.com/civicrm/civicrm-core/pull/26693))**

- **Ensure counties are properly imported even if ambiguous
  ([25989](https://github.com/civicrm/civicrm-core/pull/25989))**

- **Show manually added Smart Groups on Contact edit
  ([26521](https://github.com/civicrm/civicrm-core/pull/26521))**

- **Fix some missing places where prioritisation is not incorporated
  ([26610](https://github.com/civicrm/civicrm-core/pull/26610))**

- **Group BAO - Remove secret param that was breaking groupNesting
  ([26623](https://github.com/civicrm/civicrm-core/pull/26623))**

- **wrong hook params
  ([26500](https://github.com/civicrm/civicrm-core/pull/26500))**

- **clearTempTables: fix condition for user_job check
  ([26696](https://github.com/civicrm/civicrm-core/pull/26696))**

- **Report on the most recent membership contribution, not the oldest
  ([26111](https://github.com/civicrm/civicrm-core/pull/26111))**

- **Don't show SQL text in SK if user does not have view debug permission
  ([26711](https://github.com/civicrm/civicrm-core/pull/26711))**

- **Fix group count for delete confirmation
  ([26625](https://github.com/civicrm/civicrm-core/pull/26625))**

- **Fix actions on Relationship search using Searchkit
  ([26642](https://github.com/civicrm/civicrm-core/pull/26642))**

- **Fix debug permissions for API 4 Explorer debug
  ([26702](https://github.com/civicrm/civicrm-core/pull/26702))**

- **[PHP8] Codegen - Don't generate invalid secondary emails
  ([26680](https://github.com/civicrm/civicrm-core/pull/26680))**

- **Don't show filtered from NaN on Groups when 0 groups found
  ([26629](https://github.com/civicrm/civicrm-core/pull/26629))**

- **SchemaHandler - Fix nonstandard index capitalization + code cleanup
  ([26282](https://github.com/civicrm/civicrm-core/pull/26282))**

- **[PHP8] Fix warnings on activity and event management forms
  ([26432](https://github.com/civicrm/civicrm-core/pull/26432))**

- **APIv4 Explorer - Fix regression in php generation
  ([26622](https://github.com/civicrm/civicrm-core/pull/26622))**

- **Do not generate unshared variable in shared `processMessageTemplate`
  ([26567](https://github.com/civicrm/civicrm-core/pull/26567))**

- **Add deprecation notice to legacy exception class aliases
  ([26542](https://github.com/civicrm/civicrm-core/pull/26542))**

- **Fix for domains that have the string .css in them
  ([26530](https://github.com/civicrm/civicrm-core/pull/26530))**

- **Smarty - When temporarily setting variable, fix cleanup for
  previously-undefined values.
  ([26465](https://github.com/civicrm/civicrm-core/pull/26465))**

- **Lower-case field name uf_group.post_URL, cancel_URL
  ([26460](https://github.com/civicrm/civicrm-core/pull/26460))**

- **crmAutocomplete - Fix endless loop (again)
  ([26681](https://github.com/civicrm/civicrm-core/pull/26681))**

- **Fix ommitted port when constructing redirect URL
  ([26685](https://github.com/civicrm/civicrm-core/pull/26685))**

- **SearchKit - Fix saving created/modified fields
  ([26484](https://github.com/civicrm/civicrm-core/pull/26484))**

- **Add deprecation warning and fix deprecated constructor call (followup to
  #26398) ([26495](https://github.com/civicrm/civicrm-core/pull/26495))**

- **Remove unneeded and strange profile field save success alert
  ([26751](https://github.com/civicrm/civicrm-core/pull/26751))**

- **Attempt to fix some form notices on Contact Edit form new contact
  ([26481](https://github.com/civicrm/civicrm-core/pull/26481))**

- **Fix PHP errors on profiles and custom fields when using options per line
  ([26763](https://github.com/civicrm/civicrm-core/pull/26763))**

- **Fix another place weight is not passed
  ([26736](https://github.com/civicrm/civicrm-core/pull/26736))**

- **Fix Translation to load related language more reliably
  ([26190](https://github.com/civicrm/civicrm-core/pull/26190))**

- **Fix apiv4 bug on custom fields with spaces in name
  ([26740](https://github.com/civicrm/civicrm-core/pull/26740))**

- **Prevent API errors when CiviEvent is disabled
  ([26497](https://github.com/civicrm/civicrm-core/pull/26497))**

- **Prevent erroneous GroupContact hooks for Contact already in group
  ([26523](https://github.com/civicrm/civicrm-core/pull/26523))**

- **Stop passing around object, just to get the id in Anet.ipn
  ([26562](https://github.com/civicrm/civicrm-core/pull/26562))**

- **Misc ts fixes
  ([26565](https://github.com/civicrm/civicrm-core/pull/26565))**

- **Remove unused line item variable from signature
  ([26571](https://github.com/civicrm/civicrm-core/pull/26571))**

- **CiviImport - String fix
  ([26593](https://github.com/civicrm/civicrm-core/pull/26593))**

- **CiviImport - Fix table description
  ([26590](https://github.com/civicrm/civicrm-core/pull/26590))**

- **Move sending of email to recur function
  ([26587](https://github.com/civicrm/civicrm-core/pull/26587))**

- **CiviCRM 5.62.1 - CiviCRM core extension: Greenwich, Bootstrap CSS tries to
  load glyphicons fonts from the incorrect paths returns 404 and icons do not
  display ([dev/core#4414](https://lab.civicrm.org/dev/core/-/issues/4414):
  [26831](https://github.com/civicrm/civicrm-core/pull/26831))**  

  This fixes an issue where the Greenwich Bootstrap files include an invalid
  reference to their font data.

- **Breakage with 5.63 moving code to extensions
  ([dev/core#4424](https://lab.civicrm.org/dev/core/-/issues/4424):
  [26891](https://github.com/civicrm/civicrm-core/pull/26891) and
  [26948](https://github.com/civicrm/civicrm-core/pull/26948))**

  When reconciling managed entities, errors are now logged instead of throwing
  exceptions unless debug mode is enabled.  Neither exceptions nor error logging
  happens during install or upgrade.

### CiviCase

- **crmCaseType: fix New Case Type link visibility in obscure circumstances
  ([26749](https://github.com/civicrm/civicrm-core/pull/26749))**

- **Deleted activities filter no longer working on manage case
  ([dev/core#4427](https://lab.civicrm.org/dev/core/-/issues/4427):
  [26790](https://github.com/civicrm/civicrm-core/pull/26790)))**

### CiviContribute

- **Accepted credit cards not saved when creating or editing a payment processor
  ([dev/core#4418](https://lab.civicrm.org/dev/core/-/issues/4418):
  [26760](https://github.com/civicrm/civicrm-core/pull/26760),
  [26755](https://github.com/civicrm/civicrm-core/pull/26755) and
  [26758](https://github.com/civicrm/civicrm-core/pull/26758))**

- **Error on saving amounts on edit Contribution Page
  ([dev/core#4453](https://lab.civicrm.org/dev/core/-/issues/4453):
  [26953](https://github.com/civicrm/civicrm-core/pull/26953))**

  This resolves a hard error in PHP 8.1+ if you try to save a Contribution Page
  - Amounts tab with a fixed contribution option (not a price set).

- **Call repeatTransation not completeOrder from repeatTransaction API
  ([26557](https://github.com/civicrm/civicrm-core/pull/26557))**

- **Update Recurring end_date when setting status to completed
  ([26616](https://github.com/civicrm/civicrm-core/pull/26616))**

- **Switch to Payment.create & repeattransaction in Authorize.net
  ([26620](https://github.com/civicrm/civicrm-core/pull/26620) and
  [26659](https://github.com/civicrm/civicrm-core/pull/26659))**

- **Don't show pay_later processor on additional live Payment
  ([26578](https://github.com/civicrm/civicrm-core/pull/26578))**

- **PriceSet select options cause javascript errors
  ([dev/core#4439](https://lab.civicrm.org/dev/core/-/issues/4439):
  [26882](https://github.com/civicrm/civicrm-core/pull/26882))**

- **Cleanup Email Invoice form to remove longest ever field label
  ([26533](https://github.com/civicrm/civicrm-core/pull/26533))**

- **Switch to token for tax_exclusive_amount in offline receipt
  ([26602](https://github.com/civicrm/civicrm-core/pull/26602))**

- **Fix e-notices in contribution_offline_receipt text by removing always-empty
  field ([26599](https://github.com/civicrm/civicrm-core/pull/26599))**

- **Update related contribution trxn_id before sending email
  ([26737](https://github.com/civicrm/civicrm-core/pull/26737))**

- **Reduce PHP warnings on Contribution
  ([26506](https://github.com/civicrm/civicrm-core/pull/26506))**

- **Reduce PHP warnings with paymentBlock
  ([26505](https://github.com/civicrm/civicrm-core/pull/26505))**

- **Fix two more broken checkboxes - PCP pages
  ([26796](https://github.com/civicrm/civicrm-core/pull/26796))**

- **Add start date back to recurring contributions display on contact
  ([26811](https://github.com/civicrm/civicrm-core/pull/26811))**

### CiviEvent

- **Payment on Event Confirmation Page: Does not work when pay later is disabled
  ([dev/core#4336](https://lab.civicrm.org/dev/core/-/issues/4336):
  [26491](https://github.com/civicrm/civicrm-core/pull/26491))**

- **Fix missing </table> tag on repeat event change confirm tpl.
  ([26547](https://github.com/civicrm/civicrm-core/pull/26547))**

- **Fix e-notices on New Participant form, strict smarty
  ([26487](https://github.com/civicrm/civicrm-core/pull/26487))**

- **Fix PHP warnings on front end Register
  ([26476](https://github.com/civicrm/civicrm-core/pull/26476))**

- **replace deprecated functions in event fee form
  ([26691](https://github.com/civicrm/civicrm-core/pull/26691))**

### CiviGrant

- **CiviGrant - Support APIv4 autocompletes
  ([26687](https://github.com/civicrm/civicrm-core/pull/26687))**

### CiviMail

- **Rebuild smart group cache for specific smart groups included in mailing at
  scheduling time
  ([dev/core#3890](https://lab.civicrm.org/dev/core/-/issues/3890):
  [24681](https://github.com/civicrm/civicrm-core/pull/24681))**

- **Update online event workflow template for more consistent participant amount
  data and preview-ability
  ([26574](https://github.com/civicrm/civicrm-core/pull/26574) and
  [26893](https://github.com/civicrm/civicrm-core/pull/26893))**

- **CRM_Mailing_Form_Optout, CRM_Mailing_Form_Unsubscribe: change properties to
  protected from private
  ([26713](https://github.com/civicrm/civicrm-core/pull/26713))**

- **Typo correct for MailingEventReply.php
  ([26692](https://github.com/civicrm/civicrm-core/pull/26692))**

### CiviMember

- **Fatal error when changing membership type, on membership with 0
  contributions
  ([dev/core#4048](https://lab.civicrm.org/dev/core/-/issues/4048):
  [26554](https://github.com/civicrm/civicrm-core/pull/26554))**

- **Once you create a Membership price set, with membership options (ie Select)
  you cannot then add a new Option as the Membership fields are not displaying
  ([dev/core#4429](https://lab.civicrm.org/dev/core/-/issues/4429):
  [26902](https://github.com/civicrm/civicrm-core/pull/26902))**

  This fixes the check to see if a price option is able to be used by CiviMember
  or CiviEvent.

- **Split MembershipBlock.tpl into 2
  ([26690](https://github.com/civicrm/civicrm-core/pull/26690))**

- **Fix don't change membership status when saving a pending membership
  ([25385](https://github.com/civicrm/civicrm-core/pull/25385))**

- **Fix lifetime membership with end date error message
  ([26558](https://github.com/civicrm/civicrm-core/pull/26558))**

- **Fix recent breakage on membershipBlock.tpl
  ([26777](https://github.com/civicrm/civicrm-core/pull/26777))**

### Joomla Integration

- **Undefined variable $store in Joomla.php on line 56 -
  CRM_Core_Permission_Joomla error
  ([dev/joomla#51](https://lab.civicrm.org/dev/joomla/-/issues/51):
  [26699](https://github.com/civicrm/civicrm-core/pull/26699))**

### WordPress Integration

- **Fix UTC offsets when retrieving timezone string in WordPress
  ([298](https://github.com/civicrm/civicrm-wordpress/pull/298) and
  [26604](https://github.com/civicrm/civicrm-core/pull/26604))**

## <a name="misc"></a>Miscellany

- **Move recurring handling to recur function in PaypalIPN  
  ([26560](https://github.com/civicrm/civicrm-core/pull/26560))**

- **CiviMail - Sundry cleanups
  ([26626](https://github.com/civicrm/civicrm-core/pull/26626))**

- **UFGroup DAO is out of date
  ([26494](https://github.com/civicrm/civicrm-core/pull/26494))**

- **Remove unused functions from `AuthorizeNetIPN`
  ([26597](https://github.com/civicrm/civicrm-core/pull/26597))**

- **Simplify use of contribution - we are only looking at status
  ([26589](https://github.com/civicrm/civicrm-core/pull/26589))**

- **Extract getContributionRecur, clean up input input...
  ([26586](https://github.com/civicrm/civicrm-core/pull/26586))**

- **Drop unused table civicrm_action_mapping
  ([26646](https://github.com/civicrm/civicrm-core/pull/26646))**

- **Remove copy-and-paste comment
  ([26652](https://github.com/civicrm/civicrm-core/pull/26652))**

- **Why?
  ([26588](https://github.com/civicrm/civicrm-core/pull/26588))**

- **Remove ids Variable that is dumb
  ([26582](https://github.com/civicrm/civicrm-core/pull/26582))**

- **Fix a couple more places to use the new event trait
  ([26486](https://github.com/civicrm/civicrm-core/pull/26486))**

- **Move code to complete `repeatTransation` into that function
  ([26555](https://github.com/civicrm/civicrm-core/pull/26555))**

- **APIv4 - Deprecate unused event
  ([26537](https://github.com/civicrm/civicrm-core/pull/26537))**

- **SearchKit - Reuse helpers from CRM_Core_Action
  ([26663](https://github.com/civicrm/civicrm-core/pull/26663))**

- **Delete unused tpl file
  ([26671](https://github.com/civicrm/civicrm-core/pull/26671))**

- **Add self to contributors
  ([26584](https://github.com/civicrm/civicrm-core/pull/26584))**

- **Duplicate the few lines of shared code between `completeOrder` into
  `repeatTransaction`
  ([26556](https://github.com/civicrm/civicrm-core/pull/26556))**

- **FlexMailer\Listener\OpenTracker: remove deprecated isLegacy check
  ([26526](https://github.com/civicrm/civicrm-core/pull/26526))**

- **Remove unused variables, fix a couple of ==
  ([26734](https://github.com/civicrm/civicrm-core/pull/26734))**

- **Remove unreachable code in event registration templates for tax total
  ([26492](https://github.com/civicrm/civicrm-core/pull/26492) and
  [26512](https://github.com/civicrm/civicrm-core/pull/26512))**

- **Remove stray semi-colon
  ([26490](https://github.com/civicrm/civicrm-core/pull/26490))**

- **Remove obsolete comment
  ([26489](https://github.com/civicrm/civicrm-core/pull/26489))**

- **Remove redundant variable declared in the parent class
  ([26482](https://github.com/civicrm/civicrm-core/pull/26482))**

- **CiviEventDispatcher::dispatch() - add deprecation warning for deprecated
  event class ([26338](https://github.com/civicrm/civicrm-core/pull/26338))**

- **REF - Auto-generate links for CRM_Core_Page_Basic
  ([26644](https://github.com/civicrm/civicrm-core/pull/26644))**

- **[REF] Don't add Contacts to Groups they are already Added to on Edit
  ([26519](https://github.com/civicrm/civicrm-core/pull/26519))**

- **[REF][PHP8.1] Don't pass null to strtoupper in getDynamicCharacters
  ([26508](https://github.com/civicrm/civicrm-core/pull/26508))**

- **[REF] Use writeRecord in the revert function of MessageTemplate to ensure
  that pre and post hooks are called
  ([26754](https://github.com/civicrm/civicrm-core/pull/26754))**

- **REF - Replace CRM_Utils_Array::value with ??
  ([26731](https://github.com/civicrm/civicrm-core/pull/26731))**

- **[REF] Autoformat php short array syntax
  ([26724](https://github.com/civicrm/civicrm-core/pull/26724))**

- **[REF] Remove unnecessary CRM_Utils_Array::value and use short array syntax
  ([26723](https://github.com/civicrm/civicrm-core/pull/26723))**

- **[REF] Code cleanup; remove unused vars and remove CRM_Utils_Array::value
  ([26714](https://github.com/civicrm/civicrm-core/pull/26714))**

- **(REF) Simplify some more installation data
  ([26675](https://github.com/civicrm/civicrm-core/pull/26675))**

- **[REF] Switch a bunch of core pages to use auto-links
  ([26658](https://github.com/civicrm/civicrm-core/pull/26658))**

- **REF - Code cleanup and notice fixes in scheduled reminders
  ([26647](https://github.com/civicrm/civicrm-core/pull/26647))**

- **(REF) Convert dynamic translations from `ts()` to `_ts()`
  ([26595](https://github.com/civicrm/civicrm-core/pull/26595))**

- **[REF] CiviCase - Move more activity logic into case BAO via hook
  ([26591](https://github.com/civicrm/civicrm-core/pull/26591))**

- **[REF][PHP8.2] IDS fixes for dynamic property deprecation
  ([363](https://github.com/civicrm/civicrm-packages/pull/363))**

- **[NFC] Update test that's no longer doing what it was doing
  ([26725](https://github.com/civicrm/civicrm-core/pull/26725))**

- **NFC: standardise ufId to ufID to avoid confusion
  ([26679](https://github.com/civicrm/civicrm-core/pull/26679))**

- **[NFC] Change PHPDoc return type (findById)
  ([26504](https://github.com/civicrm/civicrm-core/pull/26504))**

- **NFC: Add debug level log message when afform submissions catch exceptions
  ([26741](https://github.com/civicrm/civicrm-core/pull/26741))**

- **Use EventTest helpers (a few more places)
  ([26477](https://github.com/civicrm/civicrm-core/pull/26477))**

- **Remove now unsed createEvent test function from test baseClass
  ([26717](https://github.com/civicrm/civicrm-core/pull/26717))**

- **Remove some unused test functions
  ([26720](https://github.com/civicrm/civicrm-core/pull/26720))**

- **Fix ChangeFeeSelectionTest to use eventCreatePaid
  ([26709](https://github.com/civicrm/civicrm-core/pull/26709))**

- **Install SK as part of headless test baseline
  ([26712](https://github.com/civicrm/civicrm-core/pull/26712))**

- **Fix participantTest class to call createEventPaid
  ([26540](https://github.com/civicrm/civicrm-core/pull/26540))**

- **[Test] Clean up payment processors when cleaning up other related entities
  ([26640](https://github.com/civicrm/civicrm-core/pull/26640))**

- **Use eventCreateUnpaid in participantCreate
  ([26708](https://github.com/civicrm/civicrm-core/pull/26708))**

- **Fix test to not use brittle xml, remove redundant crud tests
  ([26648](https://github.com/civicrm/civicrm-core/pull/26648))**

- **Update UFJoin test to not use brittle xml set up
  ([26645](https://github.com/civicrm/civicrm-core/pull/26645))**

- **Fix some test cleanup routines
  ([26634](https://github.com/civicrm/civicrm-core/pull/26634))**

- **Fix ACLPermissionTrait to use EventTest create function
  ([26707](https://github.com/civicrm/civicrm-core/pull/26707))**

- **Fix test to use created workflow
  ([26655](https://github.com/civicrm/civicrm-core/pull/26655))**

- **Remove duplicate test
  ([26568](https://github.com/civicrm/civicrm-core/pull/26568))**

- **Superficial clean up in test class
  ([26559](https://github.com/civicrm/civicrm-core/pull/26559))**

- **Very minor test cleanup
  ([26635](https://github.com/civicrm/civicrm-core/pull/26635))**

- **Test cleanup in BAO_ParticipantTest
  ([26704](https://github.com/civicrm/civicrm-core/pull/26704))**

- **[Tests] Fix a few more places to use eventTrait & remove `legacyEventCreate`
  ([26701](https://github.com/civicrm/civicrm-core/pull/26701))**

- **Cleanup AdditionalPaymentTest to use event trait
  ([26570](https://github.com/civicrm/civicrm-core/pull/26570))**

- **Fix Invoice test to user EventTestTrait, require less in order API
  ([26543](https://github.com/civicrm/civicrm-core/pull/26543))**

- **[TEST] APIv4 - Include CiviGrant in conformance tests
  ([26511](https://github.com/civicrm/civicrm-core/pull/26511))**

- **Include `entityTrait` in `ContactTestTrait`
  ([26715](https://github.com/civicrm/civicrm-core/pull/26715))**

- **Cleanup Apiv3-UfField test
  ([26638](https://github.com/civicrm/civicrm-core/pull/26638))**

- **Php8-proof SMSCommonTest
  ([26545](https://github.com/civicrm/civicrm-core/pull/26545))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andie Hunt; Agileware - Justin Freeman; Artful Robot - Rich
Lott; Blackfly Solutions - Alan Dixon; BrightMinded Ltd - Bradley Taylor;
Business & Code - Alain Benbassat; Christian Wach; Circle Interactive - Pradeep
Nayak; CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku; Coop
SymbioTIC - Mathieu Lutfy, Samuel Vanhove; Dave D; Fuzion - Jitendra Purohit,
Mike Beck; iXiam - Vangelis Pantazis; JMA Consulting - Seamus Lee; Megaphone
Technology Consulting - Jon Goldberg; MJW Consulting - Matthew Wire;
Progressive Technology Project - Jamie McClelland; Reflexive Communications -
Sandor Semsey; Squiffle Consulting - Aidan Saunders; Tadpole Collective - Kevin
Cristiano; The University of the West Indies - Howard Shand; Wikimedia
Foundation - Eileen McNaughton; Wildsight - Lars Sander-Green

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

ALL IN APPLI admin; Fuzion - Luke Stewart; JMA Consulting - Monish Deb; Oxfam
Germany - Thomas Schüttler; Tobias Voigt; ziljah

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
