<?php
return CRM_Core_CodeGen_BounceType::create('Invalid')
  ->addMetadata([
    'description' => ts('Email address is not valid'),
    'hold_threshold' => 1,
  ])
  ->addValueTable(['pattern'], [
    ['(user|recipient( name)?) is not recognized'],
    ['554 delivery error'],
    ['address does not exist'],
    ['address(es)?( you (entered|specified))? (could|was)( not|n.t)( be)? found'],
    ['address(ee)? (unknown|invalid)'],
    ['bad destination'],
    ['badly formatted address'],
    ['can\'t open mailbox for'],
    ['cannot deliver'],
    ['delivery to the following recipient(s)? failed'],
    ['destination addresses were unknown'],
    ['did not reach the following recipient'],
    ['does not exist'],
    ['does not like recipient'],
    ['does not specify a valid notes mail file'],
    ['illegal alias'],
    ['invalid (mailbox|(e-?mail )?address|recipient|final delivery)'],
    ['invalid( or unknown)?( virtual)? user'],
    ['(mail )?delivery (to this user )?is not allowed'],
    ['mailbox (not found|unavailable|name not allowed)'],
    ['message could not be forwarded'],
    ['missing or malformed local(-| )part'],
    ['no e-?mail address registered'],
    ['no such (mail drop|mailbox( \\w+)?|(e-?mail )?address|recipient|(local )?user|person)( here)?'],
    ['no mailbox (here )?by that name'],
    ['not (listed in|found in directory|known at this site|our customer)'],
    ['not a valid( (user|mailbox))?'],
    ['not present in directory entry'],
    ['recipient (does not exist|(is )?unknown|rejected|denied|not found)'],
    ['this user doesn\'t have a yahoo.com address'],
    ['unavailable to take delivery of the message'],
    ['unavailable mailbox'],
    ['unknown (local( |-)part|recipient|address error)'],
    ['unknown( or illegal)? user( account)?'],
    ['unrecognized recipient'],
    ['unregistered address'],
    ['user (unknown|(does not|doesn\'t) exist)'],

    // FIXME: In the old SQL, the "\" in "\w" didn't get through. We're probably loading the wrong data.
    // ['user doesn\'t have an? \w+ account'],
    ['user doesn\'t have an? w+ account'],

    ['user(\'s e-?mail name is)? not found'],
    ['^Validation failed for:'],
    ['5.1.0 Address rejected'],
    ['no valid recipients?'],
    ['RecipNotFound'],
    ['no one at this address'],
    ['misconfigured forwarding address'],
    ['account is not allowed'],
    ['Address .<[^>]*>. not known here'],
    ['Recipient address rejected: ([a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,}'],
    ['Non sono riuscito a trovare l.indirizzo e-mail'],
    ['nadie con esta direcci..?n'],
    ['ni bilo mogo..?e najti prejemnikovega e-po..?tnega naslova'],
    ['Elektronski naslov (je ukinjen|ne obstaja)'],
    ['nepravilno nastavljen predal'],
  ]);
